Attribute VB_Name = "ModuloResize"
Option Explicit

'******************* ISTRUZIONI PER L'USO *************************************************
'QUESTO MODULO PERMETTE DI ADATTARE E RIDIMENSIONARE I CONTROLLI PRESENTI SU UN DATO FORM _
 A SECONDA DELLE DIMENSIONI DELLO STESSO FORM. _
 I VINCOLI SONO: _
      DICHIARARE PER IN OGNI FORM CHE SI VUOLE RIDIMENSIONARE DUE VARIABILI COME SEGUE _
                     Public WForm As Long _
                     Public HForm As Long _
      E INIZIALIZZARLE NEL LOAD DEL FORM STESSO COME SEGUE _
                     WForm = Me.Width _
                     HForm = Me.Height _
      PER PERMETTERE ALLA PROCEDURA DI RICONOSCERE I CONTROLLI DA SPOSTARE O RIDIMENSIONARE _
      E' NECESSARIO USARE LA SIMBOLOGGIA CORRETTA NELLA PROPRIETA' "TAG" DEI CONTROLLI: _
                     < = ANCORATO AL MARGINE SX _
                     ^ = ANCORATO AL MARGINE SUPERIORE _
                     > = ANCORATO AL MARGINE DX _
                     v = ANCORATO AL MARGINE INFERIORE (LETTERA "V" MINUSCOLA)
'******************************************************************************************

      

Public Sub ResizeForm(frmForm As Form, MinHeight As Long, MinWidth As Long)
   Dim i As Byte
   Dim Ctrl As Object
   Dim Val1 As Long
   Dim Val2 As Long
   Dim Val3 As Long
   Dim Val4 As Long
   
   'QUI CONTROLLO IL MINIMO IN ALTEZZA E LARGHEZZA DEL FORM *******************
   If frmForm.WindowState = vbMinimized Then Exit Sub
   If frmForm.Width < MinWidth Then frmForm.Width = MinWidth
   If frmForm.Height < MinHeight Then frmForm.Height = MinHeight
   'If frmForm.Width < MinWidth Then Exit Sub
   'If frmForm.Height < MinHeight Then Exit Sub
   'FINE QUI CONTROLLO IL MINIMO IN ALTEZZA E LARGHEZZA DEL FORM **************
  
   'If WForm = 0 Then WForm = frmForm.Width
   'If HForm = 0 Then HForm = frmForm.Height

   DoEvents
   
   'CICLO SUI CONTROLLI DEL FORM *******************************************************************
   For Each Ctrl In frmForm.Controls

      'DA QUI CONTROLLO I SIMBOLI *******************************************
      If InStr(1, Ctrl.Tag, "<") Then  'LEFT *******************
         Val1 = 1
      Else
         Val1 = -1
      End If
      
      If InStr(1, Ctrl.Tag, "^") Then  'TOP ********************
         Val2 = 1
      Else
         Val2 = -1
      End If
   
      If InStr(1, Ctrl.Tag, ">") Then  'RIGHT ******************
         Val3 = 1
      Else
         Val3 = -1
      End If
      
      If InStr(1, Ctrl.Tag, "v") Then  'BOTTOM ******************
         Val4 = 1
      Else
         Val4 = -1
      End If
      'FIN QUI CONTROLLO I SIMBOLI ******************************************
      
      
      
      'GESTIONE IN ORIZZONTALE **********************************************
      If Val1 = -1 And Val3 = 1 Then
         Ctrl.Left = Ctrl.Left + (frmForm.Width - frmForm.WForm)
      ElseIf Val1 = 1 And Val3 = 1 Then
         Ctrl.Width = Ctrl.Width + (frmForm.Width - frmForm.WForm)
      End If
      'FINE GESTIONE IN ORIZZONTALE *****************************************
      
      'GESTIONE IN VERTICALE ************************************************
      If Val2 = -1 And Val4 = 1 Then
         Ctrl.Top = Ctrl.Top + (frmForm.Height - frmForm.HForm)
      ElseIf Val2 = 1 And Val4 = 1 Then
         Ctrl.Height = Ctrl.Height + (frmForm.Height - frmForm.HForm)
      End If
      'FINE GESTIONE IN VERTICALE *******************************************

   Next
   'FINE CICLO SUI CONTROLLI DEL FORM *******************************************************************
   
   
   'AGGIORNO LE VARIABILI GLOBALI DEL FORM
   frmForm.WForm = frmForm.Width
   frmForm.HForm = frmForm.Height
End Sub


Public Function CalcolaWidhtColonna(vCtrl As Object, Percentuale As Byte) As Long
   CalcolaWidhtColonna = (vCtrl.Width * Percentuale) / 100
End Function

