Attribute VB_Name = "ModuloDecodCampi"
Option Explicit

'la funzione mi restituisce l'esistenza (TRUE) del campo CHIAVE+CAMPORICERCA della tavella TABGEN _
 NOTE: _
 CampoRicerca = Puo' essere sia TGCodice che TGDescr

Public Function DECOD_VALORE_CAMPO(TABELLA As String, CampoRicerca As String, ValoreRicerca As String, CampoDaRes As String, _
                                   Optional Diverso As Boolean, _
                                   Optional RestNull As Boolean, _
                                   Optional CampoRicercaNumerico As Boolean, _
                                   Optional CampCodice As String, _
                                   Optional TextCodice As Variant) As String
'Questa funzione e' generica: _
 RETITUISCE IL VALORE DI UN DATO CAMPO (CampoDaRes) DI UNA DATA TABELLA _
 (Se il parametro RestNull = True, se l'esito della query  negativo la funzione restituisce null altrimenti NIENTE
   Dim RS As ADODB.Recordset
   Dim strRicerca As String
   Dim strWhere As String
      
   If Diverso = False Then
      strRicerca = "Select " & CampoDaRes & " from " & TABELLA & " where " & CampoRicerca & " = '" & ValoreRicerca & "' ORDER BY " & CampoDaRes & " desc"
   Else
      strRicerca = "Select " & CampoDaRes & " from " & TABELLA & " where " & CampoRicerca & " <> '" & ValoreRicerca & "' ORDER BY " & CampoDaRes & " desc"
   End If
   
'   If Diverso = True Then
'      If CampoRicercaNumerico Then
'         strWhere = "WHERE " & CampoRicerca & " <> " & CLng(ValoreRicerca) & ""
'      Else
'         strWhere = "WHERE " & CampoRicerca & " <> '" & VerificaApici(ValoreRicerca) & "'"
'      End If
'   Else
'      If CampoRicercaNumerico Then
'         strWhere = "WHERE " & CampoRicerca & " = " & CLng(ValoreRicerca) & ""
'      Else
'         strWhere = "WHERE " & CampoRicerca & " = '" & VerificaApici(ValoreRicerca) & "'"
'      End If
'   End If
'
'   strRicerca = "SELECT " & CampiRic & " FROM " & TABELLA & " " & strWhere
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      DECOD_VALORE_CAMPO = NonNullo(RS.Fields(CampoDaRes))
   Else
      If RestNull = True Then DECOD_VALORE_CAMPO = "null"
   End If
   RS.Close
   Set RS = Nothing
End Function

'Public Function DECOD_VALORE_CAMPO(TABELLA As String, CampoRicerca As String, ValoreRicerca As String, CampoDaRes As String, _
'                                   Optional Diverso As Boolean, _
'                                   Optional RestNull As Boolean, _
'                                   Optional CampoRicercaNumerico As Boolean, _
'                                   Optional CampCodice As String, _
'                                   Optional TextCodice As Variant, _
'                                   Optional pCodAzi As String, _
'                                   Optional pStrWhere As String, _
'                                   Optional pNoLike As Boolean) As String
''Questa funzione e' generica: _
' RETITUISCE IL VALORE DI UN DATO CAMPO (CampoDaRes) DI UNA DATA TABELLA _
' (Se il parametro RestNull = True, se l'esito della query  negativo la funzione restituisce null altrimenti NIENTE) _
' (Se il pNoLike = True significa che NON devo eseguire la ricerca con il LIKE)
'
'   Dim RS As ADODB.Recordset
'   Dim strRicerca As String
'   Dim vCodAzi As String
'   Dim strWhere As String
'   Dim Trovato As Boolean
'   Dim RicLike As Boolean
'   Dim CampiRic As String
'   Dim CampoASC As String
'
'   'If ConnessioneGenerale.state = 0 Then Exit Function
'
'   RicLike = False
'
'   If InStr(1, TABELLA, "GENERALE") = 0 Then
'      'QUESTO CODICE PUNTA ALLE TABELLE DELL'AZIENDA
'      If Len(pCodAzi) > 0 Then
'         vCodAzi = pCodAzi
'      Else
'         vCodAzi = Azienda
'      End If
'   End If
'
'
'   If Len(Trim(pStrWhere)) = 0 Then
'      If Diverso = True Then
'         If CampoRicercaNumerico = True Then
'            strWhere = "WHERE " & CampoRicerca & " <> " & CLng(ValoreRicerca) & ""
'         Else
'            strWhere = "WHERE " & CampoRicerca & " <> '" & VerificaApici(ValoreRicerca) & "'"
'         End If
'      Else
'         If CampoRicercaNumerico = True Then
'            strWhere = "WHERE " & CampoRicerca & " = " & CLng(ValoreRicerca) & ""
'         Else
'            strWhere = "WHERE " & CampoRicerca & " = '" & VerificaApici(ValoreRicerca) & "'"
'         End If
'      End If
'   Else
'
'      strWhere = pStrWhere
'
'   End If
'
'
'   'Qui imposto i campi da estrarre dalla query
'   If Len(CampCodice) > 0 Then
'      CampiRic = CampoDaRes & "," & CampCodice
'      CampoASC = CampCodice
'   Else
'      CampiRic = CampoDaRes
'      CampoASC = CampoDaRes
'   End If
'
'
'Ripeti:
'   strRicerca = "Select " & CampiRic & " FROM [" & vCodAzi & Replace(TABELLA, "GENERALE", "") & "] " & strWhere
'   Set RS = New ADODB.Recordset
'   RS.Open strRicerca, ConnessioneGenerale, adOpenStatic
'   'RS.Open strRicerca, ConnessioneGenerale, adOpenForwardOnly, adLockReadOnly
'   If Not RS.EOF Then
'      Trovato = True
'      If IsObject(TextCodice) = True Then TextCodice.Text = NonNullo(RS.Fields(CampCodice))
'      DECOD_VALORE_CAMPO = NonNullo(RS.Fields(CampoDaRes))
'   Else
'      Trovato = False
'      If RestNull = True Then DECOD_VALORE_CAMPO = "null"
'   End If
'   RS.Close
'   Set RS = Nothing
'
'
'   If Trovato = False And _
'      RicLike = False And _
'      CampoRicercaNumerico = False And _
'      Diverso = False And _
'      Len(Trim(pStrWhere)) = 0 And _
'      pNoLike = False Then
'
'      'Se entra qui significa che la query ha dato esito negativo e quindi provo con il LIKE
'      ValoreRicerca = "%" & ValoreRicerca
'      strWhere = "WHERE " & CampoRicerca & " Like '" & VerificaApici(ValoreRicerca) & "%' ORDER BY " & CampoASC & " ASC"
'      RicLike = True
'      GoTo Ripeti
'   End If
'
'End Function




Public Function VerificaTABGEN(Chiave As String, CampoRicerca As String, ValoreRicerca As String) As Boolean
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   strRicerca = "Select * from TAB_GEN where TGCHIAVE+" & CampoRicerca & " like '" & Chiave + ValoreRicerca & "%' ORDER BY " & CampoRicerca
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      VerificaTABGEN = True
   Else
      VerificaTABGEN = False
   End If
   RS.Close
   Set RS = Nothing
End Function

Public Function VerificaATTIVITA(ValoreRicerca As Variant, Numerico As Boolean, Optional Escludi As Integer) As Boolean
   Dim RS As ADODB.Recordset
   Dim strRicerca As String
   
   If Numerico = True Then
      strRicerca = "Select * from TAB_ATTIVITA where ATCODICE = " & ValoreRicerca & ""
   Else
      If Escludi = 0 Then 'Qui verifico se devo escludere un codice dalla ricerca
         strRicerca = "Select * from TAB_ATTIVITA where ATDESCRI LIKE '" & VerificaApici(ValoreRicerca) & "%'"
      Else
         strRicerca = "Select * from TAB_ATTIVITA where ATDESCRI = '" & VerificaApici(ValoreRicerca) & "' AND ATCODICE <> " & Escludi & ""
      End If
   End If
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      VerificaATTIVITA = True
   Else
      VerificaATTIVITA = False
   End If
   RS.Close
   Set RS = Nothing
End Function


Public Function VerificaCONTRA(Chiave As String, CampoRicerca As String, ValoreRicerca As Long) As Boolean
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   On Error GoTo GestErr

   strRicerca = "Select * from TAB_CONTRA where TCCHIAVE = '" & Chiave & "' AND TCCODICE = " & ValoreRicerca & ""
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      VerificaCONTRA = True
   Else
      VerificaCONTRA = False
   End If
   RS.Close
   Set RS = Nothing

GestErr:
   If Err.Number <> 0 Then
      MsgBox Err.Number & " - " & Err.Description
   End If
   On Error GoTo 0
End Function

Public Function VerificaLISTIN(CampoRicerca As String, ValoreRicerca As Long) As Boolean
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   On Error GoTo GestErr

   strRicerca = "Select * from TAB_LISTIN where TLCODICE = " & ValoreRicerca & ""
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      VerificaLISTIN = True
   Else
      VerificaLISTIN = False
   End If
   RS.Close
   Set RS = Nothing

GestErr:
   If Err.Number <> 0 Then
      MsgBox Err.Number & " - " & Err.Description
   End If
   On Error GoTo 0
End Function

Public Function VerificaPartitaIVA(Chiave As String, CodConto As String, vPartitaIva As String) As String
'Questa funzione restituisce il codice e la ragione sociale del PRIMO nominativo che eventualmente ha la stessa partita iva del nominativo che si sta salvando
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   'Controllo i nominativi del SOLO conto attinente e che abbia la stessa partiva iva ma che non sia il nomintaivo che si sta salvando o modificando!
   strRicerca = "Select * from CONTI where ANTIPCON = '" & Chiave & "' AND (ANPARIVA = '" & vPartitaIva & "' AND ANTIPCON+ANCODICE <> '" & Chiave & CodConto & "') ORDER BY ANCODICE"
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      VerificaPartitaIVA = RS!ANCODICE & " - " & RS!ANDESCRI
   Else
      VerificaPartitaIVA = "null"
   End If
   RS.Close
   Set RS = Nothing
End Function

Public Function VerificaTIPDOC(Chiave As String, CampoRicerca As String, ValoreRicerca As String) As Boolean
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   strRicerca = "Select * from TIP_DOC where TDFLVEAC+" & CampoRicerca & " like '" & Chiave + ValoreRicerca & "%' ORDER BY " & CampoRicerca
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      VerificaTIPDOC = True
   Else
      VerificaTIPDOC = False
   End If
   RS.Close
   Set RS = Nothing
End Function

Public Function VerificaARTICOLO(Chiave As String, CampoRicerca As String, ValoreRicerca As String) As Boolean
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   strRicerca = "Select * from ART_ICOL where ARTIPART+" & CampoRicerca & " like '" & Chiave + ValoreRicerca & "%' ORDER BY " & CampoRicerca
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      VerificaARTICOLO = True
   Else
      VerificaARTICOLO = False
   End If
   RS.Close
   Set RS = Nothing
End Function

Public Function VerificaARTICOLO_SERVIZIO(Codice As String) As Boolean
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   'Verifico se l'ARTICOLO o SERVIZIO e' gia' presente negli archivi _
    NB: la ricerca e' effettuata senza tenere conto se si tratta di un ART o un SER

   strRicerca = "Select * from ART_ICOL where ARCODICE = '" & Codice & "'"
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      VerificaARTICOLO_SERVIZIO = True
   Else
      VerificaARTICOLO_SERVIZIO = False
   End If
   RS.Close
   Set RS = Nothing
End Function

Public Function VerificaCONTO(Chiave As String, CampoRicerca As String, ValoreRicerca As String) As Boolean
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   strRicerca = "Select * from CONTI where ANTIPCON+" & CampoRicerca & " like '" & Chiave + VerificaApici(ValoreRicerca) & "%' ORDER BY " & CampoRicerca
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      VerificaCONTO = True
   Else
      VerificaCONTO = False
   End If
   RS.Close
   Set RS = Nothing
End Function

Public Function VerificaCLI_SPED(Chiave As String, CampoRicerca As String, ValoreRicerca As String, ValoreCodCon As String) As Boolean
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   'strRicerca = "Select * from CLI_SPED where SPTIPCON+SPCODCON+" & CampoRicerca & " like '" & Chiave + ValoreCodCon + ValoreRicerca & "%' ORDER BY " & CampoRicerca
   strRicerca = "SELECT  TOP 100 PERCENT * " & _
                "From dbo.CLI_SPED " & _
                "WHERE   (SPTIPCON + SPCODCON + " & CampoRicerca & " COLLATE SQL_Latin1_General_CP1_CI_AS like '" & Chiave + ValoreCodCon + ValoreRicerca & "%') " & _
                "ORDER BY " & CampoRicerca & ""
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      VerificaCLI_SPED = True
   Else
      VerificaCLI_SPED = False
   End If
   RS.Close
   Set RS = Nothing
End Function


Public Function VerificaEsistFAT_CONTO(TipDoc As String, NumDOC As Long, SerieDoc As String, TipConto As String, CodConto As String, Optional Escludi As Long) As Boolean
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   strRicerca = "Select * from DOC_MAST where MVTIPDOC = '" & TipDoc & "' AND MVNUMDOC = " & NumDOC & " AND MVALFDOC = '" & SerieDoc & "' AND MVTIPCON = '" & TipConto & "' AND MVCODCON = '" & CodConto & "' AND MVANNDOC = '" & AnnoGestione & "' AND MVSERIAL <> " & Escludi & ""
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      VerificaEsistFAT_CONTO = True
   Else
      VerificaEsistFAT_CONTO = False
   End If
   RS.Close
   Set RS = Nothing
End Function

Public Function VerificaCONTO_Movimentato(TipConto As String, CodConto As String) As Boolean
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   strRicerca = "Select * from DOC_MAST where MVTIPCON = '" & TipConto & "' AND MVCODCON = '" & CodConto & "'"
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      VerificaCONTO_Movimentato = True
   Else
      VerificaCONTO_Movimentato = False
   End If
   RS.Close
   Set RS = Nothing
End Function

Public Function VerificaCLI_SPED_Movimentato(TipConto As String, CodConto As String, CodSped As String) As Boolean
   Dim RS         As ADODB.Recordset
   Dim strRicerca As String
   Dim Esci       As Boolean
   
   'Qui Controllo che non sia presente nella tabella DOC_MAST
   strRicerca = "Select * from DOC_MAST where MVTIPCON = '" & TipConto & "' AND MVCODCON = '" & CodConto & "' AND MVCODSPE = '" & CodSped & "'"
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      VerificaCLI_SPED_Movimentato = True
      Esci = True
   Else
      VerificaCLI_SPED_Movimentato = False
   End If
   RS.Close
   Set RS = Nothing

   If Esci = True Then Exit Function

   'Qui Controllo che non sia presente nella tabella CONTI (come predefinito!)
   strRicerca = "Select * from CONTI where ANTIPCON = '" & TipConto & "' AND ANCODICE = '" & CodConto & "' AND ANCODSPE = '" & CodSped & "'"
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      VerificaCLI_SPED_Movimentato = True
   Else
      VerificaCLI_SPED_Movimentato = False
   End If
   RS.Close
   Set RS = Nothing
End Function

Public Function Decod_NOTE_DOC(MVSerial As Long) As String
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   strRicerca = "Select MV__NOTE from DOC_MAST where MVSERIAL = " & MVSerial & ""
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      Decod_NOTE_DOC = NonNullo(RS!MV__NOTE)
   End If
   RS.Close
   Set RS = Nothing
End Function

Public Function DecodCONTO(Chiave As String, CampoRicerca As String, ValoreRicerca As String, Optional TextCodice As Variant) As String
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   strRicerca = "Select * from CONTI where ANTIPCON+" & CampoRicerca & " like '" & VerificaApici(Chiave + ValoreRicerca) & "%' ORDER BY " & CampoRicerca
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      If RS.RecordCount > 1 Then
   
         DecodCONTO = "more"
   
      Else
         If IsObject(TextCodice) = True Then TextCodice.text = RS!ANCODICE
         DecodCONTO = RS!ANDESCRI
      End If
   Else
      DecodCONTO = "null"
   End If
   RS.Close
   Set RS = Nothing
End Function

Public Function DecodCLI_SPED(Chiave As String, CampoRicerca As String, ValoreRicerca As String, ValoreCodCon, Optional TextCodice As Variant) As String
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   'strRicerca = "Select * from CONTI where ANTIPCON+" & CampoRicerca & " like '" & VerificaApici(Chiave + ValoreRicerca) & "%' ORDER BY " & CampoRicerca
   strRicerca = "SELECT  TOP 100 PERCENT * " & _
                "From dbo.CLI_SPED " & _
                "WHERE   (SPTIPCON + SPCODCON + " & CampoRicerca & " like '" & VerificaApici(Chiave + ValoreCodCon + ValoreRicerca) & "%') " & _
                "ORDER BY " & CampoRicerca & ""
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      'If RS.RecordCount > 1 Then
   
      '   DecodCLI_SPED = "more"
   
      'Else
         If IsObject(TextCodice) = True Then TextCodice.text = RS!SPCODICE
         DecodCLI_SPED = RS!SPDESCRI
      'End If
   Else
      DecodCLI_SPED = "null"
   End If
   RS.Close
   Set RS = Nothing


'   'strRicerca = "Select * from CLI_SPED where SPTIPCON+SPCODCON+" & CampoRicerca & " like '" & Chiave + ValoreCodCon + ValoreRicerca & "%' ORDER BY " & CampoRicerca
'   strRicerca = "SELECT  TOP 100 PERCENT * " & _
'                "From dbo.CLI_SPED " & _
'                "WHERE   (SPTIPCON + SPCODCON + " & CampoRicerca & " COLLATE SQL_Latin1_General_CP1_CI_AS like '" & Chiave + ValoreCodCon + ValoreRicerca & "%') " & _
'                "ORDER BY " & CampoRicerca & ""
'   Set RS = New ADODB.Recordset
'   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic

End Function

Public Function DecodTABGEN(Chiave As String, CampoRicerca As String, ValoreRicerca As String, Optional TextCodice As Variant) As String
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   strRicerca = "Select * from TAB_GEN where TGCHIAVE+" & CampoRicerca & " like '" & Chiave + ValoreRicerca & "%' ORDER BY " & CampoRicerca
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      If IsObject(TextCodice) = True Then TextCodice.text = RS!TGCODICE
      DecodTABGEN = RS!TGDESCR
   Else
      DecodTABGEN = "null"
   End If
   RS.Close
   Set RS = Nothing
End Function

Public Function DecodSILOS(CampoRicerca As String, ValoreRicerca As String, Optional TextCodice As Variant) As String
'Questa function restituisce il contrario
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   Select Case CampoRicerca
      Case "SLCODICE"
         'DecodSILOS = "0"
         strRicerca = "Select * from TAB_SILOS where " & CampoRicerca & " = " & ValoreRicerca & ""
      Case "SLDESCRI"
         'DecodSILOS = "null"
         strRicerca = "Select * from TAB_SILOS where " & CampoRicerca & " like '" & VerificaApici(ValoreRicerca) & "%'"
   End Select
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      If IsObject(TextCodice) = True Then TextCodice.text = RS!SLCODICE
      DecodSILOS = RS!SLDESCRI
   Else
      DecodSILOS = "nul"
   End If
   RS.Close
   Set RS = Nothing
End Function

Public Function DecodCampoSILOS(CodSilos As Long, Campo As String) As Variant
'Questa function restituisce il contrario
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   strRicerca = "Select * from TAB_SILOS where SLCODICE = " & CodSilos & ""
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      Select Case Campo
         Case "SLCAPACI"
            DecodCampoSILOS = RS!SLCAPACI
         Case "SLMARMIN"
            DecodCampoSILOS = RS!SLMARMIN
      End Select
   End If
   RS.Close
   Set RS = Nothing
End Function

Public Function DecodSilosByGruMer(pGruMer As String, Optional pCaratProd As String) As Integer
'Questa function restituisce il Codixce del primo SILOS che risponde al Gruppo Merceologico passato nei parametri
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   Dim vCaratProd As String
   If Len(Trim(pCaratProd)) > 0 Then
      vCaratProd = " AND (SLCARPRO = '" & VerificaApici(pCaratProd) & "') "
   End If

   strRicerca = "Select SLCODICE from TAB_SILOS where (SLGRUMER = '" & VerificaApici(pGruMer) & "')" & vCaratProd
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      DecodSilosByGruMer = RS!SLCODICE
   End If
   RS.Close
   Set RS = Nothing
End Function

Public Function DecodLISTIN(CampoRicerca As String, ValoreRicerca As String, Optional TextCodice As Variant) As String
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   strRicerca = "Select * from TAB_LISTIN where " & CampoRicerca & " like '" & ValoreRicerca & "%' ORDER BY " & CampoRicerca
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      If IsObject(TextCodice) = True Then TextCodice.text = RS!TLCODICE
      DecodLISTIN = RS!TLDESCR
   Else
      DecodLISTIN = "null"
   End If
   RS.Close
   Set RS = Nothing
End Function

Public Function DecodARTICOL(Chiave As String, CampoRicerca As String, ValoreRicerca As String, Optional TextCodice As Variant, Optional ConsideraServizi As Boolean) As String
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   On Error GoTo GestErr
   
'QUI RICERCO SENZA IL "LIKE"
   If ConsideraServizi = False Then 'Qui significa che devo caricare solo gli ART o i SER
      strRicerca = "Select * from ART_ICOL where ARTIPART+" & CampoRicerca & " = '" & Chiave + ValoreRicerca & "'"
   Else  'Qui devo caricare tutti i record sia ART che SER
      strRicerca = "Select * from ART_ICOL where " & CampoRicerca & " = '" & ValoreRicerca & "'"
   End If
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      If IsObject(TextCodice) = True Then TextCodice.text = RS!ARCODICE
      DecodARTICOL = RS!ARDESCRI
      RS.Close
      Set RS = Nothing
      Exit Function
   End If
   RS.Close
   Set RS = Nothing
   

'Se e' arrivato qui allora RICERCO CON IL "LIKE"
   If ConsideraServizi = False Then 'Qui significa che devo caricare solo gli ART o i SER
      strRicerca = "Select * from ART_ICOL where ARTIPART+" & CampoRicerca & " like '" & Chiave + ValoreRicerca & "%' ORDER BY " & CampoRicerca
   Else  'Qui devo caricare tutti i record sia ART che SER
      strRicerca = "Select * from ART_ICOL where " & CampoRicerca & " like '" & ValoreRicerca & "%' ORDER BY " & CampoRicerca
   End If
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      If RS.RecordCount > 1 Then
         DecodARTICOL = "more"
      Else
         If IsObject(TextCodice) = True Then TextCodice.text = RS!ARCODICE
         DecodARTICOL = RS!ARDESCRI
      End If
   Else
      DecodARTICOL = "null"
   End If
   RS.Close
   Set RS = Nothing
   
GestErr:
   If Err.Number = 91 Then
      Resume Next
   ElseIf Err.Number <> 0 Then
      MsgBox Err.Number & " - " & Err.Description
   End If
   On Error GoTo 0
   
End Function


Public Function DecodVitignoArticolo(vCodArt As String) As String
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   On Error GoTo GestErr
   
   strRicerca = "Select ARCODICE,ARVITIGN from ART_ICOL where ARCODICE = '" & VerificaApici(vCodArt) & "'"
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      DecodVitignoArticolo = NonNullo(RS!ARVITIGN)
   End If
   RS.Close
   Set RS = Nothing
      
GestErr:
   If Err.Number <> 0 Then
      MsgBox Err.Number & " - " & Err.Description
   End If
   On Error GoTo 0
End Function



Public Function DecodMasVolART(vCodArt As String) As Byte
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   On Error GoTo GestErr
   
   strRicerca = "Select ARCODICE,ARMASVOLOBB from ART_ICOL where ARCODICE = '" & VerificaApici(vCodArt) & "'"
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      DecodMasVolART = NonNullo(RS!ARMASVOLOBB, True)
   End If
   RS.Close
   Set RS = Nothing
      
GestErr:
   If Err.Number <> 0 Then
      MsgBox Err.Number & " - " & Err.Description
   End If
   On Error GoTo 0
   
End Function

Public Function DecodFlagART_MV_TA(vCodArt As String) As String
'Questa funzione restituisce il valore del campo AR_MV_TA della tabella ART_ICOL: _
 MA = Massa Volumica ; TA = Titolo Alcool
   
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   On Error GoTo GestErr
   
   strRicerca = "Select ARCODICE,AR_MV_TA from ART_ICOL where ARCODICE = '" & VerificaApici(vCodArt) & "'"
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      DecodFlagART_MV_TA = NonNullo(RS!AR_MV_TA)
   End If
   RS.Close
   Set RS = Nothing
      
GestErr:
   If Err.Number <> 0 Then
      MsgBox Err.Number & " - " & Err.Description
   End If
   On Error GoTo 0
   
End Function


Public Function DecodATTIVITA(ValoreRicerca As String, Numerico As Boolean, Optional TextCodice As Variant, Optional CondizioneAND As String) As String
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

'Qui Cerco per COdice o per Descrizione Precisa!
   If Numerico = True Then
      strRicerca = "Select * from TAB_ATTIVITA where ATCODICE = " & ValoreRicerca & ""
   Else
      strRicerca = "Select * from TAB_ATTIVITA where ATDESCRI = '" & ValoreRicerca & "'"
   End If
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      If IsObject(TextCodice) = True Then TextCodice.text = RS!ATCODICE
      DecodATTIVITA = RS!ATDESCRI
      RS.Close
      Set RS = Nothing
      Exit Function
   End If
   RS.Close
   Set RS = Nothing


'Qui cerco per Descrizione con il LIKE
   strRicerca = "Select * from TAB_ATTIVITA where ATDESCRI like '" & ValoreRicerca & "%' " & CondizioneAND
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      If RS.RecordCount > 1 Then
         DecodATTIVITA = "more"
      Else
         If IsObject(TextCodice) = True Then TextCodice.text = RS!ATCODICE
         DecodATTIVITA = RS!ATDESCRI
      End If
   Else
      DecodATTIVITA = "null"
   End If
   RS.Close
   Set RS = Nothing

End Function

Public Function DecodCAMPI(TABELLA As String, CampoRicerca As String, ValoreRicerca As String, Optional Numerico As Boolean) As String
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   If Numerico = True Then
      strRicerca = "Select * FROM " & TABELLA & " WHERE " & CampoRicerca & " = " & ValoreRicerca & ""
   Else
      strRicerca = "Select * FROM " & TABELLA & " WHERE " & CampoRicerca & " COLLATE SQL_Latin1_General_CP1_CI_AS = '" & ValoreRicerca & "'"
   End If
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If RS.EOF Then
      DecodCAMPI = "null"
   End If
   RS.Close
   Set RS = Nothing
End Function


'Decod Sotto-Famiglia
Public Function DecodSOTFAM(Chiave As String, CampoRicerca As String, ValoreRicerca As Integer, Optional TextCodice As Variant) As String
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   'Se c'e' il Codice effettuo la ricerca per "codice" + "CampoRicerca"
   If Len(Trim(Chiave)) > 0 Then
      strRicerca = "Select * from SOT_FAM where SFCODFAM = '" & Chiave & "' AND " & CampoRicerca & " = " & ValoreRicerca & " ORDER BY " & CampoRicerca
   Else  'altrimenti effettuo la ricerca solo per "CampoRicerca"
      strRicerca = "Select * from SOT_FAM where " & CampoRicerca & " = " & ValoreRicerca & " ORDER BY " & CampoRicerca
   End If
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      If IsObject(TextCodice) = True Then TextCodice.text = RS!SFCODICE
      DecodSOTFAM = RS!SFDESCRI
   Else
      DecodSOTFAM = "null"
   End If
   RS.Close
   Set RS = Nothing
End Function


Public Function DecodTGValoreTABGEN(Chiave As String, CampoRicerca As String, ValoreRicerca As String) As Single
   'Questa funzione restituisce il valore del campo TGVALORE presente nella tabella TAB_GEN
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   'strRicerca = "Select * from TAB_GEN where TGCHIAVE+" & CampoRicerca & " like '" & Chiave + ValoreRicerca & "%' ORDER BY " & CampoRicerca
   strRicerca = "Select * from TAB_GEN where TGCHIAVE+" & CampoRicerca & " = '" & Chiave + ValoreRicerca & "'"
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      DecodTGValoreTABGEN = RS!TGVALORE
   Else
      DecodTGValoreTABGEN = 0
   End If
   RS.Close
   Set RS = Nothing
End Function

Public Function DecodTIPDOC(Chiave As String, CampoRicerca As String, ValoreRicerca As String, TextCodice As Variant) As String
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   strRicerca = "Select * from TIP_DOC where TDFLVEAC+" & CampoRicerca & " like '" & Chiave + ValoreRicerca & "%' ORDER BY " & CampoRicerca
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      If IsObject(TextCodice) = True Then TextCodice.text = RS!TDTIPDOC
      DecodTIPDOC = Trim(RS!TDDESDOC)
   Else
      DecodTIPDOC = "null"
   End If
   RS.Close
   Set RS = Nothing
End Function

Public Function DecodSerieTipDoc(pTipDoc As String) As String
'Questa funzione restituisce il valore del campo TD_SERIE. _
 Usata per pescare la SERIE del TIPO DOCUM. DA CUI PRENDERE IL PROGRESSIVO _
 (ES: FATAC prende numerazione da FADIF. In questo esempio qui cerco la SERIE del TipDoc FADIF)
   
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   strRicerca = "Select TD_SERIE from TIP_DOC where TDTIPDOC = '" & pTipDoc & "'"
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      DecodSerieTipDoc = Trim(NonNullo(RS!TD_SERIE))
   End If
   RS.Close
   Set RS = Nothing
End Function

Public Function DecodCATDOC(Chiave As String, ValoreRicerca As String) As String
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   strRicerca = "Select * from TIP_DOC where TDFLVEAC+TDTIPDOC = '" & Chiave + ValoreRicerca & "'"
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      DecodCATDOC = Trim(RS!TDCATDOC)
   End If
   RS.Close
   Set RS = Nothing
End Function


'Public Function DECOD_VALORE_CAMPO(TABELLA As String, CampoRicerca As String, ValoreRicerca As String, CampoDaRes As String, Optional Diverso As Boolean, Optional RestNull As Boolean) As String
''Questa funzione e' generica: _
' RETITUISCE IL VALORE DI UN DATO CAMPO (CampoDaRes) DI UNA DATA TABELLA _
' (Se il parametro RestNull = True, se l'esito della query  negativo la funzione restituisce null altrimenti NIENTE
'   Dim RS As ADODB.Recordset
'   Dim strRicerca As String
'
'   If Diverso = False Then
'      strRicerca = "Select " & CampoDaRes & " from " & TABELLA & " where " & CampoRicerca & " = '" & ValoreRicerca & "' ORDER BY " & CampoDaRes & " desc"
'   Else
'      strRicerca = "Select " & CampoDaRes & " from " & TABELLA & " where " & CampoRicerca & " <> '" & ValoreRicerca & "' ORDER BY " & CampoDaRes & " desc"
'   End If
'   Set RS = New ADODB.Recordset
'   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
'   If Not RS.EOF Then
'      DECOD_VALORE_CAMPO = NonNullo(RS.Fields(CampoDaRes))
'   Else
'      If RestNull = True Then DECOD_VALORE_CAMPO = "null"
'   End If
'   RS.Close
'   Set RS = Nothing
'End Function


Public Function Decod_REPORT_TIPDOC(TipDoc As String) As String
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   strRicerca = "Select TDREPORT from TIP_DOC where TDTIPDOC = '" & TipDoc & "'"
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      Decod_REPORT_TIPDOC = RS!TDREPORT
   End If
   RS.Close
   Set RS = Nothing
End Function


Public Function ver_Serial_DocTra_gen_da_DocFor(SerialFOR As Long) As Long
   'Restituisce il Seriale (MVSERIAL) del Documento del Trasportatore se il documento e' stato generato _
    da un Documento del Fornitore (campo MVRIFTRA = SerialFOR)
   Dim RS As ADODB.Recordset
   Dim strRicerca As String
   
   strRicerca = "Select MVSERIAL from DOC_MAST where MVRIFTRA = " & SerialFOR & ""
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      ver_Serial_DocTra_gen_da_DocFor = RS!MVSerial
   End If
   RS.Close
   Set RS = Nothing
End Function

Public Function ver_TipDoc_Documento(MVSerial As Long) As String
   'Restituisce il campo MVTIPDOC del Documento MVSERIAL passato come parametro
   Dim RS As ADODB.Recordset
   Dim strRicerca As String
   
   strRicerca = "Select MVTIPDOC from DOC_MAST where MVSERIAL = " & MVSerial & ""
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      ver_TipDoc_Documento = RS!MVTIPDOC
   End If
   RS.Close
   Set RS = Nothing
End Function


Public Function ver_se_Doc_Fatturato(SerialDoc As Long) As Boolean
   'Restituisce TRUE se il documento MVSERIAL = SerialDoc ha il campo MVRIFFAD > 0 (cioe' e' Fatturato!)
   Dim RS As ADODB.Recordset
   Dim strRicerca As String
   
   strRicerca = "Select MVSERIAL from DOC_MAST where MVSERIAL = " & SerialDoc & " AND MVRIFFAD > 0"
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      ver_se_Doc_Fatturato = True
   End If
   RS.Close
   Set RS = Nothing
End Function

Public Function ver_Serial_Fattura_su_DDT(SerialDDT As Long) As Long
   'Restituisce il Seriale (MVRIFFAD) della FATTURA che e' stata generata _
    dal DDT (campo MVSERIAL = SerialDDT)
   Dim RS As ADODB.Recordset
   Dim strRicerca As String
   
   strRicerca = "Select MVRIFFAD from DOC_MAST where MVSERIAL = " & SerialDDT & ""
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      ver_Serial_Fattura_su_DDT = RS!MVRIFFAD
   End If
   RS.Close
   Set RS = Nothing
End Function

Public Function ver_Serial_FATACC_su_FATDIF(Seriale As Long) As Boolean
   'Restituisce TRUE se il Seriale della FATTURA di ACCONTO  risulta essere _
    presente in DOC_DETT sul campo MVFACRIF. Significa che  agganciata a una o pi Fatture Dif.
   Dim RS As ADODB.Recordset
   Dim strRicerca As String
   
   strRicerca = "Select MVFACRIF from DOC_DETT where MVFACRIF = " & Seriale & ""
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      ver_Serial_FATACC_su_FATDIF = True
   End If
   RS.Close
   Set RS = Nothing
End Function

Public Function VerificaProgressivoUsato(TipoCampo As String, CampoNum As String, ValCampo As Long, Sezionale As Boolean, Optional ACQ_VEN As Byte) As Boolean
'CONTROLLA SE IL PROGRESSIVO ("VALCAMPO") DEL CAMPO "CAMPONUM" DEL TIPO DOCUMENTO "TIPODOC" PER L'ANNOGESTIONE _
 E' GIA' PRESENTE IN DOC_MAST. NB: il parametro ACQ_VEN distingue la ricerca in caso di documernti di ACQUISTO _
 dove il progressivo lo devo cercare sul TipoDocumento, mentre per le VENDITE lo devo cercare sul TipoDocumento che assegna il Progressivo (MVTIPDOCPRG)
   Dim RS As ADODB.Recordset
   Dim strRicerca As String
   Dim TABELLA As String
   Dim vTipoCampo As String
   
   TABELLA = "DOC_MAST"
   
   'Se non e' Sezionale e' TIPO DOCUMENTO
   If Sezionale = True Then
      vTipoCampo = "MVCODSEZ"
   Else
      If ACQ_VEN = 0 Then 'ACQUISTI
         vTipoCampo = "MVTIPDOC+MVALFDOC"
      Else 'VENDITE
         vTipoCampo = "MVTIPDOCPRG+MVALFDOC"
      End If
   End If
   
   strRicerca = "SELECT * FROM " & TABELLA & " WHERE " & vTipoCampo & " = '" & TipoCampo & "' AND " & CampoNum & " = " & ValCampo & " AND MVANNDOC = '" & AnnoGestione & "'"
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      VerificaProgressivoUsato = True
   Else
      VerificaProgressivoUsato = False
   End If
   RS.Close
   Set RS = Nothing
End Function


Public Function VerificaTipDocProgSug(VenAcq As String, TipDoc As String) As String
'La funzione verifica se il TIPO_DOCUMENTO prevede che il Progressivo debba essere suggerito in automatico _
 In tal caso la funzione restituisce la stringa che poi verra' usata come indentificati del progressivo nella tabella INDICI
   Dim RS As ADODB.Recordset
   Dim strRicerca As String
   
   On Error GoTo GestioneErrore
   
   'Cerco il TipDoc Predefinito della catergoria impostat nella ChiaveTabella
   strRicerca = "Select * from TIP_DOC where TDFLVEAC+TDTIPDOC  = '" & VenAcq & TipDoc & "'"
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      'Verifico se deve suggerire il Progressivo
      If RS!TDPRGSUG = 1 Then
         VerificaTipDocProgSug = "TIPDOC_" & RS!TDNUMERA & "_" & RS!TDFLVEAC
      End If
   End If
   RS.Close
   Set RS = Nothing

GestioneErrore:
   If Err <> 0 Then
      MsgBox Err.Number & " - " & Err.Description
      RS.Close
      Set RS = Nothing
   End If
   On Error GoTo 0
End Function

Public Function VerificaNoteArticolo(Codice As String) As String
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   strRicerca = "Select AR__NOTE from ART_ICOL where ARCODICE = '" & Codice & "'"
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      VerificaNoteArticolo = NonNullo(RS!AR__NOTE)
   End If
   RS.Close
   Set RS = Nothing
   
End Function

Public Function VerificaTipoRigheTIPDOC(Chiave As String, Campo As String) As String
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   strRicerca = "Select * from TIP_DOC where TDTIPDOC = '" & Chiave & "'"
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      If Campo = "TDSTMRIG" Then
         VerificaTipoRigheTIPDOC = NonNullo(RS!TDSTMRIG)
      ElseIf Campo = "TDGENRIG" Then
         VerificaTipoRigheTIPDOC = NonNullo(RS!TDGENRIG)
      End If
   End If
   RS.Close
   Set RS = Nothing
End Function

Public Function VerificaCampagnaPredefinita() As String
'questa funzione restituisce il codice della CAMPAGNA VINICOLA che ha il valore TGSPUNTA1 = 1  che indica che  PREDEFINITA
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   strRicerca = "Select TGCODICE, TGSPUNTA1 from TAB_GEN where TGCHIAVE = 'CAMPAG' AND TGSPUNTA1 = 1"
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      VerificaCampagnaPredefinita = RS!TGCODICE
   End If
   RS.Close
   Set RS = Nothing
End Function

Public Function VerificaMediatoreDOC(vSerial As Long) As String
'questa funzione restituisce il codice della CAMPAGNA VINICOLA che ha il valore TGSPUNTA1 = 1  che indica che  PREDEFINITA
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   strRicerca = "Select MVSERIAL, MVCODAGE  from DOC_MAST where MVSERIAL = " & vSerial & ""
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      VerificaMediatoreDOC = RS!MVCODAGE
   End If
   RS.Close
   Set RS = Nothing
End Function


Public Function VerificaMOV_Silos_Giacenza(TipMov As String, CodSilos As Long) As String
'restituisce TRUE se gi esiste un movimento di GIACENZA INIZIALE per il Silos selezionato
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   strRicerca = "Select MCSERIAL from MOV_CANT where MCTIPMOV = '" & TipMov & "' AND MCSILCAR = " & CodSilos & " AND MCFLMOVI = 1"
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      VerificaMOV_Silos_Giacenza = True
   Else
      VerificaMOV_Silos_Giacenza = False
   End If
   RS.Close
   Set RS = Nothing
End Function

Public Function DecodProgressivoSuccessivo(TABELLA As String, Campo As String, strWhere As String) As Long
'questa funzione restituisce il codice della CAMPAGNA VINICOLA che ha il valore TGSPUNTA1 = 1  che indica che  PREDEFINITA
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   strRicerca = "Select max(" & Campo & ") as ValMax from " & TABELLA & " where " & strWhere
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      DecodProgressivoSuccessivo = NonNullo(RS!ValMax, True) + 1
   Else
      DecodProgressivoSuccessivo = 1
   End If
   RS.Close
   Set RS = Nothing
End Function

Public Function VerificaBOOLEANA(strRicerca As String, Optional pDbGenerale As Boolean) As Boolean
   Dim RS As ADODB.Recordset
   
   If ConnessioneGenerale.State = 0 Then Exit Function
   
   Set RS = New ADODB.Recordset
   If pDbGenerale Then
      RS.Open strRicerca, ConnessioneGenerale, adOpenStatic
   Else
      RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   End If
   
      VerificaBOOLEANA = Not RS.EOF
      
   RS.Close
   Set RS = Nothing
End Function

Public Function GetMassaVolumicaByGrado(pGrado As Single) As Single
   Dim RS As ADODB.Recordset
   Dim strRicerca As String
   
   'recupero il valore di Massa Volumica in base al grado passato (o al valore subito prima)
   strRicerca = "SELECT TOP 1 GRMASVOL " & _
                "  FROM GRADO_MASS_VOLUM " & _
                " WHERE GR_GRADO <= ( " & Replace(pGrado, ",", ".") & ") " & _
                " ORDER BY GR_GRADO DESC"
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneGenerale, adOpenStatic
   If Not RS.EOF Then
      GetMassaVolumicaByGrado = NonNullo(RS!GRMASVOL, True)
   End If
   RS.Close
   Set RS = Nothing
End Function
