Attribute VB_Name = "Modulo1"
Option Explicit

Private Declare Function ReleaseCapture Lib "user32" () As Long 'per risolvere il problema dell'errore di RUN-TIME 400 (chiamata form modali)

'Originali**********************************
Public CHIAMANTE As String
Public ChiamanteFattura As String
Public NumeroFattura As Long
Declare Function GetDeviceCaps Lib "gdi32" (ByVal hDC As Long, ByVal nIndex As Long) As Long
'*******************************************

Public gTerminaAPP As Boolean

Public VersionePRG As String
Public VersioneDB As String
Public ContenutoTxtRicerca As String

Public gSecondaIstanza As Boolean

'Public NOMEPROGETTO As String
Public DESCRIZIONEPROGETTO As String

Public ConnessioneAzienda As ADODB.Connection 'punta all'mdb della societ selezionata (nella cartella del programma)
Public ConnessioneGenerale As ADODB.Connection  'punta all'mdb GENERALE che si trova sotto la directory "[App.path]&\DB\Generale.mdb"

Public NomeServerSQL As String
Public NomeDBSQL_GEN As String
Public NomeDBSQL_AZI As String
Public Password_SA As String 'E' la password da riempire nel caso l'utente 'sa' di SQL abbia la password (come accade per MSDE2000 SP4)
Public ConnessioneTrusted As String 'Indica il tipo di Connessione da effettuare

Public Azienda As String         'Codice Azienda in uso
Public DesAzienda As String      'Descrizione Azienda in uso
Public IndAzienda As String      'Indirizzo Azienda
Public LocAzienda As String      'Localita Azienda
Public TelAzienda As String      'Telefono Azienda
Public FaxAzienda As String      'Fax Azienda
Public PIvAzienda As String      'Partita IVA Azienda
Public ProgCliForSugg As Byte    'Indica se per in fase di caricamento delle Anagrafiche CLIENTI e FORNITORI deve suggerire il progressivo
Public UCaseAnagrafiche As Byte  'Indica se nell'inserimento delle anagrafiche i campi devo essere scritti tutti in maiuscolo
Public LenMaxCodAnag As Byte     'Indica il numero massimo del Codice delle Anagrafiche Cli/For nel caso si usi l'impostazione del caricamento automatico
Public pred_TipDoc_T As String
Public pred_CodArt_T As String
Public pred_CodIva_T As String
Public pred_CodIva_C As String
Public pred_CodIva_F As String
Public pred_Magazzino_A As String
Public pred_Magazzino_V As String
Public pred_CausaleTras As String
Public pred_Porto As String
Public pred_Spediz As String
Public pred_ModDoc As String
Public pred_CodArtAcc As String

Public pred_DecimaliImp As Byte
Public pred_DecimaliQta As Byte

Public pred_ValGradB As Single 'Valore fisso per il calcolo del Grado Baum (B)
Public pred_ValMasVol As Single 'Valore fisso per il calcolo della Massa Volumica

Public Operatore As Integer      'Codice Operatore in uso
Public DesOperatore As String    'Descrizione dell'Operatore
Public OperatoreAmm As Byte      '0=Non e' Amministratore; 1 =E' Amministratore
Public PsswOperatore As String   'E' la password dell'Operatore che si Logga

Public AnnoGestione As String    'Anno in uso
Public DataGestione As String    'Data in uso

Public IngressoAvvenuto As Boolean

Public IniPath As String         'percorso del file ParametriGenerali.ini
Public PathArchivi As String     'percorso degli archivi dei DataBase
Public PathSTAMPE As String      'percorso del Database per le Stampe (che risiede sulle singole macchine)
Public PathReport As String      'percorso del file di Report
Public PathBackUP As String      'percorso della cartella di BackUP

'Public Valuta As String          'indica la descrizione della valuta in uso
'Public SimboloValuta As String   'indica il simbolo della valuta in uso (ricavato dalla valuta in uso)
'Public SimboloLire As String     'indica il simbolo della lira
'Public SimboloEuro As String     'indica il simbolo dell'euro
'Public CambioEuro As Double      'indica il valore del cambio dell'euro (letta nel file ParametriGenerali.ini)

Public ActivateGiaEseguito As Boolean    'usata nell'Activate del FormMDI1

'Usate in fase di stampa del documento e caricate nella routine "ConfermaAzienda" del FormLonIg
Public MillimetriMargine As Integer
Public ModuloStampa As Byte
Public TipoCarta As String

'Usate quando si richiama il FormGriglia
Public CaptionFormGriglia As String ' il caption che viene visualizzato nel FormGriglia
Public SqlFormGriglia As String 'istruzione  SQL che deve eseguire l'MSRDCGriglia del FormGriglia
Public CodiceSelezioneGriglia As String 'codice della selezione effettuata nel FormGriglia
Public DesSelezioneGriglia As String 'descrizione del codice selezionato nel FormGriglia
Public TABELLA As String 'Nome della tabella che si deve caricare in griglia

Public gCodSelGriglia As String 'codice della selezione effettuata nel FormGriglia
Public gDesSelGriglia As String 'descrizione del codice selezionato nel FormGriglia
Public gOpeSelGriglia As Integer 'Codice dell'Operatore impostato nella FormGriglia in caso di Operatore Obbligatorio

Public gLastDataAzzeramento As String
Public gWhereDataAzzeramento As String 'Filtro sulla data del sezionale MVDATSEZ dei Documenti in modo da avere le giacenze a partire dalla eventuale data di Azzeramento

Public COD_LISTINO As Long

Public SerialRifFatAcc As Long 'Usato nella FormAgganciaFATACC
Public ImportRifFatAcc As Double 'Usato nella FormAgganciaFATACC
Public DescriRifFatAcc As String 'Usato nella FormAgganciaFATACC

Public CodClienteNuovo As Long 'usato nel form FORMFATTURA se inserisco da questo form un nuovo cliente

'Per leggere nel file INI
Declare Function GetPrivateProfileString Lib "kernel32" Alias "GetPrivateProfileStringA" _
                  (ByVal lpApplicationName As String, _
                   ByVal lpKeyName As Any, _
                   ByVal lpDefault As String, _
                   ByVal lpReturnedString As String, _
                   ByVal nSize As Long, _
                   ByVal lpFileName As String) _
                  As Long

Declare Function WritePrivateProfileString Lib "kernel32" Alias "WritePrivateProfileStringA" _
                  (ByVal lpApplicationName As String, _
                   ByVal lpKeyName As Any, _
                   ByVal lpString As Any, _
                   ByVal lpFileName As String) _
                  As Long
                  
Public gUserPath As String       'percorso del file ParGen.cnf personalizzato e svincolato da App.Path



'*** ********************* ***
Sub Main()
   Dim Appoggio As String
   Dim Posiz As Integer
   
      
   Call SetCSSApp
   
   gUserPath = Command()
   'gUserPath = "C:\Users\g.novi\PRIMO_TEST\"
   gUserPath = Trim(gUserPath)
   
   
'   'Evito che si eseguano pi Sessioni di lavoro
'   If App.PrevInstance Then
'      If MsgBox("Sessione di lavoro gi aperta!" & vbNewLine & _
'                "Si desidera aprirne un'altra?", vbQuestion + vbYesNo) = vbNo Then
'         End
'      Else
'         gSecondaIstanza = True
'      End If
'   End If


   If App.PrevInstance Then
      gSecondaIstanza = True
   End If


   If Len(gUserPath) <> 0 Then
      If Right(gUserPath, 1) = "\" Then
         gUserPath = Mid(gUserPath, 1, Len(gUserPath) - 1)
      End If
   
      'Controllo che la cartella esista realmente
      Dim vPathOk As Boolean
      Call VerificaEsistenzaPathCartella(gUserPath, True, vPathOk)
      If vPathOk = False Then
         MsgBox "ATTENZIONE!" & vbNewLine & _
                "USER-PATH errato!" & vbNewLine & _
                "(" & gUserPath & ")", vbCritical
         End
      End If
   End If



   Screen.MousePointer = 11
   ActivateGiaEseguito = False 'inizializzo la variabile x il FormMDI1
   
   VersionePRG = App.Major & "." & App.Minor & "." & App.Revision
   
   
   If Len(gUserPath) > 0 Then
      IniPath = gUserPath + "\ParametriGenerali.ini"
'      IniTempPath = gUserPath + "\TempInf.ini" 'percorso del file Temporaneo che viene eliminato ad ogni avvio/chiusura
'      IniSetGrid = gUserPath & "\Custom\SetGrid.CNF"
'      IniStmpParam = gUserPath & "\Custom\StmpParam.CNF"
'      IniAddMenu = gUserPath & "\Custom\AddMenu.CNF"
'      IniShowAvvisi = gUserPath & "\Custom\ShowAvvisi.CNF"
'      IniParamCustom = gUserPath & "\Custom\ParamCustom.CNF"
'      IniNewsRead = gUserPath & "\Custom\NewsRead.CNF"
   Else
      IniPath = App.path + "\ParametriGenerali.ini"
'      IniTempPath = App.path + "\TempInf.ini" 'percorso del file Temporaneo che viene eliminato ad ogni avvio/chiusura
'      IniSetGrid = App.path & "\Custom\SetGrid.CNF"
'      IniStmpParam = App.path & "\Custom\StmpParam.CNF"
'      IniAddMenu = App.path & "\Custom\AddMenu.CNF"
'      IniShowAvvisi = App.path & "\Custom\ShowAvvisi.CNF"
'      IniParamCustom = App.path & "\Custom\ParamCustom.CNF"
'      IniNewsRead = App.path & "\Custom\NewsRead.CNF"
   End If
      
      
   '****************************************************
   'RICORDARSI DI MODIFICARLO SE SI USA QUESTO MODULO _
    PER UN ALTRO PROGETTO
    NOMEPROGETTO = "ns_primo"
    DESCRIZIONEPROGETTO = "PRIMO"
    
    Call ImpostaDatiAbilitazione
   '****************************************************
      
      
   
'********************************************************************
  'Leggo il file ParametriGenerali.ini ed imposto i parametri per l'accesso ai dati
   Azienda = ReadINI("AZIENDA", "CODICE_ULTIMA_USATA", IniPath)
   Operatore = IIf(Len(ReadINI("AZIENDA", "CODICE_ULTIMO_Operatore", IniPath)) = 0, 0, ReadINI("AZIENDA", "CODICE_ULTIMO_Operatore", IniPath))
   
   Call VerificaVariabiliPath
'********************************************************************



''Apro l'ambiente di lavoro
'   Set AmbienteLavoro = rdoEnvironments(0)
   
   
''Apro l'ambiente di lavoro sul database Generale.mdb
'   Set ConnessioneGenerale = New ADODB.Connection
'   ConnessioneGenerale.ConnectionString = "Provider = Microsoft.Jet.OLEDB.4.0;Data Source =" & PathArchivi & "\Generale.mdb" & ";Jet OLEDB:Database Password=generalels;"
'   ConnessioneGenerale.Open
'
'' Creo automat. la connessione ODBC sugli archivi Generale.mdb ...
'   rdoEngine.rdoRegisterDataSource "BluFattureGenerale", "Microsoft Access Driver (*.mdb)", True, "dbq=" & PathArchivi & "\Generale.mdb;PWD="
''...e mi collego, cosi' posso verificare se l'ultima azienda usata _
'   esiste ancora, sia come record nel database  che come MDB!
'   Set ConnessioneGenerale = AmbienteLavoro.OpenConnection("BluFattureGenerale", , , "uid=;pwd=")



'Verifico che nel File "[PathArchivi]&\Generale.mdb" esista realmente l'azienda da usare.
'Non posso mettere questa istruzione prima perch devo gi essere connesso
'agli archivi del Gestionale1!
'   If Len(Trim(Azienda)) <> 0 Then
'      Call VerificaEsistenzaAzienda(Azienda)
'   End If
'
'   If Len(Trim(Operatore)) <> 0 Then
'      Call VerificaEsistenzaOperatore(Operatore)
'   End If

   Screen.MousePointer = 0
   MDIForm1.Show
End Sub

'Funzione per leggere nel file INI
Public Function ReadINI(ByVal AppName As String, KeyName As String, Filename As String) As String
Dim INIreturn As String
        
    INIreturn = String(255, Chr(0))
    ReadINI = Left(INIreturn, GetPrivateProfileString(AppName, KeyName, "", INIreturn, _
        Len(INIreturn), Filename))
End Function
'Funzione per scrivere nel file INI
Public Sub WriteINI(ByVal AppName As String, KeyName As String, NewString As String, Filename As String)
Dim Flag As Integer
        
    Flag = WritePrivateProfileString(AppName, KeyName, NewString, Filename)
End Sub



Function EseguiSQLMDB(Comando As String)
   Dim ComandoDaEseguire As String
   
   ComandoDaEseguire = ControllaApici(Comando)
   ConnessioneAzienda.Execute ComandoDaEseguire
   
End Function

Function EseguiSQLMDBGenerale(Comando As String)
   Dim ComandoDaEseguire As String
   
   ComandoDaEseguire = ControllaApici(Comando)
   ConnessioneGenerale.Execute ComandoDaEseguire
   
End Function


Function EseguiSQL_Stampe(Comando As String)
   Dim ComandoDaEseguire As String
   
   ComandoDaEseguire = ControllaApici(Comando)
   ConnSTAMPA.Execute ComandoDaEseguire
   
End Function



Public Function Twips(Millimetri As Long) As Long
   Twips = (Millimetri * 56.7)
End Function



Public Function RichiamaFormGriglia(frmForm As Form, TextDaRiempire As Object, LabelDaRiempire As Object, Caption As String, MiaTabella As String, p_ConnAzienda As Boolean, p_CampoOrderBy As Byte, p_CampoChiave As String, p_ChiaveTabella As String, Optional CampoWhere As String, Optional ValoreCampoWhere As String, Optional TipoCampoWhere As String) As Boolean
   On Error Resume Next
            
   CaptionFormGriglia = Caption
   TABELLA = MiaTabella
      
   FormGriglia.ConnGenerale = p_ConnAzienda
   FormGriglia.CampoOrderBy = p_CampoOrderBy
   FormGriglia.CampoChiave = p_CampoChiave
   FormGriglia.ChiaveTabella = p_ChiaveTabella
   
   FormGriglia.CampoWhere = CampoWhere
   FormGriglia.ValoreCampoWhere = ValoreCampoWhere
   FormGriglia.TipoCampoWhere = TipoCampoWhere
   
   FormGriglia.Show 1
   Set FormGriglia = Nothing
   
   If Len(Trim(CodiceSelezioneGriglia)) > 0 Then 'Cosi' evito di svuotarlo se non  stato selezionato nulla
      TextDaRiempire = CodiceSelezioneGriglia
      LabelDaRiempire = DesSelezioneGriglia
      
      RichiamaFormGriglia = True
   End If
   
   On Error GoTo 0
End Function


Public Sub RichiamaFormTastiGriglia(prValDescri As String, prValCodice As String, Caption As String, pTabella As String, _
                                    Optional pCampoChiave As String, Optional pChiaveTabella As String, Optional pStrWhere As String, _
                                    Optional pDatAtt As String, Optional pOraIniAtt As String, Optional pOraFinAtt As String, _
                                    Optional pBloccaAnnulla As Boolean, Optional pOperatPrefer As Integer)
   On Error Resume Next
            
   CaptionFormGriglia = Caption
   TABELLA = pTabella
      
   'FormGrigliaTasti.ConnGenerale = p_ConnAzienda
   'FormGrigliaTasti.CampoOrderBy = p_CampoOrderBy
   FormGrigliaTasti.CampoChiave = pCampoChiave
   FormGrigliaTasti.ChiaveTabella = pChiaveTabella
   FormGrigliaTasti.mStrWhere = pStrWhere
   If IsDate(pDatAtt) Then
      FormGrigliaTasti.mDatAtt = pDatAtt
      FormGrigliaTasti.mOraIniAtt = pOraIniAtt
      FormGrigliaTasti.mOraFinAtt = pOraFinAtt
   End If
   FormGrigliaTasti.mBloccaAnnulla = pBloccaAnnulla
   FormGrigliaTasti.mOperatPrefer = pOperatPrefer
   
   'FormGrigliaTasti.CampoWhere = CampoWhere
   'FormGrigliaTasti.ValoreCampoWhere = ValoreCampoWhere
   'FormGrigliaTasti.TipoCampoWhere = TipoCampoWhere
   
   Screen.MousePointer = vbHourglass
   
   'ReleaseCapture
   'Call MDIForm1.ShowOmbra
   FormGrigliaTasti.Show 1
   Set FormGrigliaTasti = Nothing
   
   
   If Len(Trim(gCodSelGriglia)) > 0 Then 'Cosi' evito di svuotarlo se non  stato selezionato nulla
      'If IsObject(TextDaRiempire) = True Then
         prValCodice = gCodSelGriglia
      'Else
      '   TextDaRiempire = gCodSelGriglia
      'End If
      prValDescri = gDesSelGriglia
   End If
   
   On Error GoTo 0
End Sub


Public Sub VerificaEsistenzaAzienda(CodAz As String)
   Dim RS As ADODB.Recordset
   Dim strRicerca As String
   

   On Error GoTo GestioneErrore

'QUI CONTROLLO CHE ESISTA IL RECORD NELLA TABELLA ANA_AZIENDE _
   DEL DATABSE GENERALE.MDB
   strRicerca = "Select * from ANA_AZIENDE where AZCODAZI = '" & CodAz & "'"
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneGenerale, adOpenStatic
   If RS.EOF Then
      MsgBox "ATTENZIONE! La Societ '" & CodAz & "' usata l'ultima volta, non risulta piu' negli Archivi", vbCritical
      RS.Close
      Set RS = Nothing
      
      Azienda = ""
      
     'Cancello il codice della societ presente nel file ParametriGenerale.ini"
      Call WriteINI("AZIENDA", "CODICE_ULTIMA_USATA", "", IniPath)
   Else
      DesAzienda = RS!AZRAGAZI
      IndAzienda = NonNullo(RS!AZINDAZI) 'Indirizzo Azienda
      LocAzienda = NonNullo(RS!AZCAPAZI) & " " & NonNullo(RS!AZLOCAZI) & " " & NonNullo(RS!AZPROAZI) 'Localita Azienda
      TelAzienda = NonNullo(RS!AZTELEFO) 'Telefono Azienda
      FaxAzienda = NonNullo(RS!AZTELFAX) 'FAX Azienda
      PIvAzienda = NonNullo(RS!AZPIVAZI)
      
      ProgCliForSugg = RS!AZPROGCF
      UCaseAnagrafiche = RS!AZUCASE
      LenMaxCodAnag = RS!AZLENCOD
      
      pred_TipDoc_T = NonNullo(RS!AZTIPDOC_T)
      pred_CodArt_T = NonNullo(RS!AZCODART_T)
      pred_CodIva_T = NonNullo(RS!AZCODIVA_T)
      pred_CodIva_C = NonNullo(RS!AZCODIVA_C)
      pred_CodIva_F = NonNullo(RS!AZCODIVA_F)
      pred_Magazzino_A = NonNullo(RS!AZCODMAG_A)
      pred_Magazzino_V = NonNullo(RS!AZCODMAG_V)
      pred_CausaleTras = NonNullo(RS!AZCAUTRA)
      pred_Porto = NonNullo(RS!AZCODPOR)
      pred_Spediz = NonNullo(RS!AZSPEDIZ)
      pred_ModDoc = NonNullo(RS!AZMODDOC)
      pred_CodArtAcc = NonNullo(RS!AZCODARTACC)
      
      pred_ValGradB = RS!AZVALGRADBE 'Valore fisso per il calcolo del Grado Baum (B)
      pred_ValMasVol = RS!AZVALMASVOL 'Valore fisso per il calcolo della Massa Volumica
      
      'Al momento sono fissi. Se servir dovr preedere dei campi nei DatiAzienda
      pred_DecimaliImp = 5
      pred_DecimaliQta = 2
      
      RS.Close
      Set RS = Nothing
   End If
   
   
GestioneErrore:
   If Err.Number = 3265 Then 'Se manca un campo (potrebbe verificarsi solo con il campo AZCODARTACC aggiunto per ultimo _
                              Poi sarebbe opportuno eliminare questo controllo!
      Resume Next
   ElseIf Err.Number <> 0 Then
      'RS.Close
      MsgBox Err.Number & " - " & Err.Description
      Call TerminaApplicazione
   End If
End Sub

Public Sub VerificaEsistenzaOperatore(CodOperatore As Integer)
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   On Error GoTo GestioneErrore

'QUI CONTROLLO CHE ESISTA IL RECORD NELLA TABELLA ANA_UTENTI DEL DATABSE GENERALE.MDB
   strRicerca = "Select * FROM ANA_UTENTI WHERE UTCODICE = " & CodOperatore & ""
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneGenerale, adOpenStatic
   If RS.EOF Then
      MsgBox "ATTENZIONE! L'Operatore '" & CodOperatore & "' usato l'ultima volta, non risulta piu' negli Archivi", vbCritical
      RS.Close
      Set RS = Nothing
      
      Operatore = 0
      
     'Cancello il codice della societ presente nel file ParametriGenerale.ini"
      Call WriteINI("AZIENDA", "CODICE_ULTIMO_Operatore", "", IniPath)
   Else
      DesOperatore = Trim(RS!UTDESUTE)
      'OperatoreAmm = RS!AMMUTE
      PsswOperatore = NonNullo(Trim(RS!UTPASSW))
      RS.Close
      Set RS = Nothing
   End If
   
   
GestioneErrore:
   If Err <> 0 Then
      'RS.Close
      MsgBox Err.Number & " - " & Err.Description
      Call TerminaApplicazione
   End If
End Sub


Public Sub TerminaApplicazione(Optional pDaMDI As Boolean, Optional ForzaChiusura As Boolean)
   Dim i As Byte
   Dim Frm As Form
   
   gTerminaAPP = True
   
   On Error Resume Next
   
   ''Cancello il record con UTNOMEPC = PC_NAME cos libero un Posto di Lavoro
   'ConnessioneGenerale.Execute ("DELETE FROM UTENTI_CONNESSI WHERE UTNOMEPC = '" & PC_NAME & "'")
   
   For Each Frm In Forms
      If Frm.Name <> MDIForm1.Name Then
         Unload Frm
         Set Frm = Nothing
         'GoTo ripeti <--- RIMOSSO CON LA 1.6.13 SPERANDO RISOLVA IL PROBLEMA DELL'ERRORE IN CHIUSURA DI PROGRAMMA
      End If
   Next Frm
   
   
   ConnessioneAzienda.Close
   ConnessioneGenerale.Close
      
   'Se provengo dalla MDI NON eseguo l'Unload MDIForm1 ma far il CLOSE nella QueryUnload dell'MDI
      If pDaMDI = False Then
         Unload MDIForm1
         Set MDIForm1 = Nothing
      Else
         'If Len(mLogFileUpdate) Then
         '   Kill App.path & "\Files\Doc\" & mLogFileUpdate
         'End If
      End If
   
   'End
   
End Sub




'Gli passo la Descrizione del Campo "DesProgressivo" della tabella "Indici"
'Il tipo pu essere: "ProgClienti"  con Anno = "----" (obbligatorio!!)
'                    "ProgFatture"  con Anno = AnnoGestione

Public Function AttribuisciProgressivo(Tipo As String, Anno As String) As String
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

'Qui leggo l'ultimo numero attribuito...
Ripeti:
   strRicerca = "Select * from INDICI where DesProgressivo = '" & Tipo & "' and Anno = '" & Anno & "'"
   'Set RS = ConnessioneAzienda.OpenResultset(strSQL, rdOpenStatic)
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      AttribuisciProgressivo = Trim(Str(RS!Progressivo + 1))
   Else
      'se non trovo niente significa che non e' predisposto per
      'l'anno in uso e quindi creo gli INDICI
      Call CreaIndiciPerNuovoAnno(Tipo, Anno)
      RS.Close
      Set RS = Nothing
      GoTo Ripeti
   End If
   RS.Close
   Set RS = Nothing
End Function

                                 
Public Sub CreaIndiciPerNuovoAnno(Tipo As String, Anno As String)
   Dim StrCampi As String
   Dim StrValori As String
   Dim StrIns As String
   
   StrCampi = "DesProgressivo"
   StrValori = "'" & Tipo & "'"
   
   StrCampi = StrCampi & ",Progressivo"
   StrValori = StrValori & ",0"
       
   StrCampi = StrCampi & ",Anno"
   StrValori = StrValori & ",'" & Anno & "'"

   StrIns = "INSERT INTO INDICI (" & StrCampi & ") values (" & StrValori & ")"
   Call EseguiSQLMDB(StrIns)
   
End Sub


Public Sub AggiornaIndici(Ind1 As String, ValInd1 As Long, Anno As String)
   'EseguiSQLMDB ("UPDATE INDICI SET Progressivo = " & ValInd1 & " WHERE DesProgressivo = '" & Ind1 & "' and Anno = '" & Anno & "'")
   ConnessioneAzienda.Execute ("UPDATE INDICI SET Progressivo = " & ValInd1 & " WHERE DesProgressivo = '" & Ind1 & "' and Anno = '" & Anno & "'")
End Sub


Public Function CodiceCliente(Posizione As String) As Long
'questa funzione e' utilizzata per sapere il codice del primo e _
   dell'ultimo Cliente della tabella AnaCF del Gestionale1 _
      "FormGeneraFat" e "FormSelDocumenti"
      
   Dim RS As ADODB.Recordset
   Dim strRicerca As String
      
'   On Error Resume Next
   
   If Posizione = "primo" Then
      strRicerca = "Select CODCL from ANA_CLIENTI order by CodCL"
   ElseIf Posizione = "ultimo" Then
      strRicerca = "Select CODCL from ANA_CLIENTI order by CodCL desc"
   End If
   'Set RS = ConnessioneAzienda.OpenResultset(strRicerca, rdOpenStatic)
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If RS.EOF Then
      CodiceCliente = 0
   Else
'      Err = 0
      CodiceCliente = CLng(RS!CODCL)
'      If Err <> 0 Then
'         MsgBox "Impossibile continuare perch si  riscontrato non tutti i Codici Clienti sono di tipo numerico!", vbCritical
'         CodiceCliente = 0
'         Err = 0
'      End If
   End If
   RS.Close
   Set RS = Nothing
End Function


Public Sub VerificaVariabiliPath()
   PathArchivi = ReadINI("PATH", "ARCHIVI", IniPath): If PathArchivi = "original_path" Then PathArchivi = ""
   PathReport = ReadINI("PATH", "REPORT", IniPath): If PathReport = "original_path" Then PathReport = ""
   PathBackUP = ReadINI("PATH", "BACKUP", IniPath): If PathBackUP = "original_path" Then PathBackUP = ""
   PathSTAMPE = ReadINI("PATH", "STAMPE", IniPath): If PathSTAMPE = "original_path" Then PathSTAMPE = ""
   
   
   If Len(Trim(PathArchivi)) = 0 Then
      If Len(gUserPath) > 0 Then
         Call WriteINI("PATH", "ARCHIVI", "original_path", IniPath)
         PathArchivi = gUserPath & "\Db"
      Else
         Call WriteINI("PATH", "ARCHIVI", App.path & "\Db", IniPath)
         PathArchivi = App.path & "\Db"
      End If
   End If

   If Len(Trim(PathReport)) = 0 Then
      Call WriteINI("PATH", "REPORT", App.path & "\Report", IniPath)
      PathReport = App.path & "\Report"
   End If
   
   If Len(Trim(PathBackUP)) = 0 Then
      If Len(gUserPath) > 0 Then
         Call WriteINI("PATH", "BACKUP", "original_path", IniPath)
         PathBackUP = gUserPath & "\BackUP"
      Else
         Call WriteINI("PATH", "BACKUP", App.path & "\BackUp", IniPath)
         PathBackUP = App.path & "\BackUP"
      End If
   End If

   If Len(Trim(PathSTAMPE)) = 0 Then
      If Len(gUserPath) > 0 Then
         Call WriteINI("PATH", "STAMPE", "original_path", IniPath)
         PathSTAMPE = gUserPath & "\DB\Stampe.mdb"
      Else
         Call WriteINI("PATH", "STAMPE", App.path & "\DB\Stampe.mdb", IniPath)
         PathSTAMPE = App.path & "\DB\Stampe.mdb"
      End If
   End If
End Sub


Public Function VerificaAzienda(CodiceAZ As String, TextCodice As Object, CampoDesc As Object, TipoCampoDesc As String) As Boolean
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   On Error GoTo GestioneErrore
   
   
   strRicerca = "Select * from ANA_AZIENDE where AZCODAZI like '" & Trim(CodiceAZ) & "%' order by AZCODAZI"
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneGenerale, adOpenStatic
   If Not RS.EOF Then
      TextCodice = Trim(RS!AZCODAZI)
      If TipoCampoDesc = "C" Then '"C" = Caption
         CampoDesc.Caption = Trim(RS!AZRAGAZI)
      Else  '"T" = Text
         CampoDesc.text = Trim(RS!AZRAGAZI)
      End If
      VerificaAzienda = True
      
   Else
      'MsgBox "ATTENZIONE! Codice Azienda inesistente!", vbCritical
      VerificaAzienda = False
      'TextCodice.SetFocus
   End If
   RS.Close
   Set RS = Nothing

GestioneErrore:
   If Err <> 0 Then
      MsgBox Err.Number & " - " & Err.Description
      RS.Close
      Set RS = Nothing
   End If
End Function

Public Function VerificaOperatore(CodiceUte As Integer, CampoDesc As Object, Optional TipoCampoDes As String) As Boolean
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   On Error GoTo GestioneErrore
   
   
   strRicerca = "Select * from ANA_UTENTI WHERE UTCODICE = " & Trim(CodiceUte) & ""
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneGenerale, adOpenStatic
   If Not RS.EOF Then
      If TipoCampoDes = "TXT" Then
         CampoDesc.text = Trim(RS!UTDESUTE)
      Else 'LABEL
         CampoDesc.Caption = Trim(RS!UTDESUTE)
      End If
      VerificaOperatore = True
   Else
      VerificaOperatore = False
   End If
   RS.Close
   Set RS = Nothing

GestioneErrore:
   If Err <> 0 Then
      MsgBox Err.Number & " - " & Err.Description
   End If
End Function


Public Sub ConfermaAzienda(CodiceAZ As String)
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   On Error GoTo GestioneErrore
   
   strRicerca = "Select * from ANA_AZIENDE where CodAz = '" & Trim(CodiceAZ) & "'"
   'Set RS = ConnessioneGenerale.OpenResultset(strRicerca, rdOpenStatic)
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneGenerale, adOpenStatic
   If Not RS.EOF Then
      
      Azienda = RS!CodAz
      DesAzienda = RS!RagSoc
   
   End If
   RS.Close
   Set RS = Nothing

GestioneErrore:
   If Err <> 0 Then
      MsgBox Err.Number & " - " & Err.Description
      RS.Close
      Set RS = Nothing
   End If
End Sub



Public Function VerificaCliente(CodiceCL As String, TextCodice As Object, CampoDesc As Object) As Boolean
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   On Error GoTo GestioneErrore
   
   
   strRicerca = "Select * from ANA_CLIENTI where CodCL = " & Trim(CodiceCL) & ""
   'Set RS = ConnessioneAzienda.OpenResultset(strRicerca, rdOpenStatic)
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      'If TipoCampoDesc = "C" Then '"C" = Caption
      '   CampoDesc.Caption = RS!RagSoc
      'Else  '"T" = Text
         CampoDesc.text = RS!RagSoc
      'End If
      VerificaCliente = True
      
   Else
      'MsgBox "ATTENZIONE! Codice Azienda inesistente!", vbCritical
      VerificaCliente = False
      'TextCodice.SetFocus
   End If
   RS.Close
   Set RS = Nothing

GestioneErrore:
   If Err <> 0 Then
      MsgBox Err.Number & " - " & Err.Description
      'RS.Close
   End If
End Function

Public Function VerificaFunzionalita() As Boolean
   If Azienda <> "" Then
      VerificaFunzionalita = True
   Else
      VerificaFunzionalita = False
      MsgBox "Funzione disabilitata! Selezionare una Societ", vbExclamation
   End If
End Function

Public Function PrimaEsecuzione() As Boolean
'OK
'questa funzione mi serve per verificare se nn esiste nessuna Societa' (Prima Esecuzione assoluta) _
 ed in questo caso la funzione restituisce TRUE altrimenti se trova almeno una Societa' registrata _
 restituisce False
   
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   On Error GoTo GestioneErrore
   
   PrimaEsecuzione = False
   
   strRicerca = "Select * from ANA_AZIENDE"
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneGenerale, adOpenStatic
   If RS.EOF Then
      PrimaEsecuzione = True
   End If
   RS.Close
   Set RS = Nothing

GestioneErrore:
   If Err <> 0 Then
      MsgBox Err.Number & " - " & Err.Description
      RS.Close
      Set RS = Nothing
   End If
   
End Function


Public Function ConnessioneSQL_GEN() As Boolean
   On Error GoTo GestErr
   ConnessioneSQL_GEN = True
   
   Screen.MousePointer = vbHourglass
   
'Impostazione Varibili ************************************************
   NomeServerSQL = ReadINI("CONN_SQL", "NAME_SERVER", IniPath)
   NomeDBSQL_GEN = ReadINI("CONN_SQL", "NAME_DB_GEN", IniPath)
   Password_SA = ReadINI("CONN_SQL", "PASSWORD_SA", IniPath)
   ConnessioneTrusted = ReadINI("CONN_SQL", "TRUSTED", IniPath)
'FINE Impostazione Varibili ********************************************
   
   
'Apro l'ambiente di lavoro su AdHOC  ***********************************
   If Len(Trim(NomeServerSQL)) > 0 And Len(Trim(NomeDBSQL_GEN)) > 0 Then
      
      Set ConnessioneGenerale = New ADODB.Connection
      If ConnessioneTrusted = "1" Then
         'ConnessioneGenerale.ConnectionString = "Provider=SQLOLEDB.1;Password=" & Password_SA & ";Persist Security Info=False;User ID=sa;Initial Catalog=" & NomeDBSQL_GEN & ";Data Source=" & NomeServerSQL
         ConnessioneGenerale.ConnectionString = "Provider=SQLOLEDB;Data Source=" & NomeServerSQL & ";Initial Catalog=" & NomeDBSQL_GEN & ";Integrated Security=SSPI"
         ConnessioneGenerale.Open
      Else
         ConnessioneGenerale.ConnectionString = "Provider=SQLOLEDB.1;Password=" & Password_SA & ";Persist Security Info=False;User ID=sa;Initial Catalog=" & NomeDBSQL_GEN & ";Data Source=" & NomeServerSQL
         ConnessioneGenerale.Open
      End If
      
      ConnessioneSQL_GEN = True
      
   Else
      MsgBox "Impostare i dati per poter effettuare la Connessione SQL al Server", vbInformation
      ConnessioneSQL_GEN = False
   End If


GestErr:
   If Err.Number <> 0 Then
      ConnessioneSQL_GEN = False
      MsgBox "ATTENZIONE! ERRORE IN FASE DI CONNESSIONE SQL AL SERVER!" & vbNewLine & Err.Number & " - " & Err.Description & vbNewLine & vbNewLine & "Verificare i dati della Connessione: <Nome Server> - <Nome Database> - <Password Utente 'sa'>", vbCritical
   End If
   On Error GoTo 0
   
   Screen.MousePointer = vbDefault
End Function


Public Function ConnessioneSQL_AZI() As Boolean
   On Error GoTo GestErr
   ConnessioneSQL_AZI = True
   
   Screen.MousePointer = vbHourglass
   
'Apro l'ambiente di lavoro su AdHOC  ***********************************
   If Len(Trim(NomeServerSQL)) > 0 And Len(Trim(NomeDBSQL_AZI)) > 0 Then
      Set ConnessioneAzienda = New ADODB.Connection
      If ConnessioneTrusted = "1" Then
         'ConnessioneAzienda.ConnectionString = "Provider=SQLOLEDB.1;Password=" & Password_SA & ";Persist Security Info=False;User ID=sa;Initial Catalog=" & NomeDBSQL_AZI & ";Data Source=" & NomeServerSQL
         ConnessioneAzienda.ConnectionString = "Provider=SQLOLEDB;Data Source=" & NomeServerSQL & ";Initial Catalog=" & NomeDBSQL_AZI & ";Integrated Security=SSPI"
         ConnessioneAzienda.Open
      Else
         ConnessioneAzienda.ConnectionString = "Provider=SQLOLEDB.1;Password=" & Password_SA & ";Persist Security Info=False;User ID=sa;Initial Catalog=" & NomeDBSQL_AZI & ";Data Source=" & NomeServerSQL
         ConnessioneAzienda.Open
      End If
   
      ConnessioneSQL_AZI = True
   
   Else
      MsgBox "Impostare i dati per poter effettuare la Connessione SQL al Server", vbInformation
      ConnessioneSQL_AZI = False
   End If

GestErr:
   If Err.Number <> 0 Then
      ConnessioneSQL_AZI = False
      MsgBox "ATTENZIONE! ERRORE IN FASE DI CONNESSIONE SQL AL SERVER!" & vbNewLine & Err.Number & " - " & Err.Description & vbNewLine & vbNewLine & "Verificare i dati della Connessione: <Nome Server> - <Nome Database> - <Password Utente 'sa'>", vbCritical
   End If
   On Error GoTo 0
   
   Screen.MousePointer = vbDefault
End Function


Public Sub AggiornaTotaliDocumento(vSerial As Long, CausaleDOC As String, Optional pAcquistoMosto As Boolean)
'Questa sub ricalcola il totale del documento ciclando dalle righe di dettaglio _
 La procedura preleva solo le righe MVTIPRIG = 'R', quindi escludo le descrizioni _
 Il parametro CausaleDOC indica se i documenti sono di ACQUISTO o di VENDITA
   Dim RS As ADODB.Recordset
   Dim strRicerca As String
   Dim Importo As Double
   Dim ValIVA As Single
   Dim vImponibile As Double
   Dim vImposta As Double


   strRicerca = "SELECT * FROM DOC_DETT WHERE MVSERIAL = " & vSerial & " AND MVTIPRIG = 'R' ORDER BY CPROWNUM"
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If RS.EOF = False Then
      Do Until RS.EOF
   
         Importo = 0
         ValIVA = 0
         
         If (CausaleDOC = "A") And (pAcquistoMosto = False) Then  'ACQUISTI
            Importo = (RS!MVPESRIS * RS!MVPRZNET) 'Q.t * PrezzoNetto
         Else 'VENDITE (per le Vendite e' diverso) oppure Acquisto MOSTO
            Importo = (RS!MVPESRIS * RS!MVPRZNET * RS!MVGRADO) 'Q.t * PrezzoNetto * Grado
         End If
         
         vImponibile = CDbl(vImponibile) + Importo

         ValIVA = DecodTGValoreTABGEN("CODIVA", "TGCODICE", RS!MVCODIVA)
         If ValIVA > 0 Then vImposta = vImposta + ((Importo * ValIVA) / 100) 'Calcolo IVA

         RS.MoveNext
      Loop
   End If
   RS.Close
   Set RS = Nothing

   'QUI AGGIORNO I TOTALI IN DOC_MAST
   ConnessioneAzienda.Execute ("UPDATE DOC_MAST SET MVTOTIMP = " & Replace(vImponibile, ",", ".") & ", " & _
                               "                    MVTOTIVA = " & Replace(vImposta, ",", ".") & " " & _
                               " WHERE MVSERIAL = " & vSerial & "")

End Sub


Public Function CalcolaAcconti(strWhere As String) As Double
   Dim RS As ADODB.Recordset
   'Dim RSDet As ADODB.Recordset
   Dim strRicerca As String
   Dim Riga As Integer
   
   strRicerca = "SELECT     SUM(ACIMPACC) AS TOTACCONTI " & _
                "From dbo.DOC_ACCO " & strWhere
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      
      CalcolaAcconti = NonNullo(RS!TotAcconti, True)
      
   End If
   RS.Close
   Set RS = Nothing
End Function

Public Function CalcolaQuotaUsataFAT_ACC(vSerial As Long) As Double
   Dim RS As ADODB.Recordset
   'Dim RSDet As ADODB.Recordset
   Dim strRicerca As String
   Dim Riga As Integer
   
   strRicerca = "SELECT     SUM(MVPRZNET) AS TOTQUOTA " & _
                "From dbo.DOC_DETT WHERE MVFACRIF = " & vSerial
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      
      CalcolaQuotaUsataFAT_ACC = NonNullo(RS!TOTQUOTA, True)
      
   End If
   RS.Close
   Set RS = Nothing
End Function

Public Function GetDocContratto(TipoConto As String, CodContratto As String, CodArt As String) As String()
'Questa funzione restituisce l'elenco in Array dei Documenti dove  stato usato il Contratto e l'articolo
   Dim RS As ADODB.Recordset
   Dim strRicerca As String
   Dim vArr() As String
   Dim vStrArr As String
                   
                   
   strRicerca = "SELECT TOP 100 PERCENT dbo.DOC_MAST.MVSERIAL, dbo.DOC_MAST.MVTIPDOC, dbo.DOC_MAST.MVCATDOC, " & _
                "       dbo.DOC_MAST.MVCODSEZ, dbo.DOC_MAST.MVPRGSEZ, dbo.DOC_MAST.MVDATSEZ, " & _
                "       dbo.DOC_MAST.MVNUMDOC, dbo.DOC_MAST.MVDATDOC " & _
                "  FROM dbo.DOC_MAST INNER JOIN " & _
                "       dbo.DOC_DETT ON dbo.DOC_MAST.MVSERIAL = dbo.DOC_DETT.MVSERIAL " & _
                " WHERE (MVTIPCON = '" & TipoConto & "') " & _
                "   AND (dbo.DOC_DETT.MVCODART = '" & CodArt & "') " & _
                "   AND (dbo.DOC_DETT.MVCONTRA = " & CodContratto & ")" & _
                " ORDER BY  dbo.DOC_MAST.MVDATDOC, dbo.DOC_MAST.MVPRGSEZ "
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      Do Until RS.EOF
         vStrArr = RS!MVSerial & "|" & _
                   RS!MVTIPDOC & "|" & _
                   RS!MVCATDOC & "|" & _
                   NonNullo(RS!MVCODSEZ) & "|" & _
                   RS!MVPRGSEZ & "|" & _
                   NonNullo(RS!MVDATSEZ) & "|" & _
                   RS!MVNUMDOC & "|" & _
                   NonNullo(RS!MVDATDOC) & "|"
                   
         Call AddArrayElement(vArr, vStrArr)
         
         RS.MoveNext
      Loop
      
      GetDocContratto = vArr
   End If
   RS.Close
   Set RS = Nothing
End Function


Public Function QuatitaUsataArticoloContratto(TipoConto As String, CodContratto As String, CodArt As String, EscludiDoc As Long) As Double
'Questa funzione restituisce la QUANTITA' usata di un dato Articolo(CodArt) per un determinato Contratto(CodContratto) _
 leggendo i movimenti presenti nella tabella DOC_DETT
   Dim RS As ADODB.Recordset
   'Dim RSDet As ADODB.Recordset
   Dim strRicerca As String
   Dim Riga As Integer
   Dim vStrEscludi As String
   
   'Se la variabile e' piena allora nel fare la somma delle quantita' gia' caricate escludo il documento in questione _
    perche' significa che sto in modifica del Documento stesso e quindi non lo considero nel conteggio
   If EscludiDoc > 0 Then
      vStrEscludi = " AND dbo.DOC_MAST.MVSERIAL <> " & EscludiDoc & ""
   End If
   
   strRicerca = "SELECT SUM(MVPESRIS) AS MVQUANTI " & _
                "  FROM dbo.DOC_MAST INNER JOIN " & _
                "       dbo.DOC_DETT ON dbo.DOC_MAST.MVSERIAL = dbo.DOC_DETT.MVSERIAL " & _
                " WHERE (dbo.DOC_MAST.MVTIPCON = '" & TipoConto & "') " & _
                "   AND (dbo.DOC_DETT.MVCODART = '" & CodArt & "') " & _
                "   AND (dbo.DOC_DETT.MVCONTRA = " & CodContratto & ") " & _
                vStrEscludi
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      QuatitaUsataArticoloContratto = NonNullo(RS!MVQUANTI, True)
   End If
   RS.Close
   Set RS = Nothing
End Function

Public Function VerificaContrattiArticolo(TipConto As String, CodConto As String, CodArt As String, DataDoc As String, _
                                          LabelCodContra As Object, TextPrzLordo As Object, TextPrzNetto As Object, _
                                          EscludiDoc As Long) As Boolean
   Dim RS As ADODB.Recordset
   'Dim RSDet As ADODB.Recordset
   Dim strRicerca As String
   'Dim Riga As Integer
   
   strRicerca = "SELECT     TOP 100 PERCENT dbo.TAB_CONTRA.TCCHIAVE, dbo.TAB_CONTRA.TCCODICE, dbo.TAB_CONTRA.TCDATCRE, dbo.TAB_CONTRA.TCTIPCON, " & _
                "dbo.TAB_CONTRA.TCCODCON, dbo.TAB_CONTRA.TCDAT_DA, dbo.TAB_CONTRA.TCDAT_AL, dbo.ART_CONTRA.TCCODART, " & _
                "dbo.ART_CONTRA.TCQUANTI , dbo.ART_CONTRA.TCPRZLOR, dbo.ART_CONTRA.TCPRZNET " & _
                "FROM         dbo.TAB_CONTRA INNER JOIN " & _
                "dbo.ART_CONTRA ON dbo.TAB_CONTRA.TCCHIAVE = dbo.ART_CONTRA.TCCHIAVE AND " & _
                "dbo.TAB_CONTRA.TCCODICE = dbo.ART_CONTRA.TCCONTRA " & _
                "WHERE     (dbo.TAB_CONTRA.TCTIPCON = '" & TipConto & "') AND (dbo.TAB_CONTRA.TCCODCON = '" & CodConto & "') AND (dbo.TAB_CONTRA.TCDAT_DA <= CONVERT(DATETIME, " & _
                "'" & Format(DataDoc, "yyyy-mm-dd") & " 00:00:00', 102)) AND (dbo.TAB_CONTRA.TCDAT_AL >= CONVERT(DATETIME, '" & Format(DataDoc, "yyyy-mm-dd") & " 00:00:00', 102)) AND  " & _
                "(dbo.ART_CONTRA.TCCODART = '" & CodArt & "') " & _
                "ORDER BY dbo.TAB_CONTRA.TCDATCRE DESC, dbo.TAB_CONTRA.TCCODICE DESC"
                
                'NOTA: il 28/07/2021 Dina mi ha chiesto di invertire il criterio di ordinamento di estrazione e di considerare valido l'ultimo Contratto e non il primo trovato
                
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
      
      If RS!TCQUANTI > QuatitaUsataArticoloContratto(TipConto, RS!TCCODICE, CodArt, EscludiDoc) Then
         
         VerificaContrattiArticolo = True
         
         LabelCodContra.Caption = RS!TCCODICE
         
         If RS!TCPRZLOR > 0 Then 'PREZZO LORDO
            TextPrzLordo = RS!TCPRZLOR
         Else                    'PREZZO NETTO
            TextPrzNetto = RS!TCPRZNET
         End If
      
      End If
   End If
   RS.Close
   Set RS = Nothing
End Function

Public Function VerificaListiniArticolo(TipConto As String, CodConto As String, CodMediatore As String, CodArt As String, DataDoc As String, LabelCodListin As Object, TextPrzLordo As Object, TextPrzNetto As Object) As Boolean
   Dim RS As ADODB.Recordset
   'Dim RSDet As ADODB.Recordset
   Dim strRicerca As String
   
   If Len(CodMediatore) = 0 Then 'Conto (Cli/For)
      strRicerca = "SELECT     dbo.TAB_LISTIN.TLCODICE, dbo.TAB_LISTIN.TLDAT_DA, dbo.TAB_LISTIN.TLDAT_AL, dbo.ART_LISTIN.TLCODART, dbo.ART_LISTIN.TLPRZLOR, dbo.ART_LISTIN.TLPRZNET , dbo.CONTI.ANTIPCON, dbo.CONTI.ANCODICE " & _
                  "FROM         dbo.TAB_LISTIN INNER JOIN " & _
                  "dbo.ART_LISTIN ON dbo.TAB_LISTIN.TLCODICE = dbo.ART_LISTIN.TLLISTIN LEFT OUTER JOIN dbo.CONTI ON dbo.TAB_LISTIN.TLCODICE = dbo.CONTI.ANCODLIS " & _
                  "WHERE     (dbo.CONTI.ANTIPCON = '" & TipConto & "') AND (dbo.CONTI.ANCODICE= '" & CodConto & "') AND (dbo.TAB_LISTIN.TLDAT_DA <= CONVERT(DATETIME, " & _
                  "'" & Format(DataDoc, "yyyy-mm-dd") & " 00:00:00', 102)) AND (dbo.TAB_LISTIN.TLDAT_AL >= CONVERT(DATETIME, '" & Format(DataDoc, "yyyy-mm-dd") & " 00:00:00', 102)) AND  " & _
                  "(dbo.ART_LISTIN.TLCODART = '" & CodArt & "') " & _
                  "ORDER BY dbo.TAB_LISTIN.TLCODICE DESC"
   
   Else  'Mediatore
      strRicerca = "SELECT     dbo.TAB_LISTIN.TLCODICE, dbo.TAB_LISTIN.TLDAT_DA, dbo.TAB_LISTIN.TLDAT_AL, dbo.ART_LISTIN.TLCODART, dbo.ART_LISTIN.TLPRZLOR, dbo.ART_LISTIN.TLPRZNET , dbo.TAB_GEN.TGCHIAVE, dbo.TAB_GEN.TGCODICE " & _
                  "FROM         dbo.TAB_LISTIN INNER JOIN " & _
                  "dbo.ART_LISTIN ON dbo.TAB_LISTIN.TLCODICE = dbo.ART_LISTIN.TLLISTIN LEFT OUTER JOIN dbo.TAB_GEN ON dbo.TAB_LISTIN.TLCODICE = dbo.TAB_GEN.TGVALORE " & _
                  "WHERE     (dbo.TAB_GEN.TGCHIAVE = 'AGENTI') AND (dbo.TAB_GEN.TGCODICE= '" & CodMediatore & "') AND (dbo.TAB_LISTIN.TLDAT_DA <= CONVERT(DATETIME, " & _
                  "'" & Format(DataDoc, "yyyy-mm-dd") & " 00:00:00', 102)) AND (dbo.TAB_LISTIN.TLDAT_AL >= CONVERT(DATETIME, '" & Format(DataDoc, "yyyy-mm-dd") & " 00:00:00', 102)) AND  " & _
                  "(dbo.ART_LISTIN.TLCODART = '" & CodArt & "') " & _
                  "ORDER BY dbo.TAB_LISTIN.TLCODICE DESC"
   End If
   
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If Not RS.EOF Then
         
      VerificaListiniArticolo = True
      
      LabelCodListin = RS!TLCODICE
      
      If RS!TLPRZLOR > 0 Then 'PREZZO LORDO
         TextPrzLordo = RS!TLPRZLOR
      Else                    'PREZZO NETTO
         TextPrzNetto = RS!TLPRZNET
      End If
   
   End If

   RS.Close
   Set RS = Nothing
End Function

Public Function ConcatenaDesArtDoc(vSerial As Long) As String
'Questa funzione restituisce la concatenazione delle descrizioni delle varie righe presenti in un dato documento
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   strRicerca = "Select MVDESART from DOC_DETT WHERE MVSERIAL = " & vSerial & " ORDER BY CPROWNUM"
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If RS.EOF = False Then
      Do Until RS.EOF
         
         If Len(Trim(ConcatenaDesArtDoc)) = 0 Then
            ConcatenaDesArtDoc = RS!MVDESART
         Else
            ConcatenaDesArtDoc = ConcatenaDesArtDoc & " " & RS!MVDESART
         End If
         
         RS.MoveNext
      Loop
   End If
   RS.Close
   Set RS = Nothing
End Function


Public Function fFormAperti() As Integer
   'Questa funzione conta tutti i FORM con MDIChild = True aperti ed esclude l'MDI
   
   Dim vConta As Integer
   Dim Frm As Form
   
   On Error GoTo GestErr
   
   For Each Frm In Forms
      If Frm.Name <> MDIForm1.Name Then
         If Frm.MDIChild Then
            If Not ((Frm.Name = "SfondoForm") Or (Frm.Name = "FormWidget") Or (Frm.Name = "AlertForm")) Then
               vConta = vConta + 1
            End If
         End If
      End If
   Next Frm
   fFormAperti = vConta
'   For Each Frm In Forms
'      If Frm.Name <> MDIForm1.Name Then
'         If Frm.MDIChild = True Then
'            vConta = vConta + 1
'         End If
'      End If
'   Next Frm
'   fFormAperti = vConta
   
GestErr:
   If Err.Number <> 0 Then
      Resume Next
   End If
End Function


Public Sub SetLastDateAzzeramento()
   'questa sub legge dalla tabella MOV_AZZERA e prelva la prima data utile inferiore alla DataGestione _
    e la setta come data di INIZIO dei movimenti del periodo
   Dim RS As ADODB.Recordset
   Dim strRicerca As String

   strRicerca = "SELECT TOP 1 MADATAZZ FROM MOV_AZZERA " & _
                " WHERE MADATAZZ <= CONVERT(DATETIME, '" & Format(DataGestione, "yyyy-mm-dd") & " 00:00:00', 102) " & _
                " ORDER BY MADATAZZ DESC"
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneAzienda, adOpenStatic
   If RS.EOF = False Then
      gLastDataAzzeramento = RS!MADATAZZ
      gWhereDataAzzeramento = " AND (MVDATSEZ >= CONVERT(DATETIME, '" & Format(gLastDataAzzeramento, "yyyy-mm-dd") & " 00:00:00', 102)) "
   Else
      gLastDataAzzeramento = ""
      gWhereDataAzzeramento = ""
   End If
   RS.Close
   Set RS = Nothing

End Sub
