Attribute VB_Name = "ModuloPlaySound"
Option Explicit

Private gPathFile As String
Private gParameter2 As Boolean

Private Const SND_APPLICATION As Long = &H80
Private Const SND_ALIAS As Long = &H10000
Private Const SND_ALIAS_ID As Long = &H110000
Private Const SND_ASYNC As Long = &H1
Private Const SND_FILENAME As Long = &H20000
Private Const SND_LOOP As Long = &H8
Private Const SND_MEMORY As Long = &H4
Private Const SND_NODEFAULT As Long = &H2
Private Const SND_NOSTOP As Long = &H10
Private Const SND_NOWAIT As Long = &H2000
Private Const SND_PURGE As Long = &H40
Private Const SND_RESOURCE As Long = &H40004
Private Const SND_SYNC As Long = &H0


Declare Function PlaySound Lib "winmm" Alias "PlaySoundA" _
                            (ByVal szName As String, _
                             ByVal hModule As Long, _
                             ByVal dwFlags As Long) As Long

Private Declare Sub Sleep Lib "kernel32.dll" (ByVal dwMilliseconds As Long)



Sub Main()
   Dim vParameter() As String
   
   gPathFile = Command()
   gPathFile = Trim(gPathFile)
   
   
                        'gPathFile = "C:\ProgettiVB\PRIMO\Files\Sounds\Cassa\critical.wav|PRIMO"
   
   
   'Se il parametro arriva con il PIPE ("|") significa che  stato eseguito da PRIMO e pertanto NON faccio comparire la INPUTBOX. _
    Se invece l'array NON  inizializzato significa che l'eseguibile  stato lanciato a mano e pertanto richiedo il path del file in modo _
    da poter provare che file suoni regolarmente
   vParameter = Split(gPathFile, "|")
   
   
   If VerificaArrayInizializzato(vParameter) Then
      gPathFile = vParameter(0)
   Else
      'Se non c' PARAMETRO allora lo chiedo . . . ma solo se  stato eseguito a mano ;)
      gPathFile = InputBox("Indicare il file WAVE da riprodurre (pecorso completo)")
   End If
   
   
   
   If Len(gPathFile) > 0 Then
      
      Call EmettiSuono(gPathFile)
      
      Sleep 500 'Senza lo SLEEP non emetteva alcun suono

   Else
      
      Call MsgInLogFile("NESSUN PARAMETRO!", True)
   
   End If
   
End Sub



'szName   = indica il percorso del file (ci interessa solo questo per ora)
'hModule  = impostiamolo a 0 per ora
'dwFlags  = pu avere uno dei seguenti valori:
            'SND_SYNC = &H0 (predefinito) Il valore di ritorno di PlaySound verr restituito al termine dell'esecuzione del file, che non sar possibile interrompere.
            'SND_ASYNC = &H1 Il file viene eseguito in background, e il programma proseguir la sua esecuzione. Passando Null a szName alla prossima chiamata dell'API, si interrompe l'esecuzione.
            'SND_ALIAS = &H10000 szName contiene un alias di un suono usato per un evento di sistema (vedi sotto).
            'SND_FILENAME = &H20000 Il flag indica all'API che szName rappresenta il nome del percorso del file. Per ora includiamolo sempre, poi vedremo perch.
            'SND_MEMORY = &H4 szName  un puntatore alla locazione di memoria RAM in cui  stato caricato un file relativo ad un suono.
            'SND_RESOURCE = &H4004 secondo la documentazione serve a riprodurre un wave contenuto in un file di risorse (non  trattato nel seguito)
            'SND_LOOP = &H8 Il suono viene ripetuto continuamente, finch la funzione non viene richiamata passando Null a szName. Per utilizzare questo parametro,  necessario ovviamente abbinarlo ad SND_ASYNC.
            'SND_NODEFAULT = &H2 per non far eseguire il suono predefinito (quello dell'istruzione Beep) nel caso il file indicato non esista.
            'SND_NOSTOP = &H10 se un file sta suonando e si tenta di farne suonare un altro, quest'ultimo non viene suonato facendo continuare a suonare il primo (non  trattato nel seguito)
            'SND_NOWAIT = &H2000 Se un altro suono  gi in esecuzione, non attende che il driver sia libero e lo interrompe avviando il suono richiesto dalla chiamata
            'SND_PURGE = &H40 Arresta l'esecuzione di qualsiasi file. szName dovr essere passata come stringa vuota


'Altre info qui: http://www.visual-basic.it/articoli/fddAudio.htm


Private Sub EmettiSuono(pNomeFile As String)
   
   If VerificaEsistenzaFile(pNomeFile) = False Then
      Call MsgInLogFile("FILE NON TROVATO (" & pNomeFile & ")", True)
   End If
   
   Call PlaySound(pNomeFile, 0, SND_FILENAME Or SND_ASYNC)

End Sub



Private Sub MsgInLogFile(Msg As String, Optional pError As Boolean)
   Dim NumFile As Integer
   Dim vStrRec As String
   Dim vNomeFile As String

   On Error Resume Next

   If pError Then
      Msg = "ERROR *** " & Msg
   End If
   
   vNomeFile = "EventLog.cnf"


   NumFile = FreeFile

   'Apro il file LOG
   Open App.Path & "\" & vNomeFile For Append As #NumFile     'CREO IL FILE

      'Stampo il messaggio (la riga!)
      vStrRec = Format(Date, "yyyy/mm/dd") & "|" & _
                Format(Now, "hh:nn:ss") & "|"

      vStrRec = vStrRec & "|" & Replace(Msg, Chr(13) + Chr(10), "")
      vStrRec = vStrRec & "|"

      Print #NumFile, vStrRec
      '+{榦ӱ=53?+jV+uY}4A65?AGT6A ???

      'STRUTTURA STRINGA : _
      DATA SISTEMA | ORA SISTEMA | STRINGA | CARATTERE DI FINE RIGA ()

   'Chiudo il file di LOG
   Close #NumFile

   'Questa istuzione mi serve per azzerare eventuali errori che possono verificarsi. In particolarte quando il comando _
    arriva da una form Modale l'istruzione MDIForm1.ActiveForm.Name genera l'errore 91
   On Error GoTo 0

End Sub


Private Function VerificaEsistenzaFile(pPathFile As String) As Boolean
   Dim MyFile As String
            
   'restituisce una stringa vuota se la cartella non esiste
   MyFile = Dir(pPathFile, vbNormal)
   If Len(Trim(MyFile)) = 0 Then
      'Il file non esiste
      VerificaEsistenzaFile = False
   Else
      'Il file esiste
      VerificaEsistenzaFile = True
   End If

End Function


Public Function VerificaArrayInizializzato(v_Arr As Variant) As Boolean
   'Questa funzione mi restituisce TRUE se l'array  stato inizializzato
   On Local Error GoTo gesterr
   
   If (LBound(v_Arr) <= UBound(v_Arr)) Then VerificaArrayInizializzato = True

gesterr:
   
End Function

