Attribute VB_Name = "ModuloRegCasRCH"
Option Explicit


'Contiene i dati dell'ultimo scontrino stampato
Private Type mTypeLastRCHRequest
   errorCode As Integer
   'errorText As String
   printerError As Boolean 'Stampante in Errore (0 = FALSE // 1 = TRUE)
   paperEnd As Boolean 'Fine carta (0 = FALSE // 1 = TRUE)
   coverOpen As Boolean 'Coperchio Aperto (0 = FALSE // 1 = TRUE)
   'lastCmd As String 'questo elemento contiene il numero di sequenza dell'ultimo Comando eseguito
   ECRStatus_mode As String 'Chiave di stato
   ECRStatus_idleState As Byte 'Stato di transazione fiscale
   'ECRStatus_idleStateTxt As String 'Stato di transazione fiscale (TESTO)
                                 '( 0 = IDLE (inattiva) _
                                    1 = IN TRANSAZIONE FISCALE _
                                    2 = IN PAGAMENTO FISCALE _
                                    3 = IN INPUT ALFANUMERICO (es. doc. GESTIONALE e fattura libera) _
                                    4 = IN ATTESA CHIUSURA DOCUMENTO (es. messaggi fidelity) _
                                    5 = DOCUMENTO GESTIONALE APERTO )
   lastZ As String 'numero che indica il contatore dell'ultimo azzeramento fiscale
   lastDocF As String 'numero che indica il Progressivo dell'ultimo scontrino fiscale/documento commerciale (0= DOPO UNA CHIUSURA GIORNALIERA)
   lastDocNF As String 'numero che indica il Progressivo dell'ultimo documento non fiscale/gestionale
   lastCreditNoteN As String 'numero che indica il Progressivo delle note di credito
   lastInvoiceN As String 'numero che indica il Progressivo delle fatture
   busy As Boolean 'Stato di interfaccia web occupata (0 = FALSE // 1 = TRUE)
   
   'msgError As String
End Type
Public gtLastRCHRequest As mTypeLastRCHRequest

'Public Enum enumFuncRCH
''Codici Comandi richiesta dati
'   'rch_getdataora = 1001
'   rch_getMatricolaFiscale = 1008
'   rch_getStatoStampante = 1010
'   rch_getModelloRelease = 1013
'   rch_getCodiceERR = 1015
'   rch_getUltimoScontrino = 1017 'SOLO macchine 3 generazione
'   rch_getTipoFiscaleSiNo = 1020
'   rch_getStatoLogicoRT = 1511
'   rch_prnStatoFirmwareRT = 1512
'
'   rch_CheckStatus = 1109
'   rch_execChiusuraFiscale = 220201
'   rch_execAzzeramentoReparti = 220206
'   rch_execApriCassetto = 70081
'   rch_execResoAnnullo = 7101
'End Enum



Public Function RCHSendCommand(vIndirIP As String, vNumPort As String, NomeFunzione As String, pArrayCmd As Variant, prBuffer As String, _
                               Optional pPathFileXml As String, Optional pPathStorico As String, Optional pRetry As Boolean, _
                               Optional pCheckBefore As Boolean) As Boolean
   Dim vLink As String
   Dim vTestoMsg As String
      
   Dim Ans As String
   Dim oHTTP As MSXML2.XMLHTTP60, sBuffer As String
   Dim sStatusText As String
   Dim sStatus As Long
   Dim vrBusy As Boolean
   Dim vTentativi As Byte
   Dim commandXML As String
   
   
   On Error GoTo GestErr
   
   
   Call MsgRegCasInLogFile("[RCHSendCommand] - Start command: " & NomeFunzione & IIf(pCheckBefore, " - CHECK BEFORE", ""))


RetryQui:
   'If vrBusy Then vrBusy = False
   vTentativi = vTentativi + 1


   Call AzzeraLastRCHRequest
   
   
   'Apertura comunicazione con Service.cgi del Registratore ed invio COMANDO
      Set oHTTP = CreateObject("MSXML2.ServerXMLHTTP")
      oHTTP.Open "POST", "http://" & vIndirIP & "/service.cgi", False
      oHTTP.setRequestHeader "Content-Type", "application/xml"
         
         
         'costruisco il Body che contiene i comandi da inviare alla Cassa
            Dim objDom As DOMDocument60
            Dim obR As IXMLDOMElement
            Dim obM1 As IXMLDOMElement
            'Dim obM1A As IXMLDOMAttribute
            Dim i As Integer
            Dim quote As String  'per apici doppi in stringa
            Dim sign As String  'per carattere <
            
            quote = Chr$(34)
            sign = Chr$(60)
            
            Set objDom = New DOMDocument60
            
            'Se non c' il file allora leggo l'Array
            If Len(Trim(pPathFileXml)) = 0 Then
               Set obR = objDom.createElement("Service")
               objDom.appendChild obR
                  For i = 0 To UBound(pArrayCmd)
                     Set obM1 = objDom.createElement("cmd")
                     obR.appendChild obM1
                     obM1.Text = Replace(Replace(pArrayCmd(i), "<", sign), Chr(34), quote)
                  Next i
               'objDom.Save (NomeFile)
               'objDom.xml
               'RCH_CommandXml = objDom.xml
            Else
               'Qui significa che gli ho passato il path di un file xml gi strutturato con i comandi
               
               Dim retString As String
               retString = ReadFileConfigCommand(pPathFileXml)
                              
               If Len(retString) = 0 Then
                  Call MsgRegCasInLogFile("[RCHSendCommand] - ERROR command in Load file '" & pPathFileXml & "'", True)
                  
                  MsgBox "Errore in fase di Load file:" & vbNewLine & _
                         "'" & pPathFileXml & "'" & _
                         "", msg_Critical
               End If
            End If
            
            
            commandXML = IIf(Len(Trim(pPathFileXml)) = 0, objDom.xml, retString)
            oHTTP.send commandXML        'Invio nel BODY la sequenza di comandi XML da far elaborare
      
            Set obR = Nothing
            Set obM1 = Nothing
            'Set objDom = Nothing
                  
      sBuffer = oHTTP.responseText
      sStatusText = oHTTP.statusText
      sStatus = oHTTP.Status
      Set oHTTP = Nothing
   
   'Risposta RCH
      If sStatus = 200 Then
      
         Call MsgRegCasInLogFile("[RCHSendCommand] - ReadState: " & sBuffer)
         
         If RCH_ReadState(sBuffer, pRetry, vrBusy) Then
            
            prBuffer = sBuffer
            RCHSendCommand = True
            
            'Salvo in storico se previsto
            If Len(pPathStorico) > 0 Then
               objDom.Save (pPathStorico)
            End If
         
         Else
            
            'significa che  occupata e riprovo per due volte
            If vrBusy And pRetry Then
               If vTentativi < 2 Then
                  pRetry = False
                  Call MsgRegCasInLogFile("[RCHSendCommand] - ReadState: <OCCUPATA> (inizio secondo tentativo)")
                  Set objDom = Nothing
                  Call PausaProgramma(3)
                  GoTo RetryQui
               End If
            End If
         
         End If
            
      Else
         
         MsgBox "Messaggio dal Server:" & vbNewLine & _
                sBuffer & vbNewLine & _
                sStatus & " - " & sStatusText, msg_Critical
         
         Call MsgRegCasInLogFile("[RCHSendCommand] - ERROR command: " & sStatus & " - " & sStatusText, True)
         
      End If
            
      Set objDom = Nothing
      
      
GestErr:
   If err.Number <> 0 Then
      Dim vErrStr As String
      Dim vEMsgTimeout As String
      
      If err.Number = -2147012894 Then vEMsgTimeout = "PROBLEMI DI COMUNICAZIONE CON IL REGISTRATORE" & vbNewLine & "VERIFICARE SIA ACCESO E COLLEGATO ALLA RETE INTERNA"
      
      vErrStr = err.Number & " - " & err.Description
      Call MsgRegCasInLogFile("[RCHSendCommand] - " & vErrStr, True)
      
      MsgBox vEMsgTimeout & vbNewLine & vbNewLine & _
             vErrStr & vbNewLine & _
             "(RCHSendCommand)", vbCritical
   End If
   On Error GoTo 0
            
   Call MsgRegCasInLogFile("[RCHSendCommand] - End command: " & NomeFunzione)
      
End Function


Public Function RCH_ReadState(pStrXml As String, pRetry As Boolean, prBusy As Boolean) As Boolean
   Dim XmlDoc As New DOMDocument60
   'Dim nodlst As IXMLDOMNodeList
   'Dim wordNode As IXMLDOMNode
   'Dim vEsitoInError As Boolean
   Dim msgError As Boolean
   Dim errorText As String
   Dim txtErrSrv As String
      
   XmlDoc.async = False
   
   If XmlDoc.loadXML(pStrXml) Then
      'Call ExtractNodes(XmlDoc.childNodes, RCH_ReadState, pTag)
      
      'Dim DOM As New DOMDocument
      Dim nodes As IXMLDOMNodeList
      Dim Node As IXMLDOMNode
      Dim i As Byte

      'Set nodes = XmlDoc.selectNodes("//" & pTag)
      Set nodes = XmlDoc.selectNodes("//Request")
      'Set nodes = nodes(0).childNodes
      
      Dim vVal As String
      
      
      gtLastScontrino.StringaEsito = "Request >> " 'apre la stringa dell'esito
      
      
      txtErrSrv = "Verifica stato 'Connettivit -> Ethernet' in Funzioni di Servizio (5+Chiave)" & vbNewLine & _
                  "      - Protocollo PC = STANDARD" & vbNewLine & _
                  "      - Abilita Stati = NO" & vbNewLine & _
                  "      - Abilita ACK = SI" & vbNewLine & _
                  "      - Web Srv. Risp. Estesa = SI"
      
      
'====================== INIZIO 'CONTROLLO ERRORI' ======================
      If nodes(0).selectSingleNode("errorCode") Is Nothing Then
         errorText = "Risp. standard: parametro <errorCode> non presente!" & vbNewLine & vbNewLine & txtErrSrv
         gtLastScontrino.StringaEsito = errorText
         Call MsgRegCasInLogFile(gtLastScontrino.StringaEsito, True)
         msgError = True
         GoTo SaltaQui
      Else
         vVal = nodes(0).selectSingleNode("errorCode").Text
            If Not IsNumeric(Trim(vVal)) Then
               gtLastRCHRequest.errorCode = "0"
            Else
               gtLastRCHRequest.errorCode = Trim(vVal)
            End If
            If gtLastRCHRequest.errorCode <> 0 Then
               errorText = decod_RCH_errorCode(gtLastRCHRequest.errorCode)
               gtLastScontrino.StringaEsito = errorText & " (errorCode: " & Trim(vVal) & ")"
               Call MsgRegCasInLogFile(gtLastScontrino.StringaEsito, True)
               msgError = True
               GoTo SaltaQui
            End If
      End If
      
      
      If nodes(0).selectSingleNode("coverOpen") Is Nothing Then
         errorText = "Risp. standard: parametro <coverOpen> non presente!" & vbNewLine & vbNewLine & txtErrSrv
         gtLastScontrino.StringaEsito = errorText
         Call MsgRegCasInLogFile(gtLastScontrino.StringaEsito, True)
         msgError = True
         GoTo SaltaQui
      Else
         vVal = nodes(0).selectSingleNode("coverOpen").Text
            gtLastRCHRequest.coverOpen = (Trim(vVal) = "1")
            If gtLastRCHRequest.coverOpen Then
               errorText = "COPERCHIO APERTO"
               gtLastScontrino.StringaEsito = errorText
               Call MsgRegCasInLogFile(gtLastScontrino.StringaEsito, True)
               msgError = True
               GoTo SaltaQui
            End If
      End If
      
      
      If nodes(0).selectSingleNode("paperEnd") Is Nothing Then
         errorText = "Risp. standard: parametro <paperEnd> non presente!" & vbNewLine & vbNewLine & txtErrSrv
         gtLastScontrino.StringaEsito = errorText
         Call MsgRegCasInLogFile(gtLastScontrino.StringaEsito, True)
         msgError = True
         GoTo SaltaQui
      Else
         vVal = nodes(0).selectSingleNode("paperEnd").Text
            gtLastRCHRequest.paperEnd = (Trim(vVal) = "1")
            If gtLastRCHRequest.paperEnd Then
               errorText = "ASSENZA CARTA"
               gtLastScontrino.StringaEsito = errorText
               Call MsgRegCasInLogFile(gtLastScontrino.StringaEsito, True)
               msgError = True
               GoTo SaltaQui
            End If
      End If


      If nodes(0).selectSingleNode("busy") Is Nothing Then
         errorText = "Risp. standard: parametro <busy> non presente!" & vbNewLine & vbNewLine & txtErrSrv
         gtLastScontrino.StringaEsito = errorText
         Call MsgRegCasInLogFile(gtLastScontrino.StringaEsito, True)
         msgError = True
         GoTo SaltaQui
      Else
         vVal = nodes(0).selectSingleNode("busy").Text
            gtLastRCHRequest.busy = (Trim(vVal) = "1")
            prBusy = gtLastRCHRequest.busy
            If gtLastRCHRequest.busy Then
               errorText = "STAMPANTE OCCUPATA, RIPROVARE TRA UN PO'"
               gtLastScontrino.StringaEsito = errorText
               Call MsgRegCasInLogFile(gtLastScontrino.StringaEsito, True)
               msgError = True
               GoTo SaltaQui
            End If
      End If


      If nodes(0).selectSingleNode("ECRStatus") Is Nothing Then
         errorText = "Risp. standard: parametro <ECRStatus> non presente!" & vbNewLine & vbNewLine & txtErrSrv
         gtLastScontrino.StringaEsito = errorText
         Call MsgRegCasInLogFile(gtLastScontrino.StringaEsito, True)
         msgError = True
         GoTo SaltaQui
      Else
         vVal = nodes(0).selectSingleNode("ECRStatus").selectSingleNode("idleState").Text
            If Not IsNumeric(Trim(vVal)) Then
               gtLastRCHRequest.ECRStatus_idleState = "0"
            Else
               gtLastRCHRequest.ECRStatus_idleState = Trim(vVal)
            End If
            If gtLastRCHRequest.ECRStatus_idleState <> 0 Then
               errorText = decod_RCH_idleState(gtLastRCHRequest.ECRStatus_idleState)
               gtLastScontrino.StringaEsito = errorText & " (idleState: " & Trim(vVal) & ")"
               Call MsgRegCasInLogFile(gtLastScontrino.StringaEsito, True)
               msgError = True
               GoTo SaltaQui
            End If
      End If


      If nodes(0).selectSingleNode("printerError") Is Nothing Then
         errorText = "Risp. standard: parametro <printerError> non presente!" & vbNewLine & vbNewLine & txtErrSrv
         gtLastScontrino.StringaEsito = errorText
         Call MsgRegCasInLogFile(gtLastScontrino.StringaEsito, True)
         msgError = True
         GoTo SaltaQui
      Else
         vVal = nodes(0).selectSingleNode("printerError").Text
            gtLastRCHRequest.printerError = (Trim(vVal) = "1")
            If gtLastRCHRequest.printerError Then
               errorText = "STAMPANTE IN ERRORE"
               gtLastScontrino.StringaEsito = errorText & " (printerError: " & Trim(vVal) & ")"
               Call MsgRegCasInLogFile(gtLastScontrino.StringaEsito, True)
               msgError = True
               GoTo SaltaQui
            End If
      End If
'====================== FINE 'CONTROLLO ERRORI' ======================



'====================== INIZIO 'RECUPERO VALORI' ======================

      vVal = nodes(0).selectSingleNode("ECRStatus").selectSingleNode("mode").Text
            gtLastRCHRequest.ECRStatus_mode = Trim(vVal)
         gtLastScontrino.StringaEsito = gtLastScontrino.StringaEsito & "ECRStatus.mode:" & Trim(vVal) & "|"
            
      
      vVal = nodes(0).selectSingleNode("lastZ").Text
            gtLastRCHRequest.lastZ = Trim(vVal)
         gtLastScontrino.StringaEsito = gtLastScontrino.StringaEsito & "lastZ:" & Trim(vVal) & "|"
      
      
      vVal = nodes(0).selectSingleNode("lastDocF").Text
            gtLastRCHRequest.lastDocF = Trim(vVal)
         gtLastScontrino.StringaEsito = gtLastScontrino.StringaEsito & "lastDocF:" & Trim(vVal) & "|"
         gtLastScontrino.ProgFiscale = CLng(gtLastRCHRequest.lastDocF)
         
      
      vVal = nodes(0).selectSingleNode("lastDocNF").Text
            gtLastRCHRequest.lastDocNF = Trim(vVal)
         gtLastScontrino.StringaEsito = gtLastScontrino.StringaEsito & "lastDocNF:" & Trim(vVal) & "|"
      
      
      vVal = nodes(0).selectSingleNode("lastCreditNoteN").Text
            gtLastRCHRequest.lastCreditNoteN = Trim(vVal)
         gtLastScontrino.StringaEsito = gtLastScontrino.StringaEsito & "lastCreditNoteN:" & Trim(vVal) & "|"
      
      
      vVal = nodes(0).selectSingleNode("lastInvoiceN").Text
            gtLastRCHRequest.lastInvoiceN = Trim(vVal)
         gtLastScontrino.StringaEsito = gtLastScontrino.StringaEsito & "lastInvoiceN:" & Trim(vVal) & "|"
                              
'====================== FINE 'RECUPERO VALORI' ======================
                        
                        
SaltaQui:
                        
      'tronco a 255 (lunghezza massima del campo RTTXTOUT della tabella DOC_RT_INFO)
         gtLastScontrino.StringaEsito = Mid(gtLastScontrino.StringaEsito, 1, 255)
         
      
      Set nodes = Nothing
      Set XmlDoc = Nothing
   End If
   
   
   
   If Not (pRetry And prBusy) Then
         
      If msgError Then
         gtLastScontrino.ProgFiscale = -1 'in segno di ERRORE
      
         MsgBox gtLastScontrino.StringaEsito, msg_Critical
         Exit Function
      End If
   
      'Se rriva qui significa che non ci sono errori
      RCH_ReadState = True
   
   End If
   
End Function


Public Sub RCHGetVatTable(vIndirIP As String, vNumPort As String)
   Dim vResponse As String
   Dim pStrXml As String
   Dim vArrCmd() As String
   Dim strOut As String
       
   On Error GoTo GestErr
     
   
   'Preparo l'array con le istruzioni che formano l'XML
      Erase vArrCmd
      Call AddArrayElement(vArrCmd, "<</?C")

   
   'Invio il comando ed attendo la risposta
      vResponse = RCHSendCommand(vIndirIP, vNumPort, "GetVatTable", vArrCmd, pStrXml)
   
   
   'Leggo la Risposta
      If vResponse And (Len(Trim(pStrXml)) > 0) Then
      
         Dim XmlDoc As New DOMDocument60
         XmlDoc.async = False
   
         If XmlDoc.loadXML(pStrXml) Then
            Dim nodes As IXMLDOMNodeList
            Dim i As Byte

            Set nodes = XmlDoc.selectNodes("//Prg//VAT")
            'Ciclo solo sulle prime 6 (tanto al momento comunque ne uso al massimo 3)
            For i = 0 To nodes.Length - 1
               strOut = strOut & "Codice IVA " & nodes(i).Attributes(0).Text & ": Aliquota " & nodes(i).selectSingleNode("value").Text & vbNewLine
               If i = 5 Then Exit For
            Next
                        
            strOut = strOut & "  - - - ESENZIONI FISSE - - -" & vbNewLine
            strOut = strOut & "Codice IVA 0: IVA Esente (N4)" & vbNewLine
            strOut = strOut & "Codice IVA 8: Esclusa (N1)" & vbNewLine
            strOut = strOut & "Codice IVA 9: Non soggetta IVA (N2)" & vbNewLine
            strOut = strOut & "Codice IVA 10: Non imponibile (N3)" & vbNewLine
            strOut = strOut & "Codice IVA 11: Regime del margine (N5)" & vbNewLine
            strOut = strOut & "Codice IVA 12: Operazione non IVA (N6)"
                        
            Set nodes = Nothing
            
            
            MsgBox strOut, msg_Information, "Aliquote IVA presenti nel Registratore"
            
         End If
                     
         Set XmlDoc = Nothing
         
      End If
            
   
   
GestErr:
   If err.Number <> 0 Then
      MsgBox "ERRORE!" & vbNewLine & _
             err.Number & " - " & err.Description, msg_Critical
   End If
   On Error GoTo 0

End Sub


Public Sub RCHGetDepartment(vIndirIP As String, vNumPort As String)
   Dim vResponse As String
   Dim pStrXml As String
   Dim vArrCmd() As String
   Dim strOut As String
       
   On Error GoTo GestErr
     
   
   'Preparo l'array con le istruzioni che formano l'XML
      Erase vArrCmd
      Call AddArrayElement(vArrCmd, "<</?C")

   
   'Invio il comando ed attendo la risposta
      vResponse = RCHSendCommand(vIndirIP, vNumPort, "GetDepartment", vArrCmd, pStrXml)
   
   
      If vResponse And (Len(Trim(pStrXml)) > 0) Then
      
         Dim XmlDoc As New DOMDocument60
         XmlDoc.async = False
   
         If XmlDoc.loadXML(pStrXml) Then
            
            
'Leggo la Risposta (REPARTI) =======================================================
            Dim nodes As IXMLDOMNodeList
            Dim i As Byte

            Set nodes = XmlDoc.selectNodes("//Prg//Department")
            'Ciclo solo sulle prime 10 (tanto al momento comunque ne uso al massimo 7)
            For i = 0 To nodes.Length - 1
               strOut = strOut & "Reparto (" & nodes(i).Attributes(0).Text & ") " & nodes(i).selectSingleNode("txt").Text & ": Codice IVA " & nodes(i).selectSingleNode("vatCode").Text & vbNewLine
               If i = 9 Then Exit For
            Next

            Set nodes = Nothing
            MsgBox strOut, msg_Information, "Reparti presenti nel Registratore"
                              
                     
'Leggo la Risposta (PAGAMENTI) =======================================================
            Set nodes = XmlDoc.selectNodes("//Prg//Payment")
            'Ciclo solo sulle prime 10 (tanto al momento comunque ne uso al massimo 7)
            strOut = ""
            For i = 0 To nodes.Length - 1
               strOut = strOut & "Pagamento (" & nodes(i).Attributes(0).Text & ") " & nodes(i).selectSingleNode("txt").Text & _
                                 "  " & IIf(nodes(i).selectSingleNode("cash").Text = "0", " (Elettronico) ", " (Contanti) ") & vbNewLine
               If i = 3 Then Exit For
            Next
      
            Set nodes = Nothing
            MsgBox strOut, msg_Information, "Tipi Pagamenti presenti nel Registratore"
                                          
         End If
         Set XmlDoc = Nothing
      End If

   
GestErr:
   If err.Number <> 0 Then
      MsgBox "ERRORE!" & vbNewLine & _
             err.Number & " - " & err.Description, msg_Critical
   End If
   On Error GoTo 0

End Sub

'Public Sub RCHGetPayment(vIndirIP As String, vNumPort As String)
'   Dim vResponse As String
'   Dim pStrXml As String
'   Dim vArrCmd() As String
'   Dim strOut As String
'
'   On Error GoTo GestErr
'
'
'   'Preparo l'array con le istruzioni che formano l'XML
'      Erase vArrCmd
'      Call AddArrayElement(vArrCmd, "<</?C")
'
'
'   'Invio il comando ed attendo la risposta
'      vResponse = RCHSendCommand(vIndirIP, vNumPort, "GetPayment", vArrCmd, pStrXml)
'
'
'   'Leggo la Risposta
'      If vResponse And (Len(Trim(pStrXml)) > 0) Then
'
'         Dim XmlDoc As New DOMDocument60
'         XmlDoc.async = False
'
'         If XmlDoc.loadXML(pStrXml) Then
'            Dim nodes As IXMLDOMNodeList
'            Dim i As Byte
'
'            Set nodes = XmlDoc.selectNodes("//Prg//Payment")
'            'Ciclo solo sulle prime 10 (tanto al momento comunque ne uso al massimo 7)
'            For i = 0 To nodes.Length - 1
'               strOut = strOut & "Pagamento (" & nodes(i).Attributes(0).Text & ") " & nodes(i).selectSingleNode("txt").Text & vbNewLine & _
'                                 "           " & IIf(nodes(i).selectSingleNode("cash").Text = "0", " - Elettronico ", " - Contanti ") & vbNewLine
'               If i = 3 Then Exit For
'            Next
'
'            Set nodes = Nothing
'         End If
'
'         Set XmlDoc = Nothing
'      End If
'
'
'   MsgBox strOut, msg_Information, "Condizioni di Pagamento presenti nel Registratore"
'
'
'GestErr:
'   If err.Number <> 0 Then
'      MsgBox "ERRORE!" & vbNewLine & _
'             err.Number & " - " & err.Description, msg_Critical
'   End If
'   On Error GoTo 0
'
'End Sub



Public Sub AzzeraLastRCHRequest()
   gtLastRCHRequest.errorCode = 0
   'gtLastRCHRequest.errorText = ""
   gtLastRCHRequest.printerError = False
   gtLastRCHRequest.paperEnd = False
   gtLastRCHRequest.coverOpen = False
   'gtLastRCHRequest.lastCmd = ""
   
   gtLastRCHRequest.ECRStatus_mode = ""
   gtLastRCHRequest.ECRStatus_idleState = 0
   'gtLastRCHRequest.ECRStatus_idleStateTxt = ""
   
   gtLastRCHRequest.lastZ = ""
   gtLastRCHRequest.lastDocF = ""
   gtLastRCHRequest.lastDocNF = ""
   gtLastRCHRequest.lastCreditNoteN = ""
   gtLastRCHRequest.lastInvoiceN = ""
   
   gtLastRCHRequest.busy = False
   'gtLastRCHRequest.msgError = ""
End Sub

Public Function decod_RCH_idleState(idleState As Byte) As String
   Select Case idleState
      Case 1: decod_RCH_idleState = "TRANSAZIONE FISCALE IN CORSO (idle 1)"
      Case 2: decod_RCH_idleState = "PAGAMENTO FISCALE IN CORSO (idle 2)"
      Case 3: decod_RCH_idleState = "INPUT ALFANUMERICO IN CORSO (idle 3)"
      Case 4: decod_RCH_idleState = "IN ATTESA CHIUSURA DOCUMENTO (idle 4)"
      Case 5: decod_RCH_idleState = "DOCUMENTO GESTIONALE APERTO (idle 5)"
   End Select
End Function

Public Function decod_RCH_errorCode(errorCode As Integer) As String
   Dim vStrCode As String
   vStrCode = Trim(Str(errorCode))
   vStrCode = "E" & IIf(Len(vStrCode) = 1, "0" & vStrCode, vStrCode)
   
   Select Case errorCode
      Case 1: decod_RCH_errorCode = vStrCode & " - VALORE NON VALIDO (in caso di RESO accertarsi di non aver superato l'Importo disponibile)"
      Case 2: decod_RCH_errorCode = vStrCode & " - ERRORE NELLA PROCEDURA IN CORSO"
      Case 7: decod_RCH_errorCode = vStrCode & " - CODICE FISCALE ERRATO"
      Case 16: decod_RCH_errorCode = vStrCode & " - DOCUMENTO GIA' RESO/ANNULLATO"
      Case 20: decod_RCH_errorCode = vStrCode & " - SEQUENZA ERRATA"
      Case 21: decod_RCH_errorCode = vStrCode & " - OPERAZIONE NON AMMESSA"
      Case 24: decod_RCH_errorCode = vStrCode & " - IMPORTO OBBLIGATORIO"
      Case 25: decod_RCH_errorCode = vStrCode & " - SUBTOTALE OBBLIGATORIO"
      Case 40: decod_RCH_errorCode = vStrCode & " - SCONTRINO NEGATIVO"
      Case 45: decod_RCH_errorCode = vStrCode & " - RESTO NON AMMESSO"
      Case 52: decod_RCH_errorCode = vStrCode & " - DATI NON AZZERATI. OBBLIGATORIO ESEGUIRE UNA CHIUSURA"
      Case 60: decod_RCH_errorCode = vStrCode & " - FINE CARTA"
      Case 61: decod_RCH_errorCode = vStrCode & " - ERRORE TESTINA"
      Case 63: decod_RCH_errorCode = vStrCode & " - ERRORE STAMPANTE"
      Case 64: decod_RCH_errorCode = vStrCode & " - TESTINA SOLLEVATA (VERIFICARE ROTOLO CARTA)"
      Case 65: decod_RCH_errorCode = vStrCode & " - TAGLIERINA INCEPPATA"
      Case 90: decod_RCH_errorCode = vStrCode & " - ERRORE DI COMUNICAZIONE TRA STAMPANTE E PC"
      Case 91: decod_RCH_errorCode = vStrCode & " - ERRORE ETHERNET"
      Case 93: decod_RCH_errorCode = vStrCode & " - RT INATTIVO. ESEGUIRE CHIUSURA"
      Case 94: decod_RCH_errorCode = vStrCode & " - MANCATA CONNESSIONE CON IL SERVER / MANCATA RISPOSTA"
      'Case 100: decod_RCH_errorCode = vStrCode & " - ESEGUIRE CHIUSURA GIORNALIERA (ESEGUIRE CHIUSURA PRIMA DELLA MEZZANOTTE)" 'AL MOMENTO ABBIAMO DECISO DI NON GESTIRLO
      Case Else
         decod_RCH_errorCode = vStrCode & " - ERRORE GENERICO NON CODIFCATO."
   End Select
End Function

Public Function ReadFileConfigCommand(pFileCommand As String) As String
   Dim Data As String
   Dim output As String
   
   Open pFileCommand For Input As #1
   While Not EOF(1)
      Input #1, Data
      output = output & Data & vbCrLf
   Wend
   Close #1
   
   ReadFileConfigCommand = output
   
End Function


Public Sub RCHComandoDaCassa(pComando As String, Optional pPathFIleConf As String)
   'mi serve per comandare il reset della stampante in caso di errore di un documento
   Dim vFileSet As String
   Dim vFileName As String
   Dim vPathFIle4Conf As String
   Dim vInd_IP As String
   Dim vPORT As String
   
   On Error Resume Next
   
   If Len(Trim(pPathFIleConf)) > 0 Then
      vPathFIle4Conf = pPathFIleConf
   Else
      vPathFIle4Conf = mPathFileConf4Scontrino
   End If
   
   vInd_IP = ReadINI("RETE", "IP", vPathFIle4Conf)
   vPORT = ReadINI("RETE", "PORT", vPathFIle4Conf)
      
   If pComando = "ChiusuraFiscale" Then
      vFileSet = App.path & "\Files\RegCas\Custom\RCHCommand\cmdZReport.txt"
   ElseIf pComando = "Reset" Then
      vFileSet = App.path & "\Files\RegCas\Custom\RCHCommand\cmdResetPrinter.txt"
   End If
   
   'Se arriva qui ed  compilato il file di configurazione allora eseguo il comando di SET
   If Len(Trim(vFileSet)) > 0 Then
      If VerificaEsistenzaFile(vFileSet) Then
         Call RCHSendCommand(vInd_IP, vPORT, pComando, "", "", vFileSet)
            'MsgBox "Settaggio eseguito correttamente", msg_Confirmation
            Call VisualizzaMsgBoxPopUp("msg_ok", "", "Comando inviato", True)
         
      Else
         MsgBox "Impossibile trovare il file di configurazione:" & vbNewLine & _
                vFileSet, msg_Exclamation
      End If
   End If
End Sub
