Attribute VB_Name = "ModuloFatturazioneElettronica"
Option Explicit

'STATI CAMPO MVSTATFE DELLA TABELLA DOC_MAST
'------------------------------------------------------------------------------------------
'  0 = DA ELABORARE
'  1 = ESCLUSE DALL'UTENTE
'  2 = DA INVIARE AL SERVER
'  3 = INVIATO AL SERVER
'  4 = XML CREATO
'  5 = PRONTO PER L'INVIO ALLO SDI
'  6 = INVIATO ALLO SDI
'  7 = IN ATTESA DI COMPLETAMENTO
'  8 = INVIO COMPLETATO ALLO SDI
'------------------------------------------------------------------------------------------
'101 = CREDITO NON DISPONIBILE
'102 = ERRORE CREAZIONE XML
'103 = ERRORE INVIO ALLO SDI
'113 = ERRORE RICEVUTO -> VALIDATION ERROR DA ARXIVAR
'114 = ERRORE RICEVUTO DALLO SDI -> REJECTION_B2B (FLUSSO B2B - NOTIFICA DI SCARTO)
'115 = ERRORE RICEVUTO DALLO SDI -> SIGN_ERROR (ERRORE DI FIRMA)
'116 = LICENZA NON VALIDA O SCADUTA
'------------------------------------------------------------------------------------------
'201 = COMPLETATO (CON LICENZA 1 - SOLO XML)
'210 = COMPLETATO (CON LICENZA 2 - DELIVERY_RECEIPT_B2B (NOTIFICA DI RICEVUTA CONSEGNA)
'211 = COMPLETATO (CON LICENZA 2 - FAILED_RECEIPT_B2B (NOTIFICA DI IMPOSSIBILITA' RECAPITO)
'212 = COMPLETATO (CON LICENZA 2 - CONSERVATION_ERROR (ERRORE DI INVIO IN CONSERVAZIONE)


Public gModuloFatEleAttivo As Boolean


'E' l'ID dei Controlli (tasti) della ToolBar(4) delle Notifiche
Public Enum tb4FatEle
   ctFatErrOUT = 2
   ctFatOUT = 3
   '- - - - - - - -
   ctFatIN = 4
   ctFatErrIN = 5
   '- - - - - - - -
   ctCredito = 6
End Enum

'Public Const tb4FatOUT As Byte = 2 ' l'ID del Controllo della ToolBar 4 delle Notifiche
'Public Const tb4FatIN As Byte = 3 ' l'ID del Controllo della ToolBar 4 delle Notifiche

'Public Const tb4IconFatOUT_OFF As Byte = 100 ' l'ID del Controllo della ToolBar 4 delle Notifiche
'Public Const tb4IconFatOUT_WAIT As Byte = 101 ' l'ID del Controllo della ToolBar 4 delle Notifiche
'Public Const tb4IconFatOUT_WORK As Byte = 102 ' l'ID del Controllo della ToolBar 4 delle Notifiche
'Public Const tb4IconFatOUT_ERROR As Byte = 103 ' l'ID del Controllo della ToolBar 4 delle Notifiche
'Public Const tb4IconFatIN_OFF As Byte = 200 ' l'ID del Controllo della ToolBar 4 delle Notifiche
'Public Const tb4IconFatIN_WAIT As Byte = 201 ' l'ID del Controllo della ToolBar 4 delle Notifiche
'Public Const tb4IconFatIN_WORK As Byte = 202 ' l'ID del Controllo della ToolBar 4 delle Notifiche
'Public Const tb4IconFatIN_ERROR As Byte = 203 ' l'ID del Controllo della ToolBar 4 delle Notifiche

'Public Const tb4IconFat_OFF As Byte = 0 ' l'ID del Controllo della ToolBar 4 delle Notifiche
'Public Const tb4IconFat_WAIT As Byte = 1 ' l'ID del Controllo della ToolBar 4 delle Notifiche
'Public Const tb4IconFat_WORK As Byte = 2 ' l'ID del Controllo della ToolBar 4 delle Notifiche
'Public Const tb4IconFat_ERROR As Byte = 3 ' l'ID del Controllo della ToolBar 4 delle Notifiche

Public Enum tb4IconFE
   iconFatOFF = 0
   iconFatWAIT = 1
   iconFatWORK = 2
   iconFatERROR = 3
End Enum


Private Type typeFatEle
   fePrimaLetturaEseguita As Boolean
   feEseguiChekDoc As Boolean
   feEseguiRefreshFormATTIVI As Boolean 'se true esegue il refres della Griglia (Tab) nel caso sia aperta la FormFAT_ELE per i doc ATTIVI
   feEseguiRefreshFormPASSIVI As Boolean 'se true esegue il refres della Griglia (Tab) nel caso sia aperta la FormFAT_ELE per i doc PASSIVI
   feLastChekTimeCA As String 'Ciclo Attivo
   feLastChekTimeCP As String 'Ciclo Passivo
   feChekTimeCP As Integer 'Tempo di esecuzione per il Ciclo Passivo
   feFormATTIVEAperta As Boolean
   feFormPASSIVEAperta As Boolean
   feLicenza As Byte
   feCredito As Long
   'feDaRicevere As Long 'Numero delle Fatture Elettroniche in Ingresso
   'feDaInviare As Long
   feWhereDaTrasmettere As String
   feWhereWorking As String
   feWhereComplete As String
   feWhereInErrore As String
   feWhereEscluse As String
End Type
Public mtFatEle As typeFatEle


'Public Enum enumStatiFE
'   DELIVERY_RECEIPT_B2B = 0 'NOTIFICA DI RICEVUTA CONSEGNA (E' L'UNICO OK!)
'   FAILED_DELIVERY_B2B = 1 'NOTIFICA DI IMPOSSIBILITA' DI RECAPITO
'   REJECTION_B2B = 2 'NOTIFICA DI SCARTO
'   VALIDATION_ERROR = 3 'NOTIFICA DI RICEVUTA CONSEGNA
'   SIGN_ERROR = 4 'NOTIFICA DI RICEVUTA CONSEGNA
'   CONSERVATION_ERROR = 5 'NOTIFICA DI RICEVUTA CONSEGNA
'End Enum



Public Sub SetTypeFatEle()
''Prendo i valori primari della Fatturazione Elettronica che sono stati popolati _
' da PatchUpdater. Mi serve per avere un primo stato quando apro PRIMO _
' Quando poi aprio la Form di gestione delle Fatture allora riprendo i valori richiedendoli al server
   
   
   'Setto le frasi SQL per cercare i documenti nei vari stati e leggo i parametri dalla tabella NUM_CONN popolata da PatchUpdater
      If Not mtFatEle.fePrimaLetturaEseguita Then
         'Setto le frasi SQL per cercare i documenti nei vari stati
         Call SetStringWhereFE
   
         'LEggo dalla tabella popolata da PacthUpdater
            Dim RS As ADODB.Recordset
            Dim strRicerca As String
            
            strRicerca = "Select * from NUM_CONN"
            Set RS = New ADODB.Recordset
            RS.Open strRicerca, ConnessioneGenerale, adOpenStatic
            If Not RS.EOF Then
               mtFatEle.feCredito = RS!NCCREDITOFE
               mtFatEle.feLicenza = RS!NCSTATOFE
            End If
            RS.Close
            Set RS = Nothing
            
            'LO DEVO SEMPRE LANCIARE ANCHE SE LA LICENZA RISULTA SPENTA PERCHE' _
             POTREBBERO ESSERCI FATTURE INVIATE PRECEDENTEMNETE DI CUI BISOGNA AGGIORNARE LO STATO
            Call EseguiConnectorFE
            
            mtFatEle.fePrimaLetturaEseguita = True
      End If
      
      
      'Le volte successive alla PRIMA i dati vengono settati nella 'GetStatoFE'
      If mtFatEle.feLicenza > 0 Then
         Call ChangeTBStateFE(ctFatOUT, iconFatWAIT)
         If mtFatEle.feLicenza > 1 Then
            Call ChangeTBStateFE(ctFatIN, iconFatWAIT)
         End If
         
         Call ChangeTBStateFE(ctCredito, iconFatWAIT, mtFatEle.feCredito)
         MDIForm1.CommandBars(4).Controls(tb4FatEle.ctCredito).Visible = (mtFatEle.feLicenza > 1)
         
      Else
      
         Call ChangeTBStateFE(ctFatOUT, iconFatOFF)
         Call ChangeTBStateFE(ctFatIN, iconFatOFF)
         MDIForm1.CommandBars(4).Controls(tb4FatEle.ctCredito).Visible = False
         MDIForm1.CommandBars(4).Controls(tb4FatEle.ctFatErrOUT).Visible = False
         MDIForm1.CommandBars(4).Controls(tb4FatEle.ctFatErrIN).Visible = False
      End If
      
End Sub


Public Sub ChangeTBStateFE(pOutIn As tb4FatEle, pState As tb4IconFE, Optional pCredito As Long)
   'Cambio l'Icona delle Fatture Elettroniche
   
   Dim vVal As Integer
   
   
   If (pOutIn = tb4FatEle.ctFatErrOUT) Or (pOutIn = tb4FatEle.ctFatErrIN) Then
      'VISIBILE O NON VISIBILE (L'ICONA IN CAMBIA)
      MDIForm1.CommandBars(4).Controls(pOutIn).Visible = (pState = iconFatERROR)
   
   ElseIf pOutIn = tb4FatEle.ctCredito Then
      'SETTO IL VALORE DEL CREDITO
      MDIForm1.CommandBars(4).Controls(pOutIn).Caption = pCredito
      
   Else
      'CAMBIO LE ICONE DI INGRESSO E USCITA
      If pOutIn = tb4FatEle.ctFatOUT Then
         vVal = 20100
      Else
         vVal = 20200
      End If
      vVal = vVal + pState
      
      MDIForm1.CommandBars(4).Controls(pOutIn).IconId = vVal
   End If
   
End Sub


Public Function CheckTBInErrorFE(pOutIn As tb4FatEle) As Boolean
   'Verifico se l'icona della Toolbar indica che ci sono errori da segnalare
   Dim vVal As Integer
   
   If pOutIn = tb4FatEle.ctFatOUT Then
      'per le OUT controllo se  visibile l'icone degli ERRORI
      CheckTBInErrorFE = (MDIForm1.CommandBars(4).Controls(tb4FatEle.ctFatErrOUT).Visible)
      Exit Function
      
   ElseIf pOutIn = tb4FatEle.ctFatIN Then
      'per le IN controllo se  visibile l'icone degli ERRORI
      CheckTBInErrorFE = (MDIForm1.CommandBars(4).Controls(tb4FatEle.ctFatErrIN).Visible)
      Exit Function
      
   Else
      'vVal = 20200
   End If
   vVal = vVal + tb4IconFE.iconFatERROR
   
   CheckTBInErrorFE = (MDIForm1.CommandBars(4).Controls(pOutIn).IconId = vVal)
End Function


'Public Sub GetStatoFatEle()
''Prendo i valori primari della Fatturazione Elettronica che sono stati popolati _
' da PatchUpdater. Mi serve per avere un primo stato quando apro PRIMO
'
''Qui prendo lo Stato della Licenza della FE che pu essere: _
'   0 = Disabilitata _
'   1 = Abilitata solo XML _
'   2 = Abilitata Sdi (completa) _
' inoltre prendo il Credito
'
'
'   Dim vLink As String
'
'   On Error GoTo GestErr
'
'   'QUI COMANDO LA CANCELLAZIONE DELLA COMPANY SUL SERVER NOVISOFT
'
'   'Setto l'inizio della stringa
'      If Not AppParam.gInTEST Then    'PRODUZIONE
'         vLink = "https://be.primosoftware.it/E-Billing/credit/primo"
'      Else                 'TEST
'         vLink = "https://test.be.primosoftware.it/E-Billing/credit/primo"
'      End If
'
'   'Aggancio il Codice Cliente (Identificativo ns Cliente)
'      vLink = vLink & "/" & pCodice & "/" & pCodice 'Ripetuto il COdice in previsione di Company e Division
'
'
'      'Faccio la chiamata
'         Dim sBuffer As String
'         Dim srStatusCode As Long
'         Dim srStatusText As String
'         sBuffer = ServerCALL("GET", vLink, srStatusCode, srStatusText)
'
'
'      'Gestisco la risposta
'         If srStatusCode = 200 Then
'
'            'Significa che  tutto OK
'               Dim vArr() As String
'               vArr = Split(sBuffer, ";") 'Esempio di risposta: "2;186;" -> dove '2'  tipo di licenza a '186'  il Credito residuo di FE da poter gestire sia in ingresso che Uscita
'            'Stato
'               If IsNumeric(vArr(0)) Then
'                  mtFatEle.feLicenza = CByte(vArr(0))
'               End If
'            'Credito
'               If IsNumeric(vArr(1)) Then
'                  mtFatEle.feCredito = CByte(vArr(1))
'               End If
'
'         Else
'            'Registro nel log
'               Call MsgInLogFile("Status 'FE': " & sBuffer & " (Tipo Licenza; Credito)", "GetStatoFatEle", True)
'         End If
'
'
'GestErr:
'   If err.Number <> 0 Then
'      Dim vTxtErr As String
'      vTxtErr = err.Number & " - " & err.Description
'      Call MsgInLogFile(vTxtErr, "PutNumDoc", True)
'   End If
'   On Error GoTo 0
'
'
'End Sub

'Public Function GetTextStatoFE(pStato As enumStatiFE) As String
'   'questa funzione restituisce il testo degli stati possibili che _
'    possiamo ricevre dalo SdI (Arxivar nello specifico) che , poi, _
'    il valore contenuto nel campo MVSTASDI della DOC_MAST
'
'   Select Case pStato
'      Case DELIVERY_RECEIPT_B2B: GetTextStatoFE = "DELIVERY_RECEIPT_B2B" '= 0 'NOTIFICA DI RICEVUTA CONSEGNA (E' L'UNICO OK!)
'      Case FAILED_DELIVERY_B2B: GetTextStatoFE = "FAILED_DELIVERY_B2B" ' = 1 'NOTIFICA DI IMPOSSIBILITA' DI RECAPITO
'      Case REJECTION_B2B: GetTextStatoFE = "REJECTION_B2B" ' = 2 'NOTIFICA DI SCARTO
'      Case VALIDATION_ERROR: GetTextStatoFE = "VALIDATION_ERROR" ' = 3 'NOTIFICA DI RICEVUTA CONSEGNA
'      Case SIGN_ERROR: GetTextStatoFE = "SIGN_ERROR" ' = 4 'NOTIFICA DI RICEVUTA CONSEGNA
'      Case CONSERVATION_ERROR: GetTextStatoFE = "CONSERVATION_ERROR" ' = 5 'NOTIFICA DI RICEVUTA CONSEGNA
'   End Select
'
'End Function

   
Public Sub SetStringWhereFE()
   'DA INVIARE
      mtFatEle.feWhereDaTrasmettere = " WHERE (TDFLFATE = 1 ) " & _
                                      "   AND (ANFLESFE = 0 ) " & _
                                      "   AND (MVSTATFE = 0) "

   'COMPLETE
      mtFatEle.feWhereComplete = " WHERE (MVSTATFE > 200)"
   'INCOMPLETE
      mtFatEle.feWhereWorking = " WHERE ((MVSTATFE >= 2) AND (MVSTATFE < 100)) "
   'IN ERRORE
      mtFatEle.feWhereInErrore = " WHERE ((MVSTATFE > 100) AND (MVSTATFE < 200))"
   'ESCLUSE
      mtFatEle.feWhereEscluse = " WHERE (MVSTATFE = 1) "
End Sub

Public Sub ChechFECicloAttivo()
   Dim RS As ADODB.Recordset
   Dim strRicerca As String
   Dim vExit As Boolean
   Dim vEseguiCheck As Boolean
   
   
   On Error GoTo GestErr


   If Not IsDate(mtFatEle.feLastChekTimeCA) Then
      vEseguiCheck = True
   ElseIf DateDiff("s", mtFatEle.feLastChekTimeCA, Now) >= 300 Then  '300 sec = 5 min
      vEseguiCheck = True
   End If

   If vEseguiCheck Then
      'Cerco prima eventuali ERRORI
         strRicerca = " SELECT TOP 1 MVSERIAL " & _
                      "   FROM [" & Azienda & "DOC_MAST] " & _
                      mtFatEle.feWhereInErrore
         Set RS = New ADODB.Recordset
         RS.Open strRicerca, ConnessioneGenerale, adOpenStatic
         If Not RS.EOF Then
            If RS!MVSerial > 0 Then
               Call ChangeTBStateFE(ctFatErrOUT, iconFatERROR) ' VISUALIZZO l'ICONA 'ERROR'
               Call ChangeTBStateFE(ctFatOUT, iconFatWORK) 'l'ICONA 'OUT' LA METTO IN LAVORAZIONE
               vExit = True
            End If
         Else
            Call ChangeTBStateFE(ctFatErrOUT, iconFatOFF) ' NASCONDO l'ICONA 'ERROR'
         End If
         RS.Close
         Set RS = Nothing
      
      mtFatEle.feLastChekTimeCA = Now
   
   Else
      'Controllo che non stia gi in stato ERRORE
      vExit = CheckTBInErrorFE(ctFatOUT)
   End If


   If vExit Then Exit Sub
      
      
      If mtFatEle.feEseguiChekDoc Then
      
         'se arriva qui cerco DA INVIARE
         strRicerca = "SELECT TOP 1 MVSERIAL " & _
                      "  FROM ([" & Azienda & "DOC_MAST] INNER JOIN [" & Azienda & "TIP_DOC] ON ([" & Azienda & "DOC_MAST].MVFLVEAC = [" & Azienda & "TIP_DOC].TDFLVEAC) AND ([" & Azienda & "DOC_MAST].MVTIPDOC = [" & Azienda & "TIP_DOC].TDTIPDOC)) " & _
                      "       INNER JOIN [" & Azienda & "CONTI] ON ([" & Azienda & "DOC_MAST].MVCODCON = [" & Azienda & "CONTI].ANCODICE) AND ([" & Azienda & "DOC_MAST].MVTIPCON = [" & Azienda & "CONTI].ANTIPCON) " & _
                      mtFatEle.feWhereDaTrasmettere
         Set RS = New ADODB.Recordset
         RS.Open strRicerca, ConnessioneGenerale, adOpenStatic
         If Not RS.EOF Then
            If RS!MVSerial > 0 Then
               Call ChangeTBStateFE(ctFatOUT, iconFatWORK)
            End If
         Else
            If mtFatEle.feLicenza > 0 Then
               Call ChangeTBStateFE(ctFatOUT, iconFatWAIT)
            Else
               Call ChangeTBStateFE(ctFatOUT, iconFatOFF)
            End If
         End If
         RS.Close
         Set RS = Nothing
   
         mtFatEle.feEseguiChekDoc = False
      End If
   
   
GestErr:
   If err.Number <> 0 Then
      MsgBox err.Number & " - " & err.Description, msg_Critical
   End If
   On Error GoTo 0
End Sub


Public Sub ChechFECicloPassivo()
   Dim RS As ADODB.Recordset
   Dim strRicerca As String
   Dim vExit As Boolean
   Dim vEseguiCheck As Boolean
   
   
   On Error GoTo GestErr


   If Not IsDate(mtFatEle.feLastChekTimeCP) Then
      vEseguiCheck = True
      mtFatEle.feChekTimeCP = 180 'la prima volta (o tutte le volte che viene svuotato) imposto la ripetizione dopo 3 minuti cos in avvio se vengono scaricati documenti vengono evidenziati subito
   ElseIf DateDiff("s", mtFatEle.feLastChekTimeCP, Now) >= mtFatEle.feChekTimeCP Then  '1800 sec = 30 min
      vEseguiCheck = True
      mtFatEle.feChekTimeCP = 1800 ' dalla volta successiva imposto il controllo a 30 minuti
   End If

   If vEseguiCheck Then
      
      'Mi collego all'ambiente
         Call ApriConnessioneConnectFE
   
         'Cerco eventuali documenti nuovi da Notificare
            strRicerca = " SELECT TOP 1 F_WebSerial " & _
                         "   FROM [WEB_INVOICEIN] " & _
                         "  WHERE F_Show = 0"
            Set RS = New ADODB.Recordset
            RS.Open strRicerca, ConnDbConnectFE, adOpenStatic
            If Not RS.EOF Then
               Call ChangeTBStateFE(ctFatIN, iconFatWORK) 'MOSTRO L'ICONA CHE CI SONO DOC ARRIVATI NON VISTI
            Else
               Call ChangeTBStateFE(ctFatIN, iconFatWAIT) 'MOSTRO L'ICONA DI ATTESA (NON CI SONO NUOVI DOC ARRIVATI - NON VISTI)
            End If
            RS.Close
            Set RS = Nothing
         
      'Mi scollego all'ambiente
         Call ChiudiConnessioneConnectFE
         
      mtFatEle.feLastChekTimeCP = Now
   
   'Else
   '   'Controllo che non stia gi in stato ERRORE
   '   vExit = CheckTBInErrorFE(ctFatOUT)
   End If

   
GestErr:
   If err.Number <> 0 Then
      MsgBox err.Number & " - " & err.Description, msg_Critical
   End If
   On Error GoTo 0
End Sub


Public Function CheckFEUnlock(pCodStato As Byte) As Boolean
   'Questa funzione restituisce TRUE se la Fattura  modificabile _
    in base al Codice stato passato nel parametro
   
   Select Case pCodStato
      Case 0, 1, 101, 102, 113, 114, 115, 116, 201
         CheckFEUnlock = True
   End Select
End Function
Public Function CheckFEDelivering(pCodStato As Byte) As Boolean
   'Questa funzione restituisce TRUE se la Fattura  in Consegna allo SdI _
    in base al Codice stato passato nel parametro
   
   Select Case pCodStato
      Case 5, 6, 7, 8
         CheckFEDelivering = True
         'prDelivering = (pCodStato > 4)
   End Select
End Function
Public Function CheckFECompleted(pCodStato As Byte, Optional prXml As Boolean, Optional prDeliveryOK As Boolean) As Boolean
   'Questa funzione restituisce TRUE se la Fattura  COMPLETATO _
    in base al Codice stato passato nel parametro _
    Nel parametro di ritorno prXml passo TRUE se il codice  201 (completato per Licenza 1)
   
   Select Case pCodStato
      'Case 201, 210, 211, 212
      Case 201 To 255
         CheckFECompleted = True
         prXml = (pCodStato = 201)
         prDeliveryOK = (pCodStato = 210) 'significa che  stato consegnato con successo
   End Select
End Function
Public Function CheckFEInError(pCodStato As Byte, Optional prXml As Boolean) As Boolean
   'Questa funzione restituisce TRUE se la Fattura  in ERRORE _
    in base al Codice stato passato nel parametro _
    Nel parametro di ritorno prXml passo TRUE se il codice  101 (completato per Licenza 1)
   Select Case pCodStato
      Case 101 To 199
         CheckFEInError = True
         prXml = (pCodStato = 102)
   End Select
End Function


Public Sub CheckFEDoc(pCodStato As Byte, _
                      Optional prUnlock As Boolean, Optional prCompleted As Boolean, Optional prInError As Boolean, _
                      Optional prXml As Boolean, Optional prDelivering As Boolean, Optional prDeliveryOK As Boolean)
   'Questa funzione restituisce TRUE se la Fattura  in ERRORE _
    in base al Codice stato passato nel parametro _
    Nel parametro di ritorno prXml passo TRUE se il codice  101 (completato per Licenza 1)
   
   prUnlock = CheckFEUnlock(pCodStato)
   
   prCompleted = CheckFECompleted(pCodStato, prXml, prDeliveryOK)
   If prCompleted Then
      prInError = False
   Else
      prDelivering = CheckFEDelivering(pCodStato)
      prInError = CheckFEInError(pCodStato, prXml)
   End If
End Sub



Public Function GetStatoFE(Optional pCodClienteUFF As String) As Long 'Stato fatturazione Elettronica
   'Questa routine serve per sapere il credito e lo stato di FE del cliente
   'PS: Per PrimoUFFICIO se nel parametro passo un codice allora devo ricercare per il cliente specifico
   
   Dim vLink As String
   Dim mCreditoFE As Long
   Dim mStatoFE As Byte '0=Disattivo /1=Attivo solo XML /2=Attivo SdI (completo)
   Dim mPerUfficio As Boolean
   
   
   On Error GoTo GestErr

   
      mPerUfficio = (Len(pCodClienteUFF) > 0)


   'Setto l'inizio della stringa
      If Not AppParam.gInTEST Then    'PRODUZIONE
         'vLink = "https://be.primosoftware.it/company/licence_end_date/primo"
         vLink = "https://be.primosoftware.it/E-Billing/credit/primo"
      Else                 'TEST
         'vLink = "https://test.be.primosoftware.it/company/licence_end_date/primo"
         vLink = "https://test.be.primosoftware.it/E-Billing/credit/primo"
      End If

   'Aggancio il Codice Cliente (Identificativo ns Cliente)
      If Len(pCodClienteUFF) > 0 Then
         vLink = vLink & "/" & pCodClienteUFF & "/" & pCodClienteUFF 'Ripetuto il COdice in previsione di Company e Division
      Else
         vLink = vLink & "/" & AppParam.gIDNovisoft & "/" & AppParam.gIDNovisoft 'Ripetuto il COdice in previsione di Company e Division
      End If
      
   
   'Faccio la chiamata
      Dim sBuffer As String
      Dim srStatusCode As Long
      Dim srStatusText As String
      sBuffer = ServerCALL("GET", vLink, srStatusCode, srStatusText)
   
   
   'Gestisco la risposta
      If srStatusCode <> 200 Then '-> corrisponde a srStatusText = "OK"
         
         'If Not mPerUfficio Then
            'signifca che c' stato un errore e lo registro nel log
            'Call MsgInLogFile("Status 'FE': Errore! - (" & srStatusCode & " - " & srStatusText & ")", "GetStatoFE", True)
            Call MsgProcedureInLogFile("Status 'FE': Errore! - (" & srStatusCode & " - " & srStatusText & ")", "CONNECTORFE", True)
            
            MsgBox "Status 'FE': Errore! - (" & srStatusCode & " - " & srStatusText & ")", msg_Critical
            
         'End If
         
      Else
      
         'Significa che  tutto OK
            Dim vArr() As String
            vArr = Split(sBuffer, ";") 'Esempio di risposta: "2;186;" -> dove '2'  tipo di licenza a '186'  il Credito residuo di FE da poter gestire sia in ingresso che Uscita
                  
         'Stato
            If IsNumeric(vArr(0)) Then
               mStatoFE = CByte(vArr(0))
            End If
         
         'Credito
            If IsNumeric(vArr(1)) Then
               mCreditoFE = CLng(vArr(1))
            End If
            
            
            If mPerUfficio Then
               GetStatoFE = mCreditoFE
            Else
               'Call MsgInLogFile("Status 'FE': " & sBuffer & " (Tipo Licenza; Credito)", "GetStatoFE")
               'Aggiorno la tabella NUMCON
               Call UpdateStatoFE(mStatoFE, mCreditoFE)
            End If
         
         
         Call MsgProcedureInLogFile("LICENZA: " & mStatoFE & "  -  CREDITO: " & mCreditoFE, "CONNECTORFE")
         
         
      End If
      
      
      If AppParam.gInTEST Then    'TEST
         Call MsgProcedureInLogFile(vLink, "CONNECTORFE")
      End If
      
      
GestErr:
   If err.Number <> 0 Then
      Dim vTxtErr As String
      vTxtErr = err.Number & " - " & err.Description
      Call MsgInLogFile(vTxtErr, "GetLicense", True)
   End If
   On Error GoTo 0
End Function

Private Function UpdateStatoFE(mStatoFE As Byte, mCreditoFE As Long)
   'Dim vTentativo As Byte
   
   On Error GoTo GestErr
      
   mtFatEle.feCredito = mCreditoFE
   mtFatEle.feLicenza = mStatoFE
   
   
   '*** NON mi interessa se non riesco ad aggiornare la tabella perch nel programma
   '    faccio riferiemtno ai valori del Type mtFatEle

'RipetiUpdate:
   'EseguiSQLMDB "UPDATE NUM_CONN SET NCSTATOFE = " & mStatoFE & ", NCCREDITOFE = " & mCreditoFE & " "
   
GestErr:
   If err.Number <> 0 Then
      'NON mi interessa se non riesco ad aggiornare la tabella perch nel programma _
       faccio riferiemtno ai valori del Type mtFatEle
   
      'vTentativo = vTentativo + 1
      
      'al momento non faccio nulla e ripeto cinque volte l'update
      'If vTentativo < 5 Then
      '   Sleep 200
      '   GoTo RipetiUpdate
      'End If
   End If
   On Error GoTo 0
End Function


Public Function CheckDatiAziendaPerFE() As Boolean
   Dim RS As ADODB.Recordset
   Dim strRicerca As String
   Dim vStrCampi As String
   
   On Error GoTo GestErr
                             
   'Qui verifico i dati proncipalei che servono per eseguire un invio di 'FE'
      strRicerca = "SELECT * FROM ANA_AZIENDE WHERE AZCODAZI = '" & Azienda & "'"
      Set RS = New ADODB.Recordset
      RS.Open strRicerca, ConnessioneGenerale, adOpenStatic
      If Not RS.EOF Then
         If Len(Trim(NonNullo(RS!AZRAGAZI))) = 0 Then vStrCampi = "- RAGIONE SOCIALE"
         If Len(Trim(NonNullo(RS!AZINDAZI))) = 0 Then vStrCampi = vStrCampi & vbNewLine & "- INDIRIZZO"
         If Len(Trim(NonNullo(RS!AZLOCAZI))) = 0 Then vStrCampi = vStrCampi & vbNewLine & "- CITTA'"
         If Len(Trim(NonNullo(RS!AZCAPAZI))) = 0 Then vStrCampi = vStrCampi & vbNewLine & "- CAP"
         If Len(Trim(NonNullo(RS!AZPROAZI))) = 0 Then vStrCampi = vStrCampi & vbNewLine & "- PROVINCIA"
         If (Len(Trim(NonNullo(RS!AZPIVAZI))) = 0) And _
            (Len(Trim(NonNullo(RS!AZCODFISAZI))) = 0) Then vStrCampi = vStrCampi & vbNewLine & "- P.IVA/COD. FISC. (ALMENO UN CAMPO)"
         If Len(Trim(NonNullo(RS!AZNAZAZI))) = 0 Then vStrCampi = vStrCampi & vbNewLine & "- NAZIONE (SEDE LEGALE)"
         If Len(Trim(NonNullo(RS!AZNAZFIS))) = 0 Then vStrCampi = vStrCampi & vbNewLine & "- NAZIONE (FISCALE)"
         If Len(Trim(NonNullo(RS!AZREGFIS))) = 0 Then vStrCampi = vStrCampi & vbNewLine & "- REGIME FISCALE"
      End If
      RS.Close
      Set RS = Nothing
      
      If Len(vStrCampi) > 0 Then
         MsgBox "" & _
                "PER ESEGUIRE CORRETTAMENTE L'INVIO DELLE FATTURE ELETTRONICHE " & _
                "E' NECESSARIO COMPILARE I SEGUENTI CAMPI NEI 'DATI AZIENDA':" & vbNewLine & _
                vStrCampi, msg_Exclamation
      Else
         CheckDatiAziendaPerFE = True
      End If
   
GestErr:
   If err.Number <> 0 Then
      MsgBox err.Number & " - " & err.Description & vbNewLine & _
             "(Verifica DatiAzienda)", msg_Critical
   End If
   On Error GoTo 0
End Function


Public Function DecodStatoDaSdI(pTestoStato As String) As String
'Qui aggiungo un minimo di descrizione sullo Stato ricevuto dallo SdI
   Dim vTesto As String

'101 = CREDITO NON DISPONIBILE
'102 = ERRORE CREAZIONE XML
'103 = ERRORE INVIO ALLO SDI
'113 = ERRORE RICEVUTO -> VALIDATION ERROR DA ARXIVAR
'114 = ERRORE RICEVUTO DALLO SDI -> REJECTION_B2B (FLUSSO B2B - NOTIFICA DI SCARTO)
'115 = ERRORE RICEVUTO DALLO SDI -> SIGN_ERROR (ERRORE DI FIRMA)
'116 = LICENZA NON VALIDA O SCADUTA
'------------------------------------------------------------------------------------------
'201 = COMPLETATO (CON LICENZA 1 - SOLO XML)
'210 = COMPLETATO (CON LICENZA 2 - DELIVERY_RECEIPT_B2B (NOTIFICA DI RICEVUTA CONSEGNA)
'211 = COMPLETATO (CON LICENZA 2 - FAILED_RECEIPT_B2B (NOTIFICA DI IMPOSSIBILITA' RECAPITO)
'212 = COMPLETATO (CON LICENZA 2 - CONSERVATION_ERROR (ERRORE DI INVIO IN CONSERVAZIONE)

'Stati Aruba -> Stato Arxivar
'"Errore Elaborazione" -> VALIDATION_ERROR
'"Scartata" -> REJECTION_B2B
'"Rifiutata" -> REJECTION_B2B
'"Non Consegnata" -> FAILED_DELIVERY_B2B
'"Recapito Impossibile" -> FAILED_DELIVERY_B2B
'"Decorrenza Termini" -> DEADLINE_PASSED_PA
'"Consegnata" -> DELIVERY_RECEIPT_B2B
'"Accettata" -> DELIVERY_RECEIPT_B2B

'Errore Elaborazione 'Si  verificato un errore nellelaborazione della fattura (Problema tecnico nell' invio allo SDI).
'Inviata 'La fattura  stata inviata al Sistema di Interscambio (SDI).
'Scartata 'La fattura  stata rifiutata dal Sistema di Interscambio (SDI) che ha restituito un codice di errore specifico.
'Non Consegnata 'La consegna della fattura da parte del Sistema di Interscambio (SDI)  fallita. Solo per le PA, verranno fatti ulteriori tentativi di consegna nei 10 giorni seguenti.
'Recapito Impossibile 'La consegna della fattura da parte del Sistema di Intercambio (SDI) non  andata a buon fine. Non verranno effettuati ulteriori tentativi di consegna.
'Consegnata 'La fattura  stata consegnata da parte del Sistema di Interscambio (SDI).
'Accettata 'Il cliente ha accettato la fattura consegnata dal Sistema di Interscambio (SDI).
'Rifiutata 'Il cliente ha rifiutato fa fattura consegnata dal Sistema di Interscambio (SDI).
'Decorrenza Termini 'La fattura  stata consegnata da parte del sistema di Interscambio (SDI) ma il cliente non ha inoltrato alcuna risposta nei 15 successivi alla consegna.

   Select Case pTestoStato
      Case "DELIVERY_RECEIPT_B2B": vTesto = pTestoStato & vbNewLine & String(50, "-") & vbNewLine & "La fattura  stata consegnata da parte del Sistema di Interscambio (SDI)"
      Case "FAILED_RECEIPT_B2B": vTesto = pTestoStato & vbNewLine & String(50, "-") & vbNewLine & "La consegna della fattura da parte del Sistema di Interscambio (SDI)  fallita"
      Case "REJECTION_B2B": vTesto = pTestoStato & vbNewLine & String(50, "-") & vbNewLine & "La fattura  stata rifiutata dal Sistema di Interscambio (SDI) che ha restituito un codice di errore specifico"
      Case "VALIDATION_ERROR": vTesto = pTestoStato & vbNewLine & String(50, "-") & vbNewLine & "Si  verificato un errore nellelaborazione della fattura per un problema tecnico nell'invio allo SDI"
      Case "FAILED_DELIVERY_B2B": vTesto = pTestoStato & vbNewLine & String(50, "-") & vbNewLine & "La consegna della fattura da parte del Sistema di Interscambio (SDI)  fallita"
      Case "DEADLINE_PASSED_PA": vTesto = pTestoStato & vbNewLine & String(50, "-") & vbNewLine & "La fattura  stata consegnata da parte del sistema di Interscambio (SDI) ma il cliente non ha inoltrato alcuna risposta nei 15 successivi alla consegna"
   '-----------------------------------------------------
      Case "SIGN_ERROR": vTesto = pTestoStato & vbNewLine & String(50, "-") & vbNewLine & "Errore di Firma"
      Case "CONSERVATION_ERROR": vTesto = pTestoStato & vbNewLine & String(50, "-") & vbNewLine & "Errore di invio in Conservazione"
      Case Else
         vTesto = pTestoStato
   End Select

   DecodStatoDaSdI = vTesto
End Function

Public Function DecodStatoFE(pCodStato As Byte, Optional pNOShowPopUpMsg As Boolean) As String
'STATI CAMPO MVSTATFE DELLA TABELLA DOC_MAST
   Dim vTesto As String

   Select Case pCodStato
      Case 0: vTesto = "DA ELABORARE"
      Case 1: vTesto = "ESCLUSO DALL'UTENTE"
      Case 2: vTesto = "DA INVIARE AL SERVER"
      Case 3: vTesto = "INVIATO AL SERVER"
      Case 4: vTesto = "XML CREATO"
      Case 5: vTesto = "PRONTO PER INVIO SDI"
      Case 6: vTesto = "INVIATO A SDI"
      Case 7: vTesto = "IN ATTESA DI COMPLETAM."
      Case 8: vTesto = "INVIO A SDI COMPLETATO"
'-----------------------------------------------------
      Case 101: vTesto = "CREDITO NON DISPONIBILE"
      Case 102: vTesto = "ERRORE CREAZIONE XML"
      Case 103: vTesto = "ERRORE IN INVIO A SDI"
      Case 113: vTesto = "ERRORE DA SDI: VALIDAZIONE"
      Case 114: vTesto = "ERRORE DA SDI: NOTIF. DI SCARTO"
      Case 115: vTesto = "ERRORE DA SDI: FIRMA"
      Case 116: vTesto = "LICENZA NON VALIDA"
'-----------------------------------------------------
      Case 201: vTesto = "COMPLETATO XML"
      Case 210: vTesto = "COMPL. SDI: CONSEGNATO"
      Case 211: vTesto = "COMPL. SDI: NON RECAPITATO"
      Case 212: vTesto = "COMPL. SDI: ERRORE CONSERV.NE"
   End Select
      
   DecodStatoFE = vTesto
   
   If Not pNOShowPopUpMsg Then
      Dim vTipoMsg As String
      
      Select Case pCodStato
         Case 201, 210: vTipoMsg = "msg_ok"
         Case 0 To 99: vTipoMsg = "msg_info"
         Case 101 To 199: vTipoMsg = "msg_error"
         Case 211, 212: vTipoMsg = "msg_exclamation"
      End Select
      
      Call VisualizzaMsgBoxPopUp(vTipoMsg, "STATO DOC.", vTesto & " (Cod." & pCodStato & ")")
   End If

End Function

Public Function GetDocStatoFE(pSerial As Long, Optional prStatoSdi As String) As Byte
   Dim RS As ADODB.Recordset
   Dim strRicerca As String
   
   On Error GoTo GestErr

   'Cerco prima eventuali ERRORI
   strRicerca = " SELECT MVSTATFE, MVSTASDI " & _
                "   FROM [" & Azienda & "DOC_MAST] " & _
                "  WHERE MVSERIAL = " & pSerial
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneGenerale, adOpenStatic
   If Not RS.EOF Then
      GetDocStatoFE = NonNullo(RS!MVSTATFE, True)
      prStatoSdi = NonNullo(RS!MVSTASDI)
   End If
   RS.Close
   Set RS = Nothing
   
GestErr:
   If err.Number <> 0 Then
      MsgBox err.Number & " - " & err.Description, msg_Critical
   End If
   On Error GoTo 0
End Function

Public Function ChangeStateDoc(pSerial As Long, pStato As Byte) As Boolean
   On Error GoTo GestErr
   
   'Cambio lo stato e svuoto il testo dello sdi
      EseguiSQLMDB ("UPDATE [" & Azienda & "DOC_MAST] SET MVSTATFE = " & pStato & ", MVSTASDI = '' " & _
                                                  " WHERE MVSERIAL = " & pSerial & "")
   'elimino eventuali notifiche
      EseguiSQLMDB ("DELETE FROM [" & Azienda & "DOC_FE_INFO] WHERE MVSERIAL = " & pSerial)
   
   'comando la cancellazione anche sul Web (solo per stato due)
      If pStato = 0 Then
         Call DeleteDocumentoFE(0, pSerial)
      End If
   
   ChangeStateDoc = True
   
GestErr:
   If err.Number <> 0 Then
      MsgBox err.Number & " - " & err.Description & _
             "(Cambio Stato Documento " & pSerial & ")", msg_Critical
   End If
End Function


Public Sub EseguiConnectorFE()
   Dim vInEsecuzione As Boolean
   Dim vPathExe As String
   
   On Error GoTo GestErr
   
   'Controllo che ci sia abilitato nel ParGen la sincronizzazione col WEB
   If Not gModuloFatEleAttivo Then Exit Sub
   
   If AppParam.gInTEST Then
      vPathExe = "ConnectFE_TEST"
   Else
      vPathExe = "ConnectFE"
   End If
   
   vInEsecuzione = VerificaEsecuzioneEXE(App.path & "\Utility\" & vPathExe & "\ConnectorFE.exe")
   
   If Not vInEsecuzione Then
      Dim RetVal
      RetVal = ShellExecute(0&, "Open", App.path & "\Utility\" & vPathExe & "\ConnectorFE.exe", 0&, App.path & "\Utility\" & vPathExe & "\", SW_SHOWNORMAL)
            
      Call MsgProcedureInLogFile(" # # # # # # # # # # # #          A.V.V.I.O           # # # # # # # # # # # # ", "CONNECTORFE")
      Call MsgProcedureInLogFile("LICENZA: " & mtFatEle.feLicenza & "  -  CREDITO: " & mtFatEle.feCredito, "CONNECTORFE")
   End If

GestErr:
   Dim vErr As String
   If err.Number = 53 Then
      vErr = "Impossibile trovare il file per eseguire GetWEB"
      MsgBox vErr & vbNewLine & _
             "Contattare l'assistenza per la soluzione del problema.", vbCritical
      Call MsgProcedureInLogFile(vErr, "CONNECTORFE", True)
   ElseIf err.Number <> 0 Then
      vErr = err.Number & " - " & err.Description
      MsgBox vErr, msg_Critical
      Call MsgProcedureInLogFile(vErr, "CONNECTORFE", True)
   End If
   On Error GoTo 0
End Sub


Public Sub DeleteDocumentoFE(vSerialWEB As Long, vMvSerial As Long)
'https://test.be.primosoftware.it/E-Billing/info/primo/001052/001052/55/25731
'Comando Delete
'usare COMPANY token (edited)
   
   Dim vLink As String
   Dim vToken As String
   
   'Prendo il Token del cliente
   vToken = DECOD_VALORE_CAMPO("GENERALEANA_AZIENDE", "AZCODAZI", Azienda, "AZWTOKEN")
   If Len(Trim(vToken)) = 0 Then Exit Sub
   
   If Not AppParam.gInTEST Then  'PRODUZIONE
      vLink = "https://be.primosoftware.it/E-Billing/info/primo/" & AppParam.gIDNovisoft & "/" & AppParam.gIDNovisoft & "/" & Trim(Str(vSerialWEB)) & "/" & Trim(Str(vMvSerial))
   Else                 'TEST
      vLink = "https://test.be.primosoftware.it/E-Billing/info/primo/" & AppParam.gIDNovisoft & "/" & AppParam.gIDNovisoft & "/" & Trim(Str(vSerialWEB)) & "/" & Trim(Str(vMvSerial))
   End If


   Dim Ans As String
   Dim oHTTP As MSXML2.XMLHTTP60, sBuffer As String
   
   Set oHTTP = CreateObject("MSXML2.ServerXMLHTTP")
   oHTTP.Open "DELETE", vLink, False
   oHTTP.setRequestHeader "company-token", vToken 'COMPANY TOKEN -> FISSO
   oHTTP.send
   
   sBuffer = oHTTP.responseText
   
   'If Len(Trim(sBuffer)) = 0 Then
   If oHTTP.Status = 200 Then
      'Call VisualizzaMsgBoxPopUp("msg_ok", "ESITO", "INVIO TICKET OK" & IIf(AppParam.gInTEST, " (in test)", ""))
      Call MsgProcedureInLogFile("Cancellazione Documento " & vSerialWEB & "(webserial) |" & vMvSerial & "(mvserial)", "CONNECTORFE")
   Else
      'MsgBox "Messaggio dal Server:" & vbNewLine & _
             sBuffer & vbNewLine & vbNewLine & IIf(AppParam.gInTEST, "(in test)", ""), msg_Exclamation
      Call MsgProcedureInLogFile("Cancellazione Documento " & vSerialWEB & "(webserial) |" & vMvSerial & "(mvserial) => " & _
                                 sBuffer & " - " & oHTTP.statusText, "CONNECTORFE", True)
   End If
   
   Set oHTTP = Nothing
End Sub


Public Function CaricamentoManualeCicloPassivo() As Boolean
'https://test.be.primosoftware.it/BillUploader.php?token=350e2f07368d981d6193af2cec65acf4&company_id=004163
'il token  il company
   
   'Prima di ESEGUIRE IL CAMBIO STATO 'IN TRASMETTERE' CONTROLLO LA LICENZA
   If IsDate(gScadManutenBlock) Then
      If (CDate(gScadManutenBlock) >= Date) Or (ReadINI("OPZIONI", "MOD_OFFICE", IniPath) = "T") Then
'         'ARRIVATO QUI CONTROLLO  LA LICENZA DI 'FE' ED IL CREDITO
'         'Prendo i dati di Licenza del Cliente
'            Call GetStatoFE
'         'Setto la ToolBar4
'            Call SetTypeFatEle
         
         If mtFatEle.feLicenza = 0 Then
            MsgBox "LICENZA NON ATTIVA", msg_Exclamation
            Exit Function
         End If
      Else
         Call MessaggioVersioneNoPRO
         Exit Function
      End If
   Else
      MsgBox "LICENZA NON ATTIVA", msg_Exclamation
      Exit Function
   End If
   
   
   
   Dim vLink As String
   Dim vToken As String
   
   'Prendo il Token del cliente
   vToken = DECOD_VALORE_CAMPO("GENERALEANA_AZIENDE", "AZCODAZI", Azienda, "AZWTOKEN")
   
   If Not AppParam.gInTEST Then  'PRODUZIONE
      vLink = "https://be.primosoftware.it/BillUploader.php?token=" & vToken & "&company_id=" & AppParam.gIDNovisoft
   Else                 'TEST
      vLink = "https://test.be.primosoftware.it/BillUploader.php?token=" & vToken & "&company_id=" & AppParam.gIDNovisoft
   End If
   
   'Apro la pagine WEB con link appena costruito
   Call OpenWebPage(MDIForm1, vLink)
   CaricamentoManualeCicloPassivo = True
   
End Function
