Attribute VB_Name = "ModuloBACKUP"
Option Explicit

Public Const WAIT_TIMEOUT = &H102

Public Declare Function CloseHandle Lib "kernel32" (ByVal hObject As Long) As Long

Public Declare Function OpenProcess Lib "kernel32.dll" (ByVal _
   dwAccess As Long, ByVal fInherit As Integer, ByVal hObject _
   As Long) As Long

Public Declare Function WaitForSingleObject Lib "kernel32" (ByVal _
 hHandle As Long, ByVal dwMilliseconds As Long) As Long

Public Const SYNCHRONIZE = &H100000
'Public Const NORMAL_PRIORITY_CLASS = &H20&
Public Const INFINITE = -1&

'Variabili per la registrazione del Backup nel database "xxx\Backup\Log\BckLog.mdb" ////////////////////////////////////////////////////
   Private mIdBackup As Long 'Se > 0 significa che le procedure di Backup e Sinc saranno registrate nel database "xxx\Backup\Log\BckLog.mdb"
   Public ConnBCK As ADODB.Connection
'///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


Public Function CreaFileBackup(PathBck As String, NomeDb As String) As Boolean
   Dim NumFile As Integer

   CreaFileBackup = True
   On Error GoTo GestErr
   
   
   Call VerificaEsistenzaPathCartella(App.path & "\Backup")
   
   
   NumFile = FreeFile

   'Apro il file LOG
   Open PathBck & "\Bck_" & NomeDb & ".sql" For Append As #NumFile    'CREO IL FILE
      
      Print #NumFile, "USE " & NomeDb
      Print #NumFile, "GO"
      
      Print #NumFile, "BACKUP DATABASE " & NomeDb & ""
      Print #NumFile, "  TO DISK = '" & PathBck & "\" & NomeDb & ".bak'"
      Print #NumFile, "  WITH INIT, NOUNLOAD"
      Print #NumFile, "  , name = '" & NomeDb & " Backup'"
      Print #NumFile, "  , NOSKIP"
      Print #NumFile, "  , STATS = 10"
      Print #NumFile, "  , Description = 'script per il backup del database " & NomeDb & " con MSDE/SQL Server'"
      Print #NumFile, "  , NOFORMAT"
      Print #NumFile, "GO"
      
      Print #NumFile, "QUIT"
      
   'Chiudo il file di LOG
   Close #NumFile


GestErr:
   If err.Number <> 0 Then
      CreaFileBackup = False
      MsgBox err.Number & " - " & err.Description, msg_Critical
   End If
   On Error GoTo 0
End Function


Public Function EseguiScriptSQL(NomeServer As String, PassUtSa As String, PathFileScript As String) As Boolean
   Dim dwProcessID As Long
   Dim hProcess As Long
   Dim ApriFile  As String
   Dim Password As String
   Dim Istruzione As String

   EseguiScriptSQL = True
   On Error GoTo GestErr


'   Kill App.path & "\Backup\" & NomeDb & ".bak"

   
   Istruzione = "osql.exe -S " & NomeServer & " -U sa -P " & PassUtSa & " -i " & Chr(34) & PathFileScript & Chr(34)
      
   
   dwProcessID = Shell(Istruzione)
    
    
   If dwProcessID = 0 Then
      Kill PathFileScript
      Exit Function
   End If
    
   hProcess = OpenProcess(SYNCHRONIZE, False, dwProcessID)
    
   If hProcess = 0 Then
      Kill PathFileScript
      Exit Function
   End If
    
      Do While WaitForSingleObject(hProcess, 100) = WAIT_TIMEOUT
         DoEvents
      Loop
    
   CloseHandle hProcess
   
      
      
   'Elimino il file di backup
   Kill PathFileScript

GestErr:
   If err.Number = 53 Then
      Resume Next
   ElseIf err.Number <> 0 Then
      EseguiScriptSQL = False
      MsgBox err.Number & " - " & err.Description, msg_Critical
   End If
   On Error GoTo 0
End Function


Public Sub AddRowFileScriptSQL(pathScript As String, NomeScript As String, RigaScript As String)
   Dim NumFile As Integer

   On Error GoTo GestErr
   
   Call VerificaEsistenzaPathCartella(pathScript)
   
   NumFile = FreeFile


   Open pathScript & "\" & NomeScript & ".sql" For Append As #NumFile   'CREO IL FILE DI SCRIPT
      
      Print #NumFile, RigaScript                                        'AGGIUNGO LA RIGA
      
   Close #NumFile                                                       'CHIUDO IL FILE DI SCRIPT


GestErr:
   If err.Number <> 0 Then
      MsgBox err.Number & " - " & err.Description, msg_Critical
   End If
   On Error GoTo 0
End Sub


Public Function CreaDatabaseMASTER(pNomeServerSQL As String, pNomeDBSQL As String, pPassword_SA As String, pConnessioneTrusted As String) As Boolean
   
   On Error GoTo GestErr
   
   If CreaFileRestore(pNomeDBSQL) = True Then
   
      CreaDatabaseMASTER = EseguiScriptSQL(pNomeServerSQL, pPassword_SA, App.path & "\Start\Rst_" & pNomeDBSQL & ".sql")
      
   Else
   
      CreaDatabaseMASTER = False
   
   End If
   
GestErr:
   If err.Number <> 0 Then
      CreaDatabaseMASTER = False
      MsgBox err.Number & " - " & err.Description, msg_Critical
   End If
   On Error GoTo 0
End Function

Public Function CreaFileRestore(NomeDb As String) As Boolean
   Dim NumFile As Integer

   CreaFileRestore = True
   On Error GoTo GestErr
   
   
   Call VerificaEsistenzaPathCartella(App.path & "\Start")
   
   
   NumFile = FreeFile

   'Apro il file LOG
   Open App.path & "\Start\Rst_" & NomeDb & ".sql" For Append As #NumFile    'CREO IL FILE
      
      Print #NumFile, "RESTORE DATABASE [" & NomeDb & "] FROM  DISK = N'" & App.path & "\Start\PRIMO_NS_MASTER_START.bak' WITH  FILE = 1,  NOUNLOAD,  REPLACE,  STATS = 10"
      Print #NumFile, "GO"
      
   'Chiudo il file di LOG
   Close #NumFile


GestErr:
   If err.Number <> 0 Then
      CreaFileRestore = False
      MsgBox err.Number & " - " & err.Description, msg_Critical
   End If
   On Error GoTo 0
End Function

Public Function CreaDATABASE(NomeDb As String) As Boolean
   Dim NumFileW As Integer
   Dim MyFile As String
   Dim NumFileR As Integer
   Dim ApriFile As String
   Dim ReadString As String
   Dim PathFileScript As String
   
   CreaDATABASE = True
   On Error GoTo GestErr
   
   
   MyFile = Dir(App.path & "\Script\DB_*." & "sql")
   Do Until MyFile = ""                               'CICLO SUI FILE PRESENTI IL CUI NOME INIZIA PER "DB_"
      NumFileR = FreeFile
      ApriFile = App.path & "\Script\" & MyFile
      
      PathFileScript = App.path & "\Script\_SCRIPT_" & MyFile
      
      Kill PathFileScript
      
      Open ApriFile For Input As #NumFileR
      Do Until EOF(NumFileR)                           'CICLO SULLE  RIGHE DEL FILE SELEZIONATO
         Line Input #NumFileR, ReadString 'Leggo la riga
                  
         'Dim NumFile As Integer
         NumFileW = FreeFile
         'Apro il file LOG
         Open PathFileScript For Append As #NumFileW  'CREO IL FILE
            
            ReadString = Replace(ReadString, "", "") 'Qui tolgo questi caratteri che si presentano solo sul primo rigo ma mi creavano problkemi sulla creazione del file
            ReadString = Replace(ReadString, "", NomeDBSQL_GEN) 'Qui aggiorno  il nome del DATABASE
            ReadString = Replace(ReadString, "", NomeDb) 'Qui aggiorno  il codice dell'AZIENDA
            Print #NumFileW, ReadString 'APPENDO LA RIGA NEL NUOVO FILE SCRIPT DA ESEGUIRE
                           
            FormCreaAzienda.LblMsg = ReadString
            FormCreaAzienda.LblMsg.Refresh
                           
         Close #NumFileW 'Chiudo il file da eseguire
         
      Loop
      Close #NumFileR
   
      
      'Qui ESEGUO LO SCRIPT
      If EseguiScriptSQL(NomeServerSQL, Password_SA, PathFileScript) = False Then
         CreaDATABASE = False
         Exit Do
      End If
      
      MyFile = Dir
   Loop


GestErr:
   If err.Number = 53 Then
      Resume Next
   ElseIf err.Number <> 0 Then
      CreaDATABASE = False
      MsgBox err.Number & " - " & err.Description, msg_Critical
   End If
   On Error GoTo 0
End Function



Public Function BackupMDB(pConnAttiva As Boolean, pTipo As String, pEsecuz As String, pPath As String, pNomeMDB As String, pCompatta As Boolean, _
                          Optional pStoricizza As Boolean, Optional pNumStorico As Byte) As String
   'pTipo   = "BCK" = Backup; "SNC" = Sincronizzazione _
    pEsecuz = "M" = Manuale; "A" = Avvio; "C" = Chiusura
   
   Dim NomeDb As String
   Dim vData As String
   Dim vOra As String
   Dim mError As Boolean
   Dim mGiaTentato As Boolean
   
   
RitentaAzione:
   
   On Error GoTo GestErr
   
   'Controllo se esiste il Database di Log
   If (Not VerificaEsistenzaFile(PathBackUP & "\Log\BckLog.mdb")) Or (mGiaTentato) Then
      Call RipristinaDbModel
   End If
   
   
   If Not (pEsecuz = "M") Then
      Call ImpostaStatusPanePrgBar(True, 2, 0, IIf(pTipo = "BCK", "Backup", "Sincro") & " in corso...")
   End If
   
   
   mIdBackup = 0 'Lo azzero perch potrebbe essere stato popolato con un precedente backup
   BackupMDB = ""
   vData = Format(Date, "dd/mm/yyyy")
   vOra = Format(Now, "hh.nn.ss")
      
   
   Call VerificaEsistenzaPathCartella(pPath)
   NomeDb = GetNomeFile(pNomeMDB)
   
   
   'Qui vedo se devo aggiungere la storicizzazione al nome del DB
   If pStoricizza Then
      NomeDb = Replace(NomeDb, ".mdb", "")
      NomeDb = NomeDb & "_" & Format(vData, "yyyymmdd") & "-" & Format(vOra, "hhnnss") & ".mdb"
   End If
   
   
   'Controllo se esiste il Database di Log
   If VerificaEsistenzaFile(PathBackUP & "\Log\BckLog.mdb") Then
      Call ApriAmbienteBCK
      Call InsertBckMast(vData & " " & vOra, pEsecuz, pTipo, NomeDb, IIf(pCompatta = True, "S", "N"), pNumStorico, pPath)
   End If
   
      
   'Qui sistemo i file di Storico (elimino i vecchi)
   If pStoricizza Then
      Call PulisciStoricoFile(pNumStorico, GetNomeFile(pNomeMDB), pPath)
   End If
   
   
   'Controllo se non ci sono stati errori
   If Len(Trim(BackupMDB)) = 0 Then
   
      'se sono collegato...
      If pConnAttiva = True Then
         'Qui mi scollego dal Database
         If ConnessioneGenerale.state = 1 Then ConnessioneGenerale.Close
      End If
      
         'Qui faccio la copia del file
         FileCopy pNomeMDB, pPath & "\" & NomeDb
         
         'QUI LO COMPATTO
         If (pCompatta = True) And (mError = False) Then
            If Len(Trim(BackupMDB)) = 0 Then Call CompattaDatabase("PR")
         End If
      
      'se ero collegato mi ricollego
      If pConnAttiva = True Then
         'Qui mi ricollego al Database
         Call ApriConnessioneACCESS(Trim(gPathDatabase))
      End If
            
   End If
   
GestErr:
   If err.Number = 70 Then 'Autorizzazione Negata
      If Not mGiaTentato Then
         mGiaTentato = True
         On Error GoTo 0
         Resume RitentaAzione
      End If
      
      mError = True
      If pEsecuz = "M" Then
         BackupMDB = err.Number & " - " & err.Description & vbNewLine & "(Verificare che il Database non sia in uso)"
      Else
         BackupMDB = ""
      End If
      On Error GoTo 0
      Resume Next
   ElseIf err.Number <> 0 Then
      If Not mGiaTentato Then
         mGiaTentato = True
         On Error GoTo 0
         Resume RitentaAzione
      End If
      
      mError = True
      BackupMDB = err.Number & " - " & err.Description
      If (err.Number = 75) Or (err.Number = 76) Then
         BackupMDB = BackupMDB & vbNewLine & "( L'UNITA' DI DESTINAZIONE DEL BACKUP  <" & pPath & ">  NON ESISTE OPPURE E' BLOCCATA )"
      End If
      On Error GoTo 0
      Resume Next
   End If
   On Error GoTo 0
   
   'Registro l'esito nel database
   If mIdBackup > 0 Then
      If Len(Trim(BackupMDB)) > 0 Then
         Call EseguiSQLBCK("UPDATE [BCK_MAST] SET XBK_ESCBCK = '! " & VerificaApici(Mid(BackupMDB, 1, 250)) & "' WHERE XBK_ID_BCK = " & mIdBackup)
      Else
         Call EseguiSQLBCK("UPDATE [BCK_MAST] SET XBK_ESCBCK = 'OK' WHERE XBK_ID_BCK = " & mIdBackup)
      End If
      
      Call ChiudiAmbienteBCK
   End If
   
   
   If Not (pEsecuz = "M") Then
      Call ImpostaStatusPanePrgBar(False)
   End If
End Function


Public Sub CompattaDatabase(Tipo As String)
   Dim dbEN As New dao.DBEngine
   Dim vPathFile As String
   Dim vNameFile As String
   Dim vNameAppFile As String 'nome momentaneo del file
   Dim vRinomaFile As Boolean
   Dim vPassword As String
   Dim vPathDatabase As String
   
   On Error GoTo GestErr
   
   vRinomaFile = False
   
   'Qui prevedo la possibilit di farlo sia sulle stampe che sul database azienda _
    anche se al momento lo faccio solo sul database delle stampe
   If Tipo = "ST" Then  'DATABASE STAMPE
      
      vPathFile = GetPathFile(PathSTAMPE)
      vNameFile = GetNomeFile(PathSTAMPE)
      
      'Controllo se esiste il Database Model e se  stato abilitata la copia dal Modello nel ParGen _
       (questa opzione la utilizzo in quei casi in cui il file Stampa.mdb si rovina frequentemente)
      'If VerificaEsistenzaFile(App.path & "\Files\Doc\Model\Stampe.mdb") And (UCase(ReadINI("OPZIONI", "STAMPEMDB_MODEL", IniPath)) = "T") Then
      'If VerificaEsistenzaFile(App.path & "\Files\Doc\Model\Stampe.mdb") Then
      If VerificaEsistenzaFile(App.path & "\Files\Doc\Model\Stm.model") Then
         'killo il file attuale e ricopio il Modello
         If VerificaEsistenzaFile(PathSTAMPE) Then
            Kill PathSTAMPE
         End If
         'Copio il file
         FileCopy App.path & "\Files\Doc\Model\Stm.model", PathSTAMPE
         
         Exit Sub 'ESCO perche' tanto non c' bisogno di fare altro
         
      Else
      
         'Qui invece procedo allo svuotamento delle tabelle e poi verr eseguita la compattazione
         mIdBackup = 0 'altrimenti cerca di scrivere anche se compatta il db Stampe
          
         'QUI SVUOTO LE TABELLE CICLICAMENTE (VALUTARE SE QUESTO NON PORTA VIA TROPPO TEMPO!)
         Call ApriAmbienteStampe
            Dim Tables As ADODB.Recordset
            Set Tables = ConnSTAMPA.OpenSchema(adSchemaTables)
            Do Until Tables.EOF
                If Tables.Fields.Item("TABLE_TYPE").Value = "TABLE" Then 'VERIFICO SI TRATTI DI UNA TABELLA
                    ConnSTAMPA.Execute "DELETE FROM [" & Tables.Fields.Item("TABLE_NAME").Value & "]" 'LA SVUOTO
                End If
                Tables.MoveNext
            Loop
         Call ChiudiAmbienteStampe
         
      End If
      
   
   ElseIf Tipo = "PR" Then  'DATABASE DI LAVORO DI PRIMO
      
      'Se la variabile globale non  popolata (questo puo verificarsi in caso di backup con compattazione all'avvio)
      'allora provo a leggerlo momentaneamente e popolo la variabile locale
      If Not Len(Trim(gPathDatabase)) = 0 Then
         vPathFile = GetPathFile(gPathDatabase)
         vNameFile = GetNomeFile(gPathDatabase)
      Else
         vPathDatabase = ReadINI("CONN_SQL", "PATH_DB", IniPath)
         vPathFile = GetPathFile(vPathDatabase)
         vNameFile = GetNomeFile(vPathDatabase)
      End If
      vPassword = "primols"
      
   End If
   
   
'COMPATTAZIONE - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

   'Se uno dei due valori  VUOTO allora evito di eseguire la compattazione perch andrebbe in errore
   If Not (Len(Trim(vPathFile)) = 0 Or Len(Trim(vNameFile)) = 0) Then
   
      'Registro l'INIZIO DELLA CAMPATTAZIONE
      If mIdBackup > 0 Then
         Call EseguiSQLBCK("UPDATE [BCK_MAST] SET XBK_ESCOMP = '! Inizio Compatt. (non comletata)' WHERE XBK_ID_BCK = " & mIdBackup)
      End If
   
      'Qui creo il nome momentaneo del database da COMPATTARE inserendo #C# prima dell'estenzione _
       cos nel caso vada in errore durante la compattazione il file  riconoscibile
      vNameAppFile = Mid(vNameFile, 1, Len(vNameFile) - 4) & "#C#" & Mid(vNameFile, Len(vNameFile) - 3)
      Name vPathFile & vNameFile As vPathFile & vNameAppFile
      vRinomaFile = True
      
      'Compatto il database (purtroppo ho dovuto mettere le due righe perch se manca la password sul database viene generato un errore
      If Len(vPassword) = 0 Then  'DATABASE STAMPE
         dbEN.CompactDatabase vPathFile & vNameAppFile, vPathFile & vNameFile
      Else
         dbEN.CompactDatabase vPathFile & vNameAppFile, vPathFile & vNameFile, , , ";Pwd=" & vPassword
      End If
      
      Kill vPathFile & vNameAppFile

      'Registro l'INIZIO DELLA CAMPATTAZIONE
      If mIdBackup > 0 Then
         Call EseguiSQLBCK("UPDATE [BCK_MAST] SET XBK_ESCOMP = 'OK' WHERE XBK_ID_BCK = " & mIdBackup)
      End If

   End If



GestErr:
   If err.Number <> 0 Then
      'Resume Next
      If vRinomaFile = True Then Name vPathFile & vNameAppFile As vPathFile & vNameFile
      
      MsgBox err.Number & " - " & err.Description & vbNewLine & vbNewLine & "ATTENZIONE!  Compattazione non riuscita.", vbExclamation
   
      'Registro l'INIZIO DELLA CAMPATTAZIONE
      If mIdBackup > 0 Then
         Call EseguiSQLBCK("UPDATE [BCK_MAST] SET XBK_ESCOMP = '! " & VerificaApici(Mid(err.Number & " - " & err.Description, 1, 250)) & "' WHERE XBK_ID_BCK = " & mIdBackup)
      End If
   
   End If
   On Error GoTo 0

End Sub


Private Sub PulisciStoricoFile(pNumFileStor As Byte, pNomeDB As String, pPathDest As String)
   Dim vArrFile() As String
   Dim MyFolder As String
   Dim NomeDB_DaCercare As String
   Dim i As Integer
   Dim vOrdFile As Integer
   Dim MyPath As String
                
   Erase vArrFile
   
   vOrdFile = 0
   
   MyPath = pPathDest
   'Controllo se c'e' la barra alla fine del percorso
   If Right(MyPath, 1) <> "\" Then MyPath = MyPath & "\"
      
   NomeDB_DaCercare = Replace(pNomeDB, ".mdb", "")
   NomeDB_DaCercare = NomeDB_DaCercare & "*.mdb"
   

'Restituisce una stringa vuota se la cartella non esiste
   MyFolder = Dir(MyPath & NomeDB_DaCercare)
   Do Until MyFolder = ""
      vOrdFile = vOrdFile + 1
      
      If mIdBackup = 0 Then 'Qui nel caso non ci siano le condizioni per salvare nel database allora uso l'array
         Call AddArrayElement(vArrFile, MyFolder)
      
      Else 'qui invece registro i file nel database BckLog.mdb
         
         Call InsertBckFile(CByte(vOrdFile), MyFolder)
      End If
      
      MyFolder = Dir()
   Loop
   
   
'Qui elimino i file pi vecchi
      If mIdBackup = 0 Then
         'DALL'ARRAY
            If VerificaArrayInizializzato(vArrFile) = True Then
               If UBound(vArrFile) + 1 > pNumFileStor Then
                  For i = 0 To (UBound(vArrFile)) - (pNumFileStor)
                     Kill MyPath & vArrFile(i)
                  Next i
               End If
            End If
         
      Else
         'DAL DATABASE
         If vOrdFile > pNumFileStor Then  'verifico se  necessario la cencellazione dei vecchi
            Call KillFileStorDaMDB((vOrdFile) - (pNumFileStor))
         End If
      End If
         
End Sub


Public Sub ApriAmbienteBCK()
'Apro l'ambiente di lavoro del Database
   Set ConnBCK = New ADODB.Connection
   ConnBCK.ConnectionString = "Provider = Microsoft.Jet.OLEDB.4.0;Data Source =" & PathBackUP & "\Log\BckLog.mdb;Jet OLEDB:Database Password=;"
   ConnBCK.Open
End Sub
Public Sub ChiudiAmbienteBCK()
   If ConnBCK.state = 1 Then
      ConnBCK.Close
   End If
End Sub

Private Function GetIDBck(TABELLA As String, Campo As String, Optional strWhere As String) As Long
   Dim RS As ADODB.Recordset
   Dim strRicerca As String
   
   On Error GoTo GestErr
   
'Qui leggo l'ultimo numero attribuito...
   strRicerca = "Select MAX(" & Campo & ") as Valore from [" & TABELLA & "] " & strWhere
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnBCK, adOpenStatic
   If Not RS.EOF Then
      GetIDBck = NonNullo(RS!Valore, True) + 1
   Else
      GetIDBck = 1
   End If
   RS.Close
   Set RS = Nothing
   
GestErr:
   If err.Number <> 0 Then
      Call MsgInLogFile(" REG. in  LOG BACKUP (BckLog.mdb) -> ERROR:" & err.Number & " - " & err.Description & " (funct. GetIDBck)")
      Call RipristinaDbModel
   End If
   On Error GoTo 0
End Function

Private Sub InsertBckMast(pDataOra As String, pEsecuz As String, pTipo As String, pNomeFile As String, _
                          pCompattaz As String, pStorico As Byte, pPathDest As String)
   Dim StrCampi As String
   Dim StrValori As String
   Dim StrIns As String
   
   'Prendo il progressivo del Backup
   mIdBackup = GetIDBck("BCK_MAST", "XBK_ID_BCK", "")
   
   StrCampi = "XBK_ID_BCK"
   StrValori = "" & mIdBackup & ""
   StrCampi = StrCampi & ",XBK_DATBCK"
   StrValori = StrValori & ",#" & pDataOra & "#"
   StrCampi = StrCampi & ",XBK_ESECUZ"
   StrValori = StrValori & ",'" & pEsecuz & "'"
   StrCampi = StrCampi & ",XBK_TIPBCK"
   StrValori = StrValori & ",'" & pTipo & "'"
   StrCampi = StrCampi & ",XBK_FLCOMP"
   StrValori = StrValori & ",'" & pCompattaz & "'"
   StrCampi = StrCampi & ",XBK_NOMFIL"
   StrValori = StrValori & ",'" & VerificaApici(pNomeFile) & "'"
   StrCampi = StrCampi & ",XBK_STORIC"
   StrValori = StrValori & "," & pStorico & ""
   StrCampi = StrCampi & ",XBK_PATHDS"
   StrValori = StrValori & ",'" & VerificaApici(pPathDest) & "'"

   StrIns = "INSERT INTO [BCK_MAST] (" & StrCampi & ") values (" & StrValori & ")"
   Call EseguiSQLBCK(StrIns)
   
End Sub

Private Sub InsertBckFile(pOrdFile As Byte, pFileStor As String)
   Dim StrCampi As String
   Dim StrValori As String
   Dim StrIns As String
   
   StrCampi = "XBK_ID_BCK"
   StrValori = "" & mIdBackup & ""
   StrCampi = StrCampi & ",XBK_ORDFIL"
   StrValori = StrValori & "," & pOrdFile & ""
   StrCampi = StrCampi & ",XBK_FILSTO"
   StrValori = StrValori & ",'" & pFileStor & "'"

   StrIns = "INSERT INTO [BCK_FILE] (" & StrCampi & ") values (" & StrValori & ")"
   Call EseguiSQLBCK(StrIns)
End Sub

Private Sub KillFileStorDaMDB(pNumFileToKILL As Byte)
   Dim RS As ADODB.Recordset
   Dim strRicerca As String
   
   On Error GoTo GestErr
   
   strRicerca = "SELECT TOP " & pNumFileToKILL & " BCK_FILE.*,  BCK_MAST.XBK_PATHDS " & _
                "  FROM BCK_FILE INNER JOIN BCK_MAST ON BCK_FILE.XBK_ID_BCK = BCK_MAST.XBK_ID_BCK " & _
                " WHERE BCK_FILE.XBK_ID_BCK = " & mIdBackup & " ORDER BY BCK_FILE.XBK_FILSTO"
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnBCK, adOpenStatic
   If Not RS.EOF Then
      Do Until RS.EOF
         'cancello il file ...
         Kill RS!XBK_PATHDS & "\" & RS!XBK_FILSTO
         'e contrassegno il file nel database come "ELIMINATO"
         Call EseguiSQLBCK("UPDATE [BCK_FILE] SET XBK_DELFIL = 'S' WHERE XBK_ID_BCK = " & mIdBackup & " AND XBK_ORDFIL = " & RS!XBK_ORDFIL & "")
         RS.MoveNext
      Loop
   End If
   RS.Close
   Set RS = Nothing
   
GestErr:
   If err.Number <> 0 Then
      Call MsgInLogFile(" REG. in  LOG BACKUP (BckLog.mdb) -> ERROR:" & err.Number & " - " & err.Description & " (funct. KillFileStorDaMDB)")
   End If
   On Error GoTo 0
End Sub

Private Function EseguiSQLBCK(Comando As String)
   On Error GoTo GestErr
   
   ConnBCK.Execute Comando
   
GestErr:
   If err.Number <> 0 Then
      'MsgBox err.Number & " - " & err.Description & vbNewLine & _
             "[ERRORE IN FASE DI REGISTRAZIONE LOG BACKUP]", msg_Critical
      Call MsgInLogFile(" REG. in  LOG BACKUP (BckLog.mdb) -> ERROR:" & err.Number & " - " & err.Description & " (comando: " & Comando & ")")
   End If
   On Error GoTo 0
End Function

Private Sub RipristinaDbModel()
   On Error Resume Next
      
      Call ChiudiAmbienteBCK
      
   'Controllo se esiste il Database Model
   If VerificaEsistenzaFile(App.path & "\Files\Doc\Model\BckLog.model") Then
      'killo il file attuale e ricopio il Modello
         Kill PathBackUP & "\Log\BckLog.mdb"
      'Copio il file
         Call VerificaEsistenzaPathCartella(PathBackUP & "\Log")
         FileCopy App.path & "\Files\Doc\Model\BckLog.model", PathBackUP & "\Log\BckLog.mdb"
   End If
   
   Call MsgInLogFile(" REG. in  LOG BACKUP (BckLog.mdb) -> RIPRISTINO DB BckLog.MODEL")
End Sub
