Attribute VB_Name = "ModuloRegCasEPSON"
Option Explicit

'Contiene i dati dell'ultimo scontrino stampato
Private Type mTypeLastEPSONRequest
   errorCode As String
   responseStatus As String
   printerError As Boolean 'Stampante in Errore (0 = FALSE // 1 = TRUE)
   printerStatus As String '!?!?
   fiscalReceiptNumber As String 'numero che indica il Progressivo dell'ultimo scontrino fiscale/documento commerciale
   fiscalReceiptAmount As String 'valore ultimo scontrino
   fiscalReceiptDate As String 'data ultimo scontrino
   fiscalReceiptTime As String 'ora ultimo scontrino
   zRepNumber As String 'progressivo Z corrente
End Type
Public gtLastEPSONRequest As mTypeLastEPSONRequest

Public gEPSONCheckInattivita As Boolean


'/////\\\\\/////\\\\\/////\\\\\  E P S O N   S T A R T  /////\\\\\/////\\\\\/////\\\\\
'/////\\\\\/////\\\\\/////\\\\\  E P S O N   S T A R T  /////\\\\\/////\\\\\/////\\\\\

'Public Sub EPSON_TEST_OLD_FUN(pPathIN As String, pMsg As String, Optional pApriCassetto As Byte)
'   On Error Resume Next
'
'   Dim NumFile As Integer 'per aprire il file che mi serve per storicizzare lo scontrino ed eventualmente ristamparlo
'   NumFile = FreeFile
'
'   'PRINT DISPLAY ***
'      Kill App.path & "\tempEpson.txt"
'      Open App.path & "\tempEpson.txt" For Append As #NumFile      'CREO IL FILE
'         'RIGHE
'         Print #NumFile, "printerCommand"
'         If pApriCassetto = 1 Then 'VERIFICO SE APRIRE IL CASSETTO
'            Print #NumFile, "directIO|opApriCassetto|1"
'         End If
'         If Len(pMsg) > 0 Then
'            Print #NumFile, "displayText|1|" & pMsg
'         End If
'      Close #NumFile
'      FileCopy App.path & "\tempEpson.txt", pPathIN & "scoTEST.txt"
'      Kill App.path & "\tempEpson.txt"
'
'   On Error GoTo 0
'End Sub

Public Function EpsonReadOut(pFileOUT As String, _
                             Optional pScontrino As Boolean, Optional pTimeoutSeconds As String) As Byte   ', Optional ExtraCommand As String, Optional StringExtraCommand As String) As Boolean
   'pFileOUT   --> path del file che contiene l'esito (di norma l'esito si trova nel secondo rigo)
   'pScontrino --> se True significa che  stato chiamato per verificare l'esito di uno scontrino e devo estrarre e salvare l'esito dal file
   
   'Verifico la presenza del file con un MAX Timeout di 10 sec. (valutare!!!)
   Dim vStart As Date
   Dim vSeconds As Integer
   
   If IsNumeric(pTimeoutSeconds) Then
      vSeconds = pTimeoutSeconds
   Else
      vSeconds = 15
   End If
   vStart = DateAdd("s", CDbl(vSeconds), Now)

Debug.Print "Epson.Read.Out - Now: " & Now
Debug.Print "Epson.Read.Out - Time: " & vStart

   Do Until VerificaEsistenzaFile(pFileOUT)
      If Now > vStart Then
         EpsonReadOut = 99 ' = Timeout
                  
         Dim vTxtErr As String
         vTxtErr = "Errore di TIMEOUT nella comunicazione col Registratore." & vbNewLine & _
                   "Accertarsi che il programma 'EpsonFpMate' sia in esecuzione."
         If pScontrino Then
            gtLastScontrino.ProgFiscale = -1 'in segno di ERRORE
            gtLastScontrino.StringaEsito = vTxtErr
            gtLastScontrino.DescErrInChiaro = vTxtErr
            'Se il file persiste nell cartella 'IN' allora lo elimino onde evitare di stampare pi volte lo scontrino
            If VerificaEsistenzaFile(mPathDestScontrino & gtLastScontrino.FilePrint) Then
               Call PausaProgramma(1, True, True)
               Call KillaFile(mPathDestScontrino & Replace(gtLastScontrino.FilePrint, ".txt", ".*")) 'faccio l'* perch potrebbe esserci anche il file .on di syncronizzazione
            End If
         Else
            MsgBox vTxtErr, msg_Critical, "TIMEOUT!"
         End If
         Call MsgRegCasInLogFile("[EpsonReadOut] - '" & vTxtErr & "'", True)
         Exit Function
      End If
   Loop
   
Debug.Print "Epson.Read.Out - File OUT Ricevuto!"
   
   
   Dim NumFile As Integer
   Dim ReadString As String
   Dim iRow As Byte
   Dim vTentativi As Byte
   
   On Error GoTo GestErr
   

RipetiLetturaFile:
   
   NumFile = FreeFile
   Open pFileOUT For Input As #NumFile
   
Debug.Print "Epson.Read.Out - Apro File OUT"
   
      'Leggo la prime 3 righe e cerco o "Result=Ok" oppure "Result=Ko"
      Do Until EOF(NumFile)
         'Leggo la riga
            iRow = iRow + 1
            Line Input #NumFile, ReadString
            
Debug.Print "Epson.Read.Out - Linea: " & ReadString
         
         'Mi ineteressa solo la riga DUE dove c' l'esito
            If iRow = 2 Then
            'Cerco l'esito
               
               If pScontrino Then
                  gtLastScontrino.StringaEsito = Mid(ReadString, 1, 255)
               End If
               
               If InStr(1, ReadString, "Result=Ok") Then
                  EpsonReadOut = 1 ' = True
                  If pScontrino Then Call GetProgressivoScontrino
                  Exit Do
               ElseIf InStr(1, ReadString, "Result=Ko") Then
                  If pScontrino Then Call GetErroreScontrino
                  Exit Do
               End If
            
            ElseIf iRow > 2 Then
               Exit Do
            End If

      Loop
   Close #NumFile
   
   
   'Se iRow = 0 significa che il file OUT era vuoto e non  possibile -
   'pertanto ripeto la lettura per almeno 5 volte con una breve pausa
   If iRow = 0 Then
      If vTentativi < 10 Then
         Debug.Print "Epson.Read.Out - File vuoto -> Ripeto Lettura tentativo " & (vTentativi + 2)
         Call PausaProgramma(1, True, True)
         vTentativi = vTentativi + 1
         GoTo RipetiLetturaFile
      Else
         Call MsgRegCasInLogFile("[EpsonReadOut] - " & "File OUT vuoto oltre 10 tentaivi", True)
      End If
   End If
   

GestErr:
   If err.Number <> 0 Then
      Dim vErrStr As String
      vErrStr = err.Number & " - " & err.Description
      Call MsgRegCasInLogFile("[EpsonReadOut] - " & vErrStr, True)
      MsgBox vErrStr & vbNewLine & vbNewLine & _
             "(Function: EpsonReadOut)", msg_Critical
   End If
   On Error GoTo 0
End Function
Private Sub GetProgressivoScontrino()
   Call MsgRegCasInLogFile("[GetProgressivoScontrino] - StringaEsito: '" & gtLastScontrino.StringaEsito & "'")
   
   If Len(Trim(gtLastScontrino.StringaEsito)) > 0 Then
      Dim i As Byte
      Dim vArr() As String
      'Ciclo sui vari parametri
      vArr = Split(gtLastScontrino.StringaEsito, "|")
      For i = 0 To UBound(vArr)
         If InStr(1, vArr(i), "ReceiptNum") > 0 Then
            Dim Y As Byte
            Dim lArr() As String
            lArr = Split(vArr(i), "=")
            gtLastScontrino.ProgFiscale = Trim(lArr(1))
            Exit Sub
         End If
      Next i
   End If
End Sub
Private Sub GetErroreScontrino()
   Call MsgRegCasInLogFile("[GetErroreScontrino] - StringaEsito: '" & gtLastScontrino.StringaEsito & "'", True)

   If Len(Trim(gtLastScontrino.StringaEsito)) > 0 Then
      Dim i As Byte
      Dim vArr() As String
      
      gtLastScontrino.ResetPrint = False
      
      'Ciclo sui vari parametri
      vArr = Split(gtLastScontrino.StringaEsito, "|")
      For i = 0 To UBound(vArr)
         If InStr(1, vArr(i), "Description") > 0 Then
            Dim Y As Byte
            Dim lArr() As String
            lArr = Split(vArr(i), "=")
            gtLastScontrino.DescErrore = Mid(Trim(lArr(1)), 1, 255) 'prendo l'intera descrizione
            
            Dim lCodArr() As String
            Dim vCodErr As String
            lCodArr = Split(vArr(i), ";")
            If UBound(lCodArr) >= 4 Then
               vCodErr = Trim(lCodArr(4))
            End If
            
            
            'cerco di mettere in chiaro l'errore
            If (vCodErr = "39") Then
               gtLastScontrino.DescErrInChiaro = "Documento gi Annullato"
            ElseIf (vCodErr = "40") Then
               gtLastScontrino.DescErrInChiaro = "Documento gi Reso"
            ElseIf (vCodErr = "41") Then
               gtLastScontrino.DescErrInChiaro = "Il Documento su cui si vuole fare un Reso non  pertinente." & vbNewLine & "Deve essere un Documento Commerciale"
            ElseIf (vCodErr = "42") Then
               gtLastScontrino.DescErrInChiaro = "Il Documento che si vuole Annullare non  pertinente." & vbNewLine & "Deve essere un Documento Commerciale"
            
            ElseIf (InStr(1, lArr(1), "Out of paper or cover open") > 0) Or (vCodErr = "3") Then
               gtLastScontrino.DescErrInChiaro = "Errore ricevuto dal Registratore:" & vbNewLine & vbNewLine & _
                                                 "-> verificare che non sia terminata la carta oppure che non sia aperto il coperchio"
            ElseIf (InStr(1, lArr(1), "Problema di comunicazione") > 0) Then
               gtLastScontrino.DescErrInChiaro = "Registratore non disponibile!" & vbNewLine & vbNewLine & _
                                                 "-> verificare che sia acceso e che sia visibile in rete"
            ElseIf (InStr(1, lArr(1), "Generic Error") > 0) Then
               gtLastScontrino.DescErrInChiaro = "Errore Generico!" & vbNewLine & vbNewLine & _
                                                 "(" & vArr(i) & ")"
            ElseIf (InStr(1, lArr(1), "Scontrino fiscale o fattura diretta precedente") > 0) Then
               gtLastScontrino.DescErrInChiaro = "Documento Fiscale precedente aperto"
               gtLastScontrino.ResetPrint = True
            ElseIf (InStr(1, lArr(1), "Il checksum del numero di partita IVA o codice fiscale") > 0) Then
               gtLastScontrino.DescErrInChiaro = "Partita IVA o Codice Fiscale del Cliente errati"
               gtLastScontrino.ResetPrint = True
            ElseIf (InStr(1, lArr(1), "aperto.  Pagamento in corso") > 0) Then
               gtLastScontrino.DescErrInChiaro = "Chiusura documento non consentita." & vbNewLine & "Pagamento in corso non corretto"
               gtLastScontrino.ResetPrint = True
            ElseIf (InStr(1, lArr(1), "possibile effettuare l'operazione richiesta") > 0) Then
               gtLastScontrino.DescErrInChiaro = "Non  possibile effettuare l'operazione richiesta"
               If gtParam4RegCas.pEseguiReso Then
                  gtLastScontrino.DescErrInChiaro = gtLastScontrino.DescErrInChiaro & vbNewLine & "Probabilmente il Documento di origine non  stato emesso da questo Registratore"
               End If
            ElseIf (InStr(1, lArr(1), "possibile eseguire al momento l'operazione richiesta") > 0) Then
               gtLastScontrino.DescErrInChiaro = "Non  possibile eseguire al momento l'operazione richiesta"
               If gtParam4RegCas.pEseguiReso Then
                  gtLastScontrino.DescErrInChiaro = gtLastScontrino.DescErrInChiaro & vbNewLine & "Probabilmente l'importo del Documento di Reso  maggiore del Documento di origine"
                  gtLastScontrino.ResetPrint = True
               End If
            
            Else
               gtLastScontrino.DescErrInChiaro = gtLastScontrino.DescErrore
            End If
            
            gtLastScontrino.ProgFiscale = -1 'in segno di ERRORE
            Exit Sub
         End If
      Next i
   End If
End Sub
Public Sub AzzeraTypeLastScontrino()

   'Setto i parametri fissi: Seriale del Documento e Codice Cliente
      '.DocSerial = gtParam4RegCas.pSerial
      '.CodiceConto = gtParam4RegCas.pCodConto
   
   'Azzero gli altri parametri
      gtLastScontrino.DescErrInChiaro = ""
      gtLastScontrino.DescErrore = ""
      gtLastScontrino.FilePrint = ""
      gtLastScontrino.ProgFiscale = 0
      gtLastScontrino.StringaEsito = ""
      gtLastScontrino.ResetPrint = False
      
      gtLastScontrino.EsitoPerDB = ""

End Sub
Public Sub EpsonGetVatTable(pPathIN As String, pPathOut As String, pSyncroON As Boolean)
   On Error Resume Next
   
   Dim vFileName As String
   Dim NumFile As Integer 'per aprire il file che mi serve per storicizzare lo scontrino ed eventualmente ristamparlo
   Dim i As Byte
   
   NumFile = FreeFile
      
   'Setto il nome del file FUNZIONE
      vFileName = EpsonSetNamePrintFile("scoGetVatTable")
         
   'distruggo un eventuale file Status creato precedentemente
      'Kill pPathOut & vFileName
      'Sleep 200
      
   'PRINT DISPLAY ***
      Kill App.path & "\temp_" & vFileName
      Open App.path & "\temp_" & vFileName For Append As #NumFile      'CREO IL FILE
         
      'RIGHE
         'Print #NumFile, "printerCommand"
         'Print #NumFile, "Printer|1"
         'Print #NumFile, "displayText|1|   *** PRIMO ***"  'Scrivo sul display
         'Print #NumFile, "queryPrinterStatus|1|Printer1_Status.txt" 'comando
         
         Print #NumFile, "printerCommand"
         Print #NumFile, "Printer|1"
         'indico che deve leggere tutte le aliquote dalla 01 alla 09
            For i = 1 To 9
               Print #NumFile, "directIO|GetVatTable|" & IIf(i < 10, "0" & i, i)
               Print #NumFile, "printReadProperty|LastAliquota"
            Next i
                                          
      Close #NumFile
      FileCopy App.path & "\temp_" & vFileName, pPathIN & vFileName
      If pSyncroON Then
         Call EpsonMakeSyncroFile(pPathIN, vFileName)
      End If
      Kill App.path & "\temp_" & vFileName
      
'ESITO - - -
      If EpsonReadOut(pPathOut & vFileName) = 1 Then
         'MsgBox "Comunicazione col Registratore Epson 'OK'", msg_Confirmation
                     
            'Dim NumFile As Integer
            Dim ReadString As String
            Dim iRow As Byte
            Dim vMsg As String
            
            NumFile = FreeFile
            Open pPathOut & vFileName For Input As #NumFile
               'Leggo la prime 3 righe e cerco o "Result=Ok" oppure "Result=Ko"
               Do Until EOF(NumFile)
                  'Leggo la riga
                     iRow = iRow + 1
                     Line Input #NumFile, ReadString
                  
                  'Mi ineteressa solo la riga DUE dove c' l'esito
                     If iRow = 3 Then
                        Dim vArr() As String
                        vArr = Split(ReadString, "|")
                        For i = 0 To UBound(vArr)
                           If Len(Trim(vArr(i))) > 0 Then
                              vMsg = vMsg & _
                                     "Indice " & IIf((i + 1) < 10, "0" & (i + 1), (i + 1)) & _
                                     Replace(vArr(i), "LastAliquota=", " = IVA ") & "%" & vbNewLine
                           End If
                        Next i
                        Exit Do
                     End If
                     
               Loop
            Close #NumFile
                        
            'ESENZIONI FISSE !!!
               vMsg = vMsg & vbNewLine & "*** ESENZIONI FISSE ***" & vbNewLine
               vMsg = vMsg & "Indice 00 = 'ES - N4' (Esente)" & vbNewLine
               vMsg = vMsg & "Indice 10 = 'EE - N1' (Esclusa ex art. 15)" & vbNewLine
               vMsg = vMsg & "Indice 11 = 'NS - N2' (Non soggetta)" & vbNewLine
               vMsg = vMsg & "Indice 12 = 'NI - N3' (Non imponibile)" & vbNewLine
               vMsg = vMsg & "Indice 13 = 'RM - N5' (Regime del margine)" & vbNewLine
               vMsg = vMsg & "Indice 14 = 'AL - N6' (Altro non IVA)"
               
            
            MsgBox vMsg, msg_Information, "Aliquote IVA presenti nel Registratore"
            
      Else
         If VerificaEsistenzaFile(pPathIN & vFileName) Then
            Call PausaProgramma(1, True, True)
            Call KillaFile(pPathIN & Replace(vFileName, ".txt", ".*")) 'faccio l'* perch potrebbe esserci anche il file .on di syncronizzazione
         End If
         MsgBox "Comunicazione col Registratore Epson 'KO'", msg_Critical
      End If
      
   On Error GoTo 0
End Sub
Public Function EpsonSetTable(pPathIN As String, pPathOut As String, pFileConfig As String, pSyncroON As Boolean) As Boolean
   On Error Resume Next
   
   Dim vFileName As String
      
   'Setto il nome del file FUNZIONE
      'vFileName = "scoSetVatTable.txt"
      vFileName = EpsonSetNamePrintFile("scoSetTable")
   
   'Invio il file in Stampa
      FileCopy pFileConfig, pPathIN & vFileName
      If pSyncroON Then
         Call EpsonMakeSyncroFile(pPathIN, vFileName)
      End If
            
   'Verifico l'esito
      If EpsonReadOut(pPathOut & vFileName) = 1 Then
         EpsonSetTable = True
         MsgBox "Settaggio eseguito correttamente", msg_Information
      Else
         If VerificaEsistenzaFile(pPathIN & vFileName) Then
            Call PausaProgramma(1, True, True)
            Call KillaFile(pPathIN & Replace(vFileName, ".txt", ".*")) 'faccio l'* perch potrebbe esserci anche il file .on di syncronizzazione
         End If
         MsgBox "Problemi durante il settaggio!", msg_Critical
      End If
      
   On Error GoTo 0
End Function
Public Sub EpsonGetDepartment(pPathIN As String, pPathOut As String, pSyncroON As Boolean)
   On Error Resume Next
   
   Dim vFileName As String
   Dim NumFile As Integer 'per aprire il file che mi serve per storicizzare lo scontrino ed eventualmente ristamparlo
   Dim i As Byte
   
   NumFile = FreeFile
      
   'Setto il nome del file FUNZIONE
      vFileName = EpsonSetNamePrintFile("scoGetDepartment")
         
   'distruggo un eventuale file Status creato precedentemente
      'Kill pPathOut & vFileName
      'Sleep 200
      
   'PRINT DISPLAY ***
      Kill App.path & "\temp_" & vFileName
      Open App.path & "\temp_" & vFileName For Append As #NumFile      'CREO IL FILE
         
      'RIGHE
         'Print #NumFile, "printerCommand"
         'Print #NumFile, "Printer|1"
         'Print #NumFile, "displayText|1|   *** PRIMO ***"  'Scrivo sul display
         'Print #NumFile, "queryPrinterStatus|1|Printer1_Status.txt" 'comando
         
         Print #NumFile, "printerCommand"
         Print #NumFile, "Printer|1"
         'indico che deve leggere tutte le aliquote dalla 01 alla 09
            For i = 1 To 19
               Print #NumFile, "directIO|GetDepartment|0" & i
               Print #NumFile, "printReadProperty|LastNReparto"
               Print #NumFile, "printReadProperty|LastDescReparto"
               Print #NumFile, "printReadProperty|LastNTassaRep"
            Next i
                                          
      Close #NumFile
      FileCopy App.path & "\temp_" & vFileName, pPathIN & vFileName
      If pSyncroON Then
         Call EpsonMakeSyncroFile(pPathIN, vFileName)
      End If
      Kill App.path & "\temp_" & vFileName
      
'ESITO - - -
      If EpsonReadOut(pPathOut & vFileName) = 1 Then
         'MsgBox "Comunicazione col Registratore Epson 'OK'", msg_Confirmation
                     
            'Dim NumFile As Integer
            Dim ReadString As String
            Dim iRow As Byte
            Dim vMsg As String
            
            NumFile = FreeFile
            Open pPathOut & vFileName For Input As #NumFile
               'Leggo la prime 3 righe e cerco o "Result=Ok" oppure "Result=Ko"
               Do Until EOF(NumFile)
                  'Leggo la riga
                     iRow = iRow + 1
                     Line Input #NumFile, ReadString
                  
                  'Mi ineteressa solo la riga DUE dove c' l'esito
                     If iRow = 3 Then
                        Dim vArr() As String
                        vArr = Split(ReadString, "|")
                        
                        Dim yPart As Byte
                        For i = 0 To UBound(vArr)
                           If Len(Trim(vArr(i))) > 0 Then
                              
                              If InStr(1, vArr(i), "LastNReparto") > 0 Then
                                 'If i > 0 Then vMsg = vMsg & vbNewLine
                                 vMsg = vMsg & "Reparto " & Replace(vArr(i), "LastNReparto=", " ") & " -- "
                                 
                              ElseIf InStr(1, vArr(i), "LastDescReparto") > 0 Then
                                 vMsg = vMsg & _
                                        "" & Trim(Replace(vArr(i), "LastDescReparto=", " ")) & " -- "
                              
                              ElseIf InStr(1, vArr(i), "LastNTassaRep") > 0 Then
                                 vMsg = vMsg & _
                                        "Indice IVA" & Replace(vArr(i), "LastNTassaRep=", " = ") & vbNewLine
                                 
                                 'ultima parte del reparto e quini agguingo alla fine della riga un 'ACCAPO'
                              End If
                              
                           End If
                        Next i

'Command
'Printer= 1|CashDesk= 0|Result=Ok|Time=03/06/2019 19:32:00
'LastNReparto=1|LastDescReparto=PRODOTTO  1         |LastNTassaRep=1| & _
 LastNReparto=2|LastDescReparto=PRODOTTO  2         |LastNTassaRep=2| & _
 LastNReparto=3|LastDescReparto=PRODOTTO  3         |LastNTassaRep=3| & _
 LastNReparto=4|LastDescReparto=PRODOTTO  4         |LastNTassaRep=4| & _
 LastNReparto=5|LastDescReparto=PRODOTTO  5         |LastNTassaRep=1| & _
 LastNReparto=6|LastDescReparto=PRODOTTO  6         |LastNTassaRep=1|
                        Exit Do
                     End If
                     
               Loop
            Close #NumFile
            
            MsgBox vMsg, msg_Information, "Reparti presenti nel Registratore"
            
      Else
         If VerificaEsistenzaFile(pPathIN & vFileName) Then
            Call PausaProgramma(1, True, True)
            Call KillaFile(pPathIN & Replace(vFileName, ".txt", ".*")) 'faccio l'* perch potrebbe esserci anche il file .on di syncronizzazione
         End If
         MsgBox "Comunicazione col Registratore Epson 'KO'", msg_Critical
      End If
      
   On Error GoTo 0
End Sub
Public Sub EpsonResetPrinter(Optional pPathFIleConf As String)
   'mi serve per comandare il reset della stampante in caso di errore di un documento
   Dim vFileCommand As String
   Dim vPathIN As String
   Dim vFileName As String
   'Dim vPatOUT As String
   Dim vSyncroON As Boolean
   Dim vPathFIle4Conf As String
      
   On Error Resume Next
   
   
   If Len(Trim(pPathFIleConf)) > 0 Then
      vPathFIle4Conf = pPathFIleConf
   Else
      vPathFIle4Conf = mPathFileConf4Scontrino
   End If

   
   If ReadINI("PARAMETRI", "COMUNICAZIONE", vPathFIle4Conf) = "WebService" Then
      Dim vInd_IP As String
      Dim vPORT As String
      Dim vFileSet As String
      Dim vArrCmd() As String
      
      vInd_IP = ReadINI("RETE", "IP", vPathFIle4Conf)
      vPORT = ReadINI("RETE", "PORT", vPathFIle4Conf)
         
      vFileSet = App.path & "\Files\RegCas\Custom\EpsonCommand\xcmdResetPrinter.xml"
      
      If VerificaEsistenzaFile(vFileSet) Then
         Call EPSONSendCommand(vInd_IP, vPORT, "ResetPrinter", vArrCmd, "", vFileSet)
            Call VisualizzaMsgBoxPopUp("msg_ok", "", "Comando inviato", True)
      Else
         MsgBox "Impossibile trovare il file di configurazione:" & vbNewLine & _
                vFileSet, msg_Exclamation
      End If

      
   Else
   
      vFileName = EpsonSetNamePrintFile("scoResetPrinter")
      
      If Len(Trim(pPathFIleConf)) > 0 Then
         vPathFIle4Conf = pPathFIleConf
      Else
         vPathFIle4Conf = mPathFileConf4Scontrino
      End If
            
      vPathIN = ReadINI("PARAMETRI", "PATH_IN", vPathFIle4Conf)
      vSyncroON = (ReadINI("PARAMETRI", "SYNCRO_ON", vPathFIle4Conf) = "1")
         
         
      vFileCommand = App.path & "\Files\RegCas\Custom\EpsonCommand\cmdResetPrinter.txt"
      'Se arriva qui ed  compilato il file di configurazione allora eseguo il comando di SET
      'If Len(Trim(vFileSet)) > 0 Then
         If VerificaEsistenzaFile(vFileCommand) Then
            Call MsgRegCasInLogFile("[EpsonResetPrinter] - FileCopy: from '" & vFileCommand & "'  to '" & vPathIN & vFileName & "'")
            FileCopy vFileCommand, vPathIN & vFileName
            If (ReadINI("PARAMETRI", "SYNCRO_ON", mPathFileConf4Scontrino) = "1") Then
               Call EpsonMakeSyncroFile(vPathIN, vFileName)
            End If
         End If
      'End If

   End If
End Sub
Public Sub EpsonChiusuraFiscale(Optional pPathFIleConf As String)
   'mi serve per comandare il reset della stampante in caso di errore di un documento
   Dim vFileCommand As String
   Dim vPathIN As String
   Dim vFileName As String
   'Dim vPatOUT As String
   Dim vSyncroON As Boolean
   Dim vPathFIle4Conf As String
   
   On Error Resume Next


   If Len(Trim(pPathFIleConf)) > 0 Then
      vPathFIle4Conf = pPathFIleConf
   Else
      vPathFIle4Conf = mPathFileConf4Scontrino
   End If

   
   If ReadINI("PARAMETRI", "COMUNICAZIONE", vPathFIle4Conf) = "WebService" Then
      Dim vInd_IP As String
      Dim vPORT As String
      Dim vFileSet As String
      Dim vArrCmd() As String
      
      vInd_IP = ReadINI("RETE", "IP", vPathFIle4Conf)
      vPORT = ReadINI("RETE", "PORT", vPathFIle4Conf)
         
      'If pComando = "ChiusuraFiscale" Then
         vFileSet = App.path & "\Files\RegCas\Custom\EpsonCommand\xcmdZReport.xml"
      'ElseIf pComando = "Reset" Then
      '   vFileSet = App.path & "\Files\RegCas\Custom\RCHCommand\cmdResetPrinter.txt"
      'End If
      
      'Se arriva qui ed  compilato il file di configurazione allora eseguo il comando di SET
      'If Len(Trim(vFileSet)) > 0 Then
         If VerificaEsistenzaFile(vFileSet) Then
            'Call RCHSendCommand(vInd_IP, vPORT, pComando, "", "", vFileSet)
            Call EPSONSendCommand(vInd_IP, vPORT, "zReport", vArrCmd, "", vFileSet)
               'MsgBox "Settaggio eseguito correttamente", msg_Confirmation
               Call VisualizzaMsgBoxPopUp("msg_ok", "", "Comando inviato", True)
            
         Else
            MsgBox "Impossibile trovare il file di configurazione:" & vbNewLine & _
                   vFileSet, msg_Exclamation
         End If
      'End If
      
   Else
   
      vFileName = EpsonSetNamePrintFile("scoChiusuraFiscale")
                  
      vPathIN = ReadINI("PARAMETRI", "PATH_IN", vPathFIle4Conf)
      vSyncroON = (ReadINI("PARAMETRI", "SYNCRO_ON", vPathFIle4Conf) = "1")
      
      
      vFileCommand = App.path & "\Files\RegCas\Custom\EpsonCommand\cmdZReport.txt"
      'Se arriva qui ed  compilato il file di configurazione allora eseguo il comando di SET
      'If Len(Trim(vFileSet)) > 0 Then
         If VerificaEsistenzaFile(vFileCommand) Then
            Call MsgRegCasInLogFile("[EpsonChiusuraFiscale] - FileCopy: from '" & vFileCommand & "'  to '" & vPathIN & vFileName & "'")
            FileCopy vFileCommand, vPathIN & vFileName
            If vSyncroON Then
               Call EpsonMakeSyncroFile(vPathIN, vFileName)
            End If
         End If
      'End If

   End If
End Sub
Public Function EpsonCheckRTStatus(pParameter As String) As String()
   'In pParameter mi ariva la stringa del tipo _
      esempio ->   "LastRTDeviceType=M" _
    quindi la splitto per decodificarne lo stato _
    (nell'esempio  riportato il parametro "RT Device Type" e il _
     valore "M" indica che si tratta di "MF Type converted in RT")
   
   'Questa funzione risponde con un array dove in 0 c' la descrizione _
    tradotta del parametro ed in 1 c' il valore del parametro (sempre tradotto)
   Dim vReturnArr() As String
   Dim vArr() As String
   vArr = Split(pParameter, "=")
   
   ReDim vReturnArr(1)
   
   Select Case Trim(vArr(0))
      Case "LastRTDeviceType"
         vReturnArr(0) = "Tipo dispositivo RT"
         Select Case vArr(1)
            Case "M": vReturnArr(1) = "Misuratore fiscale convertito in RT"
            Case "I": vReturnArr(1) = "Internal"
            Case "E": vReturnArr(1) = "External"
            Case "P": vReturnArr(1) = "Palmtop"
            Case "S": vReturnArr(1) = "Server RT"
         End Select
      Case "LastRTMainState"
         vReturnArr(0) = "Stato principale"
         Select Case UCase(vArr(1))
            Case "1", "01": vReturnArr(1) = "Modalit 'MF'"
            Case "2", "02": vReturnArr(1) = "Modalit 'RT'"
         End Select
      Case "LastRTSubState"
         vReturnArr(0) = "Stato secondario"
         Select Case UCase(vArr(1))
            Case "2", "02": vReturnArr(1) = "Certificati mancanti"
            Case "3", "03", "4", "04": vReturnArr(1) = "Certificati incompleti"
            Case "5", "05": vReturnArr(1) = "Da censire"
            Case "6", "06": vReturnArr(1) = "Censito"
            Case "7", "07": vReturnArr(1) = "Attivato"
            Case "8", "08": vReturnArr(1) = "Programmato 'RT'"
            Case Else
               vReturnArr(1) = "'RT' in servizio"
         End Select
      Case "LastRTDayOpened"
         vReturnArr(0) = "Giorno aperto"
         Select Case UCase(vArr(1))
            Case "0", "00", "FALSE": vReturnArr(1) = "NO"
            Case "1", "01", "TRUE": vReturnArr(1) = "SI"
         End Select
      Case "LastRTNonWorkingPeriod"
         vReturnArr(0) = "Periodo inattivo"
         Select Case UCase(vArr(1))
            Case "0", "00", "FALSE": vReturnArr(1) = "NO"
            Case "1", "01", "TRUE": vReturnArr(1) = "SI"
         End Select
      Case "LastRTNumberOfCurrentFiles"
         vReturnArr(0) = "Numero Files del giorno in attesa di invio"
         vReturnArr(1) = vArr(1)
      Case "LastRTNumberOfOldFiles"
         vReturnArr(0) = "Numero vecchi Files in attesa di invio"
         vReturnArr(1) = vArr(1)
      Case "LastRTNumberOfRejectedFiles"
         vReturnArr(0) = "Numero Files rifiutati"
         vReturnArr(1) = vArr(1)
'      Case "LastRTDateDeviceCertificateExpiration"
'
'      Case "LastRTDateCAAECertificateExpiration"
'
'      Case "LastRTFirmwareBuildNumber"
'
'      Case "LastRTSDFileSystemVersionNumber"
'
      Case "LastRTTrainingDemoSimulationMode"
         vReturnArr(0) = "Modalit DEMO"
         Select Case UCase(vArr(1))
            Case "0", "00", "FALSE": vReturnArr(1) = "NO"
            Case "1", "01", "TRUE": vReturnArr(1) = "SI"
         End Select
   End Select
      
   EpsonCheckRTStatus = vReturnArr
      
'RICHIESTA IN 'IN'
   'printerCommand
   'Printer|1
   'directIO|PrinterRTStatus|1
   'printReadProperty|LastRTDeviceType
   'printReadProperty|LastRTMainState
   'printReadProperty|LastRTSubState
   'printReadProperty|LastRTDayOpened
   'printReadProperty|LastRTNonWorkingPeriod
   'printReadProperty|LastRTNumberOfCurrentFiles
   'printReadProperty|LastRTNumberOfOldFiles
   'printReadProperty|LastRTNumberOfRejectedFiles
'   'printReadProperty|LastRTDateDeviceCertificateExpiration
'   'printReadProperty|LastRTDateCAAECertificateExpiration
'   'printReadProperty|LastRTFirmwareBuildNumber
'   'printReadProperty|LastRTSDFileSystemVersionNumber
   'printReadProperty|LastRTTrainingDemoSimulationMode

'RISPOSTA IN 'OUT'
   'Command
   'Printer= 1|CashDesk= 0|Result=Ok|Time=04/06/2019 16:17:26
   'LastRTDeviceType=M|LastRTMainState=1|LastRTSubState=6|LastRTDayOpened=True|LastRTNonWorkingPeriod=False|LastRTNumberOfCurrentFiles=0|LastRTNumberOfOldFiles=0|LastRTNumberOfRejectedFiles=0|LastRTDateDeviceCertificateExpiration=13/05/2027|LastRTDateCAAECertificateExpiration=11/01/2038|LastRTFirmwareBuildNumber=184|LastRTSDFileSystemVersionNumber=2|LastRTTrainingDemoSimulationMode=0|
   
End Function
Public Function EpsonSetNamePrintFile(pFileName As String) As String
   'questa funzione la uso per creare il nome del file da inviare nella cartella IN utilizzata dall'EpsonFpMate
   'in questo modo avro sempre un file UNIVOCO
   EpsonSetNamePrintFile = pFileName & "_" & gIDPostazione & "_" & Format(Now, "yyyy.mm.dd_hh.nn.ss") & ".txt"
End Function
Public Sub EpsonMakeSyncroFile(pPath As String, pFile As String)
   Call PausaProgramma(1, True, True)
   FileCopy pPath & pFile, pPath & Replace(pFile, ".txt", ".on")
End Sub


Public Function StampaVoucher_EPSON_RT(vNomeFile, pStampaValore As Boolean) As Boolean
   Dim vStrRiga As String
   Dim NumFile As Integer
   
   On Error GoTo GestErr
   
 '...altrimenti QUI INIZIO A COMPORRE IL DOCUMENTO GESTIONALE
      Call MsgRegCasInLogFile("[EpsonVOUCHER_RT] - OpenFile '" & App.path & "\" & vNomeFile & "'")
    
      NumFile = FreeFile
      Open App.path & "\" & vNomeFile For Append As #NumFile      'CREO IL FILE
      
         Print #NumFile, "printerNonFiscal"  'APERTURA DOC.GEST.
         Print #NumFile, "Printer|1"  'APERTURA DOC.GEST.
         
         Print #NumFile, "beginNonFiscal|1"  'APERTURA DOC.GEST.
   
         vStrRiga = "printNormal|1|3"  'Comando | Operatore | Font
                     vStrRiga = vStrRiga & "|" & String(22, " ")
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
                     
         vStrRiga = "printNormal|1|3"  'Comando | Operatore | Font
                     vStrRiga = vStrRiga & "|" & String(50, "=")
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
                     
         vStrRiga = "printNormal|1|3"  'Comando | Operatore | Font
                     vStrRiga = vStrRiga & "|" & String(22, " ")
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
         
         
         vStrRiga = "printNormal|1|3"  'Comando | Operatore | Font
                     vStrRiga = vStrRiga & "|" & "*** VOUCHER CARD ***"
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
                     
                     
         vStrRiga = "printNormal|1|3"  'Comando | Operatore | Font
                     vStrRiga = vStrRiga & "|" & "Codice"
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
         vStrRiga = "printNormal|1|3"  'Comando | Operatore | Font
                     vStrRiga = vStrRiga & "|" & " " & gtParam4RegCas.pVoucherID
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
                     
                     
         vStrRiga = "printNormal|1|3"  'Comando | Operatore | Font
                     vStrRiga = vStrRiga & "|" & String(22, " ")
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
                     

         vStrRiga = "printNormal|1|3"  'Comando | Operatore | Font
                     vStrRiga = vStrRiga & "|" & "Descrizione"
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
         vStrRiga = "printNormal|1|3"  'Comando | Operatore | Font
                     vStrRiga = vStrRiga & "|" & " " & gtParam4RegCas.pVoucherDescr
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
         
         
         If pStampaValore Then
               vStrRiga = "printNormal|1|3"  'Comando | Operatore | Font
                           vStrRiga = vStrRiga & "|" & String(22, " ")
                           Print #NumFile, vStrRiga 'Stampo la stringa nel File
      
      
               vStrRiga = "printNormal|1|3"  'Comando | Operatore | Font
                           vStrRiga = vStrRiga & "|" & "Valore"
                           Print #NumFile, vStrRiga 'Stampo la stringa nel File
               vStrRiga = "printNormal|1|3"  'Comando | Operatore | Font
                           vStrRiga = vStrRiga & "|" & " " & Format(gtParam4RegCas.pVoucherValue, "########0.#0")
                           Print #NumFile, vStrRiga 'Stampo la stringa nel File
         End If
         
                     
         vStrRiga = "printNormal|1|3"  'Comando | Operatore | Font
                     vStrRiga = vStrRiga & "|" & String(22, " ")
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
                     
         vStrRiga = "printNormal|1|3"  'Comando | Operatore | Font
                     vStrRiga = vStrRiga & "|" & String(50, "=")
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
                     
         Print #NumFile, "endNonFiscal|1"  'APERTURA DOC.GEST.
      
      'Chiudo il file di LOG
      Close #NumFile
      
      StampaVoucher_EPSON_RT = True
       
GestErr:
   If err.Number <> 0 Then
      MsgBox err.Number & " - " & err.Description & vbNewLine & "(Errore in funct. 'StampaVoucher')", msg_Critical
   End If
   On Error GoTo 0
       
       
End Function

'/////\\\\\/////\\\\\/////\\\\\  E P S O N   F P M A T E   E N D  /////\\\\\/////\\\\\/////\\\\\
'/////\\\\\/////\\\\\/////\\\\\  E P S O N   F P M A T E   E N D  /////\\\\\/////\\\\\/////\\\\\



'Public Function EPSONSendCommand(vIndirIP As String, vNumPort As String, NomeFunzione As String, pArrayCmd As Variant, prBuffer As String, _
                                 Optional pPathFileXml As String, Optional pPathStorico As String, Optional pRetry As Boolean) As Boolean
Public Function EPSONSendCommand(vIndirIP As String, vNumPort As String, NomeFunzione As String, pArrayCmd As Variant, prBuffer As String, _
                                 Optional pPathFileXml As String, Optional pPathStorico As String, Optional pCheckBefore As Boolean, _
                                 Optional pMsgBuffer As Boolean) As Boolean
   Dim vLink As String
   Dim vTestoMsg As String
      
   Dim oHTTP As MSXML2.XMLHTTP60, sBuffer As String
   Dim objDom As DOMDocument60
   Dim obRSchema As IXMLDOMElement
   Dim obCommand As IXMLDOMElement
   Dim obBody As IXMLDOMElement
   Dim NewNode As IXMLDOMNode
   Dim obAttrib As IXMLDOMAttribute
   Dim currentElement As IXMLDOMElement
   
   Dim sStatusText As String
   Dim sStatus As Long
   Dim vrBusy As Boolean
   Dim commandXML As String
   Dim i As Integer
   
   
   On Error GoTo GestErr
      
   Call MsgRegCasInLogFile("[EPSONSendCommand] - Start command: " & NomeFunzione & IIf(pCheckBefore, " - CHECK BEFORE", ""))

   Call AzzeraLastEPSONRequest
   
   'Apertura comunicazione con Service.cgi del Registratore ed invio COMANDO
      Set oHTTP = CreateObject("MSXML2.ServerXMLHTTP")
      oHTTP.Open "POST", "http://" & vIndirIP & "/cgi-bin/fpmate.cgi?devid=local_printer&timeout=10000", False
      oHTTP.setRequestHeader "Content-Type", "application/xml"

            
      Set objDom = New DOMDocument60
                     
         If Len(Trim(pPathFileXml)) = 0 Then
            Set obRSchema = objDom.createElement("Envelope")
            objDom.appendChild obRSchema
               Set currentElement = objDom.selectSingleNode("Envelope")
               currentElement.setAttribute "xmlns:s", "http://schemas.xmlsoap.org/soap/envelope/"
            
            
               Set obCommand = objDom.createElement("Body")
               obRSchema.appendChild obCommand
                                             
                                             
                  Set obBody = objDom.createElement(NomeFunzione) '("printerFiscalReceipt")
                  obCommand.appendChild obBody
                     
                     Dim vArrLine() As String
                     Dim vArrAttr() As String
                     Dim vArrText() As String
                     Dim yAtt As Integer
                     
                     For i = 0 To UBound(pArrayCmd)
                        Erase vArrLine
                        vArrLine = Split(pArrayCmd(i), "#")
                        
                        Set NewNode = objDom.createNode(NODE_ELEMENT, vArrLine(0), "")
                        obBody.appendChild NewNode
                           'Set currentElement = obBody.selectSingleNode(vArrLine(0))
                           Set currentElement = obBody.lastChild
                           
                           'Setto gli attributi
                           Erase vArrAttr
                           vArrAttr = Split(vArrLine(1), "|") 'splitto gli eventuali 'n' attributi
                           For yAtt = 0 To UBound(vArrAttr)
                              vArrText = Split(vArrAttr(yAtt), "=") 'splitto l'attributo tra Parametro e Valore
                              currentElement.setAttribute vArrText(0), vArrText(1)
                           Next yAtt
                     Next i
                        
         Else
            commandXML = objDom.Load(pPathFileXml) 'File diretto
         End If
         
         commandXML = objDom.xml
         oHTTP.send commandXML  'Invio nel BODY la sequenza di comandi XML da far elaborare


         Set obRSchema = Nothing
         Set obCommand = Nothing
         Set obBody = Nothing
         Set NewNode = Nothing
         Set obAttrib = Nothing
         Set currentElement = Nothing


      sBuffer = oHTTP.responseText
      sStatusText = oHTTP.statusText
      sStatus = oHTTP.Status
      Set oHTTP = Nothing


      If Len(pPathStorico) > 0 Then
         objDom.Save (pPathStorico)
      End If


   'Risposta EPSON
      If sStatus = 200 Then

         Call MsgRegCasInLogFile("[EPSONSendCommand] - ReadState: " & sBuffer) 'Registro la risposta nel LOG
         
         Dim vGetParametri As Boolean
         vGetParametri = (NomeFunzione = "printerFiscalReceipt")
         
         If EPSON_ReadState(sBuffer, vGetParametri) Then ', pRetry, vrBusy) Then

            prBuffer = sBuffer
            EPSONSendCommand = True

            ''Salvo in storico se previsto
            'If Len(pPathStorico) > 0 Then
            '   objDom.Save (pPathStorico)
            'End If

         End If

      Else

         MsgBox "Messaggio dal Server:" & vbNewLine & _
                sBuffer & vbNewLine & _
                sStatus & " - " & sStatusText, msg_Critical
         
         Call MsgRegCasInLogFile("[EPSONSendCommand] - ERROR command: " & sStatus & " - " & sStatusText, True)
         
      End If

      Set objDom = Nothing


GestErr:
   If err.Number <> 0 Then
      Dim vErrStr As String
      Dim vEMsgTimeout As String
      
      If err.Number = -2147012894 Then vEMsgTimeout = "PROBLEMI DI COMUNICAZIONE CON IL REGISTRATORE" & vbNewLine & "VERIFICARE SIA ACCESO E COLLEGATO ALLA RETE INTERNA"
      
      vErrStr = err.Number & " - " & err.Description
      Call MsgRegCasInLogFile("[EPSONSendCommand] - " & vErrStr, True)
      
      MsgBox vEMsgTimeout & vbNewLine & vbNewLine & _
             vErrStr & vbNewLine & _
             "(EPSONSendCommand)", vbCritical
      
      If pMsgBuffer Then
         MsgBox sBuffer, vbCritical, "<<< BUFFER di RISPOSTA >>>"
      End If
   End If
   On Error GoTo 0
            
   Call MsgRegCasInLogFile("[EPSONSendCommand] - End command: " & NomeFunzione)

End Function


Public Function EPSON_ReadState(pStrXml As String, pGetParametri As Boolean) As Boolean  ', pRetry As Boolean, prBusy As Boolean) As Boolean
   Dim XmlDoc As New DOMDocument60
   'Dim nodlst As IXMLDOMNodeList
   'Dim wordNode As IXMLDOMNode
   'Dim vEsitoInError As Boolean
   Dim msgError As Boolean
   Dim errorText As String
   
      
   XmlDoc.async = False
   
   If XmlDoc.loadXML(pStrXml) Then
      'Call ExtractNodes(XmlDoc.childNodes, RCH_ReadState, pTag)
      
      'Dim DOM As New DOMDocument
      Dim nodes As IXMLDOMNodeList
      Dim Node As IXMLDOMNode
      Dim i As Byte

      'Set nodes = XmlDoc.selectNodes("//" & pTag)
      Set nodes = XmlDoc.selectNodes("//response")
      'Set nodes = nodes(0).childNodes
      
      Dim vVal As String
            
      
      gtLastScontrino.StringaEsito = "Response >> " 'apre la stringa dell'esito


'====================== INIZIO 'CONTROLLO STATO' ======================

      vVal = Trim(nodes(0).Attributes.getNamedItem("success").Text)
         If Trim(LCase(vVal)) = "true" Or Trim(vVal) = "1" Then
            ' - - -  TUTTO OK!  - - -
            gtLastScontrino.StringaEsito = "Success=TRUE" & "|" 'apre la stringa dell'esito
         Else
            gtLastEPSONRequest.printerError = True
            gtLastEPSONRequest.errorCode = Trim(nodes(0).Attributes.getNamedItem("code").Text)
            gtLastEPSONRequest.responseStatus = Trim(nodes(0).Attributes.getNamedItem("status").Text)
            gtLastEPSONRequest.errorCode = gtLastEPSONRequest.errorCode
            gtLastScontrino.StringaEsito = "Success=FALSE" & "|" 'apre la stringa dell'esito
         End If
         
         'Verifico se  andato in errore
         If gtLastEPSONRequest.printerError Then
            errorText = decod_EPSON_errorCode(gtLastEPSONRequest.errorCode, gtLastEPSONRequest.responseStatus)
            gtLastScontrino.StringaEsito = errorText
            Call MsgRegCasInLogFile(gtLastScontrino.StringaEsito, True)
            msgError = True
            GoTo SaltaQui
         End If
            
'====================== FINE 'CONTROLLO STATO' ======================


      If pGetParametri Then
      
'====================== INIZIO 'RECUPERO VALORI' ======================
   
         vVal = Trim(nodes(0).selectSingleNode("addInfo").selectSingleNode("printerStatus").Text)
               gtLastEPSONRequest.printerStatus = Trim(vVal)
            gtLastScontrino.StringaEsito = gtLastScontrino.StringaEsito & "printerStatus:" & Trim(vVal) & "|"
                     
                     
         vVal = Trim(nodes(0).selectSingleNode("addInfo").selectSingleNode("fiscalReceiptNumber").Text)
               gtLastEPSONRequest.fiscalReceiptNumber = Trim(vVal)
            gtLastScontrino.StringaEsito = gtLastScontrino.StringaEsito & "fiscalReceiptNumber:" & Trim(vVal) & "|"
            gtLastScontrino.ProgFiscale = CLng(gtLastEPSONRequest.fiscalReceiptNumber)
            
         
         vVal = Trim(nodes(0).selectSingleNode("addInfo").selectSingleNode("fiscalReceiptAmount").Text)
               gtLastEPSONRequest.fiscalReceiptAmount = Trim(vVal)
            gtLastScontrino.StringaEsito = gtLastScontrino.StringaEsito & "fiscalReceiptAmount:" & Trim(vVal) & "|"
            
         
         vVal = Trim(nodes(0).selectSingleNode("addInfo").selectSingleNode("fiscalReceiptDate").Text)
               gtLastEPSONRequest.fiscalReceiptDate = Trim(vVal)
            gtLastScontrino.StringaEsito = gtLastScontrino.StringaEsito & "fiscalReceiptDate:" & Trim(vVal) & "|"
         
         
         vVal = Trim(nodes(0).selectSingleNode("addInfo").selectSingleNode("fiscalReceiptTime").Text)
               gtLastEPSONRequest.fiscalReceiptTime = Trim(vVal)
            gtLastScontrino.StringaEsito = gtLastScontrino.StringaEsito & "fiscalReceiptTime:" & Trim(vVal) & "|"
         
         
         vVal = Trim(nodes(0).selectSingleNode("addInfo").selectSingleNode("zRepNumber").Text)
               gtLastEPSONRequest.zRepNumber = Trim(vVal)
            gtLastScontrino.StringaEsito = gtLastScontrino.StringaEsito & "zRepNumber:" & Trim(vVal) & "|"
                              
'====================== FINE 'RECUPERO VALORI' ======================

      End If
                        
                        
SaltaQui:
                        
      'tronco a 255 (lunghezza massima del campo RTTXTOUT della tabella DOC_RT_INFO)
         gtLastScontrino.StringaEsito = Mid(gtLastScontrino.StringaEsito, 1, 255)
         
      
      Set nodes = Nothing
      Set XmlDoc = Nothing
   End If
   
   
   
   'If Not (pRetry And prBusy) Then
         
      If msgError Then
         gtLastScontrino.ProgFiscale = -1 'in segno di ERRORE
      
         MsgBox gtLastScontrino.StringaEsito, msg_Critical
         Exit Function
      End If
   
      'Se rriva qui significa che non ci sono errori
      EPSON_ReadState = True
   
   'End If
   
End Function

Public Sub AzzeraLastEPSONRequest()
   gtLastEPSONRequest.errorCode = ""
   gtLastEPSONRequest.responseStatus = ""
   gtLastEPSONRequest.printerError = False
   gtLastEPSONRequest.printerStatus = ""
   gtLastEPSONRequest.fiscalReceiptNumber = ""
   gtLastEPSONRequest.fiscalReceiptAmount = ""
   gtLastEPSONRequest.fiscalReceiptDate = ""
   gtLastEPSONRequest.fiscalReceiptTime = ""
   gtLastEPSONRequest.zRepNumber = ""
End Sub

Public Function decod_EPSON_errorCode(errorCode As String, statusCode As String) As String
   Select Case UCase(errorCode)
      Case "EPTR_AUTOMATICAL": decod_EPSON_errorCode = "ERRORE RECUPERABILE"
      Case "EPTR_CUTTER": decod_EPSON_errorCode = "ERRORE DELLA TAGLIERINA"
      Case "EPTR_MECHANICAL": decod_EPSON_errorCode = "ERRORE MECCANICO"
      Case "EPTR_REC_EMPTY": decod_EPSON_errorCode = "COPERCHIO APERTO / FINE CARTA"
      Case "EPTR_UNRECOVERABLE": decod_EPSON_errorCode = "ERRORE NON RECUPERABILE"
      Case "SCHEMAERROR": decod_EPSON_errorCode = "ERRORE NELLO SCHEMA"
      Case "DEVICENOTFOUND": decod_EPSON_errorCode = "STAMPANTE (DEVICE ID) NON DISPONIBILE"
      Case "PRINTSYSTEMERROR": decod_EPSON_errorCode = "ERRORE DI SISTEMA NELLA STAMPANTE"
      Case "EX_BADPORT": decod_EPSON_errorCode = "ERRORE PORTA DI COMUNICAZIONE"
      Case "EX_TIMEOUT": decod_EPSON_errorCode = "ERRORE DI TIMEOUT"
      Case "NON VALID XML COMMAND": decod_EPSON_errorCode = "ERRORE STRUTTURA COMANDO XML"
      Case "INCOMPLETE FILE": decod_EPSON_errorCode = "FILE INVIATO INCOMPLETO"
      Case "FP_NO_ANSWER": decod_EPSON_errorCode = "ERRORE DI COMUNICAZIONE CON LA STAMPANTE" & vbNewLine & "(code: " & UCase(errorCode) & ")" 'NB: Questo errore lo d anche se FPMATE  in esecuzione
      Case "FP_NO_ANSWER_NETWORK": decod_EPSON_errorCode = "ERRORE DI COMUNICAZIONE CON LA STAMPANTE - HTTP ERROR"
      Case Else
         
         Select Case UCase(statusCode)
            Case "30": decod_EPSON_errorCode = "ERRORE CODICE FISCALE / PARTITA IVA"
            Case "39": decod_EPSON_errorCode = "DOCUMENTO GIA' ANNULLATO"
            Case "40": decod_EPSON_errorCode = "DOCUMENTO GIA' RESO INTERAMENTE"
            Case "41": decod_EPSON_errorCode = "DOCUMENTO DI RESO INDICATO NON VALIDO"
            Case "42": decod_EPSON_errorCode = "DOCUMENTO DI ANNULLO INDICATO NON VALIDO"
            Case Else
               If UCase(statusCode) = "17" And gtParam4RegCas.pEseguiReso Then
                  decod_EPSON_errorCode = "ERRORE GENERICO (code: " & UCase(errorCode) & " - status: " & statusCode & ")" & vbNewLine & vbNewLine & _
                                          "E' PROBABILE CHE L'IMPORTO SUPERI IL VALORE DEL DOCUMENTO DA RENDERE"
               Else
                  decod_EPSON_errorCode = "ERRORE GENERICO NON CODIFCATO (code: " & UCase(errorCode) & " - status: " & statusCode & ")" & vbNewLine & vbNewLine & _
                                          "VERIFICARE CHE NON SIA NECESSARIA UNA 'CHIUSURA FISCALE' (Eseguire un TEST e verificare il parametro 'Periodo di lavoro')"
               End If
         End Select
   End Select
End Function '<response success="false" code="FP_NO_ANSWER" status="0">


Public Sub EpsonCGIGetVatTable(vIndirIP As String, vNumPort As String)
   Dim vResponse As String
   Dim pStrXml As String
   Dim vArrCmd() As String
   Dim vMsg As String
   Dim i As Byte
   
   On Error GoTo GestErr
        
        
   For i = 1 To 9
      
      'Preparo l'array con le istruzioni che formano l'XML
      Erase vArrCmd
      Call AddArrayElement(vArrCmd, "directIO#command=4205|data=0" & Trim(Str(i)))
      
      Call MsgRegCasInLogFile("[EPSONSendCommand] - Read VAT > Command: " & "directIO#command=4205|data=0" & Trim(Str(i)) & " " & String(20, "="))
   
   
   'Invio il comando ed attendo la risposta
      vResponse = EPSONSendCommand(vIndirIP, vNumPort, "printerCommand", vArrCmd, pStrXml, "", "", False, True)
      
      
   'Vado as interpretare la Risposta
   'Leggo la Risposta
      If vResponse And (Len(Trim(pStrXml)) > 0) Then
      
         Dim XmlDoc As New DOMDocument60
         XmlDoc.async = False
         
         If XmlDoc.loadXML(pStrXml) Then
            Dim nodes As IXMLDOMNodeList
            Set nodes = XmlDoc.selectNodes("//response//responseData")
               
               Call MsgRegCasInLogFile("[EPSONSendCommand] - Read VAT > Response: " & nodes(0).Text & " " & String(20, "="))
               Call MsgRegCasInLogFile("")
               
               vMsg = vMsg & "Indice 0" & Trim(Str(i)) & " = " & Mid(nodes(0).Text, 3, 2) & "," & Mid(nodes(0).Text, 5, 2) & "%" & vbNewLine
            
            Set nodes = Nothing
            Set XmlDoc = Nothing
         End If
               
      Else
         MsgBox "Errore in fase di lettura di Codici IVA" & vbNewLine & _
                "(Codice " & i & ")", msg_Critical, "Tabella Codici IVA"
      End If
   
   Next i
   
   
   'ESENZIONI FISSE !!!
      vMsg = vMsg & vbNewLine & "*** ESENZIONI FISSE ***" & vbNewLine
      vMsg = vMsg & "Indice 00 = 'ES - N4' (Esente)" & vbNewLine
      vMsg = vMsg & "Indice 10 = 'EE - N1' (Esclusa ex art. 15)" & vbNewLine
      vMsg = vMsg & "Indice 11 = 'NS - N2' (Non soggetta)" & vbNewLine
      vMsg = vMsg & "Indice 12 = 'NI - N3' (Non imponibile)" & vbNewLine
      vMsg = vMsg & "Indice 13 = 'RM - N5' (Regime del margine)" & vbNewLine
      vMsg = vMsg & "Indice 14 = 'AL - N6' (Altro non IVA)"
            
            
   MsgBox vMsg, msg_Information, "Tabella Codici IVA"

   
   
GestErr:
   If err.Number <> 0 Then
      MsgBox "ERRORE!" & vbNewLine & _
             err.Number & " - " & err.Description, msg_Critical
   End If
   On Error GoTo 0
End Sub
Public Sub EpsonCGISetVatTable(vIndirIP As String, vNumPort As String)
   Dim vFileSet As String
   
   Dim vResponse As String
   'Dim pStrXml As String
   Dim vArrCmd() As String
   Dim vMsg As String
   Dim i As Byte
   
   On Error GoTo GestErr
        
        
   For i = 1 To 5 'Ciclo su 5 file anche se al momento ci servono solo 3 codici IVA da settare. _
                   Questo ci consente di creare altri due nuovi file per eventuali altre IVA senza _
                   dover compilare per forza
      vFileSet = App.path & "\Files\RegCas\Custom\EpsonCommand\xsetTabIVA0" & Trim(Str(i)) & ".xml"
      
      If VerificaEsistenzaFile(vFileSet) Then
         If EPSONSendCommand(vIndirIP, vNumPort, "ResetPrinter", vArrCmd, "", vFileSet, "", False, True) Then
            
            vMsg = vMsg & "Codice IVA 0" & Trim(Str(i)) & "  (file: xsetTabIVA0" & Trim(Str(i)) & ".xml)" & vbNewLine
            
         Else
            
            vMsg = "Povare ad eseguire una 'Chiusura Fiscale', quindi ripetere l'operazione"
            Exit For
         
         End If
             'Call VisualizzaMsgBoxPopUp("msg_ok", "", "Comando inviato", True)
      Else
         vMsg = vMsg & "Codice IVA 0" & Trim(Str(i)) & "  (file: NON TROVATO)" & vbNewLine
      End If
      
   Next i
            
   MsgBox vMsg, msg_Information, "Configurazione Codici IVA"
   
   
GestErr:
   If err.Number <> 0 Then
      MsgBox "ERRORE!" & vbNewLine & _
             err.Number & " - " & err.Description, msg_Critical
   End If
   On Error GoTo 0
End Sub




Public Sub EpsonCGIGetDepartment(vIndirIP As String, vNumPort As String)
   Dim vResponse As String
   Dim pStrXml As String
   Dim vArrCmd() As String
   Dim vMsg As String
   Dim i As Byte
   
   On Error GoTo GestErr
        
        
   For i = 1 To 15
      
      'Preparo l'array con le istruzioni che formano l'XML
      Erase vArrCmd
      Call AddArrayElement(vArrCmd, "directIO#command=4202|data=" & IIf(i < 10, "0" & Trim(Str(i)), Trim(Str(i))))
         
      Call MsgRegCasInLogFile("[EPSONSendCommand] - Read DEPARTMENT > Command: " & "directIO#command=4202|data=" & IIf(i < 10, "0" & Trim(Str(i)), Trim(Str(i))) & " " & String(20, "="))
      
   'Invio il comando ed attendo la risposta
      vResponse = EPSONSendCommand(vIndirIP, vNumPort, "printerCommand", vArrCmd, pStrXml, "", "", False, True)
      
      
   'Vado as interpretare la Risposta
   'Leggo la Risposta
      If vResponse And (Len(Trim(pStrXml)) > 0) Then
      
         Dim XmlDoc As New DOMDocument60
         XmlDoc.async = False
         
         If XmlDoc.loadXML(pStrXml) Then
            Dim nodes As IXMLDOMNodeList
            Set nodes = XmlDoc.selectNodes("//response//responseData")
                        
               Call MsgRegCasInLogFile("[EPSONSendCommand] - Read DEPARTMENT > Response: " & nodes(0).Text & " " & String(20, "="))
               Call MsgRegCasInLogFile("")
                        
               vMsg = vMsg & "Reparto " & Mid(nodes(0).Text, 1, 2) & " = " & Trim(Mid(nodes(0).Text, 3, 20)) & " - Codice IVA: " & Trim(Mid(nodes(0).Text, 51, 2)) & vbNewLine
            
            Set nodes = Nothing
            Set XmlDoc = Nothing
         End If
               
      Else
         MsgBox "Errore in fase di lettura dei Reparti" & vbNewLine & _
                "(Codice " & i & ")", msg_Critical, "Tabella Reparti"
      End If
   
   Next i
   
            
   MsgBox vMsg, msg_Information, "Tabella Reparti"

   
   
GestErr:
   If err.Number <> 0 Then
      MsgBox "ERRORE!" & vbNewLine & _
             err.Number & " - " & err.Description, msg_Critical
   End If
   On Error GoTo 0

End Sub
Public Sub EpsonCGISetDepartment(vIndirIP As String, vNumPort As String)
   Dim vFileSet As String
   
   Dim vResponse As String
   'Dim pStrXml As String
   Dim vArrCmd() As String
   Dim vMsg As String
   Dim i As Byte
   Dim vPrg As String
   
   On Error GoTo GestErr
      
        
   For i = 1 To 15 'Ciclo su 15 file: dall'1 al 9 sono reparti liberi (al momento ce ne servono solo 6). _
                    I Reparti da 10 a 15 sono delegati alla gestione delle esenzioni. Nello specifico noi _
                    usiamo generalmente solo l'aliquota 'N4 Esenti' associata al Reparto 13
      
      vPrg = IIf(i < 10, "0" & Trim(Str(i)), Trim(Str(i)))
            
      vFileSet = App.path & "\Files\RegCas\Custom\EpsonCommand\xsetTabReparto" & vPrg & ".xml"
      
      If VerificaEsistenzaFile(vFileSet) Then
         If EPSONSendCommand(vIndirIP, vNumPort, "ResetPrinter", vArrCmd, "", vFileSet, "", False, True) Then
            
            vMsg = vMsg & "Reparto " & vPrg & "  (file: xsetTabReparto" & vPrg & ".xml)" & vbNewLine
            
         Else
            
            vMsg = "Povare ad eseguire una 'Chiusura Fiscale', quindi ripetere l'operazione"
            Exit For
         
         End If
     
      Else
         vMsg = vMsg & "Reparto " & vPrg & "  (file: NON TROVATO)" & vbNewLine
      End If
      
   Next i
            
   MsgBox vMsg, msg_Information, "Configurazione Reparti"
   
   
GestErr:
   If err.Number <> 0 Then
      MsgBox "ERRORE!" & vbNewLine & _
             err.Number & " - " & err.Description, msg_Critical
   End If
   On Error GoTo 0
End Sub



'Public Function queryPrinterStatus(vIP As String, vPORT As String) As Boolean
'   Dim vResponse As Boolean
'   Dim pStrXml As String
'   Dim vArrCmd() As String
'   Dim strOut As String
'
'
'   'Preparo l'array con le istruzioni che formano l'XML
'      Erase vArrCmd
'      Call AddArrayElement(vArrCmd, "queryPrinterStatus#operator=1|statusType=1")
'
'
'   'Invio il comando ed attendo la risposta
'      vResponse = EPSONSendCommand(vIP, vPORT, "printerCommand", vArrCmd, pStrXml, "", "", False, True)
'
'
'   'Vado as interpretare la Risposta
'   'Leggo la Risposta
'      If vResponse And (Len(Trim(pStrXml)) > 0) Then
'
'         Dim XmlDoc As New DOMDocument60
'         XmlDoc.async = False
'
'         If XmlDoc.loadXML(pStrXml) Then
'            Dim nodes As IXMLDOMNodeList
'            Dim i As Byte
'
'            Set nodes = XmlDoc.selectNodes("//response//addInfo//rtNoWorkingPeriod")
'
'
'
'            'Select Case nodes(0).selectSingleNode("rtNoWorkingPeriod").Text
'            '   Case "0": strOut = strOut & "Periodo di lavoro: Stampante operativa" & vbNewLine
'            '   Case "1": strOut = strOut & "Periodo di lavoro: Chiusura necessaria (eseguire una Chiusura fiscale)" & vbNewLine
'            'End Select
'
'            'strOut = strOut & "File in attesa di essere inviati: " & nodes(0).selectSingleNode("rtFileToSend").Text & vbNewLine
'            'strOut = strOut & "Vecchi File in attesa di essere inviati: " & nodes(0).selectSingleNode("rtOldFileToSend").Text & vbNewLine
'
'            Set nodes = Nothing
'         End If
'
'         Set XmlDoc = Nothing
'
'         'MsgBox strOut, msg_Information, "Stato Stampante"
'      End If
'
'
'End Function

Public Function EPSONCheckPeriodoInattivita(vIP As String, vPORT As String) As Boolean
   Dim vResponse As Boolean
   Dim pStrXml As String
   Dim vArrCmd() As String
   Dim strOut As String
   
   
   'Preparo l'array con le istruzioni che formano l'XML
      Erase vArrCmd
      Call AddArrayElement(vArrCmd, "queryPrinterStatus#operator=1|statusType=1")

   
   'Invio il comando ed attendo la risposta
      vResponse = EPSONSendCommand(vIP, vPORT, "printerCommand", vArrCmd, pStrXml, "", "", False, True)
      
   
   'Vado ad interpretare la Risposta
      If vResponse And (Len(Trim(pStrXml)) > 0) Then
      
         Dim XmlDoc As New DOMDocument60
         XmlDoc.async = False
   
         If XmlDoc.loadXML(pStrXml) Then
            Dim nodes As IXMLDOMNodeList
            Dim i As Byte

            Set nodes = XmlDoc.selectNodes("//response//addInfo")
            
               gEPSONCheckInattivita = (nodes(0).selectSingleNode("rtNoWorkingPeriod").Text <> "1")
                        
            Set nodes = Nothing
         End If
                     
         Set XmlDoc = Nothing
         
         
         EPSONCheckPeriodoInattivita = gEPSONCheckInattivita
         
         If Not gEPSONCheckInattivita Then
            MsgBox "Periodo di inattivit troppo lungo." & vbNewLine & _
                   "E' necessario eseguire una 'Chiusura Fiscale'", msg_Critical, "Stato Stampante"
         End If
      End If
            
End Function

