Attribute VB_Name = "ModuloPRIMO_TOOLS"
Option Explicit

Public gStopGetInfoInternet As Boolean


Public Sub EseguiPrimoTools()
   Dim vInEsecuzione As Boolean

   On Error GoTo GestErr
   
   vInEsecuzione = VerificaEsecuzioneEXE(App.path & "\Utility\PrimoTools\PrimoTools.exe")

   'Qui Imposto i Valori nella Tabella COM_UNICA
   Call SetParCOM_UNICA   'Rilettuta dati di connessione

   If vInEsecuzione = False Then
      ' Specificando 1 come secondo argomento l'applicazione
      ' viene avviata normalmente e riceve lo stato attivo.
      Dim RetVal
      RetVal = ShellExecute(0&, "Open", App.path & "\Utility\PrimoTools\PrimoTools.exe", 0&, App.path & "\Utility\PrimoTools\", SW_SHOWNORMAL)
   End If

GestErr:
   If err.Number = 53 Then
      MsgBox "Impossibile trovare il file per eseguire PrimoTools." & vbNewLine & _
             "Contattare l'assistenza per la soluzione del problema.", vbCritical
   ElseIf err.Number <> 0 Then
      MsgBox err.Number & " - " & err.Description, msg_Critical
   End If
   On Error GoTo 0
End Sub

Public Sub EseguiGetWEB()
'gWebSincAbilitato = ChkSincroWEB.Value
'gWebSincAutomatico = IIf(OptWebAuto(1).Value, 1, 0) '1=Automatico; 0=Manuale
   Dim vInEsecuzione As Boolean
   'Dim vParameter As String
   
   On Error GoTo GestErr
   
   'Controllo che ci sia abilitato nel ParGen la sincronizzazione col WEB
   If (gWebSincAbilitato = 0) Then Exit Sub
      
   vInEsecuzione = VerificaEsecuzioneEXE(App.path & "\Utility\GetWeb\PRIMOGetWeb.exe")
   
   If Not vInEsecuzione Then
      'vParameter = Replace(IniPath, "\ParGen.cnf", "")
   
      Dim RetVal
      RetVal = ShellExecute(0&, "Open", App.path & "\Utility\GetWeb\PRIMOGetWeb.exe", 0&, App.path & "\Utility\GetWeb\", SW_SHOWNORMAL)
            
      Call MsgProcedureInLogFile(" # # # # # # # # # # # #          A.V.V.I.O           # # # # # # # # # # # # ", "GETWEB")
   End If

GestErr:
   Dim vErr As String
   If err.Number = 53 Then
      vErr = "Impossibile trovare il file per eseguire GetWEB"
      MsgBox vErr & vbNewLine & _
             "Contattare l'assistenza per la soluzione del problema.", vbCritical
      Call MsgProcedureInLogFile(vErr, "GETWEB", True)
   ElseIf err.Number <> 0 Then
      vErr = err.Number & " - " & err.Description
      MsgBox vErr, msg_Critical
      Call MsgProcedureInLogFile(vErr, "GETWEB", True)
   End If
   On Error GoTo 0
End Sub

Public Sub ChiudiGetWEB()
   If VerificaEsecuzioneEXE(App.path & "\Utility\GetWeb\PRIMOGetWeb.exe") Then
       Call WriteINI("AZIONE", "CLOSE", "T", App.path & "\Utility\GetWeb\ParSync.cnf")
       Call MsgProcedureInLogFile(" # # # # # # # # # #   C.O.M.A.N.D.A.T.A   C.H.I.U.S.U.R.A    # # # # # # # # ", "GETWEB")
   End If
End Sub

Public Sub EseguiSmsTools()
   Dim vInEsecuzione As Boolean
   Dim vParameter As String
   'If gModDeskRem Then Exit Sub
   'If Not (ReadINI("TOOLS", "ABILITA", IniPath) = "1") Then Exit Sub
   
   On Error GoTo GestErr
   
   'Controllo che ci sia abilitato l'invio degli SMS e che il testo del "SMS-Promemoria" sia impostato nei dati azienda altrimetni  inutile aprirlo
   If (gSmsAbilitati = 0) Or (Len(gSmsTxtPromem) = 0) Then Exit Sub
   
   
   vInEsecuzione = VerificaEsecuzioneEXE(App.path & "\Utility\SmsTools\SmsTools.exe")
   
   If Not vInEsecuzione Then
      vParameter = Replace(IniPath, "\ParGen.cnf", "")
   
      Dim RetVal
      RetVal = ShellExecute(0&, "Open", App.path & "\Utility\SmsTools\SmsTools.exe", vParameter, App.path & "\Utility\SmsTools\", SW_SHOWNORMAL)
   End If

GestErr:
   If err.Number = 53 Then
      MsgBox "Impossibile trovare il file per eseguire SmsTools." & vbNewLine & _
             "Contattare l'assistenza per la soluzione del problema.", vbCritical
   ElseIf err.Number <> 0 Then
      MsgBox err.Number & " - " & err.Description, msg_Critical
   End If
   On Error GoTo 0
End Sub

Public Sub ChiudiSmsTools()
'   If gModDeskRem = False Then

      If VerificaEsecuzioneEXE(App.path & "\Utility\SmsTools\SmsTools.exe") Then
          Call WriteINI("AZIONE", "CLOSE", "T", App.path & "\Utility\SmsTools\ParSmsTools.CNF")
      End If

'   Else
   
'      ''in modalit DESKTOP REMOTO NE COMANDO LA SOSPENSIONE PER 3 Minuti e MAI la chiusura
'      'Call WriteINI("AZIONE", "PAUSE", "T", App.path & "\Utility\SmsTools\ParSmsTools.CNF")

'   End If
End Sub

Public Sub ChiudiPrimoCalendarSync()
   
   If gModDeskRem = False Then
      
      If VerificaEsecuzioneEXE(App.path & "\Utility\PrimoCalendarSync\PrimoCalendarSync.exe") Then
          Call WriteINI("AZIONE", "CLOSE", "T", App.path & "\Utility\PrimoCalendarSync\ParSyncro.cnf")
      End If

   Else
   

   End If

End Sub


Public Sub EseguiPrimoBackup()
   On Error GoTo GestErr
   
   'Se mi trovo in connessione ACCESS controllo che ci sia il Path del .mdb impostato
      If gTipoDB = 0 Then
         'Se non  stato impostato il PATH del DB nel ParGen allora non eseguo PrimoBackup
         If Len(ReadINI("CONN_SQL", "PATH_DB", IniPath)) = 0 Then Exit Sub
      End If


   'Controllo se nel ParGen ho impostato il valore che disabilita PrimoBackup
      If ReadINI("PRIMOBCKP", "DISABLE", IniPath) = "T" Then Exit Sub
   
   
   
   If VerificaEsistenzaFile(App.path & "\Utility\PrimoBackup\PrimoBackup.exe") = True Then
   
      'Verifico che non sia gi in esecuzione
      If VerificaEsecuzioneEXE(App.path & "\Utility\PrimoBackup\PrimoBackup.exe") = False Then
         Dim RetVal
         RetVal = ShellExecute(0&, "Open", App.path & "\Utility\PrimoBackup\PrimoBackup.exe", 0&, App.path & "\Utility\PrimoBackup\", 2) ' SW_SHOWMINIMIZED = 2 'SW_SHOWNORMAL)
      End If
      
   Else
      MsgBox "ATTENZIONE!" & vbNewLine & _
             "Impossibile trovare PrimoBackup.exe" & vbNewLine & vbNewLine & _
             "Contattare l'assistenza per la soluzione del problema.", vbCritical
   End If

GestErr:
   If err.Number <> 0 Then
      MsgBox err.Number & " - " & err.Description & vbNewLine & vbNewLine & _
             "Contattare l'assistenza per la soluzione del problema." & vbNewLine & _
             "(Esecuzione PrimoBackup)", vbCritical
   End If
   On Error GoTo 0
End Sub

Public Sub EseguiMailSender()
   Dim vInEsecuzione As Boolean

   On Error GoTo GestErr
   
   vInEsecuzione = VerificaEsecuzioneEXE(App.path & "\Utility\MailSender\MailSender.exe")

   'Qui Imposto i Valori nella Tabella COM_UNICA
   Call SetParCOM_UNICA   'Rilettuta dati di connessione

   If vInEsecuzione = False Then
      ' Specificando 1 come secondo argomento l'applicazione
      ' viene avviata normalmente e riceve lo stato attivo.
      Dim RetVal
      RetVal = ShellExecute(0&, "Open", App.path & "\Utility\MailSender\MailSender.exe", 0&, App.path & "\Utility\MailSender\", SW_SHOWNORMAL)
   End If


GestErr:
   If err.Number = 53 Then
      MsgBox "Impossibile trovare il file per eseguire MailSender." & vbNewLine & _
             "Contattare l'assistenza per la soluzione del problema.", vbCritical
   ElseIf err.Number <> 0 Then
      MsgBox err.Number & " - " & err.Description
   End If
   On Error GoTo 0
End Sub

Public Sub EseguiPrimoGetAPP()
   On Error GoTo GestErr
   
   'Solo per connessione di tipo ACCESS
      'Se non  stato impostato il PATH del DB nel ParGen allora non eseguo PrimoGetAPP
      If gTipoDB = 0 Then If Len(ReadINI("CONN_SQL", "PATH_DB", IniPath)) = 0 Then Exit Sub
   
   
   If VerificaEsistenzaFile(App.path & "\Utility\GetAPP\PrimoGetAPP.exe") = True Then
   
      'Verifico che non sia gi in esecuzione
      If VerificaEsecuzioneEXE(App.path & "\Utility\GetAPP\PrimoGetAPP.exe") = False Then
         Dim RetVal
         RetVal = ShellExecute(0&, "Open", App.path & "\Utility\GetAPP\PrimoGetAPP.exe", 0&, App.path & "\Utility\GetAPP\", SW_SHOWNORMAL)
      Else
         'se  gi in esecuzione imposto solamente il Parametro nel file di configurazione _
          per dire a PrimoGetAPP di aggiornare le tabelle del DB
          Call WriteINI("AZIONE", "RELOAD_TAB", "T", App.path & "\Utility\GetAPP\ParGetApp.CNF")
      End If
      
   Else
      MsgBox "ATTENZIONE!" & vbNewLine & _
             "Impossibile trovare PrimoGetAPP.exe" & vbNewLine & vbNewLine & _
             "Contattare l'assistenza per la soluzione del problema.", vbCritical
   End If

GestErr:
   If err.Number <> 0 Then
      MsgBox err.Number & " - " & err.Description & vbNewLine & vbNewLine & _
             "Contattare l'assistenza per la soluzione del problema." & vbNewLine & _
             "(Esecuzione PrimoGetAPP)", vbCritical
   End If
   On Error GoTo 0
End Sub


Public Sub ForzaRiletturaParametriGetAPP()
   'Verifico se  in Esecuzione
   If VerificaEsecuzioneEXE(App.path & "\Utility\GetAPP\PrimoGetAPP.exe") Then
      'se  in esecuzione imposto il Parametro nel file di configurazione _
       per dire a PrimoGetAPP di aggiornare le tabelle del DB
       Call WriteINI("AZIONE", "RELOAD_TAB", "T", App.path & "\Utility\GetAPP\ParGetApp.CNF")
   End If
End Sub


Public Sub EseguiPrimoCalendarSync()
   On Error GoTo GestErr
   
   'Solo per connessione di tipo ACCESS
      'Se non  stato impostato il PATH del DB nel ParGen allora non eseguo PrimoCalendarSync
      If gTipoDB = 0 Then If Len(ReadINI("CONN_SQL", "PATH_DB", IniPath)) = 0 Then Exit Sub
   
   
   If VerificaEsistenzaFile(App.path & "\Utility\PrimoCalendarSync\PrimoCalendarSync.exe") = True Then
   
      'Verifico che non sia gi in esecuzione
      If VerificaEsecuzioneEXE(App.path & "\Utility\PrimoCalendarSync\PrimoCalendarSync.exe") = False Then
         Dim RetVal
         RetVal = ShellExecute(0&, "Open", App.path & "\Utility\PrimoCalendarSync\PrimoCalendarSync.exe", 0&, App.path & "\Utility\PrimoCalendarSync\", SW_SHOWNORMAL)
      'Else
      '   'se  gi in esecuzione imposto solamente il Parametro nel file di configurazione _
      '    per dire a PrimoGetAPP di aggiornare le tabelle del DB
      '    Call WriteINI("AZIONE", "RELOAD_TAB", "T", App.path & "\Utility\GetAPP\ParGetApp.CNF")
      End If
      
   Else
      MsgBox "ATTENZIONE!" & vbNewLine & _
             "Impossibile trovare PrimoCalendarSync.exe" & vbNewLine & vbNewLine & _
             "Contattare l'assistenza per la soluzione del problema.", vbCritical
   End If

GestErr:
   If err.Number <> 0 Then
      MsgBox err.Number & " - " & err.Description & vbNewLine & vbNewLine & _
             "Contattare l'assistenza per la soluzione del problema." & vbNewLine & _
             "(Esecuzione PrimoGetAPP)", vbCritical
   End If
   On Error GoTo 0
End Sub


Public Sub SetParCOM_UNICA(Optional pChiudi As Byte, Optional pShowDati As Byte)
   'pShowDati = 0 -> PrimoTools  in esecuzione e resta iconizzato nella Tray Area _
                1 -> PrimoTools  in esecuzione si apre e mostra i dati relativi agli SMS _
                2 -> PrimoTools  in esecuzione si apre e mostra i dati relativi alle Email
   Dim RS As ADODB.Recordset
   Dim strRicerca As String
   Dim strSQL As String
   Dim StrCampi As String
   Dim StrValori As String
   Dim vRefPar As Byte
   
   If (pChiudi = 1) Or (pShowDati = 1) Then
      vRefPar = 0
   Else
      vRefPar = 1
   End If
   
   strRicerca = "SELECT * FROM [COM_UNICA]"
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneGenerale, adOpenStatic
   If Not RS.EOF Then
      'AGGIORNO
      StrCampi = "CUCODAZI = '" & VerificaApici(Azienda) & "'"
      StrCampi = StrCampi & ", CUCODUTE = " & pub_CodUtente & ""
      StrCampi = StrCampi & ", CUREFPAR = " & vRefPar & ""
      If vRefPar = 1 Then 'Se chiedo il refresh dei parametri azzero il CUINTERN che poi user come parametro per capire quando  terminato l'aggiornamento
         StrCampi = StrCampi & ", CUINTERN = 255" 'cos sono sempre sicuro che abbia realmente letto il credito (anche se 0)
         StrCampi = StrCampi & ", CUCREDIT = -1" 'cos sono sempre sicuro che abbia realmente letto il credito (anche se 0)
      End If
      StrCampi = StrCampi & ", CUTABINI = " & pShowDati & ""
      StrCampi = StrCampi & ", CU_CLOSE = " & pChiudi & ""
      strSQL = "UPDATE [COM_UNICA] SET " & StrCampi & ""
   Else
      'CREO
      StrCampi = "CUCODAZI"
      StrValori = "'" & VerificaApici(Azienda) & "'"
      StrCampi = StrCampi & ", CUCODUTE"
      StrValori = StrValori & "," & pub_CodUtente & ""
      StrCampi = StrCampi & ", CUREFPAR"
      StrValori = StrValori & ",1"
      StrCampi = StrCampi & ", CUINTERN"
      StrValori = StrValori & ",255" 'cos sono sempre sicuro che abbia realmente letto il credito (anche se 0)
      StrCampi = StrCampi & ", CUCREDIT"
      StrValori = StrValori & ",-1" 'cos sono sempre sicuro che abbia realmente letto il credito (anche se 0)
      StrCampi = StrCampi & ", CUTABINI"
      StrValori = StrValori & "," & pShowDati & ""
      StrCampi = StrCampi & ", CU_CLOSE"
      StrValori = StrValori & ",0"
      strSQL = "INSERT INTO [COM_UNICA] (" & StrCampi & ") VALUES ( " & StrValori & " )"
   End If
   RS.Close
   Set RS = Nothing

   EseguiSQLMDB (strSQL)

End Sub

Public Sub GetParCOM_UNICA(prConn As Integer, prCredSMS As Long)
   'Qui prendo i valori di Connessione ad Internet e di Credito SMS
   
   Dim RS As ADODB.Recordset
   Dim strRicerca As String
   
   strRicerca = "SELECT * FROM [COM_UNICA]"
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneGenerale, adOpenStatic
   If Not RS.EOF Then
      prConn = NonNullo(RS!CUINTERN, True)
      prCredSMS = NonNullo(RS!CUCREDIT, True)
   End If
   RS.Close
   Set RS = Nothing
End Sub

Public Function VerEsecPrimoTools() As Boolean 'Optional pChisura As Boolean) As Boolean
   'Controllo il valore del campo CUESECUZ oppure del campo CUABILIT se pChisura = True
   
   VerEsecPrimoTools = VerificaBOOLEANA("SELECT * FROM [COM_UNICA] WHERE CUESECUZ = 1")
   
End Function

Public Sub InviaDeleteSMS(pCodCli As String, pDataOra As String)
'   Dim StrCampi As String
'   Dim StrValori As String
'   Dim strStringa As String
'   Dim vData As String
'   Dim vOra As Integer
'
'
'
'   'CONTROLLO SOLO CHE CI SIA IL CLIENTE ... ALTRI CONTROLLI SONO INUTILI SEMPLICEMENTE PERCH SE NON C'ERANO LE CONDIZIONE X
'   'INVIARE UN SMS SULL'ATTIVITA LE SEGUENTI 'VerificaBOOLEANA' NON TROVERANNO NULLA
'   If Len(Trim(pCodCli)) = 0 Then Exit Sub
'
'
'
'   vData = Format(pDataOra, "dd/mm/yyyy")
'   vOra = Format(pDataOra, "hhnn")
'
'
'   'Solo se l'Attivit  a partire da 'OGGI'
'   If CDate(vData) >= Date Then
'
'      'Controllo se ci sono INVII gi comandati ma non ancora processati ed in questo caso li ANNULLO
'         If VerificaBOOLEANA("SELECT * FROM [" & Azienda & "SMS_PROMEM] " & _
'                             " WHERE (SPCODCLI = '" & VerificaApici(pCodCli) & "') " & _
'                             "   AND (SPDATATT = " & DataOraSQL(vData) & ") " & _
'                             "   AND (SP_STATO = 11) " & _
'                             " ") = True Then
'
'            EseguiSQLMDB ("UPDATE [" & Azienda & "SMS_PROMEM] SET SP_STATO = 3, SPMESSAG = 'Annullamento pre-invio' " & _
'                             " WHERE (SPCODCLI = '" & VerificaApici(pCodCli) & "') " & _
'                             "   AND (SPDATATT = " & DataOraSQL(vData) & ") " & _
'                             "   AND (SP_STATO = 11) " & _
'                             " ")
'                                       '"   AND (SPAZIONE = 0) " &
'         Else
'
'            'Se ci sono INVII eseguiti allora procedo col caricamento della cancellazione
'               If VerificaBOOLEANA("SELECT * FROM [" & Azienda & "SMS_PROMEM] " & _
'                                   " WHERE (SPCODCLI = '" & VerificaApici(pCodCli) & "') " & _
'                                   "   AND (SPDATATT = " & DataOraSQL(vData) & ") " & _
'                                   "   AND (SP_STATO = 1) " & _
'                                   " ") = True Then
'
'                  EseguiSQLMDB ("UPDATE [" & Azienda & "SMS_PROMEM] SET SP_STATO = 22, SPDATDEL = " & DataOraSQL(Format(Date, "dd/mm/yyyy")) & ", SPORADEL = " & CInt(Format(Now, "hhnn")) & " " & _
'                                   " WHERE (SPCODCLI = '" & VerificaApici(pCodCli) & "') " & _
'                                   "   AND (SPDATATT = " & DataOraSQL(vData) & ") " & _
'                                   "   AND (SP_STATO = 1) AND (SP_ERROR = 0)  " & _
'                                   " ")
'
'               End If
'
'         End If
'
'   End If
End Sub


Public Function GetSmsInfo() As Long
   'CONTROLLO la valorizzazione dei campi CUINTERN e CUCREDIT della tabella COM_UNICA
   Dim vProcedi As Boolean
   Dim vTempoMax As Date
   Dim vNumTentativo As Byte
   Dim vAzzeraTentativi As Boolean
   
   On Error GoTo GestErr
   
   vNumTentativo = 0
   
   Call ImpostaStatusPanePrgBar(True, 2, 0, "Info Sms...")
   
   BLOCCA_CHIUSURA = True
      
   vProcedi = True
   vAzzeraTentativi = False
   
RipetiVerifica:
   vNumTentativo = vNumTentativo + 1
   
'QUI PrimoTools  UN ESECUZIONE
   If VerificaEsecuzioneEXE(App.path & "\Utility\PrimoTools\PrimoTools.exe") = True Then
      
      'Debug.Print "Tentativo: " & vNumTentativo
      
      'Imposto il tempo massimo di attesa
      If vNumTentativo = 1 Then
         vTempoMax = DateAdd("s", 1, Time)
      Else
         vTempoMax = DateAdd("s", 1, vTempoMax)
      End If
   
      'Do Until VerificaEsistenzaFile(ApriFile) = True
      Do Until Time > vTempoMax
         DoEvents
      Loop
      
   Else
      
      vProcedi = False
      'Azzero i Pane della Connessione e degli Sms
      Call ImpostaConnIntStatusBar(0, "Connessione Internet = PrimoTools non  in esecuzione")
      Call ImpostaDispSmsStatusBar(0)
   
   End If
   

'QUI VERIFICO SE DEVO CONTROLLARE -----------------------
   If vProcedi = False Then GoTo GestErr
   
   'controllo che non si stia chiudendo il programma ed in questo caso ESCO
   If pub_ERROR_ESC = True Then Exit Function
   
   
   'Qui leggo i valori di Connessione e di Credito SMS dalla tabella COM_UNICA
   Dim vrConn As Integer
   Dim vrCredSMS As Long
   
   Call GetParCOM_UNICA(vrConn, vrCredSMS)
   
   
   If (vrConn = 1) And (vrCredSMS > -1) Then 'CONNESSIONE E LETTURA CREDITO OK
            
      'Nel caso il credito sia 0 allora riprovo finch posso a verificare se per caso il valore cambia perch _
       a volte capita che PrimoTools passi il valore di connessione e azzeri il credito per poi riaggiornare il credito
      If (vNumTentativo < 16) And (vrCredSMS = 0) Then 'Avendo abbassato il tempo vTempoMax del Do Until ho aumentato fino a 15 tentativi (in pratica 15 secondi)
         If vAzzeraTentativi = False Then
            vAzzeraTentativi = True
            vNumTentativo = 1 'per sucurezza riporto indietro il valore in modo da avere pi tempo
         End If
         GoTo RipetiVerifica
      End If
      
      Call ImpostaConnIntStatusBar(1, "Connessione Internet = OK")
      
      GetSmsInfo = vrCredSMS
         
      'Qui aggiorno il colore del pallino ed il Valore della disponibilit degli SMS
      Call ImpostaDispSmsStatusBar(vrCredSMS)
      
      'Debug.Print "Connessione:" & vrConn & " - Credito:" & vrCredSMS
      
   Else  'ERRORE DI CONNESSIONE
      
      'If (vrConn = 0) Then  'COntrollo se l'errore non dipenda dalla mancanza di CONNESSIONE
      
      If (vNumTentativo < 16) And (vrConn = 255) Then 'Avendo abbassato il tempo vTempoMax del Do Until ho aumentato fino a 15 tentativi (in pratica 15 secondi)
         GoTo RipetiVerifica
         'Debug.Print "Ripeti"
      Else
         'Azzero i Pane della Connessione e degli Sms
         Call ImpostaConnIntStatusBar(0, "Connessione Internet = ERRORE DI CONNESSIONE")
         Call ImpostaDispSmsStatusBar(0)
      End If
      
   End If

GestErr:

   If err.Number <> 0 Then
      MsgBox err.Number & " - " & err.Description, vbCritical
   End If
   On Error GoTo 0
   
   Call ImpostaStatusPanePrgBar(False)
   
   BLOCCA_CHIUSURA = False
     
End Function

Public Sub WaitTermineEsecuzionePT() 'Attendo che PrimoTools finisca di lavorare (CUESECUZ = 0)
   'ATTENDO CHE IL CAMPO CUABILIT DELLA TABELLA COM_UNICA SIA 0
   Dim vProcedi As Boolean
   Dim vTempoMax As Date
   Dim vNumTentativo As Byte
   
   On Error GoTo GestErr
   
   vNumTentativo = 0
   
   Call ImpostaStatusPanePrgBar(True, 2, 0, "Verifica invio Sms...")
   
   BLOCCA_CHIUSURA = True
      
   vProcedi = True
   
RipetiVerifica:
   vNumTentativo = vNumTentativo + 1
'QUI PrimoTools  UN ESECUZIONE
   'If VerificaEsecuzioneEXE(App.path & "\Utility\PrimoTools\PrimoTools.exe") = True Then
   
   If VerEsecPrimoTools = True Then
      'Imposto il tempo massimo di attesa
      If vNumTentativo = 1 Then
         vTempoMax = DateAdd("s", 1, Time)
      Else
         vTempoMax = DateAdd("s", 1, vTempoMax)
      End If
   
      'Do Until VerificaEsistenzaFile(ApriFile) = True
      Do Until Time > vTempoMax
      
         DoEvents
         
      Loop
      
   Else
      
      vProcedi = False
'      'Azzero i Pane della Connessione e degli Sms
'      Call ImpostaConnIntStatusBar(0, "Connessione Internet = PrimoTools non  in esecuzione")
'      Call ImpostaDispSmsStatusBar(0)
   
   End If
   

'QUI VERIFICO SE DEVO CONTROLLARE -----------------------
   If vProcedi = False Then
      GoTo GestErr
   End If
   
               
   If vNumTentativo < 11 Then 'Avendo abbassato il tempo vTempoMax del Do Until ho aumentato fino a 10 tentativi (in pratica 15 secondi)
      GoTo RipetiVerifica
   Else
   
      If MsgBox("ATTENZIONE!" & vbNewLine & _
                "PrimoTools sta processando l'invio di SMS o EMAIL e pertanto" & vbNewLine & _
                "si consiglia di NON forzare la chiusura del programma." & vbNewLine & vbNewLine & _
                "Attendere la conclusione del processo di Invio?", vbYesNo + vbQuestion) = vbYes Then
         vNumTentativo = 0
         GoTo RipetiVerifica
      End If
   End If
   

GestErr:
   If err.Number <> 0 Then
      MsgBox err.Number & " - " & err.Description, vbCritical
   End If
   On Error GoTo 0
   
   Call ImpostaStatusPanePrgBar(False)
   
   BLOCCA_CHIUSURA = False
     
End Sub


Public Sub WaitChiusuraPT(Optional pPerSmsTools As Boolean, Optional pGetWEB As Boolean)   'Attendo chiusura PrimoTools/SmsTools
   'Attendo che i file non siano pi in esecuzione
   Dim vProcedi As Boolean
   Dim vTempoMax As Date
   Dim vNumTentativo As Integer
   Dim vPathFile As String
   Dim vFileName As String
   Dim vTentativiTot As Integer
   
   On Error GoTo GestErr
   
   If pGetWEB Then
      vFileName = "SincroWEB"
      vPathFile = App.path & "\Utility\GetWeb\PRIMOGetWeb.exe"
      vTentativiTot = 31
   Else
      If pPerSmsTools Then
         vFileName = "SmsTools"
         vPathFile = App.path & "\Utility\SmsTools\SmsTools.exe"
         vTentativiTot = 31
      Else
         vFileName = "PrimoTools"
         vPathFile = App.path & "\Utility\PrimoTools\PrimoTools.exe"
         vTentativiTot = 11
      End If
   End If
      
   vNumTentativo = 0
   
   Call ImpostaStatusPanePrgBar(True, 2, 0, "Chiusura " & vFileName & "...") 'IIf(pPerSmsTools, "SmsTools", "PrimoTools"))
   
   vProcedi = True
   
RipetiVerifica:
   vNumTentativo = vNumTentativo + 1
'QUI PrimoTools  UN ESECUZIONE
   If VerificaEsecuzioneEXE(vPathFile) Then
   
      'Imposto il tempo massimo di attesa
      If vNumTentativo = 1 Then
         vTempoMax = DateAdd("s", 1, Time)
      Else
         vTempoMax = DateAdd("s", 1, vTempoMax)
      End If
   
      'Do Until VerificaEsistenzaFile(ApriFile) = True
      Do Until Time > vTempoMax
         DoEvents
      Loop
      
   Else
      
      vProcedi = False
   
   End If
   

'QUI VERIFICO SE DEVO CONTROLLARE -----------------------
   If vProcedi = False Then GoTo GestErr
   
               
   If vNumTentativo < vTentativiTot Then  'Avendo abbassato il tempo vTempoMax del Do Until ho aumentato fino a 10 tentativi (in pratica 15 secondi)
      GoTo RipetiVerifica
   Else
   
      If MsgBox("ATTENZIONE!" & vbNewLine & _
                vFileName & "  ancora in Esecuzione" & vbNewLine & _
                "e forzando la chiusura potrebbero esserci problemi." & vbNewLine & vbNewLine & _
                "Attendere la chiusura di " & vFileName & "?", vbYesNo + vbQuestion) = vbYes Then
         vNumTentativo = 0
         GoTo RipetiVerifica
      End If
   End If


GestErr:
   If err.Number <> 0 Then
      MsgBox err.Number & " - " & err.Description, vbCritical
   End If
   On Error GoTo 0
   Call ImpostaStatusPanePrgBar(False)
   
End Sub

Public Function InviaSMS(pNumCel As String, pDatInv As String, pTestoSms As String, pPrefInt As String, pTipoSms As String, _
                         Optional pSerialAtt As Long, Optional pOraAtt As String, _
                         Optional pTipCon As String, Optional pCodCon As String, Optional pDesCon As String, _
                         Optional pCodCampagna As String) As String
   'Questa funzione serve per inviare gli SMS sia immediati che posticipati. _
      pNumCel   =  il numero di cellulare singolo o multiplo a cui inviare l'SMS _
      pDatInv   =  la data di invio posticipata (SOLO per SMS posticipati) _
      pOraAtt   =  l'ora di invio che serve solo per gli SMS inviati dalle Attivit (SMS promemoria) _
      pTestoSms =  il testo dell'SMS (max 160 caratteri) _
      pPrefInt  =  il Prefisso Internazionale salvato nei Dati Azienda _
      pTipoSms (OLD -> ) =  il tipo di invio dell'SMS: I=immediato; C=compleanno (posticipato); P= promemoria (posticipato) _
      pTipoSms  =  il tipo di invio dell'SMS: C=compleanno; M= marketing _
      [pInvioMultiplo] = Se True indica un invio Multiplo ed in questo caso ci sono delle differenza nel codice che segue _
      [pSerialAtt] =  il codice ID (Seriale Unico) dell'Attivit _
      [pOraAtt] =  l'ora dell'Attivit _
      [pTipCon] =  il tipo del conto che dovrebbe essere sempre C=clienti ma non si sa mai in futuro potrebbe servire. Pertanto l'ho previsto _
      [pCodCon] =  il codice del Conto che dovrebbe essere sempre il Cliente

'   Dim Doc         As HTMLDocument
'   Dim StrWeb      As String

'   Dim DecripResult() As String
   Dim vIdSms As String
   Dim vNumSms As Integer
   Dim vStrResult As String
   Dim i As Integer
   
   Dim StrCampi  As String
   Dim StrValori As String
   Dim strStringa As String
'
'   Dim vSmsUser As String
'   Dim vSmsPswd As String
   'Dim vSmsMitt As String
   
   'Dim vDesCli As String
   
   Dim vOraSms As String 'per gli SMS di tipo Promemoria
   Dim vDatSms As String
   'Dim vDatDelivery As String 'Data di Invio Posticipato
   Dim vDispSms As Long
   Dim vNumCel As String
   Dim vDatInv As String
   Dim vOraInv As String
   
   Dim NomeFile As String
   
   Dim vOrderID As String
   
   Dim arrayDestinatari() As String
   Dim arrayAttach() As String
   
   'Dim vCodCampagna As String
   
   On Error GoTo GestErr
   
   gOrderIDSMS = gOrderIDSMS + 1
    
   'I TIPI di SMS sono i seguenti
      'Case "C": LblDett(index) = .Text & " = Compleanno"
      'Case "P": LblDett(index) = .Text & " = Promemoria Attivit"
      'Case "M": LblDett(index) = .Text & " = Marketing"
   
   
   'MsgBox "INVIO SMS AL NUMERO " & pNumCel
'CONTROLLO CHE PrimoTools SIA IN ESECUZIONE
   'If pTipoSms <> "P" Then 'Se sto inviando un SMS PRomemoria NON controllo l'esecuzione di PrimoTools perch potrebbe avvenire anche da una postazione client
      'If VerificaEsecuzioneEXE(App.path & "\Utility\PrimoTools\PrimoTools.exe") = False Then
      '   'SALTO TUTTO IL CODICE
      '   vStrResult = "KO|ATTENZIONE! PrimoTools non  in esecuzione." & vbNewLine & _
      '                "Operazione annullata."
      '   GoTo GestErr
      'End If
   '*** NB: questo controllo l'ho rimosso perch in installazioni di RETE si creavano delle situazioni per cui serviva _
            l'invio a prescindere dall'esecuzione di PrimoTools che norlmamente  abilitato solo su una postazione ***
   
   'QUI PRENDO LA DISPONIBILITA' DEGLI SMS
   'vDispSms = FindPane(ID_STATBAR_SMS).Value
   'If vDispSms > 0 Then
   '*** NB: questo controllo l'ho rimosso per lo stesso motivo esposto sopra! ***
   
   
      gOraUltimoInvioSMS = Format(Now, "hh:nn:ss")
   
      
      'Qui prendo la descrizione del Cliente
      'If Len(Trim(pCodCon)) > 0 Then
      '   vDesCli = Trim(DECOD_VALORE_CAMPO("CONTI", "ANTIPCON+ANCODICE", "C" & pCodCon, "ANDESCRI"))
      '   'vDesCli = vDesCli & " (" & pCodCon & ")"
      'End If
      
      'Per sicurezza qui effettuo un MID sul testo dell'SMS
      pTestoSms = Mid(pTestoSms, 1, 160)
      
      
'      If pTipoSms = "P" Then '(Promemoria Attivit)
'         'Qui prendo le ore di preavviso impostate nei Dati Azienda per quel che riguarda le Attivit
'         vOraSms = DECOD_VALORE_CAMPO("GENERALEANA_AZIENDE", "AZCODAZI", Azienda, "AZSMSOREPRE")
'         vDatSms = pDatInv & " " & pOraAtt
'         vDatSms = DateAdd("h", (CByte(vOraSms) * (-1)), vDatSms) 'sottraggo le ore di preavviso
'          vOraSms = Format(vDatSms, "hh.nn") & ".00"
'          vDatSms = Format(vDatSms, "dd/mm/yyyy")
'         'vDatDelivery = Format(vDatSms, "yyyymmdd") & Replace(Replace(vOraSms, ".", ""), ":", "")
'         'vDatDelivery = vDatSms & " " & Replace(vOraSms, ".", ":")
      
      If pTipoSms = "C" Then 'x COMPLEANNI
         'Qui verifico la DataInvio perche' in caso di compleanni l'anno deve essere corretto (chiaramente!)
         vDatSms = Format(pDatInv, "dd/mm") & "/" & Year(Date) 'Qui correggo l'anno con quello corrente
         'Inoltre qui controllo che la data corretta non sia Inferiore alla data corrente perch in questo caso significa che il compleanno cade nell'anno successivo e quindi aggiungo un anno alla data
         If CDate(vDatSms) < Date Then
            vDatSms = DateAdd("yyyy", 1, vDatSms)
         End If
         
         'Qui controllo che se non  uguale NON passo la DataDelivery perch significa che  il PRIMO INVIO in assoluto da parte di PRIMO e quindi sta inviando gli SMS di OGGI (primo invio, appunto)
         If Not CDate(vDatSms) = Date Then
            'Qui controllo se c'e' l'ora di invio (che dovrebbe arrivare dai Dati AZienda ma nel caso sia vuota passo io l'ora fissa
            If Len(Trim(pOraAtt)) > 0 Then
               vOraSms = Format(pOraAtt, "hh.mm") & ".00"
            Else
               vOraSms = "10.00.00" 'Nel caso mancasse nei Dati Azienda
            End If
            'vDatDelivery = Format(vDatSms, "yyyymmdd") & Replace(Replace(vOraSms, ".", ""), ":", "")
            'vDatDelivery = vDatSms & " " & Replace(vOraSms, ".", ":")
         End If
      
      Else 'M = Marketing (inviati direttamente dalla FormSMS)
         
         'Qui controllo che se la data di invio  uguale alla data di sistema e l'ora  vuota significa che si tratta di un invio immediato
         'If Not CDate(pDatInv) = Date And Len(Trim(pOraAtt)) = 0 Then
         If Len(Trim(pOraAtt)) = 0 Then '...in ralt basta che controllo solo l'ora! tanto gli altri controlli avvengono nella FormSMS
            vOraSms = Format(Now, "hh:nn:ss")
            vDatSms = Format(Date, "dd/mm/yyyy")
            'vDatDelivery = ""
         Else
            vDatSms = Format(pDatInv, "dd/mm/yyyy")
            vOraSms = Format(pOraAtt, "hh:mm") & ".00"
            'vDatDelivery = vDatSms & " " & Replace(vOraSms, ".", ":")
         End If
         
      End If
      
      
  '    vStrResult = ""
      
      'Qui Formatto definitivamente Data e Ora dell'Invio (se presenti)
      If Len(Trim(vDatSms)) > 0 Then
         vDatSms = Format(vDatSms, "yyyymmdd")
      End If
      If Len(Trim(vOraSms)) > 0 Then
         vOraSms = Format(vOraSms, "hhnnss")
      End If
      
      
      vOrderID = "D" & Format(Date, "yyyymmdd") & "H" & Format(Now, "hhnnss") & "P" & gOrderIDSMS
      vOrderID = UCase(vOrderID)
      
      
'''      'Se si tratta di SMS per Promemoria Attivit allora aggiorno nel record dell'Attivit l'OrderID dell'SMS
'''      If pTipoSms = "P" Then 'x Attivit (Promemoria)
'''         EseguiSQLMDB ("UPDATE [" & Azienda & "CAL_EVENTI] SET EV_IDSMS = '" & VerificaApici(vOrderID) & "' WHERE EVENTID = " & pSerialAtt & "")
'''      End If
      
      
      'Qui accodo l'SMS per l'invio
         StrCampi = "SCCODAZI"
         StrValori = "'" & VerificaApici(Azienda) & "'"
         StrCampi = StrCampi & ", SC_IDSMS"
         StrValori = StrValori & ",'" & vOrderID & "'"
         StrCampi = StrCampi & ", SCTIPSMS"
         StrValori = StrValori & ",'" & pTipoSms & "'"
         StrCampi = StrCampi & ", SCCODCLI"
         StrValori = StrValori & ",'" & VerificaApici(pCodCon) & "'"
         StrCampi = StrCampi & ", SCDESCLI"
         StrValori = StrValori & ",'" & PulisciDescrizioneCliente(VerificaApici(pDesCon)) & "'"
         StrCampi = StrCampi & ", SCNUMCEL"
         StrValori = StrValori & ",'" & VerificaApici(pNumCel) & "'"
         StrCampi = StrCampi & ", SCDATSMS"
         StrValori = StrValori & ",'" & vDatSms & "'"
         StrCampi = StrCampi & ", SCORASMS"
         StrValori = StrValori & ",'" & vOraSms & "'"
         StrCampi = StrCampi & ", SC_TESTO"
         StrValori = StrValori & ",'" & VerificaApici(pTestoSms) & "'"
         If Len(Trim(pCodCampagna)) > 0 Then
            StrCampi = StrCampi & ", SCIDINVIO" 'Id della (eventuale) campagna
            StrValori = StrValori & ",'" & VerificaApici(pCodCampagna) & "'"
         End If

         strStringa = "INSERT INTO [SMS_CODA] (" & StrCampi & ") VALUES ( " & StrValori & " )"
         EseguiSQLMDB (strStringa)
      
      vStrResult = "OK|"
      
   'End If


GestErr:
   If err.Number <> 0 Then
      'MsgBox err.Number & " - " & err.Description
      vStrResult = "KO|" & err.Number & " - " & err.Description
   End If
   On Error GoTo 0
   
   InviaSMS = vStrResult
End Function

Private Function PulisciDescrizioneCliente(pDescr As String) As String
   Dim vDescr As String
   
   vDescr = pDescr
      'vDescr = Replace(vDescr, "", "a")
      'vDescr = Replace(vDescr, "", "e")
      'vDescr = Replace(vDescr, "", "e")
      'vDescr = Replace(vDescr, "", "i")
      'vDescr = Replace(vDescr, "", "o")
      'vDescr = Replace(vDescr, "", "u")
      vDescr = Replace(vDescr, "", "E")
      vDescr = Replace(vDescr, "", "")
      vDescr = Replace(vDescr, "", "")
      vDescr = Replace(vDescr, "(", "")
      vDescr = Replace(vDescr, ")", "")
      vDescr = Replace(vDescr, "//", "")
      vDescr = Replace(vDescr, "\\", "")
      vDescr = Replace(vDescr, ";", "")
      vDescr = Replace(vDescr, ",", "")
   PulisciDescrizioneCliente = vDescr

End Function


'Public Function GetPrimoEventoCliDay(pCodCli As String, pData As String) As Long
'   'Qui controllo, nel caso di cancellazione di una Attivit, se esite un'altra Attivit _
'    dello stesso Cliete e nella stessa giornata che, chiaramente, NON abbia ID_SMS popolato
'
'   Dim RS As ADODB.Recordset
'   Dim strRicerca As String
'   Dim vOraIni As String
'   Dim vOraFin As String
'   Dim vPrimaAtt As Boolean
'
'   vOraIni = "00:00:01"
'   vOraFin = "23:59:59"
'
'   GetPrimoEventoCliDay = 0
'   vPrimaAtt = False
'
''''   strRicerca = "SELECT EventID,EV_IDSMS FROM [" & Azienda & "CAL_EVENTI] " & _
''''                       "WHERE (COD_CONTO = '" & VerificaApici(pCodCli) & "') " & _
''''                       " AND  (StartDateTime >= " & DataOraSQL(pData, False, vOraIni, False) & ") " & _
''''                       " AND  (StartDateTime <= " & DataOraSQL(pData, False, vOraFin, False) & ") " & _
''''                       " AND  (EV_IDSMS <> '') AND (EV_IDSMS IS NOT NULL) " & _
''''                       "ORDER BY StartDateTime"
''''   'Qui mi accerto che non esista gi un'attivit con IDSMS > 0
''''   If VerificaBOOLEANA(strRicerca) = False Then
'
'   'Verifico se la PRIMA attivit del giorno del cliente NON ha l'IDSMS compilato ed in questo caso lo prendo
'   strRicerca = "SELECT EventID,EV_IDSMS FROM [" & Azienda & "CAL_EVENTI] " & _
'                       "WHERE (COD_CONTO = '" & VerificaApici(pCodCli) & "') " & _
'                       " AND  (StartDateTime >= " & DataOraSQL(pData, False, vOraIni, False) & ") " & _
'                       " AND  (StartDateTime <= " & DataOraSQL(pData, False, vOraFin, False) & ") " & _
'                       "ORDER BY StartDateTime, EventID"
'   Set RS = New ADODB.Recordset
'   RS.Open strRicerca, ConnessioneGenerale, adOpenStatic
'   If Not RS.EOF Then
'      If Len(Trim(RS!EV_IDSMS)) = 0 Then
'         vPrimaAtt = True
'         GetPrimoEventoCliDay = RS!EventID
'      End If
'   End If
'   RS.Close
'   Set RS = Nothing
'
'
'   'QUI IN PRATICA DEVO CICLARE SU TUTTE LE ATTIVIT DEL CLIENTE PER IL GIORNO IN QUESTIONE _
'    E VERIFICARE SE IL PRIMO APPUNTAMENTO HA L'ID_SMS COMPILATO. SE NON  COS ALLORA SIGNIFICA _
'    CHE DEVO ELIMINARE TUTTI GLI SMS POSTICIPATI INVIATI E RIMANDARLO PER L'ORARIO DEL PRIMO APPUNTAMENTO
'
'   'Se il primo apppuntamento del giorno NON ha l'IDSMS compilato allora cerco quello da cancellare (se c')
'   If vPrimaAtt = True Then
'      'Se arrivo qui significa che devo verificare se  possibile che ci siano attivit con IDSMS compilato (in teoria al massimo ce ne potrebbe essere una)
'      strRicerca = "SELECT EV_IDSMS FROM [" & Azienda & "CAL_EVENTI] " & _
'                          "WHERE (COD_CONTO = '" & VerificaApici(pCodCli) & "') " & _
'                          " AND  (StartDateTime >= " & DataOraSQL(pData, False, vOraIni, False) & ") " & _
'                          " AND  (StartDateTime <= " & DataOraSQL(pData, False, vOraFin, False) & ") " & _
'                          " AND  (EV_IDSMS <> '') AND (EV_IDSMS IS NOT NULL) " & _
'                          "ORDER BY StartDateTime"
'      Set RS = New ADODB.Recordset
'      RS.Open strRicerca, ConnessioneGenerale, adOpenStatic
'      If Not RS.EOF Then
'         Do Until RS.EOF
'            Call InviaDeleteSMS(RS!EV_IDSMS)
'            RS.MoveNext
'         Loop
'      End If
'      RS.Close
'      Set RS = Nothing
'   End If
'
'End Function

Public Function VerificaCodePT() As Boolean
   VerificaCodePT = False

   If VerificaBOOLEANA("SELECT * FROM [SMS_CODA]") = True Then
      VerificaCodePT = True
      Exit Function
   End If
   
   If VerificaBOOLEANA("SELECT * FROM [EMAIL_CODA]") = True Then
      VerificaCodePT = True
      Exit Function
   End If
   
End Function

Public Sub GestioneSmsPromemoria(pCodCliNEW As String, pDataNEW As String, _
                                 pCodCliOLD As String, pDataOLD As String)
   
'*****   SOSPESO CON IL RILASCIO DELLA RELEASE 2.0 DI SmsTools   *****
   
   
''NOTE PARAMETRI: pCodCliNEW e pDataNEW = indicano i dati del cliente e la data di invio _
'                 pCodCliOLD e pDataOLD = indicano i dati del cliente pre modifica o eliminazione dell'Attivit _
'                                         (posso essere diversi dai NEW perch posso aver cambiato sia Cliente sia Data) _
'
'   'Dim vPrefInt As String
'   Dim vNumCel As String
'   'Dim vLenAlias As Byte
'   Dim vTestoModSms As String
'   Dim vAliasCliente As String
'   Dim vDataAtt As String
'   Dim vVal As String
'   'Dim vDesCli As String
'   Dim vInvioAbilitato As String
'   Dim vTestoSmsPromem As String
'   Dim vOrePreavvisSms As Byte
'   Dim vIdEvent As Long
'   Dim vOrderID As String
'   Dim RS As ADODB.Recordset
'   Dim StrCampi As String
'   Dim StrValori As String
'   Dim StrIns As String
'
'   Dim strRicerca As String
'   Dim vForzaUscita As Boolean
'
'   Dim vDataOraSchedulazione As String
'
'   On Error GoTo GestErr
'
'
'
''PRIMO CONTROLLO SE CI SONO DIFFERENZE TRA NUOVI DATI E VECCHI DATI (SE SONO POPOLATI)
'   If (Len(Trim(pCodCliOLD)) > 0) Then
'      If (pCodCliNEW <> pCodCliOLD) Or (pDataNEW <> pDataOLD) Then
'         'COMANDO LA CANCELLAZIONE DI EVENTUALI SMS VECCHI
'         Call InviaDeleteSMS(pCodCliOLD, pDataOLD)
'
'      Else
'
'         'Se arriva qui significa che non  cambiato nulla e quindi ESCO dalla procedura
'         Exit Sub
'
'      End If
'   End If
'
'
'
''ALTRI CONTROLLI SUI DATI AZIENDA - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'   'Controllo se  abilitatio l'invio degli SMS
'      If gSmsAbilitati <> 1 Then Exit Sub
'
'   'CHE CI SIA IL TESTO DEL PROMEMORIA ALTRIMENTI ESCO
'      If Len(gSmsTxtPromem) = 0 Then Exit Sub
'
'
''''   'QUI CONTROLLO CHE DAL MOMENTO DEL SALVATAGGIO ALL'ORA DELL'APPUNTAMENTO CI SIA UN TEMPO MAGGIORE (O QUANTOMENO UGUALE) DELLE ORE DI PREAVVISO IMPOSTATE NEI DATI AZIENDA
''''      If DateDiff("h", Now, pDataNEW) < gSmsOrePreavv Then Exit Sub
'      'NB: QUESTO CONTROLLO L'HO RIMOSSO PERCHE' SE OGGI FACCIO UNA MODIFICA AD UN APPUNTAMENTO DI DOMANI AL DI SOTTO DELLE 24 ORE
'          'IL VECCHIO SMS VENIVA CANCELLATO MA IL NUOVO NON RIPARTIVA
'
'   'Qui calcolo la Data e Ora di Invio reale (schedulazione) sottraendo alla data/ora dell'Attivit le ore di Preavviso
'      If DateDiff("h", Now, pDataNEW) > gSmsOrePreavv Then 'SE C' UN TEMPO > DELLE ORE DI PREAVVISIO ALLORA LE CALCOLO
'         vDataOraSchedulazione = Format(DateAdd("h", (gSmsOrePreavv * -1), pDataNEW), "dd/mm/yyyy hh:nn:ss")
'      Else
'         'vDataOraSchedulazione = Format(DateAdd("n", 30, Now), "dd/mm/yyyy hh:nn:ss") ' lo invio tra mezz'ora
'
'         'SE IL TEMPO A DISPOSIZIONE PER L'INVIO E' MINORE DELLE ORE DI PREAVVISO ALLORA NON MANDO ALCUN SMS
'         'SARA' SmsTools.exe AD EVIDENZIARE L'IMPOSSIBILIT DI INVIO PER "TEMPO DI PREAVVISO INSUFFICIENTE"
'         Exit Sub
'      End If
''- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'
'
'
''Controllo che non si stia prendendo Oggi un appuntamento per OGGI (indipendentemente dalle ore di preavviso). _
'    (Mi sembra inutile inviare un SMS oggi per OGGI)
'      If CDate(Format(pDataNEW, "dd/mm/yyyy")) <= Date Then
'         Exit Sub
'      End If
'
'
''QUI CONTROLLO CHE CI SIA IL CLIENTE ALTRIMENTI  INUTILE FARE QUALSIASI TIPO DI CONTROLLO
'   If (Len(Trim(pCodCliNEW)) > 0) Then
'
'
'
'         'NB: QUI AVREI POTUTO FARE IL CONTROLLO SE GI PRESENTE UN SMS INVIATO E QUINDI EVITARE L'ACCODAMENTO DI UN
'             'NUOVO RECORD. PERO' QUESTO TIPO DI CONTROLLO LO DEMANDO ALL'ESEGUIBILE CHE PROCEDE DI FATTO ALL'INVIO
'             'IN MODO DA NON DARE ALTRO PESO E RALLENATAMENTO A QUESTA PROCEDURA * * * * * * * * * * * * * * * * * *
'
'
'
''CONTROLLI SUL CLIENTE "NEW" - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'      strRicerca = "SELECT * FROM [" & Azienda & "CONTI] WHERE ANCODICE = '" & VerificaApici(pCodCliNEW) & "' AND ANTIPCON = 'C'"
'      Set RS = New ADODB.Recordset
'      RS.Open strRicerca, ConnessioneGenerale, adOpenStatic
'      If Not RS.EOF Then
'
'         'Controllo se c'e' la spunta per l'invio dell'SMS per il Promemoria
'            If RS!ANSMSPRO <> "S" Then vForzaUscita = True: GoTo SaltaCliente
'
'         'Controllo la validit del Numero di cellulare
'            vNumCel = NonNullo(RS!ANNUMCEL)
'            If (IsNumeric(vNumCel) = False) Then
'               vForzaUscita = True
'               GoTo SaltaCliente
'            Else
'               vNumCel = ImpostaNumCelConPrefInternaz(vNumCel, gSmsPrefInter)
'            End If
'
'         'Prendo l'Alias
'            vAliasCliente = Trim(NonNullo(RS!ANDESCR2))
'
'      End If
'SaltaCliente:
'      RS.Close
'      Set RS = Nothing
'      If vForzaUscita = True Then Exit Sub
''- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'
'
'
'      'COMPONGO IL TESTO DELL'SMS CON LE DOVUTE SISTEMAZIONI
'         vTestoModSms = gSmsTxtPromem
'         'SOSTITUISCO LA DATA AL TESTO DEL'SMS
'            If InStr(1, UCase(gSmsTxtPromem), "#DATA#") > 0 Then 'Qui controllo se devo inserire la data
'               vTestoModSms = Replace(vTestoModSms, "#DATA#", Format(pDataNEW, "dd/mm/yy"))
'            End If
'         'SOSTITUISCO L'ORA AL TESTO DEL'SMS
'            If InStr(1, UCase(gSmsTxtPromem), "#ORA#") > 0 Then 'Qui controllo se devo inserire l'Ora
'               vTestoModSms = Replace(vTestoModSms, "#ORA#", Format(pDataNEW, "hh:nn"))
'            End If
'         'SOSTITUISCO L'ALISA AL TESTO DEL'SMS
'            If InStr(1, gSmsTxtPromem, "#NOME#") > 0 Then 'Qui controllo se devo inserire il Nome (Alias del cliente)
'               vTestoModSms = Replace(vTestoModSms, "#NOME#", Mid(vAliasCliente, 1, CByte(gSmsLenAlias)))
'            End If
'
'
'      'PRENDO IL PROGRESSIVO GENERALE DELL'SMS E CREO L'ID
'         gOrderIDSMS = gOrderIDSMS + 1
'         vOrderID = "D" & Format(Date, "yyyymmdd") & "H" & Format(Now, "hhnnss") & "P" & gOrderIDSMS
'         vOrderID = UCase(vOrderID)
'
'
'      'QUI ACCODO L'SMS ALLA TABELLA SMS_PROMEM CHE POI SAR VALITATO DAL PROGRAMMA DI INVIO -----------------------------------
'         StrCampi = "SPCODCLI"
'         StrValori = "'" & VerificaApici(pCodCliNEW) & "'"
'
'         StrCampi = StrCampi & ", SPDATATT"
'         StrValori = StrValori & "," & DataOraSQL(Format(pDataNEW, "dd/mm/yyyy")) & ""
'         StrCampi = StrCampi & ", SPORAATT"
'         StrValori = StrValori & "," & Format(pDataNEW, "hhnn") & ""
'
'         StrCampi = StrCampi & ", SPDATPRO"
'         StrValori = StrValori & "," & DataOraSQL(Format(vDataOraSchedulazione, "dd/mm/yyyy")) & ""
'         StrCampi = StrCampi & ", SPORAPRO"
'         StrValori = StrValori & "," & Format(vDataOraSchedulazione, "hhnn") & ""
'
'         StrCampi = StrCampi & ", SP_IDSMS"
'         StrValori = StrValori & ",'" & vOrderID & "'"
'         StrCampi = StrCampi & ", SPNUMCEL"
'         StrValori = StrValori & ",'" & vNumCel & "'"
'         StrCampi = StrCampi & ", SPTXTSMS"
'         StrValori = StrValori & ",'" & VerificaApici(vTestoModSms) & "'"
'         StrCampi = StrCampi & ", SP_STATO"
'         StrValori = StrValori & ",11" 'INVIO DA PROCESSARE
'         'StrCampi = StrCampi & ", SPAZIONE"
'         'StrValori = StrValori & ",1" 'CANCELLAZIONE
'
'         StrCampi = StrCampi & ", SPDATINV"
'         StrValori = StrValori & "," & DataOraSQL(Format(Date, "dd/mm/yyyy")) & ""
'         StrCampi = StrCampi & ", SPORAINV"
'         StrValori = StrValori & "," & CInt(Format(Now, "hhnn")) & ""
'
'
'         StrIns = "INSERT INTO [" & Azienda & "SMS_PROMEM] (" & StrCampi & ") VALUES ( " & StrValori & " )"
'         EseguiSQLMDB (StrIns)
'      '--------------------------------------------------------------------- -----------------------------------------------------
'
'
'   End If
'
'GestErr:
'   If err.Number <> 0 Then
'      MsgBox err.Number & " - " & err.Description, msg_Critical
'   End If
'   On Error GoTo 0
End Sub


Public Sub InvSmsCompleanni(pTestoSmsComple As String, pGiorniVerifica As Byte, pUltimGiornoVer As String, pOraInvio As String)
   Dim vSmsDisp As Long
   Dim RS As ADODB.Recordset
   Dim strRicerca As String
   Dim strWhereDate As String
   Dim pDataIni As String
   Dim pDataFin As String
   Dim pValDataIni As Long
   Dim pValDataFin As Long
   Dim strUpdate As String
   Dim vPrefInt As String
   Dim vDataLavoro As String
   'Dim vNumCel() As String
   Dim vNumCel As String
   Dim vMaxSecondi As Integer
   Dim vLenAlias As String
   Dim vTestoModSms As String
   Dim vWhereSQL As String
   Dim vCorreggiDataIni As Boolean
   
   On Error GoTo GestErr

   'Qui imposto la connessione e prendo il numero degli SMS disponibili
   vSmsDisp = GetSmsInfo()

   If vSmsDisp > 0 Then

      vDataLavoro = Format(Date, "dd/mm/yyyy")

      'Prendo il prefisso internazionale
         vPrefInt = DECOD_VALORE_CAMPO("GENERALEANA_AZIENDE", "AZCODAZI", Azienda, "AZPREFISINT")

      'Qui prendo la lunghezza dedicata al campo Alias
         vLenAlias = DECOD_VALORE_CAMPO("GENERALEANA_AZIENDE", "AZCODAZI", Azienda, "AZSMSLENALIAS")
         If Len(Trim(vLenAlias)) = 0 Then vLenAlias = "0"


      'Qui imposto la Data di Inizio
         If IsDate(pUltimGiornoVer) Then
            'Qui controllo che la data INIZIO non sia inferiore a "Date + 1" (domani) altrimenti vengono processati SMS per l'anno successivo!!!
               If CDate(pUltimGiornoVer) < CDate(vDataLavoro) Then
                  vCorreggiDataIni = True
               Else
                  pDataIni = pUltimGiornoVer
               End If
            Else
               vCorreggiDataIni = True
            End If
            
      'Qui controllo che la data INIZIO non sia inferiore a "Date + 1" (domani) altrimenti vengono processati SMS per l'anno successivo!!!
         If vCorreggiDataIni Then
            'Se  la prima esecuzione controllo anche i compleanni di OGGI in modo da non saltarli
            pDataIni = CStr(CDate(vDataLavoro) - 1)
         End If


      'Qui imposto la Data di Fine
         'pDataFin = DateAdd("d", pGiorniVerifica, DataGestione)
         pDataFin = DateAdd("d", pGiorniVerifica, CDate(vDataLavoro))

      'Qui controllo che la data di fine sia maggiore della datainizio
         If CDate(pDataFin) > CDate(pDataIni) Then
         'Qui ciclo sui Clienti che hanno la spunta sul campo ANSMSCOM = "S"
            'strRicerca = "SELECT ANDESCRI,ANNUMCEL,ANDATNAS " & _
                         "FROM [" & Azienda & "CONTI] " & _
                         "WHERE (ANTIPCON = 'C') AND (ANSMSCOM = 'S') AND (ANDATNAS > " & DataOraSQL(pDataIni) & ") AND (ANDATNAS <= " & DataOraSQL(pDataFin) & ") "
            pValDataIni = (Month(pDataIni) * 100) + Day(pDataIni)
            pValDataFin = (Month(pDataFin) * 100) + Day(pDataFin)

            'Qui nel caso la data di fine cada nell'anno seguente
            If Year(pDataFin) > Year(pDataIni) Then
               strWhereDate = "( (((Month(ANDATNAS) * 100) + Day(ANDATNAS)) > " & pValDataIni & ") OR " & _
                              "  (((Month(ANDATNAS) * 100) + Day(ANDATNAS)) <= " & pValDataFin & ") ) "
            Else 'Qui invece sono per forza uguali
               strWhereDate = "(((Month(ANDATNAS) * 100) + Day(ANDATNAS)) > " & pValDataIni & ") AND " & _
                              "(((Month(ANDATNAS) * 100) + Day(ANDATNAS)) <= " & pValDataFin & ") "
            End If

      
            If gTipoDB = 1 Then 'SQL
               vWhereSQL = "  AND (ISNUMERIC(ANNUMCEL) = 1) "
            Else
               vWhereSQL = "  AND (ISNUMERIC(ANNUMCEL)) "
            End If


            strRicerca = "SELECT ANCODICE,ANDESCRI,ANDESCR2,ANNUMCEL,ANDATNAS " & _
                         "FROM [" & Azienda & "CONTI] " & _
                         "WHERE (ANTIPCON = 'C') AND (ANSMSCOM = 'S') " & vWhereSQL & " AND " & strWhereDate
            Set RS = New ADODB.Recordset
            RS.Open strRicerca, ConnessioneGenerale, adOpenStatic
            If Not RS.EOF Then
               Do Until RS.EOF
                  DoEvents
                  'If IsNumeric(RS!ANNUMCEL) = True Then
                     'MsgBox RS!ANDESCRI

                     vMaxSecondi = vMaxSecondi + 1
                     
                     vTestoModSms = pTestoSmsComple
                     'Qui controllo se devo inserire il Nome (Alias del cliente)
                     If InStr(1, pTestoSmsComple, "#NOME#") > 0 Then
                        vTestoModSms = Replace(pTestoSmsComple, "#NOME#", Mid(Trim(NonNullo(RS!ANDESCR2)), 1, CByte(vLenAlias)))
                     End If
                     
                     'Erase vNumCel
                     'ReDim vNumCel(1)
                     vNumCel = RS!ANCODICE & "|" & RS!ANDESCRI & "|" & RS!ANNUMCEL & ";"
                     
                     'QUI INVIO L'SMS -----------------------------------------------------
                        Call InviaSMS(vNumCel, RS!ANDATNAS, vTestoModSms, vPrefInt, "C", 0, pOraInvio, "C", RS!ANCODICE, RS!ANDESCRI)
                     '---------------------------------------------------------------------
                     
                  'End If

                  RS.MoveNext
               Loop
               
               'Rileggo il Credito
               Call GetSmsInfo
               '-----------------------------------------------
               
            End If
            RS.Close
            Set RS = Nothing


            'Qui aggiorno la data di "Ultimo.Giorno.Di.Verifica" nei dati azienda aggiornandola con la DataFin che  l'ultimo giorno di verifica
               strUpdate = "UPDATE ANA_AZIENDE SET AZSMSULTGIOVER = " & DataOraSQL(pDataFin) & " WHERE AZCODAZI = '" & Azienda & "'"
               EseguiSQLMDB (strUpdate)

         End If

   End If


GestErr:
   If err.Number <> 0 Then
      MsgBox err.Number & " - " & err.Description, msg_Critical
   End If
   On Error GoTo 0
End Sub

Public Function GetLenCaratteriDoppiSMS(pTesto As String) As Integer
   'queta funzione conta il numero di caratteri caratteri doppi (  ^  [  ]  {  }  ~  \) presenti nel testo
   Dim vTesto As String
   
   vTesto = pTesto
   
   vTesto = Replace(vTesto, "", "")
   vTesto = Replace(vTesto, "^", "")
   vTesto = Replace(vTesto, "[", "")
   vTesto = Replace(vTesto, "]", "")
   vTesto = Replace(vTesto, "{", "")
   vTesto = Replace(vTesto, "}", "")
   vTesto = Replace(vTesto, "~", "")
   vTesto = Replace(vTesto, "\", "")
   
   GetLenCaratteriDoppiSMS = Len(pTesto) - Len(vTesto)
End Function

Public Function ComunicaCambioStatoRichiestaAPP(pSerAPP As Long, pNewStato As String) As Boolean
   'Questa funzione serve per cambiare lo stato alla Richiesta pervenuta dall'APP. _
       pNewStato = "1"  -> la richiesta  stata confermata _
       pNewStato = "-1" -> la richiesta  stata rifiutata (annullata dal centro) _

      Dim RS As ADODB.Recordset
      Dim strRicerca As String
      'Dim Azienda As String
      
      Dim vPathWEB As String
      Dim vObjInet As Object
      Dim Testo As String
      
      
      On Error GoTo GestErr
      'Debug.Print "INIZIO RICHIESTA WEB"
      
      strRicerca = "SELECT AZINDAPP,AZCODWEB " & _
                   "  FROM [ANA_AZIENDE] " & _
                   " WHERE (AZCODAZI = '" & Azienda & "') "
      Set RS = New ADODB.Recordset
      RS.Open strRicerca, ConnessioneGenerale, adOpenStatic
      If RS.EOF = False Then
         
         'mPathWEB = "http://95.110.229.105/novisoft/getprenotazionicentro.ashx?CA=000001&SP="
         vPathWEB = Trim(RS!AZINDAPP) & "setprenotazionecentro.ashx?CA=" & Trim(RS!AZCODWEB) & _
                                        "&EI=" & Trim(CStr(pSerAPP)) & _
                                        "&SP=" & pNewStato
            
         'Set vObjInet = CreateObject("InetCtls.Inet")
         Set vObjInet = MDIForm1.Inet1
         Testo = vObjInet.OpenURL(vPathWEB)
         
         Set vObjInet = Nothing
            
            
         'Controllo l'esito su pi Valori (SE SUPERA TUTTI I SEGUENTI CONTROLLI ALLORA SIGNIFICA CHE  ANDATO A BUON FINE)
         Dim vStr As String
         vStr = "Risposta WS Errata (stringa non conforme). Verificare connessione Internet -> (Cambio Stato richiesta da APP)"
         If InStr(1, Testo, "<PRENOTAZIONE>") = 0 Then
            Call MsgInLogFile("!!! ERRORE !!! " & vStr & " -> ID: " & pSerAPP, "LogRichiesteAPP.cnf")
            MsgBox vStr, vbCritical
            Exit Function
         End If
         If InStr(1, Testo, "<EVENTID>" & Trim(CStr(pSerAPP)) & "</EVENTID>") = 0 Then
            Call MsgInLogFile("!!! ERRORE !!! " & vStr & " -> ID: " & pSerAPP, "LogRichiesteAPP.cnf")
            MsgBox vStr, vbCritical
            Exit Function
         End If
         If InStr(1, Testo, "<COD_STA>" & pNewStato & "</COD_STA>") = 0 Then
            Call MsgInLogFile("!!! ERRORE !!! " & vStr & " -> ID: " & pSerAPP, "LogRichiesteAPP.cnf")
            MsgBox vStr, vbCritical
            Exit Function
         End If
         vStr = ""
         
         
         'Se arriva qui significa che  tutto OK!
         ComunicaCambioStatoRichiestaAPP = True
                     
      End If
      RS.Close
      Set RS = Nothing
      
      'Debug.Print "FINE RICHIESTA WEB"
      
GestErr:
   If err.Number <> 0 Then
      MsgBox err.Number & " - " & err.Description & _
             "(Cambio Stato richiesta da APP)", vbCritical
   End If
   On Error GoTo 0
   
End Function


'***** 06.11.2018 CLAUDIA-WHATSAPP CONFIGURAZIONE MESSAGGIO CON ELENCO TRATTAMENTI
Public Function GestioneWAPromemoria(pCodCliNEW As String, pDataNEW As String, prNumCel As String, prTrattamenti As String) As String
   
'NOTE PARAMETRI: pCodCliNEW e pDataNEW = indicano i dati del cliente e la data di invio _

   Dim vTestoModWA As String
   Dim vAliasCliente As String
   Dim vDataAtt As String
   Dim vVal As String
   Dim vTestoWAPromem As String
   Dim RS As ADODB.Recordset
   Dim StrCampi As String
   Dim StrValori As String
   Dim StrIns As String

   Dim strRicerca As String
   Dim vForzaUscita As Boolean

   On Error GoTo GestErr


'QUI CONTROLLO CHE CI SIA IL CLIENTE ALTRIMENTI  INUTILE FARE QUALSIASI TIPO DI CONTROLLO
   If (Len(Trim(pCodCliNEW)) > 0) Then


'CONTROLLI SUL CLIENTE "NEW" - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      strRicerca = "SELECT * FROM [" & Azienda & "CONTI] WHERE ANCODICE = '" & VerificaApici(pCodCliNEW) & "' AND ANTIPCON = 'C'"
      Set RS = New ADODB.Recordset
      RS.Open strRicerca, ConnessioneGenerale, adOpenStatic
      If Not RS.EOF Then

         'Controllo la validit del Numero di cellulare
            prNumCel = NonNullo(RS!ANNUMCEL)
            If (IsNumeric(prNumCel) = False) Then
               vForzaUscita = True
               
            Else
               prNumCel = ImpostaNumCelConPrefInternaz(prNumCel, gSmsPrefInter)
               If Mid(prNumCel, 1, 1) = "+" Then
                  prNumCel = "00" & Mid(prNumCel, 2)
               End If
            End If

         'Prendo l'Alias
            vAliasCliente = Trim(NonNullo(RS!ANDESCR2))

      End If
      RS.Close
      Set RS = Nothing
      
      If vForzaUscita = True Then Exit Function
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

      'COMPONGO IL TESTO DEL MESSAGGIO WHATASPP CON LE DOVUTE SISTEMAZIONI
      vTestoModWA = gWATxt
      'SOSTITUISCO LA DATA AL TESTO DEL'SMS
      If InStr(1, UCase(gWATxt), "#DATA#") > 0 Then 'Qui controllo se devo inserire la data
         vTestoModWA = Replace(vTestoModWA, "#DATA#", Format(pDataNEW, "dd/mm/yy"))
      End If
      'SOSTITUISCO L'ORA AL TESTO DEL'SMS
      If InStr(1, UCase(gWATxt), "#ORA#") > 0 Then 'Qui controllo se devo inserire l'Ora
         vTestoModWA = Replace(vTestoModWA, "#ORA#", Format(pDataNEW, "hh:nn"))
      End If
      'SOSTITUISCO L'ALIAS AL TESTO
      If InStr(1, gWATxt, "#NOME#") > 0 Then 'Qui controllo se devo inserire il Nome (Alias del cliente)
         vTestoModWA = Replace(vTestoModWA, "#NOME#", Mid(vAliasCliente, 1, CByte(gSmsLenAlias)))
      End If

'***** 06.11.2018 CLAUDIA-WHATSAPP CONFIGURAZIONE MESSAGGIO CON ELENCO TRATTAMENTI
      'SOSTITUISCO I TRATTAMENTI AL TESTO
      If InStr(1, gWATxt, "#TRAT#") > 0 Then 'Qui controllo se devo inserire l'elenco dei Trattamenti
         'imposto il grassetto sulla stringa dei trattamenti, mettendo il carattere '*' avanti e dietro la stringa
         If Len(Trim(prTrattamenti)) > 0 Then prTrattamenti = "*" & Trim(prTrattamenti) & "*"
         vTestoModWA = Replace(vTestoModWA, "#TRAT#", prTrattamenti)
      End If
'***** 06.11.2018 CLAUDIA-WHATSAPP CONFIGURAZIONE MESSAGGIO CON ELENCO TRATTAMENTI

      GestioneWAPromemoria = vTestoModWA
      
   End If

GestErr:
   If err.Number <> 0 Then
      MsgBox err.Number & " - " & err.Description, msg_Critical
   End If
   On Error GoTo 0
End Function



'***** 16.11.2018 CLAUDIA-WHATSAPP CONFIGURAZIONE MESSAGGIO IN CHIUSURA DEI DOCUMENTI DI CASSA IN BASE AL TIPO DOCUMENTO
Public Function GestioneWADocumento(pCodCliNEW As String, pDataNEW As String, _
                                     prCodTipoDoc As String, prNumCel As String) As String
                                     

   Dim vTestoModWA As String
   Dim vAliasCliente As String
   Dim vDataAtt As String
   Dim vVal As String
   Dim vTestoWA As String
   Dim RS As ADODB.Recordset
   Dim StrCampi As String
   Dim StrValori As String
   Dim StrIns As String

   Dim strRicerca As String
   Dim vForzaUscita As Boolean

   On Error GoTo GestErr

'QUI CONTROLLO CHE CI SIA IL CLIENTE ALTRIMENTI  INUTILE FARE QUALSIASI TIPO DI CONTROLLO
   If (Len(Trim(pCodCliNEW)) > 0) Then


'RECUPERO IL TESTO DEL MSG IN BASE AL TIPO DOCUMENTO - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      strRicerca = "SELECT TDFLWATDOC, TDTXTWAT FROM [" & Azienda & "TIP_DOC] WHERE TDTIPDOC = '" & VerificaApici(prCodTipoDoc) & "' AND TDFLVEAC = 'V'"
      Set RS = New ADODB.Recordset
      RS.Open strRicerca, ConnessioneGenerale, adOpenStatic
      If Not RS.EOF Then
         'verifico che sia abilitato l'utilizzo del msg di WA sul tipo documento
         If RS!TDFLWATDOC = 0 Then
            vForzaUscita = True
         Else
            vTestoWA = NonNullo(RS!TDTXTWAT)
         End If
      End If
      RS.Close
      Set RS = Nothing
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

      If vForzaUscita = True Then Exit Function


'CONTROLLI SUL CLIENTE "NEW" - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      strRicerca = "SELECT * FROM [" & Azienda & "CONTI] WHERE ANCODICE = '" & VerificaApici(pCodCliNEW) & "' AND ANTIPCON = 'C'"
      Set RS = New ADODB.Recordset
      RS.Open strRicerca, ConnessioneGenerale, adOpenStatic
      If Not RS.EOF Then

         'Controllo la validit del Numero di cellulare
            prNumCel = NonNullo(RS!ANNUMCEL)
            If (IsNumeric(prNumCel) = False) Then
               vForzaUscita = True
               
            Else
               prNumCel = ImpostaNumCelConPrefInternaz(prNumCel, gSmsPrefInter)
               If Mid(prNumCel, 1, 1) = "+" Then
                  prNumCel = "00" & Mid(prNumCel, 2)
               End If
            End If

         'Prendo l'Alias
            vAliasCliente = Trim(NonNullo(RS!ANDESCR2))

      End If
      RS.Close
      Set RS = Nothing
      
      If vForzaUscita = True Then Exit Function
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

'COMPONGO IL TESTO DEL MESSAGGIO WHATASPP CON LE DOVUTE SISTEMAZIONI
      vTestoModWA = vTestoWA
      'SOSTITUISCO LA DATA AL TESTO DEL'SMS
      If InStr(1, UCase(vTestoWA), "#DATA#") > 0 Then 'Qui controllo se devo inserire la data
         vTestoModWA = Replace(vTestoModWA, "#DATA#", Format(pDataNEW, "dd/mm/yy"))
      End If
      'SOSTITUISCO L'ALIAS AL TESTO
      If InStr(1, vTestoWA, "#NOME#") > 0 Then 'Qui controllo se devo inserire il Nome (Alias del cliente)
         vTestoModWA = Replace(vTestoModWA, "#NOME#", Mid(vAliasCliente, 1, CByte(gSmsLenAlias)))
      End If

      GestioneWADocumento = vTestoModWA
      
   End If

GestErr:
   If err.Number <> 0 Then
      MsgBox err.Number & " - " & err.Description, msg_Critical
   End If
   On Error GoTo 0

End Function

'***** 16.11.2018 CLAUDIA-WHATSAPP CONFIGURAZIONE MESSAGGIO IN CHIUSURA DEI DOCUMENTI DI CASSA IN BASE AL TIPO DOCUMENTO

