Attribute VB_Name = "ModuloAbilitazione"
Option Explicit

Public IniPathSystem As String   'contiene il percorso completo del file .ini
                                 '(cartella di sistema + Mspers2.ini)

Public NumeroSerialeHardDiskCriptato As String  'numero seriale della macchina (gia' elaborato)
                                                'su cui si sta eseguendo il programma
Public CodiceUtente  As String     ' il numero ID che si deve
                                   'comunicare alla NOVISOFT
                                   
'Public NumeroEsecuzioni As Integer 'contiene il numero di esecuzioni disponibili
                                   'letto nella sezione "Port=" del file "Mspers2.ini"
                                   
Public CodiceAttivazione_1 As String  'contiene la prima parte del codice di attivazione
                                      'letto nella sezione "IRQ=" del file "Mspers2.ini"
Public CodiceAttivazione_2 As String  'contiene la prima parte del codice di attivazione
                                      'letto nella sezione "CIPort=" del file "Mspers2.ini"

Public ProgrammaAttivato As Boolean  'impostata a "True" se il numero delle esecuzioni =99
                                     'oppure il codice di attivazione  corretto
                                     
Public ProgrammaAppenaAttivato As Boolean  'impostata a "True" se il numero delle esecuzioni =99
                                     'oppure il codice di attivazione  corretto
                    
Public Const IniName = "Mspers2.ini"    'nome del file .ini contenuto nella
                                       'cartella di sistema su cui scrivo il
                                       'codice di abilitazione e il numero delle
                                       'esecuzioni disponibili

Public PC_NAME As String 'nome del PC che si logga al database _
                         (mi serve per controllare il numero MAX di accessi al database)

Public NOMEPROGETTO As String
Public NomeKeyReg As String

'API per sapere la cartella di sistema
Private Declare Function GetSystemDirectory Lib "kernel32" Alias _
    "GetSystemDirectoryA" (ByVal lpBuffer As String, _
    ByVal nSize As Long) As Long
    
''API per sapere il Nome del Computer
'Private Declare Function GetComputerName Lib "kernel32" Alias "GetComputerNameA" (ByVal BufferString As String, BufferSize As Long) As Long
    
'Per determinare il numero seriale dell'hard-disk
Public Type DriveInformation
    DriveName As String
    DriveLabel As String
    SerialNumber As Long ''formato numerico
    SerialCode As String ''formato xxxx-yyyy
    MaximumNameLenght As Long
    FileSystemName As String
    FileSystemFlags As Long
    Compressed As Boolean
    SupportsUnicode As Boolean
    CasePreservedNames As Boolean
    CaseSensitiveSearch As Boolean
    PersistentACLS As Boolean
    SupportsCompression As Boolean
End Type

'informazioni sull'unit di sistema
Declare Function GetVolumeInformation Lib "kernel32" Alias "GetVolumeInformationA" _
        (ByVal lpRootPathName As String, ByVal lpVolumeNameBuffer As String, _
        ByVal nVolumeNameSize As Long, lpVolumeSerialNumber As Long, _
        lpMaximumComponentLength As Long, lpFileSystemFlags As Long, _
        ByVal lpFileSystemNameBuffer As String, ByVal nFileSystemNameSize As Long) _
        As Long

Public Const FILE_VOLUME_IS_COMPRESSED = &H8000
Public Const FILE_UNICODE_ON_DISK = &H4
Public Const FILE_CASE_PRESERVED_NAMES = &H2
Public Const FILE_CASE_SENSITIVE_SEARCH = &H1
Public Const FILE_PERSISTENT_ACLS = &H8
Public Const FILE_FILE_COMPRESSION = &H10

Public Const MAX_PATH = 260
Public Const MAXDWORD = &HFFFF
Public Const FILE_ATTRIBUTE_ARCHIVE = &H20
'Un file di archivio (la maggior parte dei files).
Public Const FILE_ATTRIBUTE_DIRECTORY = &H10
'Una directory invece di un file.
Public Const FILE_ATTRIBUTE_HIDDEN = &H2
'File nascosto.
Public Const FILE_ATTRIBUTE_NORMAL = &H80
'File senza attributi.
Public Const FILE_ATTRIBUTE_READONLY = &H1
'File di sola lettura.
Public Const FILE_ATTRIBUTE_SYSTEM = &H4
'File di sistema (lo usa solo il sistema operativo)
Public Const FILE_ATTRIBUTE_TEMPORARY = &H100
Public Const FILE_ATTRIBUTE_COMPRESSED = &H800
'Un file in un drive o in una directori compressa.

Public Const INVALID_HANDLE_VALUE = -1

Declare Function FindFirstFile Lib "kernel32" Alias "FindFirstFileA" (ByVal lpFileName As String, lpFindFileData As WIN32_FIND_DATA) As Long
Declare Function FindNextFile Lib "kernel32" Alias "FindNextFileA" (ByVal hFindFile As Long, lpFindFileData As WIN32_FIND_DATA) As Long
Declare Function GetFileInformationByHandle Lib "kernel32.dll" (ByVal hfile As Long, lpFileInformation As BY_HANDLE_FILE_INFORMATION) As Long
Declare Function CreateFileNS Lib "kernel32.dll" Alias "CreateFileA" (ByVal lpFileName As String, ByVal dwDesiredAccess As Long, ByVal dwShareMode As Long, ByVal lpSecurityAttributes As Long, ByVal dwCreationDisposition As Long, ByVal dwFlagsAndAttributes As Long, ByVal hTemplateFile As Long) As Long
Declare Function FileTimeToCittaFileTime Lib "kernel32.dll" (lpFileTime As FILETIME, lpCittaFileTime As FILETIME) As Long
Declare Function FileTimeToSystemTime Lib "kernel32.dll" (lpFileTime As FILETIME, lpSystemTime As SYSTEMTIME) As Long
Declare Function FindClose Lib "kernel32" (ByVal hFindFile As Long) As Long
Declare Function GetFileAttributes Lib "kernel32" Alias "GetFileAttributesA" (ByVal lpFileName As String) As Long

Public Type FILETIME
    dwLowDateTime As Long
    dwHighDateTime As Long
End Type

Public Type SYSTEMTIME
  wYear As Integer
  wMonth As Integer
  wDayOfWeek As Integer
  wDay As Integer
  wHour As Integer
  wMinute As Integer
  wSecond As Integer
  wMilliseconds As Integer
End Type

Public Type BY_HANDLE_FILE_INFORMATION
  dwFileAttributes As Long ''
  ftCreationTime As FILETIME ''
  ftLastAccessTime As FILETIME ''
  ftLastWriteTime As FILETIME ''
  dwVolumeSerialNumber As Long  ''
  nFileSizeHigh As Long
  nFileSizeLow As Long ''
  nNumberOfLinks As Long ''
  nFileIndexHigh As Long
  nFileIndexLow As Long
End Type

Public Type WIN32_FIND_DATA
    dwFileAttributes As Long
    ftCreationTime As FILETIME
    ftLastAccessTime As FILETIME
    ftLastWriteTime As FILETIME
    nFileSizeHigh As Long
    nFileSizeLow As Long
    dwReserved0 As Long
    dwReserved1 As Long
    cFileName As String * MAX_PATH
    cAlternate As String * 14
End Type


' The path of the System directory
Function SystemDirectory() As String
    Dim Buffer As String * 512, Length As Integer
    Length = GetSystemDirectory(Buffer, Len(Buffer))
    SystemDirectory = Left$(Buffer, Length)
End Function

Public Function DriveInfo(DriveName As String) As DriveInformation
'per determinare le informazioni sull'hard-disk
Dim lpRootPathName As String
Dim lpVolumeNameBuffer As String
Dim nVolumeNameSize As Long
Dim lpVolumeSerialNumber As Long
Dim lpFileSystemNameBuffer As String
Dim nFileSystemNameSize As Long
Dim lpMaximumComponentLength As Long
Dim lpFileSystemFlags As Long

Dim LReturnCode As Long

lpRootPathName = DriveName
lpVolumeNameBuffer = Space$(256)
lpFileSystemNameBuffer = Space$(256)
lpMaximumComponentLength = 0
lpVolumeSerialNumber = 0
lpFileSystemFlags = 0
If Len(lpRootPathName) = 1 Then
    lpRootPathName = lpRootPathName & ":\"
End If
LReturnCode = GetVolumeInformation(lpRootPathName, lpVolumeNameBuffer, _
              Len(lpVolumeNameBuffer), lpVolumeSerialNumber, _
              lpMaximumComponentLength, lpFileSystemFlags, _
              lpFileSystemNameBuffer, Len(lpFileSystemNameBuffer))
If LReturnCode = 0 Then
    DriveInfo.DriveName = ""
    Exit Function
End If

With DriveInfo
    .DriveName = lpRootPathName
    .DriveLabel = lpVolumeNameBuffer
    .SerialCode = Left(Hex(lpVolumeSerialNumber), 4) & "-" & Right(Hex(lpVolumeSerialNumber), 4)
    .SerialNumber = lpVolumeSerialNumber
    .FileSystemName = lpFileSystemNameBuffer
    .MaximumNameLenght = lpMaximumComponentLength
    .FileSystemFlags = lpFileSystemFlags
    .Compressed = (lpFileSystemFlags And FILE_VOLUME_IS_COMPRESSED) = FILE_VOLUME_IS_COMPRESSED
    .SupportsCompression = (lpFileSystemFlags And FILE_FILE_COMPRESSION) = FILE_FILE_COMPRESSION
    .SupportsUnicode = (lpFileSystemFlags And FILE_UNICODE_ON_DISK) = FILE_UNICODE_ON_DISK
    .CasePreservedNames = (lpFileSystemFlags And FILE_CASE_PRESERVED_NAMES) = FILE_CASE_PRESERVED_NAMES
    .CaseSensitiveSearch = (lpFileSystemFlags And FILE_CASE_SENSITIVE_SEARCH) = FILE_CASE_SENSITIVE_SEARCH
    .PersistentACLS = (lpFileSystemFlags And FILE_PERSISTENT_ACLS) = FILE_PERSISTENT_ACLS
End With
End Function


Function FindFilesAPI(path As String, SearchStr As String, FileCount As Integer, DirCount As Integer)

'    Dim FileName As String ' Walking filename variable...
'    Dim DirName As String ' SubDirectory Name
'    Dim dirNames() As String ' Buffer for directory name entries
'    Dim nDir As Integer ' Number of directories in this path
'    Dim i As Integer ' For-loop counter...
'    Dim hSearch As Long ' Search Handle
'    Dim WFD As WIN32_FIND_DATA
'    Dim Cont As Integer
'    If Right(path, 1) <> "\" Then path = path & "\"
'    ' Search for subdirectories.
'    nDir = 0
'    ReDim dirNames(nDir)
'    Cont = True
'    hSearch = FindFirstFile(path & "*", WFD)
'    If hSearch <> INVALID_HANDLE_VALUE Then
'        Do While Cont
'         DirName = StripNulls(WFD.cFileName)
'         ' Ignore the current and encompassing directories.
'         If (DirName <> ".") And (DirName <> "..") Then
'             ' Check for directory with bitwise comparison.
'             If GetFileAttributes(path & DirName) And FILE_ATTRIBUTE_DIRECTORY Then
'                 dirNames(nDir) = DirName
'                 DirCount = DirCount + 1
'                 nDir = nDir + 1
'                 ReDim Preserve dirNames(nDir)
'             End If
'         End If
'         Cont = FindNextFile(hSearch, WFD) 'Get next subdirectory.
'        Loop
'        Cont = FindClose(hSearch)
'    End If
'    ' Walk through this directory and sum file sizes.
'    hSearch = FindFirstFile(path & SearchStr, WFD)
'    Cont = True
'    If hSearch <> INVALID_HANDLE_VALUE Then
'        While Cont
'            FileName = StripNulls(WFD.cFileName)
'            If (FileName <> ".") And (FileName <> "..") Then
'                FindFilesAPI = FindFilesAPI + (WFD.nFileSizeHigh * MAXDWORD) + WFD.nFileSizeLow
'                FileCount = FileCount + 1
''                List1.AddItem path & FileName
'            End If
'            Cont = FindNextFile(hSearch, WFD) ' Get next file
'        Wend
'        Cont = FindClose(hSearch)
'    End If
'    ' If there are sub-directories...
'    If nDir > 0 Then
'        ' Recursively walk into them...
'        For i = 0 To nDir - 1
'            FindFilesAPI = FindFilesAPI + FindFilesAPI(path & dirNames(i) & "\", SearchStr, FileCount, DirCount)
'        Next i
'    End If
End Function

Public Function CercaFile(NomeFile) As String
    Dim strParentDir As String
    Dim strSubDirs() As String
    Dim strFullPath As String
    Dim strCurFile As String
    Dim bFirstFile As Boolean
    Dim bEndOfSearch As Boolean
    Dim bIsFile As Boolean
    Dim lngSubIdx As Long
    '*********************************
    'Temp vars for demo purposes only
    '*********************************
    Dim lngFileCount As Long
    '*********************************
    
    lngSubIdx = 1
    ReDim strSubDirs(1)
    'Set the initial directory...
    strSubDirs(1) = "C:\"
    bEndOfSearch = False
    bFirstFile = True
    
    Do While Not bEndOfSearch
        strParentDir = strSubDirs(lngSubIdx)
        If bFirstFile Then
            ChDir strParentDir
            strCurFile = Dir(strParentDir, vbArchive Or _
                vbDirectory Or vbHidden Or vbNormal Or _
                vbReadOnly Or vbSystem)
            If strCurFile <> "" And strCurFile <> "." And _
                strCurFile <> ".." Then
            If GetAttr(strParentDir & strCurFile) = vbDirectory Then
                'This is a directory...
                ReDim Preserve strSubDirs(UBound(strSubDirs) + 1)
                strSubDirs(UBound(strSubDirs)) = strParentDir & _
                    strCurFile & "\"
            Else
                'This is a file...
                bIsFile = True
            End If
        End If
        bFirstFile = False
    Else
        strCurFile = Dir(, vbArchive Or vbDirectory Or _
            vbHidden Or vbNormal Or vbReadOnly Or vbSystem)
        If strCurFile <> "" And strCurFile <> "." And _
            strCurFile <> ".." Then
        If (strCurFile <> "pagefile.sys") Then
         If (strCurFile <> "?") Then
            If GetAttr(strParentDir & strCurFile) = vbDirectory Then
                'This is a directory...
                ReDim Preserve strSubDirs(UBound(strSubDirs) + 1)
                strSubDirs(UBound(strSubDirs)) = strParentDir & _
                    strCurFile & "\"
            Else
                'This is a file
                bIsFile = True
            End If
          End If
         End If
    End If
End If
If bIsFile Then
    '**************************************************
    'This is where you put the code to handle a file...
    'Replace this with your code.
    '***************************************************
    lngFileCount = lngFileCount + 1
    '**************************************************
    bIsFile = False
Else
    '**************************************************
    'This is where you put the code to handle all other
    'items found...
    '**************************************************
End If
If strCurFile = "" Then
    lngSubIdx = lngSubIdx + 1
    If lngSubIdx > UBound(strSubDirs) Then
        bEndOfSearch = True
    Else
        bFirstFile = True
    End If
End If
   
'*************************'*************************'*************************
'*************************'*****   NOME FILE   *****'*************************
   If strCurFile = NomeFile Then
      CercaFile = strParentDir & strCurFile
      Exit Function
   End If
   DoEvents
Loop
MsgBox "File not found: " & NomeFile

End Function

Public Function ChiaveAccesso() As String
   Dim DriveAccesso As DriveInformation
   Dim Lunghezza As Integer
   Dim i As Integer
   Dim Trasformazione As String
   Dim CodiceTrasformato As String
   Dim EsaDecimale As String
   Dim CodiceTrasformatoEsadecimale As Variant
   Dim ChiaveFinale As Long
   
   
   DriveAccesso = DriveInfo("c:\")
   With DriveAccesso
       .SerialNumber = ((.SerialNumber - 2408)) - 98  '((NumeroSeriale - 2408) * 2) - 98
       EsaDecimale = Hex(.SerialNumber)
      CodiceUtente = EsaDecimale
   End With
   
   Lunghezza = Len(EsaDecimale)
   For i = 1 To Lunghezza
       Trasformazione = Mid(EsaDecimale, i, 1)
       Select Case Trasformazione
           Case "1"
           CodiceTrasformato = CodiceTrasformato & "53"
           Case "2"
           CodiceTrasformato = CodiceTrasformato & "66"
           Case "3"
           CodiceTrasformato = CodiceTrasformato & "49"
           Case "4"
           CodiceTrasformato = CodiceTrasformato & "81"
           Case "5"
           CodiceTrasformato = CodiceTrasformato & "22"
           Case "6"
           CodiceTrasformato = CodiceTrasformato & "65"
           Case "7"
           CodiceTrasformato = CodiceTrasformato & "46"
           Case "8"
           CodiceTrasformato = CodiceTrasformato & "23"
           Case "9"
           CodiceTrasformato = CodiceTrasformato & "34"
           Case "0"
           CodiceTrasformato = CodiceTrasformato & "24"
           Case "A"
           CodiceTrasformato = CodiceTrasformato & "25"
           Case "B"
           CodiceTrasformato = CodiceTrasformato & "35"
           Case "C"
           CodiceTrasformato = CodiceTrasformato & "48"
           Case "D"
           CodiceTrasformato = CodiceTrasformato & "54"
           Case "E"
           CodiceTrasformato = CodiceTrasformato & "63"
           Case "F"
           CodiceTrasformato = CodiceTrasformato & "87"
       End Select
   Next i
   
   ' N.B.= PRENDO IN CONSIDERAZIONE SOLO I PRIMI 8 CARATTERI DEL CODICE
   CodiceTrasformato = Mid(CodiceTrasformato, 1, 8)
   CodiceTrasformatoEsadecimale = Hex(CLng(CodiceTrasformato))
  
   
'********************************************************************************************
'********************************************************************************************
   'SUL RISULTATO DELLA CONVERSIONE (IN ESADECIMALE) EFFETTUO UN'ULTERIORE MODIFICA _
      ELIMINANDO LE LETTERE E TRASFORMANDO TUTTO IN CIFRE.
     
   Lunghezza = Len(CodiceTrasformatoEsadecimale)
   For i = 1 To Lunghezza
       Trasformazione = Mid(CodiceTrasformatoEsadecimale, i, 1)
       
       'Se  una lettera allora...
       If Trasformazione = "A" Or Trasformazione = "B" Or _
          Trasformazione = "C" Or Trasformazione = "D" Or _
          Trasformazione = "E" Or Trasformazione = "F" Then
         
         Select Case Trasformazione
             Case "A"
             ChiaveFinale = ChiaveFinale & "1"
             Case "B"
             ChiaveFinale = ChiaveFinale & "3"
             Case "C"
             ChiaveFinale = ChiaveFinale & "2"
             Case "D"
             ChiaveFinale = ChiaveFinale & "8"
             Case "E"
             ChiaveFinale = ChiaveFinale & "4"
             Case "F"
             ChiaveFinale = ChiaveFinale & "5"
         End Select
         
      Else
         ChiaveFinale = ChiaveFinale & Trasformazione
      End If
   Next i
   
   ChiaveFinale = ChiaveFinale / 2
   ChiaveAccesso = ChiaveFinale
   
End Function



Public Sub CreaFileAbilitazione()
'   Dim NumFile As Integer
'
'   On Error GoTo gesterr
'
'   NumFile = FreeFile
''   ChDrive "c:"
''   ChDir CartellaDiSistema
'   Open IniPathSystem For Output As #NumFile
'   NumeroEsecuzioni = 10
'
'   Print #NumFile, "[SBPCI]"
'   Print #NumFile, "Port=009M5243"
'   Print #NumFile, "USBPort=220W632"
'   Print #NumFile, "IRQ=7Q456R123"
'   Print #NumFile, "SBIRQ=124"
'   Print #NumFile, "DMA=1"
'   Print #NumFile, "DMA16=7"
'   Print #NumFile, "SBEnable=false"
'   Print #NumFile, "JSEnable=true"
'   Print #NumFile, "PCIPort=100F1451"
'   Print #NumFile, "PCIIRQ=10P6363334"
'   Print #NumFile, "SPDIFMode=1"
'   Print #NumFile, "SPDIFRec=B103C6755"
'
'   Close #NumFile
''   SetAttr CartellaDiSistema & "\" & IniName, vbHidden ?? conviene
'   SetAttr CartellaDiSistema & "\" & IniName, vbNormal
'
'   Exit Sub
'
'gesterr:
'   If Err.Number > 0 Then
'      MsgBox "Comunicare al Servizio Assistenza il seguente errore:" & vbNewLine & "N. " & Err.Number & " - " & Err.Description, vbCritical, "Errore"
'   End If
'
'   On Error GoTo 0
End Sub


Public Function CalcolaEsecuzioni() As Integer
   Dim QuanteEsecuzioni As String
   Dim AppoEsecuzioni As String  'contiene il valore decrementato di
                                 '1 unit da scrivere nella Chiave di Registro
   
   Dim LettereUlterioriEsecuzioni As String
   
   'QuanteEsecuzioni = ReadINI("SBPCI", "Port", IniPathSystem)
    
   QuanteEsecuzioni = GetSetting(NomeKeyReg, "New", NomeKeyReg, vbNullString)
   LettereUlterioriEsecuzioni = Mid(QuanteEsecuzioni, 10, 1)
   
   QuanteEsecuzioni = Mid(QuanteEsecuzioni, 6, 1)
   
   
   
   Select Case QuanteEsecuzioni
      Case "F"
         CalcolaEsecuzioni = 0
         AppoEsecuzioni = "F"
     
         If ProgrammaAttivato = False Then
            'MsgBox "VERSIONE DIMOSTRATIVA SCADUTA..." & vbNewLine & vbNewLine & "Per ottenere il modulo di abilitazione," & vbNewLine & "cliccare sul tasto <Stampa> (Richiedi Chiave)", vbInformation, "Attivazione Programma " & NOMEPROGETTO
         End If
         
      Case "B"
         CalcolaEsecuzioni = 1
         AppoEsecuzioni = "F"
      Case "X"
         CalcolaEsecuzioni = 2
         AppoEsecuzioni = "B"
      Case "G"
         CalcolaEsecuzioni = 3
         AppoEsecuzioni = "X"
      Case "P"
         CalcolaEsecuzioni = 4
         AppoEsecuzioni = "G"
      Case "E"
         CalcolaEsecuzioni = 5
         AppoEsecuzioni = "P"
      Case "R"
         CalcolaEsecuzioni = 6
         AppoEsecuzioni = "E"
      Case "Z"
         CalcolaEsecuzioni = 7
         AppoEsecuzioni = "R"
      Case "A"
         CalcolaEsecuzioni = 8
         AppoEsecuzioni = "Z"
      Case "M"
         CalcolaEsecuzioni = 9
         AppoEsecuzioni = "A"
      Case "H"
         CalcolaEsecuzioni = 10
         AppoEsecuzioni = "M"
      Case "J"
         CalcolaEsecuzioni = 11
         AppoEsecuzioni = "H"
      Case "V"
         CalcolaEsecuzioni = 12
         AppoEsecuzioni = "J"
      Case "N"
         CalcolaEsecuzioni = 13
         AppoEsecuzioni = "V"
      Case "C"
         CalcolaEsecuzioni = 14
         AppoEsecuzioni = "N"
      Case "L"
         CalcolaEsecuzioni = 15
         AppoEsecuzioni = "C"
      Case "K"
         CalcolaEsecuzioni = 16
         AppoEsecuzioni = "L"
      Case "Y"
         CalcolaEsecuzioni = 17
         AppoEsecuzioni = "K"
      Case "I"
         CalcolaEsecuzioni = 18
         AppoEsecuzioni = "Y"
      Case "T"
         CalcolaEsecuzioni = 19
         AppoEsecuzioni = "I"
      Case "D"
         CalcolaEsecuzioni = 20
         AppoEsecuzioni = "T"
         
      Case "Q"
         CalcolaEsecuzioni = 99
         AppoEsecuzioni = "Q"
   End Select
   
   'Aggiorno la chiave con il nuovo valore del numero di esecuzioni disponibili
   SaveSetting NomeKeyReg, "New", NomeKeyReg, "IRQ=7" & AppoEsecuzioni & "456" & LettereUlterioriEsecuzioni & "123;PCIPort=100S14Z1"

End Function




Public Sub LeggiFileAbilitazione()
   Dim CodiceAttivazioneCompleto As String
   Dim strRegistro As String
   Dim PosPuntoVirgola As Byte
   Dim PosESSE As Byte
   
   'SaveSetting "MSBPers", "New", "MSBPers", "IRQ=7D456R123;PCIPort=100S1451"
   'Distinzione per il NUOVO nome del prg "BluConad-E" ed il VECCHIO "BluARc2"
   strRegistro = GetSetting(NomeKeyReg, "New", NomeKeyReg, vbNullString)
   
   PosPuntoVirgola = InStr(1, strRegistro, ";")
   PosESSE = InStr(1, strRegistro, "S")
   
   CodiceAttivazione_1 = Mid(strRegistro, 11, PosPuntoVirgola - 11)
   
   CodiceAttivazione_2 = Mid(strRegistro, PosESSE + 1)

   CodiceAttivazioneCompleto = CodiceAttivazione_1 & CodiceAttivazione_2
   
   If CodiceAttivazioneCompleto = NumeroSerialeHardDiskCriptato Then
      ProgrammaAttivato = True
      Exit Sub
   End If
   
   'Distinzione per il NUOVO nome del prg "BluConad-E" ed il VECCHIO "BluARc2"
   'NumeroEsecuzioni = CalcolaEsecuzioni()
   
   'If (NumeroEsecuzioni = 99) And (CodiceAttivazioneCompleto = NumeroSerialeHardDiskCriptato) Then
   If (CodiceAttivazioneCompleto = NumeroSerialeHardDiskCriptato) Then
      ProgrammaAttivato = True
   Else
      ProgrammaAttivato = False
   End If
End Sub


Public Sub ImpostaDatiAbilitazione()
   Dim i As Integer
   Dim FindStr As String
   
   NumeroSerialeHardDiskCriptato = ChiaveAccesso
   ProgrammaAttivato = False
   
   'Trasformo il nome dell'EXE invertendo il nome (ES: bluarc1 -> 1craulb) _
    in modo da non dovermi inventare ogni volta il file o la chiave di _
    registro dove inserire la chiave di abilitazione
   For i = 0 To Len(NOMEPROGETTO) - 1
      NomeKeyReg = NomeKeyReg & Mid(LCase(NOMEPROGETTO), Len(NOMEPROGETTO) - i, 1)
   Next i
   
   
   'Cerco la chiave nel Registro per vedere se il prg e' abilitato
   FindStr = GetSetting(NomeKeyReg, "New", NomeKeyReg, vbNullString)
   If Len(Trim(FindStr)) = 0 Then  'Riga nel Registro ancora non e' stata creata
      Call CreaKeyAbilitazione
   Else
      Call LeggiFileAbilitazione
   End If
End Sub

Public Sub CreaKeyAbilitazione()

   'Crea la Chiave generica (con le 20 esecuzioni) nel file di Registro _
      impostando il contatore delle esecuzioni (carattere 6) = T, cioe' _
         altre 19 esecuzioni!!
   SaveSetting NomeKeyReg, "New", NomeKeyReg, "IRQ=7T456R123;PCIPort=100S14Z1"
   'NumeroEsecuzioni = 20
End Sub

Public Sub CreaKeyAbilitazioniAGGIUNTIVE()

   'QUI CANCELLO LA CHIAVE E LA RICREO PER ULTEIORI 20 ESECUZIONI!"
   'DeleteSetting NomeKeyReg
   Call EliminaKeyAbilitazione
   
   'Ricreo la Chiave
   SaveSetting NomeKeyReg, "New", NomeKeyReg, "IRQ=7T456F123;PCIPort=100S14Z1"
   'NumeroEsecuzioni = 20
End Sub

Public Sub EliminaKeyAbilitazione()

   'Elimina la Chiave di registro
   DeleteSetting NomeKeyReg
   
End Sub

Public Function CONNETTI_UTENTE_CORRENTE() As Boolean
   'Dim NumFile As Integer
   'Dim ApriFile As String
   'Dim stringa As String
   
   'NumFile = FreeFile


   CONNETTI_UTENTE_CORRENTE = True

''Questa funzione restituisce TRUE se non  stato raggiunto il Numero Massimo degli Utenti connessi _
' contemporaneamente come da Contratto
   Dim RS As ADODB.Recordset
   Dim strRicerca As String
   Dim NUM_CONN As Byte
   Dim MAX_CONN As Byte
   Dim i As Integer
   Dim vUltimaPos As Integer
   
   NUM_CONN = 0

'Qui prendo il Numero di Connessioni come da Contratto _
   (MOMENTANEAMENTE IL NUMERO E' IMPOSTATO FISSO IN QUESTA TABELLA _
    MA IN FUTURO DOVRA' ESSERE LETTO DAL CODICE DI ABILITAZIONE!!)
   strRicerca = "Select * from NUM_CONN"
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneGenerale, adOpenStatic
   If Not RS.EOF Then
      MAX_CONN = RS!NCNUMCON
   End If
   RS.Close
   Set RS = Nothing

   'Se c' PrimoTools in esecuzione allora aggiungo un posto di lavoro che altrimenti risulterebbe in meno a causa della connessione di PrimoTools
   If VerificaEsecuzioneEXE(App.path & "\Utility\PrimoTools\PrimoTools.exe") = True Then
      MAX_CONN = MAX_CONN + 1
   End If


   If gTipoDB = 1 Then 'SQL

'''   'Qui leggo la sp_Who2 che mi restituisce tutti gli utenti collegati al database. _
'''    Nel ciclo poi faccio il filtro per verificare solo gli utenti collegati al database _
'''    PRIMO_GENER (attribuito alla variabile NomeDBSQL_GEN nel modulo Main) e che sono _
'''    collegati con il Primgramma PRIMO
'''      Set RS = ConnessioneGenerale.Execute("EXEC sp_Who2 ")
'''      If Not RS.EOF Then
'''         RS.MoveFirst
'''         Do Until RS.EOF
'''            If Trim(RS!ProgramName) = App.ProductName And Trim(RS!dbname) = NomeDBSQL_GEN Then
'''               'RS!spid = ID
'''               'RS!loginame = Nome utente sa
'''               'RS!HostName = Nome Utente del PC
'''               'RS!dbname = Nome al database a cui e' collegato
'''               NUM_CONN = NUM_CONN + 1
'''            End If
'''            RS.MoveNext
'''         Loop
'''      End If
'''      RS.Close
'''      Set RS = Nothing

   Else  'ACCESS
         
      ' The user roster is exposed as a provider-specific schema rowset
      ' in the Jet 4 OLE DB provider.  You have to use a GUID to
      ' reference the schema, as provider-specific schemas are not
      ' listed in ADO's type library for schema rowsets
   
      Set RS = ConnessioneGenerale.OpenSchema(adSchemaProviderSpecific, _
      , "{947bb102-5d43-11d1-bdbf-00c04fb92675}")
   
      'Output the list of all users in the current database.
   
      'Debug.Print rs.Fields(0).Name, "", rs.Fields(1).Name, _
      "", rs.Fields(2).Name, rs.Fields(3).Name
   
      While Not RS.EOF
         'Debug.Print RS.Fields(0), RS.Fields(1), RS.Fields(2), RS.Fields(3)
         
         'Dim vStr As String
         'vStr = Replace(RS.Fields(0), Chr(13) + Chr(10), " ")
         
         'If Len(Trim(Mid(RS.Fields(0), 1, 5))) > 0 Then
            'Debug.Print RS.Fields(0), RS.Fields(1), RS.Fields(2), RS.Fields(3)
            NUM_CONN = NUM_CONN + 1
         'End If
         
         RS.MoveNext
      Wend

   End If

'QUI FACCIO IL CONTROLLO
   If NUM_CONN > MAX_CONN Then CONNETTI_UTENTE_CORRENTE = False
End Function

