Attribute VB_Name = "ModuloSCONTRINI"
Option Explicit


Public mPathFileConf4Scontrino As String

'Private mFileConf As String
'Public mpGridScontrino As ReportControl
Public mpGridScontrino As ReportControl
'Private mScontoDoc As Currency
'Private mScontoPercent As Boolean
'Private mImpRicPerScontrino As Currency
'Private mImpTotale As Currency
 'Posizione Colonne Griglia
   'Private mColCodArt As Byte
   'Private mColCodIva As Byte
   'Private mColQuanti As Byte
   'Private mColPrezzo As Byte
   'Private mColPrzQta As Byte
   'Private mColImpNet As Byte
   'Private mColScont1 As Byte
   'Private mColSimbol As Byte
'Private mPuntiFid As Long
'Private mRistScontrino As String
'Private mRifDocFat As String
Private mTotImpArt As Currency
'Private mCodFisc As String
'Private mPrepagUsato As Currency

Public mPathDestScontrino As String
Dim mLenDescri As String


'VALORI SERIALI PER XON/XOFF
'Public gSctrnSerialPORT As String
'Public gSctrnSerialSPEED As String
'Public gSctrnSerialDATABITS As String
'Public gSctrnSerialPARITY As String
'Public gSctrnSerialSTOPBITS As String
'Public gSctrnSerialECHO As String

Dim mLenDescriXonXOff As Integer


'Contiene i dati dell'ultimo scontrino stampato
Private Type mTypeLastScontrino
   'DocSerial As Long 'MvSerial del Documento che si sta stampanto
   'CodiceConto As String 'Codice del Cliente/Generico intestatario dello scontrino
   FilePrint As String 'Nome del file inviato nella cartella IN (Epson) da stampare
   ProgFiscale As Long 'Progressivo Fiscale dello scontrino restituito dal registratore
   StringaEsito As String 'contiene l'esito prodotto dal registratore di cassa
   DescErrore As String 'Contiene eventuale Descrizione dell'errore di stampa
   DescErrInChiaro As String 'qui inserisco una descrizione in chiaro che possa essere comprensibile all'utente (la ricavo dal tipo di errore)
   ResetPrint As Boolean 'Se TRUE eseguo il reset del Registratore
   PathOut As String 'PAth del file di risposta
   EsitoPerDB As String 'Contiene la stringa che sar salvata nella tabella xxxxxDOC_RT_INFO
End Type
Public gtLastScontrino As mTypeLastScontrino


'Contiene i dati necessari per stampa un nuovo Scontrino/Fattura sul Registratore Telematico
Private Type mTypeParam4RegCas
   pCausalDoc As String
   pSerial As Long
   pCodConto As String 'solo se Tipo = 'C' (per il Conto Generico non salvo nulla)
   pFileConf As String
   'pGrid As ReportControl
   pImpTotale As Currency
   pImpRicPerScontrino As Currency
   pScontoDoc As Currency
   pScontoPercent As Boolean
   pColCodArt As Byte
   pColCodIva As Byte
   pColRepIVA As Byte
   pColQuanti As Byte
   pColPrezzo As Byte
   pColPrzQta As Byte
   pColImpNet As Byte
   pColScont1 As Byte
   pColSimbol As Byte
   pColStmpAddMsgRow As Byte
   pColStmpSeparLineBefore As Byte
   
   pPuntiFid As Long
   pRistScontrino As String
   pRifDocFat As String
   pXonXoff As Boolean
   pCodFisc As String
   pPrepagUsato As Currency
   pPrepagResiduo As Currency
   pMatricola As String
   pModalitaRT As Boolean
   pStmpDescrAltern As Boolean
   
   pEseguiReso As Boolean
   pEseguiAnnullo As Boolean
   pResAnnNumDoc1 As String
   pResAnnNumDoc2 As String
   pResAnnDatDoc As String
   pResAnnMatric As String
   pDocAnnullo() As String 'contiene i documenti di PRIMO che fanno riferimento allo scontrino che si sta annullando
   
   pVoucherID As String
   pVoucherDescr As String
   pVoucherValue As Currency
   
   pGenerazioneCustom As String 'Solo per CUSTOM indica la Generazione (se II-IV oppure III) perch alcune azioni sono differenti
End Type
Public gtParam4RegCas As mTypeParam4RegCas


Private Type mTypeRepartiIVA
   riCodRep() As String
   riCodIVA() As String
   riCodAlt() As String 'Codici alternativi ma di pari aliquota IVA
   riArtSer() As String
End Type
Public gtRepartiIVA As mTypeRepartiIVA

Public Sub SetRepartiIVA()
   'Questo type  usato prevalentemente in CASSA e SUBTOTALE in modo da recuperare velocemente il Reparto IVA _
    dei vari servizi/articoli venduti che serve specificare in fase di emissione dello scontrino _
    Abbiamo deciso di adottare questa soluzione per evitare di aprire continuamente la tabella TAB_GEN
   
   Erase gtRepartiIVA.riCodRep
   Erase gtRepartiIVA.riCodIVA
   Erase gtRepartiIVA.riCodAlt
   Erase gtRepartiIVA.riArtSer

   Dim RS As ADODB.Recordset
   Dim strRicerca As String
   
   strRicerca = "SELECT * FROM [" & Azienda & "TAB_GEN] " & _
                " WHERE TGCHIAVE = 'REPIVA' " & _
                " ORDER BY TGTESTO1 DESC, TGTESTO3 DESC"
                '" ORDER BY TGTESTO1 DESC, TGTESTO3 ASC"
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneGenerale, adOpenStatic
   If Not RS.EOF Then
      Do Until RS.EOF
         Call AddArrayElement(gtRepartiIVA.riCodRep, RS!TGCODICE)
         Call AddArrayElement(gtRepartiIVA.riCodIVA, NonNullo(RS!TGTESTO1))
         Call AddArrayElement(gtRepartiIVA.riCodAlt, NonNullo(RS!TGTESTO5))
         Call AddArrayElement(gtRepartiIVA.riArtSer, NonNullo(RS!TGTESTO3))
         
         RS.MoveNext
      Loop
   End If
   RS.Close
   Set RS = Nothing
End Sub


Public Function GetRepartoIVA(pCodIva As String, pTipoArtSer As String) As String
   'Questo type  usato prevalentemente in CASSA e SUBTOTALE in modo da recuperare velocemente il Reparto IVA _
    dei vari servizi/articoli venduti che serve specificare in fase di emissione dello scontrino _
    Abbiamo deciso di adottare questa soluzione per evitare di aprire continuamente la tabella TAB_GEN
   
   Dim i As Integer
   Dim vReparto As String
   Dim vTipoArtSer As String
      
   If pTipoArtSer = "R" Then
      vTipoArtSer = "ART"
   ElseIf pTipoArtSer = "S" Then
      vTipoArtSer = "SER"
   Else
      vTipoArtSer = pTipoArtSer
   End If
   
   
   If VerificaArrayInizializzato(gtRepartiIVA.riCodRep) Then
      For i = 0 To UBound(gtRepartiIVA.riCodRep)
         
         'Qui cerco SUBITO l'associazione al CODICE IVA ed al TIPO e se lo trovo esco subito dal ciclo ...
            If (gtRepartiIVA.riCodIVA(i) = pCodIva) And (gtRepartiIVA.riArtSer(i) = vTipoArtSer) Then
               vReparto = gtRepartiIVA.riCodRep(i)
               Exit For
            End If
         
         '...altrimenti faccio un controllo senza TIPO che serve per le aliquote dove non c' il tipo specificato (es. "ESENT") ...
            If (gtRepartiIVA.riCodIVA(i) = pCodIva) And (gtRepartiIVA.riArtSer(i) = "") Then
               vReparto = gtRepartiIVA.riCodRep(i)
               Exit For
            End If
         
         
         'NB: se arrivo qui significa che non  stato trovato il Codice IVA passato e questo pu verificarsi _
              in tutti casi in cui le IVA erano state separate tra articoli e servizi. _
              Qui, pertanto, cerca nella stringa TGTESTO5 dove ci sono tutte
            If (InStr(1, gtRepartiIVA.riCodAlt(i), "|" & pCodIva & "|") > 0) And (gtRepartiIVA.riArtSer(i) = vTipoArtSer) Then
               vReparto = gtRepartiIVA.riCodRep(i)
               Exit For
            End If
            
            '... senza TIPO
            If (InStr(1, gtRepartiIVA.riCodAlt(i), "|" & pCodIva & "|") > 0) And (gtRepartiIVA.riArtSer(i) = "") Then
               vReparto = gtRepartiIVA.riCodRep(i)
               Exit For
            End If
         
      Next i
      
      GetRepartoIVA = vReparto
   End If
End Function


 
Public Function StampaSCONTRINO() As Boolean
   Dim vMsg As String
   Dim vMarca As String
   Dim vStrSerial As String
   Dim vAnnullaSeriale As Boolean
   If gtParam4RegCas.pSerial > 0 Then
      vStrSerial = " Seriale " & gtParam4RegCas.pSerial & "  "
   End If
   
   Call MsgRegCasInLogFile("======================  [StampaScontrino]  " & vStrSerial & "======================")
   
   

   Call AzzeraTypeLastScontrino 'al momento questo lo uso per EPSON>RT / RCH>RT / CUSTOM
   
   
   
   If VerificaEsistenzaFile(PathREGCAS & "\Custom\" & gtParam4RegCas.pFileConf & ".CNF") = True Then
      mPathFileConf4Scontrino = PathREGCAS & "\Custom\" & gtParam4RegCas.pFileConf & ".CNF"
   Else
      mPathFileConf4Scontrino = PathREGCAS & "\" & gtParam4RegCas.pFileConf & ".CNF"
   End If
   
   
   'Controllo che il file di configurazione esista
   If VerificaEsistenzaFile(mPathFileConf4Scontrino) = False Then
      MsgBox "ATTENZIONE!" & vbNewLine & _
             "Impossibile trovare il file di configurazione per la stampa del Registratore di Cassa." & vbNewLine & _
             "(" & mPathFileConf4Scontrino & ")" & vbNewLine & vbNewLine & _
             "Impossibile eseguire la stampa dello Scontrino.", vbCritical
      GoTo salta
   End If

   'Qui prendo la Marca che  il parametro TYPE
   vMarca = ReadINI("TYPE", "NAME", mPathFileConf4Scontrino)
   'Controllo che sia pieno
   If Len(Trim(vMarca)) = 0 Then
      MsgBox "ATTENZIONE!" & vbNewLine & _
             "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
             "(Tag [TYPE] Parametro <NAME> non presente)" & vbNewLine & vbNewLine & _
             "Impossibile eseguire la stampa dello Scontrino.", vbCritical
      GoTo salta
   End If



ripeti_stampa:

'STAMPA SCONTRINO -----------------------------------------------
   If gtParam4RegCas.pXonXoff Then
   
      'SOLO PER PROTOCOLLO XON/XOFF
         If Scontrino_XONXOFF(vMarca, gtParam4RegCas.pCausalDoc, "", False, gtParam4RegCas.pSerial) = False Then
            If MsgBox("Riprovare a stampare lo Scontrino?", vbQuestion + vbYesNo) = vbYes Then
               GoTo ripeti_stampa
            End If
         End If
      
   Else
   
      'ALTRI PROTOCOLLI O SOFTWARE IN ASCOLTO
         Select Case vMarca
         
            Case "CUSTOM"
               If Scontrino_CUSTOM(gtParam4RegCas.pCausalDoc, gtParam4RegCas.pSerial) = False Then
                  If gtParam4RegCas.pModalitaRT Then
                     vAnnullaSeriale = True
                     GoTo salta
                  Else
                     If MsgBox("Riprovare a stampare lo Scontrino?", vbQuestion + vbYesNo) = vbYes Then
                        GoTo ripeti_stampa
                     End If
                  End If
               End If
               
               
            Case "OLIVETTI-NETTUNA"
               If Scontrino_OLIVETTI_NETTUNA = False Then
                  If MsgBox("Riprovare a stampare lo Scontrino?", vbQuestion + vbYesNo) = vbYes Then
                     GoTo ripeti_stampa
                  End If
               End If
            
            
            Case "EPSON"
               Dim vCGI As Boolean
               vCGI = (ReadINI("PARAMETRI", "COMUNICAZIONE", mPathFileConf4Scontrino) = "WebService")
               
               If (vCGI) And (gtParam4RegCas.pModalitaRT) Then
                  If EpsonSetScontrino_CGI_RT = False Then
                     vAnnullaSeriale = True
                     GoTo salta
                  End If
                  
               Else
               
                  If Scontrino_EPSON(gtParam4RegCas.pCausalDoc, gtParam4RegCas.pSerial) = False Then
                     If gtParam4RegCas.pModalitaRT Then
                        If gtLastScontrino.ProgFiscale <= 0 Then 'In errore
                           'Compongo il messaggion di errore
                              vMsg = gtLastScontrino.DescErrInChiaro
                           
                           'Verifico se devo Resettare il registratore
                              If gtLastScontrino.ResetPrint Then
                                 vMsg = vMsg & vbNewLine & vbNewLine & _
                                        "Il Documento corrente sar annullato"
                                 If VerificaEsistenzaFile(gtLastScontrino.PathOut & gtLastScontrino.FilePrint) Then
                                    Call PausaProgramma(1, True, True)
                                    Call KillaFile(gtLastScontrino.PathOut & gtLastScontrino.FilePrint)
                                    'Kill gtLastScontrino.PathOut & gtLastScontrino.FilePrint
                                 End If
                              End If
                              
                           'Mostro il Messaggio
                              MsgBox vMsg, msg_Critical
                              If gtLastScontrino.ResetPrint Then
                                 Call EpsonResetPrinter
                              End If
                           
                           vAnnullaSeriale = True
                           GoTo salta
                        End If
                     
                     Else 'MF
                        If MsgBox("Riprovare a stampare lo Scontrino?", vbQuestion + vbYesNo) = vbYes Then
                           GoTo ripeti_stampa
                        End If
                     
                     End If
                  End If
               End If
               
               
            Case "RCH-RT"
               If Scontrino_RCH_RT = False Then
                  vAnnullaSeriale = True
                  GoTo salta
               End If
            
'               If Scontrino_EPSON(gtParam4RegCas.pCausalDoc, gtParam4RegCas.pSerial) = False Then
'                  If gtParam4RegCas.pModalitaRT Then
'                     If gtLastScontrino.ProgFiscale <= 0 Then 'In errore
'                        'Compongo il messaggion di errore
'                           vMsg = gtLastScontrino.DescErrInChiaro
'
'                        'Verifico se devo Resettare il registratore
'                           If gtLastScontrino.ResetPrint Then
'                              vMsg = vMsg & vbNewLine & vbNewLine & _
'                                     "Il Documento corrente sar annullato"
'                              If VerificaEsistenzaFile(gtLastScontrino.PathOut & gtLastScontrino.FilePrint) Then
'                                 Call PausaProgramma(1, True, True)
'                                 Call KillaFile(gtLastScontrino.PathOut & gtLastScontrino.FilePrint)
'                                 'Kill gtLastScontrino.PathOut & gtLastScontrino.FilePrint
'                              End If
'                           End If
'
'                        'Mostro il Messaggio
'                           MsgBox vMsg, msg_Critical
'                           If gtLastScontrino.ResetPrint Then
'                              Call EpsonResetPrinter
'                           End If
'
'                        vAnnullaSeriale = True
'                        GoTo salta
'                     End If
'
'                  Else 'MF
'                     If MsgBox("Riprovare a stampare lo Scontrino?", vbQuestion + vbYesNo) = vbYes Then
'                        GoTo ripeti_stampa
'                     End If
'
'                  End If
'               End If
                              
            Case "DITRON"
               If Scontrino_DITRON(gtParam4RegCas.pCausalDoc, gtParam4RegCas.pSerial) = False Then
                  If MsgBox("Riprovare a stampare lo Scontrino?", vbQuestion + vbYesNo) = vbYes Then
                     GoTo ripeti_stampa
                  End If
               End If
               
            Case "DATAPROCESS": Call Scontrino_DATAPROCESS
            Case "MCT": Call Scontrino_MCT_RCH
            Case "RCH": Call Scontrino_MCT_RCH
            Case "FASY": Call Scontrino_FASY
         End Select
      
      
      'Se arriva qui  OK!
      StampaSCONTRINO = True
      Call MsgRegCasInLogFile("~~~~~~~~~~~~~~~~~~~~~~  [Stampa ESITO OK]  " & vStrSerial & "~~~~~~~~~~~~~~~~~~~~~~")
   End If
'------------------------------------------------------------
   

salta:
   If vAnnullaSeriale Then
      'significa che devo registrare che il seriale  stato annullato (solo per RT che NON possono chiudere i docuemnti se non stampano)
      If Len(Trim(vStrSerial)) > 0 Then
         Call MsgRegCasInLogFile("!!!!!!!!!!!!!!!!!!!!!  ALERT! Stampa ANNULLATA e " & Trim(vStrSerial) & " RIPRISTINATO  !!!!!!!!!!!!!!!!!!!!!")
      Else
         Call MsgRegCasInLogFile("!!!!!!!!!!!!!!!!!!!!!  ALERT! Stampa ANNULLATA  !!!!!!!!!!!!!!!!!!!!!")
      End If
   End If
   
'qui le distruggo le variabili per sicurezza
   gtParam4RegCas.pFileConf = ""
   Set mpGridScontrino = Nothing
   gtParam4RegCas.pScontoDoc = 0
   gtParam4RegCas.pScontoPercent = False
   gtParam4RegCas.pImpRicPerScontrino = 0
   gtParam4RegCas.pImpTotale = 0
   gtParam4RegCas.pColCodArt = 0
   gtParam4RegCas.pColQuanti = 0
   gtParam4RegCas.pColPrezzo = 0
   gtParam4RegCas.pColScont1 = 0
   gtParam4RegCas.pColStmpAddMsgRow = 0
   gtParam4RegCas.pColStmpSeparLineBefore = 0
      
   'Campi per Reso o Annullo
   gtParam4RegCas.pEseguiReso = False
   gtParam4RegCas.pEseguiAnnullo = False
   gtParam4RegCas.pResAnnNumDoc1 = ""
   gtParam4RegCas.pResAnnNumDoc2 = ""
   gtParam4RegCas.pResAnnDatDoc = ""
   gtParam4RegCas.pResAnnMatric = ""
            
   FormCASSA.mRitornoDaSubtot = False
   FormCASSA.mIncassaScaduti = False
         
   Call ScaricaGriglia99Cassa
   
End Function

Private Sub ScaricaGriglia99Cassa()
   On Error Resume Next
   Unload FormCASSA.Griglia(99)
   On Error GoTo 0
End Sub
   


Private Sub Scontrino_DATAPROCESS()
   Dim NumFile As Integer 'per aprire il file di esecuzioni(LOG)
   Dim vStrRiga As String
   Dim i As Integer
   Dim vStrImpRicevuto As String
   Dim vVal As String
   
   'Dim vPathScontrino As String
   'Qui prendo il PATH dove creare il file dello scontrino da stampare
   
   mPathDestScontrino = ReadINI("FPCONNECTOR", "PATH", mPathFileConf4Scontrino)
   'Controllo che sia pieno
   If Len(Trim(mPathDestScontrino)) = 0 Then
      MsgBox "ATTENZIONE!" & vbNewLine & _
             "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
             "(Tag [FPCONNECTOR] Parametro <PATH> non presente)" & vbNewLine & vbNewLine & _
             "Impossibile eseguire la stampa dello Scontrino.", vbCritical
      Exit Sub
   End If
   
   'Verifico se aprire il Cassetto
   vVal = ReadINI("PARAMETRI", "APRI_CASSETTO", mPathFileConf4Scontrino)
   If vVal = "1" Then Call Test_DATAPROCESS(mPathDestScontrino, "", 1)
   
   
   'verifico che non si tratti di una ristampa...
   If Len(gtParam4RegCas.pRistScontrino) = 0 Then
      
      '...altrimenti QUI INIZIO A COMPORRE LO SCONTRINO
      NumFile = FreeFile
      Open App.path & "\temp.txt" For Append As #NumFile      'CREO IL FILE
   
      With mpGridScontrino
      
         For i = 0 To .Rows.Count - 1
            
            'Qui verifico se c'e' l'associazione del Codice IVA con il Reparti del Registratore di Cassa
            vVal = ReadINI("REPARTIIVA_REPARTI", .Rows(i).Record.Item(gtParam4RegCas.pColRepIVA).Value, mPathFileConf4Scontrino)
            If Len(Trim(vVal)) > 0 Then vVal = Replace(UCase(vVal), "REPARTO", "")
            If IsNumeric(vVal) = False Then vVal = "1"
            
            
            'Controllo se si tratta di un RESO o di un articolo normale di vendita
            'If .CellBackColor = Colore("rosso1") Then
            If .Rows(i).Record.Item(gtParam4RegCas.pColSimbol).Value = "R" Then
               vStrRiga = RowScontrDATAPROCESS(i, "RESO", vVal) 'Compongo la stringa di RESO
            Else
               vStrRiga = RowScontrDATAPROCESS(i, "STD", vVal) 'Compongo la stringa STANDARD
            End If
            Print #NumFile, vStrRiga                  'Stampo la stringa nel File
            
            
            'Qui controllo se c' lo Sconto riga sull'Articolo
            If .Rows(i).Record.Item(gtParam4RegCas.pColScont1).Value > 0 Then
               vStrRiga = RowScontrDATAPROCESS(i, "SCN_RIG", vVal)  'Compongo la stringa SCONTO RIGA
               Print #NumFile, vStrRiga                        'Stampo la stringa nel File
            End If
            
         Next i
         
         
         'Qui controllo se c' SCONTO sul Documento
         If gtParam4RegCas.pScontoDoc > 0 Then
            If gtParam4RegCas.pScontoPercent = True Then 'Controllo se  in PERCENTUALE...
               vStrRiga = RowScontrDATAPROCESS(0, "SCN_DOC_PER")   'Compongo la stringa SCONTO RIGA
               Print #NumFile, vStrRiga                            'Stampo la stringa nel File
            Else                          '...oppure se  a VALORE
               vStrRiga = RowScontrDATAPROCESS(0, "SCN_DOC_DOC")   'Compongo la stringa SCONTO RIGA
               Print #NumFile, vStrRiga                        'Stampo la stringa nel File
            End If
         End If
         
               
         'CONTROLLO SE DEVO INDICARE IL RESTO SULLO SCONTRINO
         If gtParam4RegCas.pImpRicPerScontrino > gtParam4RegCas.pImpTotale Then
            vStrImpRicevuto = Format(gtParam4RegCas.pImpRicPerScontrino, "#########.#0")
            vStrImpRicevuto = Replace(vStrImpRicevuto, ",", "")
         Else
            vStrImpRicevuto = "0"
         End If
         
         'Stampo la riga con il totale dei Punti Fedelet accumulati
         If gtParam4RegCas.pPuntiFid > 0 Then
            vStrRiga = "*PUNTI FIDELITY: " & Trim(Str(gtParam4RegCas.pPuntiFid)) & "*"
            Print #NumFile, "171" & Mid(vStrRiga, 1, 27) & "1"
         End If
         
         'RIGA DI CHIUSURA SCONTRINO
         Print #NumFile, "21" & vStrImpRicevuto & "0"
         
         'Chiudo il file di LOG
         Close #NumFile
         
         Call GestFileScontrino("temp.txt")
         
      End With

   Else
   
      'Qui se trattasi di RISTAMPA di ULTIMO SCONTRINO lo copio direttamente dalla cartella di storico _
       nella cartella di destinazione senza passare dall sub GestFileScontrino ( inutile)
      FileCopy PathREGCAS & "\Storico\" & gtParam4RegCas.pRistScontrino, mPathDestScontrino & "temp.txt"
      
   End If

End Sub

Private Function Scontrino_OLIVETTI_NETTUNA() As Boolean
   Dim NumFile As Integer 'per aprire il file di esecuzioni(LOG)
   Dim vStrRiga As String
   Dim i As Integer
   Dim vStrImpRicevuto As String
   'Dim vPathScontrino As String
   Dim vPathEsito As String
   Dim vApriCassetto As String
   Dim pVal As String
   
   mTotImpArt = 0
   'Qui prendo il PATH dove creare il file dello scontrino da stampare
   
   Scontrino_OLIVETTI_NETTUNA = False
   
   mPathDestScontrino = ReadINI("ELAEXECUTE", "PATH_IN", mPathFileConf4Scontrino)
   'Controllo che sia pieno
   If Len(Trim(mPathDestScontrino)) = 0 Then
      MsgBox "ATTENZIONE!" & vbNewLine & _
             "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
             "(Tag [ELAEXECUTE] Parametro <PATH_IN> non presente)" & vbNewLine & vbNewLine & _
             "Impossibile eseguire la stampa dello Scontrino.", vbCritical
      Exit Function
   End If
   
   vPathEsito = ReadINI("ELAEXECUTE", "PATH_OUT", mPathFileConf4Scontrino)
   'Controllo che sia pieno
   If Len(Trim(vPathEsito)) = 0 Then
      MsgBox "ATTENZIONE!" & vbNewLine & _
             "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
             "(Tag [ELAEXECUTE] Parametro <PATH_OUT> non presente)" & vbNewLine & vbNewLine & _
             "Impossibile eseguire la stampa dello Scontrino.", vbCritical
      Exit Function
   End If
   
   
   vApriCassetto = ReadINI("ELAEXECUTE", "APRI_CASSETTO", mPathFileConf4Scontrino)
   If IsNumeric(vApriCassetto) = False Then
      vApriCassetto = "0"
   End If
   
   
''Elimino eventuali file vecchi
'   Kill mPathDestScontrino & "scontrino.txt"
'   Kill vPathEsito & "scontrino.txt"
   
      
   'controllo che non sia una ristampa ...
   If Len(gtParam4RegCas.pRistScontrino) = 0 Then
      
      '...altrimenti QUI INIZIO A COMPORRE LO SCONTRINO
      NumFile = FreeFile
      Open App.path & "\temp.txt" For Append As #NumFile      'CREO IL FILE
   
      Print #NumFile, "1322"  'APERTURA SCONTRINO
   
         With mpGridScontrino
         
            For i = 0 To .Rows.Count - 1
               
               'Creo il totale documento senza considerare lo sconto sul documento
               mTotImpArt = mTotImpArt + CCur(.Rows(i).Record.Item(gtParam4RegCas.pColImpNet).Value)
               
               
               'Controllo se si tratta di un RESO o di un articolo normale di vendita
               'If .CellBackColor = Colore("rosso1") Then
               'If .Rows(i).Record.Item(gtParam4RegCas.pColSimbol) = "R" Then
               '   vStrRiga = RowScontrOLIVETTI_NETTUNA(i, "RESO") 'Compongo la stringa di RESO
               'Else
                  vStrRiga = RowScontrOLIVETTI_NETTUNA(i, "STD")  'Compongo la stringa STANDARD
               'End If
               Print #NumFile, vStrRiga                  'Stampo la stringa nel File
               
               
               'Qui controllo se c' lo Sconto riga sull'Articolo
               If .Rows(i).Record.Item(gtParam4RegCas.pColScont1).Value > 0 Then
                  vStrRiga = RowScontrOLIVETTI_NETTUNA(i, "SCN_RIG")   'Compongo la stringa SCONTO RIGA
                  Print #NumFile, vStrRiga                        'Stampo la stringa nel File
               End If
               
            Next i
            
            
            'Qui controllo se c' SCONTO sul Documento
            If gtParam4RegCas.pScontoDoc > 0 Then
               'Prima dello sconto sul documento devo eseguire il Subtotale
               Print #NumFile, "1332"  'SUBTOTALE
               
               If gtParam4RegCas.pScontoPercent = True Then 'Controllo se  in PERCENTUALE...
                  vStrRiga = RowScontrOLIVETTI_NETTUNA(-1, "SCN_DOC_PER")   'Compongo la stringa SCONTO RIGA
                  Print #NumFile, vStrRiga                            'Stampo la stringa nel File
               Else                          '...oppure se  a VALORE
                  vStrRiga = RowScontrOLIVETTI_NETTUNA(-1, "SCN_DOC_DOC")   'Compongo la stringa SCONTO RIGA
                  Print #NumFile, vStrRiga                        'Stampo la stringa nel File
               End If
            End If
            
                  
            'CONTROLLO SE DEVO INDICARE IL RESTO SULLO SCONTRINO
            If gtParam4RegCas.pImpRicPerScontrino > gtParam4RegCas.pImpTotale Then
               vStrImpRicevuto = Format(gtParam4RegCas.pImpRicPerScontrino, "########0.#0")
               vStrImpRicevuto = Replace(vStrImpRicevuto, ".", ",")
               Print #NumFile, "1329;" & vStrImpRicevuto
            Else
               Print #NumFile, "1329"
            End If
                        
                        
            'Stampa del Codice Fiscale (MA NON L'HO POTUTO TESTARE PER MANCANZA DI APPARECCHIATURE!!!) _
              Pertanto se mi viene segnalato che NON funziona mi basta creare nel ParGen il Tag [SCONTRINI] _
              con parametro NO_CODFIS=T in modo da non far stampare il Codice Fiscale ed eliminare l'eventuale anomalia
               'pVal = ReadINI("SCONTRINI", "NO_CODFIS", IniPath)
               'If Not (pVal = "T") Then
                  If Len(gtParam4RegCas.pCodFisc) > 0 Then
                     Print #NumFile, "112;;0;1;1" 'Riga senza testo per dare spazio
                        vStrRiga = "C.F.: " & gtParam4RegCas.pCodFisc & ""
                        Print #NumFile, "112;" & vStrRiga & ";0;1;1"
                     Print #NumFile, "112;;0;1;1" 'Riga senza testo per dare spazio
                  End If
               'End If
            
            'Stampo la riga con il totale dei Punti Fedelet accumulati
               If gtParam4RegCas.pPuntiFid > 0 Then
                  Print #NumFile, "112;;0;1;1" 'Riga senza testo per dare spazio
                     vStrRiga = "*PUNTI FIDELITY: " & Trim(Str(gtParam4RegCas.pPuntiFid)) & "*"
                     Print #NumFile, "112;" & vStrRiga & ";0;1;1"
                  Print #NumFile, "112;;0;1;1" 'Riga senza testo per dare spazio
               End If
         
         End With
         
         'RIGA DI CHIUSURA SCONTRINO
         Print #NumFile, "1323"
         
         'Qui controllo se devo aprire il cassetto
         If CInt(vApriCassetto) > 0 Then
            Print #NumFile, "912;" & vApriCassetto
         End If
         
         'Chiudo il file di LOG
         Close #NumFile
         
      Call GestFileScontrino("scontrino.txt")
      
   Else
   
      'Qui se trattasi di RISTAMPA di ULTIMO SCONTRINO lo copio direttamente dalla cartella di storico _
       nella cartella di destinazione senza passare dall sub GestFileScontrino ( inutile)
      FileCopy PathREGCAS & "\Storico\" & gtParam4RegCas.pRistScontrino, mPathDestScontrino & "scontrino.txt"
   
   End If
      
      
'SE ARRIVA QUI ALLORA E' ANDATO TUTTO A BUON FINE _
   ULTIMO CONTROLLO E' SUL FILE DI ESITO
   Scontrino_OLIVETTI_NETTUNA = VerificaEsito_OLIVETTI_NETTUNA(vPathEsito)
      
   

End Function

Private Sub Scontrino_FASY()
   Dim NumFile As Integer 'per aprire il file di esecuzioni(LOG)
   Dim vStrRiga As String
   Dim i As Integer
   Dim vStrImpRicevuto As String
   Dim vVal As String
   Dim vApriCassetto As String
   
   'Dim vPathScontrino As String
   'Qui prendo il PATH dove creare il file dello scontrino da stampare
   
      
   mPathDestScontrino = ReadINI("FSEDRIVERS", "PATH", mPathFileConf4Scontrino)
   'Controllo che sia pieno
   If Len(Trim(mPathDestScontrino)) = 0 Then
      MsgBox "ATTENZIONE!" & vbNewLine & _
             "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
             "(Tag [FSEDRIVERS] Parametro <PATH> non presente)" & vbNewLine & vbNewLine & _
             "Impossibile eseguire la stampa dello Scontrino.", vbCritical
      Exit Sub
   End If
   
   vApriCassetto = ReadINI("FSEDRIVERS", "APRI_CASSETTO", mPathFileConf4Scontrino)
   If IsNumeric(vApriCassetto) = False Then
      vApriCassetto = "0"
   End If
   
   mLenDescri = ReadINI("FSEDRIVERS", "LEN_DESCR", mPathFileConf4Scontrino)
   If IsNumeric(mLenDescri) = False Then
      mLenDescri = "42"
   End If
   
   
   'verifico che non si tratti di una ristampa...
   If Len(gtParam4RegCas.pRistScontrino) = 0 Then
      
      '...altrimenti QUI INIZIO A COMPORRE LO SCONTRINO
      NumFile = FreeFile
      Open App.path & "\temp.txt" For Append As #NumFile      'CREO IL FILE
   
      With mpGridScontrino
         
         Print #NumFile, "0 0 0 "   'Apertura Scontrino
         
         For i = 0 To .Rows.Count - 1
            
            'Qui verifico se c'e' l'associazione del Codice IVA con il Reparti del Registratore di Cassa
            vVal = ReadINI("REPARTIIVA_REPARTI", .Rows(i).Record.Item(gtParam4RegCas.pColRepIVA).Value, mPathFileConf4Scontrino)
            If Len(Trim(vVal)) > 0 Then vVal = Replace(UCase(vVal), "REPARTO", "")
            If IsNumeric(vVal) = False Then vVal = "1"
            
            
            'Controllo se si tratta di un RESO o di un articolo normale di vendita
               'NB:PER LO SCARICAO DEL PREPAGATO HO DOVUTO USARE LA FUNZIONE "RESO" (CODICE 3) PERCH LA FUNZIONE "STORNO" (CODICE 2) _
                   NON SONO RIUSCITO A FARLA FUNZIONARE IN NESSUN MODO!!! PER IL MOMENTO  MEGLIO LA DICITURA ERRATA CHE IL TOTALE!!!
            If .Rows(i).Record.Item(gtParam4RegCas.pColSimbol).Value = "R" Or .Rows(i).Record.Item(gtParam4RegCas.pColSimbol).Value = "#" Then
               vStrRiga = RowScontrFASY(i, "RESO", vVal) 'Compongo la stringa di RESO
            Else
               vStrRiga = RowScontrFASY(i, "STD", vVal) 'Compongo la stringa STANDARD
            End If
            Print #NumFile, vStrRiga                  'Stampo la stringa nel File
            
            
            'Qui controllo se c' lo Sconto riga sull'Articolo
            If .Rows(i).Record.Item(gtParam4RegCas.pColScont1).Value > 0 Then
               vStrRiga = RowScontrFASY(i, "SCN_RIG", vVal)  'Compongo la stringa SCONTO RIGA
               Print #NumFile, vStrRiga                        'Stampo la stringa nel File
            End If
            
         Next i
         
         
         'Qui controllo se c' SCONTO sul Documento
         If gtParam4RegCas.pScontoDoc > 0 Then
            If gtParam4RegCas.pScontoPercent = True Then 'Controllo se  in PERCENTUALE...
               vStrRiga = RowScontrFASY(0, "SCN_DOC_PER")   'Compongo la stringa SCONTO RIGA
               Print #NumFile, vStrRiga                            'Stampo la stringa nel File
            Else                          '...oppure se  a VALORE
               vStrRiga = RowScontrFASY(0, "SCN_DOC_DOC")   'Compongo la stringa SCONTO RIGA
               Print #NumFile, vStrRiga                        'Stampo la stringa nel File
            End If
         End If
         
               
         'CONTROLLO SE DEVO INDICARE IL RESTO SULLO SCONTRINO
         If gtParam4RegCas.pImpRicPerScontrino > gtParam4RegCas.pImpTotale Then
            vStrImpRicevuto = Format(gtParam4RegCas.pImpRicPerScontrino, "#########.#0")
            vStrImpRicevuto = Replace(vStrImpRicevuto, ",", ".")
         Else
            vStrImpRicevuto = ""
         End If
         
         
         'Stampa del Codice Fiscale (TESTATO = OK!)
            If Len(gtParam4RegCas.pCodFisc) > 0 Then
               Print #NumFile, "5 0 " & String(CInt(mLenDescri), "-")
               
               vStrRiga = "C.F.: " & gtParam4RegCas.pCodFisc & ""
               Print #NumFile, "5 0 " & vStrRiga
            End If
         
         'Stampo la riga con il totale dei Punti Fedelet accumulati
            If gtParam4RegCas.pPuntiFid > 0 Then
               Print #NumFile, "5 0 " & String(CInt(mLenDescri), "-")
               
               vStrRiga = "PUNTI FIDELITY: " & Trim(Str(gtParam4RegCas.pPuntiFid)) & ""
               Print #NumFile, "5 0 " & vStrRiga
            End If
         
         
         'RIGA DI CHIUSURA SCONTRINO
         Print #NumFile, "6 " & vStrImpRicevuto & Space(10 - Len(vStrImpRicevuto)) & Space(36) & "0  0 "
         
         If vApriCassetto = "1" Then
            Print #NumFile, "13"   'Apertura Cassetto
         End If
         
         'Chiudo il file di LOG
         Close #NumFile
         
         Call GestFileScontrino("temp.txt")
         
      End With

   Else
   
      'Qui se trattasi di RISTAMPA di ULTIMO SCONTRINO lo copio direttamente dalla cartella di storico _
       nella cartella di destinazione senza passare dall sub GestFileScontrino ( inutile)
      FileCopy PathREGCAS & "\Storico\" & gtParam4RegCas.pRistScontrino, mPathDestScontrino & "temp.txt"
      
   End If

End Sub


Private Function VerificaEsito_OLIVETTI_NETTUNA(pPathEsito As String) As Boolean
   'Dim Log As String
   'Dim vConta As Integer
   
   On Error Resume Next
   'vConta = 0
   
   VerificaEsito_OLIVETTI_NETTUNA = True
   
   On Error GoTo 0
   
   'PER IL MOMENTO HO SOSPESO I CONTROLLI INERENTI ALL'ESITO DELLO SCONTRINO _
    PERCH RICHIEDE UNA ANALISI PI APPROFONDITA. =================================================
   
'''   Call PausaProgramma(0.2, True)
'''
'''ripeti:
'''
'''Open pPathEsito & "scontrino.txt" For Input As #1
'''      Do While Not EOF(1)
'''         vConta = vConta + 1
'''
'''         If vConta = 10 Then GoTo ripeti
'''         If vConta > 20 Then Exit Do
'''
'''         Input #1, Log
'''
'''         If UCase(Mid(Log, 1, 5)) = "ESITO" Then
'''            'Se non lo trovo segnalo l'ERRORE
'''            If InStr(6, Log, "OK") = 0 Then
'''               VerificaEsito_OLIVETTI_NETTUNA = False
'''               MsgBox "ATTENZIONE!" & vbNewLine & _
'''                      "Il Registratore ha segnalato un'anomalia in fase di emissione dello Scontrino.", vbCritical
'''            End If
'''            Close #1
'''
'''            Exit Do
'''         End If
'''      Loop
'''   Close #1
'''
'''   Kill pPathEsito & "scontrino.txt"
   
End Function


Private Function RowScontrDATAPROCESS(pRiga As Integer, pTipo As String, Optional pReparto As String) As String
   Dim vStrValScontoDoc As String
   Dim vDescr As String
   
   'Compone la riga dello scontrino per DATAPROCESS

   With mpGridScontrino
      
      Select Case pTipo
         Case "STD" 'riga STANDARD
            vDescr = .Rows(pRiga).Record.Item(gtParam4RegCas.pColCodArt + 1).Value
            vDescr = PulisciDescrizioneScontrino(vDescr)
            If Len(vDescr) < 20 Then vDescr = vDescr & Space(20 - Len(vDescr))
            RowScontrDATAPROCESS = "1" & vDescr & "" ' Descrizione
            
            'Quantit
            vDescr = Format(.Rows(pRiga).Record.Item(gtParam4RegCas.pColQuanti).Value, "########0.#00") 'Quantit a 3 decimali
            vDescr = Replace(Replace(vDescr, ",", ""), ".", "") 'tolgo eventuali punti e virgole
            RowScontrDATAPROCESS = RowScontrDATAPROCESS & vDescr & "" 'Quantita
            
            'Prezzo
            vDescr = Format(.Rows(pRiga).Record.Item(gtParam4RegCas.pColPrezzo).Value, "########0.#0") 'Prezzo a 2 decimali
            vDescr = Replace(Replace(vDescr, ",", ""), ".", "") 'tolgo eventuali punti e virgole
            RowScontrDATAPROCESS = RowScontrDATAPROCESS & vDescr & "" 'Prezzo
            
            'Reparto
            RowScontrDATAPROCESS = RowScontrDATAPROCESS & pReparto & "11"  'Reparto e chiusura
         
         Case "RESO" 'riga RESO
            vDescr = .Rows(pRiga).Record.Item(gtParam4RegCas.pColCodArt + 1).Value
            vDescr = PulisciDescrizioneScontrino(vDescr)
            If Len(vDescr) < 20 Then vDescr = vDescr & Space(20 - Len(vDescr))
            RowScontrDATAPROCESS = "9" & vDescr & "" ' Descrizione
            
            'Prezzo
            vDescr = Format(.Rows(pRiga).Record.Item(gtParam4RegCas.pColPrezzo).Value, "########0.#0") 'Prezzo a 2 decimali
            vDescr = Replace(Replace(Replace(vDescr, ",", ""), ".", ""), "-", "") 'tolgo eventuali punti e virgole e il segno "-"
            RowScontrDATAPROCESS = RowScontrDATAPROCESS & vDescr & "" 'Prezzo

            'Reparto
            RowScontrDATAPROCESS = RowScontrDATAPROCESS & pReparto & "1"  'Reparto
            
            'Quantit
            vDescr = Format(.Rows(pRiga).Record.Item(gtParam4RegCas.pColQuanti).Value, "########0.#00") 'Quantit a 3 decimali
            vDescr = Replace(Replace(vDescr, ",", ""), ".", "") 'tolgo eventuali punti e virgole
            RowScontrDATAPROCESS = RowScontrDATAPROCESS & vDescr & "" 'Quantita
         
         Case "SCN_RIG" 'riga SCONTO RIGA %
            If .Rows(pRiga).Record.Item(gtParam4RegCas.pColScont1).Value = 100 Then 'OMAGGIO
               RowScontrDATAPROCESS = "3" ' Funzione ARTICOLO STORNO
               vDescr = " O M A G G I O "
               RowScontrDATAPROCESS = RowScontrDATAPROCESS & vDescr & "" 'Descrizione
               'Prezzo
               vDescr = Format(.Rows(pRiga).Record.Item(gtParam4RegCas.pColPrezzo).Value, "########0.#0") 'Prezzo a 2 decimali
               vDescr = Replace(Replace(vDescr, ",", ""), ".", "") 'tolgo eventuali punti e virgole
               RowScontrDATAPROCESS = RowScontrDATAPROCESS & vDescr & "" 'Prezzo
               'Reparto
               RowScontrDATAPROCESS = RowScontrDATAPROCESS & pReparto & "1"  'Reparto
               'Quantit
               vDescr = Format(.Rows(pRiga).Record.Item(gtParam4RegCas.pColQuanti).Value, "########0.#00") 'Quantit a 3 decimali
               vDescr = Replace(Replace(vDescr, ",", ""), ".", "") 'tolgo eventuali punti e virgole
               RowScontrDATAPROCESS = RowScontrDATAPROCESS & vDescr & "" 'Quantita
         
'               RowScontrDATAPROCESS = "111" & vDescr & "" ' Funzione
'               'Prezzo
'               vDescr = Format(.Rows(pRiga).Record.Item(gtParam4RegCas.pColPrezzo).Value, "########0.#0") 'Prezzo a 2 decimali
'               vDescr = Replace(Replace(vDescr, ",", ""), ".", "") 'tolgo eventuali punti e virgole
'               RowScontrDATAPROCESS = RowScontrDATAPROCESS & vDescr & "" 'Prezzo
'               'Descrizione
'               vDescr = " O M A G G I O "
'               RowScontrDATAPROCESS = RowScontrDATAPROCESS & vDescr & "" 'Descrizione
'               RowScontrDATAPROCESS = RowScontrDATAPROCESS & "1-1"  'chiusura
            Else                                'SCONTO NORMALE < DI 100%
               RowScontrDATAPROCESS = "131" ' Valori fissi Riga
               'Sconto NORMALE
               vDescr = Format(.Rows(pRiga).Record.Item(gtParam4RegCas.pColScont1).Value, "########0.#0") 'Sconto a 2 decimali
               vDescr = Replace(Replace(vDescr, ",", ""), ".", "") 'tolgo eventuali punti e virgole
               RowScontrDATAPROCESS = RowScontrDATAPROCESS & vDescr  'Sconto 1
               RowScontrDATAPROCESS = RowScontrDATAPROCESS & "-1"  'Valori fissi di Chiusura Riga
            End If
         
         Case "SCN_DOC_PER" 'riga SCONTO DOCUMENTO IN PERCENTUALE
            vStrValScontoDoc = Format(gtParam4RegCas.pScontoDoc, "#########.#0")
            RowScontrDATAPROCESS = "631" ' Valori fissi Riga
            RowScontrDATAPROCESS = RowScontrDATAPROCESS & Replace(vStrValScontoDoc, ",", "")  'valore Sconto
            RowScontrDATAPROCESS = RowScontrDATAPROCESS & ""  'Valori fissi di Chiusura Riga
         
         Case "SCN_DOC_DOC" 'riga SCONTO DOCUMENTO A VALORE
            vStrValScontoDoc = Format(gtParam4RegCas.pScontoDoc, "#########.#0")
            RowScontrDATAPROCESS = "711" ' Valori fissi Riga
            RowScontrDATAPROCESS = RowScontrDATAPROCESS & Replace(vStrValScontoDoc, ",", "")  'valore Sconto
            RowScontrDATAPROCESS = RowScontrDATAPROCESS & ""  'Valori fissi di Chiusura Riga
         
      End Select
      
   End With
   
End Function

Private Function RowScontrFASY(pRiga As Integer, pTipo As String, Optional pReparto As String) As String
   Dim vStrValScontoDoc As String
   Dim vDescr As String
   Dim vVal As String
   
   'Compone la riga dello scontrino per FASY
   With mpGridScontrino
      
      Select Case pTipo
         Case "STD" 'riga STANDARD
            'Tipo Record
               RowScontrFASY = "1 "
               RowScontrFASY = RowScontrFASY & Space(25) 'PLU facoltativo
            'Prezzo
               vDescr = Format(.Rows(pRiga).Record.Item(gtParam4RegCas.pColPrezzo).Value, "########0.#0") 'Prezzo a 2 decimali
               vDescr = Replace(vDescr, ",", ".") 'imposto il punto decimale (non virgola)
               RowScontrFASY = RowScontrFASY & vDescr & Space(10 - Len(vDescr)) 'Prezzo
            'Reparto
               RowScontrFASY = RowScontrFASY & pReparto & Space(3 - Len(pReparto)) 'Raparto
            'Descrizione
               vDescr = Mid(.Rows(pRiga).Record.Item(gtParam4RegCas.pColCodArt + 1).Value, 1, CByte(mLenDescri))
               vDescr = PulisciDescrizioneScontrino(vDescr, True)
               If Len(vDescr) < CByte(mLenDescri) Then vDescr = vDescr & Space(CLng(mLenDescri - Len(vDescr)))
               RowScontrFASY = RowScontrFASY & vDescr 'Descrizione
            'Quantit
               vDescr = Format(.Rows(pRiga).Record.Item(gtParam4RegCas.pColQuanti).Value, "########0.#00") 'Quantit a 3 decimali
               vDescr = Replace(vDescr, ",", ".") 'imposto il punto decimale (non virgola)
               RowScontrFASY = RowScontrFASY & vDescr & Space(10 - Len(vDescr)) 'Quantita
         
         Case "RESO" 'riga RESO
            'Tipo Record
               RowScontrFASY = "3 "
               RowScontrFASY = RowScontrFASY & Space(25) 'PLU facoltativo
            'Prezzo
               vDescr = Format(.Rows(pRiga).Record.Item(gtParam4RegCas.pColPrezzo).Value, "########0.#0") 'Prezzo a 2 decimali
               vDescr = Replace(Replace(vDescr, ",", "."), "-", "") 'imposto il punto decimale (non virgola)
               RowScontrFASY = RowScontrFASY & vDescr & Space(10 - Len(vDescr)) 'Prezzo
            'Reparto
               RowScontrFASY = RowScontrFASY & pReparto & Space(3 - Len(pReparto)) 'Raparto
            'Descrizione
               vDescr = Mid(.Rows(pRiga).Record.Item(gtParam4RegCas.pColCodArt + 1).Value, 1, CByte(mLenDescri))
               vDescr = PulisciDescrizioneScontrino(vDescr, True)
               If Len(vDescr) < CByte(mLenDescri) Then vDescr = vDescr & Space(CLng(mLenDescri - Len(vDescr)))
               RowScontrFASY = RowScontrFASY & vDescr 'Descrizione
            'Quantit
               vDescr = Format(.Rows(pRiga).Record.Item(gtParam4RegCas.pColQuanti).Value, "########0.#00") 'Quantit a 3 decimali
               vDescr = Replace(vDescr, ",", ".") 'imposto il punto decimale (non virgola)
               RowScontrFASY = RowScontrFASY & vDescr & Space(10 - Len(vDescr)) 'Quantita
         
         Case "SCN_RIG" 'riga SCONTO RIGA %
            'Tipo Record
               RowScontrFASY = "4 "
            'Descrizione
               If .Rows(pRiga).Record.Item(gtParam4RegCas.pColScont1).Value = 100 Then 'OMAGGIO
                  vDescr = "  OMAGGIO"
               Else
                  vDescr = "  SCONTO"
               End If
               If Len(vDescr) < CByte(mLenDescri) Then vDescr = vDescr & Space(CLng(mLenDescri - Len(vDescr)))
               RowScontrFASY = RowScontrFASY & vDescr 'Descrizione
            'Sconto sulla Riga
               RowScontrFASY = RowScontrFASY & "0  0  " 'Sconto % sulla Riga
            'Valore di Sconto
               vDescr = Format(.Rows(pRiga).Record.Item(gtParam4RegCas.pColScont1).Value, "########0.#0") 'Quantit a 3 decimali
               vDescr = Replace(vDescr, ",", ".") 'imposto il punto decimale (non virgola)
               RowScontrFASY = RowScontrFASY & vDescr & Space(10 - Len(vDescr)) 'Quantita
         
         Case "SCN_DOC_PER" 'riga SCONTO DOCUMENTO IN PERCENTUALE
            'Questo parametro serve per qui modelli che gestiscono SOLO 3 funzioni di sconti/maggiorazioni _
             a cui in Cassa devo passare un paraemtro diverso rispetto ai modelli cheb gestiscono 6 funzioni. _
             Vedi documentazione "REGOLE_SCONTRINOTXT(R.010012).doc"
            vVal = ReadINI("PARAMETRI", "REG_3_FUN", mPathFileConf4Scontrino)
            If Not IsNumeric(vVal) Then vVal = "0"
         
            'Tipo Record
               RowScontrFASY = "4 "
            'Descrizione
               vDescr = "SCONTO"
               If Len(vDescr) < CByte(mLenDescri) Then vDescr = vDescr & Space(CLng(mLenDescri - Len(vDescr)))
               RowScontrFASY = RowScontrFASY & vDescr 'Descrizione
            'Sconto sulla Riga
               RowScontrFASY = RowScontrFASY & "1  " 'Sconto % Sul Subtotale
               RowScontrFASY = RowScontrFASY & IIf(vVal = 0, "1", "0") & "  " 'Il codice cambia per i modelli che gestiscono solo 3 funzioni di sconto
            'Valore di Sconto
               vStrValScontoDoc = Format(gtParam4RegCas.pScontoDoc, "#########.#0")
               vDescr = Replace(vStrValScontoDoc, ",", ".") 'imposto il punto decimale (non virgola)
               RowScontrFASY = RowScontrFASY & vDescr & Space(10 - Len(vDescr)) 'Quantita
         
         Case "SCN_DOC_DOC" 'riga SCONTO DOCUMENTO A VALORE
            'Questo parametro serve per qui modelli che gestiscono SOLO 3 funzioni di sconti/maggiorazioni _
             a cui in Cassa devo passare un paraemtro diverso rispetto ai modelli cheb gestiscono 6 funzioni. _
             Vedi documentazione "REGOLE_SCONTRINOTXT(R.010012).doc"
            vVal = ReadINI("PARAMETRI", "REG_3_FUN", mPathFileConf4Scontrino)
            If Not IsNumeric(vVal) Then vVal = "0"
            
            'Tipo Record
               RowScontrFASY = "4 "
            'Descrizione
               vDescr = "SCONTO"
               If Len(vDescr) < CByte(mLenDescri) Then vDescr = vDescr & Space(CLng(mLenDescri - Len(vDescr)))
               RowScontrFASY = RowScontrFASY & vDescr 'Descrizione
            'Sconto sulla Riga
               RowScontrFASY = RowScontrFASY & "1  " 'Sconto a Valore sul Subtotale
               RowScontrFASY = RowScontrFASY & IIf(vVal = 0, "3", "2") & "  " 'Il codice cambia per i modelli che gestiscono solo 3 funzioni di sconto
            'Valore di Sconto
               vStrValScontoDoc = Format(gtParam4RegCas.pScontoDoc, "#########.#0")
               vDescr = Replace(vStrValScontoDoc, ",", ".") 'imposto il punto decimale (non virgola)
               RowScontrFASY = RowScontrFASY & vDescr & Space(10 - Len(vDescr)) 'Quantita
         
      End Select
      
   End With
   
End Function


Private Function Scontrino_EPSON(pCausalDoc As String, pSerial As Long) As Boolean
   Dim NumFile As Integer 'per aprire il file di esecuzioni(LOG)
   Dim vStrRiga As String
   Dim vTempFile As String
   Dim vPrintFile As String
   
   Dim i As Integer
   Dim vStrImpRicevuto As String
   'Dim vTotCalcolato As Currency
   'Dim vPathEsito As String
   Dim vApriCassetto As String
   Dim vVal As String
   Dim vRetValEsito As Boolean
   Dim vSyncroON As Boolean
   
   
   mTotImpArt = 0
   'Qui prendo il PATH dove creare il file dello scontrino da stampare
   
   Scontrino_EPSON = False
   
   mPathDestScontrino = ReadINI("PARAMETRI", "PATH_IN", mPathFileConf4Scontrino)
   gtLastScontrino.PathOut = ReadINI("PARAMETRI", "PATH_OUT", mPathFileConf4Scontrino)
   
   
   Call MsgRegCasInLogFile("[Scontrino_EPSON] - Path_IN '" & mPathDestScontrino & "'")
   Call MsgRegCasInLogFile("[Scontrino_EPSON] - Path_OUT '" & gtLastScontrino.PathOut & "'")
   
   
   'Controllo che sia pieno
   If Len(Trim(mPathDestScontrino)) = 0 Then
      MsgBox "ATTENZIONE!" & vbNewLine & _
             "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
             "(Tag [PARAMETRI] Parametro <PATH_IN> non presente)" & vbNewLine & vbNewLine & _
             "Impossibile eseguire la stampa dello Scontrino.", vbCritical
      Exit Function
   End If
   
   gtLastScontrino.PathOut = ReadINI("PARAMETRI", "PATH_OUT", mPathFileConf4Scontrino)
   'Controllo che sia pieno
   If Len(Trim(gtLastScontrino.PathOut)) = 0 Then
      MsgBox "ATTENZIONE!" & vbNewLine & _
             "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
             "(Tag [PARAMETRI] Parametro <PATH_OUT> non presente)" & vbNewLine & vbNewLine & _
             "Impossibile eseguire la stampa dello Scontrino.", vbCritical
      Exit Function
   End If
   
   vApriCassetto = ReadINI("PARAMETRI", "APRI_CASSETTO", mPathFileConf4Scontrino)
   If IsNumeric(vApriCassetto) = False Then
      vApriCassetto = "0"
   End If

   
   vSyncroON = (ReadINI("PARAMETRI", "SYNCRO_ON", mPathFileConf4Scontrino) = "1")
   
   
   'controllo che non sia una ristampa ...
   If Len(gtParam4RegCas.pRistScontrino) = 0 Then
      
      'Setto i nomi dei file che andr a creare
         vTempFile = EpsonSetNamePrintFile("tmpEpson")
         vPrintFile = EpsonSetNamePrintFile("scontrino")
      
      
         'INIZIO FILE DOCUMENTO  ===============================================================
               If pCausalDoc = "CO" Then 'SCONTRINO
                  If gtParam4RegCas.pModalitaRT Then
                     If Not EpsonSetFileScontrino_RT(vTempFile) Then
                        Exit Function
                     End If
                  Else
                     If Not EpsonSetFileScontrino_MF Then
                        Exit Function
                     End If
                  End If
               ElseIf pCausalDoc = "FA" Then 'FATTURA
                  If Not EpsonSetFileFattura(pSerial) Then
                     Exit Function
                  End If
               'ElseIf pCausalDoc = "NC" Then 'NOTA DI CREDITO
               '   If StampaNotaCreditoCUSTOM(pSerial, _
               '                                vTipConn, vApriCas, vIndirIP, vNumPort, vBaudRat, _
               '                                vBitDati, vParita, vBitStop, vFlusso, vNomeStampante) = False Then
               '      Exit Function
               '   End If
               End If
         'FINE FILE DOCUMENTO  ===============================================================
                                 
         
         'Copio il file scontrino nella cartella di IN (SOLO PER RT)
            If gtParam4RegCas.pModalitaRT Then
               Call GestFileScontrino("", vTempFile, vPrintFile, vSyncroON)
               'Setto il nome nel Type preposto per i dati dello scontrino
                  gtLastScontrino.FilePrint = vPrintFile
            End If
      
         

   Else
      
      'Setto i nomi dei file che andr a creare
         vPrintFile = gtParam4RegCas.pRistScontrino
   
      'Qui se trattasi di RISTAMPA di ULTIMO SCONTRINO lo copio direttamente dalla cartella di storico _
       nella cartella di destinazione senza passare dalla sub GestFileScontrino ( inutile)
         If Len(Trim(gtLastScontrino.FilePrint)) > 0 Then
            FileCopy PathREGCAS & "\Storico\" & gtParam4RegCas.pRistScontrino, mPathDestScontrino & vPrintFile
         Else
            FileCopy PathREGCAS & "\Storico\" & gtParam4RegCas.pRistScontrino, mPathDestScontrino & "scontrino.txt"
         End If
   
   End If
      

'ESITO FINALE - - - - - - - - - -
   'Verifico se devo attendere la risposta
      If ReadINI("PARAMETRI", "WAIT_OUT_REG", mPathFileConf4Scontrino) = "1" Then
         Dim vSeconds As String
         vSeconds = ReadINI("PARAMETRI", "TIMEOUT_WAIT", mPathFileConf4Scontrino)
         vRetValEsito = (EpsonReadOut(gtLastScontrino.PathOut & vPrintFile, True, vSeconds) = 1)
      Else
         'SE ARRIVA QUI ALLORA E' ANDATO TUTTO A BUON FINE ULTIMO CONTROLLO E' SUL FILE DI ESITO
            vRetValEsito = True
      End If
      
      Scontrino_EPSON = vRetValEsito
      
      Call MsgRegCasInLogFile("[Scontrino_EPSON] - Esito ReadOut: '" & vRetValEsito & "'")
      
      
      'Salvo il tentativo nella tabella delle INFO con qualsiasi esito in modo da creare la storia della stampa del documento
      Call MsgRegCasInLogFile("[Scontrino_EPSON] - Insert_DOC_INFO_RT")
         Call Insert_DOC_INFO_RT
      
      ''Invio nil comando di reset (light) in modo da sboccare eventuali errori
         'If Not Scontrino_EPSON Then Call EpsonResetPrinter
         
         
   '************* 2019.11.25 GESTIONE VOUCHER
      If pCausalDoc = "CO" And gtParam4RegCas.pModalitaRT And vRetValEsito Then  'Corrispettivi 'SCONTRINO 'STAMPA SCONTRINO = OK
         If Len(gtParam4RegCas.pVoucherID) > 0 Then
            vTempFile = EpsonSetNamePrintFile("tmpEpson")
            vPrintFile = EpsonSetNamePrintFile("scontrino")
            If StampaVoucher_EPSON_RT(vTempFile, (ReadINI("OPZIONI", "NO_PREZZO_VOUCHER", mPathFileConf4Scontrino) <> "1")) Then
               'Copio il file scontrino nella cartella di IN (SOLO PER RT)
                  Call GestFileScontrino("", vTempFile, vPrintFile, vSyncroON)
            Else
               Exit Function
            End If
         End If
               
      End If
   
   '************* 2019.11.25 GESTIONE VOUCHER
                     
End Function

Private Function EpsonSetFileScontrino_RT(vTempFile As String) As Boolean
   Dim NumFile As Integer 'per aprire il file di esecuzioni(LOG)
   Dim vStrRiga As String
   'Dim vTempFile As String
   'Dim vPrintFile As String
   Dim vTotCalcolato As Currency
   Dim i As Integer
   Dim vVal As String
   Dim vArr() As String
   Dim Y As Byte
   Dim vPos As Byte
   Dim vPrgRowMsg As Byte
   
   On Error GoTo GestErr
      
      
    '...altrimenti QUI INIZIO A COMPORRE LO SCONTRINO
      Call MsgRegCasInLogFile("[EpsonSetFileScontrino_RT] - OpenFile '" & App.path & "\" & vTempFile & "'")
    
      NumFile = FreeFile
      Open App.path & "\" & vTempFile For Append As #NumFile      'CREO IL FILE
      
      Print #NumFile, "printerFiscalReceipt"  'APERTURA SCONTRINO
      Print #NumFile, "Printer|1"  'seconda riga sempre uguale
 
   With mpGridScontrino
      vTotCalcolato = 0
            
      'Verifichiamo se si tratta di un RESO

      If gtParam4RegCas.pEseguiReso Then
         'Print #NumFile, "printRecMessage|1|1|1|1|DOCUMENTO DI RESO"  'Indicazione che si tratta di RESO
         Print #NumFile, "printRecMessage|1|4|1|1|REFUND " & gtParam4RegCas.pResAnnNumDoc1 & _
                                                       " " & gtParam4RegCas.pResAnnNumDoc2 & _
                                                       " " & Replace(gtParam4RegCas.pResAnnDatDoc, "/", "") & _
                                                       " " & gtParam4RegCas.pResAnnMatric  'Costruzione dell ariga di riferimento per il RESO
      ElseIf gtParam4RegCas.pEseguiAnnullo Then
         Print #NumFile, "printRecMessage|1|4|1|1|VOID " & gtParam4RegCas.pResAnnNumDoc1 & _
                                                     " " & gtParam4RegCas.pResAnnNumDoc2 & _
                                                     " " & Replace(gtParam4RegCas.pResAnnDatDoc, "/", "") & _
                                                     " " & gtParam4RegCas.pResAnnMatric  'Costruzione della riga di riferimento per il ANNULLO
      End If
      
      
      
      For i = 0 To .Rows.Count - 1
         vTotCalcolato = vTotCalcolato + .Rows(i).Record.Item(gtParam4RegCas.pColImpNet).Value
                                
                                
         'Eventuale linea di separazione
            If gtParam4RegCas.pColStmpSeparLineBefore > 0 Then
               If .Rows(i).Record.Item(gtParam4RegCas.pColStmpSeparLineBefore).Value = 1 Then
                  vStrRiga = "printRecMessage|1"  'Comando | Operatore
                  vStrRiga = vStrRiga & "|4|1|1"  'Tipo Riga | Progress di riga (per Tip 4 va bene anche sempre 1) | Font (normal)
                  vStrRiga = vStrRiga & "|" & String(22, "-")
                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
               End If
            End If
                                
                                
          'Qui verifico se c'e' l'associazione del Codice IVA con il Reparti del Registratore di Cassa
            vVal = ReadINI("REPARTIIVA_REPARTI", .Rows(i).Record.Item(gtParam4RegCas.pColRepIVA).Value, mPathFileConf4Scontrino)
            If Len(Trim(vVal)) > 0 Then vVal = Replace(vVal, "Reparto", "")
            If IsNumeric(vVal) = False Then vVal = "1"
                      
                      
          'Controllo se si tratta di un RESO o di un articolo normale di vendita
            If .Rows(i).Record.Item(gtParam4RegCas.pColSimbol).Value = "R" Then
               vStrRiga = RowScontrEPSON_RT(i, "RESO", CByte(vVal))  'Compongo la stringa di RESO
            Else
               vStrRiga = RowScontrEPSON_RT(i, "STD", CByte(vVal))  'Compongo la stringa STANDARD
            End If
             Print #NumFile, vStrRiga 'Stampo la stringa nel File
                      
'            'Qui controllo se c' lo Sconto riga sull'Articolo
'            If .Rows(i).Record.Item(gtParam4RegCas.pColScont1) > 0 Then
'               vStrRiga = RowScontrEPSON_RT(i, "SCN_RIG", 0, CByte(vVal)) 'Compongo la stringa SCONTO RIGA
'               Print #NumFile, vStrRiga 'Stampo la stringa nel File
'            End If
            
         If gtParam4RegCas.pColStmpAddMsgRow > 0 Then
            If Len(Trim(.Rows(i).Record.Item(gtParam4RegCas.pColStmpAddMsgRow).Value)) > 0 Then
               vArr = Split(.Rows(i).Record.Item(gtParam4RegCas.pColStmpAddMsgRow).Value, "")
               For Y = 0 To UBound(vArr)
                  vStrRiga = "printRecMessage|1|4|1|1|"  'Comando | Operatore | Tipo Riga | Progress di riga (per Tip 4 va bene anche sempre 1) | Font (normal)
                  vStrRiga = vStrRiga & vArr(Y)
                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
               Next Y
               Erase vArr
            End If
         End If
                    
      Next i
       
       
'Print #NumFile, "CIAO"
       
       If Not gtParam4RegCas.pEseguiAnnullo Then
       
          'Verifico se devo inserire la riga di riferimento (vale per scontrini a 0 in presenza di Prepagati o Abbonamenti)
            If Len(Trim(gtParam4RegCas.pRifDocFat)) > 0 Then
               gtParam4RegCas.pRifDocFat = Replace(gtParam4RegCas.pRifDocFat, "Doc.C", "Doc. Comm.")
               vPos = InStr(1, LCase(gtParam4RegCas.pRifDocFat), "nr")
               If vPos > 1 Then
                  vStrRiga = "printRecMessage|1|4|1|1|" & Trim(Mid(gtParam4RegCas.pRifDocFat, 1, vPos - 1))
                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
                  vStrRiga = "printRecMessage|1|4|1|1|" & "  " & Trim(Mid(gtParam4RegCas.pRifDocFat, vPos))
                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
               Else
                  vStrRiga = "printRecMessage|1|4|1|1|" & gtParam4RegCas.pRifDocFat
                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
               End If
            End If
          
      
         'Eventuali SCONTI sul DOCUMENTO
            If vTotCalcolato > gtParam4RegCas.pImpTotale Then
               'If gtParam4RegCas.pScontoPercent = True Then 'Controllo se  in PERCENTUALE...
                  vStrRiga = RowScontrEPSON_RT(-1, "SCN_DOC", 0, (vTotCalcolato - gtParam4RegCas.pImpTotale))  'Compongo la stringa SCONTO RIGA
                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
               'Else                          '...oppure se  a VALORE
               '   'Stampo il Subtotale
               '      vStrRiga = "3003"
               '         Print #NumFile, vStrRiga 'Stampo la stringa nel File
               '   '-------------------
               '   vStrRiga = RowScontrEPSON_RT(0, "SCN_DOC_DOC", (vTotCalcolato - gtParam4RegCas.pImpTotale))   'Compongo la stringa SCONTO RIGA
               '      Print #NumFile, vStrRiga 'Stampo la stringa nel File
               'End If
            End If
      
      
         'Stampa del Codice Fiscale
            'vVal = ReadINI("SCONTRINI", "NO_CODFIS", IniPath)
            vVal = ReadINI("OPZIONI", "NO_CODFIS", mPathFileConf4Scontrino)
            If Not (vVal = "1") Then
               If Len(gtParam4RegCas.pCodFisc) > 0 Then '(TESTATO = OK!)
                  'vStrRiga = RowScontrEPSON_RT(-1, "CODFIS", 0, 0, "C.F. Cliente: " & gtParam4RegCas.pCodFisc & "")
                        vStrRiga = "directIO|opCodFiscale"  'Comando
                        vStrRiga = vStrRiga & "|1"  'Tipo Riga
                        vStrRiga = vStrRiga & "|" & gtParam4RegCas.pCodFisc 'COdice FIscale
                  
                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
               End If
            End If
            
      
'LINEE DI CORTESIA ===========================================================================================================
'     '===========================================================================================================
            Dim vLineeCortesia As Boolean
            vLineeCortesia = ((gtParam4RegCas.pPrepagResiduo > 0) Or (gtParam4RegCas.pPuntiFid > 0) Or (Len(gtParam4RegCas.pVoucherID) > 0))
            
            If vLineeCortesia Then
               vPrgRowMsg = vPrgRowMsg + 1
                  vStrRiga = "printRecMessage|1|3|" & Trim(Str(vPrgRowMsg)) & "|1|" & String(46, " ") & "| "
                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
               vPrgRowMsg = vPrgRowMsg + 1
                  vStrRiga = "printRecMessage|1|3|" & Trim(Str(vPrgRowMsg)) & "|1|" & String(46, "-") & "| "
                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
            End If
      '===========================================================================================================
      
      
         'Stampo la riga di Cortesia con il totale del Credito del Prepagato residuo
            If gtParam4RegCas.pPrepagResiduo > 0 Then
               vPrgRowMsg = vPrgRowMsg + 1
                  vStrRiga = "printRecMessage|1|3|" & Trim(Str(vPrgRowMsg)) & "|1|" & String(46, " ") & "| "
                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
'               vPrgRowMsg = vPrgRowMsg + 1
'                  vStrRiga = "printRecMessage|1|3|" & Trim(Str(vPrgRowMsg)) & "|1|" & String(46, "*") & "| "
'                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
'               vPrgRowMsg = vPrgRowMsg + 1
'                  vStrRiga = "printRecMessage|1|3|" & Trim(Str(vPrgRowMsg)) & "|1|" & String(46, " ") & "| "
'                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
               
                  vPrgRowMsg = vPrgRowMsg + 1
                     vStrRiga = "printRecMessage|1|3|" & Trim(Str(vPrgRowMsg)) & "|1|PREPAGATO DISPONIBILE| "
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
                  vPrgRowMsg = vPrgRowMsg + 1
                     vStrRiga = "printRecMessage|1|3|" & Trim(Str(vPrgRowMsg)) & "|3|" & Format(gtParam4RegCas.pPrepagResiduo, "#####0.#0") & "| "
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
                                 
'               vPrgRowMsg = vPrgRowMsg + 1
'                  vStrRiga = "printRecMessage|1|3|" & Trim(Str(vPrgRowMsg)) & "|1|" & String(46, " ") & "| "
'                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
'               vPrgRowMsg = vPrgRowMsg + 1
'                  vStrRiga = "printRecMessage|1|3|" & Trim(Str(vPrgRowMsg)) & "|1|" & String(46, "*") & "| "
'                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
               vPrgRowMsg = vPrgRowMsg + 1
                  vStrRiga = "printRecMessage|1|3|" & Trim(Str(vPrgRowMsg)) & "|1|" & String(46, " ") & "| "
                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
            End If
      
      
          'Stampo la riga di Cortesia con il totale dei Punti Fedelt accumulati
             If gtParam4RegCas.pPuntiFid > 0 Then
               vPrgRowMsg = vPrgRowMsg + 1
                  vStrRiga = "printRecMessage|1|3|" & Trim(Str(vPrgRowMsg)) & "|1|" & String(46, " ") & "| "
                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
'               vPrgRowMsg = vPrgRowMsg + 1
'                  vStrRiga = "printRecMessage|1|3|" & Trim(Str(vPrgRowMsg)) & "|1|" & String(46, "*") & "| "
'                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
'               vPrgRowMsg = vPrgRowMsg + 1
'                  vStrRiga = "printRecMessage|1|3|" & Trim(Str(vPrgRowMsg)) & "|1|" & String(46, " ") & "| "
'                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
               
                  vPrgRowMsg = vPrgRowMsg + 1
                     vStrRiga = "printRecMessage|1|3|" & Trim(Str(vPrgRowMsg)) & "|1|PUNTI FIDELITY| "
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
                  vPrgRowMsg = vPrgRowMsg + 1
                     vStrRiga = "printRecMessage|1|3|" & Trim(Str(vPrgRowMsg)) & "|3|" & Trim(Str(gtParam4RegCas.pPuntiFid)) & "| "
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
               
'               vPrgRowMsg = vPrgRowMsg + 1
'                  vStrRiga = "printRecMessage|1|3|" & Trim(Str(vPrgRowMsg)) & "|1|" & String(46, " ") & "| "
'                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
'               vPrgRowMsg = vPrgRowMsg + 1
'                  vStrRiga = "printRecMessage|1|3|" & Trim(Str(vPrgRowMsg)) & "|1|" & String(46, "*") & "| "
'                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
               vPrgRowMsg = vPrgRowMsg + 1
                  vStrRiga = "printRecMessage|1|3|" & Trim(Str(vPrgRowMsg)) & "|1|" & String(46, " ") & "| "
                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
             End If
      
      
         'Stampo la riga di Cortesia con il riferimento al numero voucher e importo
             If Len(gtParam4RegCas.pVoucherID) > 0 Then
               vPrgRowMsg = vPrgRowMsg + 1
                  vStrRiga = "printRecMessage|1|3|" & Trim(Str(vPrgRowMsg)) & "|1|" & String(46, " ") & "| "
                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
               
                  vPrgRowMsg = vPrgRowMsg + 1
                     vStrRiga = "printRecMessage|1|3|" & Trim(Str(vPrgRowMsg)) & "|1|VOUCHER CARD| "
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
                  vPrgRowMsg = vPrgRowMsg + 1
                     vStrRiga = "printRecMessage|1|3|" & Trim(Str(vPrgRowMsg)) & "|3|" & gtParam4RegCas.pVoucherID & "| "
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
                  
                  vPrgRowMsg = vPrgRowMsg + 1
                     vStrRiga = "printRecMessage|1|3|" & Trim(Str(vPrgRowMsg)) & "|1|Descrizione| "
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
                  vPrgRowMsg = vPrgRowMsg + 1
                     vStrRiga = "printRecMessage|1|3|" & Trim(Str(vPrgRowMsg)) & "|3|" & gtParam4RegCas.pVoucherDescr & "| "
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
                                    
                  vPrgRowMsg = vPrgRowMsg + 1
                     vStrRiga = "printRecMessage|1|3|" & Trim(Str(vPrgRowMsg)) & "|1|Valore| "
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
                  vPrgRowMsg = vPrgRowMsg + 1
                     vStrRiga = "printRecMessage|1|3|" & Trim(Str(vPrgRowMsg)) & "|3|" & Format(gtParam4RegCas.pVoucherValue, "########0.#0") & "| "
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
                  
               vPrgRowMsg = vPrgRowMsg + 1
                  vStrRiga = "printRecMessage|1|3|" & Trim(Str(vPrgRowMsg)) & "|1|" & String(46, " ") & "| "
                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
             End If
   

         If vLineeCortesia Then
            vPrgRowMsg = vPrgRowMsg + 1
               vStrRiga = "printRecMessage|1|3|" & Trim(Str(vPrgRowMsg)) & "|1|" & String(46, "-") & "| "
               Print #NumFile, vStrRiga 'Stampo la stringa nel File
            vPrgRowMsg = vPrgRowMsg + 1
               vStrRiga = "printRecMessage|1|3|" & Trim(Str(vPrgRowMsg)) & "|1|" & String(46, " ") & "| "
               Print #NumFile, vStrRiga 'Stampo la stringa nel File
         End If
   '===========================================================================================================
   
   
   
         'Seriale del documento + SPAZIO
         vPrgRowMsg = vPrgRowMsg + 1
            vStrRiga = "printRecMessage|1|3|" & Trim(Str(vPrgRowMsg)) & "|1|S:" & gtParam4RegCas.pSerial & "| "
            Print #NumFile, vStrRiga 'Stampo la stringa nel File
'         vPrgRowMsg = vPrgRowMsg + 1
'            vStrRiga = "printRecMessage|1|3|" & Trim(Str(vPrgRowMsg)) & "|1|" & String(46, " ") & "| "
'            Print #NumFile, vStrRiga 'Stampo la stringa nel File
   
   
      
      
          'Riga di chiusura del SUBTOTALE
             vStrRiga = RowScontrEPSON_RT(-1, "CHI_TOT", 0)
             Print #NumFile, vStrRiga 'Stampo la stringa nel File
      
      
          
          
   'gTipPagSubtot   struttura x, 0 -> Codice Tipo Pagamento _
                              x, 1 -> Importo Pagamento _
                              x, 2 -> Conto Incasso (campo TGTESTO1 della tabella TAB_GEN con CHIAVE = 'PAGAME') _
                              x, 3 -> Codice per Registratore Telematico (campo TGSPUNTA2 della tabella TAB_GEN con CHIAVE = 'PAGAME') _
                              x, 4 -> Importo Pagamento (all'origine, perch durante gl'incasso il valore viene svuotato e allo scontrino arriverebbe vuoto)
                              
          'Stringa di IMPORTO RICEVUTO (prendo la descrizione dalla gTipPagSubtot(0, 1))
             Dim vDesPagam As String
             
            Dim vNoDescPersonal As Boolean
            vNoDescPersonal = (ReadINI("OPZIONI", "NO_PAGAMENTI", mPathFileConf4Scontrino) = "1")
             
             'vStrRiga = RowScontrEPSON_RT(-1, "IMP_RIC", 0, IIf(gtParam4RegCas.pImpRicPerScontrino > gtParam4RegCas.pImpTotale, gtParam4RegCas.pImpRicPerScontrino, gtParam4RegCas.pImpTotale))
             vDesPagam = DecodDesPagamento(gTipPagSubtot(0, 0), vNoDescPersonal)
             vStrRiga = RowScontrEPSON_RT(-1, "IMP_RIC", 0, CCur(gTipPagSubtot(0, 4)), vDesPagam, gTipPagSubtot(0, 3))
             Print #NumFile, vStrRiga 'Stampo la stringa nel File
                      
          'Verifico se c' il pagamento 2
             If Len(Trim(gTipPagSubtot(1, 0))) > 0 Then
                vDesPagam = DecodDesPagamento(gTipPagSubtot(1, 0), vNoDescPersonal)
                vStrRiga = RowScontrEPSON_RT(-1, "IMP_RIC", 0, CCur(gTipPagSubtot(1, 4)), vDesPagam, gTipPagSubtot(1, 3))
                Print #NumFile, vStrRiga 'Stampo la stringa nel File
             End If
          
          'Verifico se c' il pagamento 3
             If Len(Trim(gTipPagSubtot(2, 0))) > 0 Then
                vDesPagam = DecodDesPagamento(gTipPagSubtot(2, 0), vNoDescPersonal)
                vStrRiga = RowScontrEPSON_RT(-1, "IMP_RIC", 0, CCur(gTipPagSubtot(2, 4)), vDesPagam, gTipPagSubtot(2, 3))
                Print #NumFile, vStrRiga 'Stampo la stringa nel File
             End If
       
         End If
                
                
''         'Qui controllo se devo inserire la riga di apertura del Cassetto _
''          NB: DEVE ESSER L'ULTIMO COMANDO ALOTRIMENTI C' IL RISCHIO CHE L'FPMATE VADA IN ERRORE
''         If CInt(vApriCassetto) > 0 Then
''            Print #NumFile, "openDrawer|1"
''         End If
 ''--- RIMOSSO perch con lo scontrino arriva gi un impulso sulla porta del cassetto e si sentiva un doppio "beep"
                
       Call MsgRegCasInLogFile("[EpsonSetFileScontrino_RT] - CloseFile")
                
       'Chiudo il file di LOG
       Close #NumFile
              
   End With

   
   EpsonSetFileScontrino_RT = True


GestErr:
   If err.Number <> 0 Then
      Dim vErrStr As String
      vErrStr = err.Number & " - " & err.Description
      Call MsgRegCasInLogFile("[EpsonSetFileScontrino_RT] - " & vErrStr, True)
      MsgBox vErrStr & vbNewLine & _
             "Errore in fase generazione file scontrino" & vbNewLine & _
             "(EpsonSetFileScontrino_RT)", vbCritical
   End If
   On Error GoTo 0
End Function
Private Function EpsonSetFileFattura(pSerial As Long) As Boolean
'   Dim vStrRiga As String
'   Dim i As Integer
'   Dim vTotDOC As Currency
'   Dim vTotDocFormat As String
'   Dim vTotArt As Currency
'   Dim vVal As String
'   Dim vLenDescr As Byte
'
'   'Dim vRet As Long
'   'Dim vRetErr As Long
'
'   Dim RS As ADODB.Recordset
'   Dim strRicerca As String
'   Dim vArrAliquote() As String
'   'Dim vArrDettArt() As String
'
'   Dim vNumDoc As String
'   Dim vCliRagSoc As String
'   Dim vCliIndiri As String
'   Dim vCliLocali As String
'   Dim vCliParIva As String
'   Dim vCliCodFis As String
'
'
'   Dim NumFile As Integer 'per aprire il file di esecuzioni(LOG)
'   'Dim vStrRiga As String
'   'Dim vTempFile As String
'   Dim vPrintFile As String
'   Dim vTotCalcolato As Currency
'   Dim i As Integer
'   Dim vVal As String
'
'   On Error GoTo GestErr
'
'
''Qui Prendo i dati dal MASTER =============================================
'   strRicerca = "SELECT MVNUMDOC, MVALFDOC, MVDATDOC, " & _
'                "       ANDESCRI, ANINDIRI, AN___CAP, ANLOCALI, ANPROVIN, ANCODFIS, ANPARIVA " & _
'                "FROM [" & Azienda & "DOC_MAST] INNER JOIN [" & Azienda & "CONTI] ON ([" & Azienda & "DOC_MAST].MVCODCON = [" & Azienda & "CONTI].ANCODICE) AND ([" & Azienda & "DOC_MAST].MVTIPCON = [" & Azienda & "CONTI].ANTIPCON) " & _
'                "WHERE MVSERIAL = " & pSerial
'   Set RS = New ADODB.Recordset
'   RS.Open strRicerca, ConnessioneGenerale, adOpenStatic
'   If Not RS.EOF Then
'      vNumDoc = RS!MVNUMDOC & IIf(Len(Trim(RS!MVALFDOC)) > 0, "/" & RS!MVALFDOC, "")
'      vNumDoc = vNumDoc & " del " & RS!MVDATDOC
'
'      vCliRagSoc = Mid(RS!ANDESCRI, 1, 32)
'      vCliIndiri = Mid(NonNullo(RS!ANINDIRI), 1, 32)
'      vCliLocali = IIf(Len(Trim(NonNullo(RS!AN___CAP))) > 0, NonNullo(RS!AN___CAP) & " ", "")
'      vCliLocali = vCliLocali & Mid(NonNullo(RS!ANLOCALI), 1, 21) 'max 21 perche' gli altri caratteri se li prendono il CAP(5) e la Provincia(4) + 2 spazi (tot 11)
'      vCliLocali = vCliLocali & IIf(Len(Trim(NonNullo(RS!ANPROVIN))) > 0, " (" & NonNullo(RS!ANPROVIN) & ")", "")
'      vCliParIva = NonNullo(RS!ANPARIVA)
'      vCliCodFis = NonNullo(RS!ANCODFIS)
'   End If
'   RS.Close
'   Set RS = Nothing
'
'
'
'    '...altrimenti QUI INIZIO A COMPORRE LO SCONTRINO
'       NumFile = FreeFile
'       Open App.path & "\" & vTempFile For Append As #NumFile      'CREO IL FILE
'
'       Print #NumFile, "printerFiscalDocument"  'APERTURA FATTURA
'       Print #NumFile, "beginFiscalDocument|1|invAmount"  'seconda riga con l'importodella Fattura
'
'
'
''Qui Prendo i dettagli degli Articoli =============================================
'   strRicerca = "SELECT * " & _
'                "FROM     [" & Azienda & "DOC_DETT] " & _
'                "WHERE MVSERIAL = " & pSerial & " AND MVTIPRIG <> 'D' " & _
'                "ORDER BY CPROWNUM"
'   Set RS = New ADODB.Recordset
'   RS.Open strRicerca, ConnessioneGenerale, adOpenStatic
'   If Not RS.EOF Then
'      vTotArt = 0
'      Do Until RS.EOF
'         vTotArt = vTotArt + RS!MVVALRIG 'Totale SENZA sconti Documento
'
'
'         vStrRiga = "4003132"
'         vVal = FormattaNumero(RS!MVPESRIS, IIf(pred_DecimaliQta > 2, 2, pred_DecimaliQta), 1) 'Qt (MAX 2 DECIMALI)
'         vStrRiga = vStrRiga & Space(6 - Len(Trim(vVal))) & Trim(vVal) 'qta formatta
'            vStrRiga = vStrRiga & Space(1) 'SPAZIO
'         vVal = Trim(Mid(Trim(RS!MVDESART), 1, 13)) 'descrizione
'         vStrRiga = vStrRiga & vVal & Space(13 - Len(vVal)) 'descrizione formattata
'            vStrRiga = vStrRiga & Space(1) 'SPAZIO
'         vVal = FormattaNumero(RS!MVVALRIG, 2, 1)  'Valore di Riga (a 2 DECIMALI)
'         vStrRiga = vStrRiga & Space(7 - Len(Trim(vVal))) & Trim(vVal) 'Valore formatto
'            vStrRiga = vStrRiga & Space(1) 'SPAZIO
'         vVal = Trim(Mid(Trim(RS!MVCODIVA), 1, 3)) 'Cod.IVA
'         vStrRiga = vStrRiga & Space(3 - Len(vVal)) & vVal 'codiva formattato
'
'         'Stampo la riga
'         vRet = VbCEFWrite(vStrRiga, vRetErr)
'         'Debug.Print vStrRiga
'
'         RS.MoveNext
'      Loop
'   End If
'   RS.Close
'   Set RS = Nothing
'
'
'   ' riga di IMPORTO TOTALE  ----------------------------------
'   vStrRiga = "4003F"
'   vVal = "TOTALE FATTURA"
'   vLenDescr = Len(Trim(vVal))
'   vStrRiga = vStrRiga & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr))  'Lunghezza della Descrizione
'   vStrRiga = vStrRiga & Trim(vVal & vTotDocFormat)
'   vRet = VbCEFWrite(vStrRiga, vRetErr)
'   'Debug.Print vStrRiga
'
'   'Eventuali SCONTI sul DOCUMENTO
'   If vTotArt > gtParam4RegCas.pImpTotale Then
'      vStrRiga = "40031"
'      vVal = "-" & Trim(Format(vTotArt - gtParam4RegCas.pImpTotale, "#######0.#0"))
'      vVal = "SCONTO" & Space(26 - Len(vVal)) & vVal 'creo sempre una riga da 32 caratteri)
'      vLenDescr = Len(Trim(vVal))
'      vStrRiga = vStrRiga & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr))  'Lunghezza della Descrizione
'      vStrRiga = vStrRiga & Trim(vVal)
'      vRet = VbCEFWrite(vStrRiga, vRetErr)
'      'Debug.Print vStrRiga
'   End If
'
'   ' riga di PAGAMENTO  ----------------------------------
'   vStrRiga = "40031"
'   vVal = Trim(Format(gtParam4RegCas.pImpRicPerScontrino, "#######0.#0"))
'   vVal = "CONTANTE" & Space(24 - Len(vVal)) & vVal 'creo sempre una riga da 32 caratteri)
'   vLenDescr = Len(Trim(vVal))
'   vStrRiga = vStrRiga & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr))  'Lunghezza della Descrizione
'   vStrRiga = vStrRiga & Trim(vVal)
'   vRet = VbCEFWrite(vStrRiga, vRetErr)
'   'Debug.Print vStrRiga
'
'   ' riga di RESTO (solo se c') ----------------------------------
'   If (gtParam4RegCas.pImpRicPerScontrino - vTotDOC) > 0 Then
'      vStrRiga = "40031"
'      vVal = Trim(Format(gtParam4RegCas.pImpRicPerScontrino - vTotDOC, "#######0.#0"))
'      vVal = "RESTO" & Space(27 - Len(vVal)) & vVal 'creo sempre una riga da 32 caratteri)
'      vLenDescr = Len(Trim(vVal))
'      vStrRiga = vStrRiga & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr))  'Lunghezza della Descrizione
'      vStrRiga = vStrRiga & Trim(vVal)
'      vRet = VbCEFWrite(vStrRiga, vRetErr)
'      'Debug.Print vStrRiga
'   End If
'
'   ' riga di separazione ----------------------------------------------
'   vStrRiga = "4003132" & String(32, "-")
'   vRet = VbCEFWrite(vStrRiga, vRetErr)
'   'Debug.Print vStrRiga
'
'
''DETTAGLIO ALIQUOTE IVA
'   ' riga di testata delle righe di dettaglio -------------------------
'   vStrRiga = "4003132" & "         IMPOSTA      IMPONIBILE"
'   vRet = VbCEFWrite(vStrRiga, vRetErr)
'   'Debug.Print vStrRiga
'
'   'Cicolo sulle aliquote
'   For i = 0 To UBound(vArrAliquote)
'      vStrRiga = "40031"
'      vVal = vArrAliquote(i, 0) & ": IVA " & vArrAliquote(i, 1) & "%"
'      vLenDescr = Len(Trim(vVal))
'      vStrRiga = vStrRiga & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr))  'Lunghezza della Descrizione
'      vStrRiga = vStrRiga & Trim(vVal)
'      vRet = VbCEFWrite(vStrRiga, vRetErr)
'      'Debug.Print vStrRiga
'
'      vStrRiga = "4003132"
'      vVal = FormattaNumero(CDbl(vArrAliquote(i, 2)), 2, 1)  'Imponibile
'      vStrRiga = vStrRiga & Space(16 - Len(Trim(vVal))) & Trim(vVal) 'Imponibile formatta
'      vVal = FormattaNumero(CDbl(vArrAliquote(i, 3)), 2, 1)  'Imposta
'      vStrRiga = vStrRiga & Space(16 - Len(Trim(vVal))) & Trim(vVal) 'Imposta formatta
'      'Stampo la riga
'      vRet = VbCEFWrite(vStrRiga, vRetErr)
'      'Debug.Print vStrRiga
'   Next i
'
'   ' riga di separazione ----------------------------------------------
'   vStrRiga = "4003132" & String(32, "-")
'   vRet = VbCEFWrite(vStrRiga, vRetErr)
'   'Debug.Print vStrRiga
'
'   vStrRiga = "40031"
'   vVal = "[         DATI CLIENTE         ]"
'   vLenDescr = Len(Trim(vVal))
'   vStrRiga = vStrRiga & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr))  'Lunghezza della Descrizione
'   vStrRiga = vStrRiga & Trim(vVal)
'   vRet = VbCEFWrite(vStrRiga, vRetErr)
'   'Debug.Print vStrRiga
'
'   vStrRiga = "40031"
'   vVal = vCliRagSoc
'   vLenDescr = Len(Trim(vVal))
'   vStrRiga = vStrRiga & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr))  'Lunghezza della Descrizione
'   vStrRiga = vStrRiga & Trim(vVal)
'   vRet = VbCEFWrite(vStrRiga, vRetErr)
'   'Debug.Print vStrRiga
'   If Len(Trim(vCliIndiri)) > 0 Then
'      vStrRiga = "40031"
'      vVal = vCliIndiri
'      vLenDescr = Len(Trim(vVal))
'      vStrRiga = vStrRiga & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr))  'Lunghezza della Descrizione
'      vStrRiga = vStrRiga & Trim(vVal)
'      vRet = VbCEFWrite(vStrRiga, vRetErr)
'      'Debug.Print vStrRiga
'   End If
'   If Len(Trim(vCliLocali)) > 0 Then
'      vStrRiga = "40031"
'      vVal = vCliLocali
'      vLenDescr = Len(Trim(vVal))
'      vStrRiga = vStrRiga & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr))  'Lunghezza della Descrizione
'      vStrRiga = vStrRiga & Trim(vVal)
'      vRet = VbCEFWrite(vStrRiga, vRetErr)
'      'Debug.Print vStrRiga
'   End If
'   If Len(Trim(vCliParIva)) > 0 Then
'      vStrRiga = "40031"
'      vVal = "P.IVA: " & vCliParIva
'      vLenDescr = Len(Trim(vVal))
'      vStrRiga = vStrRiga & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr))  'Lunghezza della Descrizione
'      vStrRiga = vStrRiga & Trim(vVal)
'      vRet = VbCEFWrite(vStrRiga, vRetErr)
'      'Debug.Print vStrRiga
'   End If
'   If Len(Trim(vCliCodFis)) > 0 Then
'      vStrRiga = "40031"
'      vVal = "C.FIS.: " & vCliCodFis
'      vLenDescr = Len(Trim(vVal))
'      vStrRiga = vStrRiga & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr))  'Lunghezza della Descrizione
'      vStrRiga = vStrRiga & Trim(vVal)
'      vRet = VbCEFWrite(vStrRiga, vRetErr)
'      'Debug.Print vStrRiga
'   End If
'
'   'Punti Fedelet accumulati
'   If gtParam4RegCas.pPuntiFid > 0 Then
'      vStrRiga = "40036"
'      vVal = ">>> PUNTI FIDELITY: " & Trim(Str(gtParam4RegCas.pPuntiFid)) & " <<<"
'      vLenDescr = Len(Trim(vVal))
'      vStrRiga = vStrRiga & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr))  'Lunghezza della Descrizione
'      vStrRiga = vStrRiga & Trim(vVal)
'      vRet = VbCEFWrite(vStrRiga, vRetErr)
'      'Debug.Print vStrRiga
'   End If
'
'
'   'Chiudo il documento
'   vStrRiga = "4006"
'   vRet = VbCEFWrite(vStrRiga, vRetErr)
'   'Debug.Print "Chiusura Documento"
'
'   'Close Communication on Com Port
'   vRet = VbCEFClose(vRetErr)
'   'Debug.Print "Close"
'
'   StampaFatturaCUSTOM = True
End Function

Private Function RowScontrEPSON_RT(pRiga As Integer, pTipo As String, pReparto As Byte, _
                                Optional pValore As Currency, Optional pTesto As String, _
                                Optional pTipoPagTelematico As String, Optional pNumRigaMessaggio As Byte) As String
   Dim vDescr As String
   Dim vVal As Currency
   'Compone la riga dello scontrino per EPSON

   With mpGridScontrino
      
      'Se una riga con descrizione allora tolgo eventuali parentesi dalla descrizione
      If pRiga > -1 Then
         If gtParam4RegCas.pStmpDescrAltern Then 'verifico se devo prendere la descrizione alternativa
            vDescr = DecodDES_ALTREN_ARTICOLO(.Rows(pRiga).Record.Item(gtParam4RegCas.pColCodArt).Value)
         End If
         If Len(Trim(vDescr)) = 0 Then
            vDescr = .Rows(pRiga).Record.Item(gtParam4RegCas.pColCodArt + 1).Value
         End If
         vDescr = Trim(Mid(PulisciDescrizioneScontrino(vDescr), 1, 32))
      End If
      
      
      If pTipo = "STD" Or pTipo = "RESO" Then 'riga STANDARD o Reso (SONO IDENTICHE CAMBIA SOLO IL COMANDO)
         'printRecItem|1|Vendita Reparto Iva 10%|1|100,0|15|1
         If (pTipo = "RESO") Or (gtParam4RegCas.pEseguiReso) Then
            RowScontrEPSON_RT = "printRecRefund|1"  'Comando e Operatore (fisso)
            If gtParam4RegCas.pEseguiReso Then
               vVal = .Rows(pRiga).Record.Item(gtParam4RegCas.pColPrezzo).Value 'Prezzo per RESO RT  positivo e arriva gi Positivo
            Else
               vVal = .Rows(pRiga).Record.Item(gtParam4RegCas.pColPrezzo).Value * (-1) 'Prezzo ma devo renderlo positivo
            End If
         Else
            RowScontrEPSON_RT = "printRecItem|1"  'Comando e Operatore (fisso)
            vVal = .Rows(pRiga).Record.Item(gtParam4RegCas.pColPrezzo).Value 'Prezzo
            
            'Se l'importo  negativo e non si tratta di reso allora  uno storno dal Prepagato
            If vVal < 0 Then ' in questo caso si tratta di riga di scarico dal prepagato
               RowScontrEPSON_RT = "printRecVoidItem|1"  'Comando e Operatore (fisso)
               vVal = .Rows(pRiga).Record.Item(gtParam4RegCas.pColPrezzo).Value * (-1) 'Prezzo ma devo renderlo positivo
            End If
         End If
         RowScontrEPSON_RT = RowScontrEPSON_RT & "|" & vDescr & "" 'Descrizione
         RowScontrEPSON_RT = RowScontrEPSON_RT & "|" & Replace(FormattaNumero(.Rows(pRiga).Record.Item(gtParam4RegCas.pColQuanti).Value, pred_DecimaliQta, 1), ".", ",") & "" 'Quantit
         RowScontrEPSON_RT = RowScontrEPSON_RT & "|" & Replace(FormattaNumero(CDbl(vVal), pred_DecimaliImp, 1), ".", ",") & "" 'Prezzo
         RowScontrEPSON_RT = RowScontrEPSON_RT & "|" & pReparto & "|1" 'Reparto + Allineamento testo a display (1=mostra i primi 20 caratteri)

         'Qui controllo subito se per caso c' uno sconto di riga e creo subito la riga andando a capo...
         If (CCur(.Rows(pRiga).Record.Item(gtParam4RegCas.pColScont1).Value) > 0) And (CCur(.Rows(pRiga).Record.Item(gtParam4RegCas.pColPrezzo).Value) > 0) Then
            'printRecItemAdjustment|1|Sconto su singolo prodotto|0|50,00|1|2
            RowScontrEPSON_RT = RowScontrEPSON_RT & vbNewLine
            
            'Inizia la riga dello sconto
            If CCur(.Rows(pRiga).Record.Item(gtParam4RegCas.pColScont1).Value) = 100 Then 'OMAGGIO = 100% DI SCONTO
               vDescr = "  O M A G G I O  "
            Else                                                           'SCOBTO NORMALE
               vDescr = "  S C O N T 0  " & Format(.Rows(pRiga).Record.Item(gtParam4RegCas.pColScont1).Value, "##0.#0") & "%"
            End If
            RowScontrEPSON_RT = RowScontrEPSON_RT & "printRecItemAdjustment|1"  'Comando e Operatore (fisso)
            RowScontrEPSON_RT = RowScontrEPSON_RT & "|" & vDescr & "" 'Descrizione
            RowScontrEPSON_RT = RowScontrEPSON_RT & "|0" 'Sconto normale
            vVal = CCur(.Rows(pRiga).Record.Item(gtParam4RegCas.pColPrzQta).Value) - CCur(.Rows(pRiga).Record.Item(gtParam4RegCas.pColImpNet).Value)  'calcolo l'importo da scontare moltiplicando la quantit con il prezzo unitario e sottraendo l'importo netto
            RowScontrEPSON_RT = RowScontrEPSON_RT & "|" & Replace(FormattaNumero(CDbl(vVal), pred_DecimaliImp, 1), ".", ",") & "" 'Importo da scontare
            RowScontrEPSON_RT = RowScontrEPSON_RT & "|" & pReparto & "|1" 'Reparto + Allineamento testo a display (1=mostra i primi 20 caratteri)
         End If
      
      ElseIf pTipo = "SCN_DOC" Then 'riga SCONTO DOCUMENTO IN PERCENTUALE
         'printRecSubtotalAdjustment|1|Sconto sul subtotal|1|50,00|1|1
         If gtParam4RegCas.pScontoPercent Then
            vDescr = "S C O N T 0   " & Format(gtParam4RegCas.pScontoDoc, "##0.#0") & "%"
         Else
            vDescr = "S C O N T 0"
         End If
         RowScontrEPSON_RT = "printRecSubtotalAdjustment|1"  'Comando e Operatore (fisso)
         RowScontrEPSON_RT = RowScontrEPSON_RT & "|" & vDescr & "" 'Descrizione
         RowScontrEPSON_RT = RowScontrEPSON_RT & "|1" 'Sconto con esposizione normale
         RowScontrEPSON_RT = RowScontrEPSON_RT & "|" & Replace(FormattaNumero(CDbl(pValore), 2, 1), ".", ",") & "" 'Importo da scontare
         RowScontrEPSON_RT = RowScontrEPSON_RT & "|1|1" 'Valore Fisso + Allineamento testo a display (1=mostra i primi 20 caratteri)
      
      ElseIf pTipo = "IMP_RIC" Then 'riga IMPORTO RICEVUTO
         'printRecTotal|4|Pagamento Cash|700,0|0|0|2
         RowScontrEPSON_RT = "printRecTotal|1"  'Comando e Operatore (fisso)
         RowScontrEPSON_RT = RowScontrEPSON_RT & "|" & Mid(pTesto, 1, 30) 'Descrizione
         RowScontrEPSON_RT = RowScontrEPSON_RT & "|" & Replace(FormattaNumero(CDbl(pValore), 2, 1), ".", ",") & "" 'Importo da scontare
         RowScontrEPSON_RT = RowScontrEPSON_RT & "|" & pTipoPagTelematico 'Tipo Pagamento
         RowScontrEPSON_RT = RowScontrEPSON_RT & "|" & IIf((pTipoPagTelematico = "2") Or (pTipoPagTelematico = "3"), "1", "0") 'Indice di Pagamento
         RowScontrEPSON_RT = RowScontrEPSON_RT & "|1" 'Allineamento testo a display (1=mostra i primi 20 caratteri)
      
      ElseIf pTipo = "CHI_TOT" Then 'riga DI CHIUSURA SUBTOTAL
         'printRecSubtotal|1|1
         RowScontrEPSON_RT = "printRecSubtotal|1|0"  'Comando + Operatore (fisso) + Opzione Esposizione (0=Print and display; 1=Print only; 2=display only)
      
      ElseIf pTipo = "CODFIS" Then
         'printRecMessage|1|2|1|1|Prima Riga Aggiuntiva Tipo 2
         'printRecMessage|1|2|2|1|Seconda Riga Aggiuntiva Tipo 2
         
         RowScontrEPSON_RT = "printRecMessage|1"  'Comando e Operatore (fisso)
         RowScontrEPSON_RT = RowScontrEPSON_RT & "|2" 'Tipo Riga
         RowScontrEPSON_RT = RowScontrEPSON_RT & "|1" 'Progressivo riga
         RowScontrEPSON_RT = RowScontrEPSON_RT & "|1" 'Tipo carattere
         RowScontrEPSON_RT = RowScontrEPSON_RT & "|" & String(32, "-") 'Tipo carattere
         'RowScontrEPSON_RT = RowScontrEPSON_RT & "| " 'Tipo carattere
         
         RowScontrEPSON_RT = RowScontrEPSON_RT & vbNewLine
         RowScontrEPSON_RT = RowScontrEPSON_RT & "printRecMessage|1"  'Comando e Operatore (fisso)
         RowScontrEPSON_RT = RowScontrEPSON_RT & "|2" 'Tipo Riga
         RowScontrEPSON_RT = RowScontrEPSON_RT & "|2" 'Progressivo riga
         RowScontrEPSON_RT = RowScontrEPSON_RT & "|2" 'Tipo carattere
         RowScontrEPSON_RT = RowScontrEPSON_RT & "|" & pTesto 'Tipo carattere
         
         RowScontrEPSON_RT = RowScontrEPSON_RT & vbNewLine
         RowScontrEPSON_RT = RowScontrEPSON_RT & "printRecMessage|1"  'Comando e Operatore (fisso)
         RowScontrEPSON_RT = RowScontrEPSON_RT & "|2" 'Tipo Riga
         RowScontrEPSON_RT = RowScontrEPSON_RT & "|3" 'Progressivo riga
         RowScontrEPSON_RT = RowScontrEPSON_RT & "|1" 'Tipo carattere
         RowScontrEPSON_RT = RowScontrEPSON_RT & "|" & String(32, "-") 'Tipo carattere
         'RowScontrEPSON_RT = RowScontrEPSON_RT & "| " 'Tipo carattere

      ElseIf pTipo = "MSG" Then
         'printRecMessage|1|2|1|1|Prima Riga Aggiuntiva Tipo 2
         'printRecMessage|1|2|2|1|Seconda Riga Aggiuntiva Tipo 2
         
         'Devo fare questo controllo perch le righe descrittive devo avere sempre il progressivo di riga consecutivo e quindi mi devo regolare iun base alla presenza del Codice Fiscale
         Dim vPrgRiga As Byte
         
         If pNumRigaMessaggio = 0 Then
            vPrgRiga = 1
         Else
            vPrgRiga = pNumRigaMessaggio
         End If
         
         RowScontrEPSON_RT = "printRecMessage|1"  'Comando e Operatore (fisso)
         RowScontrEPSON_RT = RowScontrEPSON_RT & "|2" 'Tipo Riga
         RowScontrEPSON_RT = RowScontrEPSON_RT & "|" & Trim(Str(vPrgRiga)) 'Progressivo riga
         RowScontrEPSON_RT = RowScontrEPSON_RT & "|1" 'Tipo carattere
         RowScontrEPSON_RT = RowScontrEPSON_RT & "|" & String(32, "*") 'Tipo carattere
         'RowScontrEPSON_RT = RowScontrEPSON_RT & "| " 'Tipo carattere
         vPrgRiga = vPrgRiga + 1
         
         RowScontrEPSON_RT = RowScontrEPSON_RT & vbNewLine
         RowScontrEPSON_RT = RowScontrEPSON_RT & "printRecMessage|1"  'Comando e Operatore (fisso)
         RowScontrEPSON_RT = RowScontrEPSON_RT & "|2" 'Tipo Riga
         RowScontrEPSON_RT = RowScontrEPSON_RT & "|" & Trim(Str(vPrgRiga)) 'Progressivo riga
         RowScontrEPSON_RT = RowScontrEPSON_RT & "|2" 'Tipo carattere
         RowScontrEPSON_RT = RowScontrEPSON_RT & "|" & pTesto 'Tipo carattere
         vPrgRiga = vPrgRiga + 1
         
         RowScontrEPSON_RT = RowScontrEPSON_RT & vbNewLine
         RowScontrEPSON_RT = RowScontrEPSON_RT & "printRecMessage|1"  'Comando e Operatore (fisso)
         RowScontrEPSON_RT = RowScontrEPSON_RT & "|2" 'Tipo Riga
         RowScontrEPSON_RT = RowScontrEPSON_RT & "|" & Trim(Str(vPrgRiga)) 'Progressivo riga
         RowScontrEPSON_RT = RowScontrEPSON_RT & "|1" 'Tipo carattere
         RowScontrEPSON_RT = RowScontrEPSON_RT & "|" & String(32, "*") 'Tipo carattere
         'RowScontrEPSON_RT = RowScontrEPSON_RT & "| " 'Tipo carattere

      End If

   End With
   
End Function


Private Function EpsonSetScontrino_CGI_RT() As Boolean
   Dim NumFile As Integer 'per aprire il file di esecuzioni(LOG)
   Dim vStrRiga As String
   Dim vTotCalcolato As Currency
   Dim i As Integer
   Dim vVal As String
   Dim vArr() As String
   Dim Y As Byte
   Dim vPos As Byte
   Dim vPrgRowMsg As Byte
   
   Dim vIndirIP As String
   Dim vNumPort As String
   Dim vArrDoc() As String
   Dim vStrAnnulloReso As String
   Dim vRetValEsito As Boolean
   
   On Error GoTo GestErr
      
      
      
'Qui prendo l'IP del Registratore
      vIndirIP = ReadINI("RETE", "IP", mPathFileConf4Scontrino)
      If Len(Trim(vIndirIP)) = 0 Then
         MsgBox "ATTENZIONE!" & vbNewLine & _
                "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
                "(Tag [RETE] Parametro <IP> non presente)" & vbNewLine & vbNewLine & _
                "Impossibile eseguire la stampa dello Scontrino.", vbCritical
         Exit Function
      End If

''Qui prendo il NUMERO DI PORTA da passare nel file scontrino (al momento non mi serve)
'      vNumPort = ReadINI("RETE", "PORT", mPathFileConf4Scontrino)
'      If Not IsNumeric(vNumPort) Then
'         MsgBox "ATTENZIONE!" & vbNewLine & _
'                "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
'                "(Tag [RETE] Parametro <PORT> non valido)" & vbNewLine & vbNewLine & _
'                "Impossibile eseguire la stampa dello Scontrino.", vbCritical
'         Exit Function
'      End If
''-------------------------------------------------------------------------------------------------



'Eseguo sempre il Check dello stato della stampante prima di procedere =============================================
      Erase vArrDoc
      Call AddArrayElement(vArrDoc, "resetPrinter#operator=1")
      If Not (EPSONSendCommand(vIndirIP, vNumPort, "printerCommand", vArrDoc, "")) Then
      'If Not queryPrinterStatus(vIndirIP, vNumPort) Then  'se 1 significa che necessita di chiusura
         Exit Function
      Else
         If gEPSONCheckInattivita = False Then 'verifico che non sia necessaria una Chiusura Fiscale
            If Not (EPSONCheckPeriodoInattivita(vIndirIP, vNumPort)) Then
               Exit Function
            End If
         End If
      End If
'===================================================================================================================
   
   
      Erase vArrDoc
            
      
'Procedura di ANNULLO ==========================================================================================
   If gtParam4RegCas.pEseguiAnnullo Then
      vStrAnnulloReso = gtParam4RegCas.pResAnnNumDoc1 & " " & _
                        gtParam4RegCas.pResAnnNumDoc2 & " " & _
                        Format(gtParam4RegCas.pResAnnDatDoc, "ddmmyyyy") & " " & _
                        gtParam4RegCas.pResAnnMatric
      vStrRiga = "printRecMessage#operator=1|messageType=4|index=1|font=1|message=VOID " & vStrAnnulloReso
      Call AddArrayElement(vArrDoc, vStrRiga)
      GoTo InvioComando
   End If
'===============================================================================================================
               
            
      
'APERTURA Procedura di RESO ====================================================================================
   If gtParam4RegCas.pEseguiReso Then
      vStrAnnulloReso = gtParam4RegCas.pResAnnNumDoc1 & " " & _
                        gtParam4RegCas.pResAnnNumDoc2 & " " & _
                        Format(gtParam4RegCas.pResAnnDatDoc, "ddmmyyyy") & " " & _
                        gtParam4RegCas.pResAnnMatric
      vStrRiga = "printRecMessage#operator=1|messageType=4|message=REFUND " & vStrAnnulloReso & "|font=1|index=1"
      Call AddArrayElement(vArrDoc, vStrRiga)
      
   Else
'APERTURA Procedura emissione DOCUMENTO COMMERCIALE ======================================================================
         
      Call MsgRegCasInLogFile("[EpsonSetScontrino_CGI_RT] - INIZIO EMISSIONE DOCUMENTO COMMERCIALE")
               
      'INIZIO ISTRUZIONI - - -
      Call AddArrayElement(vArrDoc, "beginFiscalReceipt#operator=1")
         
   End If

   
'DETTAGLIO del DOCUMENTO COMMERCIALE oppure DOCUMENTO DI RESO ==============================================================
   With mpGridScontrino
      vTotCalcolato = 0
      
      For i = 0 To .Rows.Count - 1
         vTotCalcolato = vTotCalcolato + .Rows(i).Record.Item(gtParam4RegCas.pColImpNet).Value
         
         'Eventuale linea di separazione
            If Not gtParam4RegCas.pEseguiReso Then 'se NON  RESO
               If gtParam4RegCas.pColStmpSeparLineBefore > 0 Then
                  If .Rows(i).Record.Item(gtParam4RegCas.pColStmpSeparLineBefore).Value = 1 Then
                     Call AddArrayElement(vArrDoc, "printRecMessage#operator=1|Text=" & String(22, "-") & "|Type=4|Index=1|Font=1")
                  End If
               End If
            End If
         
                           
               'Qui verifico se c'e' l'associazione del Codice IVA con il Reparti del Registratore di Cassa
                  vVal = ReadINI("REPARTIIVA_REPARTI", .Rows(i).Record.Item(gtParam4RegCas.pColRepIVA).Value, mPathFileConf4Scontrino)
                  If Len(Trim(vVal)) > 0 Then vVal = Replace(UCase(vVal), "REPARTO", "")
                  If IsNumeric(vVal) = False Then vVal = "1"
                                       
               'RIGA DI VENDITA / RESO
                  If gtParam4RegCas.pEseguiReso Then
                     vStrRiga = RowScontrEPSON_CGI_RT(i, "RES", CByte(vVal))  'Compongo la stringa STANDARD
                  Else
                     vStrRiga = RowScontrEPSON_CGI_RT(i, "STD", CByte(vVal))  'Compongo la stringa STANDARD
                  End If
                  Call AddArrayElement(vArrDoc, vStrRiga)
                                             
'               'Verificao se la riga sia in abbonamento
'                  If .Rows(i).Record.Item(gtParam4RegCas.pColSimbol).Value = "A" Then
'                     Call AddArrayElement(vArrDoc, "printRecMessage#operator=1|Text=(in abbonamento)|Type=4|Index=1|Font=1")
'                  End If
                                             
               'Qui controllo se c' lo Sconto riga sull'Articolo
                  If (CCur(.Rows(i).Record.Item(gtParam4RegCas.pColScont1).Value) > 0) And (CCur(.Rows(i).Record.Item(gtParam4RegCas.pColPrezzo).Value) > 0) Then
                     vStrRiga = RowScontrEPSON_CGI_RT(i, "SCN_ROW", CByte(vVal))  'Compongo la stringa dello SCONTO DI RIGA
                     Call AddArrayElement(vArrDoc, vStrRiga)
                  End If
                     
                  
         'Eventuali righe descrittive (messaggi da Subtotale)
            If Not gtParam4RegCas.pEseguiReso Then 'se NON  RESO
               If gtParam4RegCas.pColStmpAddMsgRow > 0 Then
                  If Len(Trim(.Rows(i).Record.Item(gtParam4RegCas.pColStmpAddMsgRow).Value)) > 0 Then
                     vArr = Split(.Rows(i).Record.Item(gtParam4RegCas.pColStmpAddMsgRow).Value, "")
                     For Y = 0 To UBound(vArr)
                        Call AddArrayElement(vArrDoc, "printRecMessage#operator=1|Text=" & vArr(Y) & "|Type=4|Index=1|Font=1")
                     Next Y
                     Erase vArr
                  End If
               End If
            End If
         
      Next i
      
      
             
      If Not gtParam4RegCas.pEseguiAnnullo Then
       
          'Verifico se devo inserire la riga di riferimento (vale per scontrini a 0 in presenza di Prepagati o Abbonamenti)
            If Len(Trim(gtParam4RegCas.pRifDocFat)) > 0 Then
               gtParam4RegCas.pRifDocFat = Replace(gtParam4RegCas.pRifDocFat, "Doc.C", "Doc. Comm.")
               vPos = InStr(1, LCase(gtParam4RegCas.pRifDocFat), "nr")
               If vPos > 1 Then
                  'Separo la riga
                  Call AddArrayElement(vArrDoc, "printRecMessage#operator=1|Text=" & Trim(Mid(gtParam4RegCas.pRifDocFat, 1, vPos - 1)) & "|Type=4|Index=1|Font=1")
                  Call AddArrayElement(vArrDoc, "printRecMessage#operator=1|Text=  " & Trim(Mid(gtParam4RegCas.pRifDocFat, vPos)) & "|Type=4|Index=1|Font=1")
               Else
                  'vStrRiga = "printRecMessage|1|4|1|1|" & gtParam4RegCas.pRifDocFat
                  'Print #NumFile, vStrRiga 'Stampo la stringa nel File
                  Call AddArrayElement(vArrDoc, "printRecMessage#operator=1|Text=" & gtParam4RegCas.pRifDocFat & "|Type=4|Index=1|Font=1")
               End If
            End If
          
      
          'Eventuali SCONTI sul DOCUMENTO
            If vTotCalcolato > gtParam4RegCas.pImpTotale Then
                'If gtParam4RegCas.pScontoPercent = True Then 'Controllo se  in PERCENTUALE...
               vStrRiga = RowScontrEPSON_CGI_RT(-1, "SCN_DOC", 0, (vTotCalcolato - gtParam4RegCas.pImpTotale))  'Compongo la stringa SCONTO RIGA
               Call AddArrayElement(vArrDoc, vStrRiga)
            End If
      
      
          'Stampa del Codice Fiscale
            'vVal = ReadINI("SCONTRINI", "NO_CODFIS", IniPath)
            'If Not (vVal = "T") Then
            vVal = ReadINI("OPZIONI", "NO_CODFIS", mPathFileConf4Scontrino)
            If Not (vVal = "1") Then
               If Len(gtParam4RegCas.pCodFisc) > 0 Then
                  vStrRiga = "directIO#command=1061|data=01" & gtParam4RegCas.pCodFisc
                  Call AddArrayElement(vArrDoc, vStrRiga)
               End If
            End If
      
            

'LINEE DI CORTESIA ===========================================================================================================
'     '===========================================================================================================
            Dim vLineeCortesia As Boolean
            vLineeCortesia = ((gtParam4RegCas.pPrepagResiduo > 0) Or (gtParam4RegCas.pPuntiFid > 0) Or (Len(gtParam4RegCas.pVoucherID) > 0))
            
            If vLineeCortesia Then
               vPrgRowMsg = vPrgRowMsg + 1
                  vStrRiga = "printRecMessage#operator=1|Text=" & String(46, " ") & "|Type=3|Index=" & Trim(Str(vPrgRowMsg)) & "|Font=1"
                  Call AddArrayElement(vArrDoc, vStrRiga)
               vPrgRowMsg = vPrgRowMsg + 1
                  vStrRiga = "printRecMessage#operator=1|Text=" & String(46, "-") & "|Type=3|Index=" & Trim(Str(vPrgRowMsg)) & "|Font=1"
                  Call AddArrayElement(vArrDoc, vStrRiga)
            End If
      '===========================================================================================================
      
      
      'PREPAGATO =================== Stampo la riga di Cortesia con il totale del Credito del Prepagato residuo
                  If gtParam4RegCas.pPrepagResiduo > 0 Then
                     vPrgRowMsg = vPrgRowMsg + 1
                        vStrRiga = "printRecMessage#operator=1|Text=" & String(46, " ") & "|Type=3|Index=" & Trim(Str(vPrgRowMsg)) & "|Font=1"
                        Call AddArrayElement(vArrDoc, vStrRiga)
                     
                        vPrgRowMsg = vPrgRowMsg + 1
                           vStrRiga = "printRecMessage#operator=1|Text= PREPAGATO DISPONIBILE|Type=3|Index=" & Trim(Str(vPrgRowMsg)) & "|Font=1"
                           Call AddArrayElement(vArrDoc, vStrRiga)
                        vPrgRowMsg = vPrgRowMsg + 1
                           vStrRiga = "printRecMessage#operator=1|Text=          " & Format(gtParam4RegCas.pPrepagResiduo, "#####0.#0") & "|Type=3|Index=" & Trim(Str(vPrgRowMsg)) & "|Font=3"
                           Call AddArrayElement(vArrDoc, vStrRiga)
                                       
                     vPrgRowMsg = vPrgRowMsg + 1
                        vStrRiga = "printRecMessage#operator=1|Text=" & String(46, " ") & "|Type=3|Index=" & Trim(Str(vPrgRowMsg)) & "|Font=1"
                        Call AddArrayElement(vArrDoc, vStrRiga)
                  End If
      '======================================================================='=================================================
            
      'FIDELITY CARD =================== Stampo la riga di Cortesia con il totale dei Punti Fedelt accumulati
                   If gtParam4RegCas.pPuntiFid > 0 Then
                     vPrgRowMsg = vPrgRowMsg + 1
                        vStrRiga = "printRecMessage#operator=1|Text=" & String(46, " ") & "|Type=3|Index=" & Trim(Str(vPrgRowMsg)) & "|Font=1"
                        Call AddArrayElement(vArrDoc, vStrRiga)
                     
                        vPrgRowMsg = vPrgRowMsg + 1
                           vStrRiga = "printRecMessage#operator=1|Text=     PUNTI FIDELITY|Type=3|Index=" & Trim(Str(vPrgRowMsg)) & "|Font=1"
                           Call AddArrayElement(vArrDoc, vStrRiga)
                        vPrgRowMsg = vPrgRowMsg + 1
                           vStrRiga = "printRecMessage#operator=1|Text=          " & Trim(Str(gtParam4RegCas.pPuntiFid)) & "|Type=3|Index=" & Trim(Str(vPrgRowMsg)) & "|Font=3"
                           Call AddArrayElement(vArrDoc, vStrRiga)
                     
                     vPrgRowMsg = vPrgRowMsg + 1
                        vStrRiga = "printRecMessage#operator=1|Text=" & String(46, " ") & "|Type=3|Index=" & Trim(Str(vPrgRowMsg)) & "|Font=1"
                        Call AddArrayElement(vArrDoc, vStrRiga)
                   End If
      '======================================================================='=================================================
            
      'VOUCHER =================== Stampo la riga di Cortesia con il riferimento al numero voucher e importo
                   If Len(gtParam4RegCas.pVoucherID) > 0 Then
                     vPrgRowMsg = vPrgRowMsg + 1
                        vStrRiga = "printRecMessage#operator=1|Text=" & String(46, " ") & "|Type=3|Index=" & Trim(Str(vPrgRowMsg)) & "|Font=1"
                        Call AddArrayElement(vArrDoc, vStrRiga)
                     
                        vPrgRowMsg = vPrgRowMsg + 1
                           vStrRiga = "printRecMessage#operator=1|Text=VOUCHER CARD|Type=3|Index=" & Trim(Str(vPrgRowMsg)) & "|Font=1"
                           Call AddArrayElement(vArrDoc, vStrRiga)
                        vPrgRowMsg = vPrgRowMsg + 1
                           vStrRiga = "printRecMessage#operator=1|Text=" & gtParam4RegCas.pVoucherID & "|Type=3|Index=" & Trim(Str(vPrgRowMsg)) & "|Font=3"
                           Call AddArrayElement(vArrDoc, vStrRiga)
                        
                        vPrgRowMsg = vPrgRowMsg + 1
                           vStrRiga = "printRecMessage#operator=1|Text=Descrizione|Type=3|Index=" & Trim(Str(vPrgRowMsg)) & "|Font=1"
                           Call AddArrayElement(vArrDoc, vStrRiga)
                        vPrgRowMsg = vPrgRowMsg + 1
                           vStrRiga = "printRecMessage#operator=1|Text=" & gtParam4RegCas.pVoucherDescr & "|Type=3|Index=" & Trim(Str(vPrgRowMsg)) & "|Font=3"
                           Call AddArrayElement(vArrDoc, vStrRiga)
                        
                        vPrgRowMsg = vPrgRowMsg + 1
                           vStrRiga = "printRecMessage#operator=1|Text=Valore|Type=3|Index=" & Trim(Str(vPrgRowMsg)) & "|Font=1"
                           Call AddArrayElement(vArrDoc, vStrRiga)
                        vPrgRowMsg = vPrgRowMsg + 1
                           vStrRiga = "printRecMessage#operator=1|Text=" & Format(gtParam4RegCas.pVoucherValue, "########0.#0") & "|Type=3|Index=" & Trim(Str(vPrgRowMsg)) & "|Font=3"
                           Call AddArrayElement(vArrDoc, vStrRiga)
                        
                     vPrgRowMsg = vPrgRowMsg + 1
                        vStrRiga = "printRecMessage#operator=1|Text=" & String(46, " ") & "|Type=3|Index=" & Trim(Str(vPrgRowMsg)) & "|Font=1"
                        Call AddArrayElement(vArrDoc, vStrRiga)
                   End If
      '======================================================================='=======================
      
      
'CHIUSURA LINEE DI CORTESIA ==================================================================================================================
            If vLineeCortesia Then
               vPrgRowMsg = vPrgRowMsg + 1
                  vStrRiga = "printRecMessage#operator=1|Text=" & String(46, "-") & "|Type=3|Index=" & Trim(Str(vPrgRowMsg)) & "|Font=1"
                  Call AddArrayElement(vArrDoc, vStrRiga)
               vPrgRowMsg = vPrgRowMsg + 1
                  vStrRiga = "printRecMessage#operator=1|Text=" & String(46, " ") & "|Type=3|Index=" & Trim(Str(vPrgRowMsg)) & "|Font=1"
                  Call AddArrayElement(vArrDoc, vStrRiga)
            End If
'=============================================================================================================================================
      
      
         'Seriale del documento + SPAZIO
         vPrgRowMsg = vPrgRowMsg + 1
            vStrRiga = "printRecMessage#operator=1|Text=S:" & gtParam4RegCas.pSerial & "|Type=3|Index=" & Trim(Str(vPrgRowMsg)) & "|Font=1"
            Call AddArrayElement(vArrDoc, vStrRiga)
'         vPrgRowMsg = vPrgRowMsg + 1
'            vStrRiga = "printRecMessage#operator=1|Text=" & String(46, " ") & "|Type=3|Index=" & Trim(Str(vPrgRowMsg)) & "|Font=1"
'            Call AddArrayElement(vArrDoc, vStrRiga)
      
      
      
'SUBTOTALE =============================================================
            vStrRiga = RowScontrEPSON_CGI_RT(-1, "CHI_TOT", 0)
            Call AddArrayElement(vArrDoc, vStrRiga)
'=======================================================================
      
            
                        
   'gTipPagSubtot   struttura x, 0 -> Codice Tipo Pagamento _
                              x, 1 -> Importo Pagamento _
                              x, 2 -> Conto Incasso (campo TGTESTO1 della tabella TAB_GEN con CHIAVE = 'PAGAME') _
                              x, 3 -> Codice per Registratore Telematico (campo TGSPUNTA2 della tabella TAB_GEN con CHIAVE = 'PAGAME') _
                              x, 4 -> Importo Pagamento (all'origine, perch durante gl'incasso il valore viene svuotato e allo scontrino arriverebbe vuoto)
            Dim vDesPagam As String
            Dim vNoDescPersonal As Boolean
            vNoDescPersonal = (ReadINI("OPZIONI", "NO_PAGAMENTI", mPathFileConf4Scontrino) = "1")
                              
          'Stringa di IMPORTO RICEVUTO (prendo la descrizione dalla gTipPagSubtot(0, 1))
            vDesPagam = DecodDesPagamento(gTipPagSubtot(0, 0), vNoDescPersonal)
            vStrRiga = RowScontrEPSON_CGI_RT(-1, "IMP_RIC", 0, CCur(gTipPagSubtot(0, 4)), vDesPagam, gTipPagSubtot(0, 3))
            Call AddArrayElement(vArrDoc, vStrRiga)
                      
          'Verifico se c' il pagamento 2
            If Len(Trim(gTipPagSubtot(1, 0))) > 0 Then
               vDesPagam = DecodDesPagamento(gTipPagSubtot(1, 0), vNoDescPersonal)
               vStrRiga = RowScontrEPSON_CGI_RT(-1, "IMP_RIC", 0, CCur(gTipPagSubtot(1, 4)), vDesPagam, gTipPagSubtot(1, 3))
               Call AddArrayElement(vArrDoc, vStrRiga)
            End If
          
          'Verifico se c' il pagamento 3
            If Len(Trim(gTipPagSubtot(2, 0))) > 0 Then
               vDesPagam = DecodDesPagamento(gTipPagSubtot(2, 0), vNoDescPersonal)
               vStrRiga = RowScontrEPSON_CGI_RT(-1, "IMP_RIC", 0, CCur(gTipPagSubtot(2, 4)), vDesPagam, gTipPagSubtot(2, 3))
               Call AddArrayElement(vArrDoc, vStrRiga)
            End If
       
       
         'endFiscalReceipt operator="1"
         vStrRiga = "endFiscalReceipt#operator=1"
         Call AddArrayElement(vArrDoc, vStrRiga)
       
      End If
                
      Call MsgRegCasInLogFile("[EpsonSetScontrino_CGI_RT] - CloseFile")

   End With

   
   
'INVIO COMANDO AL CGI DELLA STAMPANTE
InvioComando:
      Call VerificaEsistenzaPathCartella(PathREGCAS & "\Storico\")
      Dim Filename As String
      Filename = "EPSON_" & gIDPostazione & "_" & Format(Now, "yyyy.mm.dd_hh.nn.ss") & ".xml"
      vRetValEsito = EPSONSendCommand(vIndirIP, vNumPort, "printerFiscalReceipt", vArrDoc, "", "", PathREGCAS & "\Storico\" & Filename)
   
   
   'Verifico se devo attendere la risposta
      If ReadINI("PARAMETRI", "WAIT_OUT_REG", mPathFileConf4Scontrino) <> "1" Then
         vRetValEsito = True
      End If
   
   
   'Esito
      EpsonSetScontrino_CGI_RT = vRetValEsito
      Call MsgRegCasInLogFile("[EpsonSetScontrino_CGI_RT] - Esito ReadOut: '" & vRetValEsito & "'")
   
   
   'Salvo il tentativo nella tabella delle INFO se  andata a buonfine
      If vRetValEsito Then
         Call MsgRegCasInLogFile("[EpsonSetScontrino_CGI_RT] - Insert_DOC_INFO_RT")
            Call Insert_DOC_INFO_RT
      End If
      
      
   'Verifico se stampare il voucher CGI (NON INCIDE SULL'ESITO DELLA STAMPA DELLO SCONTRINO)
      If Len(gtParam4RegCas.pVoucherID) > 0 Then
         Erase vArrDoc
         Call AddArrayElement(vArrDoc, "beginNonFiscal#operator=1")
            Call AddArrayElement(vArrDoc, "printNormal#operator=1|font=1|data=" & String(46, "="))
            Call AddArrayElement(vArrDoc, "printNormal#operator=1|font=1|data=" & String(46, " "))
            Call AddArrayElement(vArrDoc, "printNormal#operator=1|font=1|data=" & String(46, " "))
               Call AddArrayElement(vArrDoc, "printNormal#operator=1|font=3|data= *** VOUCHER CARD ***")
            Call AddArrayElement(vArrDoc, "printNormal#operator=1|font=1|data=" & String(46, " "))
               Call AddArrayElement(vArrDoc, "printNormal#operator=1|font=3|data=Codice")
               Call AddArrayElement(vArrDoc, "printNormal#operator=1|font=3|data= " & gtParam4RegCas.pVoucherID)
            Call AddArrayElement(vArrDoc, "printNormal#operator=1|font=1|data=" & String(46, " "))
               Call AddArrayElement(vArrDoc, "printNormal#operator=1|font=3|data=Descrizione")
               Call AddArrayElement(vArrDoc, "printNormal#operator=1|font=3|data= " & gtParam4RegCas.pVoucherDescr)
            
            vVal = ReadINI("OPZIONI", "NO_PREZZO_VOUCHER", mPathFileConf4Scontrino)
            If vVal <> "1" Then
               Call AddArrayElement(vArrDoc, "printNormal#operator=1|font=1|data=" & String(46, " "))
                  Call AddArrayElement(vArrDoc, "printNormal#operator=1|font=3|data=Valore")
                  Call AddArrayElement(vArrDoc, "printNormal#operator=1|font=3|data= " & gtParam4RegCas.pVoucherValue)
            End If
            Call AddArrayElement(vArrDoc, "printNormal#operator=1|font=1|data=" & String(46, " "))
            Call AddArrayElement(vArrDoc, "printNormal#operator=1|font=1|data=" & String(46, " "))
            Call AddArrayElement(vArrDoc, "printNormal#operator=1|font=1|data=" & String(46, "="))
         Call AddArrayElement(vArrDoc, "endNonFiscal#operator=1")
         
         If Not (EPSONSendCommand(vIndirIP, vNumPort, "printerNonFiscal", vArrDoc, "")) Then
            Exit Function
         End If
      End If



GestErr:
   If err.Number <> 0 Then
      Dim vErrStr As String
      vErrStr = err.Number & " - " & err.Description
      Call MsgRegCasInLogFile("[EpsonSetScontrino_CGI_RT] - " & vErrStr, True)
      MsgBox vErrStr & vbNewLine & _
             "Errore in fase stampa Documento Commerciale" & vbNewLine & _
             "(EpsonSetScontrino_CGI_RT)", vbCritical
   End If
   On Error GoTo 0

End Function

Private Function RowScontrEPSON_CGI_RT(pRiga As Integer, pTipo As String, pReparto As Byte, _
                                       Optional pValore As Currency, Optional pTesto As String, _
                                       Optional pTipoPagTelematico As String, Optional pNumRigaMessaggio As Byte) As String
   Dim vDescr As String
   Dim vVal As Currency
   'Compone la riga dello scontrino per EPSON

   With mpGridScontrino
      
      'Se una riga con descrizione allora tolgo eventuali parentesi dalla descrizione
      If pRiga > -1 Then
         If gtParam4RegCas.pStmpDescrAltern Then 'verifico se devo prendere la descrizione alternativa
            vDescr = DecodDES_ALTREN_ARTICOLO(.Rows(pRiga).Record.Item(gtParam4RegCas.pColCodArt).Value)
         End If
         If Len(Trim(vDescr)) = 0 Then
            vDescr = .Rows(pRiga).Record.Item(gtParam4RegCas.pColCodArt + 1).Value
         End If
         vDescr = Trim(Mid(PulisciDescrizioneScontrino(vDescr), 1, 32))
      End If
      
      
      Select Case pTipo
         Case "STD", "RES"  'riga STANDARD
            If (pTipo = "RES") Or (gtParam4RegCas.pEseguiReso) Then
               RowScontrEPSON_CGI_RT = "printRecRefund#operator=1"   'Comando e Operatore (fisso)
            Else
               RowScontrEPSON_CGI_RT = "printRecItem#operator=1"   'Comando e Operatore (fisso)
            End If
            vVal = .Rows(pRiga).Record.Item(gtParam4RegCas.pColPrezzo).Value 'Prezzo
            'Se l'importo  negativo e non si tratta di reso allora  uno storno dal Prepagato
            If vVal < 0 Then ' in questo caso si tratta di riga di scarico dal prepagato
               RowScontrEPSON_CGI_RT = "printRecVoidItem#operator=1"  'Comando e Operatore (fisso)
               vVal = .Rows(pRiga).Record.Item(gtParam4RegCas.pColPrezzo).Value * (-1) 'Prezzo ma devo renderlo positivo
            End If
            RowScontrEPSON_CGI_RT = RowScontrEPSON_CGI_RT & "|Text=" & vDescr & "" 'Descrizione
            RowScontrEPSON_CGI_RT = RowScontrEPSON_CGI_RT & "|Qty=" & Replace(FormattaNumero(.Rows(pRiga).Record.Item(gtParam4RegCas.pColQuanti).Value, pred_DecimaliQta, 1), ".", ",") & "" 'Quantit
            RowScontrEPSON_CGI_RT = RowScontrEPSON_CGI_RT & "|UnitCost=" & Replace(FormattaNumero(CDbl(vVal), pred_DecimaliImp, 1), ".", ",") & "" 'Prezzo
            RowScontrEPSON_CGI_RT = RowScontrEPSON_CGI_RT & "|Dep=" & pReparto & "" 'Reparto
            RowScontrEPSON_CGI_RT = RowScontrEPSON_CGI_RT & "|Just=1" 'Allineamento testo a display (1=mostra i primi 20 caratteri)
      
         Case "SCN_ROW" 'riga SCONTO DI RIGA IN PERCENTUALE
            'Inizia la riga dello sconto
            If CCur(.Rows(pRiga).Record.Item(gtParam4RegCas.pColScont1).Value) = 100 Then 'OMAGGIO = 100% DI SCONTO
               vDescr = "  O M A G G I O  "
            Else                                                           'SCONTO NORMALE
               vDescr = "  S C O N T O  " & Format(.Rows(pRiga).Record.Item(gtParam4RegCas.pColScont1).Value, "##0.#0") & "%"
            End If
            RowScontrEPSON_CGI_RT = "printRecItemAdjustment#operator=1"  'Comando e Operatore (fisso)
            RowScontrEPSON_CGI_RT = RowScontrEPSON_CGI_RT & "|Text=" & vDescr & "" 'Descrizione
            RowScontrEPSON_CGI_RT = RowScontrEPSON_CGI_RT & "|Type=0" 'Sconto normale
            vVal = CCur(.Rows(pRiga).Record.Item(gtParam4RegCas.pColPrzQta).Value) - CCur(.Rows(pRiga).Record.Item(gtParam4RegCas.pColImpNet).Value)  'calcolo l'importo da scontare moltiplicando la quantit con il prezzo unitario e sottraendo l'importo netto
            RowScontrEPSON_CGI_RT = RowScontrEPSON_CGI_RT & "|Amount=" & Replace(FormattaNumero(CDbl(vVal), pred_DecimaliImp, 1), ".", ",") & "" 'Importo da scontare
            RowScontrEPSON_CGI_RT = RowScontrEPSON_CGI_RT & "|Dep=" & pReparto & "" 'Reparto
            RowScontrEPSON_CGI_RT = RowScontrEPSON_CGI_RT & "|Just=1" 'Allineamento testo a display (1=mostra i primi 20 caratteri)

         Case "SCN_DOC" 'riga SCONTO DOCUMENTO IN PERCENTUALE
            'printRecSubtotalAdjustment|1|Sconto sul subtotal|1|50,00|1|1
            If gtParam4RegCas.pScontoPercent Then
               vDescr = "S C O N T O   " & Format(gtParam4RegCas.pScontoDoc, "##0.#0") & "%"
            Else
               vDescr = "S C O N T O"
            End If
            RowScontrEPSON_CGI_RT = "printRecSubtotalAdjustment#operator=1"  'Comando e Operatore (fisso)
            RowScontrEPSON_CGI_RT = RowScontrEPSON_CGI_RT & "|Text=" & vDescr & "" 'Descrizione
            RowScontrEPSON_CGI_RT = RowScontrEPSON_CGI_RT & "|Type=1" 'Sconto con esposizione normale
            RowScontrEPSON_CGI_RT = RowScontrEPSON_CGI_RT & "|Amount=" & Replace(FormattaNumero(CDbl(pValore), 2, 1), ".", ",") & "" 'Importo da scontare
            RowScontrEPSON_CGI_RT = RowScontrEPSON_CGI_RT & "|Dep=" & pReparto & "" 'Reparto
            RowScontrEPSON_CGI_RT = RowScontrEPSON_CGI_RT & "|Just=1" 'Allineamento testo a display (1=mostra i primi 20 caratteri)
      
         Case "IMP_RIC" 'riga IMPORTO RICEVUTO
            RowScontrEPSON_CGI_RT = "printRecTotal#operator=1"  'Comando e Operatore (fisso)
            RowScontrEPSON_CGI_RT = RowScontrEPSON_CGI_RT & "|Text=" & Mid(pTesto, 1, 30) 'Descrizione
            RowScontrEPSON_CGI_RT = RowScontrEPSON_CGI_RT & "|Amount=" & Replace(FormattaNumero(CDbl(pValore), 2, 1), ".", ",") & "" 'Importo da pagare
            RowScontrEPSON_CGI_RT = RowScontrEPSON_CGI_RT & "|Type=" & pTipoPagTelematico 'Tipo Pagamento
            RowScontrEPSON_CGI_RT = RowScontrEPSON_CGI_RT & "|Index=" & IIf((pTipoPagTelematico = "2") Or (pTipoPagTelematico = "3"), "1", "0") 'Indice di Pagamento
            RowScontrEPSON_CGI_RT = RowScontrEPSON_CGI_RT & "|Just=1" 'Allineamento testo a display (1=mostra i primi 20 caratteri)
               
         Case "CHI_TOT" 'riga DI CHIUSURA SUBTOTAL
            RowScontrEPSON_CGI_RT = "printRecSubtotal#operator=1|Type=1"  'Comando + Operatore (fisso) + Opzione Esposizione (0=Print and display; 1=Print only; 2=display only)
      
      End Select

   End With
   
End Function

Private Function EpsonSetFileScontrino_MF() As Boolean
   Dim NumFile As Integer 'per aprire il file di esecuzioni(LOG)
   Dim vStrRiga As String
   Dim i As Integer
   Dim vStrImpRicevuto As String
   Dim vTotCalcolato As Currency
   Dim vPathEsito As String
   Dim vApriCassetto As String
   Dim vVal As String
   Dim vPathScontrino As String
   
   mTotImpArt = 0
   'Qui prendo il PATH dove creare il file dello scontrino da stampare
      
   
   vPathScontrino = ReadINI("PARAMETRI", "PATH_IN", mPathFileConf4Scontrino)
   'Controllo che sia pieno
   If Len(Trim(vPathScontrino)) = 0 Then
      MsgBox "ATTENZIONE!" & vbNewLine & _
             "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
             "(Tag [PARAMETRI] Parametro <PATH_IN> non presente)" & vbNewLine & vbNewLine & _
             "Impossibile eseguire la stampa dello Scontrino.", vbCritical
      Exit Function
   End If
   
   vPathEsito = ReadINI("PARAMETRI", "PATH_OUT", mPathFileConf4Scontrino)
   'Controllo che sia pieno
   If Len(Trim(vPathEsito)) = 0 Then
      MsgBox "ATTENZIONE!" & vbNewLine & _
             "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
             "(Tag [PARAMETRI] Parametro <PATH_OUT> non presente)" & vbNewLine & vbNewLine & _
             "Impossibile eseguire la stampa dello Scontrino.", vbCritical
      Exit Function
   End If
   
   
   vApriCassetto = ReadINI("PARAMETRI", "APRI_CASSETTO", mPathFileConf4Scontrino)
   If IsNumeric(vApriCassetto) = False Then
      vApriCassetto = "0"
   End If

   'Qui controllo se devo creare il file per aprire il cassetto che devo mandare prima _
    dello scontrino altrimenti a video non si legge l'importo dello scontrino
   If CInt(vApriCassetto) > 0 Then
      'Call Test_EPSON(vPathScontrino, "", 1) 'sfrutto la sub Test_EPSON
      Call PausaProgramma(0, True) ' sono costretto altrimenti NON si vede l'importo da pagare alla fine
   End If
   
   
   'controllo che non sia una ristampa ...
   If Len(gtParam4RegCas.pRistScontrino) = 0 Then
      
      '...altrimenti QUI INIZIO A COMPORRE LO SCONTRINO
      NumFile = FreeFile
      Open App.path & "\temp.txt" For Append As #NumFile      'CREO IL FILE
   
      Print #NumFile, "printerFiscalReceipt"  'APERTURA SCONTRINO
      Print #NumFile, "Printer|1"  'seconda riga sempre uguale
   
      With mpGridScontrino
         vTotCalcolato = 0
         
         For i = 0 To .Rows.Count - 1
            vTotCalcolato = vTotCalcolato + .Rows(i).Record.Item(gtParam4RegCas.pColImpNet).Value
                        
'            If CDbl(.Rows(i).Record.Item(mColQuanti)) <> 1 Then
'               vStrRiga = RowScontrEPSON_MF(i, "QTA")  'Inserisco la riga con le Quantit
'
'                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
'            End If
            
            'Qui verifico se c'e' l'associazione del Codice IVA con il Reparti del Registratore di Cassa
            vVal = ReadINI("REPARTIIVA_REPARTI", .Rows(i).Record.Item(gtParam4RegCas.pColRepIVA).Value, mPathFileConf4Scontrino)
            If Len(Trim(vVal)) > 0 Then vVal = Replace(UCase(vVal), "REPARTO", "")
            If IsNumeric(vVal) = False Then vVal = "1"
                        
                        
            'Controllo se si tratta di un RESO o di un articolo normale di vendita
            If .Rows(i).Record.Item(gtParam4RegCas.pColSimbol).Value = "R" Then
               vStrRiga = RowScontrEPSON_MF(i, "RESO", CByte(vVal))  'Compongo la stringa di RESO
            Else
               vStrRiga = RowScontrEPSON_MF(i, "STD", CByte(vVal))  'Compongo la stringa STANDARD
            End If
            Print #NumFile, vStrRiga 'Stampo la stringa nel File
            
'            'Qui controllo se c' lo Sconto riga sull'Articolo
'            If .Rows(i).Record.Item(mColScont1) > 0 Then
'               vStrRiga = RowScontrEPSON_MF(i, "SCN_RIG", 0, CByte(vVal)) 'Compongo la stringa SCONTO RIGA
'               Print #NumFile, vStrRiga 'Stampo la stringa nel File
'            End If
            
         Next i
         
         
         'Verifico se devo inserire la riga di riferimento (vale per cosntrini a 0 in presenza di Prepagati o Abbonamenti)
            If Len(Trim(gtParam4RegCas.pRifDocFat)) > 0 Then
               'printRecMessage|1|4|1|1|Prima Riga Aggiuntiva Tipo 4
               vStrRiga = "printRecMessage|1|4|1|1|" & gtParam4RegCas.pRifDocFat
               Print #NumFile, vStrRiga 'Stampo la stringa nel File
            End If
         
     
         'Eventuali SCONTI sul DOCUMENTO
            If vTotCalcolato > gtParam4RegCas.pImpTotale Then
               'If mScontoPercent = True Then 'Controllo se  in PERCENTUALE...
                  vStrRiga = RowScontrEPSON_MF(-1, "SCN_DOC", 0, (vTotCalcolato - gtParam4RegCas.pImpTotale))  'Compongo la stringa SCONTO RIGA
                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
               'Else                          '...oppure se  a VALORE
               '   'Stampo il Subtotale
               '      vStrRiga = "3003"
               '         Print #NumFile, vStrRiga 'Stampo la stringa nel File
               '   '-------------------
               '   vStrRiga = RowScontrEPSON_MF(0, "SCN_DOC_DOC", (vTotCalcolato - gtParam4RegCas.pImpTotale))   'Compongo la stringa SCONTO RIGA
               '      Print #NumFile, vStrRiga 'Stampo la stringa nel File
               'End If
            End If
     
     
         'Stampa del Codice Fiscale
            If Len(gtParam4RegCas.pCodFisc) > 0 Then '(TESTATO = OK!)
               vStrRiga = RowScontrEPSON_MF(-1, "CODFIS", 0, 0, "C.F.: " & gtParam4RegCas.pCodFisc & "")
               Print #NumFile, vStrRiga 'Stampo la stringa nel File
            End If
     
         'Stampo la riga di Cortesia con il totale dei Punti Fedelet accumulati
            If gtParam4RegCas.pPuntiFid > 0 Then
               vStrRiga = RowScontrEPSON_MF(-1, "MSG", 0, 0, ">>> PUNTI FIDELITY: " & Trim(Str(gtParam4RegCas.pPuntiFid)) & " <<<") 'Inserisco la riga con le Quantit
               Print #NumFile, vStrRiga 'Stampo la stringa nel File
            End If
     
     
         'Riga di chiusura del SUBTOTALE
            vStrRiga = RowScontrEPSON_MF(-1, "CHI_TOT", 0)
            Print #NumFile, vStrRiga 'Stampo la stringa nel File
     
     
         'Stringa di IMPORTO RICEVUTO
         'If gtParam4RegCas.pImpRicPerScontrino > gtParam4RegCas.pImpTotale Then
         vStrRiga = RowScontrEPSON_MF(-1, "IMP_RIC", 0, IIf(gtParam4RegCas.pImpRicPerScontrino > gtParam4RegCas.pImpTotale, gtParam4RegCas.pImpRicPerScontrino, gtParam4RegCas.pImpTotale))
         Print #NumFile, vStrRiga 'Stampo la stringa nel File
         'End If
                  
         'Chiudo il file di LOG
         Close #NumFile
         
      End With
         
      Call GestFileScontrino("scontrino.txt")
      
   Else
   
      'Qui se trattasi di RISTAMPA di ULTIMO SCONTRINO lo copio direttamente dalla cartella di storico _
       nella cartella di destinazione senza passare dall sub GestFileScontrino ( inutile)
      FileCopy PathREGCAS & "\Storico\" & gtParam4RegCas.pRistScontrino, vPathScontrino & "scontrino.txt"
   
   End If
      
      
'SE ARRIVA QUI ALLORA E' ANDATO TUTTO A BUON FINE _
   ULTIMO CONTROLLO E' SUL FILE DI ESITO
   EpsonSetFileScontrino_MF = True
      
End Function
Private Function RowScontrEPSON_MF(pRiga As Integer, pTipo As String, pReparto As Byte, Optional pValore As Currency, Optional pTesto As String) As String
   Dim vDescr As String
   Dim vVal As Currency
   'Compone la riga dello scontrino per EPSON

   With mpGridScontrino
      
      'Se una riga con descrizione allora tolgo eventuali parentesi dalla descrizione
      If pRiga > -1 Then
         vDescr = Trim(Mid(.Rows(pRiga).Record.Item(gtParam4RegCas.pColCodArt + 1).Value, 1, 32))
         vDescr = PulisciDescrizioneScontrino(vDescr)
      End If
      
      
      If pTipo = "STD" Or pTipo = "RESO" Then 'riga STANDARD o Reso (SONO IDENTICHE CAMBIA SOLO IL COMANDO)
         'printRecItem|1|Vendita Reparto Iva 10%|1|100,0|15|1
         If pTipo = "RESO" Then
            RowScontrEPSON_MF = "printRecRefund|1"  'Comando e Operatore (fisso)
            vVal = .Rows(pRiga).Record.Item(gtParam4RegCas.pColPrezzo).Value * (-1) 'Prezzo ma devo renderlo positivo
         Else
            RowScontrEPSON_MF = "printRecItem|1"  'Comando e Operatore (fisso)
            vVal = .Rows(pRiga).Record.Item(gtParam4RegCas.pColPrezzo).Value 'Prezzo
            
            'Se l'importo  negativo e non si tratta di reso allora  uno storno dal Prepagato
            If vVal < 0 Then ' in questo caso si tratta di riga di scarico dal prepagato
               RowScontrEPSON_MF = "printRecVoidItem|1"  'Comando e Operatore (fisso)
               vVal = .Rows(pRiga).Record.Item(gtParam4RegCas.pColPrezzo).Value * (-1) 'Prezzo ma devo renderlo positivo
            End If
         End If
         RowScontrEPSON_MF = RowScontrEPSON_MF & "|" & vDescr & "" 'Descrizione
         RowScontrEPSON_MF = RowScontrEPSON_MF & "|" & Replace(FormattaNumero(.Rows(pRiga).Record.Item(gtParam4RegCas.pColQuanti).Value, pred_DecimaliQta, 1), ".", ",") & "" 'Quantit
         RowScontrEPSON_MF = RowScontrEPSON_MF & "|" & Replace(FormattaNumero(CDbl(vVal), pred_DecimaliImp, 1), ".", ",") & "" 'Prezzo
         RowScontrEPSON_MF = RowScontrEPSON_MF & "|" & pReparto & "|1" 'Reparto + Allineamento testo a display (1=mostra i primi 20 caratteri)

         'Qui controllo subito se per caso c' uno sconto di riga e creo subito la riga andando a capo...
         If CCur(.Rows(pRiga).Record.Item(gtParam4RegCas.pColScont1).Value) > 0 Then
            'printRecItemAdjustment|1|Sconto su singolo prodotto|0|50,00|1|2
            RowScontrEPSON_MF = RowScontrEPSON_MF & vbNewLine
            
            'Inizia la riga dello sconto
            If CCur(.Rows(pRiga).Record.Item(gtParam4RegCas.pColScont1).Value) = 100 Then 'OMAGGIO = 100% DI SCONTO
               vDescr = "- - -  O M A G G I O   - - -"
            Else                                                           'SCOBTO NORMALE
               vDescr = "   S C O N T 0   " & Format(.Rows(pRiga).Record.Item(gtParam4RegCas.pColScont1).Value, "##0.#0") & "%"
            End If
            RowScontrEPSON_MF = RowScontrEPSON_MF & "printRecItemAdjustment|1"  'Comando e Operatore (fisso)
            RowScontrEPSON_MF = RowScontrEPSON_MF & "|" & vDescr & "" 'Descrizione
            RowScontrEPSON_MF = RowScontrEPSON_MF & "|0" 'Sconto normale
            vVal = CCur(.Rows(pRiga).Record.Item(gtParam4RegCas.pColPrzQta).Value) - CCur(.Rows(pRiga).Record.Item(gtParam4RegCas.pColImpNet).Value)  'calcolo l'importo da scontare moltiplicando la quantit con il prezzo unitario e sottraendo l'importo netto
            RowScontrEPSON_MF = RowScontrEPSON_MF & "|" & Replace(FormattaNumero(CDbl(vVal), pred_DecimaliImp, 1), ".", ",") & "" 'Importo da scontare
            RowScontrEPSON_MF = RowScontrEPSON_MF & "|" & pReparto & "|1" 'Reparto + Allineamento testo a display (1=mostra i primi 20 caratteri)
         End If
      
      ElseIf pTipo = "SCN_DOC" Then 'riga SCONTO DOCUMENTO IN PERCENTUALE
         'printRecSubtotalAdjustment|1|Sconto sul subtotal|1|50,00|1|1
         If gtParam4RegCas.pScontoPercent = True Then
            vDescr = "S C O N T 0   " & Format(gtParam4RegCas.pScontoDoc, "##0.#0") & "%"
         Else
            vDescr = "S C O N T 0"
         End If
         RowScontrEPSON_MF = "printRecSubtotalAdjustment|1"  'Comando e Operatore (fisso)
         RowScontrEPSON_MF = RowScontrEPSON_MF & "|" & vDescr & "" 'Descrizione
         RowScontrEPSON_MF = RowScontrEPSON_MF & "|1" 'Sconto con esposizione normale
         RowScontrEPSON_MF = RowScontrEPSON_MF & "|" & Replace(FormattaNumero(CDbl(pValore), 2, 1), ".", ",") & "" 'Importo da scontare
         RowScontrEPSON_MF = RowScontrEPSON_MF & "|1|1" 'Valore Fisso + Allineamento testo a display (1=mostra i primi 20 caratteri)
      
      ElseIf pTipo = "IMP_RIC" Then 'riga IMPORTO RICEVUTO
         'printRecTotal|4|Pagamento Cash|700,0|0|0|2
         RowScontrEPSON_MF = "printRecTotal|1"  'Comando e Operatore (fisso)
         RowScontrEPSON_MF = RowScontrEPSON_MF & "|Pagamento" 'Descrizione
         RowScontrEPSON_MF = RowScontrEPSON_MF & "|" & Replace(FormattaNumero(CDbl(pValore), 2, 1), ".", ",") & "" 'Importo da scontare
         RowScontrEPSON_MF = RowScontrEPSON_MF & "|0|0|1" 'Tipo Pagamento + Valore Fisso + Allineamento testo a display (1=mostra i primi 20 caratteri)
      
      ElseIf pTipo = "CHI_TOT" Then 'riga DI CHIUSURA SUBTOTAL
         'printRecSubtotal|1|1
         RowScontrEPSON_MF = "printRecSubtotal|1|1"  'Comando + Operatore (fisso) + Tipo Esposizione
      
      ElseIf pTipo = "CODFIS" Then
         'printRecMessage|1|2|1|1|Prima Riga Aggiuntiva Tipo 2
         'printRecMessage|1|2|2|1|Seconda Riga Aggiuntiva Tipo 2
         
         RowScontrEPSON_MF = "printRecMessage|1"  'Comando e Operatore (fisso)
         RowScontrEPSON_MF = RowScontrEPSON_MF & "|2" 'Tipo Riga
         RowScontrEPSON_MF = RowScontrEPSON_MF & "|1" 'Progressivo riga
         RowScontrEPSON_MF = RowScontrEPSON_MF & "|1" 'Tipo carattere
         RowScontrEPSON_MF = RowScontrEPSON_MF & "|" & String(32, "-") 'Tipo carattere
         'RowScontrEPSON_MF = RowScontrEPSON_MF & "| " 'Tipo carattere
         
         RowScontrEPSON_MF = RowScontrEPSON_MF & vbNewLine
         RowScontrEPSON_MF = RowScontrEPSON_MF & "printRecMessage|1"  'Comando e Operatore (fisso)
         RowScontrEPSON_MF = RowScontrEPSON_MF & "|2" 'Tipo Riga
         RowScontrEPSON_MF = RowScontrEPSON_MF & "|2" 'Progressivo riga
         RowScontrEPSON_MF = RowScontrEPSON_MF & "|2" 'Tipo carattere
         RowScontrEPSON_MF = RowScontrEPSON_MF & "|" & pTesto 'Tipo carattere
         
         RowScontrEPSON_MF = RowScontrEPSON_MF & vbNewLine
         RowScontrEPSON_MF = RowScontrEPSON_MF & "printRecMessage|1"  'Comando e Operatore (fisso)
         RowScontrEPSON_MF = RowScontrEPSON_MF & "|2" 'Tipo Riga
         RowScontrEPSON_MF = RowScontrEPSON_MF & "|3" 'Progressivo riga
         RowScontrEPSON_MF = RowScontrEPSON_MF & "|1" 'Tipo carattere
         RowScontrEPSON_MF = RowScontrEPSON_MF & "|" & String(32, "-") 'Tipo carattere
         'RowScontrEPSON_MF = RowScontrEPSON_MF & "| " 'Tipo carattere

      ElseIf pTipo = "MSG" Then
         'printRecMessage|1|2|1|1|Prima Riga Aggiuntiva Tipo 2
         'printRecMessage|1|2|2|1|Seconda Riga Aggiuntiva Tipo 2
         
         'Devo fare questo controllo perch le righe descrittive devo avere sempre il progressivo di riga consecutivo e quindi mi devo regolare iun base alla presenza del Codice Fiscale
         Dim vPrgRiga As Byte
         If Len(gtParam4RegCas.pCodFisc) > 0 Then
            vPrgRiga = 4
         Else
            vPrgRiga = 1
         End If
         
         RowScontrEPSON_MF = "printRecMessage|1"  'Comando e Operatore (fisso)
         RowScontrEPSON_MF = RowScontrEPSON_MF & "|2" 'Tipo Riga
         RowScontrEPSON_MF = RowScontrEPSON_MF & "|" & Trim(Str(vPrgRiga)) 'Progressivo riga
         RowScontrEPSON_MF = RowScontrEPSON_MF & "|1" 'Tipo carattere
         RowScontrEPSON_MF = RowScontrEPSON_MF & "|" & String(32, "*") 'Tipo carattere
         'RowScontrEPSON_MF = RowScontrEPSON_MF & "| " 'Tipo carattere
         vPrgRiga = vPrgRiga + 1
         
         RowScontrEPSON_MF = RowScontrEPSON_MF & vbNewLine
         RowScontrEPSON_MF = RowScontrEPSON_MF & "printRecMessage|1"  'Comando e Operatore (fisso)
         RowScontrEPSON_MF = RowScontrEPSON_MF & "|2" 'Tipo Riga
         RowScontrEPSON_MF = RowScontrEPSON_MF & "|" & Trim(Str(vPrgRiga)) 'Progressivo riga
         RowScontrEPSON_MF = RowScontrEPSON_MF & "|2" 'Tipo carattere
         RowScontrEPSON_MF = RowScontrEPSON_MF & "|" & pTesto 'Tipo carattere
         vPrgRiga = vPrgRiga + 1
         
         RowScontrEPSON_MF = RowScontrEPSON_MF & vbNewLine
         RowScontrEPSON_MF = RowScontrEPSON_MF & "printRecMessage|1"  'Comando e Operatore (fisso)
         RowScontrEPSON_MF = RowScontrEPSON_MF & "|2" 'Tipo Riga
         RowScontrEPSON_MF = RowScontrEPSON_MF & "|" & Trim(Str(vPrgRiga)) 'Progressivo riga
         RowScontrEPSON_MF = RowScontrEPSON_MF & "|1" 'Tipo carattere
         RowScontrEPSON_MF = RowScontrEPSON_MF & "|" & String(32, "*") 'Tipo carattere
         'RowScontrEPSON_MF = RowScontrEPSON_MF & "| " 'Tipo carattere

      End If

   End With
   
End Function



Private Function Scontrino_DITRON(pCausalDoc As String, pSerial As Long) As Boolean
   Dim NumFile As Integer 'per aprire il file di esecuzioni(LOG)
   Dim vStrRiga As String
   Dim i As Integer
   Dim vStrImpRicevuto As String
   Dim vTotCalcolato As Currency
   Dim vPathEsito As String
   Dim vApriCassetto As String
   Dim vVal As String
   
   mTotImpArt = 0
   'Qui prendo il PATH dove creare il file dello scontrino da stampare
   
   Scontrino_DITRON = False
   
   mPathDestScontrino = ReadINI("PARAMETRI", "PATH_IN", mPathFileConf4Scontrino)
   'Controllo che sia pieno
   If Len(Trim(mPathDestScontrino)) = 0 Then
      MsgBox "ATTENZIONE!" & vbNewLine & _
             "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
             "(Tag [PARAMETRI] Parametro <PATH_IN> non presente)" & vbNewLine & vbNewLine & _
             "Impossibile eseguire la stampa dello Scontrino.", vbCritical
      Exit Function
   End If
   
   vPathEsito = ReadINI("PARAMETRI", "PATH_OUT", mPathFileConf4Scontrino)
   'Controllo che sia pieno
   If Len(Trim(vPathEsito)) = 0 Then
      MsgBox "ATTENZIONE!" & vbNewLine & _
             "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
             "(Tag [PARAMETRI] Parametro <PATH_OUT> non presente)" & vbNewLine & vbNewLine & _
             "Impossibile eseguire la stampa dello Scontrino.", vbCritical
      Exit Function
   End If
   
   
   'Mi accerto che ci sia un valore numerico sull'opzione APERTURA CASSETTO
   vApriCassetto = ReadINI("PARAMETRI", "APRI_CASSETTO", mPathFileConf4Scontrino)
   If IsNumeric(vApriCassetto) = False Then vApriCassetto = "0"
   
   
   
   'controllo che non sia una ristampa ...
   If Len(gtParam4RegCas.pRistScontrino) = 0 Then
      
      '...altrimenti QUI INIZIO A COMPORRE LO SCONTRINO
      NumFile = FreeFile
      Open App.path & "\temp.txt" For Append As #NumFile      'CREO IL FILE
   
      Print #NumFile, "CLEAR" '        ;preme il tasto C"  'APERTURA SCONTRINO
      Print #NumFile, "CHIAVE REG" '   ;conferma che la cassa si trovi in assetto REGistrazione"  'seconda riga sempre uguale
      
      'Qui controllo se devo creare il file per aprire il cassetto che devo mandare prima _
       dello scontrino altrimenti a video non si legge l'importo dello scontrino
         If CInt(vApriCassetto) > 0 Then
            'inp term=37
            Print #NumFile, "INP TERM=37" 'APERTURA CASSETTO
         End If
      
      'QUI verifico se si tratta di FATTURA che per DITRON  identica allo Socntrino se non per il fatto che bisogna indicare il CLIENTE ed il tipo di Documento
         If pCausalDoc = "FA" Then 'FATTURA
            'Qui costruisco la Stringa con i dati del Cliente
            vStrRiga = RowScontrDITRON(-1, "FATTURA", 0, 0, gtParam4RegCas.pCodFisc, pSerial)
            Print #NumFile, vStrRiga 'Stampo la stringa nel File
               
         Else
         
         'Se si tratta di SCONTRINO allora verifico se devo stampare il CODICE FISCALE
         'Stampa del Codice Fiscale
            If Len(gtParam4RegCas.pCodFisc) > 0 Then '(TESTATO = OK!)
               vStrRiga = RowScontrDITRON(-1, "CODFIS", 0, 0, gtParam4RegCas.pCodFisc)
               Print #NumFile, vStrRiga 'Stampo la stringa nel File
            End If
      
         End If
      
      
      
      With mpGridScontrino
         vTotCalcolato = 0
         
         For i = 0 To .Rows.Count - 1
            vTotCalcolato = vTotCalcolato + .Rows(i).Record.Item(gtParam4RegCas.pColImpNet).Value


            'Qui verifico se c'e' l'associazione del Codice IVA con il Reparti del Registratore di Cassa
            vVal = ReadINI("REPARTIIVA_REPARTI", .Rows(i).Record.Item(gtParam4RegCas.pColRepIVA).Value, mPathFileConf4Scontrino)
            If Len(Trim(vVal)) > 0 Then vVal = Replace(UCase(vVal), "REPARTO", "")
            If IsNumeric(vVal) = False Then vVal = "1"
                        
                        
            'Controllo se si tratta di un RESO o di un articolo normale di vendita
            If .Rows(i).Record.Item(gtParam4RegCas.pColSimbol).Value = "R" Then
               vStrRiga = RowScontrDITRON(i, "RESO", CByte(vVal))  'Compongo la stringa di RESO
            Else
               vStrRiga = RowScontrDITRON(i, "STD", CByte(vVal))  'Compongo la stringa STANDARD
            End If
            Print #NumFile, vStrRiga 'Stampo la stringa nel File
         Next i
         
         
         'Verifico se devo inserire la riga di riferimento (vale per scontrini a 0 in presenza di Prepagati o Abbonamenti)
            If Len(Trim(gtParam4RegCas.pRifDocFat)) > 0 Then
               'prmsg riga='giacca'      ; tale comando permette di stampare una riga aggiuntiva all'interno di uno scontrino
               vStrRiga = RowScontrDITRON(-1, "RIGA_AGGIUNTIVA", 0, 0, Trim(gtParam4RegCas.pRifDocFat)) 'Inserisco la riga Aggiuntiva
               Print #NumFile, vStrRiga 'Stampo la stringa nel File
            End If
            
         
         'Stampo la riga di Cortesia con il totale dei Punti Fedelet accumulati
            If gtParam4RegCas.pPuntiFid > 0 Then
               vStrRiga = RowScontrDITRON(-1, "MSG", 0, 0, "> PUNTI FIDELITY: " & Trim(Str(gtParam4RegCas.pPuntiFid)) & " <") 'Inserisco la riga con le Quantit
               Print #NumFile, vStrRiga 'Stampo la stringa nel File
            End If
                        
     
         'Eventuali SCONTI sul DOCUMENTO
            If vTotCalcolato > gtParam4RegCas.pImpTotale Then
               vStrRiga = RowScontrDITRON(-1, "SCN_DOC", 0, (vTotCalcolato - gtParam4RegCas.pImpTotale))  'Compongo la stringa SCONTO RIGA
               Print #NumFile, vStrRiga 'Stampo la stringa nel File
            End If
     
     
         'Riga di chiusura del SUBTOTALE
            vStrRiga = "CHIUS T=1"      ';Chiusura in contanti

   '        'Stringa di IMPORTO RICEVUTO
            If gtParam4RegCas.pImpRicPerScontrino < gtParam4RegCas.pImpTotale Then ' - - - VERIFICO SE C' UN SOSPESO (il RESTO l'ho sospeso perch mi dava un errore anche se lo scontrino sembrava OK!)
'               chius t=1, imp=10.00   ; Chiude parzialmente lo scontrino (10) in contanti
'               chius t=2              ; Chiude il restante da pagare (10) a credito (non pagato)
               vStrRiga = vStrRiga & ", imp=" & Replace(Format(gtParam4RegCas.pImpRicPerScontrino, "########0.#0"), ",", ".")
               vStrRiga = vStrRiga & vbNewLine
               vStrRiga = vStrRiga & "CHIUS t=2"
            End If
            Print #NumFile, vStrRiga
         
                  
         'Chiudo il file di LOG
         Close #NumFile
         
      End With
         
      Call GestFileScontrino("scontrino.txt")
      
   Else
   
      'Qui se trattasi di RISTAMPA di ULTIMO SCONTRINO lo copio direttamente dalla cartella di storico _
       nella cartella di destinazione senza passare dall sub GestFileScontrino ( inutile)
      FileCopy PathREGCAS & "\Storico\" & gtParam4RegCas.pRistScontrino, mPathDestScontrino & "scontrino.txt"
   
   End If
      
      
'SE ARRIVA QUI ALLORA E' ANDATO TUTTO A BUON FINE _
   ULTIMO CONTROLLO E' SUL FILE DI ESITO
   Scontrino_DITRON = True
      
End Function

Private Function RowScontrDITRON(pRiga As Integer, pTipo As String, pReparto As Byte, _
                                 Optional pValore As Currency, Optional pTesto As String, _
                                 Optional pSerial) As String
   Dim vDescr As String
   Dim vVal As Currency
   Dim vStorno As Boolean
   
   Dim RS As ADODB.Recordset
   Dim strRicerca As String
'   Dim vNumDoc As String
'   Dim vCliRagSoc As String
'   Dim vCliIndiri As String
'   Dim vCliLocali As String
'   Dim vCliParIva As String
'   Dim vCliCodFis As String
   


   With mpGridScontrino
      
      'Se una riga con descrizione allora tolgo eventuali parentesi dalla descrizione
      If pRiga > -1 Then
         vDescr = Trim(Mid(.Rows(pRiga).Record.Item(gtParam4RegCas.pColCodArt + 1).Value, 1, 32))
         vDescr = PulisciDescrizioneScontrino(vDescr)
      End If
      
      
      If pTipo = "STD" Or pTipo = "RESO" Then 'riga STANDARD o Reso (SONO IDENTICHE CAMBIA SOLO IL LA DICITURA "RESO" ALLA FINE DELLA RIGA)
                     
               'R I G A    T I P O:  - - - >    vend rep=1,pre=0.80,des='Caffe''',qty=2
         'AZIONE
            RowScontrDITRON = "vend "
         'REPARTO
            RowScontrDITRON = RowScontrDITRON & "rep=" & Trim(Str(pReparto)) & ","
         'PREZZO
            If .Rows(pRiga).Record.Item(gtParam4RegCas.pColPrezzo).Value < 0 Then 'PERZZO MINORE DI 0
               RowScontrDITRON = RowScontrDITRON & "pre=" & Replace(Format(.Rows(pRiga).Record.Item(gtParam4RegCas.pColPrezzo).Value * (-1), "#####0.#0"), ",", ".") & "," 'Prezzo NEGATIVO
               vStorno = True
            Else
               RowScontrDITRON = RowScontrDITRON & "pre=" & Replace(Format(.Rows(pRiga).Record.Item(gtParam4RegCas.pColPrezzo).Value, "#####0.#0"), ",", ".") & "," 'Prezzo NORMALE
            End If
         'DESCRIZIONE
            RowScontrDITRON = RowScontrDITRON & "des='" & vDescr & "'"
         'QUANTITA' (la inserisco solo se <> 1)
            If CCur(.Rows(pRiga).Record.Item(gtParam4RegCas.pColQuanti).Value) <> 1 Then
               RowScontrDITRON = RowScontrDITRON & ",qty=" & Replace(.Rows(pRiga).Record.Item(gtParam4RegCas.pColQuanti).Value, ",", ".") 'Quantit
            End If
         
         'EVENTUALE RESO
            If pTipo = "RESO" Then
               RowScontrDITRON = RowScontrDITRON & ", reso"
            Else
               If vStorno Then
                  RowScontrDITRON = RowScontrDITRON & ", storno"
               End If
            End If

         'SCONTO DI RIGA
         If CCur(.Rows(pRiga).Record.Item(gtParam4RegCas.pColScont1).Value) > 0 Then
            'perca aliq=25
            RowScontrDITRON = RowScontrDITRON & vbNewLine 'VADO A CAPO
            If CCur(.Rows(pRiga).Record.Item(gtParam4RegCas.pColScont1).Value) = 100 Then
               RowScontrDITRON = RowScontrDITRON & "perca aliq=99.99"
            Else
               RowScontrDITRON = RowScontrDITRON & "perca aliq=" & Replace(CCur(.Rows(pRiga).Record.Item(gtParam4RegCas.pColScont1).Value), ",", ".")
            End If
         End If
      
      
      ElseIf pTipo = "RIGA_AGGIUNTIVA" Then
         'prmsg riga='giacca'      ; tale comando permette di stampare una riga aggiuntiva all'interno di uno scontrino
         RowScontrDITRON = "prmsg riga='" & pTesto & "'"  'Riga AGGIUNTIVA
      
      
      ElseIf pTipo = "SCN_DOC" Then 'riga SCONTO DOCUMENTO IN PERCENTUALE
         'Sconto val=5.00,subtot    >A VALORE
         'perca aliq=50,subtot      >IN %
         If gtParam4RegCas.pScontoPercent = True Then
            'vDescr = "S C O N T 0   " & Format(gtParam4RegCas.pScontoDoc, "##0.#0") & "%"
            RowScontrDITRON = "perca aliq=" & Replace(Format(gtParam4RegCas.pScontoDoc, "##0.#0"), ",", ".") & ",subtot"
         Else
            RowScontrDITRON = "Sconto val=" & Replace(Format(gtParam4RegCas.pScontoDoc, "########0.#0"), ",", ".") & ",subtot"
         End If
      
      
'''      ElseIf pTipo = "IMP_RIC" Then 'riga IMPORTO RICEVUTO
'''         'printRecTotal|4|Pagamento Cash|700,0|0|0|2
'''         RowScontrDITRON = "printRecTotal|1"  'Comando e Operatore (fisso)
'''         RowScontrDITRON = RowScontrDITRON & "|Pagamento" 'Descrizione
'''         RowScontrDITRON = RowScontrDITRON & "|" & Replace(FormattaNumero(CDbl(pValore), 2, 1), ".", ",") & "" 'Importo da scontare
'''         RowScontrDITRON = RowScontrDITRON & "|0|0|1" 'Tipo Pagamento + Valore Fisso + Allineamento testo a display (1=mostra i primi 20 caratteri)
      
'''      ElseIf pTipo = "CHI_TOT" Then 'riga DI CHIUSURA SUBTOTAL
'''         'printRecSubtotal|1|1
'''         RowScontrDITRON = "printRecSubtotal|1|1"  'Comando + Operatore (fisso) + Tipo Esposizione
      
      ElseIf pTipo = "CODFIS" Then
         '**************************   A T T E N Z I O N E   *****************************
         'QUESTA FUNZIONE CONTROLLA LA CORRETTEZZA DELL'ULTIMA LETTERA DEL CODICE FISCALE
         'E SE NON CORRETTO NON LO STAMPA ED IL REGISTRATORE DI CASSA EMETTE UN SUONO
         '********************************************************************************
         RowScontrDITRON = "INP TERM=61"
         RowScontrDITRON = RowScontrDITRON & vbNewLine & "INP ALFA='" & Trim(pTesto) & "',TERM=49"
         

      ElseIf pTipo = "MSG" Then
         'CORT R1='PROVA MESSAGGIO 1',R2='PROVA MESSAGGIO 2'    ;messaggio di cortesia
         RowScontrDITRON = "CORT R1='" & pTesto & "'"  'Riga MESSAGGI
         'RowScontrDITRON = RowScontrDITRON & vbNewLine & _
                           "alleg fine"  'Chiusura MESSAGGI
      
      
      ElseIf pTipo = "FATTURA" Then 'Costruisco la stringa della FATTURA con il riferimneto del Cliente
         'Fattura tipo=2, nome1='Ditron S.r.l.', nome2='Via Antiniana 115', nome3='80078 - Pozzuoli (Na)', nome4='Tel. 0812428557'
         strRicerca = "SELECT ANDESCRI, ANINDIRI, AN___CAP, ANLOCALI, ANPROVIN, ANCODFIS, ANPARIVA " & _
                      "FROM [" & Azienda & "DOC_MAST] INNER JOIN [" & Azienda & "CONTI] ON ([" & Azienda & "DOC_MAST].MVCODCON = [" & Azienda & "CONTI].ANCODICE) AND ([" & Azienda & "DOC_MAST].MVTIPCON = [" & Azienda & "CONTI].ANTIPCON) " & _
                      "WHERE MVSERIAL = " & pSerial
         Set RS = New ADODB.Recordset
         RS.Open strRicerca, ConnessioneGenerale, adOpenStatic
         If Not RS.EOF Then
            
            RowScontrDITRON = "Fattura tipo=2"
            RowScontrDITRON = RowScontrDITRON & ", nome1='" & Trim(RS!ANDESCRI) & "'"
            RowScontrDITRON = RowScontrDITRON & ", nome2='" & Trim(NonNullo(RS!ANINDIRI)) & "'"
            RowScontrDITRON = RowScontrDITRON & ", nome3='" & Trim(NonNullo(RS!AN___CAP)) & " - " & _
                                                              Trim(NonNullo(RS!ANLOCALI)) & " " & _
                                                              Trim(NonNullo(RS!ANPROVIN)) & "'"
            
            If Len(Trim(NonNullo(RS!ANPARIVA))) > 0 Then 'Do priorit alla PARTITA IVA ...
               RowScontrDITRON = RowScontrDITRON & ", nome4='P.IVA: " & Trim(RS!ANPARIVA) & "'"
            Else     '... ma se manca allora provo a stampare il CODICE FISCALE
               If Len(Trim(NonNullo(RS!ANCODFIS))) > 0 Then
                  RowScontrDITRON = RowScontrDITRON & ", nome4='C.F.: " & Trim(RS!ANCODFIS) & "'"
               End If
            End If
            'NB: non posso stampare ENTRAMBE perch i codici "nome" sono da 1 a 4
         End If
         RS.Close
         Set RS = Nothing
      
      End If

   End With
   
End Function



Private Function RowScontrOLIVETTI_NETTUNA(pRiga As Integer, pTipo As String) As String
   Dim vStrValScontoDoc As String
   Dim vDescr As String
   Dim vValIva As String

   With mpGridScontrino
      
      If pRiga > -1 Then
         'Compone la riga dello scontrino per OLIVETTI-NETTUTA (SOFTWARE "ELA EXECUTE")
         vDescr = .Rows(pRiga).Record.Item(gtParam4RegCas.pColCodArt + 1).Value
         vDescr = PulisciDescrizioneScontrino(vDescr)
      End If
      
      Select Case pTipo
         Case "STD" 'riga STANDARD
            RowScontrOLIVETTI_NETTUNA = "1325;" 'CODICE COMANDO
            RowScontrOLIVETTI_NETTUNA = RowScontrOLIVETTI_NETTUNA & FormattaNumero(.Rows(pRiga).Record.Item(gtParam4RegCas.pColPrzQta).Value, 2, 1) & ";" 'Prezzo Totale di Riga
            RowScontrOLIVETTI_NETTUNA = RowScontrOLIVETTI_NETTUNA & vDescr & ";" 'Descrizione
            vValIva = DecodTGValoreTABGEN("CODIVA", "TGCODICE", .Rows(pRiga).Record.Item(gtParam4RegCas.pColCodIva + 1).Value)  'Prendo il valore dell'aliquota IVA
            RowScontrOLIVETTI_NETTUNA = RowScontrOLIVETTI_NETTUNA & Trim(vValIva) & ";" 'IVA
            If CCur(.Rows(pRiga).Record.Item(gtParam4RegCas.pColQuanti).Value) > 1 Then 'Se le quantit  maggiore di 1 allora insersico il parametro Qt x Prz che poi  solo descrittivo!)
               RowScontrOLIVETTI_NETTUNA = RowScontrOLIVETTI_NETTUNA & FormattaNumero(.Rows(pRiga).Record.Item(gtParam4RegCas.pColQuanti).Value, 2, 1) & "x" & FormattaNumero(.Rows(pRiga).Record.Item(gtParam4RegCas.pColPrezzo).Value, 2, 1) & ";" 'Riga Qt x Prz
            Else
               RowScontrOLIVETTI_NETTUNA = RowScontrOLIVETTI_NETTUNA & ";"  'Riga Qt x Prz
            End If
            RowScontrOLIVETTI_NETTUNA = RowScontrOLIVETTI_NETTUNA & "0" 'Attributo (Chiusura Riga)
         
'         Case "RESO" 'riga RESO
'            If Len(vDescr) < 20 Then vDescr = vDescr & Space(20 - Len(vDescr))
'            RowScontrOLIVETTI_NETTUNA = "9" & vDescr & "" ' Descrizione
'            RowScontrOLIVETTI_NETTUNA = RowScontrOLIVETTI_NETTUNA & Replace(Replace(.Rows(pRiga).Record.Item(gtParam4RegCas.pColPrezzo), ",", ""), "-", "") & "11" 'Prezzo
'            RowScontrOLIVETTI_NETTUNA = RowScontrOLIVETTI_NETTUNA & .Rows(pRiga).Record.Item(gtParam4RegCas.pColQuanti) & "000" 'Quantita
         
         Case "SCN_RIG" 'riga SCONTO RIGA %
            RowScontrOLIVETTI_NETTUNA = "1327;" 'CODICE COMANDO
            vDescr = CCur(.Rows(pRiga).Record.Item(gtParam4RegCas.pColPrzQta).Value) - CCur(.Rows(pRiga).Record.Item(gtParam4RegCas.pColImpNet).Value)
            vDescr = Replace(Format(vDescr, "#######0.#0"), ".", ",")
            RowScontrOLIVETTI_NETTUNA = RowScontrOLIVETTI_NETTUNA & vDescr & ";" 'Importo da scontare
            RowScontrOLIVETTI_NETTUNA = RowScontrOLIVETTI_NETTUNA & .Rows(pRiga).Record.Item(gtParam4RegCas.pColScont1).Value & "%" 'Desrizione della percentuale IVA applicata
         
         Case "SCN_DOC_PER" 'riga SCONTO DOCUMENTO IN PERCENTUALE
            RowScontrOLIVETTI_NETTUNA = "1327;" 'CODICE COMANDO
            vStrValScontoDoc = Replace(Format(mTotImpArt - gtParam4RegCas.pImpTotale, "########0.#0"), ".", ",")
            RowScontrOLIVETTI_NETTUNA = RowScontrOLIVETTI_NETTUNA & vStrValScontoDoc & ";" 'Importo da scontare
            RowScontrOLIVETTI_NETTUNA = RowScontrOLIVETTI_NETTUNA & gtParam4RegCas.pScontoDoc & "%"  'Desrizione della percentuale IVA applicata
         
         Case "SCN_DOC_DOC" 'riga SCONTO DOCUMENTO A VALORE
            RowScontrOLIVETTI_NETTUNA = "1327;" 'CODICE COMANDO
            vStrValScontoDoc = Replace(Format(gtParam4RegCas.pScontoDoc, "########0.#0"), ".", ",")
            RowScontrOLIVETTI_NETTUNA = RowScontrOLIVETTI_NETTUNA & vStrValScontoDoc & ";" 'Importo da scontare
      End Select
      
   End With
   
End Function


Private Sub Scontrino_MCT_RCH()
   Dim NumFile As Integer 'per aprire il file di esecuzioni(LOG)
   Dim vStrRiga As String
   Dim i As Integer
   Dim vStrImpRicevuto As String
   'Dim vPathScontrino As String
   Dim vPathMultidriver As String
   Dim vTipConn As String
   Dim vNumPort As String
   Dim vParamet As String
   Dim vFileIni As String
   Dim vFileExe As String
   Dim pVal As String
  
   On Error GoTo GestErr
  
'CONTROLLI SUI VALORI
   'Qui prendo il PATH dove sono presenti i File Multidriver.ini (per il Path di posizionamento dello scontrino) e il file MULTIDRIVER_APP.exe che stampa lo scontrino
      vPathMultidriver = ReadINI("MULTIDRIVER", "PATH", mPathFileConf4Scontrino)
      If Len(Trim(vPathMultidriver)) = 0 Then
         MsgBox "ATTENZIONE!" & vbNewLine & _
                "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
                "(Tag [MULTIDRIVER] Parametro <PATH> non presente)" & vbNewLine & vbNewLine & _
                "Impossibile eseguire la stampa dello Scontrino.", vbCritical
         Exit Sub
      End If
   'Qui prendo il TIPO CONNESSIONE da passare nel file scontrino
      vTipConn = ReadINI("MULTIDRIVER", "TIP_CONN", mPathFileConf4Scontrino)
      If Len(Trim(vTipConn)) = 0 Then
         MsgBox "ATTENZIONE!" & vbNewLine & _
                "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
                "(Tag [MULTIDRIVER] Parametro <TIP_CONN> non presente)" & vbNewLine & vbNewLine & _
                "Impossibile eseguire la stampa dello Scontrino.", vbCritical
         Exit Sub
      End If
   'Qui prendo il NUMERO DI PORTA da passare nel file scontrino
      vNumPort = ReadINI("MULTIDRIVER", "NUM_PORT", mPathFileConf4Scontrino)
      If Len(Trim(vNumPort)) = 0 Then
         MsgBox "ATTENZIONE!" & vbNewLine & _
                "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
                "(Tag [MULTIDRIVER] Parametro <NUM_PORT> non presente)" & vbNewLine & vbNewLine & _
                "Impossibile eseguire la stampa dello Scontrino.", vbCritical
         Exit Sub
      End If
   'Qui prendo i PARAMTERI da passare nel file scontrino
      vParamet = ReadINI("MULTIDRIVER", "PARAMET", mPathFileConf4Scontrino)
      If Len(Trim(vParamet)) = 0 Then
         MsgBox "ATTENZIONE!" & vbNewLine & _
                "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
                "(Tag [MULTIDRIVER] Parametro <PARAMET> non presente)" & vbNewLine & vbNewLine & _
                "Impossibile eseguire la stampa dello Scontrino.", vbCritical
         Exit Sub
      End If
   'Qui prendo il nome del File INI da dove prendere il Path dove creare il file SCONTRINO.inp
      vFileIni = ReadINI("FILE", "INI", mPathFileConf4Scontrino)
      If Len(Trim(vFileIni)) = 0 Then
         MsgBox "ATTENZIONE!" & vbNewLine & _
                "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
                "(Tag [FILE] Parametro <INI> non presente)" & vbNewLine & vbNewLine & _
                "Impossibile eseguire la stampa dello Scontrino.", vbCritical
         Exit Sub
      End If
   'Qui prendo il nome del File EXE che dovr eseguire per effettuare la stampa dello scontrino
      vFileExe = ReadINI("FILE", "EXE", mPathFileConf4Scontrino)
      If Len(Trim(vFileIni)) = 0 Then
         MsgBox "ATTENZIONE!" & vbNewLine & _
                "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
                "(Tag [FILE] Parametro <EXE> non presente)" & vbNewLine & vbNewLine & _
                "Impossibile eseguire la stampa dello Scontrino.", vbCritical
         Exit Sub
      End If

      mPathDestScontrino = ReadINI("Settings", "PATH_IN", vPathMultidriver & vFileIni)
      If Len(Trim(mPathDestScontrino)) = 0 Then
         MsgBox "ATTENZIONE!" & vbNewLine & _
                "Il file di configurazione " & vFileIni & "  incompleto." & vbNewLine & _
                "(Tag [Settings] Parametro <PATH_IN> non presente)" & vbNewLine & vbNewLine & _
                "Impossibile eseguire la stampa dello Scontrino.", vbCritical
         Exit Sub
      End If
      
   'Qui prendo la linghezza della descrizine
      mLenDescri = ReadINI("PARAMETRI", "LEN_DESCR", mPathFileConf4Scontrino)
      If IsNumeric(mLenDescri) = False Then
         mLenDescri = "12"
      End If
'-------------------------------------------------------------------------------------------------
   
   
   'verifico che non si tratti di una ristampa...
   If Len(gtParam4RegCas.pRistScontrino) = 0 Then
      
      Dim vVal As String
      
      '...altrimenti QUI INIZIO A COMPORRE LO SCONTRINO ----------------------------------------------------------------
      NumFile = FreeFile
      Open App.path & "\temp.txt" For Append As #NumFile      'CREO IL FILE
      
      
      If vTipConn = "S" Then 'SOLO PER SERIALE
         vStrRiga = vNumPort:    Print #NumFile, vStrRiga 'Stampo la Porta (che per la Rete  l'IP+PORTA)
         vStrRiga = vParamet:    Print #NumFile, vStrRiga 'Stampo i parametri Seriali
      Else
         vStrRiga = vParamet:    Print #NumFile, vStrRiga 'Stampo i parametri Seriali
      End If
      
   
      'Qui passo il valore "K" fisso
         vStrRiga = "=x":    Print #NumFile, vStrRiga
         vStrRiga = "=K":    Print #NumFile, vStrRiga
   
   
      'Stampa del Codice Fiscale (NB: deve stare subito dopo del K di apertura altrimenti non viene stampato!)
         pVal = ReadINI("SCONTRINI", "NO_CODFIS", IniPath)
         If Not (pVal = "T") Then
            If Len(gtParam4RegCas.pCodFisc) > 0 Then
               Print #NumFile, "=" & Chr(34) & "/?C/(" & gtParam4RegCas.pCodFisc & ")"
            End If
         End If
   
   
      With mpGridScontrino
         
         For i = 0 To .Rows.Count - 1
            
            'Solo se la riga ha un valore >= 0 altrimenti salto perch il Multidriver NON gestisce le righe negative
            If .Rows(i).Record.Item(gtParam4RegCas.pColPrezzo).Value >= 0 Then
            
               'Qui verifico se c'e' l'associazione del Codice IVA con il Reparti del Registratore di Cassa
               vVal = ReadINI("REPARTIIVA_REPARTI", .Rows(i).Record.Item(gtParam4RegCas.pColRepIVA).Value, mPathFileConf4Scontrino)
               If Len(Trim(vVal)) > 0 Then vVal = Replace(UCase(vVal), "REPARTO", "")
               If IsNumeric(vVal) = False Then vVal = "1"
               
               
               'Controllo se si tratta di un RESO o di un articolo normale di vendita
               'If .CellBackColor = Colore("rosso1") Then
               If .Rows(i).Record.Item(gtParam4RegCas.pColSimbol).Value = "R" Then
                  vStrRiga = RowScontrMCT_RCH(i, "RESO", vVal) 'Compongo la stringa di RESO
               Else
                  vStrRiga = RowScontrMCT_RCH(i, "STD", vVal) 'Compongo la stringa STANDARD
               End If
               Print #NumFile, vStrRiga                  'Stampo la stringa nel File
               
               
               'Qui controllo se c' lo Sconto riga sull'Articolo
               If .Rows(i).Record.Item(gtParam4RegCas.pColScont1).Value > 0 Then
                  vStrRiga = RowScontrMCT_RCH(i, "SCN_RIG")   'Compongo la stringa SCONTO RIGA
                  Print #NumFile, vStrRiga                        'Stampo la stringa nel File
               End If
            
            End If
            
         Next i
         
         
         'Qui controllo se c' SCONTO sul Documento oppure un Valore di Scarico del Prepagato che _
          richiede un comportamento pari allo Scarico a Valore sul totale. _
          Questa  la soluzione adottata perch il Multidriver non gestisce le righe negative e, _
          pertanto, lo scarico di prepagato generava un errore. _
          Quindi se c' uno ScaricoPrepagato imposto il valore sulla variabile gtParam4RegCas.pScontoDoc in modo che venga _
          scalato dal totale
         If gtParam4RegCas.pPrepagUsato > 0 Then
            gtParam4RegCas.pScontoDoc = gtParam4RegCas.pPrepagUsato
            gtParam4RegCas.pScontoPercent = False 'non servirebbe perch se c' un Prepagato lo sconto  disabilitato, ma lo faccio per sicurezza
         End If
         If gtParam4RegCas.pScontoDoc > 0 Then
            If gtParam4RegCas.pScontoPercent Then  'Controllo se  in PERCENTUALE...
               vStrRiga = RowScontrMCT_RCH(-1, "SCN_DOC_PER")   'Compongo la stringa SCONTO RIGA
               Print #NumFile, vStrRiga                            'Stampo la stringa nel File
            Else                          '...oppure se  a VALORE
               vStrRiga = RowScontrMCT_RCH(-1, "SCN_DOC_DOC")   'Compongo la stringa SCONTO RIGA
               Print #NumFile, vStrRiga                        'Stampo la stringa nel File
            End If
         End If
         
               
         'CONTROLLO SE DEVO INDICARE IL RESTO SULLO SCONTRINO
         If gtParam4RegCas.pImpRicPerScontrino > gtParam4RegCas.pImpTotale Then
            vStrImpRicevuto = Format(gtParam4RegCas.pImpRicPerScontrino, "#########.#0")
            vStrImpRicevuto = Replace(vStrImpRicevuto, ",", "")
            'RIGA DI CHIUSURA SCONTRINO
            Print #NumFile, "=T/$" & vStrImpRicevuto
         Else
            'vStrImpRicevuto = "0"
            'RIGA DI CHIUSURA SCONTRINO
            Print #NumFile, "=T"
         End If
                  
'         'Stampa del Codice Fiscale (MA NON L'HO POTUTO TESTARE PER MANCANZA DI APPARECCHIATURE!!!) _
'           Pertanto se mi viene segnalato che NON funziona mi basta creare nel ParGen il Tag [SCONTRINI] _
'           con parametro "NO_CODFIS=T" in modo da non far stampare il Codice Fiscale ed eliminare l'eventuale anomalia
'            pVal = ReadINI("SCONTRINI", "NO_CODFIS", IniPath)
'            If Not (pVal = "T") Then
'               If Len(gtParam4RegCas.pCodFisc) > 0 Then
'                  Print #NumFile, "=" & Chr(34) & "/?C/(" & gtParam4RegCas.pCodFisc & ")"
'               End If
'            End If
         
         'Stampo la riga di Cortesia con il totale dei Punti Fedelet accumulati
         If gtParam4RegCas.pPuntiFid > 0 Then
            Print #NumFile, "=" & Chr(34) & "/( )" ' Riga vuota ->    ="/( )
            Print #NumFile, "=" & Chr(34) & "/(*PUNTI CARD*)"
            Print #NumFile, "=" & Chr(34) & "/(" & Trim(Str(gtParam4RegCas.pPuntiFid)) & ")"
            Print #NumFile, "=" & Chr(34) & "/(************)"
            Print #NumFile, "=" & Chr(34) & "/( )" ' Riga vuota ->    ="/( )
         End If
         
         
         'Print #NumFile, "=c"
         
         
         'Chiudo il file di LOG
         Close #NumFile
         
         
         Call GestFileScontrino("SCONTRINO.INP")
         
      End With
      
   Else
   
      'Qui se trattasi di RISTAMPA di ULTIMO SCONTRINO lo copio direttamente dalla cartella di storico _
       nella cartella di destinazione senza passare dall sub GestFileScontrino ( inutile)
      FileCopy PathREGCAS & "\Storico\" & gtParam4RegCas.pRistScontrino, mPathDestScontrino & "SCONTRINO.INP"
      
   End If
      
      
      
      'ESEGUO LA STAMPA
         'NOTE: qui ho avuto il problema che MULTIDRIVER_APP.exe non funzionava e mi diceva sempre che non trovava il file SCONTRINO.INP _
                La soluzione mi  stata suggerita da Giorgio Brausi(email del 02.09.2011) dove spega come usare la ShellExecute _
                "Tu stai indicando alla shell di Windows 'dove' si trova l'eseguibile, ma NON la cartella di lavoro, per cui usa quella "corrente", ... _
                 La cosa pi semplice, pi logica e pi efficiente,  quella di usare ShellExecute() ed impostare il parametro _
                 <b> lpDirectory </b> sulla directory di MULTIDRIVER_APP.exe."
      ShellExecute 0, "open", vPathMultidriver & vFileExe, 0&, vPathMultidriver, SW_SHOWNORMAL
      


GestErr:
   'If Err.Number = 53 Then
   '   MsgBox "Impossibile trovare il file per eseguire il servizio di Teleassistenza." & vbNewLine & _
   '          "Errore in fase di stampa scontrino.", vbCritical
   If err.Number <> 0 Then
      MsgBox err.Number & " - " & err.Description & vbNewLine & _
             "Errore in fase di stampa scontrino.", vbCritical
   End If
   On Error GoTo 0

End Sub

Private Function RowScontrMCT_RCH(pRiga As Integer, pTipo As String, Optional pReparto As String) As String
   Dim vStrValScontoDoc As String
   Dim vDescr As String
   Dim vValori As String
   'Compone la riga dello scontrino per DATAPROCESS

   With mpGridScontrino
      
      'Imposto la lunghezza della stringa e la pulisco dai caratteri non validi
      If pRiga > -1 Then
         vDescr = RTrim(Mid(.Rows(pRiga).Record.Item(gtParam4RegCas.pColCodArt + 1).Value, 1, CInt(mLenDescri)))
         vDescr = PulisciDescrizioneScontrino(vDescr)
      End If
      
      Select Case pTipo
         Case "STD" 'riga STANDARD
            'RowScontrMCT_RCH = "=R" & pReparto & "/$"
            vValori = Format(.Rows(pRiga).Record.Item(gtParam4RegCas.pColPrezzo).Value, "########0.#0") 'Prezzo Formatto il numero a due decimali
            vValori = Replace(Replace(vValori, ",", ""), ".", "") 'Prezzo Tolgo i punti e virgole
            RowScontrMCT_RCH = "=R" & pReparto & "/$" & vValori 'Prezzo
            RowScontrMCT_RCH = RowScontrMCT_RCH & "/*" & .Rows(pRiga).Record.Item(gtParam4RegCas.pColQuanti).Value  'Quantita
            RowScontrMCT_RCH = RowScontrMCT_RCH & "/(" & vDescr & ")" 'Descrizione
         
         Case "RESO" 'riga RESO
            RowScontrMCT_RCH = "=r" & vbNewLine 'Codice Funzione di reso
            vValori = Format(.Rows(pRiga).Record.Item(gtParam4RegCas.pColPrezzo).Value, "########0.#0") 'Prezzo Formatto il numero a due decimali
            vValori = Replace(Replace(Replace(vValori, ",", ""), ".", ""), "-", "") 'Prezzo Tolgo i punti e virgole eil segno "-"
            RowScontrMCT_RCH = RowScontrMCT_RCH & "=R" & pReparto & "/$" & vValori 'Prezzo
            RowScontrMCT_RCH = RowScontrMCT_RCH & "/*" & .Rows(pRiga).Record.Item(gtParam4RegCas.pColQuanti).Value 'Quantita
            RowScontrMCT_RCH = RowScontrMCT_RCH & "/(" & vDescr & ")" 'Descrizione
         
         Case "SCN_RIG" 'riga SCONTO RIGA %
            RowScontrMCT_RCH = "=%/*" ' Valori fissi Riga
            vValori = Format(.Rows(pRiga).Record.Item(gtParam4RegCas.pColScont1).Value, "###0.#0") 'Prezzo Formatto il numero a due decimali
            RowScontrMCT_RCH = RowScontrMCT_RCH & Replace(vValori, ",", ".")  'Sconto1
         
         Case "SCN_DOC_PER" 'riga SCONTO DOCUMENTO IN PERCENTUALE
            vStrValScontoDoc = Format(gtParam4RegCas.pScontoDoc, "########0.#0")
            RowScontrMCT_RCH = "=S" & vbNewLine ' Valori fissi Riga
            RowScontrMCT_RCH = RowScontrMCT_RCH & "=%/*"  ' Valori fissi Riga
            RowScontrMCT_RCH = RowScontrMCT_RCH & Replace(vStrValScontoDoc, ",", ".")
         
         Case "SCN_DOC_DOC" 'riga SCONTO DOCUMENTO A VALORE
            vStrValScontoDoc = Format(gtParam4RegCas.pScontoDoc, "########0.#0")
            RowScontrMCT_RCH = "=S" & vbNewLine ' Valori fissi Riga
            RowScontrMCT_RCH = RowScontrMCT_RCH & "=V/*"  ' Valori fissi Riga
            RowScontrMCT_RCH = RowScontrMCT_RCH & Replace(vStrValScontoDoc, ",", "")
            'In presenza di Prepagato allora inserisco anche la Descrizione di Scarico
            If gtParam4RegCas.pPrepagUsato > 0 Then
               RowScontrMCT_RCH = RowScontrMCT_RCH & "/(Scarico Prepagato)" 'Descrizione
            End If
      End Select
      
   End With
   
End Function


Private Function Scontrino_RCH_RT() As Boolean
   Dim vStrRiga As String
   Dim i As Integer
   Dim vTotCalcolato As Currency
   Dim vRetValEsito As Boolean
   Dim vArrDoc() As String
   
   Dim vIndirIP As String
   Dim vNumPort As String
   
   Dim vArr() As String
   Dim Y As Byte
   Dim vVal As String
   Dim vStrAnnulloReso As String
  
  
   On Error GoTo GestErr
   
   
     
'Qui prendo l'IP del Registratore
      vIndirIP = ReadINI("RETE", "IP", mPathFileConf4Scontrino)
      If Len(Trim(vIndirIP)) = 0 Then
         MsgBox "ATTENZIONE!" & vbNewLine & _
                "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
                "(Tag [RETE] Parametro <IP> non presente)" & vbNewLine & vbNewLine & _
                "Impossibile eseguire la stampa dello Scontrino.", vbCritical
         Exit Function
      End If

'Qui prendo il NUMERO DI PORTA da passare nel file scontrino (al momento non mi serve)
      vNumPort = ReadINI("RETE", "PORT", mPathFileConf4Scontrino)
      If Not IsNumeric(vNumPort) Then
         MsgBox "ATTENZIONE!" & vbNewLine & _
                "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
                "(Tag [RETE] Parametro <PORT> non valido)" & vbNewLine & vbNewLine & _
                "Impossibile eseguire la stampa dello Scontrino.", vbCritical
         Exit Function
      End If
'-------------------------------------------------------------------------------------------------



'Eseguo sempre il Check dello stato della stampante prima di procedere =============================================
      Erase vArrDoc
      Call AddArrayElement(vArrDoc, "<</?i/*4")
      If Not (RCHSendCommand(vIndirIP, vNumPort, "CheckPrinterStatus", vArrDoc, "")) Then
         Exit Function
      End If
'===================================================================================================================
   
   
      Erase vArrDoc
      

'Procedura di ANNULLO ==========================================================================================
   If gtParam4RegCas.pEseguiAnnullo Then
      vStrAnnulloReso = Format(gtParam4RegCas.pResAnnDatDoc, "ddmmyy")
      vStrAnnulloReso = vStrAnnulloReso & "/[" & gtParam4RegCas.pResAnnNumDoc1 & "/]" & gtParam4RegCas.pResAnnNumDoc2 & "/(" & gtParam4RegCas.pResAnnMatric & ")"
      
      Call AddArrayElement(vArrDoc, "=k/&" & vStrAnnulloReso)
      If (RCHSendCommand(vIndirIP, vNumPort, "VoidDocument", vArrDoc, "")) Then
         Call MsgRegCasInLogFile("[Scontrino_RCH_RT] - ANNULLATO DOCUMENTO: " & gtParam4RegCas.pResAnnNumDoc1 & "-" & gtParam4RegCas.pResAnnNumDoc2 & " del " & gtParam4RegCas.pResAnnDatDoc)
      Else
         Call MsgRegCasInLogFile("[Scontrino_RCH_RT] - ERRORE ANNULLO: " & gtParam4RegCas.pResAnnNumDoc1 & "-" & gtParam4RegCas.pResAnnNumDoc2 & " del " & gtParam4RegCas.pResAnnDatDoc, True)
      End If
      Scontrino_RCH_RT = True
      Exit Function
   End If
'===============================================================================================================
               
            
      
'APERTURA Procedura di RESO ====================================================================================
   If gtParam4RegCas.pEseguiReso Then
         
      vStrAnnulloReso = Format(gtParam4RegCas.pResAnnDatDoc, "ddmmyy")
      vStrAnnulloReso = vStrAnnulloReso & "/[" & gtParam4RegCas.pResAnnNumDoc1 & "/]" & gtParam4RegCas.pResAnnNumDoc2 & "/(" & gtParam4RegCas.pResAnnMatric & ")"
      
      Call MsgRegCasInLogFile("[Scontrino_RCH_RT] - INZIO RESO DOCUMENTO: " & gtParam4RegCas.pResAnnNumDoc1 & "-" & gtParam4RegCas.pResAnnNumDoc2 & " del " & gtParam4RegCas.pResAnnDatDoc)
         
      'INIZIO ISTRUZIONI - - -
         Call AddArrayElement(vArrDoc, "=r/&" & vStrAnnulloReso)
   
   Else
'APERTURA Procedura emissione DOCUMENTO COMMERCIALE ======================================================================
         
      Call MsgRegCasInLogFile("[Scontrino_RCH_RT] - INIZIO EMISSIONE DOCUMENTO COMMERCIALE")
               
      'INIZIO ISTRUZIONI - - -
         Call AddArrayElement(vArrDoc, "=x") 'terminatore delle operazioni in corso (Riporta la modalit in REG (1 CHIAVE))
         Call AddArrayElement(vArrDoc, "=K") 'clear
                        
      'Stampa del Codice Fiscale
         'vVal = ReadINI("SCONTRINI", "NO_CODFIS", IniPath)
         'If Not (vVal = "T") Then
         vVal = ReadINI("OPZIONI", "NO_CODFIS", mPathFileConf4Scontrino)
         If Not (vVal = "1") Then
            If Len(gtParam4RegCas.pCodFisc) > 0 Then
               Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/?C/(" & gtParam4RegCas.pCodFisc & ")")
            End If
         End If
   
   End If

   
'DETTAGLIO del DOCUMENTO COMMERCIALE oppure DOCUMENTO DI RESO ==============================================================
   With mpGridScontrino
      vTotCalcolato = 0
   
      For i = 0 To .Rows.Count - 1
         vTotCalcolato = vTotCalcolato + .Rows(i).Record.Item(gtParam4RegCas.pColImpNet).Value
         
         'Eventuale linea di separazione
            If Not gtParam4RegCas.pEseguiReso Then 'se NON  RESO
               If gtParam4RegCas.pColStmpSeparLineBefore > 0 Then
                  If .Rows(i).Record.Item(gtParam4RegCas.pColStmpSeparLineBefore).Value = 1 Then
                     Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/(" & String(48, "-") & ")")
                  End If
               End If
            End If
         
                           
         'Qui verifico se c'e' l'associazione del Codice IVA con il Reparti del Registratore di Cassa
            vVal = ReadINI("REPARTIIVA_REPARTI", .Rows(i).Record.Item(gtParam4RegCas.pColRepIVA).Value, mPathFileConf4Scontrino)
            If Len(Trim(vVal)) > 0 Then vVal = Replace(UCase(vVal), "REPARTO", "")
            If IsNumeric(vVal) = False Then vVal = "1"
            
            
         'deve precedere le righe negative
            If .Rows(i).Record.Item(gtParam4RegCas.pColPrezzo).Value < 0 Then
               vStrRiga = RowScontrRCH_RT(i, "VAL_NEGATIVO", vVal) 'Compongo la stringa STANDARD
               Call AddArrayElement(vArrDoc, vStrRiga)
            End If
            
         
         'RIGA DI VENDITA / RESO
            vStrRiga = RowScontrRCH_RT(i, "STD", vVal) 'Compongo la stringa STANDARD
            Call AddArrayElement(vArrDoc, vStrRiga)
            
            
         'Qui controllo se c' lo Sconto riga sull'Articolo
            If .Rows(i).Record.Item(gtParam4RegCas.pColScont1).Value > 0 Then
               vStrRiga = RowScontrRCH_RT(i, "SCN_RIG")   'Compongo la stringa SCONTO RIGA
               Call AddArrayElement(vArrDoc, vStrRiga)
            End If
         
                  
         'Eventuali righe descrittive (messaggi da Subtotale)
            If Not gtParam4RegCas.pEseguiReso Then 'se NON  RESO
               If gtParam4RegCas.pColStmpAddMsgRow > 0 Then
                  If Len(Trim(.Rows(i).Record.Item(gtParam4RegCas.pColStmpAddMsgRow).Value)) > 0 Then
                     vArr = Split(.Rows(i).Record.Item(gtParam4RegCas.pColStmpAddMsgRow).Value, "")
                     For Y = 0 To UBound(vArr)
                        Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/(" & vArr(Y) & ")")
                     Next Y
                     Erase vArr
                  End If
               End If
            End If
         
      Next i
      
               
'CALCE del DOCUMENTO COMMERCIALE oppure DOCUMENTO DI RESO ==============================================================
      If gtParam4RegCas.pEseguiReso Then
'qui RESO
         Call AddArrayElement(vArrDoc, "=T1")
      
      
      Else
'qui VENDITA DOCUMENTO COMMERCIALE

         'INZIO SCONTI DOCUMENTO ========================================================================
            If (vTotCalcolato > gtParam4RegCas.pImpTotale) Then
               If gtParam4RegCas.pScontoPercent Then  'Controllo se  in PERCENTUALE...
                  vStrRiga = RowScontrRCH_RT(-1, "SCN_DOC_PER")   'Compongo la stringa SCONTO DOC
                  Call AddArrayElement(vArrDoc, "=S")
                  Call AddArrayElement(vArrDoc, vStrRiga)
               Else                          '...oppure se  a VALORE
                  vStrRiga = RowScontrRCH_RT(-1, "SCN_DOC_DOC", "", gtParam4RegCas.pScontoDoc) 'Compongo la stringa SCONTO RIGA
                  Call AddArrayElement(vArrDoc, "=S")
                  Call AddArrayElement(vArrDoc, vStrRiga)
               End If
            End If
         'FINE SCONTI DOCUMENTO ========================================================================
      
      
         'INZIO PAGAMENTO ========================================================================
            'gTipPagSubtot   struttura x, 0 -> Codice Tipo Pagamento _
                              x, 1 -> Importo Pagamento _
                              x, 2 -> Conto Incasso (campo TGTESTO1 della tabella TAB_GEN con CHIAVE = 'PAGAME') _
                              x, 3 -> Codice per Registratore Telematico (campo TGSPUNTA2 della tabella TAB_GEN con CHIAVE = 'PAGAME') _
                              x, 4 -> Importo Pagamento (all'origine, perch durante gl'incasso il valore viene svuotato e allo scontrino arriverebbe vuoto)
             'Stringa di IMPORTO RICEVUTO (prendo la descrizione dalla gTipPagSubtot(0, 1))
               If Not gtParam4RegCas.pEseguiReso Then 'il pagamento NON va indicato in caso di RESO
                  vStrRiga = RowScontrRCH_RT(-1, "IMP_RIC", "", CCur(gTipPagSubtot(0, 4)), gTipPagSubtot(0, 3))
                  Call AddArrayElement(vArrDoc, vStrRiga)
                           
                  'Verifico se c' il pagamento 2
                     If Len(Trim(gTipPagSubtot(1, 0))) > 0 Then
                        vStrRiga = RowScontrRCH_RT(-1, "IMP_RIC", "", CCur(gTipPagSubtot(1, 4)), gTipPagSubtot(1, 3))
                        Call AddArrayElement(vArrDoc, vStrRiga)
                     End If
                  
                  'Verifico se c' il pagamento 3
                     If Len(Trim(gTipPagSubtot(2, 0))) > 0 Then
                        vStrRiga = RowScontrRCH_RT(-1, "IMP_RIC", "", CCur(gTipPagSubtot(2, 4)), gTipPagSubtot(2, 3))
                        Call AddArrayElement(vArrDoc, vStrRiga)
                     End If
               End If
         'FINE PAGAMENTO ========================================================================
      
         
         'Stampa documento  di Riferimetno
         If Len(Trim(gtParam4RegCas.pRifDocFat)) > 0 Then
            Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/()")
               Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/&1/(" & Trim(gtParam4RegCas.pRifDocFat) & ")")
            Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/()")
         End If
      
      
'LINEE DI CORTESIA ===========================================================================================================
'     '===========================================================================================================
            Dim vLineeCortesia As Boolean
            vLineeCortesia = ((gtParam4RegCas.pPrepagResiduo > 0) Or (gtParam4RegCas.pPuntiFid > 0) Or (Len(gtParam4RegCas.pVoucherID) > 0))
            
            If vLineeCortesia Then
               Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/()")
               Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/&1/(" & String(40, "-") & ")")
            End If
      
      
            'Stampo la riga di Cortesia con il totale del Credito del Prepagato residuo
               If gtParam4RegCas.pPrepagResiduo > 0 Then
                  Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/()")
                  Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/( PREPAGATO DISPONIBILE)")
                  Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/(          " & Format(gtParam4RegCas.pPrepagResiduo, "#####0.#0") & ")/*2")
                  Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/()")
               End If
            
            'Stampo la riga di Cortesia con il totale dei Punti Fedelet accumulati
               If gtParam4RegCas.pPuntiFid > 0 Then
                  Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/&1/()")
                  Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/&1/( PUNTI FIDELITY)")
                  Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/&1/(          " & Trim(Str(gtParam4RegCas.pPuntiFid)) & ")/*2")
                  Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/&1/()")
               End If

            'Stampo la riga di Cortesia con il riferimento del numero del Voucher e il suo importo
               If Len(gtParam4RegCas.pVoucherID) > 0 Then
                  Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/()")
                  Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/(VOUCHER CARD)")
                  Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/( " & gtParam4RegCas.pVoucherID & ")/*2")
                  Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/(Descrizione)")
                  Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/( " & PulisciDescrizioneScontrino(gtParam4RegCas.pVoucherDescr) & ")/*2")
                  Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/(VALORE)")
                  Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/( " & Format(gtParam4RegCas.pVoucherValue, "#####0.#0") & ")/*2")
                  Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/()")
               End If
               
            
            If vLineeCortesia Then
               Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/&1/(" & String(40, "-") & ")")
               Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/()")
            End If
         'FINE RIGHE DI CORTESIA ========================================================================
               
               
            'Seriale del documento
            Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/&1/(S:" & gtParam4RegCas.pSerial & ")")
               
      End If

            
      'INZIO DI CHIUSURA
         Call AddArrayElement(vArrDoc, "=c")
      
      
      
      '************* 2019.11.25 GESTIONE VOUCHER
         'CREAZIONE DEL DOCUMENTO GESTIONALE, ACCODATO AL DOCUMENTO COMMERCIALE
         If Len(gtParam4RegCas.pVoucherID) > 0 Then
            Call AddArrayElement(vArrDoc, "=o")
            Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/()")
            Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/()")
            Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/(" & String(40, "=") & ")")
            Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/()")
            Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/()")
            Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/(*** VOUCHER CARD ***)/*2")
            Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/()")
            Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/(Codice)")
            Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/( " & gtParam4RegCas.pVoucherID & ")/*2")
            Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/()")
            Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/(Descrizione)")
            Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/( " & PulisciDescrizioneScontrino(gtParam4RegCas.pVoucherDescr) & ")/*2")
            
            vVal = ReadINI("OPZIONI", "NO_PREZZO_VOUCHER", mPathFileConf4Scontrino)
            If vVal <> "1" Then
               Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/()")
               Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/(Valore)")
               Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/( " & Format(gtParam4RegCas.pVoucherValue, "#####0.#0") & ")/*2")
            End If
            
            Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/()")
            Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/()")
            Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/(" & String(40, "=") & ")")
            Call AddArrayElement(vArrDoc, "=o")
         End If
      '************* 2019.11.25 GESTIONE VOUCHER
   End With
   
   
   
   
'INVIO COMANDO AL CGI DELLA STAMPANTE
      Call VerificaEsistenzaPathCartella(PathREGCAS & "\Storico\")
      Dim Filename As String
      Filename = "RCH_" & gIDPostazione & "_" & Format(Now, "yyyy.mm.dd_hh.nn.ss") & ".xml"
      vRetValEsito = RCHSendCommand(vIndirIP, vNumPort, "PrintDoc", vArrDoc, "", "", PathREGCAS & "\Storico\" & Filename, True)
   
   
   'Verifico se devo attendere la risposta
      If ReadINI("PARAMETRI", "WAIT_OUT_REG", mPathFileConf4Scontrino) <> "1" Then
         vRetValEsito = True
      End If
   
   
   'Esito
      Scontrino_RCH_RT = vRetValEsito
      Call MsgRegCasInLogFile("[Scontrino_RCH_RT] - Esito ReadOut: '" & vRetValEsito & "'")
   
   
   'Salvo il tentativo nella tabella delle INFO se  andata a buonfine
      If vRetValEsito Then
         Call MsgRegCasInLogFile("[Scontrino_RCH_RT] - Insert_DOC_INFO_RT")
            Call Insert_DOC_INFO_RT
      End If
      


GestErr:
   If err.Number <> 0 Then
      Dim vErrStr As String
      vErrStr = err.Number & " - " & err.Description
      Call MsgRegCasInLogFile("[Scontrino_RCH_RT] - " & vErrStr, True)
      MsgBox vErrStr & vbNewLine & _
             "Errore in fase stampa Documento Commerciale" & vbNewLine & _
             "(Scontrino_RCH_RT)", vbCritical
   End If
   On Error GoTo 0

End Function

Private Function RowScontrRCH_RT(pRiga As Integer, pTipo As String, Optional pReparto As String, Optional pValore As Currency, _
                                 Optional pTipoPagTelematico As String) As String
      
   Dim vStrValScontoDoc As String
   Dim vDescr As String
   Dim vValori As String
   'Compone la riga dello scontrino per DATAPROCESS

   With mpGridScontrino
      
      'Imposto la lunghezza della stringa e la pulisco dai caratteri non validi
      If pRiga > -1 Then
         If gtParam4RegCas.pStmpDescrAltern Then 'verifico se devo prendere la descrizione alternativa
            vDescr = DecodDES_ALTREN_ARTICOLO(.Rows(pRiga).Record.Item(gtParam4RegCas.pColCodArt).Value)
         End If
         If Len(Trim(vDescr)) = 0 Then
            vDescr = Trim(.Rows(pRiga).Record.Item(gtParam4RegCas.pColCodArt + 1).Value)
         End If
         vDescr = PulisciDescrizioneScontrino(vDescr)
      End If
      
      
      Select Case pTipo
         Case "STD" 'riga STANDARD
            'RowScontrRCH_RT = "=R" & pReparto & "/$"
            Dim vPrezzo As Currency
            If .Rows(pRiga).Record.Item(gtParam4RegCas.pColPrezzo).Value < 0 Then
               vPrezzo = .Rows(pRiga).Record.Item(gtParam4RegCas.pColPrezzo).Value * (-1)
            Else
               vPrezzo = .Rows(pRiga).Record.Item(gtParam4RegCas.pColPrezzo).Value
            End If
            vValori = Format(vPrezzo, "########0.#0")  'Prezzo Formatto il numero a due decimali
            vValori = Replace(Replace(vValori, ",", ""), ".", "") 'Prezzo Tolgo i punti e virgole
            RowScontrRCH_RT = "=R" & pReparto & "/$" & vValori 'Prezzo
            RowScontrRCH_RT = RowScontrRCH_RT & "/*" & .Rows(pRiga).Record.Item(gtParam4RegCas.pColQuanti).Value  'Quantita
            RowScontrRCH_RT = RowScontrRCH_RT & "/(" & vDescr & ")" 'Descrizione
         
         
         Case "VAL_NEGATIVO"
            RowScontrRCH_RT = "=s"
         
'         Case "RESO" 'riga RESO
'            RowScontrRCH_RT = "=r" & vbNewLine 'Codice Funzione di reso
'            vValori = Format(.Rows(pRiga).Record.Item(gtParam4RegCas.pColPrezzo).Value, "########0.#0") 'Prezzo Formatto il numero a due decimali
'            vValori = Replace(Replace(Replace(vValori, ",", ""), ".", ""), "-", "") 'Prezzo Tolgo i punti e virgole eil segno "-"
'            RowScontrRCH_RT = RowScontrRCH_RT & "=R" & pReparto & "/$" & vValori 'Prezzo
'            RowScontrRCH_RT = RowScontrRCH_RT & "/*" & .Rows(pRiga).Record.Item(gtParam4RegCas.pColQuanti).Value 'Quantita
'            RowScontrRCH_RT = RowScontrRCH_RT & "/(" & vDescr & ")" 'Descrizione
         
         Case "SCN_RIG" 'riga SCONTO RIGA %
            RowScontrRCH_RT = "=%/*" ' Valori fissi Riga
            vValori = Format(.Rows(pRiga).Record.Item(gtParam4RegCas.pColScont1).Value, "###0.#0") 'Prezzo Formatto il numero a due decimali
            RowScontrRCH_RT = RowScontrRCH_RT & Replace(vValori, ",", ".")  'Sconto1
         
         Case "SCN_DOC_PER" 'riga SCONTO DOCUMENTO IN PERCENTUALE
            vStrValScontoDoc = Format(gtParam4RegCas.pScontoDoc, "########0.#0")
            'RowScontrRCH_RT = "=S" & vbNewLine ' Valori fissi Riga
            RowScontrRCH_RT = RowScontrRCH_RT & "=%/*"  ' Valori fissi Riga
            RowScontrRCH_RT = RowScontrRCH_RT & Replace(vStrValScontoDoc, ",", ".")
         
         Case "SCN_DOC_DOC" 'riga SCONTO DOCUMENTO A VALORE
            vStrValScontoDoc = Format(pValore, "########0.#0")
            'RowScontrRCH_RT = "=S" & vbNewLine ' Valori fissi Riga
            RowScontrRCH_RT = RowScontrRCH_RT & "=V/*"  ' Valori fissi Riga
            RowScontrRCH_RT = RowScontrRCH_RT & Replace(vStrValScontoDoc, ",", "")
            'In presenza di Prepagato allora inserisco anche la Descrizione di Scarico
'            If gtParam4RegCas.pPrepagUsato > 0 Then
'               RowScontrRCH_RT = RowScontrRCH_RT & "/(Scarico Prepagato)" 'Descrizione
'            End If
            
         Case "IMP_RIC"  'riga IMPORTO RICEVUTO
            vValori = Format(pValore, "########0.#0") 'Prezzo Formatto il numero a due decimali
            vValori = Replace(Replace(vValori, ",", ""), ".", "") 'Prezzo Tolgo i punti e virgole
            RowScontrRCH_RT = RowScontrRCH_RT & "=T" & (CByte(pTipoPagTelematico) + 1) & "/$" & vValori
            RowScontrRCH_RT = RowScontrRCH_RT & "/()" 'Descrizione
            
      End Select
      
   End With
   
End Function


Private Function Scontrino_CUSTOM(pCausalDoc As String, pSerial As Long) As Boolean
   'Dim NumFile As Integer 'per aprire il file di esecuzioni(LOG)
   Dim vStrRiga As String
'   Dim i As Integer
'   Dim vStrImpRicevuto As String
   
   'Dim vPathScontrino As String 'Con CUSTOM non creo il file TEMP perch l'invio della stampa avviene direttamente alla .dll Custom
   'Dim vPathMultidriver As String
   Dim vTipConn As String
   Dim vApriCas As String
   Dim vDoppCop As String 'Doppia Copia: Solo x Fatture
   Dim vNumPort As String
   Dim vIndirIP As String
   Dim vBaudRat As String
   Dim vBitDati As String
   Dim vParita As String
   Dim vBitStop As String
   Dim vFlusso As String
   Dim vNomeStampante As String
   
   Dim vTotCalcolato As Currency
   Dim vVal As String
   
   Dim vRet As Long
   Dim vRetErr As Long
  
   On Error GoTo GestErr
  
  
'CONTROLLI SUI VALORI
   'Qui prendo il TIPO CONNESSIONE da passare nel file scontrino
      vTipConn = ReadINI("PARAMETRI", "TIP_CONN", mPathFileConf4Scontrino)
      If Len(Trim(vTipConn)) = 0 Then
         MsgBox "ATTENZIONE!" & vbNewLine & _
                "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
                "(Tag [PARAMETRI] Parametro <TIP_CONN> non presente)" & vbNewLine & vbNewLine & _
                "Impossibile eseguire la stampa dello Scontrino.", vbCritical
         Exit Function
      End If
      
'QUI CONTROLLO SE DEVO VERIFICARE I PARAMETRI DI RETE E SERIALI E USB
      If vTipConn = "R" Then 'VALORI DI RETE
         
         'Qui prendo l'IP del Registratore
            vIndirIP = ReadINI("RETE", "IP", mPathFileConf4Scontrino)
            If Len(Trim(vIndirIP)) = 0 Then
               MsgBox "ATTENZIONE!" & vbNewLine & _
                      "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
                      "(Tag [RETE] Parametro <IP> non presente)" & vbNewLine & vbNewLine & _
                      "Impossibile eseguire la stampa dello Scontrino.", vbCritical
               Exit Function
            End If
         'Qui prendo il NUMERO DI PORTA da passare nel file scontrino
            vNumPort = ReadINI("RETE", "PORT", mPathFileConf4Scontrino)
            If Not IsNumeric(vNumPort) Then
               MsgBox "ATTENZIONE!" & vbNewLine & _
                      "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
                      "(Tag [RETE] Parametro <PORT> non valido)" & vbNewLine & vbNewLine & _
                      "Impossibile eseguire la stampa dello Scontrino.", vbCritical
               Exit Function
            End If
            
      ElseIf vTipConn = "U" Then 'VALORI PER USB
         'Qui prendo il Nome della Stampante in caso di stampa tramiteUSB
            vNomeStampante = ReadINI("USB", "PRINT_NAME", mPathFileConf4Scontrino)
            If Len(Trim(vNomeStampante)) = 0 Then
               MsgBox "ATTENZIONE!" & vbNewLine & _
                      "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
                      "(Tag [SERIALE] Parametro <FLUSSO> non valido)" & vbNewLine & vbNewLine & _
                      "Impossibile eseguire la stampa dello Scontrino.", vbCritical
               Exit Function
            End If
      
      Else
         'Qui prendo il NUMERO DI PORTA da passare nel file scontrino
            vNumPort = ReadINI("SERIALE", "PORTA_COM", mPathFileConf4Scontrino)
            If Not IsNumeric(vNumPort) Then
               MsgBox "ATTENZIONE!" & vbNewLine & _
                      "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
                      "(Tag [SERIALE] Parametro <PORTA> non valido)" & vbNewLine & vbNewLine & _
                      "Impossibile eseguire la stampa dello Scontrino.", vbCritical
               Exit Function
            End If
         'Qui prendo il BAUD_RATE
            vBaudRat = ReadINI("SERIALE", "BAUD_RATE", mPathFileConf4Scontrino)
            If Not IsNumeric(vBaudRat) Then
               MsgBox "ATTENZIONE!" & vbNewLine & _
                      "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
                      "(Tag [SERIALE] Parametro <BAUD_RATE> non valido)" & vbNewLine & vbNewLine & _
                      "Impossibile eseguire la stampa dello Scontrino.", vbCritical
               Exit Function
            End If
         'Qui prendo il BIT_DATI
            vBitDati = ReadINI("SERIALE", "BIT_DATI", mPathFileConf4Scontrino)
            If Not IsNumeric(vBitDati) Then
               MsgBox "ATTENZIONE!" & vbNewLine & _
                      "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
                      "(Tag [SERIALE] Parametro <BIT_DATI> non valido)" & vbNewLine & vbNewLine & _
                      "Impossibile eseguire la stampa dello Scontrino.", vbCritical
               Exit Function
            End If
         'Qui prendo il PARITA
            vParita = ReadINI("SERIALE", "PARITA", mPathFileConf4Scontrino)
            If Not IsNumeric(vParita) Then
               MsgBox "ATTENZIONE!" & vbNewLine & _
                      "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
                      "(Tag [SERIALE] Parametro <PARITA> non valido)" & vbNewLine & vbNewLine & _
                      "Impossibile eseguire la stampa dello Scontrino.", vbCritical
               Exit Function
            End If
         'Qui prendo il BIT_STOP
            vBitStop = ReadINI("SERIALE", "BIT_STOP", mPathFileConf4Scontrino)
            If Not IsNumeric(vBitStop) Then
               MsgBox "ATTENZIONE!" & vbNewLine & _
                      "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
                      "(Tag [SERIALE] Parametro <BIT_STOP> non valido)" & vbNewLine & vbNewLine & _
                      "Impossibile eseguire la stampa dello Scontrino.", vbCritical
               Exit Function
            End If
         'Qui prendo il FLUSSO
            vFlusso = ReadINI("SERIALE", "FLUSSO", mPathFileConf4Scontrino)
            If Not IsNumeric(vFlusso) Then
               MsgBox "ATTENZIONE!" & vbNewLine & _
                      "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
                      "(Tag [SERIALE] Parametro <FLUSSO> non valido)" & vbNewLine & vbNewLine & _
                      "Impossibile eseguire la stampa dello Scontrino.", vbCritical
               Exit Function
            End If
            
      End If
   
      vApriCas = ReadINI("PARAMETRI", "APRI_CASSETTO", mPathFileConf4Scontrino)
      vDoppCop = ReadINI("PARAMETRI", "DOPPIA_COPIA", mPathFileConf4Scontrino)
'-------------------------------------------------------------------------------------------------
      
      
      If gtParam4RegCas.pModalitaRT Then
         'Prendo la Generazione
         gtParam4RegCas.pGenerazioneCustom = ReadINI("PARAMETRI", "GENERAZIONE", mPathFileConf4Scontrino)
         If Len(Trim(gtParam4RegCas.pGenerazioneCustom)) = 0 Then gtParam4RegCas.pGenerazioneCustom = "III"
      
      
         'Controllo lo stato della stampante
            If Mid(CUSTOMFunctionRT(CheckStatus, True, mPathFileConf4Scontrino), 1, 3) = "ERR" Then
               Exit Function
            Else
               If gCUSTOMCheckInattivita = False Then
                  If Mid(CUSTOMFunctionRT(getStatoLogicoRT, True, mPathFileConf4Scontrino, 0, True), 1, 3) = "ERR" Then
                     Exit Function
                  End If
               End If
            End If
            
         
         'Verifico se c' un RESO da comandare prima oppure un ANNULLO
            If gtParam4RegCas.pEseguiReso Or gtParam4RegCas.pEseguiAnnullo Then
               If Len(Trim(CUSTOMFunctionRT(execResoAnnullo, True, mPathFileConf4Scontrino))) > 0 Then
                  Exit Function
               Else
                  'in caso di annullo devo ripetere il comando con il parametro 1 (in pratica la prova volta viene passato "0" e qui viene passato "1")  --  PS: Cos Funziona
                  If gtParam4RegCas.pEseguiAnnullo Then
                     If Len(Trim(CUSTOMFunctionRT(execResoAnnullo, True, mPathFileConf4Scontrino, 1))) > 0 Then
                        Exit Function
                     End If
                  End If
               End If
            End If
         
      End If
   
   '===================================================================================================
   'QUI COMPONGO LO SCONTRINO  ===============================================================
      If pCausalDoc = "CO" Then 'Corrispettivi 'SCONTRINO
         If gtParam4RegCas.pModalitaRT Then
            If Not gtParam4RegCas.pEseguiAnnullo Then
               If StampaScontrinoCUSTOM_RT(vTipConn, vApriCas, vIndirIP, vNumPort, vBaudRat, _
                                          vBitDati, vParita, vBitStop, vFlusso, vNomeStampante) = False Then
                  Exit Function
               End If
            End If
         Else
            If StampaScontrinoCUSTOM_MF(vTipConn, vApriCas, vIndirIP, vNumPort, vBaudRat, _
                                       vBitDati, vParita, vBitStop, vFlusso, vNomeStampante) = False Then
               Exit Function
            End If
         End If
            
      ElseIf pCausalDoc = "FA" Then 'FATTURA
         If StampaFatturaCUSTOM(pSerial, vDoppCop, _
                                  vTipConn, vApriCas, vIndirIP, vNumPort, vBaudRat, _
                                  vBitDati, vParita, vBitStop, vFlusso, vNomeStampante) = False Then
            Exit Function
         End If
      ElseIf pCausalDoc = "NC" Then 'NOTA DI CREDITO
         If StampaNotaCreditoCUSTOM(pSerial, _
                                      vTipConn, vApriCas, vIndirIP, vNumPort, vBaudRat, _
                                      vBitDati, vParita, vBitStop, vFlusso, vNomeStampante) = False Then
            Exit Function
         End If
      End If

                                    
   'QUI VERIFIO SE APRIRE IL CASSETTO  ===============================================================
      If vApriCas = "1" Then
         If gtParam4RegCas.pModalitaRT Then
            'qui non valuto l'esito perch anche se va in errore non mi interessa ai fini dell'emissione dello scontrino
            Dim vRisp As String
            vRisp = CUSTOMFunctionRT(execApriCassetto, False, mPathFileConf4Scontrino)
            If Mid(vRisp, 1, 3) = "ERR" Then
               MsgBox "Errore nell'apertura del Cassetto", msg_Exclamation
            End If
            
         Else
            Call Test_CUSTOM(vTipConn, vApriCas, vIndirIP, vNumPort, vBaudRat, _
                             vBitDati, vParita, vBitStop, vFlusso, _
                             "APRI_CASSETTO")
         End If
      End If
                                 
   
   'Se arriva qui  andato tutto bene!!
   Scontrino_CUSTOM = True



'************* 2019.11.25 GESTIONE VOUCHER
   If pCausalDoc = "CO" And gtParam4RegCas.pModalitaRT Then  'Corrispettivi 'SCONTRINO
      If Len(gtParam4RegCas.pVoucherID) > 0 Then
         If StampaVoucher_CUSTOM_RT(vTipConn, vApriCas, vIndirIP, vNumPort, vBaudRat, _
                                    vBitDati, vParita, vBitStop, vFlusso, vNomeStampante, _
                                    (ReadINI("OPZIONI", "NO_PREZZO_VOUCHER", mPathFileConf4Scontrino) <> "1")) = False Then
            Exit Function
         End If
      End If
            
   End If



GestErr:
   If err.Number <> 0 Then
      MsgBox err.Number & " - " & err.Description & vbNewLine & _
             "Errore in fase di stampa scontrino.", vbCritical
      
      If pCausalDoc = "CO" Then 'Corrispettivi 'SCONTRINO
         ' Comando di interruzione stampa
         vStrRiga = "3001818Annull.transazione000000000"
         If gtParam4RegCas.pModalitaRT Then
            vRet = VbCEFWriteCustom(vStrRiga, vRetErr)
         Else
            vRet = VbCEFWrite(vStrRiga, vRetErr)
         End If
         ' Close Document
         vStrRiga = "3011"
         If gtParam4RegCas.pModalitaRT Then
            vRet = VbCEFWriteCustom(vStrRiga, vRetErr)
         Else
            vRet = VbCEFWrite(vStrRiga, vRetErr)
         End If
         ' Print and Cut
         vStrRiga = "3013"
         If gtParam4RegCas.pModalitaRT Then
            vRet = VbCEFWriteCustom(vStrRiga, vRetErr)
         Else
            vRet = VbCEFWrite(vStrRiga, vRetErr)
         End If
      End If
   End If
   On Error GoTo 0

End Function

Private Function StampaScontrinoCUSTOM_MF(vTipConn As String, vApriCas As String, _
                                          vIndirIP As String, vNumPort As String, _
                                          vBaudRat As String, vBitDati As String, vParita As String, vBitStop As String, vFlusso As String, _
                                          vNomeStampante As String) As Boolean
   Dim vStrRiga As String
   Dim i As Integer
   Dim vTotCalcolato As Currency
   Dim vVal As String
   
   Dim vRet As Long
   Dim vRetErr As Long
   
   Dim NumFile As Integer 'per aprire il file che mi serve per storicizzare lo scontrino ed eventualmente ristamparlo
   
   StampaScontrinoCUSTOM_MF = False

   Call VerificaEsistenzaPathCartella(PathREGCAS & "\Storico")

   ' Open Communication
   If vTipConn = "R" Then 'RETE
      vRet = VbCEFOpenEth(vIndirIP, CLng(vNumPort), vRetErr)
   ElseIf vTipConn = "U" Then 'USB
      vRet = VbCEFOpenUSB(vNomeStampante, vRetErr)
   Else 'SERIALE
       vRet = VbCEFOpen(CLng(vNumPort), CLng(vBaudRat), CByte(vParita), CByte(vBitDati), CByte(vBitStop), CByte(vFlusso), CLng(vRetErr))
   End If
   
   ' Check Init
   If (vRet <> 0) Then
      MsgBox "ATTENZIONE!" & vbNewLine & _
             "Errore di Comunicazione", (vbOKOnly + vbCritical)
      Exit Function
   End If
   
   'vRetA = Int(Combo1.Text)
   
   
   'verifico che non si tratti di una ristampa...
   If Len(gtParam4RegCas.pRistScontrino) = 0 Then
           
      'qui apri il file che creo comunque per la storicizzazione dello scontrino e l'eventuale ristampa
      NumFile = FreeFile
      'Open App.path & "\temp.txt" For Append As #NumFile      'CREO IL FILE
      Dim vNomeFileStorico As String
      vNomeFileStorico = Replace(Format(Date, "yyyy-mm-dd") & "_" & Format(Now, "hh.nn.ss"), ":", ".") & ".txt"
      Open PathREGCAS & "\Storico\" & vNomeFileStorico For Append As #NumFile      'CREO IL FILE
      
      '...altrimenti creo le righe da inviare alla Dll Custom
      'Setta la stampa NON Bufferizzata (la stampa dei prodotti avviene articolo per articolo)
      vStrRiga = "30160"
      vRet = VbCEFWrite(vStrRiga, vRetErr)
         Print #NumFile, vStrRiga 'Stampo la stringa nel File
      
      'RIGHE
      With mpGridScontrino
         vTotCalcolato = 0
         
         For i = 0 To .Rows.Count - 1
            vTotCalcolato = vTotCalcolato + .Rows(i).Record.Item(gtParam4RegCas.pColImpNet).Value
            
            'Qui controllo se si tratta di reso perch prima delle quantit inserisco una riga descrittiva per dire che l'articolo/i successivo  un reso
            If .Rows(i).Record.Item(gtParam4RegCas.pColSimbol).Value = "R" Then
               vStrRiga = RowScontrCUSTOM_MF(i, "TESTO", 0, 0, "   --- R E S O ---") 'Inserisco la riga con le Quantit
               vRet = VbCEFWrite(vStrRiga, vRetErr)
                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
            End If
            
            If CDbl(.Rows(i).Record.Item(gtParam4RegCas.pColQuanti).Value) <> 1 Then
               vStrRiga = RowScontrCUSTOM_MF(i, "QTA")  'Inserisco la riga con le Quantit
               vRet = VbCEFWrite(vStrRiga, vRetErr)
                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
            End If
            
            'Qui verifico se c'e' l'associazione del Codice IVA con il Reparti del Registratore di Cassa
            vVal = ReadINI("REPARTIIVA_REPARTI", .Rows(i).Record.Item(gtParam4RegCas.pColRepIVA).Value, mPathFileConf4Scontrino)
            If Len(Trim(vVal)) > 0 Then vVal = Replace(UCase(vVal), "REPARTO", "")
            If IsNumeric(vVal) = False Then vVal = "0"
            
            'Controllo se si tratta di un RESO o di un articolo normale di vendita
            'If .CellBackColor = Colore("rosso1") Then
            If .Rows(i).Record.Item(gtParam4RegCas.pColSimbol).Value = "R" Then
               vStrRiga = RowScontrCUSTOM_MF(i, "RESO", 0, CByte(vVal)) 'Compongo la stringa di RESO
            Else
               vStrRiga = RowScontrCUSTOM_MF(i, "STD", 0, CByte(vVal)) 'Compongo la stringa STANDARD
            End If
            vRet = VbCEFWrite(vStrRiga, vRetErr)
               Print #NumFile, vStrRiga 'Stampo la stringa nel File
            
            'Qui controllo se c' lo Sconto riga sull'Articolo
            If .Rows(i).Record.Item(gtParam4RegCas.pColScont1).Value > 0 Then
               vStrRiga = RowScontrCUSTOM_MF(i, "SCN_RIG", 0, CByte(vVal)) 'Compongo la stringa SCONTO RIGA
               vRet = VbCEFWrite(vStrRiga, vRetErr)
                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
            End If
            
         Next i
     
     
         'Eventuali SCONTI sul DOCUMENTO
         If vTotCalcolato > gtParam4RegCas.pImpTotale Then
            If gtParam4RegCas.pScontoPercent = True Then 'Controllo se  in PERCENTUALE...
               'Stampo il Subtotale
                  vStrRiga = "3003"
                  vRet = VbCEFWrite(vStrRiga, vRetErr)
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
               '-------------------
               vStrRiga = RowScontrCUSTOM_MF(-1, "SCN_DOC_PER", (vTotCalcolato - gtParam4RegCas.pImpTotale))   'Compongo la stringa SCONTO RIGA
               vRet = VbCEFWrite(vStrRiga, vRetErr)
                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
            Else                          '...oppure se  a VALORE
               'Stampo il Subtotale
                  vStrRiga = "3003"
                  vRet = VbCEFWrite(vStrRiga, vRetErr)
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
               '-------------------
               vStrRiga = RowScontrCUSTOM_MF(-1, "SCN_DOC_DOC", (vTotCalcolato - gtParam4RegCas.pImpTotale))   'Compongo la stringa SCONTO RIGA
               vRet = VbCEFWrite(vStrRiga, vRetErr)
                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
            End If
         End If
     
     
         'Stringa di IMPORTO RICEVUTO
         'If gtParam4RegCas.pImpRicPerScontrino > gtParam4RegCas.pImpTotale Then
            vStrRiga = RowScontrCUSTOM_MF(-1, "IMP_RIC", IIf(gtParam4RegCas.pImpRicPerScontrino > gtParam4RegCas.pImpTotale, gtParam4RegCas.pImpRicPerScontrino, gtParam4RegCas.pImpTotale))
            vRet = VbCEFWrite(vStrRiga, vRetErr)
               Print #NumFile, vStrRiga 'Stampo la stringa nel File
         'End If
         
         ' Close Document
         vStrRiga = "3011"
         vRet = VbCEFWrite(vStrRiga, vRetErr)
            Print #NumFile, vStrRiga 'Stampo la stringa nel File
         
         
         'Verifico se devo inserire la riga di riferimento (vale per scontrini a 0 in presenza di Prepagati o Abbonamenti)
         If Len(Trim(gtParam4RegCas.pRifDocFat)) > 0 Then
            vStrRiga = RowScontrCUSTOM_MF(-1, "CORTESIA", 0, 0, gtParam4RegCas.pRifDocFat)
            vRet = VbCEFWrite(vStrRiga, vRetErr)
               Print #NumFile, vStrRiga 'Stampo la stringa nel File
         
            'NB: dato che l'avanzamento carta NON funziona inserisco 2 righe di cortesia VUOTE dopo la stampa del Codice Fiscale!
            vStrRiga = "3012101 "
            vRet = VbCEFWrite(vStrRiga, vRetErr)
               Print #NumFile, vStrRiga 'Stampo la stringa nel File
            
            'Se non ci sono punti da stampare allora imposto altre 3 righe vuote
            If (Len(gtParam4RegCas.pCodFisc) = 0) And (gtParam4RegCas.pPuntiFid = 0) Then
               vStrRiga = "3012101 "
               vRet = VbCEFWrite(vStrRiga, vRetErr)
                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
               vStrRiga = "3012101 "
               vRet = VbCEFWrite(vStrRiga, vRetErr)
                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
               vStrRiga = "3012101 "
               vRet = VbCEFWrite(vStrRiga, vRetErr)
                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
            End If
         End If
         
         
         'Verifico se devo stampare il Codice Fiscale (TESTATO = OK!)
         If Len(gtParam4RegCas.pCodFisc) > 0 Then
            vStrRiga = RowScontrCUSTOM_MF(-1, "CORTESIA", 0, 0, "- C.F.: " & gtParam4RegCas.pCodFisc & " -")
            vRet = VbCEFWrite(vStrRiga, vRetErr)
               Print #NumFile, vStrRiga 'Stampo la stringa nel File
         
            'NB: dato che l'avanzamento carta NON funziona inserisco 2 righe di cortesia VUOTE dopo la stampa del Codice Fiscale!
            vStrRiga = "3012101 "
            vRet = VbCEFWrite(vStrRiga, vRetErr)
               Print #NumFile, vStrRiga 'Stampo la stringa nel File
            
            'Se non ci sono punti da stampare allora imposto altre 3 righe vuote
            If gtParam4RegCas.pPuntiFid = 0 Then
               vStrRiga = "3012101 "
               vRet = VbCEFWrite(vStrRiga, vRetErr)
                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
               vStrRiga = "3012101 "
               vRet = VbCEFWrite(vStrRiga, vRetErr)
                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
               vStrRiga = "3012101 "
               vRet = VbCEFWrite(vStrRiga, vRetErr)
                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
            End If
         End If
         
         
         'Stampo la riga di Cortesia con il totale dei Punti Fedelet accumulati
         If gtParam4RegCas.pPuntiFid > 0 Then
            vStrRiga = RowScontrCUSTOM_MF(-1, "CORTESIA", 0, 0, ">>> PUNTI FIDELITY: " & Trim(Str(gtParam4RegCas.pPuntiFid)) & " <<<") 'Inserisco la riga con le Quantit
            vRet = VbCEFWrite(vStrRiga, vRetErr)
               Print #NumFile, vStrRiga 'Stampo la stringa nel File
         
   '         ' AVANZAMENTO CARTA
   '         vStrRiga = "7001 0"
   '         vRet = VbCEFWrite(vStrRiga, vRetErr)
         
            'NB: dato che l'avanzamento carta NON funziona inserisco 4 righe di cortesia VUOTE dopo la stampa dei punti!
            vStrRiga = "3012101 "
            vRet = VbCEFWrite(vStrRiga, vRetErr)
               Print #NumFile, vStrRiga 'Stampo la stringa nel File
            vStrRiga = "3012101 "
            vRet = VbCEFWrite(vStrRiga, vRetErr)
               Print #NumFile, vStrRiga 'Stampo la stringa nel File
            vStrRiga = "3012101 "
            vRet = VbCEFWrite(vStrRiga, vRetErr)
               Print #NumFile, vStrRiga 'Stampo la stringa nel File
            vStrRiga = "3012101 "
            vRet = VbCEFWrite(vStrRiga, vRetErr)
               Print #NumFile, vStrRiga 'Stampo la stringa nel File
            
         End If
               
         ' Print and Cut
         vStrRiga = "3013"
         vRet = VbCEFWrite(vStrRiga, vRetErr)
            Print #NumFile, vStrRiga 'Stampo la stringa nel File
         
            'Chiudo il file
            Close #NumFile
      End With
   
   Else
      'qui ciclo sul file dell'ultimo scontrino e passo le singole righe alla Dll
      
      'Qui se trattasi di RISTAMPA di ULTIMO SCONTRINO lo copio direttamente dalla cartella di storico _
       nella cartella di destinazione senza passare dall sub GestFileScontrino ( inutile)

      Dim ApriFile As String
      
      NumFile = FreeFile
      ApriFile = PathREGCAS & "\Storico\" & gtParam4RegCas.pRistScontrino
         
      Open ApriFile For Input As #FreeFile
      Do Until EOF(NumFile)
         'Leggo la riga
         Line Input #NumFile, vStrRiga
                  
         'passo la riga alla Dll
         vRet = VbCEFWrite(vStrRiga, vRetErr)
      Loop
      Close #FreeFile
      
   End If
   
   
   'Close Communication on Com Port
   vRet = VbCEFClose(vRetErr)
   
   StampaScontrinoCUSTOM_MF = True
End Function

Private Function RowScontrCUSTOM_MF(pRiga As Integer, pTipo As String, Optional pValore As Currency, Optional pReparto As Byte, Optional pTesto As String) As String
   Dim vStrValScontoDoc As String
   Dim vDescr As String
   'Dim RowScontrCUSTOM_MF As String
   Dim vLenDescr As Byte
   Dim vVal As Currency
   'Compone la riga dello scontrino per DATAPROCESS

   With mpGridScontrino
      
      'Se una riga con descrizione allora tolgo eventuali parentesi dalla descrizione
      If pRiga > -1 Then
         vDescr = Trim(Mid(.Rows(pRiga).Record.Item(gtParam4RegCas.pColCodArt + 1).Value, 1, 22))
         'vDescr = RTrim(Replace(vDescr, "(", " "))
         'vDescr = RTrim(Replace(vDescr, ")", " "))
         vDescr = PulisciDescrizioneScontrino(vDescr)
      End If
      
      Select Case pTipo
         Case "STD" 'riga STANDARD
            RowScontrCUSTOM_MF = IIf(pReparto = 0, "3001", "3101") 'Codice per "Operazione Fiscale"
            If CCur(.Rows(pRiga).Record.Item(gtParam4RegCas.pColPrzQta).Value) < 0 Then
               RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & "3"  'Funzione per "Vendita" ma con importo negativo (Es: PREPAGATO) In questo caso va considerato come uno sconto a valore
            Else
               RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & "1"  'Funzione per "Vendita"
            End If
            
            If pReparto > 0 Then
               'RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & Trim(Str(pReparto)) & Space(2 - Len(Trim(Str(pReparto))))   'Reparto
               RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & String(2 - Len(Trim(Str(pReparto))), "0") & Trim(Str(pReparto)) 'Reparto
            End If
               vLenDescr = Len(Trim(vDescr))
            RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr)) 'Lunghezza della Descrizione
            RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & vDescr
               If CCur(.Rows(pRiga).Record.Item(gtParam4RegCas.pColPrzQta).Value) < 0 Then 'se  un importo negativo allora lo inverto perch altrimenti NON funziona
                  vDescr = Format((.Rows(pRiga).Record.Item(gtParam4RegCas.pColPrzQta).Value * (-1)), "########0.#0") 'Prezzo x Quantit (Senza Sconti!)
               Else
                  vDescr = Format(.Rows(pRiga).Record.Item(gtParam4RegCas.pColPrzQta).Value, "########0.#0") 'Prezzo x Quantit (Senza Sconti!)
               End If
               vDescr = Trim(Replace(vDescr, ",", "")) 'Prezzo
            RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & String(9 - Len(vDescr), "0") & vDescr 'Aggiungo il Prezzo alla riga da stampare
         
         Case "QTA" 'riga delle Quantit
            vDescr = Space(10 - Len(Trim(.Rows(pRiga).Record.Item(gtParam4RegCas.pColQuanti).Value))) 'Spazi prima delle quantit
            vDescr = vDescr & .Rows(pRiga).Record.Item(gtParam4RegCas.pColQuanti).Value & "x"  'quantit con simbolo "x"
            vDescr = vDescr & Space(10 - Len(Trim(.Rows(pRiga).Record.Item(gtParam4RegCas.pColPrezzo).Value))) 'Spazi prima del prezzo unitario
            vDescr = vDescr & .Rows(pRiga).Record.Item(gtParam4RegCas.pColPrezzo).Value 'Prezzo unitario
            RowScontrCUSTOM_MF = "3002" 'Riga descrittiva
            RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & "1"  'Testo Normale
               vLenDescr = Len(vDescr)
            RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr)) 'Lunghezza della Descrizione
            RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & vDescr
         
         Case "RESO" 'riga RESO
            RowScontrCUSTOM_MF = IIf(pReparto = 0, "3001", "3101") 'Codice per "Operazione Fiscale"
            RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & "9"  'Funzione per "RESO"
            If pReparto > 0 Then
               'RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & Trim(Str(pReparto)) & Space(2 - Len(Trim(Str(pReparto))))   'Reparto
               RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & String(2 - Len(Trim(Str(pReparto))), "0") & Trim(Str(pReparto)) 'Reparto
            End If
               vLenDescr = Len(Trim(vDescr))
            RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr)) 'Lunghezza della Descrizione
            RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & vDescr
               vDescr = Format(.Rows(pRiga).Record.Item(gtParam4RegCas.pColPrzQta).Value, "########0.#0") 'Prezzo x Quantit (Senza Sconti!)
               If CCur(vDescr) < 0 Then
                  vDescr = CCur(vDescr) * (-1)
                  vDescr = Format(vDescr, "########0.#0") 'Prezzo x Quantit (Senza Sconti!)
               End If
               vDescr = Trim(Replace(vDescr, ",", "")) 'Prezzo
            RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & String(9 - Len(vDescr), "0") & vDescr 'Aggiungo il Prezzo alla riga da stampare
         
         Case "TESTO" 'riga di Testo Libero
            vDescr = pTesto
            RowScontrCUSTOM_MF = "3002" 'Riga descrittiva
            RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & "1"  'testo Normale
               vLenDescr = Len(vDescr)
            RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr)) 'Lunghezza della Descrizione
            RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & vDescr
         
         Case "SCN_RIG" 'riga SCONTO RIGA %
            vDescr = "(%-)     " & Format(.Rows(pRiga).Record.Item(gtParam4RegCas.pColScont1).Value, "##0.#0") & "%"
            RowScontrCUSTOM_MF = IIf(pReparto = 0, "3001", "3101") 'Codice per "Operazione Fiscale"
            RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & "3"  'Funzione per "Sconto"
            If pReparto > 0 Then
               'RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & Trim(Str(pReparto)) & Space(2 - Len(Trim(Str(pReparto))))   'Reparto
               RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & String(2 - Len(Trim(Str(pReparto))), "0") & Trim(Str(pReparto)) 'Reparto
            End If
               vLenDescr = Len(Trim(vDescr))
            RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr)) 'Lunghezza della Descrizione
            RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & vDescr
               'vVal = (CCur(.Rows(pRiga).Record.Item(gtParam4RegCas.pColPrezzo)) * CCur(.Rows(pRiga).Record.Item(gtParam4RegCas.pColQuanti))) - CCur(.Rows(pRiga).Record.Item(gtParam4RegCas.pColImpNet)) 'calcolo l'importo da scontare moltiplicando la quantit con il prezzo unitario e sottraendo l'importo netto
               vVal = CCur(.Rows(pRiga).Record.Item(gtParam4RegCas.pColPrzQta).Value) - CCur(.Rows(pRiga).Record.Item(gtParam4RegCas.pColImpNet).Value)  'calcolo l'importo da scontare moltiplicando la quantit con il prezzo unitario e sottraendo l'importo netto
               vDescr = Format(vVal, "########0.#0") 'Importo da scontare
               vDescr = Trim(Replace(vDescr, ",", ""))
            RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & String(9 - Len(vDescr), "0") & vDescr 'Aggiungo il Prezzo alla riga da stampare
         
         Case "SCN_DOC_PER" 'riga SCONTO DOCUMENTO IN PERCENTUALE
            'vStrValScontoDoc = Format(gtParam4RegCas.pScontoDoc, "########0.#0")
            'RowScontrCUSTOM_MF = "=S" & vbNewLine ' Valori fissi Riga
            'RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & "=%/*"  ' Valori fissi Riga
            'RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & Replace(vStrValScontoDoc, ",", ".")
            vDescr = "SCONTO   " & Format(gtParam4RegCas.pScontoDoc, "##0.#0") & "%"
            RowScontrCUSTOM_MF = IIf(pReparto = 0, "3001", "3101") 'Codice per "Operazione Fiscale"
            RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & "3"  'Funzione per "Sconto"
            If pReparto > 0 Then
               'RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & Trim(Str(pReparto)) & Space(2 - Len(Trim(Str(pReparto))))   'Reparto
               RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & String(2 - Len(Trim(Str(pReparto))), "0") & Trim(Str(pReparto)) 'Reparto
            End If
               vLenDescr = Len(Trim(vDescr))
            RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr)) 'Lunghezza della Descrizione
            RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & vDescr
               vVal = pValore
               vDescr = Format(vVal, "########0.#0") 'Importo da scontare
               vDescr = Trim(Replace(vDescr, ",", ""))
            RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & String(9 - Len(vDescr), "0") & vDescr 'Aggiungo il Prezzo alla riga da stampare
         
         Case "SCN_DOC_DOC" 'riga SCONTO DOCUMENTO A VALORE
            vDescr = "SCONTO"
            RowScontrCUSTOM_MF = IIf(pReparto = 0, "3001", "3101") 'Codice per "Operazione Fiscale"
            RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & "3"  'Funzione per "Sconto"
            If pReparto > 0 Then
               'RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & Trim(Str(pReparto)) & Space(2 - Len(Trim(Str(pReparto))))   'Reparto
               RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & String(2 - Len(Trim(Str(pReparto))), "0") & Trim(Str(pReparto)) 'Reparto
            End If
               vLenDescr = Len(Trim(vDescr))
            RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr)) 'Lunghezza della Descrizione
            RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & vDescr
               vVal = pValore
               vDescr = Format(vVal, "########0.#0") 'Importo da scontare
               vDescr = Trim(Replace(vDescr, ",", ""))
            RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & String(9 - Len(vDescr), "0") & vDescr 'Aggiungo il Prezzo alla riga da stampare
         
         Case "IMP_RIC" 'riga Importo Ricevuto
            vDescr = "CONTANTE"
            RowScontrCUSTOM_MF = "3004" 'Codice per "Operazione Fiscale"
               vLenDescr = Len(Trim(Mid(vDescr, 1, 22)))
            RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr)) 'Lunghezza della Descrizione
            RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & vDescr
               vDescr = Format(pValore, "########0.#0") 'Importo Ricevuto
               vDescr = Trim(Replace(vDescr, ",", ""))
            RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & String(9 - Len(vDescr), "0") & vDescr 'Aggiungo il Prezzo alla riga da stampare
      
         Case "CORTESIA" 'riga di Cortesia (viene stampata dopo il Totale
            vDescr = pTesto
            RowScontrCUSTOM_MF = "3012" 'Riga descrittiva
            RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & "6"  'testo Corsivo
               vLenDescr = Len(vDescr)
            RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr)) 'Lunghezza della Descrizione
            RowScontrCUSTOM_MF = RowScontrCUSTOM_MF & vDescr
      
      End Select
      
   End With
   
End Function


Private Function StampaScontrinoCUSTOM_RT(vTipConn As String, vApriCas As String, _
                                          vIndirIP As String, vNumPort As String, _
                                          vBaudRat As String, vBitDati As String, vParita As String, vBitStop As String, vFlusso As String, _
                                          vNomeStampante As String) As Boolean
   Dim vStrRiga As String
   Dim i As Integer
   Dim vTotCalcolato As Currency
   Dim vVal As String
   
   Dim vRet As Long
   Dim vRetErr As Long
   
   Dim NumFile As Integer 'per aprire il file che mi serve per storicizzare lo scontrino ed eventualmente ristamparlo
   Dim vArr() As String
   Dim Y As Byte
   Dim vErrWrite As Boolean
   Dim vPortaAperta As Boolean
   Dim vFileAperto As Boolean
   
   On Error GoTo GestErr
   
   Call VerificaEsistenzaPathCartella(PathREGCAS & "\Storico")
      

   ' Open Communication
   If vTipConn = "R" Then 'RETE
      vRet = VbCEFOpenEthCustom(vIndirIP, CLng(vNumPort), vRetErr)
   'ElseIf vTipConn = "U" Then 'USB
   '   vRet = VbCEFOpenUSBCustom(vNomeStampante, vRetErr)
   '   Call MsgRegCasInLogFile("[ScontrinoCustom_RT] - VbCEFOpenEthCustom: " & vRet, (vRet <> 0))
   Else 'SERIALE
       vRet = VbCEFOpenCustom(CLng(vNumPort), CLng(vBaudRat), CByte(vParita), CByte(vBitDati), CByte(vBitStop), CByte(vFlusso), CLng(vRetErr))
   End If
   vPortaAperta = True
   
   ' Check Init
   Call MsgRegCasInLogFile("[ScontrinoCustom_RT] - OpenConn '" & IIf(vTipConn = "R", "Rete", "Seriale") & "': " & vRet, (vRet <> 0))
   If (vRet <> 0) Then
      MsgBox "ATTENZIONE!" & vbNewLine & _
             "Errore di Comunicazione", (vbOKOnly + vbCritical)
      Exit Function
   End If
   
   'vRetA = Int(Combo1.Text)
   
   
   'verifico che non si tratti di una ristampa...
   'If Len(gtParam4RegCas.pRistScontrino) = 0 Then
           
      'qui apri il file che creo comunque per la storicizzazione dello scontrino e l'eventuale ristampa
      NumFile = FreeFile
      'Open App.path & "\temp.txt" For Append As #NumFile      'CREO IL FILE
      Dim vNomeFileStorico As String
      vNomeFileStorico = Replace(Format(Date, "yyyy-mm-dd") & "_" & Format(Now, "hh.nn.ss"), ":", ".") & ".txt"
      Open PathREGCAS & "\Storico\" & vNomeFileStorico For Append As #NumFile      'CREO IL FILE
      vFileAperto = True
      
      '...altrimenti creo le righe da inviare alla Dll Custom
      'Setta la stampa NON Bufferizzata (la stampa dei prodotti avviene articolo per articolo)
      vStrRiga = "30160"
      'vRet = VbCEFWriteCustom(vStrRiga, vRetErr)
      If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
         Print #NumFile, vStrRiga 'Stampo la stringa nel File
      
      'RIGHE
      With mpGridScontrino
         vTotCalcolato = 0
         
         For i = 0 To .Rows.Count - 1
            vTotCalcolato = vTotCalcolato + .Rows(i).Record.Item(gtParam4RegCas.pColImpNet).Value
            
            
         'Eventuale linea di separazione
            If gtParam4RegCas.pColStmpSeparLineBefore > 0 Then
               If .Rows(i).Record.Item(gtParam4RegCas.pColStmpSeparLineBefore).Value = 1 Then
                  vStrRiga = "3002128"
                  vStrRiga = vStrRiga & " " & String(20, "-") & " "
                  'vRet = VbCEFWriteCustom(vStrRiga, vRetErr)
                  If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
               End If
            End If
            
            
            'Qui controllo se si tratta di reso perch prima delle quantit inserisco una riga descrittiva per dire che l'articolo/i successivo  un reso
            If .Rows(i).Record.Item(gtParam4RegCas.pColSimbol).Value = "R" Then
               vStrRiga = RowScontrCUSTOM_RT(i, "TESTO", 0, 0, "   --- R E S O ---") 'Inserisco la riga con le Quantit
               'vRet = VbCEFWriteCustom(vStrRiga, vRetErr)
               If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
            End If
            
            If CDbl(.Rows(i).Record.Item(gtParam4RegCas.pColQuanti).Value) <> 1 Then
               vStrRiga = RowScontrCUSTOM_RT(i, "QTA")  'Inserisco la riga con le Quantit
               'vRet = VbCEFWriteCustom(vStrRiga, vRetErr)
               If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
            End If
            
            'Qui verifico se c'e' l'associazione del Codice IVA con il Reparti del Registratore di Cassa
            vVal = ReadINI("REPARTIIVA_REPARTI", .Rows(i).Record.Item(gtParam4RegCas.pColRepIVA).Value, mPathFileConf4Scontrino)
            If Len(Trim(vVal)) > 0 Then vVal = Replace(UCase(vVal), "REPARTO", "")
            If IsNumeric(vVal) = False Then vVal = "0"
            
            'Controllo se si tratta di un RESO o di un articolo normale di vendita
            'If .CellBackColor = Colore("rosso1") Then
            If .Rows(i).Record.Item(gtParam4RegCas.pColSimbol).Value = "R" Then
               vStrRiga = RowScontrCUSTOM_RT(i, "RESO", 0, CByte(vVal)) 'Compongo la stringa di RESO
            Else
               vStrRiga = RowScontrCUSTOM_RT(i, "STD", 0, CByte(vVal)) 'Compongo la stringa STANDARD
            End If
            'vRet = VbCEFWriteCustom(vStrRiga, vRetErr)
            If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
               Print #NumFile, vStrRiga 'Stampo la stringa nel File
            
            'Qui controllo se c' lo Sconto riga sull'Articolo
            If (.Rows(i).Record.Item(gtParam4RegCas.pColScont1).Value > 0) And (.Rows(i).Record.Item(gtParam4RegCas.pColPrezzo).Value > 0) Then
               vStrRiga = RowScontrCUSTOM_RT(i, "SCN_RIG", 0, CByte(vVal)) 'Compongo la stringa SCONTO RIGA
               'vRet = VbCEFWriteCustom(vStrRiga, vRetErr)
               If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
            End If
            
            
            If gtParam4RegCas.pColStmpAddMsgRow > 0 Then
               If Len(Trim(.Rows(i).Record.Item(gtParam4RegCas.pColStmpAddMsgRow).Value)) > 0 Then
                  vArr = Split(.Rows(i).Record.Item(gtParam4RegCas.pColStmpAddMsgRow).Value, "")
                  For Y = 0 To UBound(vArr)
                     vStrRiga = "30021" & Len(vArr(Y))
                     vStrRiga = vStrRiga & vArr(Y)
                     'vRet = VbCEFWriteCustom(vStrRiga, vRetErr)
                     If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
                  Next Y
                  Erase vArr
               End If
            End If
            
         Next i
     
     
         'Eventuali SCONTI sul DOCUMENTO
         If vTotCalcolato > gtParam4RegCas.pImpTotale Then
            If gtParam4RegCas.pScontoPercent = True Then 'Controllo se  in PERCENTUALE...
               'Stampo il Subtotale
                  vStrRiga = "3003"
                  'vRet = VbCEFWriteCustom(vStrRiga, vRetErr)
                  If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
               '-------------------
               vStrRiga = RowScontrCUSTOM_RT(-1, "SCN_DOC_PER", (vTotCalcolato - gtParam4RegCas.pImpTotale))   'Compongo la stringa SCONTO RIGA
               'vRet = VbCEFWriteCustom(vStrRiga, vRetErr)
               If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
            Else                          '...oppure se  a VALORE
               'Stampo il Subtotale
                  vStrRiga = "3003"
                  'vRet = VbCEFWriteCustom(vStrRiga, vRetErr)
                  If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
               '-------------------
               vStrRiga = RowScontrCUSTOM_RT(-1, "SCN_DOC_DOC", (vTotCalcolato - gtParam4RegCas.pImpTotale))   'Compongo la stringa SCONTO RIGA
               'vRet = VbCEFWriteCustom(vStrRiga, vRetErr)
               If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
            End If
         End If
     
     
'PAGAMENTO ////////////////////////////////////////
'      vStrRiga = RowScontrCUSTOM_RT(-1, "IMP_RIC", IIf(gtParam4RegCas.pImpRicPerScontrino > gtParam4RegCas.pImpTotale, gtParam4RegCas.pImpRicPerScontrino, gtParam4RegCas.pImpTotale))
'      vRet = VbCEFWriteCustom(vStrRiga, vRetErr)
'         Print #NumFile, vStrRiga 'Stampo la stringa nel File
         
'gTipPagSubtot   struttura x, 0 -> Codice Tipo Pagamento _
                           x, 1 -> Importo Pagamento _
                           x, 2 -> Conto Incasso (campo TGTESTO1 della tabella TAB_GEN con CHIAVE = 'PAGAME') _
                           x, 3 -> Codice per Registratore Telematico (campo TGSPUNTA2 della tabella TAB_GEN con CHIAVE = 'PAGAME') _
                           x, 4 -> Importo Pagamento (all'origine, perch durante gl'incasso il valore viene svuotato e allo scontrino arriverebbe vuoto)
                           
       'Stringa di IMPORTO RICEVUTO (prendo la descrizione dalla gTipPagSubtot(0, 1))
         If Not gtParam4RegCas.pEseguiReso Then 'il pagamento NON va indicato in caso di RESO
            Dim vDesPagam As String
            
            Dim vNoDescPersonal As Boolean
            vNoDescPersonal = (ReadINI("OPZIONI", "NO_PAGAMENTI", mPathFileConf4Scontrino) = "1")
            
            vDesPagam = DecodDesPagamento(gTipPagSubtot(0, 0), vNoDescPersonal)
            vStrRiga = RowScontrCUSTOM_RT(-1, "IMP_RIC", CCur(gTipPagSubtot(0, 4)), 0, vDesPagam, gTipPagSubtot(0, 3))
            'vRet = VbCEFWriteCustom(vStrRiga, vRetErr)
            If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
            Print #NumFile, vStrRiga 'Stampo la stringa nel File
                     
            'Verifico se c' il pagamento 2
               If Len(Trim(gTipPagSubtot(1, 0))) > 0 Then
                  vDesPagam = DecodDesPagamento(gTipPagSubtot(1, 0), vNoDescPersonal)
                  vStrRiga = RowScontrCUSTOM_RT(-1, "IMP_RIC", CCur(gTipPagSubtot(1, 4)), 0, vDesPagam, gTipPagSubtot(1, 3))
                  'vRet = VbCEFWriteCustom(vStrRiga, vRetErr)
                  If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
               End If
            
            'Verifico se c' il pagamento 3
               If Len(Trim(gTipPagSubtot(2, 0))) > 0 Then
                  vDesPagam = DecodDesPagamento(gTipPagSubtot(2, 0), vNoDescPersonal)
                  vStrRiga = RowScontrCUSTOM_RT(-1, "IMP_RIC", 0, CCur(gTipPagSubtot(2, 4)), vDesPagam, gTipPagSubtot(2, 3))
                  'vRet = VbCEFWriteCustom(vStrRiga, vRetErr)
                  If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
               End If
         End If
'FINE PAGAMENTO ////////////////////////////////////////
                                
                                
         'Stampa del Codice Fiscale
            'vVal = ReadINI("SCONTRINI", "NO_CODFIS", IniPath)
            'If Not (vVal = "T") Then
            vVal = ReadINI("OPZIONI", "NO_CODFIS", mPathFileConf4Scontrino)
            If Not (vVal = "1") Then
               'Verifico se devo stampare il Codice Fiscale (TESTATO = OK!)
               If Len(gtParam4RegCas.pCodFisc) > 0 Then
                  vStrRiga = RowScontrCUSTOM_RT(-1, "COD_FIS", 0, 0, gtParam4RegCas.pCodFisc)
                  'vRet = VbCEFWriteCustom(vStrRiga, vRetErr)
                  If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
               
                  ''NB: dato che l'avanzamento carta NON funziona inserisco 2 righe di cortesia VUOTE dopo la stampa del Codice Fiscale!
                  'vStrRiga = "3012101 "
                  ''vRet = VbCEFWriteCustom(vStrRiga, vRetErr)
                  'If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                  '   Print #NumFile, vStrRiga 'Stampo la stringa nel File
                  
                  ''Se non ci sono punti da stampare allora imposto altre 3 righe vuote
                  'If gtParam4RegCas.pPuntiFid = 0 Then
                  '   vStrRiga = "3012101 "
                  '   'vRet = VbCEFWriteCustom(vStrRiga, vRetErr)
                  '   If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                  '      Print #NumFile, vStrRiga 'Stampo la stringa nel File
                  '   vStrRiga = "3012101 "
                  '   'vRet = VbCEFWriteCustom(vStrRiga, vRetErr)
                  '   If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                  '      Print #NumFile, vStrRiga 'Stampo la stringa nel File
                  '   vStrRiga = "3012101 "
                  '   'vRet = VbCEFWriteCustom(vStrRiga, vRetErr)
                  '   If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                  '      Print #NumFile, vStrRiga 'Stampo la stringa nel File
                  'End If
               End If
            End If
                
         
         ' Close Document
         vStrRiga = "3011"
         'vRet = VbCEFWriteCustom(vStrRiga, vRetErr)
         If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
            Print #NumFile, vStrRiga 'Stampo la stringa nel File
         
         
         
         'Verifico se posso stampare le righe di Cortesia (Introdotta perch il firmware dei BigIII non gestisce in questo modo le righe di cortesia e non siappiamo come fare! - 11.dic.2019)
         'If ReadINI("OPZIONI", "NO_RIGHE_CORTESIA", mPathFileConf4Scontrino) <> "1" Then
         
         
            'Verifico se devo inserire la riga di riferimento (vale per scontrini a 0 in presenza di Prepagati o Abbonamenti)
            If Len(Trim(gtParam4RegCas.pRifDocFat)) > 0 Then
               'gtParam4RegCas.pRifDocFat = Replace(gtParam4RegCas.pRifDocFat, "Doc.C", "Doc. Comm.")
               'vPos = InStr(1, LCase(gtParam4RegCas.pRifDocFat), "nr")
            
               vStrRiga = RowScontrCUSTOM_RT(-1, "CORTESIA", 0, 0, gtParam4RegCas.pRifDocFat)
               If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
            
               'NB: dato che l'avanzamento carta NON funziona inserisco 2 righe di cortesia VUOTE dopo la stampa del Codice Fiscale!
               'vStrRiga = "3010101 "
               'If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
               '   Print #NumFile, vStrRiga 'Stampo la stringa nel File
               vStrRiga = RowScontrCUSTOM_RT(-1, "CORTESIA", 0, 0, " ")
               If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
               
               
               'Se non ci sono punti da stampare allora imposto altre 3 righe vuote
               If (Len(gtParam4RegCas.pCodFisc) = 0) And (gtParam4RegCas.pPuntiFid = 0) Then
                  'vStrRiga = "3010101 "
                  'If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                  '      Print #NumFile, vStrRiga 'Stampo la stringa nel File
                  vStrRiga = RowScontrCUSTOM_RT(-1, "CORTESIA", 0, 0, " ")
                  If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
                     
                  'vStrRiga = "3010101 "
                  'If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                  '   Print #NumFile, vStrRiga 'Stampo la stringa nel File
                  vStrRiga = RowScontrCUSTOM_RT(-1, "CORTESIA", 0, 0, " ")
                  If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
                     
                  'vStrRiga = "3010101 "
                  'If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                  '   Print #NumFile, vStrRiga 'Stampo la stringa nel File
                  vStrRiga = RowScontrCUSTOM_RT(-1, "CORTESIA", 0, 0, " ")
                  If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
               End If
            End If
                           
            
            
   'LINEE DI CORTESIA ===========================================================================================================
   '     '===========================================================================================================
               Dim vLineeCortesia As Boolean
               vLineeCortesia = ((gtParam4RegCas.pPrepagResiduo > 0) Or (gtParam4RegCas.pPuntiFid > 0) Or (Len(gtParam4RegCas.pVoucherID) > 0))
               
               If vLineeCortesia Then
                  'vStrRiga = "3010101 " 'LINEA VUOTA
                  'If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                  '   Print #NumFile, vStrRiga 'Stampo la stringa nel File
                  vStrRiga = RowScontrCUSTOM_RT(-1, "CORTESIA", 0, 0, " ")
                  If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
               
                  'vStrRiga = "3002128" 'LINEA TRATTEGGIATA
                  'vStrRiga = vStrRiga & " " & String(30, "-") & " "
                  'If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                  '   Print #NumFile, vStrRiga 'Stampo la stringa nel File
                  vStrRiga = RowScontrCUSTOM_RT(-1, "CORTESIA", 0, 0, String(28, "-"))
                  If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
               End If
         '===========================================================================================================
            
            If gtParam4RegCas.pPrepagResiduo > 0 Then
               'vStrRiga = "3010101 " 'LINEA VUOTA
               'If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
               '   Print #NumFile, vStrRiga 'Stampo la stringa nel File
               vStrRiga = RowScontrCUSTOM_RT(-1, "CORTESIA", 0, 0, " ")
                  If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
                        
                  vStrRiga = RowScontrCUSTOM_RT(-1, "CORTESIA", 0, 0, " PREPAGATO DISPONIBILE")
                  If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
            
                  vStrRiga = RowScontrCUSTOM_RT(-1, "CORTESIA", 0, 0, "      " & Format(gtParam4RegCas.pPrepagResiduo, "#####0.#0"), "", True)
                  If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
            
               'vStrRiga = "3010101 " 'LINEA VUOTA
               'If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
               '   Print #NumFile, vStrRiga 'Stampo la stringa nel File
               vStrRiga = RowScontrCUSTOM_RT(-1, "CORTESIA", 0, 0, " ")
                  If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
            End If
                           
            
            'Stampo la riga di Cortesia con il totale dei Punti Fedelet accumulati
            If gtParam4RegCas.pPuntiFid > 0 Then
               'vStrRiga = "3010101 " 'LINEA VUOTA
               'If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
               '   Print #NumFile, vStrRiga 'Stampo la stringa nel File
               vStrRiga = RowScontrCUSTOM_RT(-1, "CORTESIA", 0, 0, " ")
                  If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
                  
                  vStrRiga = RowScontrCUSTOM_RT(-1, "CORTESIA", 0, 0, " PUNTI FIDELITY")
                  If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
            
                  vStrRiga = RowScontrCUSTOM_RT(-1, "CORTESIA", 0, 0, "        " & Trim(Str(gtParam4RegCas.pPuntiFid)), "", True)
                  If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
            
               'vStrRiga = "3010101 " 'LINEA VUOTA
               'If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
               '   Print #NumFile, vStrRiga 'Stampo la stringa nel File
               vStrRiga = RowScontrCUSTOM_RT(-1, "CORTESIA", 0, 0, " ")
                  If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
            End If
                  
                  
            'Stampo la riga di Cortesia con il riferimento al N. Voucher e Importo
            If Len(gtParam4RegCas.pVoucherID) > 0 Then
               'vStrRiga = "3010101 " 'LINEA VUOTA
               'If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
               '   Print #NumFile, vStrRiga 'Stampo la stringa nel File
               vStrRiga = RowScontrCUSTOM_RT(-1, "CORTESIA", 0, 0, " ")
                  If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
            
                  vStrRiga = RowScontrCUSTOM_RT(-1, "CORTESIA", 0, 0, "VOUCHER CARD")
                  If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
                  vStrRiga = RowScontrCUSTOM_RT(-1, "CORTESIA", 0, 0, " " & gtParam4RegCas.pVoucherID, "", True)
                  If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
                              
                  vStrRiga = RowScontrCUSTOM_RT(-1, "CORTESIA", 0, 0, "Descrizione")
                  If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
                  vStrRiga = RowScontrCUSTOM_RT(-1, "CORTESIA", 0, 0, " " & PulisciDescrizioneScontrino(gtParam4RegCas.pVoucherDescr), "", True)
                  If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
                              
                  vStrRiga = RowScontrCUSTOM_RT(-1, "CORTESIA", 0, 0, "Valore")
                  If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
                  vStrRiga = RowScontrCUSTOM_RT(-1, "CORTESIA", 0, 0, " " & Format(gtParam4RegCas.pVoucherValue, "#####0.#0"), "", True)
                  If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
               
               'vStrRiga = "3010101 " 'LINEA VUOTA
               'If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
               '   Print #NumFile, vStrRiga 'Stampo la stringa nel File
               vStrRiga = RowScontrCUSTOM_RT(-1, "CORTESIA", 0, 0, " ")
                  If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
            End If
            
            
   'CHIUSURA LINEE DI CORTESIA ===================================================================================
            If vLineeCortesia Then
               'vStrRiga = "3002128" 'LINEA TRATTEGGIATA
               'vStrRiga = vStrRiga & " " & String(30, "-") & " "
               'If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
               '   Print #NumFile, vStrRiga 'Stampo la stringa nel File
               vStrRiga = RowScontrCUSTOM_RT(-1, "CORTESIA", 0, 0, String(28, "-"))
               If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                  Print #NumFile, vStrRiga 'Stampo la stringa nel File

               'vStrRiga = "3010101 " 'LINEA VUOTA
               'If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
               '   Print #NumFile, vStrRiga 'Stampo la stringa nel File
               vStrRiga = RowScontrCUSTOM_RT(-1, "CORTESIA", 0, 0, " ")
                  If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
                     Print #NumFile, vStrRiga 'Stampo la stringa nel File
            End If
   '===========================================================================================================
            
            
            'Call AddArrayElement(vArrDoc, "=" & Chr(34) & "/&1/(S:" & gtParam4RegCas.pSerial & ")")
            'vStrRiga = "3002128" 'Seriale del Documento
            'vStrRiga = vStrRiga & " S:" & gtParam4RegCas.pSerial & " "
            'If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
            '   Print #NumFile, vStrRiga 'Stampo la stringa nel File
                  
            vStrRiga = RowScontrCUSTOM_RT(-1, "CORTESIA", 0, 0, " S:" & gtParam4RegCas.pSerial)
            If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
               Print #NumFile, vStrRiga 'Stampo la stringa nel File
         'End If
               
               
         ' Print and Cut
         vStrRiga = "3013"
         'vRet = VbCEFWriteCustom(vStrRiga, vRetErr)
         If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
            Print #NumFile, vStrRiga 'Stampo la stringa nel File
         
         
ChiusuraForzata:
            'Chiudo il file
            Close #NumFile
            vFileAperto = False
            
       
      End With
      
   
   'Close Communication on Com Port
      vRet = VbCEFClose(vRetErr)
      vPortaAperta = False
      Call MsgRegCasInLogFile("[ScontrinoCustom_RT] - CloseConn '" & IIf(vTipConn = "R", "Rete", "Seriale") & "': " & vRet, (vRet <> 0))
   
   
   If vErrWrite Then
      Exit Function
   End If
   
   
'ESITO FINALE - - - - - - - - - -
   'Verifico se devo attendere la risposta
   If ReadINI("PARAMETRI", "WAIT_OUT_REG", mPathFileConf4Scontrino) = "1" Then
      Dim vRisp As String
      vRisp = CUSTOMFunctionRT(getUltimoScontrino, False, mPathFileConf4Scontrino)
      If Mid(vRisp, 1, 3) = "ERR" Then
         MsgBox "Errore risposta da parte del Registratore" & vbNewLine & "Impossibile recuperare il numero del Documento di Vendita", msg_Exclamation
      Else
         'Salvo il tentativo nella tabella delle INFO con qualsiasi esito in modo da creare la storia della stampa del documento
         Call MsgRegCasInLogFile("[ScontrinoCustom_RT] - Insert_DOC_INFO_RT")
         Call Insert_DOC_INFO_RT
      End If
   Else
      Call MsgRegCasInLogFile("[ScontrinoCustom_RT] - Risposta Registratore non richiesta")
   End If
            
      
      ''Invio nil comando di reset (light) in modo da sboccare eventuali errori
         'If Not Scontrino_EPSON Then Call EpsonResetPrinter
   
   
   StampaScontrinoCUSTOM_RT = True


GestErr:
   If err.Number <> 0 Then
      Dim vErrStr As String
      
      'Salvo il Messaggio
         vErrStr = err.Number & " - " & err.Description & vbNewLine & ""
      
      'Close Communication on Com Port
         If vPortaAperta Then
         ' Close Document
            vStrRiga = RowScontrCUSTOM_RT(-1, "ERR", vTotCalcolato) 'Compongo la stringa di ANNULLO
               If Not fCustomWrite(vStrRiga) Then vErrWrite = True
               Print #NumFile, vStrRiga 'Chiusura forzata scontrino in corso
            If Not fCustomWrite("3011") Then vErrWrite = True
               Print #NumFile, vStrRiga 'Stampo la stringa nel File
         ' Print and Cut
            If Not fCustomWrite("3013") Then vErrWrite = True
               Print #NumFile, vStrRiga 'Stampo la stringa nel File
         'Chiusura Porta Ethernet
            vRet = VbCEFClose(vRetErr)
         'Chiudo il file
            If vFileAperto Then
               Close #NumFile
            End If
            
            Call MsgRegCasInLogFile("[ScontrinoCustom_RT] - CloseConn '" & IIf(vTipConn = "R", "Rete", "Seriale") & "': " & vRet, (vRet <> 0))
         End If
      
         Call MsgRegCasInLogFile("[ScontrinoCustom_RT] - " & vErrStr, True)
         MsgBox vErrStr & vbNewLine & _
                "(funct. 'ScontrinoCustom_RT')", msg_Critical
   End If
End Function

Private Function RowScontrCUSTOM_RT(pRiga As Integer, pTipo As String, Optional pValore As Currency, _
                                    Optional pReparto As Byte, Optional pTesto As String, _
                                    Optional pTipoPagTelematico As String, Optional pAltezzaDoppia As Boolean) As String
   Dim vStrValScontoDoc As String
   Dim vDescr As String
   'Dim RowScontrCUSTOM_RT As String
   Dim vLenDescr As Byte
   Dim vVal As Currency
   'Compone la riga dello scontrino per DATAPROCESS

   With mpGridScontrino
      
      'Se una riga con descrizione allora tolgo eventuali parentesi dalla descrizione
      If pRiga > -1 Then
         If gtParam4RegCas.pStmpDescrAltern Then 'verifico se devo prendere la descrizione alternativa
            vDescr = DecodDES_ALTREN_ARTICOLO(.Rows(pRiga).Record.Item(gtParam4RegCas.pColCodArt).Value)
         End If
         If Len(Trim(vDescr)) = 0 Then
            vDescr = Trim(Mid(.Rows(pRiga).Record.Item(gtParam4RegCas.pColCodArt + 1).Value, 1, 22))
         End If
         vDescr = Trim(Mid(PulisciDescrizioneScontrino(vDescr), 1, 22))
      End If
            
      
      Select Case pTipo
         Case "STD" 'riga STANDARD
            RowScontrCUSTOM_RT = IIf(pReparto = 0, "3001", "3101") 'Codice per "Operazione Fiscale"
            If CCur(.Rows(pRiga).Record.Item(gtParam4RegCas.pColPrzQta).Value) < 0 Then
               RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & "3"  'Funzione per "Vendita" ma con importo negativo (Es: PREPAGATO) In questo caso va considerato come uno sconto a valore
            Else
               RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & "1"  'Funzione per "Vendita"
            End If
            
            If pReparto > 0 Then
               'RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & Trim(Str(pReparto)) & Space(2 - Len(Trim(Str(pReparto))))   'Reparto
               RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & String(2 - Len(Trim(Str(pReparto))), "0") & Trim(Str(pReparto)) 'Reparto
            End If
               vLenDescr = Len(Trim(vDescr))
            RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr)) 'Lunghezza della Descrizione
            RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & vDescr
               If CCur(.Rows(pRiga).Record.Item(gtParam4RegCas.pColPrezzo).Value) < 0 Then 'se  un importo negativo allora lo inverto perch altrimenti NON funziona
                  vDescr = Format(((.Rows(pRiga).Record.Item(gtParam4RegCas.pColPrezzo).Value * .Rows(pRiga).Record.Item(gtParam4RegCas.pColQuanti).Value) * (-1)), "########0.#0") 'Prezzo x Quantit (Senza Sconti!)
               Else
                  vDescr = Format((.Rows(pRiga).Record.Item(gtParam4RegCas.pColPrezzo).Value * .Rows(pRiga).Record.Item(gtParam4RegCas.pColQuanti).Value), "########0.#0") 'Prezzo x Quantit (Senza Sconti!)
               End If
               
'               If CCur(.Rows(pRiga).Record.Item(gtParam4RegCas.pColPrzQta).Value) < 0 Then 'se  un importo negativo allora lo inverto perch altrimenti NON funziona
'                  vDescr = Format((.Rows(pRiga).Record.Item(gtParam4RegCas.pColPrzQta).Value * (-1)), "########0.#0") 'Prezzo x Quantit (Senza Sconti!)
'               Else
'                  vDescr = Format(.Rows(pRiga).Record.Item(gtParam4RegCas.pColPrzQta).Value, "########0.#0") 'Prezzo x Quantit (Senza Sconti!)
'               End If
               
               vDescr = Trim(Replace(vDescr, ",", "")) 'Prezzo
            RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & String(9 - Len(vDescr), "0") & vDescr 'Aggiungo il Prezzo alla riga da stampare
         
         Case "QTA" 'riga delle Quantit
            vDescr = Space(10 - Len(Trim(.Rows(pRiga).Record.Item(gtParam4RegCas.pColQuanti).Value))) 'Spazi prima delle quantit
            vDescr = vDescr & .Rows(pRiga).Record.Item(gtParam4RegCas.pColQuanti).Value & "x"  'quantit con simbolo "x"
            vDescr = vDescr & Space(10 - Len(Trim(.Rows(pRiga).Record.Item(gtParam4RegCas.pColPrezzo).Value))) 'Spazi prima del prezzo unitario
            vDescr = vDescr & .Rows(pRiga).Record.Item(gtParam4RegCas.pColPrezzo).Value 'Prezzo unitario
            RowScontrCUSTOM_RT = "3002" 'Riga descrittiva
            RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & "1"  'Testo Normale
               vLenDescr = Len(vDescr)
            RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr)) 'Lunghezza della Descrizione
            RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & vDescr
         
         Case "RESO" 'riga RESO
            RowScontrCUSTOM_RT = IIf(pReparto = 0, "3001", "3101") 'Codice per "Operazione Fiscale"
            RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & "9"  'Funzione per "RESO"
            If pReparto > 0 Then
               'RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & Trim(Str(pReparto)) & Space(2 - Len(Trim(Str(pReparto))))   'Reparto
               RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & String(2 - Len(Trim(Str(pReparto))), "0") & Trim(Str(pReparto)) 'Reparto
            End If
               vLenDescr = Len(Trim(vDescr))
            RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr)) 'Lunghezza della Descrizione
            RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & vDescr
               vDescr = Format(.Rows(pRiga).Record.Item(gtParam4RegCas.pColPrzQta).Value, "########0.#0") 'Prezzo x Quantit (Senza Sconti!)
               If CCur(vDescr) < 0 Then
                  vDescr = CCur(vDescr) * (-1)
                  vDescr = Format(vDescr, "########0.#0") 'Prezzo x Quantit (Senza Sconti!)
               End If
               vDescr = Trim(Replace(vDescr, ",", "")) 'Prezzo
            RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & String(9 - Len(vDescr), "0") & vDescr 'Aggiungo il Prezzo alla riga da stampare
         
         Case "TESTO" 'riga di Testo Libero
            vDescr = pTesto
            RowScontrCUSTOM_RT = "3002" 'Riga descrittiva
            RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & "1"  'testo Normale
               vLenDescr = Len(vDescr)
            RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr)) 'Lunghezza della Descrizione
            RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & vDescr
         
         Case "SCN_RIG" 'riga SCONTO RIGA %
            vDescr = "(%-)     " & Format(.Rows(pRiga).Record.Item(gtParam4RegCas.pColScont1).Value, "##0.#0") & "%"
            RowScontrCUSTOM_RT = IIf(pReparto = 0, "3001", "3101") 'Codice per "Operazione Fiscale"
            RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & "3"  'Funzione per "Sconto"
            If pReparto > 0 Then
               'RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & Trim(Str(pReparto)) & Space(2 - Len(Trim(Str(pReparto))))   'Reparto
               RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & String(2 - Len(Trim(Str(pReparto))), "0") & Trim(Str(pReparto)) 'Reparto
            End If
               vLenDescr = Len(Trim(vDescr))
            RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr)) 'Lunghezza della Descrizione
            RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & vDescr
               'vVal = (CCur(.Rows(pRiga).Record.Item(gtParam4RegCas.pColPrezzo)) * CCur(.Rows(pRiga).Record.Item(gtParam4RegCas.pColQuanti))) - CCur(.Rows(pRiga).Record.Item(gtParam4RegCas.pColImpNet)) 'calcolo l'importo da scontare moltiplicando la quantit con il prezzo unitario e sottraendo l'importo netto
               vVal = CCur(.Rows(pRiga).Record.Item(gtParam4RegCas.pColPrzQta).Value) - CCur(.Rows(pRiga).Record.Item(gtParam4RegCas.pColImpNet).Value)  'calcolo l'importo da scontare moltiplicando la quantit con il prezzo unitario e sottraendo l'importo netto
               vDescr = Format(vVal, "########0.#0") 'Importo da scontare
               vDescr = Trim(Replace(vDescr, ",", ""))
            RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & String(9 - Len(vDescr), "0") & vDescr 'Aggiungo il Prezzo alla riga da stampare
         
         Case "SCN_DOC_PER" 'riga SCONTO DOCUMENTO IN PERCENTUALE
            'vStrValScontoDoc = Format(gtParam4RegCas.pScontoDoc, "########0.#0")
            'RowScontrCUSTOM_RT = "=S" & vbNewLine ' Valori fissi Riga
            'RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & "=%/*"  ' Valori fissi Riga
            'RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & Replace(vStrValScontoDoc, ",", ".")
            vDescr = "SCONTO   " & Format(gtParam4RegCas.pScontoDoc, "##0.#0") & "%"
            RowScontrCUSTOM_RT = IIf(pReparto = 0, "3001", "3101") 'Codice per "Operazione Fiscale"
            RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & "3"  'Funzione per "Sconto"
            If pReparto > 0 Then
               'RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & Trim(Str(pReparto)) & Space(2 - Len(Trim(Str(pReparto))))   'Reparto
               RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & String(2 - Len(Trim(Str(pReparto))), "0") & Trim(Str(pReparto)) 'Reparto
            End If
               vLenDescr = Len(Trim(vDescr))
            RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr)) 'Lunghezza della Descrizione
            RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & vDescr
               vVal = pValore
               vDescr = Format(vVal, "########0.#0") 'Importo da scontare
               vDescr = Trim(Replace(vDescr, ",", ""))
            RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & String(9 - Len(vDescr), "0") & vDescr 'Aggiungo il Prezzo alla riga da stampare
         
         Case "SCN_DOC_DOC" 'riga SCONTO DOCUMENTO A VALORE
            vDescr = "SCONTO"
            RowScontrCUSTOM_RT = IIf(pReparto = 0, "3001", "3101") 'Codice per "Operazione Fiscale"
            RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & "3"  'Funzione per "Sconto"
            If pReparto > 0 Then
               'RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & Trim(Str(pReparto)) & Space(2 - Len(Trim(Str(pReparto))))   'Reparto
               RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & String(2 - Len(Trim(Str(pReparto))), "0") & Trim(Str(pReparto)) 'Reparto
            End If
               vLenDescr = Len(Trim(vDescr))
            RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr)) 'Lunghezza della Descrizione
            RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & vDescr
               vVal = pValore
               vDescr = Format(vVal, "########0.#0") 'Importo da scontare
               vDescr = Trim(Replace(vDescr, ",", ""))
            RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & String(9 - Len(vDescr), "0") & vDescr 'Aggiungo il Prezzo alla riga da stampare
         
         Case "IMP_RIC" 'riga Importo Ricevuto
            vDescr = pTesto
            Select Case pTipoPagTelematico
               Case 0 'Pagamento CONTANTI"
                  'vDescr = "CONTANTE"
                  RowScontrCUSTOM_RT = "3004"
               Case 1
                  'vDescr = "ASSEGNO"
                  RowScontrCUSTOM_RT = "3004"
               Case 2
                  'vDescr = "PAGAM. ELETTR."
                  RowScontrCUSTOM_RT = "3006"
               Case 3
                  'vDescr = "NON RISCOSSO"
                  RowScontrCUSTOM_RT = "3005"
            End Select
            vLenDescr = Len(Trim(Mid(vDescr, 1, 22)))
            RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr)) 'Lunghezza della Descrizione
            RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & vDescr
               vDescr = Format(pValore, "########0.#0") 'Importo Ricevuto
               vDescr = Trim(Replace(vDescr, ",", ""))
            RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & String(9 - Len(vDescr), "0") & vDescr 'Aggiungo il Prezzo alla riga da stampare
      
         Case "CORTESIA" 'riga di Cortesia (viene stampata dopo il Totale
            vDescr = pTesto
            RowScontrCUSTOM_RT = IIf(gtParam4RegCas.pGenerazioneCustom = "III", "3012", "3010") '"3012" 'Riga descrittiva
            RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & IIf(pAltezzaDoppia, "4", "1") 'Altezza doppia / Normale
               vLenDescr = Len(vDescr)
            RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr)) 'Lunghezza della Descrizione
            RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & vDescr
      
         Case "COD_FIS" 'riga per il Codice Fiscale
            vDescr = pTesto
            RowScontrCUSTOM_RT = "3010" 'Riga descrittiva
            RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & IIf(gtParam4RegCas.pGenerazioneCustom = "III", "B", "F") 'P.IVA / Cod.FIsc
               vLenDescr = Len(vDescr)
            RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr)) 'Lunghezza della Descrizione
            RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & vDescr
            
         Case "ERR" 'riga ANNULLA SCONTRINO in corso PER ERRORE
            RowScontrCUSTOM_RT = "3001"
            RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & "8"  'Funzione per ANNULLO TRANSAZIONE
            vDescr = "DOCUMENTO ANNULLATO"
            vLenDescr = Len(vDescr)
            RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr)) 'Lunghezza della Descrizione
            RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & vDescr
            vDescr = Format(pValore, "########0.#0")
            vDescr = Trim(Replace(vDescr, ",", "")) 'Prezzo
            RowScontrCUSTOM_RT = RowScontrCUSTOM_RT & String(9 - Len(vDescr), "0") & vDescr 'Aggiungo il Prezzo alla riga da stampare
      
      End Select
      
   End With
   
End Function

Public Function Test_CUSTOM(vTipConn As String, vApriCas As String, vIndirIP As String, _
                            vNumPort As String, vBaudRat As String, vBitDati As String, _
                            vParita As String, vBitStop As String, vFlusso As String, _
                            vFunzione As String, _
                            Optional vTEST As Boolean, Optional pMsg As String, _
                            Optional vNomeStampante As String) As String
   
   Dim vStrRiga As String
   Dim vVal As String
   
   Dim vRet As Long
   Dim vRetA As Long
   Dim vRetErr As Long
   Dim pBytBuffOut(1000) As Byte
  
   On Error GoTo GestErr
  

'QUI CONTROLLO SE DEVO VERIFICARE I PARAMETRI DI RETE E SERIALI (SOLO SE FACCIO IL TEST DELLA DATA!)
   If vTEST = True Then
      
      If vTipConn = "R" Then 'VALORI DI RETE

         'Qui prendo l'IP del Registratore
            'vIndirIP = ReadINI("RETE", "IP", mPathFileConf4Scontrino)
            If Len(Trim(vIndirIP)) = 0 Then
               MsgBox "ATTENZIONE!" & vbNewLine & _
                      "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
                      "(Tag [RETE] Parametro <IP> non presente)" & vbNewLine & vbNewLine & _
                      "Impossibile eseguire la stampa dello Scontrino.", vbCritical
               Exit Function
            End If
         'Qui prendo il NUMERO DI PORTA da passare nel file scontrino
            'vNumPort = ReadINI("RETE", "PORT", mPathFileConf4Scontrino)
            If Not IsNumeric(vNumPort) Then
               MsgBox "ATTENZIONE!" & vbNewLine & _
                      "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
                      "(Tag [RETE] Parametro <PORT> non valido)" & vbNewLine & vbNewLine & _
                      "Impossibile eseguire la stampa dello Scontrino.", vbCritical
               Exit Function
            End If
            
      Else
         'Qui prendo il NUMERO DI PORTA da passare nel file scontrino
            'vNumPort = ReadINI("SERIALE", "PORTA_COM", mPathFileConf4Scontrino)
            If Not IsNumeric(vNumPort) Then
               MsgBox "ATTENZIONE!" & vbNewLine & _
                      "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
                      "(Tag [SERIALE] Parametro <PORTA> non valido)" & vbNewLine & vbNewLine & _
                      "Impossibile eseguire la stampa dello Scontrino.", vbCritical
               Exit Function
            End If
         'Qui prendo il BAUD_RATE
            'vBaudRat = ReadINI("SERIALE", "BAUD_RATE", mPathFileConf4Scontrino)
            If Not IsNumeric(vBaudRat) Then
               MsgBox "ATTENZIONE!" & vbNewLine & _
                      "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
                      "(Tag [SERIALE] Parametro <BAUD_RATE> non valido)" & vbNewLine & vbNewLine & _
                      "Impossibile eseguire la stampa dello Scontrino.", vbCritical
               Exit Function
            End If
         'Qui prendo il BIT_DATI
            'vBitDati = ReadINI("SERIALE", "BIT_DATI", mPathFileConf4Scontrino)
            If Not IsNumeric(vBitDati) Then
               MsgBox "ATTENZIONE!" & vbNewLine & _
                      "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
                      "(Tag [SERIALE] Parametro <BIT_DATI> non valido)" & vbNewLine & vbNewLine & _
                      "Impossibile eseguire la stampa dello Scontrino.", vbCritical
               Exit Function
            End If
         'Qui prendo il PARITA
            'vParita = ReadINI("SERIALE", "PARITA", mPathFileConf4Scontrino)
            If Not IsNumeric(vParita) Then
               MsgBox "ATTENZIONE!" & vbNewLine & _
                      "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
                      "(Tag [SERIALE] Parametro <PARITA> non valido)" & vbNewLine & vbNewLine & _
                      "Impossibile eseguire la stampa dello Scontrino.", vbCritical
               Exit Function
            End If
         'Qui prendo il BIT_STOP
            'vBitStop = ReadINI("SERIALE", "BIT_STOP", mPathFileConf4Scontrino)
            If Not IsNumeric(vBitStop) Then
               MsgBox "ATTENZIONE!" & vbNewLine & _
                      "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
                      "(Tag [SERIALE] Parametro <BIT_STOP> non valido)" & vbNewLine & vbNewLine & _
                      "Impossibile eseguire la stampa dello Scontrino.", vbCritical
               Exit Function
            End If
         'Qui prendo il FLUSSO
            'vFlusso = ReadINI("SERIALE", "FLUSSO", mPathFileConf4Scontrino)
            If Not IsNumeric(vFlusso) Then
               MsgBox "ATTENZIONE!" & vbNewLine & _
                      "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
                      "(Tag [SERIALE] Parametro <FLUSSO> non valido)" & vbNewLine & vbNewLine & _
                      "Impossibile eseguire la stampa dello Scontrino.", vbCritical
               Exit Function
            End If
            
      End If
      
   End If
'-------------------------------------------------------------------------------------------------
   
   
'===================================================================================================
'QUI INIZIO A COMPORRE LO SCONTRINO  ===============================================================
   ' Open Communication
   If vTipConn = "R" Then 'RETE
      vRet = VbCEFOpenEth(vIndirIP, CLng(vNumPort), vRetErr)
   ElseIf vTipConn = "U" Then 'USB
      vRet = VbCEFOpenUSB(vNomeStampante, vRetErr)
   Else 'SERIALE
      vRet = VbCEFOpen(CLng(vNumPort), CLng(vBaudRat), CByte(vParita), CByte(vBitDati), CByte(vBitStop), CByte(vFlusso), CLng(vRetErr))
   End If
   
   ' Check Init
   If (vRet <> 0) Then
      Test_CUSTOM = "ERRORE!" & vbNewLine & _
                    "Errore di comunicazione nr. " & vRet
      Exit Function
   End If
   
      
   Select Case vFunzione
      Case "DATA"
         ' Get DATE
         vStrRiga = "1001"
         vRet = VbCEFWrite(vStrRiga, vRetErr)
         vRet = VbCEFRead(pBytBuffOut(), vRetA, vRetErr)
         
         'i = 1
         vVal = "Data: "
         vVal = vVal + String(1, pBytBuffOut(1)) + String(1, pBytBuffOut(2)) + "/"
         vVal = vVal + String(1, pBytBuffOut(3)) + String(1, pBytBuffOut(4)) + "/"
         vVal = vVal + String(1, pBytBuffOut(5)) + String(1, pBytBuffOut(6)) + "  Ore:"
         vVal = vVal + String(1, pBytBuffOut(7)) + String(1, pBytBuffOut(8)) + ":"
         vVal = vVal + String(1, pBytBuffOut(9)) + String(1, pBytBuffOut(10))
         
         Test_CUSTOM = vVal
         
      Case "APRI_CASSETTO"
         vStrRiga = "70081"
         vRet = VbCEFWrite(vStrRiga, vRetErr)
         
      Case "DISPLAY_MSG"
         vStrRiga = "7007" & Mid(pMsg, 1, 40) 'per Custom Dll 40 MAX byte
         vRet = VbCEFWrite(vStrRiga, vRetErr)
         
   End Select
   
   ' Close Communication on Com Port
   vRet = VbCEFClose(vRetErr)
      

GestErr:
   If err.Number <> 0 Then
      Test_CUSTOM = "ERRORE!" & vbNewLine & _
                    err.Number & " - " & err.Description
             
   End If
   On Error GoTo 0

End Function



'Public Function Test_3i(vApriCas As String, _
'                        vNumPort As String, vBaudRat As String, vBitDati As String, _
'                        vParita As String, vBitStop As String, _
'                        vFunzione As String, _
'                        Optional vTEST As Boolean, Optional pMsg As String) As String
'
'   Dim vStrRiga As String
'   Dim strOut As String
'
'
'   On Error GoTo GestErr
'
'
''QUI CONTROLLO SE DEVO VERIFICARE I PARAMETRI DI RETE E SERIALI (SOLO SE FACCIO IL TEST DELLA DATA!)
'   If vTEST = True Then
'
'      'Qui prendo il NUMERO DI PORTA da passare nel file scontrino
'         'vNumPort = ReadINI("SERIALE", "PORTA_COM", mPathFileConf4Scontrino)
'         If Not IsNumeric(vNumPort) Then
'            MsgBox "ATTENZIONE!" & vbNewLine & _
'                   "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
'                   "(Tag [SERIALE] Parametro <PORTA> non valido)" & vbNewLine & vbNewLine & _
'                   "Impossibile eseguire la stampa dello Scontrino.", vbCritical
'            Exit Function
'         End If
'      'Qui prendo il BAUD_RATE
'         'vBaudRat = ReadINI("SERIALE", "BAUD_RATE", mPathFileConf4Scontrino)
'         If Not IsNumeric(vBaudRat) Then
'            MsgBox "ATTENZIONE!" & vbNewLine & _
'                   "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
'                   "(Tag [SERIALE] Parametro <BAUD_RATE> non valido)" & vbNewLine & vbNewLine & _
'                   "Impossibile eseguire la stampa dello Scontrino.", vbCritical
'            Exit Function
'         End If
'      'Qui prendo il BIT_DATI
'         'vBitDati = ReadINI("SERIALE", "BIT_DATI", mPathFileConf4Scontrino)
'         If Not IsNumeric(vBitDati) Then
'            MsgBox "ATTENZIONE!" & vbNewLine & _
'                   "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
'                   "(Tag [SERIALE] Parametro <BIT_DATI> non valido)" & vbNewLine & vbNewLine & _
'                   "Impossibile eseguire la stampa dello Scontrino.", vbCritical
'            Exit Function
'         End If
'      'Qui prendo il PARITA
'         'vParita = ReadINI("SERIALE", "PARITA", mPathFileConf4Scontrino)
'         If Not IsNumeric(vParita) Then
'            MsgBox "ATTENZIONE!" & vbNewLine & _
'                   "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
'                   "(Tag [SERIALE] Parametro <PARITA> non valido)" & vbNewLine & vbNewLine & _
'                   "Impossibile eseguire la stampa dello Scontrino.", vbCritical
'            Exit Function
'         End If
'      'Qui prendo il BIT_STOP
'         'vBitStop = ReadINI("SERIALE", "BIT_STOP", mPathFileConf4Scontrino)
'         If Not IsNumeric(vBitStop) Then
'            MsgBox "ATTENZIONE!" & vbNewLine & _
'                   "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
'                   "(Tag [SERIALE] Parametro <BIT_STOP> non valido)" & vbNewLine & vbNewLine & _
'                   "Impossibile eseguire la stampa dello Scontrino.", vbCritical
'            Exit Function
'         End If
'
'   End If
''-------------------------------------------------------------------------------------------------
'
'
''===================================================================================================
''QUI INIZIO A COMPORRE LO SCONTRINO  ===============================================================
'
'
'   Select Case vFunzione
'      Case "DATA"
'         ' Get DATE
'         vStrRiga = "1001"
'         vRet = VbCEFWrite(vStrRiga, vRetErr)
'         vRet = VbCEFRead(pBytBuffOut(), vRetA, vRetErr)
'
'         'i = 1
'         strOut = "Data:"
'         strOut = strOut + String(1, pBytBuffOut(1)) + String(1, pBytBuffOut(2)) + "/"
'         strOut = strOut + String(1, pBytBuffOut(3)) + String(1, pBytBuffOut(4)) + "/"
'         strOut = strOut + String(1, pBytBuffOut(5)) + String(1, pBytBuffOut(6)) + "  Ore:"
'         strOut = strOut + String(1, pBytBuffOut(7)) + String(1, pBytBuffOut(8)) + ":"
'         strOut = strOut + String(1, pBytBuffOut(9)) + String(1, pBytBuffOut(10))
'
'         Test_3i = strOut
'
'      Case "APRI_CASSETTO"
'         vStrRiga = "70081"
'         vRet = VbCEFWrite(vStrRiga, vRetErr)
'
'      Case "DISPLAY_MSG"
'         vStrRiga = "7007" & Mid(pMsg, 1, 40) 'per Custom Dll 40 MAX byte
'         vRet = VbCEFWrite(vStrRiga, vRetErr)
'
'   End Select
'
'
'
'GestErr:
'   If err.Number <> 0 Then
'      Test_3i = "ERRORE!" & vbNewLine & _
'                    err.Number & " - " & err.Description
'
'   End If
'   On Error GoTo 0
'
'End Function


Private Function StampaFatturaCUSTOM(pSerial As Long, pDoppiaCopia As String, _
                                vTipConn As String, vApriCas As String, _
                                vIndirIP As String, vNumPort As String, _
                                vBaudRat As String, vBitDati As String, vParita As String, vBitStop As String, vFlusso As String, _
                                vNomeStampante As String) As Boolean
   Dim vStrRiga As String
   Dim i As Integer
   Dim vTotDOC As Currency
   Dim vTotDocFormat As String
   Dim vTotArt As Currency
   Dim vVal As String
   Dim vLenDescr As Byte
   
   Dim vRet As Long
   Dim vRetErr As Long

   Dim RS As ADODB.Recordset
   Dim strRicerca As String
   Dim vArrAliquote() As String
   'Dim vArrDettArt() As String
   
   Dim vNumDoc As String
   Dim vCliRagSoc As String
   Dim vCliIndiri As String
   Dim vCliLocali As String
   Dim vCliParIva As String
   Dim vCliCodFis As String
   
   
   StampaFatturaCUSTOM = False
   
'Qui Prendo i dati dal MASTER =============================================
   'Erase vArrDettArt
'   strRicerca = "SELECT * " & _
'                "FROM     [" & Azienda & "DOC_MAST] " & _
'                "WHERE MVSERIAL = " & pSerial
   strRicerca = "SELECT MVNUMDOC, MVALFDOC, MVDATDOC, " & _
                "       ANDESCRI, ANINDIRI, AN___CAP, ANLOCALI, ANPROVIN, ANCODFIS, ANPARIVA " & _
                "FROM [" & Azienda & "DOC_MAST] INNER JOIN [" & Azienda & "CONTI] ON ([" & Azienda & "DOC_MAST].MVCODCON = [" & Azienda & "CONTI].ANCODICE) AND ([" & Azienda & "DOC_MAST].MVTIPCON = [" & Azienda & "CONTI].ANTIPCON) " & _
                "WHERE MVSERIAL = " & pSerial
                
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneGenerale, adOpenStatic
   If Not RS.EOF Then
      vNumDoc = RS!MVNUMDOC & IIf(Len(Trim(RS!MVALFDOC)) > 0, "/" & RS!MVALFDOC, "")
      vNumDoc = vNumDoc & " del " & RS!MVDATDOC
      
      vCliRagSoc = Mid(RS!ANDESCRI, 1, 32)
      vCliIndiri = Mid(NonNullo(RS!ANINDIRI), 1, 32)
      vCliLocali = IIf(Len(Trim(NonNullo(RS!AN___CAP))) > 0, NonNullo(RS!AN___CAP) & " ", "")
      vCliLocali = vCliLocali & Mid(NonNullo(RS!ANLOCALI), 1, 21) 'max 21 perche' gli altri caratteri se li prendono il CAP(5) e la Provincia(4) + 2 spazi (tot 11)
      vCliLocali = vCliLocali & IIf(Len(Trim(NonNullo(RS!ANPROVIN))) > 0, " (" & NonNullo(RS!ANPROVIN) & ")", "")
      vCliParIva = NonNullo(RS!ANPARIVA)
      vCliCodFis = NonNullo(RS!ANCODFIS)
   End If
   RS.Close
   Set RS = Nothing


'Qui Prendo i dettagli delle Aliquote =============================================
   Erase vArrAliquote
   strRicerca = "SELECT * " & _
                "FROM     [" & Azienda & "DOC_TOTA] " & _
                "WHERE MVSERIAL = " & pSerial & " " & _
                "ORDER BY MVCODIVA"
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneGenerale, adOpenStatic
   If Not RS.EOF Then
      i = 0
      vTotDOC = 0
      ReDim vArrAliquote(RS.RecordCount - 1, 3)
      Do Until RS.EOF
         vArrAliquote(i, 0) = RS!MVCODIVA
         vArrAliquote(i, 1) = RS!MVVALIVA
         vArrAliquote(i, 2) = RS!MVIMPIMP
         vArrAliquote(i, 3) = RS!MVIMPIVA
         
         vTotDOC = vTotDOC + RS!MVIMPIMP + RS!MVIMPIVA
         
         i = i + 1
         RS.MoveNext
      Loop
   End If
   RS.Close
   Set RS = Nothing
   
   

' Open Communication
   If vTipConn = "R" Then 'RETE
      vRet = VbCEFOpenEth(vIndirIP, CLng(vNumPort), vRetErr)
   ElseIf vTipConn = "U" Then 'USB
      vRet = VbCEFOpenUSB(vNomeStampante, vRetErr)
   Else 'SERIALE
       vRet = VbCEFOpen(CLng(vNumPort), CLng(vBaudRat), CByte(vParita), CByte(vBitDati), CByte(vBitStop), CByte(vFlusso), CLng(vRetErr))
   End If
   'Debug.Print "Open"
   
   ' Check Init
   If (vRet <> 0) Then
      MsgBox "ATTENZIONE!" & vbNewLine & _
             "Errore di Comunicazione", (vbOKOnly + vbCritical)
      Exit Function
   End If
      
      
   vTotDocFormat = Format(vTotDOC, "########0.#0") 'Importo Ricevuto
   vTotDocFormat = Trim(Replace(vTotDocFormat, ",", ""))    'tolgo la virgola
   vTotDocFormat = String(9 - Len(Trim(vTotDocFormat)), "0") & vTotDocFormat 'aggiungo gli zeri davanti
      
' APRE IL DOCUMENTO (con il totale documento)
   vStrRiga = "40012"
   vStrRiga = vStrRiga & IIf(pDoppiaCopia = "1", "1", "0") 'Doppia copia SI'(1) o NO(0)
   vStrRiga = vStrRiga & vTotDocFormat
   vRet = VbCEFWrite(vStrRiga, vRetErr)
   'Debug.Print vStrRiga
   
   ' Stampa l'intestazione del Mittente
   vStrRiga = "4002"
   vRet = VbCEFWrite(vStrRiga, vRetErr)
   'Debug.Print vStrRiga
      
   ' riga di separazione ----------------------------------------------
   vStrRiga = "4003132" & String(32, "-")
   vRet = VbCEFWrite(vStrRiga, vRetErr)
   'Debug.Print vStrRiga
      
   ' riga di Fattura (numero e data) ----------------------------------
   vStrRiga = "40034"
   vVal = "FATTURA " & vNumDoc
   vLenDescr = Len(Trim(vVal))
   vStrRiga = vStrRiga & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr))  'Lunghezza della Descrizione
   vStrRiga = vStrRiga & Trim(vVal)
   vRet = VbCEFWrite(vStrRiga, vRetErr)
   'Debug.Print vStrRiga
      
   ' riga di testata delle righe di dettaglio -------------------------
   vStrRiga = "4003132" & "  Q.ta Descrizione   Importo IVA"
   vRet = VbCEFWrite(vStrRiga, vRetErr)
   'Debug.Print vStrRiga
      
'Qui Prendo i dettagli degli Articoli =============================================
   strRicerca = "SELECT * " & _
                "FROM     [" & Azienda & "DOC_DETT] " & _
                "WHERE MVSERIAL = " & pSerial & " AND MVTIPRIG <> 'D' " & _
                "ORDER BY CPROWNUM"
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneGenerale, adOpenStatic
   If Not RS.EOF Then
      vTotArt = 0
      Do Until RS.EOF
         vTotArt = vTotArt + RS!MVVALRIG 'Totale SENZA sconti Documento
         
         
         vStrRiga = "4003132"
         vVal = FormattaNumero(RS!MVPESRIS, IIf(pred_DecimaliQta > 2, 2, pred_DecimaliQta), 1) 'Qt (MAX 2 DECIMALI)
         vStrRiga = vStrRiga & Space(6 - Len(Trim(vVal))) & Trim(vVal) 'qta formatta
            vStrRiga = vStrRiga & Space(1) 'SPAZIO
         vVal = Trim(Mid(Trim(RS!MVDESART), 1, 13)) 'descrizione
         vStrRiga = vStrRiga & vVal & Space(13 - Len(vVal)) 'descrizione formattata
            vStrRiga = vStrRiga & Space(1) 'SPAZIO
         vVal = FormattaNumero(RS!MVVALRIG, 2, 1)  'Valore di Riga (a 2 DECIMALI)
         vStrRiga = vStrRiga & Space(7 - Len(Trim(vVal))) & Trim(vVal) 'Valore formatto
            vStrRiga = vStrRiga & Space(1) 'SPAZIO
         vVal = Trim(Mid(Trim(RS!MVCODIVA), 1, 3)) 'Cod.IVA
         vStrRiga = vStrRiga & Space(3 - Len(vVal)) & vVal 'codiva formattato
         
         'Stampo la riga
         vRet = VbCEFWrite(vStrRiga, vRetErr)
         'Debug.Print vStrRiga
         
         RS.MoveNext
      Loop
   End If
   RS.Close
   Set RS = Nothing
      
      
   ' riga di IMPORTO TOTALE  ----------------------------------
   vStrRiga = "4003F"
   vVal = "TOTALE FATTURA"
   vLenDescr = Len(Trim(vVal))
   vStrRiga = vStrRiga & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr))  'Lunghezza della Descrizione
   vStrRiga = vStrRiga & Trim(vVal & vTotDocFormat)
   vRet = VbCEFWrite(vStrRiga, vRetErr)
   'Debug.Print vStrRiga
      
   'Eventuali SCONTI sul DOCUMENTO
   If vTotArt > gtParam4RegCas.pImpTotale Then
      vStrRiga = "40031"
      vVal = "-" & Trim(Format(vTotArt - gtParam4RegCas.pImpTotale, "#######0.#0"))
      vVal = "SCONTO" & Space(26 - Len(vVal)) & vVal 'creo sempre una riga da 32 caratteri)
      vLenDescr = Len(Trim(vVal))
      vStrRiga = vStrRiga & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr))  'Lunghezza della Descrizione
      vStrRiga = vStrRiga & Trim(vVal)
      vRet = VbCEFWrite(vStrRiga, vRetErr)
      'Debug.Print vStrRiga
   End If
      
   ' riga di PAGAMENTO  ----------------------------------
   vStrRiga = "40031"
   vVal = Trim(Format(gtParam4RegCas.pImpRicPerScontrino, "#######0.#0"))
   vVal = "CONTANTE" & Space(24 - Len(vVal)) & vVal 'creo sempre una riga da 32 caratteri)
   vLenDescr = Len(Trim(vVal))
   vStrRiga = vStrRiga & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr))  'Lunghezza della Descrizione
   vStrRiga = vStrRiga & Trim(vVal)
   vRet = VbCEFWrite(vStrRiga, vRetErr)
   'Debug.Print vStrRiga
      
   ' riga di RESTO (solo se c') ----------------------------------
   If (gtParam4RegCas.pImpRicPerScontrino - vTotDOC) > 0 Then
      vStrRiga = "40031"
      vVal = Trim(Format(gtParam4RegCas.pImpRicPerScontrino - vTotDOC, "#######0.#0"))
      vVal = "RESTO" & Space(27 - Len(vVal)) & vVal 'creo sempre una riga da 32 caratteri)
      vLenDescr = Len(Trim(vVal))
      vStrRiga = vStrRiga & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr))  'Lunghezza della Descrizione
      vStrRiga = vStrRiga & Trim(vVal)
      vRet = VbCEFWrite(vStrRiga, vRetErr)
      'Debug.Print vStrRiga
   End If
            
   ' riga di separazione ----------------------------------------------
   vStrRiga = "4003132" & String(32, "-")
   vRet = VbCEFWrite(vStrRiga, vRetErr)
   'Debug.Print vStrRiga
      

'DETTAGLIO ALIQUOTE IVA
   ' riga di testata delle righe di dettaglio -------------------------
   vStrRiga = "4003132" & "         IMPOSTA      IMPONIBILE"
   vRet = VbCEFWrite(vStrRiga, vRetErr)
   'Debug.Print vStrRiga
   
   'Cicolo sulle aliquote
   For i = 0 To UBound(vArrAliquote)
      vStrRiga = "40031"
      vVal = vArrAliquote(i, 0) & ": IVA " & vArrAliquote(i, 1) & "%"
      vLenDescr = Len(Trim(vVal))
      vStrRiga = vStrRiga & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr))  'Lunghezza della Descrizione
      vStrRiga = vStrRiga & Trim(vVal)
      vRet = VbCEFWrite(vStrRiga, vRetErr)
      'Debug.Print vStrRiga
         
      vStrRiga = "4003132"
      vVal = FormattaNumero(CDbl(vArrAliquote(i, 2)), 2, 1)  'Imponibile
      vStrRiga = vStrRiga & Space(16 - Len(Trim(vVal))) & Trim(vVal) 'Imponibile formatta
      vVal = FormattaNumero(CDbl(vArrAliquote(i, 3)), 2, 1)  'Imposta
      vStrRiga = vStrRiga & Space(16 - Len(Trim(vVal))) & Trim(vVal) 'Imposta formatta
      'Stampo la riga
      vRet = VbCEFWrite(vStrRiga, vRetErr)
      'Debug.Print vStrRiga
   Next i

   ' riga di separazione ----------------------------------------------
   vStrRiga = "4003132" & String(32, "-")
   vRet = VbCEFWrite(vStrRiga, vRetErr)
   'Debug.Print vStrRiga

   vStrRiga = "40031"
   vVal = "[         DATI CLIENTE         ]"
   vLenDescr = Len(Trim(vVal))
   vStrRiga = vStrRiga & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr))  'Lunghezza della Descrizione
   vStrRiga = vStrRiga & Trim(vVal)
   vRet = VbCEFWrite(vStrRiga, vRetErr)
   'Debug.Print vStrRiga
  
   vStrRiga = "40031"
   vVal = vCliRagSoc
   vLenDescr = Len(Trim(vVal))
   vStrRiga = vStrRiga & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr))  'Lunghezza della Descrizione
   vStrRiga = vStrRiga & Trim(vVal)
   vRet = VbCEFWrite(vStrRiga, vRetErr)
   'Debug.Print vStrRiga
   If Len(Trim(vCliIndiri)) > 0 Then
      vStrRiga = "40031"
      vVal = vCliIndiri
      vLenDescr = Len(Trim(vVal))
      vStrRiga = vStrRiga & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr))  'Lunghezza della Descrizione
      vStrRiga = vStrRiga & Trim(vVal)
      vRet = VbCEFWrite(vStrRiga, vRetErr)
      'Debug.Print vStrRiga
   End If
   If Len(Trim(vCliLocali)) > 0 Then
      vStrRiga = "40031"
      vVal = vCliLocali
      vLenDescr = Len(Trim(vVal))
      vStrRiga = vStrRiga & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr))  'Lunghezza della Descrizione
      vStrRiga = vStrRiga & Trim(vVal)
      vRet = VbCEFWrite(vStrRiga, vRetErr)
      'Debug.Print vStrRiga
   End If
   If Len(Trim(vCliParIva)) > 0 Then
      vStrRiga = "40031"
      vVal = "P.IVA: " & vCliParIva
      vLenDescr = Len(Trim(vVal))
      vStrRiga = vStrRiga & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr))  'Lunghezza della Descrizione
      vStrRiga = vStrRiga & Trim(vVal)
      vRet = VbCEFWrite(vStrRiga, vRetErr)
      'Debug.Print vStrRiga
   End If
   If Len(Trim(vCliCodFis)) > 0 Then
      vStrRiga = "40031"
      vVal = "C.FIS.: " & vCliCodFis
      vLenDescr = Len(Trim(vVal))
      vStrRiga = vStrRiga & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr))  'Lunghezza della Descrizione
      vStrRiga = vStrRiga & Trim(vVal)
      vRet = VbCEFWrite(vStrRiga, vRetErr)
      'Debug.Print vStrRiga
   End If
   
   'Punti Fedelet accumulati
   If gtParam4RegCas.pPuntiFid > 0 Then
      vStrRiga = "40036"
      vVal = ">>> PUNTI FIDELITY: " & Trim(Str(gtParam4RegCas.pPuntiFid)) & " <<<"
      vLenDescr = Len(Trim(vVal))
      vStrRiga = vStrRiga & String(2 - Len(Trim(Str(vLenDescr))), "0") & Trim(Str(vLenDescr))  'Lunghezza della Descrizione
      vStrRiga = vStrRiga & Trim(vVal)
      vRet = VbCEFWrite(vStrRiga, vRetErr)
      'Debug.Print vStrRiga
   End If
      
      
   'Chiudo il documento
   vStrRiga = "4006"
   vRet = VbCEFWrite(vStrRiga, vRetErr)
   'Debug.Print "Chiusura Documento"
   
   'Close Communication on Com Port
   vRet = VbCEFClose(vRetErr)
   'Debug.Print "Close"
   
   StampaFatturaCUSTOM = True
End Function


Private Function StampaNotaCreditoCUSTOM(pSerial As Long, vTipConn As String, vApriCas As String, _
                                    vIndirIP As String, vNumPort As String, _
                                    vBaudRat As String, vBitDati As String, vParita As String, vBitStop As String, vFlusso As String, _
                                    vNomeStampante As String) As Boolean
   Dim vStrRiga As String
   Dim i As Integer
   Dim vTotCalcolato As Currency
   Dim vVal As String
   
   Dim vRet As Long
   Dim vRetErr As Long

   Dim RS As ADODB.Recordset
   Dim strRicerca As String
   Dim vNumDoc As String
   
   
   StampaNotaCreditoCUSTOM = False
   
   
'Qui Prendo i dati dal MASTER =============================================
   strRicerca = "SELECT MVNUMDOC " & _
                "FROM     [" & Azienda & "DOC_MAST] " & _
                "WHERE MVSERIAL = " & pSerial
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneGenerale, adOpenStatic
   If Not RS.EOF Then
      vNumDoc = RS!MVNUMDOC
   End If
   RS.Close
   Set RS = Nothing


   ' Open Communication
   If vTipConn = "R" Then 'RETE
      vRet = VbCEFOpenEth(vIndirIP, CLng(vNumPort), vRetErr)
   ElseIf vTipConn = "U" Then 'USB
      vRet = VbCEFOpenUSB(vNomeStampante, vRetErr)
   Else 'SERIALE
       vRet = VbCEFOpen(CLng(vNumPort), CLng(vBaudRat), CByte(vParita), CByte(vBitDati), CByte(vBitStop), CByte(vFlusso), CLng(vRetErr))
       'Debug.Print vStrRiga
   End If
   
   ' Check Init
   If (vRet <> 0) Then
      MsgBox "ATTENZIONE!" & vbNewLine & _
             "Errore di Comunicazione", (vbOKOnly + vbCritical)
      Exit Function
   End If
   
   'vRetA = Int(Combo1.Text)
   
'   'Setta la stampa NON Bufferizzata (la stampa dei prodotti avviene articolo per articolo)
'   vStrRiga = "30160"
'   vRet = VbCEFWrite(vStrRiga, vRetErr)
   
   
   'Indico che si tratta di Nota di Credito e passo il progressivo
'   vStrRiga = "71026"
'   vStrRiga = vStrRiga & String(5 - Len(Trim(vNumDoc)), "0") & Trim(vNumDoc)
   vStrRiga = "7102600000"
   vRet = VbCEFWrite(vStrRiga, vRetErr)
   'Debug.Print vStrRiga
   
   'RIGHE
   With mpGridScontrino
      vTotCalcolato = 0
      
      For i = 0 To .Rows.Count - 1
         vTotCalcolato = vTotCalcolato + .Rows(i).Record.Item(gtParam4RegCas.pColImpNet).Value
                  
         If CDbl(.Rows(i).Record.Item(gtParam4RegCas.pColQuanti).Value) <> 1 Then
            vStrRiga = RowScontrCUSTOM_MF(i, "QTA")  'Inserisco la riga con le Quantit
            vRet = VbCEFWrite(vStrRiga, vRetErr)
            'Debug.Print vStrRiga
         End If
         
         'Qui verifico se c'e' l'associazione del Codice IVA con il Reparti del Registratore di Cassa
         vVal = ReadINI("REPARTIIVA_REPARTI", .Rows(i).Record.Item(gtParam4RegCas.pColRepIVA).Value, mPathFileConf4Scontrino)
         If Len(Trim(vVal)) > 0 Then vVal = Replace(UCase(vVal), "REPARTO", "")
         If IsNumeric(vVal) = False Then vVal = "0"
         
         vStrRiga = RowScontrCUSTOM_MF(i, "STD", 0, CByte(vVal)) 'Compongo la stringa STANDARD
         vRet = VbCEFWrite(vStrRiga, vRetErr)
         'Debug.Print vStrRiga
         
         'Qui controllo se c' lo Sconto riga sull'Articolo
         If .Rows(i).Record.Item(gtParam4RegCas.pColScont1).Value > 0 Then
            vStrRiga = RowScontrCUSTOM_MF(i, "SCN_RIG", 0, CByte(vVal)) 'Compongo la stringa SCONTO RIGA
            vRet = VbCEFWrite(vStrRiga, vRetErr)
            'Debug.Print vStrRiga
         End If
         
      Next i
  
  
      'Eventuali SCONTI sul DOCUMENTO
      If vTotCalcolato > gtParam4RegCas.pImpTotale Then
         If gtParam4RegCas.pScontoPercent = True Then 'Controllo se  in PERCENTUALE...
            'Stampo il Subtotale
               vStrRiga = "3003"
               vRet = VbCEFWrite(vStrRiga, vRetErr)
               'Debug.Print vStrRiga
            '-------------------
            vStrRiga = RowScontrCUSTOM_MF(-1, "SCN_DOC_PER", (vTotCalcolato - gtParam4RegCas.pImpTotale))   'Compongo la stringa SCONTO RIGA
            vRet = VbCEFWrite(vStrRiga, vRetErr)
            'Debug.Print vStrRiga
         Else                          '...oppure se  a VALORE
            'Stampo il Subtotale
               vStrRiga = "3003"
               vRet = VbCEFWrite(vStrRiga, vRetErr)
               'Debug.Print vStrRiga
            '-------------------
            vStrRiga = RowScontrCUSTOM_MF(-1, "SCN_DOC_DOC", (vTotCalcolato - gtParam4RegCas.pImpTotale))   'Compongo la stringa SCONTO RIGA
            vRet = VbCEFWrite(vStrRiga, vRetErr)
            'Debug.Print vStrRiga
         End If
      End If
  
  
      'Stringa di IMPORTO RICEVUTO
      'If gtParam4RegCas.pImpRicPerScontrino > gtParam4RegCas.pImpTotale Then
         vStrRiga = RowScontrCUSTOM_MF(-1, "IMP_RIC", gtParam4RegCas.pImpTotale) 'Passo SEMPRE il TOTALE DOCUMENTO PERCH NON HA SENSO STAMPARE UN "RESTO" SULLA NOTA CREDITO
         vRet = VbCEFWrite(vStrRiga, vRetErr)
         'Debug.Print vStrRiga
      'End If
      
      ' Close Document
      vStrRiga = "3011"
      vRet = VbCEFWrite(vStrRiga, vRetErr)
      'Debug.Print vStrRiga
            
      ' Print and Cut
      vStrRiga = "3013"
      vRet = VbCEFWrite(vStrRiga, vRetErr)
      'Debug.Print vStrRiga
      
      'Close Communication on Com Port
      vRet = VbCEFClose(vRetErr)
   
   End With
   
   
   StampaNotaCreditoCUSTOM = True
End Function





Public Sub Test_DITRON(pPathIN As String, pMsg As String, Optional pApriCassetto As Byte)
   
   On Error Resume Next

   Dim NumFile As Integer 'per aprire il file che mi serve per storicizzare lo scontrino ed eventualmente ristamparlo
   NumFile = FreeFile
   
   'PRINT DISPLAY ***
      Kill App.path & "\tempDitron.txt"
      Open App.path & "\tempDitron.txt" For Append As #NumFile      'CREO IL FILE
         'RIGHE
         Print #NumFile, "nofis apri"
         Print #NumFile, "nofis opz=17                   ; EFFETTUA IL TAGLIO CARTA"
         Print #NumFile, "nofis riga='- - - - - - - - - - - - - - - -'"
         Print #NumFile, "nofis riga='**~P~R~I~M~O ~S~O~F~T~W~A~R~E**'"
         Print #NumFile, "nofis riga='- - - - - - - - - - - - - - - -'"
         Print #NumFile, "nofis opz = 17                 ; EFFETTUA IL TAGLIO CARTA"
         Print #NumFile, "nofis CHIUDI"
                  
         If pApriCassetto = 1 Then 'VERIFICO SE APRIRE IL CASSETTO
            Print #NumFile, "inp term=37    ;Apre il cassetto"
         End If
      Close #NumFile
      FileCopy App.path & "\tempDitron.txt", pPathIN & "scontrino.txt"
      Kill App.path & "\tempDitron.txt"
   
   On Error GoTo 0
'nofis apri
'nofis opz=17                   ; EFFETTUA IL TAGLIO CARTA
'nofis riga='- - - - - - - - - - - - - - - -'
'nofis riga='**~P~R~I~M~O ~S~O~F~T~W~A~R~E**'
'nofis riga='- - - - - - - - - - - - - - - -'
'nofis opz = 17
'nofis CHIUDI
'inp term=37    ;Apre il cassetto
'; Il simbolo ~ inserito prima di un carattere permette di stamparlo in doppia altezza.
End Sub

Public Sub Test_OLIVETTI(pPathIN As String, pStrDisplay As String, Optional pApriCassetto As Byte)
   'Questa funzione la uso anche per far comparire gli importi a display del registratore di cassa
   
   On Error Resume Next

   Dim NumFile As Integer 'per aprire il file che mi serve per storicizzare lo scontrino ed eventualmente ristamparlo
   NumFile = FreeFile
   
   'PRINT DISPLAY ***
      Kill App.path & "\tempEpson.txt"
      Open App.path & "\tempEpson.txt" For Append As #NumFile      'CREO IL FILE
         'RIGHE
         If pApriCassetto = 1 Then 'VERIFICO SE APRIRE IL CASSETTO
            Print #NumFile, "912;1"
         End If
         'If pSoloCassetto = False Then
         Print #NumFile, "212;1;" & pStrDisplay
         Print #NumFile, "212;2;" 'per sicurezza svuoto la seconda riga per quei modelli che la prevedeono (per im momento faccio cos. In futuro potrei gestire le due righe)
         'End If
      Close #NumFile
      FileCopy App.path & "\tempEpson.txt", pPathIN & "scoTEST.txt"
      Kill App.path & "\tempEpson.txt"
   
   On Error GoTo 0
End Sub

Public Sub Test_FASY(pPathIN As String, pApriCassetto As Byte)
   
   On Error Resume Next

   Dim NumFile As Integer 'per aprire il file che mi serve per storicizzare lo scontrino ed eventualmente ristamparlo
   NumFile = FreeFile
   
   'PRINT DISPLAY ***
      Kill App.path & "\tempFasy.txt"
      Open App.path & "\tempFasy.txt" For Append As #NumFile      'CREO IL FILE
         'RIGHE
         'Print #NumFile, "0 0 0 "
         Print #NumFile, "5 0 PRIMO - www.primosoftware.it"
         If pApriCassetto = 1 Then 'VERIFICO SE APRIRE IL CASSETTO
            Print #NumFile, "13"
         End If
         'Print #NumFile, "6 0.00      ---                                 0  1"
         Print #NumFile, "99"
      Close #NumFile
      FileCopy App.path & "\tempFasy.txt", pPathIN & "scoTEST.txt"
      Kill App.path & "\tempFasy.txt"
   
   On Error GoTo 0
End Sub

Public Sub Test_DATAPROCESS(pPathIN As String, pMsg As String, Optional pApriCassetto As Byte)
   
   On Error Resume Next

   Dim NumFile As Integer 'per aprire il file che mi serve per storicizzare lo scontrino ed eventualmente ristamparlo
   NumFile = FreeFile
   
   'APRE CASSETTO ***
   If pApriCassetto = 1 Then 'VERIFICO SE APRIRE IL CASSETTO
      Kill App.path & "\tempDataprocess.txt"
      Open App.path & "\tempDataprocess.txt" For Append As #NumFile      'CREO IL FILE
         Print #NumFile, "201"
      Close #NumFile
      FileCopy App.path & "\tempDataprocess.txt", pPathIN & "scoTEST.txt"
      Kill App.path & "\tempDataprocess.txt"
   End If
   
   'PRINT DISPLAY ***
   If Len(pMsg) > 0 Then
      Kill App.path & "\tempDataprocess.txt"
      Open App.path & "\tempDataprocess.txt" For Append As #NumFile      'CREO IL FILE
         Print #NumFile, "23" & pMsg & "1"
      Close #NumFile
      FileCopy App.path & "\tempDataprocess.txt", pPathIN & "scoTEST.txt"
      Kill App.path & "\tempDataprocess.txt"
   End If
   
   On Error GoTo 0
End Sub

Public Sub Test_MCT_RCH(pPathIN As String, pMsg As String)
   
   
   

End Sub


Private Sub GestFileScontrino(pNomeScontrino As String, _
                              Optional pRTFileTemp As String, Optional pRTFilePrint As String, _
                              Optional pSyncro4Epson As Boolean)
   'Qui copio il file temp creato nella cartella di destinazione affinch venga stampato, _
    lo storicizzo nella mia cartella di storico e poi lo elimino
   
   'NOTA: Con CUSTOM non creo il file TEMP perch l'invio della stampa avviene direttamente alla .dll CUSTOM
   On Error GoTo GestErr
   
   Dim vPathStorico As String
   Dim vNomeFileStorico As String
   Dim vFileTemp As String
   Dim vFilePrint As String
   Dim vTentativi As Byte
   Dim vErrStr As String
   
   
   If Len(Trim(pRTFileTemp)) > 0 Then
      vFileTemp = pRTFileTemp
      vFilePrint = pRTFilePrint
      vNomeFileStorico = pRTFilePrint
   Else
      vFileTemp = "temp.txt"
      vFilePrint = pNomeScontrino
      vNomeFileStorico = Replace(Format(Date, "yyyy-mm-dd") & "_" & Format(Now, "hh.nn.ss"), ":", ".") & ".txt"
   End If
   
   Call MsgRegCasInLogFile("[GestFileScontrino] - FileCopy: from '" & App.path & "\" & vFileTemp & "'  to '" & mPathDestScontrino & vFilePrint & "'")
'Copio il file nella cartella di stampa
   FileCopy App.path & "\" & vFileTemp, mPathDestScontrino & vFilePrint
   If pSyncro4Epson Then
      Call EpsonMakeSyncroFile(mPathDestScontrino, vFilePrint)
      'FileCopy mPathDestScontrino & vFilePrint, mPathDestScontrino & Replace(vFilePrint, ".txt", ".on")
   End If
   
'Copio il file nella mia cartella di storico
   'If Right(PathREGCAS, 1) <> "\" Then PathREGCAS = PathREGCAS & "\"
   vPathStorico = PathREGCAS & "\Storico\"
   Call VerificaEsistenzaPathCartella(vPathStorico)
   
   Call MsgRegCasInLogFile("[GestFileScontrino] - FileCopyStorico: from '" & App.path & "\" & vFileTemp & "'  to '" & vPathStorico & vNomeFileStorico & "'")
   FileCopy App.path & "\" & vFileTemp, vPathStorico & vNomeFileStorico
      
      
'Elimino il file temp
   Call PausaProgramma(1, True, True)
   Call MsgRegCasInLogFile("[GestFileScontrino] - KillFileTemp: '" & App.path & "\" & vFileTemp & "'")
   Call KillaFile(App.path & "\" & vFileTemp)
   'Kill App.path & "\" & vFileTemp


GestErr:
   If err.Number = 53 Then
      If vTentativi < 5 Then
         vTentativi = vTentativi + 1
         Call PausaProgramma(1)
         Resume
      Else
         vErrStr = err.Number & " - " & err.Description
         Call MsgRegCasInLogFile("[GestFileScontrino] - " & vErrStr, True)
         MsgBox vErrStr & vbNewLine & _
                "(funct. 'GestFileScontrino')", msg_Critical
      End If
   ElseIf err.Number <> 0 Then
      vErrStr = err.Number & " - " & err.Description & vbNewLine & "(funct. 'GestFileScontrino')"
      Call MsgRegCasInLogFile("[GestFileScontrino] - " & vErrStr, True)
      MsgBox vErrStr & vbNewLine & _
             "(funct. 'GestFileScontrino')", msg_Critical
   End If

End Sub


Public Function PulisciDescrizioneScontrino(pDescr As String, _
                                             Optional pFasy As Boolean) As String
   Dim vDescr As String
   Dim vPosiz As Integer
   
   vDescr = pDescr
      vDescr = Replace(vDescr, "", "a")
      vDescr = Replace(vDescr, "", "e")
      vDescr = Replace(vDescr, "", "e")
      vDescr = Replace(vDescr, "", "i")
      vDescr = Replace(vDescr, "", "o")
      vDescr = Replace(vDescr, "", "u")
      vDescr = Replace(vDescr, "", "E")
      vDescr = Replace(vDescr, "", "'")
      vDescr = Replace(vDescr, "", "'")
      vDescr = Replace(vDescr, "(", "`")
      vDescr = Replace(vDescr, ")", "`")
      vDescr = Replace(vDescr, "//", "`")
      vDescr = Replace(vDescr, "\\", "`")
      vDescr = Replace(vDescr, "~", "`")
      vDescr = Replace(vDescr, "'", "`")
      vDescr = Replace(vDescr, "", "`")
      vDescr = Replace(vDescr, "totale", "total.")
      vDescr = Replace(vDescr, "Totale", "Total.")
      vDescr = Replace(vDescr, "TOTALE", "TOTAL.")
      
      If pFasy Then 'Per il "GRANDE" Fasy devo controllare che non ci siano le parole "TOTALE" e "TOT." altrimenti il Reg di Cas va in TILT!!!
         'vDescr = Replace(vDescr, "totale", "total")
         'vDescr = Replace(vDescr, "Totale", "Total")
         'vDescr = Replace(vDescr, "TOTALE", "TOTALE")
         vDescr = Replace(vDescr, "tot.", "tot")
         vDescr = Replace(vDescr, "Tot.", "Tot")
         vDescr = Replace(vDescr, "TOT.", "TOT")
      End If
   PulisciDescrizioneScontrino = vDescr

End Function

Public Sub MessaggioDisplayRegCas(pFileConf As String, pMsg As String)
   
   Dim vPathFile As String
   Dim vPathSctr As String
   Dim vMarca As String
   Dim vMsg As String
   
   Dim NumFile As Integer 'per aprire il file
   
   On Error GoTo GestErr
   
   vMsg = PulisciDescrizioneScontrino(pMsg)
   
   'Imposto le variabili interne dal Modulo
   mPathFileConf4Scontrino = pFileConf

   If VerificaEsistenzaFile(PathREGCAS & "\Custom\" & pFileConf & ".CNF") = True Then
      mPathFileConf4Scontrino = PathREGCAS & "\Custom\" & pFileConf & ".CNF"
   Else
      mPathFileConf4Scontrino = PathREGCAS & "\" & pFileConf & ".CNF"
   End If
   
   
   'Qui prendo la Marca che  il parametro TYPE
   vMarca = ReadINI("TYPE", "NAME", mPathFileConf4Scontrino)
   'Controllo che sia pieno
   If Len(Trim(vMarca)) = 0 Then
      Exit Sub
   End If


   'Elimino il file temp
    Kill App.path & "\temp.txt"

   If UCase(vMarca) = "3I-XONXOFF" Or UCase(vMarca) = "CUSTOM-XONXOFF" Then
         NumFile = FreeFile
         Open App.path & "\temp.txt" For Append As #NumFile      'CREO IL FILE
            Print #NumFile, "K"
            Print #NumFile, Chr(34) & vMsg & Chr(34) & "1%"
         Close #NumFile
         Call Scontrino_XONXOFF(vMarca, "", App.path & "\temp.txt", True)
      
         'Elimino il file temp
         Kill App.path & "\temp.txt"
      
   ElseIf UCase(vMarca) = "SAREMA-XONXOFF" Or UCase(vMarca) = "EDIT-XONXOFF" Then
      'Di fatto uyso questa funzione per eseguire i TEST perch il SAREMA XonXoff NON gestisce la scritura a display
         NumFile = FreeFile
         Open App.path & "\temp.txt" For Append As #NumFile      'CREO IL FILE
            Print #NumFile, "j"
            Print #NumFile, Chr(34) & vMsg & Chr(34) & "@"
            Print #NumFile, "J"
         Close #NumFile
         Call Scontrino_XONXOFF(vMarca, "", App.path & "\temp.txt", True)
      
      
         'Elimino il file temp
         Kill App.path & "\temp.txt"
   
   ElseIf UCase(vMarca) = "CUSTOM" Then
         Dim vTipConn As String: Dim vNumPort As String
         Dim vIndirIP As String: Dim vBaudRat As String
         Dim vBitDati As String: Dim vParita As String
         Dim vBitStop As String: Dim vFlusso As String
      
         'Qui prendo il TIPO CONNESSIONE da passare nel file scontrino
         vTipConn = ReadINI("PARAMETRI", "TIP_CONN", mPathFileConf4Scontrino)
         If vTipConn = "R" Then 'VALORI DI RETE
            vIndirIP = ReadINI("RETE", "IP", mPathFileConf4Scontrino) 'Qui prendo l'IP del Registratore
            vNumPort = ReadINI("RETE", "PORT", mPathFileConf4Scontrino) 'Qui prendo il NUMERO DI PORTA da passare nel file scontrino
         Else
            vNumPort = ReadINI("SERIALE", "PORTA_COM", mPathFileConf4Scontrino) 'Qui prendo il NUMERO DI PORTA da passare nel file scontrino
            vBaudRat = ReadINI("SERIALE", "BAUD_RATE", mPathFileConf4Scontrino) 'Qui prendo il BAUD_RATE
            vBitDati = ReadINI("SERIALE", "BIT_DATI", mPathFileConf4Scontrino) 'Qui prendo il BIT_DATI
            vParita = ReadINI("SERIALE", "PARITA", mPathFileConf4Scontrino) 'Qui prendo il PARITA
            vBitStop = ReadINI("SERIALE", "BIT_STOP", mPathFileConf4Scontrino) 'Qui prendo il BIT_STOP
            vFlusso = ReadINI("SERIALE", "FLUSSO", mPathFileConf4Scontrino) 'Qui prendo il FLUSSO
         End If
         Call Test_CUSTOM(vTipConn, "", vIndirIP, vNumPort, vBaudRat, _
                          vBitDati, vParita, vBitStop, vFlusso, _
                          "DISPLAY_MSG", False, vMsg)
      
   ElseIf UCase(vMarca) = "OLIVETTI-NETTUNA" Then
         vPathSctr = ReadINI("ELAEXECUTE", "PATH_IN", mPathFileConf4Scontrino)
         If Len(Trim(vPathSctr)) > 0 Then Call Test_OLIVETTI(vPathSctr, vMsg)
         
   ElseIf UCase(vMarca) = "EPSON" Then
         'vPathSctr = ReadINI("PARAMETRI", "PATH_IN", mPathFileConf4Scontrino)
         'If Len(Trim(vPathSctr)) > 0 Then Call EPSON_TEST_OLD_FUN(vPathSctr, vMsg)
      
   ElseIf UCase(vMarca) = "DATAPROCESS" Then
         vPathSctr = ReadINI("FPCONNECTOR", "PATH", mPathFileConf4Scontrino)
         If Len(Trim(vPathSctr)) > 0 Then Call Test_DATAPROCESS(vPathSctr, vMsg)
      
      'Case "MCT"
      
      'Case "RCH"
      
      'Case "FASY"
   End If

   
   Exit Sub 'QUESTO NON DEVE ESSERE RIMOSSO ALTRIMETNI MI COMPARE L'ERRORE 20
   

GestErr:
   If err.Number = 53 Then
      Resume Next
   ElseIf err.Number <> 0 Then
      MsgBox err.Number & " - " & err.Description, vbCritical
   End If
   On Error GoTo 0
End Sub

Public Function Scontrino_XONXOFF(pMarca As String, pCausalDoc As String, _
                                  Optional pPathScontrino As String, Optional pNoEcho As Boolean, _
                                  Optional pSerial As Long) As Boolean
   Dim vStrRiga As String
   
   Dim vApriCas As String
   Dim vDoppCop As String 'Doppia Copia: Solo x Fatture
   
   Dim vNumPort As String
   Dim vBaudRat As String
   Dim vBitDati As String
   Dim vParita As String
   Dim vBitStop As String
   Dim vEcho As String
   Dim vTipoSconto As String
   
   On Error GoTo GestErr
  
   Scontrino_XONXOFF = False
   MDIForm1.TxtXonXoff.Text = ""
   MDIForm1.TimerXonXoff.Enabled = False
   
   
'VALORI DELLA SERIALE
   
      'Qui prendo il NUMERO DI PORTA da passare nel file scontrino
         vNumPort = ReadINI("SERIALE", "PORTA_COM", mPathFileConf4Scontrino)
         If Not IsNumeric(vNumPort) Then
            MsgBox "ATTENZIONE!" & vbNewLine & _
                   "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
                   "(Tag [SERIALE] Parametro <PORTA> non valido)" & vbNewLine & vbNewLine & _
                   "Impossibile eseguire la stampa dello Scontrino.", vbCritical
            Exit Function
         End If
         
      'Qui prendo il BAUD_RATE
         vBaudRat = ReadINI("SERIALE", "BAUD_RATE", mPathFileConf4Scontrino)
         If Not IsNumeric(vBaudRat) Then
            MsgBox "ATTENZIONE!" & vbNewLine & _
                   "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
                   "(Tag [SERIALE] Parametro <BAUD_RATE> non valido)" & vbNewLine & vbNewLine & _
                   "Impossibile eseguire la stampa dello Scontrino.", vbCritical
            Exit Function
         End If
         
      'Qui prendo il BIT_DATI
         vBitDati = ReadINI("SERIALE", "BIT_DATI", mPathFileConf4Scontrino)
         If Not IsNumeric(vBitDati) Then
            MsgBox "ATTENZIONE!" & vbNewLine & _
                   "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
                   "(Tag [SERIALE] Parametro <BIT_DATI> non valido)" & vbNewLine & vbNewLine & _
                   "Impossibile eseguire la stampa dello Scontrino.", vbCritical
            Exit Function
         End If
         
      'Qui prendo il PARITA'
         vParita = ReadINI("SERIALE", "PARITA", mPathFileConf4Scontrino)
         If Not IsNumeric(vParita) Then
            MsgBox "ATTENZIONE!" & vbNewLine & _
                   "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
                   "(Tag [SERIALE] Parametro <PARITA> non valido)" & vbNewLine & vbNewLine & _
                   "Impossibile eseguire la stampa dello Scontrino.", vbCritical
            Exit Function
         Else
            Select Case vParita
               Case "0":  vParita = "e"   'Pari (Even)
               Case "1":  vParita = "o"   'Dispari (Odd)
               Case "3":  vParita = "m"   'Mark
               Case "4":  vParita = "s"   'Space
               Case Else: vParita = "n"   'Nessuno
            End Select
         End If
         
      'Qui prendo il BIT_STOP
         vBitStop = ReadINI("SERIALE", "BIT_STOP", mPathFileConf4Scontrino)
         If Not IsNumeric(vBitStop) Then
            MsgBox "ATTENZIONE!" & vbNewLine & _
                   "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
                   "(Tag [SERIALE] Parametro <BIT_STOP> non valido)" & vbNewLine & vbNewLine & _
                   "Impossibile eseguire la stampa dello Scontrino.", vbCritical
            Exit Function
         End If
         
      'Qui prendo il ECHO (nessun errore da segnalare perch tanto se non c' al massimo non faccio nessun controllo)
         vEcho = ReadINI("SERIALE", "ECHO", mPathFileConf4Scontrino)


   
      vApriCas = ReadINI("PARAMETRI", "APRI_CASSETTO", mPathFileConf4Scontrino)
      vDoppCop = ReadINI("PARAMETRI", "DOPPIA_COPIA", mPathFileConf4Scontrino)
      vTipoSconto = ReadINI("PARAMETRI", "SCONTI_BUFFETTI", mPathFileConf4Scontrino)
      If Not IsNumeric(vTipoSconto) Then vTipoSconto = "0"
'=======================================================================================
   
   
   
'QUI IMPOSTO IL PATH ED IL NOME DEL FILE DA STAMPARE ===================================
      Dim vPathFileSctr As String

      If Len(gtParam4RegCas.pRistScontrino) = 0 And Len(pPathScontrino) = 0 Then 'NOME FILE DA STAMPARE
      
         Call VerificaEsistenzaPathCartella(PathREGCAS & "\Storico")
         'qui apri il file che creo comunque per la storicizzazione dello scontrino e l'eventuale ristampa
         Dim vNomeFile As String
         
         vNomeFile = Replace(Format(Date, "yyyy-mm-dd") & "_" & Format(Now, "hh.nn.ss"), ":", ".") & ".txt"
         vPathFileSctr = PathREGCAS & "\Storico\" & vNomeFile
         
         
         'QUI COMPONGO LO SCONTRINO  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
               If pCausalDoc = "CO" Then 'Corrispettivi 'SCONTRINO
                  mLenDescriXonXOff = 22 'predefinito
                  Select Case UCase(pMarca)
                     Case "3I-XONXOFF"
                        mLenDescriXonXOff = 38
                     Case "SAREMA-XONXOFF"
                        mLenDescriXonXOff = 38
                     Case "CUSTOM-XONXOFF"
                        mLenDescriXonXOff = 22
                  End Select
         
                  'Stampo lo Scontrino
                  If StampaScontrino_XONXOFF(vApriCas, vPathFileSctr, CByte(vTipoSconto)) = False Then
                     Exit Function
                  End If
         
         
               ElseIf pCausalDoc = "FA" Then 'FATTURA
                  Select Case UCase(pMarca)
                     Case "3I-XONXOFF"
                        If StampaFattura_XONXOFF(pSerial, vDoppCop, vApriCas, vPathFileSctr, UCase(pMarca)) = False Then
                           Exit Function
                        End If
                        
                     Case "CUSTOM-XONXOFF"
                        If StampaFatturaCUSTOM_XONXOFF(pSerial, vDoppCop, vApriCas, vPathFileSctr) = False Then
                           Exit Function
                        End If
                        
                     Case "SAREMA-XONXOFF"
                        If StampaFatturaSAREMA_XONXOFF(pSerial, vDoppCop, vApriCas, vPathFileSctr) = False Then
                           Exit Function
                        End If
                        
                     Case "EDIT-XONXOFF"
                        If StampaFatturaSAREMA_XONXOFF(pSerial, vDoppCop, vApriCas, vPathFileSctr) = False Then
                           Exit Function
                        End If
                        
                  End Select
                  
         '''      ElseIf pCausalDoc = "NC" Then 'NOTA DI CREDITO
         '''         If StampaNotaCreditoCUSTOM(pSerial, _
         '''                                      vTipConn, vApriCas, vIndirIP, vNumPort, vBaudRat, _
         '''                                      vBitDati, vParita, vBitStop, vEcho) = False Then
         '''            Exit Function
         '''         End If
               End If
         '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
         
         'Se arriva qui significa che il file  stato creato correttamente e quindi lo associo ala variabile gtParam4RegCas.pRistScontrino
         'perche' in caso di errore di comunicazione NON lo devo ricreare ma  sufficiente che ristampi il file appena creato
         gtParam4RegCas.pRistScontrino = vNomeFile
         
      Else                             'RISTAMPA
         
         If Len(pPathScontrino) > 0 Then 'Path di appoggio che posso usare sia per il test che per la visualizzazione a display
            vPathFileSctr = pPathScontrino
         Else
            vPathFileSctr = PathREGCAS & "\Storico\" & gtParam4RegCas.pRistScontrino
         End If
      
      End If
               ' D A   R I M U O V E R E  < - - - - - -
               'vPathFileSctr = "D:\ProgettiVB\PRIMO (UTILITY)\_DOCUMENTAZIONE\_REGISTRATORI DI CASSA\3i\Pacchetto_Software-House_FTP-FAST\FileXONXOFF\scontrino_con_descrizione_@_1.txt"
'========================================================================================




'QUI TESTO ED APRO LA PORTA COM =========================================================
   With MDIForm1.MSComm1
      'IMPOSTO I SETTAGGI GENERALI
         .InputLen = 0
         .RThreshold = 1
         .SThreshold = 1
      
      'IMPOSTO I SETTAGGI DELLA PORTA COM
         .CommPort = CInt(vNumPort)
         .Settings = vBaudRat & "," & vParita & "," & vBitDati & "," & vBitStop
         .Handshaking = comXOnXoff  'Tipo di sincronia FISSA
      
      'APRO LA PORTA COM
         .PortOpen = True
                  Debug.Print "PORTA: APERTA"
                  Debug.Print "~~~~~~~~~~~~~"
'=======================================================================================


            
'STAMPO IL FILE APPENA CREATO ===========================================================
'      If pCausalDoc = "FA" And UCase(pMarca) = "3I-XONXOFF" Then
'         vStrRiga = "190F"
'         .output = vStrRiga 'Azzero il progressivo delle Fatture del Registraore di Cassa che altrimenti da fastidio
'      End If
      
      
      Dim hSend As Long
      Dim BSize As Long
      Dim LF&
      Dim Ret As Integer      ' Intero temporaneo.
      
      ' Apre il file registro.
      hSend = FreeFile
      Open vPathFileSctr For Binary Access Read As hSend

      ' Legge il file in blocchi pari alle dimensioni del buffer di trasmissione.
      BSize = .OutBufferSize
      LF& = LOF(hSend)
      Do Until EOF(hSend)
         ' Non legge pi del necessario alla fine.
         If LF& - Loc(hSend) <= BSize Then
            BSize = LF& - Loc(hSend) + 1
         End If

         ' Legge un blocco di dati.
         vPathFileSctr = Space$(BSize)
         Get hSend, , vPathFileSctr

         ' Trasmette il blocco.
         .output = vPathFileSctr
         'If err Then
         '   MsgBox Error$, 48
         '   Exit Do
         'End If

         ' Attende che tutti i dati vengano inviati.
         Do
            Ret = DoEvents()
         Loop Until .OutBufferCount = 0
         
                  
         'CONTROLLO RITORNO DA CASSA SE ECHO E' ABILITATO (ECHO = "1") ==================================
            If pNoEcho = False Then
               Dim vrMsgErr As String
               vrMsgErr = ""
               If vEcho = "1" Then
                  MDIForm1.TimerXonXoff.Enabled = True
                  Do Until MDIForm1.TimerXonXoff.Enabled = False
                     DoEvents
                     'gReturnRegCas
                  Loop
                  
                  'Eseguo il controllo tra la parte inviata alla stampante e il ritorno (Eco appunto)
                  If EsitoXonXoff(vrMsgErr, vPathFileSctr) = False Then
                     Close hSend
                     GoTo GestErr
                  End If
               End If
            End If
         '=================================================================================================
         
      Loop
      Close hSend
'            'prove varie *****-----------********----------
'            .output = "k"
'            .output = Chr(34) & "RICAMBI AUTOMOTOCICL" & Chr(34) & "1*2536H01R"
'            .output = Chr(34) & "MAC.PRODOTTI AGRICOL" & Chr(34) & "1*320H01R"
'            .output = Chr(34) & "------------------------" & Chr(34) & "@"
'            .output = Chr(34) & "N. PEZZI 2" & Chr(34) & "@"
'            .output = "3000 H1T"
'            .output = "a"
   '============================================================================================
   
               
   
''CONTROLLO RITORNO DA CASSA SE ECHO E' ABILITATO (ECHO = "1") ==================================
'      Dim vrMsgErr As String
'      vrMsgErr = ""
'      If vEcho = "1" Then
'         MDIForm1.TimerXonXoff.Enabled = True
'         Do Until MDIForm1.TimerXonXoff.Enabled = False
'            DoEvents
'            'gReturnRegCas
'         Loop
'
'         'controllo che non sia vuoto altrimenti signiica che c' stato un errore in fase di stampa
'         'If Len(Trim(MDIForm1.TxtXonXoff.Text)) = 0 Then
'         If EsitoXonXoff(vrMsgErr, vStrInviata) = False Then
'            GoTo GestErr
'         End If
'      End If
''=================================================================================================
   
   
   
'F I N E    (Se arriva qui  andato tutto bene!!!)
      Scontrino_XONXOFF = True
      .PortOpen = False
                  
                  Debug.Print "~~~~~~~~~~~~~"
                  Debug.Print "PORTA: CHIUSA"
'=================================================


GestErr:
      'Se la COM  aperta allora la chiudo
      If .PortOpen = True Then
         .PortOpen = False
                  Debug.Print "~~~~~~~~~~~~~"
                  Debug.Print "PORTA: CHIUSA"
      End If
      
      If err.Number <> 0 Then
         MsgBox err.Number & " - " & err.Description & vbNewLine & vbNewLine & _
                "Errore in fase di stampa scontrino.", vbCritical
      Else
         If Len(Trim(vrMsgErr)) > 0 Then
            MsgBox vrMsgErr & vbNewLine & vbNewLine & _
                   "Errore in fase di stampa scontrino.", vbCritical
         End If
      End If
      On Error GoTo 0

   End With

End Function


' Questa routine aggiunge dati alla variabile gReturnRegCas
' Filtra anche i caratteri di controllo, come BACKSPACE,
' ritorno a capo e avanzamento riga e scrive i dati
' in un file registro aperto.
' I caratteri BACKSPACE cancellano i caratteri a sinistra,
' sia nella varibile gReturnRegCas che in una stringa passata.
' I caratteri di avanzamento riga vengono aggiunti dopo tutti i
' caratteri di ritorno a capo. Vengono inoltre controllate
' le dimensioni della varibile gReturnRegCas in modo
' che non siano mai maggiori del valore di MAXTERMSIZE.
Public Static Sub ReturnXonXoff(Term As TextBox, Data As String)
    On Error GoTo Handler
    Const MAXTERMSIZE = 16000
    Dim TermSize As Long, i
    
    If Len(Trim(Data)) = 0 Then Exit Sub
    
            'If Len(MDIForm1.TxtXonXoff.Text) > 0 Then
               'Debug.Print Data
            'End If
    
    
    ' Controlla che le dimensioni del testo esistente non siano
    ' troppo grandi.
    TermSize = Len(Term.Text)
    If TermSize > MAXTERMSIZE Then
       Term.Text = Mid$(Term.Text, 4097)
       TermSize = Len(Term.Text)
    End If

    ' Punta alla fine dei dati di Term.
    Term.SelStart = TermSize

    ' Filtra/gestisce i caratteri BACKSPACE.
    Do
       i = InStr(Data, Chr$(8))
       If i Then
          If i = 1 Then
             Term.SelStart = TermSize - 1
             Term.SelLength = 1
             Data = Mid$(Data, i + 1)
          Else
             Data = Left$(Data, i - 2) & Mid$(Data, i + 1)
          End If
       End If
    Loop While i

    ' Elimina i caratteri di avanzamento riga.
    Do
       i = InStr(Data, Chr$(10))
       If i Then
          Data = Left$(Data, i - 1) & Mid$(Data, i + 1)
       End If
    Loop While i

    ' Verifica che tutti i caratteri di ritorno a capo siano
    ' seguiti da un carattere di avanzamento riga.
    i = 1
    Do
       i = InStr(i, Data, Chr$(13))
       If i Then
          Data = Left$(Data, i) & Chr$(10) & Mid$(Data, i + 1)
          i = i + 1
       End If
    Loop While i

    ' Assegna i dati filtrati alla propriet SelText.
    Term.SelText = Data
  
'    ' Se richiesto, registra i dati nel file.
'    If hLogFile Then
'       i = 2
'       Do
'          err = 0
'          Put hLogFile, , Data
'          If err Then
'             i = MsgBox(Error$, 21)
'             If i = 2 Then
'                mnuCloseLog_Click
'             End If
'          End If
'       Loop While i <> 2
'    End If
    
    
    Term.SelStart = Len(Term.Text)
Exit Sub

Handler:
    MsgBox Error$
    Resume Next


'///////////////// OLD ///////////////////////
'    On Error GoTo Handler
'    Const MAXTERMSIZE = 16000
'    Dim TermSize As Long, i
'
'               If Len(Trim(Data)) > 0 Then
'                     Debug.Print Data
'               End If
'
'    ' Controlla che le dimensioni del testo esistente non siano
'    ' troppo grandi.
'    TermSize = Len(gReturnRegCas)
'    If TermSize > MAXTERMSIZE Then
'       gReturnRegCas = Mid$(gReturnRegCas, 4097)
'       TermSize = Len(gReturnRegCas)
'    End If
'
'    '' Punta alla fine dei dati di mdiform1.txtxonxoff.
'    'mdiform1.txtxonxoff.SelStart = TermSize
'
'    ' Filtra/gestisce i caratteri BACKSPACE.
'    Do
'       i = InStr(Data, Chr$(8))
'       If i Then
'          If i = 1 Then
'             'mdiform1.txtxonxoff.SelStart = TermSize - 1
'             'mdiform1.txtxonxoff.SelLength = 1
'             Data = Mid$(Data, i + 1)
'          Else
'             Data = left$(Data, i - 2) & Mid$(Data, i + 1)
'          End If
'       End If
'    Loop While i
'
'    ' Elimina i caratteri di avanzamento riga.
'    Do
'       i = InStr(Data, Chr$(10))
'       If i Then
'          Data = left$(Data, i - 1) & Mid$(Data, i + 1)
'       End If
'    Loop While i
'
'    ' Verifica che tutti i caratteri di ritorno a capo siano
'    ' seguiti da un carattere di avanzamento riga.
'    i = 1
'    Do
'       i = InStr(i, Data, Chr$(13))
'       If i Then
'          Data = left$(Data, i) & Chr$(10) & Mid$(Data, i + 1)
'          i = i + 1
'       End If
'    Loop While i
'
'    ' Assegna i dati filtrati alla propriet SelText.
'    gReturnRegCas = gReturnRegCas & Data
'
''    ' Se richiesto, registra i dati nel file.
''    If hLogFile Then
''       i = 2
''       Do
''          err = 0
''          Put hLogFile, , Data
''          If err Then
''             i = MsgBox(Error$, 21)
''             If i = 2 Then
''                mnuCloseLog_Click
''             End If
''          End If
''       Loop While i <> 2
''    End If
'
'
'    'mdiform1.txtxonxoff.SelStart = Len(mdiform1.txtxonxoff.Text)
'Exit Sub
'
'Handler:
'    MsgBox Error$
'    Resume Next
End Sub

Private Function EsitoXonXoff(prMsgErr As String, pStrInviata As String) As Boolean
   'Qui controllo il contenuto del TxtXonXoff

   EsitoXonXoff = False

   With MDIForm1.TxtXonXoff
               
      If Mid(.Text, 1, 5) = "#ERR#" Then
         prMsgErr = .Text
         Exit Function
   
      ElseIf Len(Trim(.Text)) = 0 Then 'Nessuna Risposta = La Cassa potrebbe essere spenta o bloccata
         prMsgErr = "#ERR# - Nessuna risposta dalla Cassa"
         Exit Function
   
      Else
         'Se passo la stringa inviata allora significa che devo verificare che l'Echo sia uguale
         If Len(pStrInviata) > 0 Then
            
            Dim vStrInv As String
            vStrInv = pStrInviata
            
            'Tolgo un po' di caratteri che potrebbero darmi fastidio e li uniformo in modo da essere sicuro che siano uguali
               vStrInv = Replace(vStrInv, Chr(13) + Chr(10), "")
               vStrInv = Replace(vStrInv, Chr(13), "")
               vStrInv = Replace(vStrInv, Chr(10), "")
               vStrInv = Replace(vStrInv, Chr(9), "")
               vStrInv = Replace(vStrInv, Chr(8), "")
               vStrInv = Trim(Replace(vStrInv, Chr(32), ""))
               
               .Text = Replace(.Text, Chr(13) + Chr(10), "")
               .Text = Replace(.Text, Chr(13), "")
               .Text = Replace(.Text, Chr(10), "")
               .Text = Replace(.Text, Chr(9), "")
               .Text = Replace(.Text, Chr(8), "")
               .Text = Trim(Replace(.Text, Chr(32), ""))
            
            If Len(vStrInv) > Len(Trim(.Text)) Then
               Dim vDiff As Integer
               vDiff = Len(vStrInv) - Len(Trim(.Text))
               vStrInv = Mid(vStrInv, 1, Len(vStrInv) - vDiff)
            End If
                  
                  Debug.Print "======================================================"
                  Debug.Print "                                                      "
                  Debug.Print "TEXT: " & .Text
                  Debug.Print "------------------------------------------------------"
                  Debug.Print "INV.: " & vStrInv
            
            If vStrInv <> Trim(.Text) Then
               prMsgErr = "#ERR# - Stampa scontrino Parziale"
               Exit Function
            End If
         End If
      
         prMsgErr = ""
         EsitoXonXoff = True
         
      End If
      
      'Lo svuoto in modo che continene sempre l'ultima parte (buffer) stampata
      .Text = ""
      
   End With

'   ' Sceglie i diversi casi a seconda del valore della propriet CommEvent.
'   Select Case vReturn
'      ' Messaggi degli eventi.
'      Case comEvReceive
'         Dim Buffer As Variant
'         Buffer = MSComm1.Input
'         'Debug.Print "Ricezione:" & StrConv(Buffer, vbUnicode)
'         Call ReturnXonXoff(TxtXonXoff, StrConv(Buffer, vbUnicode))
'      Case comEvSend
''        Case comEvCTS
''            EVMsg$ = "Rilevata modifica in CTS"
''        Case comEvDSR
''            EVMsg$ = "Rilevata modifica in DSR"
''        Case comEvCD
''            EVMsg$ = "Rilevata modifica in CD"
''        Case comEvRing
''            EVMsg$ = "Il telefono sta squillando"
'      Case comEvEOF:     ERMsg = "#ERR# - Raggiunta la fine del file"
'      ' Messaggi di errore.
'      Case comBreak:     ERMsg = "#ERR# - Ricevuta interruzione"
'      Case comCDTO:      ERMsg = "#ERR# - Timeout Carrier Detect"
'      Case comCTSTO:     ERMsg = "#ERR# - Timeout CTS"
'      Case comDCB:       ERMsg = "#ERR# - Errore durante il recupero di DCB"
'      Case comDSRTO:     ERMsg = "#ERR# - Timeout DSR"
'      Case comFrame:     ERMsg = "#ERR# - Errore di frame"
'      Case comOverrun:   ERMsg = "#ERR# - Errore di overrun"
'      Case comRxOver:    ERMsg = "#ERR# - Overflow del buffer di ricezione"
'      Case comRxParity:  ERMsg = "#ERR# - Errore di parit"
'      Case comTxFull:    ERMsg = "#ERR# - Buffer di trasmissione pieno"
'      Case Else:         ERMsg = "#ERR# - Errore o evento sconosciuto"
'   End Select

End Function


Private Function StampaScontrino_XONXOFF(vApriCas As String, pPathFile As String, Optional pTipoSconto As Byte) As Boolean
   
   'Nota: Il parametro pTipoSconto => Default 0; 1 per EDIT che per gli sconti di Riga si comporta diversamente dal SAREMA-XonXoff
   
   Dim vStrRiga As String
   Dim i As Integer
   Dim vTotCalcolato As Currency
   Dim vVal As String
   Dim NumFile As Integer 'per aprire il file che mi serve per storicizzare lo scontrino ed eventualmente ristamparlo
   
   StampaScontrino_XONXOFF = False
           
   'qui apri il file che creo comunque per la storicizzazione dello scontrino e l'eventuale ristampa
   NumFile = FreeFile
   Open pPathFile For Append As #NumFile      'CREO IL FILE
   
   
   vStrRiga = "K"
   Print #NumFile, vStrRiga 'Stampo la stringa nel File
   
   'RIGHE
   With mpGridScontrino
      vTotCalcolato = 0
      
      For i = 0 To .Rows.Count - 1
         vTotCalcolato = vTotCalcolato + .Rows(i).Record.Item(gtParam4RegCas.pColImpNet).Value
         
         'Qui verifico se c'e' l'associazione del Codice IVA con il Reparti del Registratore di Cassa
         vVal = ReadINI("REPARTIIVA_REPARTI", .Rows(i).Record.Item(gtParam4RegCas.pColRepIVA).Value, mPathFileConf4Scontrino)
         If Len(Trim(vVal)) > 0 Then vVal = Replace(UCase(vVal), "REPARTO", "")
         If IsNumeric(vVal) = False Then vVal = "1"
         
         
         'Controllo se si tratta di un RESO o di un articolo normale di vendita
         'If .CellBackColor = Colore("rosso1") Then
         If .Rows(i).Record.Item(gtParam4RegCas.pColSimbol).Value = "R" Then
            vStrRiga = RowScontr_XONXOFF(i, "RESO", 0, CByte(vVal)) 'Compongo la stringa di RESO
         Else
            'Controllo se la riga  negativa x STORNO altrimenti  una riga normale di vendita
            If .Rows(i).Record.Item(gtParam4RegCas.pColPrezzo).Value < 0 Then
               vStrRiga = RowScontr_XONXOFF(i, "STORNO", 0, CByte(vVal)) 'Compongo la stringa STANDARD
            Else
               vStrRiga = RowScontr_XONXOFF(i, "STD", 0, CByte(vVal), "", pTipoSconto) 'Compongo la stringa STANDARD
            End If
         End If
         Print #NumFile, vStrRiga 'Stampo la stringa nel File
         
'         'Qui controllo se c' lo Sconto riga sull'Articolo
'         If .Rows(i).Record.Item(gtParam4RegCas.pColScont1).Value > 0 Then
'            vStrRiga = RowScontr_XONXOFF(i, "SCN_RIG", 0, CByte(vVal)) 'Compongo la stringa SCONTO RIGA
'            Print #NumFile, vStrRiga 'Stampo la stringa nel File
'         End If
         
      Next i
  
  
      'Eventuali SCONTI sul DOCUMENTO
      If vTotCalcolato > gtParam4RegCas.pImpTotale Then
         'Stampo il Subtotale
            vStrRiga = "="
            Print #NumFile, vStrRiga 'Stampo la stringa nel File
            
         If gtParam4RegCas.pScontoPercent = True Then 'Controllo se  in PERCENTUALE...
            vStrRiga = RowScontr_XONXOFF(-1, "SCN_DOC_PER", (vTotCalcolato - gtParam4RegCas.pImpTotale), 0, "", pTipoSconto) 'Compongo la stringa SCONTO RIGA
            Print #NumFile, vStrRiga 'Stampo la stringa nel File
         Else                          '...oppure se  a VALORE
            vStrRiga = RowScontr_XONXOFF(-1, "SCN_DOC_DOC", (vTotCalcolato - gtParam4RegCas.pImpTotale))   'Compongo la stringa SCONTO RIGA
               Print #NumFile, vStrRiga 'Stampo la stringa nel File
         End If
      End If
  
  
      'Verifico se devo inserire la riga di riferimento (vale per cosntrini a 0 in presenza di Prepagati o Abbonamenti)
         If Len(Trim(gtParam4RegCas.pRifDocFat)) > 0 Then
            vStrRiga = RowScontr_XONXOFF(-1, "CORTESIA", 0, 0, "---------------------------") 'Inserisco la riga con le Quantit
            Print #NumFile, vStrRiga 'Stampo la stringa nel File
            vStrRiga = RowScontr_XONXOFF(-1, "CORTESIA", 0, 0, gtParam4RegCas.pRifDocFat)  'Inserisco il Riferimento del Documento Fiscale
            Print #NumFile, vStrRiga 'Stampo la stringa nel File
            vStrRiga = RowScontr_XONXOFF(-1, "CORTESIA", 0, 0, "---------------------------") 'Inserisco la riga con le Quantit
            Print #NumFile, vStrRiga 'Stampo la stringa nel File
         End If
  
      'Stampo il Codice Fiscale
         If Len(gtParam4RegCas.pCodFisc) > 0 Then '(TESTATO = OK!)
            If Len(Trim(gtParam4RegCas.pRifDocFat)) = 0 Then
               vStrRiga = RowScontr_XONXOFF(-1, "CORTESIA", 0, 0, "---------------------------") 'Inserisco la riga con le Quantit
            End If
            Print #NumFile, vStrRiga 'Stampo la stringa nel File
            vStrRiga = RowScontr_XONXOFF(-1, "CORTESIA", 0, 0, " C.F.: " & Trim(gtParam4RegCas.pCodFisc))  'Inserisco il Codice Fiscale
            Print #NumFile, vStrRiga 'Stampo la stringa nel File
            vStrRiga = RowScontr_XONXOFF(-1, "CORTESIA", 0, 0, "---------------------------") 'Inserisco la riga con le Quantit
            Print #NumFile, vStrRiga 'Stampo la stringa nel File
         End If
      
      'Stampo la riga di Cortesia con il totale dei Punti Fedelt accumulati
         If gtParam4RegCas.pPuntiFid > 0 Then
            If (Len(gtParam4RegCas.pCodFisc) = 0) And (Len(Trim(gtParam4RegCas.pRifDocFat)) = 0) Then
               vStrRiga = RowScontr_XONXOFF(-1, "CORTESIA", 0, 0, "---------------------------") 'Inserisco la riga con le Quantit
            End If
            Print #NumFile, vStrRiga 'Stampo la stringa nel File
            vStrRiga = RowScontr_XONXOFF(-1, "CORTESIA", 0, 0, " P.TI FIDELITY: " & Trim(Str(gtParam4RegCas.pPuntiFid)))  'Inserisco la riga con le Quantit
            Print #NumFile, vStrRiga 'Stampo la stringa nel File
            vStrRiga = RowScontr_XONXOFF(-1, "CORTESIA", 0, 0, "---------------------------") 'Inserisco la riga con le Quantit
            Print #NumFile, vStrRiga 'Stampo la stringa nel File
         End If
      
      
      'CONTROLLO SE DEVO INDICARE IL RESTO SULLO SCONTRINO
         If gtParam4RegCas.pImpRicPerScontrino > gtParam4RegCas.pImpTotale Then
            vStrRiga = Format(gtParam4RegCas.pImpRicPerScontrino, "########0.#0") 'Prezzo a 2 decimali
            vStrRiga = Replace(Replace(vStrRiga, ",", ""), ".", "") 'tolgo sia la virgola che il punto
            If Mid(vStrRiga, 1, 1) = "0" Then vStrRiga = Mid(vStrRiga, 2) 'tolgo l'eventuale zero iniziale (es: 0,35 diventa -> 035 e in definitiva -> 35)
            vStrRiga = vStrRiga & "H1T"
         Else
            vStrRiga = "1T"
         End If
         Print #NumFile, vStrRiga 'Stampo la stringa nel File
      

      ' Controllo se aprire il Cassetto
      If vApriCas = "1" Then
         vStrRiga = "a"
         Print #NumFile, vStrRiga 'Stampo la stringa nel File
      End If
            
            
      'Chiudo il file
      Close #NumFile
   End With
   
   StampaScontrino_XONXOFF = True
End Function

Private Function RowScontr_XONXOFF(pRiga As Integer, pTipo As String, Optional pValore As Currency, Optional pReparto As Byte, Optional pTesto As String, _
                                   Optional pTipoSconto As Byte) As String
                                   
   'Nota: Il parametro pTipoSconto => Default 0; 1 per EDIT che per gli sconti di Riga si comporta diversamente dal SAREMA-XonXoff
                                   
   Dim vStrValScontoDoc As String
   Dim vDescr As String
   Dim vPrezzo As String
   Dim vLenDescr As Byte
   Dim vVal As Currency
   Dim vValRiga As String
   
   With mpGridScontrino
      
      If pRiga > -1 Then
         vDescr = Trim(Mid(.Rows(pRiga).Record.Item(gtParam4RegCas.pColCodArt + 1).Value, 1, mLenDescriXonXOff))
         vDescr = PulisciDescrizioneScontrino(vDescr)
      End If
      
      Select Case pTipo
         Case "STD" 'riga STANDARD
            'Descrizione
               RowScontr_XONXOFF = Chr(34) & vDescr & Chr(34)
            'Quantit   ->  la inserisco solo se <> da 1
               If CCur(.Rows(pRiga).Record.Item(gtParam4RegCas.pColQuanti).Value) <> 1 Then
                  vDescr = FormattaNumero(.Rows(pRiga).Record.Item(gtParam4RegCas.pColQuanti).Value, pred_DecimaliQta, 1) 'Quantit a 3 decimali
                  vDescr = Replace(vDescr, ",", ".") 'imposto il punto decimale (non virgola)
                  RowScontr_XONXOFF = RowScontr_XONXOFF & vDescr & "*"
               End If
            'Prezzo
               vPrezzo = Format(.Rows(pRiga).Record.Item(gtParam4RegCas.pColPrezzo).Value, "########0.#0") 'Prezzo a 2 decimali
               vPrezzo = Replace(Replace(vPrezzo, ",", ""), ".", "") 'tolgo sia la virgola che il punto
               If Mid(vPrezzo, 1, 1) = "0" Then vPrezzo = Mid(vPrezzo, 2) 'tolgo l'eventuale zero iniziale (es: 0,35 diventa -> 035 e in definitiva -> 35)
               RowScontr_XONXOFF = RowScontr_XONXOFF & vPrezzo & "H"
            'Reparto
               RowScontr_XONXOFF = RowScontr_XONXOFF & pReparto & "R"
            'Sconto   ->  (se c' lo Sconto riga sull'Articolo)
               If .Rows(pRiga).Record.Item(gtParam4RegCas.pColScont1).Value > 0 Then
                  If .Rows(pRiga).Record.Item(gtParam4RegCas.pColScont1).Value < 100 Then 'Fino al 99%
                     vDescr = Format(.Rows(pRiga).Record.Item(gtParam4RegCas.pColScont1).Value, "##0.#0")
                     vDescr = Replace(vDescr, ",", ".") 'imposto il punto decimale (non virgola)
                     'qui creo la parte dello sconto in base al tipo di registratore
                     If pTipoSconto = 1 Then 'Qui  solo per l'EDIT che si comporta diversamente sal Sarema-XonXoff
                        RowScontr_XONXOFF = RowScontr_XONXOFF & vbNewLine  'Aggiungo la nuova riga (l'Edit lo vuole su una nuova riga!)
                        vDescr = Replace(vDescr, ".00", "") 'per gli sconti senza decimali DEVO togliere gli zeri (.00) altrimenti l'EDIT d i numeri!
                        RowScontr_XONXOFF = RowScontr_XONXOFF & vDescr & "*1M"
                     Else
                        RowScontr_XONXOFF = RowScontr_XONXOFF & vDescr & "*1M"
                     End If
                  Else        'OMAGGIO (STORNO)
                     If CCur(.Rows(pRiga).Record.Item(gtParam4RegCas.pColQuanti).Value) > 1 Then
                        'Moltiplico Prezzo * Quantit
                        vValRiga = Format(.Rows(pRiga).Record.Item(gtParam4RegCas.pColQuanti).Value * .Rows(pRiga).Record.Item(gtParam4RegCas.pColPrezzo).Value, "########0.#0") 'Prezzo a 2 decimali
                        vValRiga = Replace(Replace(vValRiga, ",", ""), ".", "") 'tolgo sia la virgola che il punto
                        If Mid(vValRiga, 1, 1) = "0" Then vValRiga = Mid(vValRiga, 2) 'tolgo l'eventuale zero iniziale (es: 0,35 diventa -> 035 e in definitiva -> 35)
                     Else
                        vValRiga = vPrezzo
                     End If
                     RowScontr_XONXOFF = RowScontr_XONXOFF & vbNewLine  'Aggiungo la nuova riga dove carico l'OMAGGIO
                     RowScontr_XONXOFF = RowScontr_XONXOFF & "0M" 'codice Funzione per l'OMAGGIO (STORNO)
                     RowScontr_XONXOFF = RowScontr_XONXOFF & vValRiga & "H" 'riporto l'interno importo dell'articolo
                     RowScontr_XONXOFF = RowScontr_XONXOFF & pReparto & "R"
                  End If
               End If
                              
         Case "RESO" 'riga RESO
            'Descrizione
               RowScontr_XONXOFF = Chr(34) & vDescr & Chr(34)
               RowScontr_XONXOFF = RowScontr_XONXOFF & "9M" '& Chr(34) & vDescr & Chr(34) <--- MODIFICA SU SEGNALAZIONE DI ALESSANDRO MIOTTO DELLA DACOS
            'Quantit   ->  la inserisco solo se <> da 1
               If CCur(.Rows(pRiga).Record.Item(gtParam4RegCas.pColQuanti).Value) <> 1 Then
                  vDescr = FormattaNumero(.Rows(pRiga).Record.Item(gtParam4RegCas.pColQuanti).Value, pred_DecimaliQta, 1) 'Quantit a 3 decimali
                  vDescr = Replace(vDescr, ",", ".") 'imposto il punto decimale (non virgola)
                  RowScontr_XONXOFF = RowScontr_XONXOFF & vDescr & "*"
               End If
            'Prezzo
               vPrezzo = Format(.Rows(pRiga).Record.Item(gtParam4RegCas.pColPrezzo).Value, "########0.#0") 'Prezzo a 2 decimali
               vPrezzo = Replace(Replace(Replace(vPrezzo, ",", ""), ".", ""), "-", "") 'tolgo sia la virgola che il punto che il segno "-"
               If Mid(vPrezzo, 1, 1) = "0" Then vPrezzo = Mid(vPrezzo, 2) 'tolgo l'eventuale zero iniziale (es: 0,35 diventa -> 035 e in definitiva -> 35)
               RowScontr_XONXOFF = RowScontr_XONXOFF & vPrezzo & "H"
            'Reparto
               RowScontr_XONXOFF = RowScontr_XONXOFF & pReparto & "R"
            'Sconto   ->  (se c' lo Sconto riga sull'Articolo)
               If .Rows(pRiga).Record.Item(gtParam4RegCas.pColScont1).Value > 0 Then
                  If .Rows(pRiga).Record.Item(gtParam4RegCas.pColScont1).Value < 100 Then 'Fino al 99%
                     vDescr = Format(.Rows(pRiga).Record.Item(gtParam4RegCas.pColScont1).Value, "##0.#0")
                     vDescr = Replace(vDescr, ",", ".") 'imposto il punto decimale (non virgola)
                     RowScontr_XONXOFF = RowScontr_XONXOFF & vDescr & "*1M"
                  Else        'OMAGGIO (STORNO)
                     RowScontr_XONXOFF = RowScontr_XONXOFF & vbNewLine  'Aggiungo la nuova riga dove carico l'OMAGGIO
                     RowScontr_XONXOFF = RowScontr_XONXOFF & "0M" 'codice Funzione per l'OMAGGIO (STORNO)
                     RowScontr_XONXOFF = RowScontr_XONXOFF & vPrezzo & "H" 'riporto l'intero importo dell'articolo
                     RowScontr_XONXOFF = RowScontr_XONXOFF & pReparto & "R"
                  End If
               End If
                  
         Case "STORNO" 'riga per gli articoli con IMPORTO NEGATIVO
            'Descrizione
               RowScontr_XONXOFF = Chr(34) & vDescr & Chr(34)
               RowScontr_XONXOFF = RowScontr_XONXOFF & "0M" & Chr(34) & vDescr & Chr(34) 'qui ripeto la descrizione altrimenti mi stamap REPARTO1 !!!
            'Quantit   ->  la inserisco solo se <> da 1
               If CCur(.Rows(pRiga).Record.Item(gtParam4RegCas.pColQuanti).Value) <> 1 Then
                  vDescr = FormattaNumero(.Rows(pRiga).Record.Item(gtParam4RegCas.pColQuanti).Value, pred_DecimaliQta, 1) 'Quantit a 3 decimali
                  vDescr = Replace(vDescr, ",", ".") 'imposto il punto decimale (non virgola)
                  RowScontr_XONXOFF = RowScontr_XONXOFF & vDescr & "*"
               End If
            'Prezzo
               vPrezzo = Format(.Rows(pRiga).Record.Item(gtParam4RegCas.pColPrezzo).Value, "########0.#0") 'Prezzo a 2 decimali
               vPrezzo = Replace(Replace(Replace(vPrezzo, ",", ""), ".", ""), "-", "") 'tolgo sia la virgola che il punto che il segno "-"
               If Mid(vPrezzo, 1, 1) = "0" Then vPrezzo = Mid(vPrezzo, 2) 'tolgo l'eventuale zero iniziale (es: 0,35 diventa -> 035 e in definitiva -> 35)
               RowScontr_XONXOFF = RowScontr_XONXOFF & vPrezzo & "H"
            'Reparto
               RowScontr_XONXOFF = RowScontr_XONXOFF & pReparto & "R"
                  
         Case "SCN_DOC_PER" 'riga SCONTO DOCUMENTO IN PERCENTUALE
            vDescr = Format(gtParam4RegCas.pScontoDoc, "##0.#0")
            vDescr = Replace(vDescr, ",", ".") 'imposto il punto decimale (non virgola)
            If pTipoSconto = 1 Then 'Qui  solo per l'EDIT che si comporta diversamente sal Sarema-XonXoff
               vDescr = Replace(vDescr, ".00", "") 'per gli sconti senza decimali DEVO togliere gli zeri (.00) altrimenti l'EDIT d i numeri!
            End If
            RowScontr_XONXOFF = vDescr & "*2M"
            
         Case "SCN_DOC_DOC" 'riga SCONTO DOCUMENTO A VALORE
            vDescr = Format(gtParam4RegCas.pScontoDoc, "########0.#0") 'Prezzo a 2 decimali
            vDescr = Replace(Replace(vDescr, ",", ""), ".", "") 'tolgo sia la virgola che il punto
            If Mid(vDescr, 1, 1) = "0" Then vDescr = Mid(vDescr, 2) 'tolgo l'eventuale zero iniziale (es: 0,35 diventa -> 035 e in definitiva -> 35)
            RowScontr_XONXOFF = vDescr & "H4M"
         
         Case "CORTESIA" 'riga di Cortesia (viene stampata dopo il Totale
            RowScontr_XONXOFF = Chr(34) & pTesto & Chr(34)
            RowScontr_XONXOFF = RowScontr_XONXOFF & "@"
      
      End Select
      
   End With
   
End Function

Private Function StampaFattura_XONXOFF(pSerial As Long, pDoppiaCopia As String, vApriCas As String, _
                                       pPathFile As String, pMarca As String) As Boolean
   Dim vStrRiga As String
   
   Dim vVal As String
   Dim vPrezzo As String
   Dim vReparto As String
   
   Dim vValSconto As Currency
   Dim vScontoPercent As Boolean
   
   Dim NumFile As Integer 'per aprire il file che mi serve per storicizzare lo scontrino ed eventualmente ristamparlo

   Dim RS As ADODB.Recordset
   Dim strRicerca As String
   
   Dim vNumDoc As String
   Dim vCliRagSoc As String
   Dim vCliIndiri As String
   Dim vCliLocali As String
   Dim vCliParIva As String
   Dim vCliCodFis As String
   
   
   StampaFattura_XONXOFF = False
   
'Qui Prendo i dati dal MASTER =============================================
   strRicerca = "SELECT * " & _
                "FROM [" & Azienda & "DOC_MAST] INNER JOIN [" & Azienda & "CONTI] ON ([" & Azienda & "DOC_MAST].MVCODCON = [" & Azienda & "CONTI].ANCODICE) AND ([" & Azienda & "DOC_MAST].MVTIPCON = [" & Azienda & "CONTI].ANTIPCON) " & _
                "WHERE MVSERIAL = " & pSerial
                
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneGenerale, adOpenStatic
   If Not RS.EOF Then
      vNumDoc = RS!MVNUMDOC '& IIf(Len(Trim(RS!MVALFDOC)) > 0, "/" & RS!MVALFDOC, "")
      'vNumDoc = 'vNumDoc & " del " & RS!MVDATDOC
      
      vCliRagSoc = Mid(RS!ANDESCRI, 1, 32)
      vCliIndiri = Mid(NonNullo(RS!ANINDIRI), 1, 32)
      vCliLocali = IIf(Len(Trim(NonNullo(RS!AN___CAP))) > 0, NonNullo(RS!AN___CAP) & " ", "")
      vCliLocali = vCliLocali & Mid(NonNullo(RS!ANLOCALI), 1, 21) 'max 21 perche' gli altri caratteri se li prendono il CAP(5) e la Provincia(4) + 2 spazi (tot 11)
      vCliLocali = vCliLocali & IIf(Len(Trim(NonNullo(RS!ANPROVIN))) > 0, " (" & NonNullo(RS!ANPROVIN) & ")", "")
      vCliParIva = NonNullo(RS!ANPARIVA)
      vCliCodFis = NonNullo(RS!ANCODFIS)
      
      'Verifico gli sconti
      If RS!MVSCOVAL > 0 Or RS!MVSCODC1 > 0 Then
         If RS!MVSCOVAL > 0 Then
            vValSconto = RS!MVSCOVAL
            vScontoPercent = False
         Else
            vValSconto = RS!MVSCODC1
            vScontoPercent = True
         End If
      End If
   End If
   RS.Close
   Set RS = Nothing


'A P R O   I L   F I L E     <==============================================================================================
   NumFile = FreeFile
   Open pPathFile For Append As #NumFile      'CREO IL FILE
      
   If UCase(pMarca) = "3I-XONXOFF" Then
      vStrRiga = "190F"
      Print #NumFile, vStrRiga 'Azzero il progressivo delle Fatture (SOLO per 3i)
   End If
   
   vStrRiga = Chr(34) & String(5 - Len(vNumDoc), "0") & vNumDoc & Chr(34) & "19F"
   Print #NumFile, vStrRiga 'Stampo la stringa nel File
      
   
   'D A T I   D E L   C L I E N  T E --------------------------
   vStrRiga = Chr(34) & vCliRagSoc & Chr(34) & "192F"
   Print #NumFile, vStrRiga 'Stampo la stringa nel File
   'Debug.Print vStrRiga
   If Len(Trim(vCliIndiri)) > 0 Then
      vStrRiga = Chr(34) & vCliIndiri & Chr(34) & "193F"
      Print #NumFile, vStrRiga 'Stampo la stringa nel File
   End If
   If Len(Trim(vCliLocali)) > 0 Then
      vStrRiga = Chr(34) & vCliLocali & Chr(34) & "194F"
      Print #NumFile, vStrRiga 'Stampo la stringa nel File
   End If
   If Len(Trim(vCliParIva)) > 0 Then
      vStrRiga = Chr(34) & vCliParIva & Chr(34) & "195F"
      Print #NumFile, vStrRiga 'Stampo la stringa nel File
   End If
   If Len(Trim(vCliCodFis)) > 0 Then
      vStrRiga = Chr(34) & vCliCodFis & Chr(34) & "196F"
      'vStrRiga = Chr(34) & vCliCodFis & Chr(34) & "@39F"
      Print #NumFile, vStrRiga 'Stampo la stringa nel File
   End If
      
      
'Qui Prendo i dettagli degli Articoli =============================================
   strRicerca = "SELECT * " & _
                "FROM     [" & Azienda & "DOC_DETT] " & _
                "WHERE MVSERIAL = " & pSerial & " AND MVTIPRIG <> 'D' " & _
                "ORDER BY CPROWNUM"
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneGenerale, adOpenStatic
   If Not RS.EOF Then
      'vTotArt = 0
      Do Until RS.EOF
         
         'Qui verifico se c'e' l'associazione del Codice IVA con il Reparti del Registratore di Cassa
         vReparto = ReadINI("REPARTIIVA_REPARTI", RS!MVCODIVA, mPathFileConf4Scontrino) '<--- DA CORREGGERE COL REPARTO DI STAMPA!!
         If Len(Trim(vReparto)) > 0 Then vReparto = Right(vReparto, 1)
         If IsNumeric(vReparto) = False Then vReparto = "1"
         
         
         'Descrizione
            vStrRiga = Chr(34) & RS!MVDESART & Chr(34)
         'Quantit   ->  la inserisco solo se <> da 1
            vVal = FormattaNumero(RS!MVPESRIS, pred_DecimaliQta, 1) 'Quantit a 3 decimali
            vVal = Replace(vVal, ",", ".") 'imposto il punto decimale (non virgola)
            vStrRiga = vStrRiga & vVal & "*"
         'Prezzo
            vPrezzo = Format(RS!MVPRZNET, "########0.#0") 'Prezzo a 2 decimali
            vPrezzo = Replace(Replace(vPrezzo, ",", ""), ".", "") 'tolgo sia la virgola che il punto
            If Mid(vPrezzo, 1, 1) = "0" Then vPrezzo = Mid(vPrezzo, 2) 'tolgo l'eventuale zero iniziale (es: 0,35 diventa -> 035 e in definitiva -> 35)
            vStrRiga = vStrRiga & vPrezzo & "H"
         'Reparto
            vStrRiga = vStrRiga & vReparto & "R"
         'Sconto   ->  (se c' lo Sconto riga sull'Articolo)
            If RS!MVSCORW1 > 0 Then
               If RS!MVSCORW1 < 100 Then 'Fino al 99%
                  vVal = Format(RS!MVSCORW1, "##0.#0")
                  vVal = Replace(vVal, ",", ".") 'imposto il punto decimale (non virgola)
                  vStrRiga = vStrRiga & vVal & "*1M"
               Else        'OMAGGIO (STORNO)
                  vStrRiga = vStrRiga & vbNewLine  'Aggiungo la nuova riga dove carico l'OMAGGIO
                  vStrRiga = vStrRiga & "0M" 'codice Funzione per l'OMAGGIO (STORNO)
                  vStrRiga = vStrRiga & vPrezzo & "H" 'riporto l'interno importo dell'articolo
                  vStrRiga = vStrRiga & vReparto & "R"
               End If
            End If
         
            Print #NumFile, vStrRiga 'Stampo la stringa nel File
      
         RS.MoveNext
      Loop
   End If
   RS.Close
   Set RS = Nothing
      
      
   'Punti Fedelet accumulati
   If gtParam4RegCas.pPuntiFid > 0 Then
      vStrRiga = RowScontr_XONXOFF(-1, "CORTESIA", 0, 0, "------------------------------") 'Inserisco la riga con le Quantit
      Print #NumFile, vStrRiga 'Stampo la stringa nel File
      vStrRiga = RowScontr_XONXOFF(-1, "CORTESIA", 0, 0, ">>> PUNTI FIDELITY: " & Trim(Str(gtParam4RegCas.pPuntiFid)) & " <<<") 'Inserisco la riga con le Quantit
      Print #NumFile, vStrRiga 'Stampo la stringa nel File
      vStrRiga = RowScontr_XONXOFF(-1, "CORTESIA", 0, 0, "------------------------------") 'Inserisco la riga con le Quantit
      Print #NumFile, vStrRiga 'Stampo la stringa nel File
   End If
      
      
   'Eventuali SCONTI sul DOCUMENTO
   If vValSconto > 0 Then
      'Stampo il Subtotale
         vStrRiga = "="
         Print #NumFile, vStrRiga 'Stampo la stringa nel File
      
      'Stampo lo sconto
         If vScontoPercent = True Then 'Controllo se  in PERCENTUALE...
            vStrRiga = Format(vValSconto, "##0.#0")
            vStrRiga = Replace(vStrRiga, ",", ".") 'imposto il punto decimale (non virgola)
            Print #NumFile, vStrRiga & "*2M"
         Else                          '...oppure se  a VALORE
            vStrRiga = Format(vValSconto, "########0.#0") 'Prezzo a 2 decimali
            vStrRiga = Replace(Replace(vStrRiga, ",", ""), ".", "") 'tolgo sia la virgola che il punto
            If Mid(vStrRiga, 1, 1) = "0" Then vStrRiga = Mid(vStrRiga, 2) 'tolgo l'eventuale zero iniziale (es: 0,35 diventa -> 035 e in definitiva -> 35)
            Print #NumFile, vStrRiga & "H4M"
         End If
   End If
      
      
   vStrRiga = "1T"
   Print #NumFile, vStrRiga 'Stampo la stringa nel File
   

   ' Controllo se aprire il Cassetto
   If vApriCas = "1" Then
      vStrRiga = "a"
      Print #NumFile, vStrRiga 'Stampo la stringa nel File
   End If
      
         
   'Chiudo il file
   Close #NumFile
   
   
   StampaFattura_XONXOFF = True
End Function


Private Function StampaFatturaCUSTOM_XONXOFF(pSerial As Long, pDoppiaCopia As String, vApriCas As String, _
                                             pPathFile As String) As Boolean
   Dim vStrRiga As String
   
   Dim vVal As String
   Dim vPrezzo As String
   Dim vReparto As String
   Dim vDesArt As String
   Dim vValRiga As String
   Dim vValSconto As Currency
   Dim vScontoPercent As Boolean
   
   Dim NumFile As Integer 'per aprire il file che mi serve per storicizzare lo scontrino ed eventualmente ristamparlo

   Dim RS As ADODB.Recordset
   Dim strRicerca As String
   
   Dim vNumDoc As String
   Dim vCliRagSoc As String
   Dim vCliIndiri As String
   Dim vCliLocali As String
   Dim vCliParIva As String
   Dim vCliCodFis As String
   
   
   StampaFatturaCUSTOM_XONXOFF = False
   
'Qui Prendo i dati dal MASTER =============================================
   strRicerca = "SELECT * " & _
                "FROM [" & Azienda & "DOC_MAST] INNER JOIN [" & Azienda & "CONTI] ON ([" & Azienda & "DOC_MAST].MVCODCON = [" & Azienda & "CONTI].ANCODICE) AND ([" & Azienda & "DOC_MAST].MVTIPCON = [" & Azienda & "CONTI].ANTIPCON) " & _
                "WHERE MVSERIAL = " & pSerial
                
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneGenerale, adOpenStatic
   If Not RS.EOF Then
      vNumDoc = RS!MVNUMDOC '& IIf(Len(Trim(RS!MVALFDOC)) > 0, "/" & RS!MVALFDOC, "")
      
      vCliRagSoc = Mid(RS!ANDESCRI, 1, 32)
      vCliIndiri = Mid(NonNullo(RS!ANINDIRI), 1, 32)
      vCliLocali = IIf(Len(Trim(NonNullo(RS!AN___CAP))) > 0, NonNullo(RS!AN___CAP) & " ", "")
      vCliLocali = vCliLocali & Mid(NonNullo(RS!ANLOCALI), 1, 21) 'max 21 perche' gli altri caratteri se li prendono il CAP(5) e la Provincia(4) + 2 spazi (tot 11)
      vCliLocali = vCliLocali & IIf(Len(Trim(NonNullo(RS!ANPROVIN))) > 0, " (" & NonNullo(RS!ANPROVIN) & ")", "")
      vCliParIva = NonNullo(RS!ANPARIVA)
      vCliCodFis = NonNullo(RS!ANCODFIS)
      
      'Verifico gli sconti
      If RS!MVSCOVAL > 0 Or RS!MVSCODC1 > 0 Then
         If RS!MVSCOVAL > 0 Then
            vValSconto = RS!MVSCOVAL
            vScontoPercent = False
         Else
            vValSconto = RS!MVSCODC1
            vScontoPercent = True
         End If
      End If
   End If
   RS.Close
   Set RS = Nothing



'APRO IL FILE <=======================================================================================
   NumFile = FreeFile
   Open pPathFile For Append As #NumFile      'CREO IL FILE
   
   
   vStrRiga = "9F"
   Print #NumFile, vStrRiga 'Stampo la stringa nel File
      
   vStrRiga = Chr(34) & String(5 - Len(vNumDoc), "0") & vNumDoc & Chr(34) & "101M"
   Print #NumFile, vStrRiga 'Stampo la stringa nel File
      
      
'Qui Prendo i dettagli degli Articoli =============================================
   strRicerca = "SELECT * " & _
                "FROM     [" & Azienda & "DOC_DETT] " & _
                "WHERE MVSERIAL = " & pSerial & " AND MVTIPRIG <> 'D' " & _
                "ORDER BY CPROWNUM"
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneGenerale, adOpenStatic
   If Not RS.EOF Then
      'vTotArt = 0
      Do Until RS.EOF
         'Qui verifico se c'e' l'associazione del Codice IVA con il Reparti del Registratore di Cassa
         vReparto = ReadINI("REPARTIIVA_REPARTI", RS!MVCODIVA, mPathFileConf4Scontrino) '<--- DA CORREGGERE COL REPARTO DI STAMPA!!
         If Len(Trim(vReparto)) > 0 Then vReparto = Right(vReparto, 1)
         If IsNumeric(vReparto) = False Then vReparto = "1"
         
         'Descrizione
            vDesArt = Chr(34) & RS!MVDESART & Chr(34)
            vStrRiga = vDesArt
         'Quantit   ->  la inserisco solo se <> da 1
            vVal = FormattaNumero(RS!MVPESRIS, pred_DecimaliQta, 1) 'Quantit a 3 decimali
            vVal = Replace(vVal, ",", ".") 'imposto il punto decimale (non virgola)
            vStrRiga = vStrRiga & vVal & "*"
         'Prezzo (estraggo)
            vPrezzo = Format(RS!MVPRZNET, "########0.#0") 'Prezzo a 2 decimali
            vPrezzo = Replace(Replace(vPrezzo, ",", ""), ".", "") 'tolgo sia la virgola che il punto
            If Mid(vPrezzo, 1, 1) = "0" Then vPrezzo = Mid(vPrezzo, 2) 'tolgo l'eventuale zero iniziale (es: 0,35 diventa -> 035 e in definitiva -> 35)
            
         'Se la riga  negativa allora imposto il comando che serve tra la quantit e il prezzo
            If RS!MVPRZNET < 0 Then vStrRiga = vStrRiga & "0M" & vDesArt 'codice Funzione per l'OMAGGIO (STORNO)
         
         'Prezzo (inserisco)
            vStrRiga = vStrRiga & vPrezzo & "H"
         'Reparto
            vStrRiga = vStrRiga & vReparto & "R"
                        
         'Sconto   ->  (se c' lo Sconto riga sull'Articolo)
            If RS!MVSCORW1 > 0 Then
               If RS!MVSCORW1 < 100 Then 'Fino al 99%
                  vVal = Format(RS!MVSCORW1, "##0.#0")
                  vVal = Replace(vVal, ",", ".") 'imposto il punto decimale (non virgola)
                  vStrRiga = vStrRiga & vVal & "*1M"
               Else        'OMAGGIO (STORNO)
                  If CCur(RS!MVPESRIS) > 1 Then
                     'Moltiplico Prezzo * Quantit
                     vValRiga = Format((RS!MVPRZNET * RS!MVPESRIS), "########0.#0") 'Prezzo a 2 decimali
                     vValRiga = Replace(Replace(vValRiga, ",", ""), ".", "") 'tolgo sia la virgola che il punto
                     If Mid(vValRiga, 1, 1) = "0" Then vValRiga = Mid(vValRiga, 2) 'tolgo l'eventuale zero iniziale (es: 0,35 diventa -> 035 e in definitiva -> 35)
                  Else
                     vValRiga = vPrezzo
                  End If
                  vStrRiga = vStrRiga & vbNewLine  'Aggiungo la nuova riga dove carico l'OMAGGIO
                  vStrRiga = vStrRiga & "0M" 'codice Funzione per l'OMAGGIO (STORNO)
                  vStrRiga = vStrRiga & vValRiga & "H" 'riporto l'interno importo dell'articolo
                  vStrRiga = vStrRiga & vReparto & "R"
               End If
            End If
         
            Print #NumFile, vStrRiga 'Stampo la stringa nel File
      
         RS.MoveNext
      Loop
   End If
   RS.Close
   Set RS = Nothing
      
      
      
   'D A T I   D E L   C L I E N  T E --------------------------
   vStrRiga = Chr(34) & vCliRagSoc & Chr(34) & "@38F"
   Print #NumFile, vStrRiga 'Stampo la stringa nel File
   'Debug.Print vStrRiga
   If Len(Trim(vCliIndiri)) > 0 Then
      vStrRiga = Chr(34) & vCliIndiri & Chr(34) & "@38F"
      Print #NumFile, vStrRiga 'Stampo la stringa nel File
   End If
   If Len(Trim(vCliLocali)) > 0 Then
      vStrRiga = Chr(34) & vCliLocali & Chr(34) & "@38F"
      Print #NumFile, vStrRiga 'Stampo la stringa nel File
   End If
   If Len(Trim(vCliParIva)) > 0 Then
      vStrRiga = Chr(34) & "P.IVA: " & vCliParIva & Chr(34) & "@38F"
      Print #NumFile, vStrRiga 'Stampo la stringa nel File
   End If
   
   If Len(gtParam4RegCas.pCodFisc) > 0 Then vCliCodFis = gtParam4RegCas.pCodFisc 'controllo che se il Codice Fiscale passato dalla Cassa allora ha la presedenza
   If Len(Trim(vCliCodFis)) > 0 Then
      vStrRiga = Chr(34) & "C.FISC.: " & vCliCodFis & Chr(34) & "@38F"
      Print #NumFile, vStrRiga 'Stampo la stringa nel File
   End If
      
      
   'Punti Fedelet accumulati
   If gtParam4RegCas.pPuntiFid > 0 Then
      vStrRiga = RowScontr_XONXOFF(-1, "CORTESIA", 0, 0, "------------------------------") 'Inserisco la riga con le Quantit
      Print #NumFile, vStrRiga 'Stampo la stringa nel File
      vStrRiga = RowScontr_XONXOFF(-1, "CORTESIA", 0, 0, ">>> PUNTI FIDELITY: " & Trim(Str(gtParam4RegCas.pPuntiFid)) & " <<<") 'Inserisco la riga con le Quantit
      Print #NumFile, vStrRiga 'Stampo la stringa nel File
      vStrRiga = RowScontr_XONXOFF(-1, "CORTESIA", 0, 0, "------------------------------") 'Inserisco la riga con le Quantit
      Print #NumFile, vStrRiga 'Stampo la stringa nel File
   End If
      
      
   'Eventuali SCONTI sul DOCUMENTO
   If vValSconto > 0 Then
      'Stampo il Subtotale
         vStrRiga = "="
         Print #NumFile, vStrRiga 'Stampo la stringa nel File
      
      'Stampo lo sconto
         If vScontoPercent = True Then 'Controllo se  in PERCENTUALE...
            vStrRiga = Format(vValSconto, "##0.#0")
            vStrRiga = Replace(vStrRiga, ",", ".") 'imposto il punto decimale (non virgola)
            Print #NumFile, vStrRiga & "*2M"
         Else                          '...oppure se  a VALORE
            vStrRiga = Format(vValSconto, "########0.#0") 'Prezzo a 2 decimali
            vStrRiga = Replace(Replace(vStrRiga, ",", ""), ".", "") 'tolgo sia la virgola che il punto
            If Mid(vStrRiga, 1, 1) = "0" Then vStrRiga = Mid(vStrRiga, 2) 'tolgo l'eventuale zero iniziale (es: 0,35 diventa -> 035 e in definitiva -> 35)
            Print #NumFile, vStrRiga & "H4M"
         End If
   End If
      
   'Chiusura scontrino
   vStrRiga = "1T"
   Print #NumFile, vStrRiga 'Stampo la stringa nel File

   ' Controllo se aprire il Cassetto
   If vApriCas = "1" Then
      vStrRiga = "a"
      Print #NumFile, vStrRiga 'Stampo la stringa nel File
   End If
      
         
   'Chiudo il file
   Close #NumFile
   
   
   StampaFatturaCUSTOM_XONXOFF = True
End Function

Private Function StampaFatturaSAREMA_XONXOFF(pSerial As Long, pDoppiaCopia As String, vApriCas As String, _
                                             pPathFile As String) As Boolean
   Dim vStrRiga As String
   
   Dim vVal As String
   Dim vPrezzo As String
   Dim vReparto As String
   
   Dim vValSconto As Currency
   Dim vScontoPercent As Boolean
   
   Dim NumFile As Integer 'per aprire il file che mi serve per storicizzare lo scontrino ed eventualmente ristamparlo

   Dim RS As ADODB.Recordset
   Dim strRicerca As String
   
   Dim vNumDoc As String
   Dim vCliRagSoc As String
   Dim vCliIndiri As String
   Dim vCliLocali As String
   Dim vCliParIva As String
   Dim vCliCodFis As String
   
   
   StampaFatturaSAREMA_XONXOFF = False
   
'Qui Prendo i dati dal MASTER =============================================
   strRicerca = "SELECT * " & _
                "FROM [" & Azienda & "DOC_MAST] INNER JOIN [" & Azienda & "CONTI] ON ([" & Azienda & "DOC_MAST].MVCODCON = [" & Azienda & "CONTI].ANCODICE) AND ([" & Azienda & "DOC_MAST].MVTIPCON = [" & Azienda & "CONTI].ANTIPCON) " & _
                "WHERE MVSERIAL = " & pSerial
                
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneGenerale, adOpenStatic
   If Not RS.EOF Then
      vNumDoc = RS!MVNUMDOC '& IIf(Len(Trim(RS!MVALFDOC)) > 0, "/" & RS!MVALFDOC, "")
      
      vCliRagSoc = Mid(RS!ANDESCRI, 1, 32)
      vCliIndiri = Mid(NonNullo(RS!ANINDIRI), 1, 32)
      vCliLocali = IIf(Len(Trim(NonNullo(RS!AN___CAP))) > 0, NonNullo(RS!AN___CAP) & " ", "")
      vCliLocali = vCliLocali & Mid(NonNullo(RS!ANLOCALI), 1, 21) 'max 21 perche' gli altri caratteri se li prendono il CAP(5) e la Provincia(4) + 2 spazi (tot 11)
      vCliLocali = vCliLocali & IIf(Len(Trim(NonNullo(RS!ANPROVIN))) > 0, " (" & NonNullo(RS!ANPROVIN) & ")", "")
      vCliParIva = NonNullo(RS!ANPARIVA)
      vCliCodFis = NonNullo(RS!ANCODFIS)
      
      'Verifico gli sconti
      If RS!MVSCOVAL > 0 Or RS!MVSCODC1 > 0 Then
         If RS!MVSCOVAL > 0 Then
            vValSconto = RS!MVSCOVAL
            vScontoPercent = False
         Else
            vValSconto = RS!MVSCODC1
            vScontoPercent = True
         End If
      End If
   End If
   RS.Close
   Set RS = Nothing



'APRO IL FILE <=======================================================================================
   NumFile = FreeFile
   Open pPathFile For Append As #NumFile      'CREO IL FILE
   
         
   vStrRiga = Chr(34) & String(4 - Len(vNumDoc), "0") & vNumDoc & Chr(34) & "@"
   Print #NumFile, vStrRiga 'Stampo la stringa nel File
            
   vStrRiga = "99F"
   Print #NumFile, vStrRiga 'Stampo la stringa nel File
      
      
   'D A T I   D E L   C L I E N T E --------------------------
   vStrRiga = Chr(34) & vCliRagSoc & Chr(34) & "@"
   Print #NumFile, vStrRiga 'Stampo la stringa nel File
   'Debug.Print vStrRiga
   If Len(Trim(vCliIndiri)) > 0 Then
      vStrRiga = Chr(34) & vCliIndiri & Chr(34) & "@"
      Print #NumFile, vStrRiga 'Stampo la stringa nel File
   End If
   If Len(Trim(vCliLocali)) > 0 Then
      vStrRiga = Chr(34) & vCliLocali & Chr(34) & "@"
      Print #NumFile, vStrRiga 'Stampo la stringa nel File
   End If
   If Len(Trim(vCliParIva)) > 0 Then
      vStrRiga = Chr(34) & "P.IVA: " & vCliParIva & Chr(34) & "@"
      Print #NumFile, vStrRiga 'Stampo la stringa nel File
   End If
   If Len(Trim(vCliCodFis)) > 0 Then
      vStrRiga = Chr(34) & "C.FISC.: " & vCliCodFis & Chr(34) & "@"
      Print #NumFile, vStrRiga 'Stampo la stringa nel File
   End If
      
      
   vStrRiga = "937F"
   Print #NumFile, vStrRiga 'Stampo la stringa nel File
      
      
'Qui Prendo i dettagli degli Articoli =============================================
   strRicerca = "SELECT * " & _
                "FROM     [" & Azienda & "DOC_DETT] " & _
                "WHERE MVSERIAL = " & pSerial & " AND MVTIPRIG <> 'D' " & _
                "ORDER BY CPROWNUM"
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneGenerale, adOpenStatic
   If Not RS.EOF Then
      'vTotArt = 0
      Do Until RS.EOF
         'Qui verifico se c'e' l'associazione del Codice IVA con il Reparti del Registratore di Cassa
         vReparto = ReadINI("REPARTIIVA_REPARTI", RS!MVCODIVA, mPathFileConf4Scontrino) '<--- DA CORREGGERE COL REPARTO DI STAMPA!!
         If Len(Trim(vReparto)) > 0 Then vReparto = Right(vReparto, 1)
         If IsNumeric(vReparto) = False Then vReparto = "1"
         
         'Descrizione
            vStrRiga = Chr(34) & RS!MVDESART & Chr(34)
         'Quantit   ->  la inserisco solo se <> da 1
            vVal = FormattaNumero(RS!MVPESRIS, pred_DecimaliQta, 1) 'Quantit a 3 decimali
            vVal = Replace(vVal, ",", ".") 'imposto il punto decimale (non virgola)
            vStrRiga = vStrRiga & vVal & "*"
         'Prezzo
            vPrezzo = Format(RS!MVPRZNET, "########0.#0") 'Prezzo a 2 decimali
            vPrezzo = Replace(Replace(vPrezzo, ",", ""), ".", "") 'tolgo sia la virgola che il punto
            If Mid(vPrezzo, 1, 1) = "0" Then vPrezzo = Mid(vPrezzo, 2) 'tolgo l'eventuale zero iniziale (es: 0,35 diventa -> 035 e in definitiva -> 35)
            vStrRiga = vStrRiga & vPrezzo & "H"
         'Reparto
            vStrRiga = vStrRiga & vReparto & "R"
         'Sconto   ->  (se c' lo Sconto riga sull'Articolo)
            If RS!MVSCORW1 > 0 Then
               If RS!MVSCORW1 < 100 Then 'Fino al 99%
                  vVal = Format(RS!MVSCORW1, "##0.#0")
                  vVal = Replace(vVal, ",", ".") 'imposto il punto decimale (non virgola)
                  vStrRiga = vStrRiga & vVal & "*1M"
               Else        'OMAGGIO (STORNO)
                  vStrRiga = vStrRiga & vbNewLine  'Aggiungo la nuova riga dove carico l'OMAGGIO
                  vStrRiga = vStrRiga & "0M" 'codice Funzione per l'OMAGGIO (STORNO)
                  vStrRiga = vStrRiga & vPrezzo & "H" 'riporto l'interno importo dell'articolo
                  vStrRiga = vStrRiga & vReparto & "R"
               End If
            End If
         
            Print #NumFile, vStrRiga 'Stampo la stringa nel File
      
         RS.MoveNext
      Loop
   End If
   RS.Close
   Set RS = Nothing
            
      
   'Punti Fedelet accumulati
   If gtParam4RegCas.pPuntiFid > 0 Then
      vStrRiga = RowScontr_XONXOFF(-1, "CORTESIA", 0, 0, "------------------------------") 'Inserisco la riga con le Quantit
      Print #NumFile, vStrRiga 'Stampo la stringa nel File
      vStrRiga = RowScontr_XONXOFF(-1, "CORTESIA", 0, 0, "P.TI FIDELITY: " & Trim(Str(gtParam4RegCas.pPuntiFid)) & "") 'Inserisco la riga con le Quantit
      Print #NumFile, vStrRiga 'Stampo la stringa nel File
      vStrRiga = RowScontr_XONXOFF(-1, "CORTESIA", 0, 0, "------------------------------") 'Inserisco la riga con le Quantit
      Print #NumFile, vStrRiga 'Stampo la stringa nel File
   End If
      
      
   'Eventuali SCONTI sul DOCUMENTO
   If vValSconto > 0 Then
      'Stampo il Subtotale
         vStrRiga = "="
         Print #NumFile, vStrRiga 'Stampo la stringa nel File
      
      'Stampo lo sconto
         If vScontoPercent = True Then 'Controllo se  in PERCENTUALE...
            vStrRiga = Format(vValSconto, "##0.#0")
            vStrRiga = Replace(vStrRiga, ",", ".") 'imposto il punto decimale (non virgola)
            Print #NumFile, vStrRiga & "*2M"
         Else                          '...oppure se  a VALORE
            vStrRiga = Format(vValSconto, "########0.#0") 'Prezzo a 2 decimali
            vStrRiga = Replace(Replace(vStrRiga, ",", ""), ".", "") 'tolgo sia la virgola che il punto
            If Mid(vStrRiga, 1, 1) = "0" Then vStrRiga = Mid(vStrRiga, 2) 'tolgo l'eventuale zero iniziale (es: 0,35 diventa -> 035 e in definitiva -> 35)
            Print #NumFile, vStrRiga & "H4M"
         End If
   End If
      
   'Chiusura scontrino
   vStrRiga = "1T"
   Print #NumFile, vStrRiga 'Stampo la stringa nel File

   ' Controllo se aprire il Cassetto
   If vApriCas = "1" Then
      vStrRiga = "a"
      Print #NumFile, vStrRiga 'Stampo la stringa nel File
   End If
      
         
   'Chiudo il file
   Close #NumFile
   
   
   StampaFatturaSAREMA_XONXOFF = True
End Function



Public Sub Insert_DOC_INFO_RT(Optional pSerialAcconto As Long)
   'If gtParam4RegCas.pSerial = 0 And pSerialAcconto = 0 Then Exit Sub
   
   
   Dim StrCampi As String
   Dim StrValori As String
   Dim strStringa As String
   
   
   StrCampi = "RTSERDOC"
   If pSerialAcconto > 0 Then
      StrValori = "" & pSerialAcconto & ""
   Else
      StrValori = "" & IIf(gtLastScontrino.ProgFiscale > 0, gtParam4RegCas.pSerial, 0) & ""
   End If
   StrCampi = StrCampi & ", RTCODCON"
   StrValori = StrValori & ",'" & gtParam4RegCas.pCodConto & "'"
   StrCampi = StrCampi & ", RTFILEIN"
   StrValori = StrValori & ",'" & gtLastScontrino.FilePrint & "'"
   StrCampi = StrCampi & ", RTPROGRT"
   StrValori = StrValori & "," & gtLastScontrino.ProgFiscale & ""
   StrCampi = StrCampi & ", RTTXTOUT"
   StrValori = StrValori & ",'" & IIf(pSerialAcconto > 0, "ACCONTO|", "") & VerificaApici(gtLastScontrino.StringaEsito) & "'"
   StrCampi = StrCampi & ", RTDATPRN"
   StrValori = StrValori & "," & DataOraSQL(Now, False, "", True)
   StrCampi = StrCampi & ", RTMATRIC"
   StrValori = StrValori & ",'" & gtParam4RegCas.pMatricola & "'"
   
   If pSerialAcconto > 0 Then
      EseguiSQLMDB ("INSERT INTO [" & Azienda & "DOC_RT_INFO] (" & StrCampi & ") VALUES ( " & StrValori & " )")
   Else
      gtLastScontrino.EsitoPerDB = "INSERT INTO [" & Azienda & "DOC_RT_INFO] (" & StrCampi & ") VALUES ( " & StrValori & " )"
   End If
   
End Sub


Public Function RTAnnullaDoc(Optional pPathFIleConf As String) As Boolean
   FormResoAnnulloRT.mpTipoProcedura = "A"
   gtParam4RegCas.pResAnnMatric = ReadINI("PARAMETRI", "MATRICOLA_RT", pPathFIleConf)
   FormResoAnnulloRT.Show 1
   Set FormResoAnnulloRT = Nothing
   
   RTAnnullaDoc = gtParam4RegCas.pEseguiAnnullo
End Function


Public Function VerificaSeScontrinoAnnullato(pSerDoc As Long, pProgScontrino As Integer) As Boolean
   'Verifico se lo scontrino associato al documento  stato annullato _
    ( presente una data che per convenzione  >= del 01/07/2019 data di entrata in vigore della legge) _
    ed in questo caso restiuisce TRUE
   Dim RS As ADODB.Recordset
   Dim strRicerca As String
   
   strRicerca = "SELECT RT_ID " & _
                "  FROM [" & Azienda & "DOC_RT_INFO] " & _
                " WHERE (RTPROGRT =  " & pProgScontrino & ") " & _
                "   AND (RTSERDOC =  " & pSerDoc & ") " & _
                "   AND (RTDATDEL >= " & DataOraSQL("01/07/2019", False, "00:00:01", False) & ") "
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnessioneGenerale, adOpenStatic
      VerificaSeScontrinoAnnullato = Not RS.EOF
   RS.Close
   Set RS = Nothing
End Function

