Attribute VB_Name = "ModuloRegCasCUSTOM"
Option Explicit

'Dichiarazioni che consentono di usare la CeFdll della CUSTOM -----------------------
   'Chiamate per protocollo CUSTOM DLL
      Declare Function VbCEFOpen Lib "CeFdll.dll" (ByVal intCom As Long, ByVal dwBaudRate As Long, ByVal byParity As Byte, ByVal byDataBit As Byte, ByVal byStopBit As Byte, ByVal byFlowControl As Byte, lpdwSysError As Long) As Long ' Declare Function for Open Communication RS232 Seriale
      Declare Function VbCEFOpenEth Lib "CeFdll.dll" (textip As String, ByVal dwPort As Long, lpdwSysError As Long) As Long ' Declare Function for Open Communication Ethernet
      Declare Function VbCEFOpenUSB Lib "CeFdll.dll" (NamePrint As String, lpdwSysError As Long) As Long ' Declare Function for Open Communication USB
      Declare Function VbCEFWrite Lib "CeFdll.dll" (textcmd As String, lpdwSysError As Long) As Long ' Declare Function for Write Command on Communication Port
      Declare Function VbCEFRead Lib "CeFdll.dll" (RetData() As Byte, pdwByteRead As Long, lpdwSysError As Long) As Long ' Declare Function for Read from Communication Port
   
   'Chiamate per protocollo CUSTOM
      Declare Function VbCEFOpenCustom Lib "CeFdll.dll" (ByVal intCom As Long, ByVal dwBaudRate As Long, ByVal byParity As Byte, ByVal byDataBit As Byte, ByVal byStopBit As Byte, ByVal byFlowControl As Byte, lpdwSysError As Long) As Long
      Declare Function VbCEFOpenEthCustom Lib "CeFdll.dll" (textip As String, ByVal dwPort As Long, lpdwSysError As Long) As Long
      Declare Function VbCEFOpenUSBCustom Lib "CeFdll.dll" (NamePrint As String, lpdwSysError As Long) As Long
      Declare Function VbCEFWriteCustom Lib "CeFdll.dll" (textcmd As String, lpdwSysError As Long) As Long
      Declare Function VbCEFReadCustom Lib "CeFdll.dll" (RetData() As Byte, pdwByteRead As Long, lpdwSysError As Long) As Long
   
   'Chiamate uniche sia per protocollo CUSTOM che CUSTOM DLL
      Declare Function VbCEFGetVersion Lib "CeFdll.dll" (RetData() As Byte, lpdwSysError As Long) As Long ' Declare Function for Read DLL Version
      Declare Function VbCEFClose Lib "CeFdll.dll" (lpdwSysError As Long) As Long ' Declare Function for Close Communication Port
'------------------------------------------------------------------------------------




Public Enum enumFuncCustom
'Codici Comandi richiesta dati
   getdataora = 1001
   getMatricolaFiscale = 1008
   getStatoStampante = 1010
   getModelloRelease = 1013
   getCodiceERR = 1015
   getUltimoScontrino = 1017 'SOLO macchine 3 generazione (per le 2 e 4 generazione uso il 1003)
   getTipoFiscaleSiNo = 1020
   getStatoLogicoRT = 1511
   prnStatoFirmwareRT = 1512
            
   CheckStatus = 1109
   execChiusuraFiscale = 2002 '220201
   execChiusuraPerReparti = 220206
   execApriCassetto = 70081
   execResoAnnullo = 7101
End Enum


Public gCUSTOMCheckInattivita As Boolean

'Public Function CUSTOMFunctionRT(CodiceFunzione As enumFuncCustom, vTipConn As String, vIndirIP As String, _
                                 vNumPort As String, vBaudRat As String, vBitDati As String, _
                                 vParita As String, vBitStop As String, vFlusso As String) As String
Public Function CUSTOMFunctionRT(CodiceFunzione As enumFuncCustom, pShowMsgBox As Boolean, pPathFIleConf As String, _
                                 Optional pParamAnnullo As Byte, Optional vCheckInattivita As Boolean) As String
   ' questa funzione restituisce la risposta attesa dal tegsitratore oppure
    'una stringa vuota se non sono previste risposte e tutto  andato tutto bene
   ' In presenza di un ERRORE resistuisce una stringa che coincia SEMPRE con "ERR"
   
   'If Not gtParam4RegCas.pModalitaRT Then Exit Function
   
   Dim vTipConn As String
   Dim vIndirIP As String
   Dim vNumPort As String
   Dim vBaudRat As String
   Dim vBitDati As String
   Dim vParita As String
   Dim vBitStop As String
   Dim vFlusso As String
   
   Dim vStrRiga As String
   Dim strOut As String
   Dim tmpOut As String
   Dim vTitleMsg As String
   Dim vErrWrite As Boolean
   
   Dim vRet As Long
   Dim vRetA As Long
   Dim vRetErr As Long
   Dim pBytBuffOut(1000) As Byte
  
   Dim vErrTxt As String
   Dim i As Integer
   
   Dim vErrFunc As Boolean
   Dim vAnnulloNonNcessario As Boolean
   
   On Error GoTo GestErr
   
   Call MsgRegCasInLogFile("[CUSTOMFunctionRT] - Start command: " & CodiceFunzione)
   
   
'CONTROLLI SUI VALORI
   'Qui prendo il TIPO CONNESSIONE da passare nel file scontrino
      vTipConn = ReadINI("PARAMETRI", "TIP_CONN", pPathFIleConf)
      If Len(Trim(vTipConn)) = 0 Then
         MsgBox "ATTENZIONE!" & vbNewLine & _
                "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
                "(Tag [PARAMETRI] Parametro <TIP_CONN> non presente)" & vbNewLine & vbNewLine & _
                "Impossibile eseguire la stampa dello Scontrino.", vbCritical
         Exit Function
      End If
      
'QUI CONTROLLO SE DEVO VERIFICARE I PARAMETRI DI RETE E SERIALI E USB
      If vTipConn = "R" Then 'VALORI DI RETE
         
         'Qui prendo l'IP del Registratore
            vIndirIP = ReadINI("RETE", "IP", pPathFIleConf)
            If Len(Trim(vIndirIP)) = 0 Then
               MsgBox "ATTENZIONE!" & vbNewLine & _
                      "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
                      "(Tag [RETE] Parametro <IP> non presente)" & vbNewLine & vbNewLine & _
                      "Impossibile eseguire la stampa dello Scontrino.", vbCritical
               Exit Function
            End If
         'Qui prendo il NUMERO DI PORTA da passare nel file scontrino
            vNumPort = ReadINI("RETE", "PORT", pPathFIleConf)
            If Not IsNumeric(vNumPort) Then
               MsgBox "ATTENZIONE!" & vbNewLine & _
                      "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
                      "(Tag [RETE] Parametro <PORT> non valido)" & vbNewLine & vbNewLine & _
                      "Impossibile eseguire la stampa dello Scontrino.", vbCritical
               Exit Function
            End If
            
'      ElseIf vTipConn = "U" Then 'VALORI PER USB
'         'Qui prendo il Nome della Stampante in caso di stampa tramiteUSB
'            vNomeStampante = ReadINI("USB", "PRINT_NAME", pPathFIleConf)
'            If Len(Trim(vNomeStampante)) = 0 Then
'               MsgBox "ATTENZIONE!" & vbNewLine & _
'                      "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
'                      "(Tag [SERIALE] Parametro <FLUSSO> non valido)" & vbNewLine & vbNewLine & _
'                      "Impossibile eseguire la stampa dello Scontrino.", vbCritical
'               Exit Function
'            End If

         'Se vuoto prendo il tipo di Generazione
            If Len(Trim(gtParam4RegCas.pGenerazioneCustom)) = 0 Then
               gtParam4RegCas.pGenerazioneCustom = ReadINI("PARAMETRI", "GENERAZIONE", pPathFIleConf)
            End If
      
      Else
         'Qui prendo il NUMERO DI PORTA da passare nel file scontrino
            vNumPort = ReadINI("SERIALE", "PORTA_COM", pPathFIleConf)
            If Not IsNumeric(vNumPort) Then
               MsgBox "ATTENZIONE!" & vbNewLine & _
                      "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
                      "(Tag [SERIALE] Parametro <PORTA> non valido)" & vbNewLine & vbNewLine & _
                      "Impossibile eseguire la stampa dello Scontrino.", vbCritical
               Exit Function
            End If
         'Qui prendo il BAUD_RATE
            vBaudRat = ReadINI("SERIALE", "BAUD_RATE", pPathFIleConf)
            If Not IsNumeric(vBaudRat) Then
               MsgBox "ATTENZIONE!" & vbNewLine & _
                      "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
                      "(Tag [SERIALE] Parametro <BAUD_RATE> non valido)" & vbNewLine & vbNewLine & _
                      "Impossibile eseguire la stampa dello Scontrino.", vbCritical
               Exit Function
            End If
         'Qui prendo il BIT_DATI
            vBitDati = ReadINI("SERIALE", "BIT_DATI", pPathFIleConf)
            If Not IsNumeric(vBitDati) Then
               MsgBox "ATTENZIONE!" & vbNewLine & _
                      "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
                      "(Tag [SERIALE] Parametro <BIT_DATI> non valido)" & vbNewLine & vbNewLine & _
                      "Impossibile eseguire la stampa dello Scontrino.", vbCritical
               Exit Function
            End If
         'Qui prendo il PARITA
            vParita = ReadINI("SERIALE", "PARITA", pPathFIleConf)
            If Not IsNumeric(vParita) Then
               MsgBox "ATTENZIONE!" & vbNewLine & _
                      "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
                      "(Tag [SERIALE] Parametro <PARITA> non valido)" & vbNewLine & vbNewLine & _
                      "Impossibile eseguire la stampa dello Scontrino.", vbCritical
               Exit Function
            End If
         'Qui prendo il BIT_STOP
            vBitStop = ReadINI("SERIALE", "BIT_STOP", pPathFIleConf)
            If Not IsNumeric(vBitStop) Then
               MsgBox "ATTENZIONE!" & vbNewLine & _
                      "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
                      "(Tag [SERIALE] Parametro <BIT_STOP> non valido)" & vbNewLine & vbNewLine & _
                      "Impossibile eseguire la stampa dello Scontrino.", vbCritical
               Exit Function
            End If
         'Qui prendo il FLUSSO
            vFlusso = ReadINI("SERIALE", "FLUSSO", pPathFIleConf)
            If Not IsNumeric(vFlusso) Then
               MsgBox "ATTENZIONE!" & vbNewLine & _
                      "Il file di configurazione per la stampa del Registratore di Cassa  incompleto." & vbNewLine & _
                      "(Tag [SERIALE] Parametro <FLUSSO> non valido)" & vbNewLine & vbNewLine & _
                      "Impossibile eseguire la stampa dello Scontrino.", vbCritical
               Exit Function
            End If
      End If
            
  
'===================================================================================================
'QUI INIZIO A COMPORRE LO SCONTRINO  ===============================================================
   ' Open Communication
   If vTipConn = "R" Then 'RETE
      vRet = VbCEFOpenEthCustom(vIndirIP, CLng(vNumPort), vRetErr)
   'ElseIf vTipConn = "U" Then 'USB
   '   vRet = VbCEFOpenUSBCustom(vNomeStampante, vRetErr)
   Else 'SERIALE
      vRet = VbCEFOpenCustom(CLng(vNumPort), CLng(vBaudRat), CByte(vParita), CByte(vBitDati), CByte(vBitStop), CByte(vFlusso), CLng(vRetErr))
   End If
   
' Check Init
   If (vRet <> 0) Then
      vErrTxt = "ERRORE di comunicazione nr. " & vRet & vbNewLine & vbNewLine & DecodErrorCustom(vRet)
      Call MsgRegCasInLogFile("[CUSTOMFunctionRT] - " & vErrTxt, True)
      MsgBox vErrTxt, msg_Critical, vTitleMsg
      CUSTOMFunctionRT = vErrTxt
      Exit Function
   End If
   
   
   vAnnulloNonNcessario = ((CodiceFunzione = execApriCassetto) Or (CodiceFunzione = getUltimoScontrino))
   
   
'INTEGRAZIONE CHIAMATA
   Select Case CodiceFunzione
      Case execResoAnnullo
         vStrRiga = CodiceFunzione & IIf(gtParam4RegCas.pEseguiReso, "R", "A") & _
                    gtParam4RegCas.pResAnnNumDoc1 & gtParam4RegCas.pResAnnNumDoc2 & _
                    Format(gtParam4RegCas.pResAnnDatDoc, "ddmmyy") & IIf(gtParam4RegCas.pEseguiAnnullo, pParamAnnullo, IIf(gtParam4RegCas.pGenerazioneCustom = "III", "", "0"))
         'If pParamAnnullo = 1 Then vAnnulloNonNcessario = True
      Case Else
      '1003
         If (CodiceFunzione = getUltimoScontrino) And (gtParam4RegCas.pGenerazioneCustom <> "III") Then
            vStrRiga = 1003 'Uso il 1017 per le macchine 3 generazione mentre per le 2 e 4 generazione uso il 1003
         Else
            vStrRiga = CodiceFunzione 'CodiceFunzione Default (cos come arriva!)
         End If
   End Select
   
   

'ESECUZIONE CHIAMATA
   If Not fCustomWrite(vStrRiga, vAnnulloNonNcessario) Then vErrWrite = True: GoTo ChiusuraForzata
   vRet = VbCEFReadCustom(pBytBuffOut(), vRetA, vRetErr)
   
   
   
'RISPOSTA
   Select Case CodiceFunzione
      Case execResoAnnullo
         For i = 9 To vRetA - 3
            tmpOut = tmpOut + String(1, pBytBuffOut(i))
         Next i
         
         If Len(Trim(tmpOut)) > 0 Then
            Select Case Mid(tmpOut, 1, 1)
               Case "0"
                  strOut = "ERR. - Documento non trovato nel Registratore." & vbNewLine & _
                           "Operazione di " & IIf(gtParam4RegCas.pEseguiReso, "Reso", "Annullo") & " terminata"
                  vErrFunc = True
               Case "1": strOut = ""
               Case "2"
                  strOut = "ERR. - Operazione di " & IIf(gtParam4RegCas.pEseguiReso, "Reso", "Annullo") & " non consentita"
                  vErrFunc = True
            End Select
         End If
         If Len(Trim(strOut)) > 0 Then
            Call MsgRegCasInLogFile("[CUSTOMFunctionRT] - execResoAnnullo risposta: '" & strOut & "'", True)
         End If
         
   
      Case getdataora
         strOut = "Data: "
         strOut = strOut + String(1, pBytBuffOut(9)) + String(1, pBytBuffOut(10)) + "/"
         strOut = strOut + String(1, pBytBuffOut(11)) + String(1, pBytBuffOut(12)) + "/"
         strOut = strOut + String(1, pBytBuffOut(13)) + String(1, pBytBuffOut(14)) + "  -  Ore: "
         strOut = strOut + String(1, pBytBuffOut(15)) + String(1, pBytBuffOut(16)) + ":"
         strOut = strOut + String(1, pBytBuffOut(17)) + String(1, pBytBuffOut(18))

      Case getStatoLogicoRT
         'vTitleMsg = "LETTURA 'STATO LOGICO RT'"
         strOut = " - LETTURA 'STATO LOGICO RT' - " & vbNewLine
         For i = 9 To vRetA - 3
            tmpOut = tmpOut + String(1, pBytBuffOut(i))
         Next i
         
         If Len(Trim(tmpOut)) > 0 Then
            If vCheckInattivita = False Then
               strOut = strOut & "SERIALE RT: " & IIf(Mid(tmpOut, 1, 1) = "1", "SI", "NO") & vbNewLine
               strOut = strOut & "MATRICOLA RT: " & Mid(tmpOut, 2, 11) & vbNewLine
               'strOut = strOut & "MATRICOLA 83: " & Mid(tmpOut, 13, 10) & vbNewLine
               strOut = strOut & "CHIAVE GENERATA: " & IIf(Mid(tmpOut, 23, 1) = "1", "SI", "NO") & vbNewLine
               strOut = strOut & "CENSIMENTO: " & IIf(Mid(tmpOut, 24, 1) = "1", "SI", "NO") & vbNewLine
               strOut = strOut & "ATTIVAZIONE: " & IIf(Mid(tmpOut, 25, 1) = "1", "SI", "NO") & vbNewLine
               strOut = strOut & "IN SERVIZIO: " & IIf(Mid(tmpOut, 26, 1) = "1", "SI", "NO") & vbNewLine
               strOut = strOut & "DATA MESSA IN SERV: " & Mid(tmpOut, 27, 6) & vbNewLine
               strOut = strOut & "PERIODO INATTIVITA': " & IIf(Mid(tmpOut, 37, 1) = "1", "NON ATTIVO (necessaria Chius. Fisc.)", "ATTIVO")
            Else
               If Mid(tmpOut, 37, 1) = "1" Then
                  strOut = "ERR. - Periodo di inattivit troppo lungo." & vbNewLine & _
                           "E' necessario eseguire una 'Chiusura Fiscale'"
                  vErrFunc = True
               Else
                  gCUSTOMCheckInattivita = True
                  pShowMsgBox = False 'non serve mostrare alcun Messaggio
               End If
            End If
         End If
      
      
      Case getUltimoScontrino
         'vTitleMsg = "LETTURA 'STATO LOGICO RT'"
         'strOut = " - LETTURA 'STATO LOGICO RT' - " & vbNewLine
         For i = 9 To vRetA - 3
            tmpOut = tmpOut + String(1, pBytBuffOut(i))
         Next i
         
         If gtParam4RegCas.pGenerazioneCustom = "III" Then
            If Len(Trim(tmpOut)) > 0 Then
               strOut = "Result=" & IIf(Mid(tmpOut, 25, 1) = "0", "Ok", "Ko") & "|"
               strOut = strOut & "Time=" & Mid(tmpOut, 1, 2) & "/" & Mid(tmpOut, 3, 2) & "/" & Mid(tmpOut, 5, 2)
                        strOut = strOut & " " & Mid(tmpOut, 7, 2) & ":" & Mid(tmpOut, 9, 2) & ":00" & "|"
               strOut = strOut & "ReceiptNum=" & CInt(Mid(tmpOut, 11, 4)) & "|"
               strOut = strOut & "Total=" & CCur(Mid(tmpOut, 15, 7) & "," & Mid(tmpOut, 22, 2)) & "|"
               Select Case Mid(tmpOut, 24, 1)
                  Case "0": strOut = strOut & "TypeDoc=non fiscale"
                  Case "1": strOut = strOut & "TypeDoc=fiscale"
                  Case "2": strOut = strOut & "TypeDoc=fattura"
                  Case "3": strOut = strOut & "TypeDoc=nota credito"
               End Select
               gtLastScontrino.EsitoPerDB = strOut
               gtLastScontrino.ProgFiscale = CInt(Mid(tmpOut, 11, 4))
               gtLastScontrino.StringaEsito = strOut
            End If
         Else
            If Len(Trim(tmpOut)) > 0 Then
               strOut = "Result=?|"
               strOut = strOut & "Time=?|"
               strOut = strOut & "ReceiptNum=" & CInt(Mid(tmpOut, 57, 4)) & "|"
               strOut = strOut & "Total=?|"
               strOut = strOut & "TypeDoc=?"
               
               gtLastScontrino.EsitoPerDB = strOut
               gtLastScontrino.ProgFiscale = CInt(Mid(tmpOut, 57, 4))
               gtLastScontrino.StringaEsito = strOut
            End If
         End If
                  
         Call MsgRegCasInLogFile("[CUSTOMFunctionRT] - getUltimoScontrino: '" & gtLastScontrino.StringaEsito & "'", (Mid(tmpOut, 25, 1) <> "0"))
         
         
      Case CheckStatus
         For i = 9 To vRetA - 3
            tmpOut = tmpOut + String(1, pBytBuffOut(i))
         Next i
         
         If Len(Trim(tmpOut)) > 0 Then
            'If InStr(1, tmpOut, "1") > 0 Then
            If Mid(tmpOut, 1, 1) = "1" Then
               strOut = "ERR. - Verificare apertura coperchio Registratore"
               vErrFunc = True
            ElseIf Mid(tmpOut, 2, 1) = "1" Then
               strOut = "ERR. - Verificare carta nel Registratore"
               vErrFunc = True
            'ElseIf Mid(tmpOut, 3, 1) = "1" Then
            '   strOut = "AVVISO - La carta nel Registratore sta per terminare. Si consiglia di sostituire il rotolo il prima possibile"
            '   'vErrFunc = True
            
               'NOTA: ABBIAMO DOVUTO ESCLUDERE IL CONTROLLO DI "QUASI FINE CARTA" PERCH FACENDO DEI TEST
               '      L'AVVISO COMPARE GIA' QUANDO IL ROTOLO HA ANCORA 2cm DI CARTA, CHE SIGNIFICA ALMENO
               '      UN CENTINAIO DI SCONTRINI!!!
            Else
               strOut = ""
            End If
            'se  tutto mOK non restituisco nulla (struinga vuota)
         Else
            strOut = "ERR. - Comunicazione col Registratore assente" & vbNewLine & _
                               "Verificare che sia acceso e visibile in Rete"
            vErrFunc = True
         End If
      
      
   End Select
   
   
ChiusuraForzata:
   If vErrWrite Then
      strOut = "ERR. in fCustomWrite"
      pShowMsgBox = False
   End If
   
   
   CUSTOMFunctionRT = strOut
   
   
   ' Close Communication on Com Port
   vRet = VbCEFClose(vRetErr)
   Call MsgRegCasInLogFile("[CUSTOMFunctionRT] - End command: " & CodiceFunzione)
      
   
   If pShowMsgBox And Len(Trim(strOut)) > 0 Then
      MsgBox strOut, IIf(vErrFunc, msg_Critical, msg_Information), vTitleMsg
   End If


GestErr:
   If err.Number <> 0 Then
      vErrTxt = err.Number & " - " & err.Description
      MsgBox vErrTxt, msg_Critical, vTitleMsg
      CUSTOMFunctionRT = "ERR." & vErrTxt
      Call MsgRegCasInLogFile("[CUSTOMFunctionRT] - ERR." & vErrTxt, True)
   End If
   On Error GoTo 0
End Function



'Public Function CustomOpenConn(pRegCasRT As Boolean, _
'                               Optional vTipConn As String, Optional vApriCas As String, Optional vIndirIP As String, _
'                               Optional vNumPort As String, Optional vBaudRat As String, Optional vBitDati As String, _
'                               Optional vParita As String, Optional vBitStop As String, Optional vFlusso As String, _
'                               Optional vNomeStampante As String) As Long
'   Dim vRet As Long
'   If vTipConn = "R" Then 'RETE
'      If pRegCasRT Then
'         vRet = VbCEFOpenEthCustom(vIndirIP, CLng(vNumPort), vRetErr)
'      Else
'         vRet = VbCEFOpenEth(vIndirIP, CLng(vNumPort), vRetErr)
'      End If
'
'   ElseIf vTipConn = "U" Then 'USB
'      If pRegCasRT Then
'         vRet = VbCEFOpenUSBCustom(vNomeStampante, vRetErr)
'      Else
'         vRet = VbCEFOpenUSB(vNomeStampante, vRetErr)
'      End If
'
'   Else 'SERIALE
'      If pRegCasRT Then
'         vRet = VbCEFOpenCustom(CLng(vNumPort), CLng(vBaudRat), CByte(vParita), CByte(vBitDati), CByte(vBitStop), CByte(vFlusso), CLng(vRetErr))
'      Else
'         vRet = VbCEFOpen(CLng(vNumPort), CLng(vBaudRat), CByte(vParita), CByte(vBitDati), CByte(vBitStop), CByte(vFlusso), CLng(vRetErr))
'      End If
'   End If
'   CustomOpenConn = vRet
'End Function

Public Function CUSTOMGetVatTable(vTipConn As String, vIndirIP As String, _
                                  vNumPort As String, vBaudRat As String, vBitDati As String, _
                                  vParita As String, vBitStop As String, vFlusso As String) As String
   
   Dim vStrRiga As String
   Dim strOut As String
   Dim tmpOut As String
   
   Dim vRet As Long
   Dim vRetA As Long
   Dim vRetErr As Long
   Dim pBytBuffOut(1000) As Byte
  
   On Error GoTo GestErr
  
'===================================================================================================
'QUI INIZIO A COMPORRE LO SCONTRINO  ===============================================================
   ' Open Communication
   If vTipConn = "R" Then 'RETE
      vRet = VbCEFOpenEthCustom(vIndirIP, CLng(vNumPort), vRetErr)
   'ElseIf vTipConn = "U" Then 'USB
   '   vRet = VbCEFOpenUSB(vNomeStampante, vRetErr)
   Else 'SERIALE
      vRet = VbCEFOpenCustom(CLng(vNumPort), CLng(vBaudRat), CByte(vParita), CByte(vBitDati), CByte(vBitStop), CByte(vFlusso), CLng(vRetErr))
   End If
   
   ' Check Init
   If (vRet <> 0) Then
      MsgBox "ERRORE!" & vbNewLine & _
             "Errore di comunicazione nr. " & vRet, msg_Critical
      Exit Function
   End If
   
   
      ' Get Aliquota IVA
      vStrRiga = "7012"
      vRet = VbCEFWriteCustom(vStrRiga, vRetErr)
      vRet = VbCEFReadCustom(pBytBuffOut(), vRetA, vRetErr)
      
      
      Dim vMsg As String
      Dim vAliIva As String
      Dim i As Integer
      Dim iRow As Byte
      
      'Leggo la prime 3 righe e cerco o "Result=Ok" oppure "Result=Ko"
      
         For i = 9 To vRetA - 3
            tmpOut = tmpOut + String(1, pBytBuffOut(i))
         Next i
         
         If Len(Trim(tmpOut)) > 0 Then
            strOut = "Codice IVA 01: " & Mid(tmpOut, 1, 2) & "," & Mid(tmpOut, 3, 2) & vbNewLine
            strOut = strOut & "Codice IVA 02: " & Mid(tmpOut, 5, 2) & "," & Mid(tmpOut, 7, 2) & vbNewLine
            strOut = strOut & "Codice IVA 03: " & Mid(tmpOut, 9, 2) & "," & Mid(tmpOut, 11, 2) & vbNewLine
            strOut = strOut & "Codice IVA 04: " & Mid(tmpOut, 13, 2) & "," & Mid(tmpOut, 15, 2) & vbNewLine
            strOut = strOut & "Codice IVA 05: " & Mid(tmpOut, 17, 2) & "," & Mid(tmpOut, 19, 2) & vbNewLine & vbNewLine
            strOut = strOut & "  - - - ESENZIONI FISSE - - -" & vbNewLine
            strOut = strOut & "Codice IVA 06: IVA Esente" & vbNewLine
            strOut = strOut & "Codice IVA 07: Esclusa" & vbNewLine
            strOut = strOut & "Codice IVA 08: Non soggetta IVA" & vbNewLine
            strOut = strOut & "Codice IVA 09: Non imponibile" & vbNewLine
            strOut = strOut & "Codice IVA 10: Regime del margine" & vbNewLine
            strOut = strOut & "Codice IVA 11: Operazione non IVA"
         End If
      
      CUSTOMGetVatTable = strOut
   
   ' Close Communication on Com Port
   vRet = VbCEFClose(vRetErr)
      
      
   MsgBox strOut, msg_Information, "Aliquote IVA presenti nel Registratore"
   

GestErr:
   If err.Number <> 0 Then
      MsgBox "ERRORE!" & vbNewLine & _
             err.Number & " - " & err.Description, msg_Critical
             
   End If
   On Error GoTo 0
End Function


Public Function CUSTOMSetVatTable(vTipConn As String, vIndirIP As String, _
                                  vNumPort As String, vBaudRat As String, vBitDati As String, _
                                  vParita As String, vBitStop As String, vFlusso As String, _
                                  pGenerazione As String) As Long
   
   Dim vStrRiga As String
   Dim strOut As String
   Dim tmpOut As String
   Dim i As Integer
   
   Dim vRet As Long
   Dim vRetA As Long
   Dim vRetErr As Long
   Dim pBytBuffOut(1000) As Byte
  
   On Error GoTo GestErr
  
'===================================================================================================
'QUI INIZIO A COMPORRE LO SCONTRINO  ===============================================================
   ' Open Communication
   If vTipConn = "R" Then 'RETE
      vRet = VbCEFOpenEthCustom(vIndirIP, CLng(vNumPort), vRetErr)
   'ElseIf vTipConn = "U" Then 'USB
   '   vRet = VbCEFOpenUSB(vNomeStampante, vRetErr)
   Else 'SERIALE
      vRet = VbCEFOpenCustom(CLng(vNumPort), CLng(vBaudRat), CByte(vParita), CByte(vBitDati), CByte(vBitStop), CByte(vFlusso), CLng(vRetErr))
   End If
   
   ' Check Init
   If (vRet <> 0) Then
      MsgBox "ERRORE!" & vbNewLine & _
             "Errore di comunicazione nr. " & vRet, msg_Critical
      vRet = VbCEFClose(vRetErr)
      Exit Function
   End If
   
   
   If pGenerazione = "III" Then
   
      ' Get Aliquota IVA
      vStrRiga = "7013"
      vStrRiga = vStrRiga & "2200" 'Codice 01 - VAT Rate A
      vStrRiga = vStrRiga & "1000" 'Codice 02 - VAT Rate B
      vStrRiga = vStrRiga & "0400" 'Codice 03 - VAT Rate C
      vStrRiga = vStrRiga & "0000" 'Codice 04 - VAT Rate D
      vStrRiga = vStrRiga & "0000" 'Codice 05 - VAT Rate E
      'vStrRiga = vStrRiga & "0000" 'Codice 06 - VAT Rate F
      vRet = VbCEFWriteCustom(vStrRiga, vRetErr)
      'vRet = VbCEFReadCustom(pBytBuffOut(), vRetA, vRetErr)
      
      'Debug.Print vRetErr
      
      If vRet <> 0 Then
         Select Case vRet
            Case 54
               strOut = "SI RICHIEDE LA CHIUSURA FISCALE e AZZERAMENTO TOTALIZZATORI IVA PERIODO (Comando Z51)"
               CUSTOMSetVatTable = execChiusuraPerReparti
            Case 3
               strOut = "SI RICHIEDE AZZERAMENTO TOTALIZZATORI IVA PERIODO"
               CUSTOMSetVatTable = execChiusuraPerReparti
            Case Else
               strOut = "AZIONE NON CONSENTITA (Errore: " & vRet & ")"
         End Select
         MsgBox "Errore in fase di configurazione Aliquote IVA" & vbNewLine & vbNewLine & _
                strOut, msg_Critical
'         vRet = VbCEFWriteCustom("1015", vRetErr) 'Lettura ERRORE
'         vRet = VbCEFReadCustom(pBytBuffOut(), vRetA, vRetErr)
'         For i = 0 To vRetA
'            strOut = strOut + String(1, pBytBuffOut(i))
'         Next i
      End If

   
   Else

      Dim vDesc As String
      Dim vExit As Boolean
      
      For i = 1 To 3 '5
         vExit = False
         
         'Set Aliquota IVA 'EX 7013 modificato per le II e IV generazione
         vStrRiga = "7113"
         vStrRiga = vStrRiga & "0" & Trim(Str(i))
         Select Case i
            Case 1: vStrRiga = vStrRiga & "2300": vDesc = "01" 'il BigIII non accetta un solo carattere anche se poi, se si verifica da registratore (1159 + FUN.) mostra come descrizione solo il secondo carattere
            Case 2: vStrRiga = vStrRiga & "1100": vDesc = "02"
            Case 3: vStrRiga = vStrRiga & "0500": vDesc = "03"
            'Case 4: vStrRiga = vStrRiga & "0000": vDesc = "04"
            'Case 5: vStrRiga = vStrRiga & "0000": vDesc = "05"
         End Select
         vStrRiga = vStrRiga & "0" 'Codice esente (da 1 a 6)
         vStrRiga = vStrRiga & Len(vDesc)
         vStrRiga = vStrRiga & vDesc
         
         vRet = VbCEFWriteCustom(vStrRiga, vRetErr)
         
         If vRet <> 0 Then
            Select Case vRet
               Case 54: strOut = "SI RICHIEDE LA CHIUSURA FISCALE e AZZERAMENTO TOTALIZZATORI IVA PERIODO (Comando Z51)": vExit = True
               Case 3: strOut = "SI RICHIEDE AZZERAMENTO TOTALIZZATORI IVA PERIODO (Comando Z51)": vExit = True
               Case Else
                  strOut = "AZIONE NON CONSENTITA (Errore: " & vRet & ")"
            End Select
            MsgBox "Errore in fase di configurazione Aliquote IVA " & "0" & Trim(Str(i)) & vbNewLine & vbNewLine & _
                   strOut, msg_Critical
            
            If vExit Then Exit For
         End If
      Next i
   
   
      MsgBox "Procedura terminata." & vbNewLine & _
             "Si consiglia di spegnere e riaccendere il Registratore", msg_Information
      
   End If
   
      
   ' Close Communication on Com Port
   vRet = VbCEFClose(vRetErr)
   

GestErr:
   If err.Number <> 0 Then
      MsgBox "ERRORE!" & vbNewLine & _
             err.Number & " - " & err.Description, msg_Critical
             
   End If
   On Error GoTo 0

End Function

Public Function CUSTOMGetReparti(vTipConn As String, vIndirIP As String, _
                                 vNumPort As String, vBaudRat As String, vBitDati As String, _
                                 vParita As String, vBitStop As String, vFlusso As String) As String
   
   
   'DA QUESTO COMANDO NON SI OTTIENE IL DETTAGLIO DEI REPARTI, MA SEMPLICEMENTE LA STAMPA DEI REPARTI _
    MOVIMENTATI CHE, DOPO LA CHIUSURA, DIVENTA VUOTA!!! _
    IN PRATICA NON SERVE A NULLA
   
   
   Dim vStrRiga As String
   Dim strOut As String
   Dim tmpOut As String
   
   Dim vRet As Long
   Dim vRetA As Long
   Dim vRetErr As Long
   Dim pBytBuffOut(1000) As Byte
  
   On Error GoTo GestErr
  
'===================================================================================================
'QUI INIZIO A COMPORRE LO SCONTRINO  ===============================================================
   ' Open Communication
   If vTipConn = "R" Then 'RETE
      vRet = VbCEFOpenEthCustom(vIndirIP, CLng(vNumPort), vRetErr)
   'ElseIf vTipConn = "U" Then 'USB
   '   vRet = VbCEFOpenUSB(vNomeStampante, vRetErr)
   Else 'SERIALE
      vRet = VbCEFOpenCustom(CLng(vNumPort), CLng(vBaudRat), CByte(vParita), CByte(vBitDati), CByte(vBitStop), CByte(vFlusso), CLng(vRetErr))
   End If
   
   ' Check Init
   If (vRet <> 0) Then
      MsgBox "ERRORE!" & vbNewLine & _
             "Errore di comunicazione nr. " & vRet, msg_Critical
      Exit Function
   End If
   
   
      ' Get Aliquota IVA
      vStrRiga = "2103"
      vRet = VbCEFWriteCustom(vStrRiga, vRetErr)
      vRet = VbCEFReadCustom(pBytBuffOut(), vRetA, vRetErr)
      
      
      Dim vMsg As String
      Dim vAliIva As String
      Dim i As Integer
      Dim iRow As Byte
      
      'Leggo la prime 3 righe e cerco o "Result=Ok" oppure "Result=Ko"
      
         For i = 9 To vRetA - 3
            tmpOut = tmpOut + String(1, pBytBuffOut(i))
         Next i
         
         If Len(Trim(tmpOut)) > 0 Then
            strOut = "Codice IVA 01: " & Mid(tmpOut, 1, 2) & "," & Mid(tmpOut, 3, 2) & vbNewLine
            strOut = strOut & "Codice IVA 02: " & Mid(tmpOut, 5, 2) & "," & Mid(tmpOut, 7, 2) & vbNewLine
            strOut = strOut & "Codice IVA 03: " & Mid(tmpOut, 9, 2) & "," & Mid(tmpOut, 11, 2) & vbNewLine
            strOut = strOut & "Codice IVA 04: " & Mid(tmpOut, 13, 2) & "," & Mid(tmpOut, 15, 2) & vbNewLine
            strOut = strOut & "Codice IVA 05: " & Mid(tmpOut, 17, 2) & "," & Mid(tmpOut, 19, 2) & vbNewLine & vbNewLine
            strOut = strOut & "  - - - ESENZIONI FISSE - - -" & vbNewLine
            strOut = strOut & "Codice IVA 06: IVA Esente" & vbNewLine
            strOut = strOut & "Codice IVA 07: Esclusa" & vbNewLine
            strOut = strOut & "Codice IVA 08: Non soggetta IVA" & vbNewLine
            strOut = strOut & "Codice IVA 09: Non imponibile" & vbNewLine
            strOut = strOut & "Codice IVA 10: Regime del margine" & vbNewLine
            strOut = strOut & "Codice IVA 11: Operazione non IVA"
         End If
      
      CUSTOMGetReparti = strOut
   
   ' Close Communication on Com Port
   vRet = VbCEFClose(vRetErr)
      
      
   MsgBox strOut, msg_Information, "Aliquote IVA presenti nel Registratore"
   

GestErr:
   If err.Number <> 0 Then
      MsgBox "ERRORE!" & vbNewLine & _
             err.Number & " - " & err.Description, msg_Critical
             
   End If
   On Error GoTo 0
End Function


Public Function CUSTOMSetRepartiTable(vTipConn As String, vIndirIP As String, _
                                      vNumPort As String, vBaudRat As String, vBitDati As String, _
                                      vParita As String, vBitStop As String, vFlusso As String) ', _
                                      pGenerazione As String, vArrRep() As String) As String
   
   Dim vStrRiga As String
   Dim strOut As String
   Dim tmpOut As String
   Dim i As Integer
   
   Dim vRet As Long
   Dim vRetA As Long
   Dim vRetErr As Long
   Dim pBytBuffOut(1000) As Byte
  
   On Error GoTo GestErr
  
'===================================================================================================
'QUI INIZIO A COMPORRE LO SCONTRINO  ===============================================================
   ' Open Communication
   If vTipConn = "R" Then 'RETE
      vRet = VbCEFOpenEthCustom(vIndirIP, CLng(vNumPort), vRetErr)
   'ElseIf vTipConn = "U" Then 'USB
   '   vRet = VbCEFOpenUSB(vNomeStampante, vRetErr)
   Else 'SERIALE
      vRet = VbCEFOpenCustom(CLng(vNumPort), CLng(vBaudRat), CByte(vParita), CByte(vBitDati), CByte(vBitStop), CByte(vFlusso), CLng(vRetErr))
   End If
   
   ' Check Init
   If (vRet <> 0) Then
      MsgBox "ERRORE!" & vbNewLine & _
             "Errore di comunicazione nr. " & vRet, msg_Critical
      vRet = VbCEFClose(vRetErr)
      Exit Function
   End If
                        

'REPARTI SU ALIQUOTE STANDARD
         vStrRiga = "7009"
         vStrRiga = vStrRiga & "01" 'Numero Reparto
            vStrRiga = vStrRiga & "16" 'Lunghezza descrizione
            vStrRiga = vStrRiga & "R01 Serv. IVA 22" 'descrizione
            vStrRiga = vStrRiga & "00000" 'prezzo programmato
            'If pGenerazione = "III" Then
               vStrRiga = vStrRiga & "01" 'Codice aliquota reparto
            'Else
            '   vStrRiga = vStrRiga & vArrRep(0) 'Valore aliquota IVA reparto
            'End If
         vRet = VbCEFWriteCustom(vStrRiga, vRetErr)
         If vRet <> 0 Then GoTo ErrWrite
      
         vStrRiga = "7009"
         vStrRiga = vStrRiga & "02" 'Numero Reparto
            vStrRiga = vStrRiga & "16" 'Lunghezza descrizione
            vStrRiga = vStrRiga & "R02 Art.  IVA 22" 'descrizione
            vStrRiga = vStrRiga & "00000" 'prezzo programmato
            'If pGenerazione = "III" Then
               vStrRiga = vStrRiga & "01" 'Codice aliquota reparto
            'Else
            '   vStrRiga = vStrRiga & vArrRep(1) 'Valore aliquota IVA reparto
            'End If
         vRet = VbCEFWriteCustom(vStrRiga, vRetErr)
         If vRet <> 0 Then GoTo ErrWrite
         
         vStrRiga = "7009"
         vStrRiga = vStrRiga & "03" 'Numero Reparto
            vStrRiga = vStrRiga & "16" 'Lunghezza descrizione
            vStrRiga = vStrRiga & "R03 Serv. IVA 10" 'descrizione
            vStrRiga = vStrRiga & "00000" 'prezzo programmato
            'If pGenerazione = "III" Then
               vStrRiga = vStrRiga & "02" 'Codice aliquota reparto
            'Else
            '   vStrRiga = vStrRiga & vArrRep(2) 'Valore aliquota IVA reparto
            'End If
         vRet = VbCEFWriteCustom(vStrRiga, vRetErr)
         If vRet <> 0 Then GoTo ErrWrite
         
         vStrRiga = "7009"
         vStrRiga = vStrRiga & "04" 'Numero Reparto
            vStrRiga = vStrRiga & "16" 'Lunghezza descrizione
            vStrRiga = vStrRiga & "R04 Art.  IVA 10" 'descrizione
            vStrRiga = vStrRiga & "00000" 'prezzo programmato
            'If pGenerazione = "III" Then
               vStrRiga = vStrRiga & "02" 'Codice aliquota reparto
            'Else
            '   vStrRiga = vStrRiga & vArrRep(3) 'Valore aliquota IVA reparto
            'End If
         vRet = VbCEFWriteCustom(vStrRiga, vRetErr)
         If vRet <> 0 Then GoTo ErrWrite
         
         vStrRiga = "7009"
         vStrRiga = vStrRiga & "05" 'Numero Reparto
            vStrRiga = vStrRiga & "16" 'Lunghezza descrizione
            vStrRiga = vStrRiga & "R05 Serv. IVA 04" 'descrizione
            vStrRiga = vStrRiga & "00000" 'prezzo programmato
            'If pGenerazione = "III" Then
               vStrRiga = vStrRiga & "03" 'Codice aliquota reparto
            'Else
            '   vStrRiga = vStrRiga & vArrRep(4) 'Valore aliquota IVA reparto
            'End If
         vRet = VbCEFWriteCustom(vStrRiga, vRetErr)
         If vRet <> 0 Then GoTo ErrWrite
      
         vStrRiga = "7009"
         vStrRiga = vStrRiga & "06" 'Numero Reparto
            vStrRiga = vStrRiga & "16" 'Lunghezza descrizione
            vStrRiga = vStrRiga & "R06 Art.  IVA 04" 'descrizione
            vStrRiga = vStrRiga & "00000" 'prezzo programmato
            'If pGenerazione = "III" Then
               vStrRiga = vStrRiga & "03" 'Codice aliquota reparto
            'Else
            '   vStrRiga = vStrRiga & vArrRep(5) 'Valore aliquota IVA reparto
            'End If
         vRet = VbCEFWriteCustom(vStrRiga, vRetErr)
         If vRet <> 0 Then GoTo ErrWrite
         
'ESENZIONI
         vStrRiga = "7009"
         vStrRiga = vStrRiga & "07" 'Numero Reparto
            vStrRiga = vStrRiga & "14" 'Lunghezza descrizione
            vStrRiga = vStrRiga & "R07 IVA Esente" 'descrizione
            vStrRiga = vStrRiga & "00000" 'prezzo programmato
            'If pGenerazione = "III" Then
               vStrRiga = vStrRiga & "06" 'Codice aliquota reparto
            'Else
            '   vStrRiga = vStrRiga & vArrRep(6) 'Valore aliquota IVA reparto
            'End If
         vRet = VbCEFWriteCustom(vStrRiga, vRetErr)
         If vRet <> 0 Then GoTo ErrWrite
         
         vStrRiga = "7009"
         vStrRiga = vStrRiga & "08" 'Numero Reparto
            vStrRiga = vStrRiga & "11" 'Lunghezza descrizione
            vStrRiga = vStrRiga & "R08 Esclusa" 'descrizione
            vStrRiga = vStrRiga & "00000" 'prezzo programmato
            'If pGenerazione = "III" Then
               vStrRiga = vStrRiga & "07" 'Codice aliquota reparto
            'Else
            '   vStrRiga = vStrRiga & vArrRep(7) 'Valore aliquota IVA reparto
            'End If
         vRet = VbCEFWriteCustom(vStrRiga, vRetErr)
         If vRet <> 0 Then GoTo ErrWrite
         
         vStrRiga = "7009"
         vStrRiga = vStrRiga & "09" 'Numero Reparto
            vStrRiga = vStrRiga & "16" 'Lunghezza descrizione
            vStrRiga = vStrRiga & "R09 Non sogg.IVA" 'descrizione
            vStrRiga = vStrRiga & "00000" 'prezzo programmato
            'If pGenerazione = "III" Then
               vStrRiga = vStrRiga & "08" 'Codice aliquota reparto
            'Else
            '   vStrRiga = vStrRiga & vArrRep(8) 'Valore aliquota IVA reparto
            'End If
         vRet = VbCEFWriteCustom(vStrRiga, vRetErr)
         If vRet <> 0 Then GoTo ErrWrite
         
         vStrRiga = "7009"
         vStrRiga = vStrRiga & "10" 'Numero Reparto
            vStrRiga = vStrRiga & "16" 'Lunghezza descrizione
            vStrRiga = vStrRiga & "R10 Non Imponib." 'descrizione
            vStrRiga = vStrRiga & "00000" 'prezzo programmato
            'If pGenerazione = "III" Then
               vStrRiga = vStrRiga & "09" 'Codice aliquota reparto
            'Else
            '   vStrRiga = vStrRiga & vArrRep(9) 'Valore aliquota IVA reparto
            'End If
         vRet = VbCEFWriteCustom(vStrRiga, vRetErr)
         If vRet <> 0 Then GoTo ErrWrite
         
         vStrRiga = "7009"
         vStrRiga = vStrRiga & "11" 'Numero Reparto
            vStrRiga = vStrRiga & "16" 'Lunghezza descrizione
            vStrRiga = vStrRiga & "R11 Regime marg." 'descrizione
            vStrRiga = vStrRiga & "00000" 'prezzo programmato
            'If pGenerazione = "III" Then
               vStrRiga = vStrRiga & "10" 'Codice aliquota reparto
            'Else
            '   vStrRiga = vStrRiga & vArrRep(10) 'Valore aliquota IVA reparto
            'End If
         vRet = VbCEFWriteCustom(vStrRiga, vRetErr)
         If vRet <> 0 Then GoTo ErrWrite
         
         vStrRiga = "7009"
         vStrRiga = vStrRiga & "12" 'Numero Reparto
            vStrRiga = vStrRiga & "15" 'Lunghezza descrizione
            vStrRiga = vStrRiga & "R12 Op. non IVA" 'descrizione
            vStrRiga = vStrRiga & "00000" 'prezzo programmato
            'If pGenerazione = "III" Then
               vStrRiga = vStrRiga & "11" 'Codice aliquota reparto
            'Else
            '   vStrRiga = vStrRiga & vArrRep(11) 'Valore aliquota IVA reparto
            'End If
         vRet = VbCEFWriteCustom(vStrRiga, vRetErr)
      
ErrWrite:
      If vRet <> 0 Then
         Select Case vRet
            Case 54: strOut = "SI RICHIEDE LA CHIUSURA FISCALE e AZZERAMENTO TOTALIZZATORI IVA PERIODO"
            Case 3: strOut = "SI RICHIEDE AZZERAMENTO TOTALIZZATORI IVA PERIODO"
            Case Else
               strOut = "AZIONE NON CONSENTITA (Errore: " & vRet & ")"
         End Select
         MsgBox "Errore in fase di configurazione Reparti" & vbNewLine & vbNewLine & _
                strOut, msg_Critical
      End If
      
      
   ' Close Communication on Com Port
   vRet = VbCEFClose(vRetErr)
   
   
   MsgBox "Operazione terminata senza errori." & vbNewLine & vbNewLine & _
          "Per ottenere una stampa dettagliata dei reparti, eseguire il comando '100' dal menu Programmazione del Registratore Telematico", msg_Information
   

GestErr:
   If err.Number <> 0 Then
      MsgBox "ERRORE!" & vbNewLine & _
             err.Number & " - " & err.Description, msg_Critical
             
   End If
   On Error GoTo 0

End Function


'Private Function GetValIVAPerReparto(CodReparto) As String
'   'SOSPESO PER IL MOMENTO --- MI SEMBRA UN PO' UN AZZARDO E NON SONO SICURO CHE FUNZIONI IN TUTTE LE CASISTICHE _
'    PERTANTO PER LE II E IV GENERAZIONI IL SETTAGGIO VA FATTO A MANO
'
'   Dim rs As ADODB.Recordset
'   Dim strRicerca As String
'
'   On Error GoTo GestErr
'
'   strRicerca = "SELECT [" & Azienda & "TAB_GEN].TGCHIAVE, [" & Azienda & "TAB_GEN].TGCODICE,  " & _
'                "       [" & Azienda & "TAB_GEN_1].TGCHIAVE, [" & Azienda & "TAB_GEN_1].TGCODICE, [" & Azienda & "TAB_GEN_1].TGVALORE AS VALORE, [" & Azienda & "TAB_GEN_1].TGTESTO3 AS ESENZIONE " & _
'                "  FROM [" & Azienda & "TAB_GEN] INNER JOIN [" & Azienda & "TAB_GEN] AS [" & Azienda & "TAB_GEN_1] ON [" & Azienda & "TAB_GEN].TGTESTO1 = [" & Azienda & "TAB_GEN_1].TGCODICE " & _
'                " WHERE ((([" & Azienda & "TAB_GEN].TGCHIAVE)='REPIVA') " & _
'                "   AND (([" & Azienda & "TAB_GEN_1].TGCHIAVE)='CODIVA')) " & _
'                "   AND (([" & Azienda & "TAB_GEN].TGCODICE)='" & VerificaApici(CodReparto) & "')) "
'   Set rs = New ADODB.Recordset
'   rs.Open strRicerca, ConnessioneGenerale, adOpenStatic
'   If Not rs.EOF Then
'      If Len(Trim(rs!ESENZIONE)) = 0 Then
'         GetValIVAPerReparto = Trim(Str(rs!Valore))
'      Else
'         Select Case rs!ESENZIONE
'            Case "N1": GetValIVAPerReparto = "IVA Esclusa"
'            Case "N2": GetValIVAPerReparto = "Non soggetta IVA"
'            Case "N3": GetValIVAPerReparto = "Non imponibile"
'            Case "N4": GetValIVAPerReparto = "IVA Esente"
'            Case "N5": GetValIVAPerReparto = "Regime del margine"
'            Case "N6": GetValIVAPerReparto = "Operazione non IVA"
'         End Select
'      End If
'   Else
'      GetValIVAPerReparto = "0"
'   End If
'End Function


Public Function fCustomWrite(pStrRiga As String, Optional vAnnulloNonNecessario As Boolean) As Boolean
   Dim vRetA As Long
   Dim pBytBuffOut(1000) As Byte
   Dim vRet As Long
   Dim vRetErr As Long
   Dim vNullRet As Long
   Dim i As Integer
   
   'Dim strOut As String
   Dim tmpOut As String
   
   Dim vDecodErr As String
   Dim vAnnullaTransazione As Boolean
   Dim vAttendiERipeti As Boolean
   Dim vTentativo As Byte
   Dim vTime As Date
   Dim vStrNull As String
   Dim vNoMsgBox As Boolean
   Dim vFineCarta As Boolean
   
   On Error GoTo GestErr
   
   
RipetiComando:
   'registro il comando nel Log
      Call MsgRegCasInLogFile("[fCustomWrite] - " & pStrRiga)
   'eseguo il comando
      vRet = VbCEFWriteCustom(pStrRiga, vRetErr)
            
   'verifoc l'esito
      If vRet = 0 Then
         fCustomWrite = True
         Exit Function
      Else
         vDecodErr = "Err. " & vRet & " - "
         Select Case vRet
            Case 3: vDecodErr = vDecodErr & "Valore non valido": vAnnullaTransazione = True
            Case 5: vDecodErr = vDecodErr & "Operazione non possibile": vAnnullaTransazione = True
            Case 7: vDecodErr = vDecodErr & "Scritta 'TOTALE' non accetta": vAnnullaTransazione = True
            Case 12: vDecodErr = vDecodErr & "Verificare la Data dell'operazione": vAnnullaTransazione = True
            Case 16: vDecodErr = vDecodErr & "Fine carta nel Registratore": vFineCarta = True ': vAnnullaTransazione = false
            Case 21: vDecodErr = vDecodErr & "Documento in corso": vAttendiERipeti = True
            Case 23: vDecodErr = vDecodErr & "Totale negativo": vAnnullaTransazione = True
            Case 24: vDecodErr = vDecodErr & "Inviato Comando con lunghezza sbagliata (troppo grande)": vAnnullaTransazione = True
            Case 25: vDecodErr = vDecodErr & "Pagamento incompleto": vAnnullaTransazione = True
            Case 29: vDecodErr = vDecodErr & "Importo Reso maggiore del Documento di origine oppure IVA negativa": vAnnullaTransazione = True  '<-- INVENTATO DA NOI (Lo abbiamo riscontrato emettendo un documento di RESO con importo > del Documento da Rendere)
            Case 54: vDecodErr = vDecodErr & "Richiesta chiusura fiscale": vAnnullaTransazione = True
            Case 62: vDecodErr = vDecodErr & "Ricezione dati in corso": vAttendiERipeti = True
            Case 64: vDecodErr = vDecodErr & "Coperchio Registratore aperto": vAnnullaTransazione = True
            
            Case 99:
               vDecodErr = vDecodErr & "Errore Generico 99": vAnnullaTransazione = True
               
               'il supporto ci ha detto che in caso di errore generico 99 deve essere richiamato il comando 1015
               'per la descrizione dell'errore custom
               vRetErr = VbCEFWriteCustom("1015", vRetErr)
               vRet = VbCEFReadCustom(pBytBuffOut(), vRetA, vRetErr)
               tmpOut = ""
               For i = 9 To vRetA - 3
                  tmpOut = tmpOut + String(1, pBytBuffOut(i))
               Next i
               
               
               'If vRetErr <> 0 Then
                  vDecodErr = vDecodErr & vbNewLine & "*** Esito chiamata 1015: " & tmpOut & " ***"
                  Call MsgRegCasInLogFile("[fCustomWrite] - Errore generico (comando 1015) - Esito 'Read': " & tmpOut, True)
               'End If
            
            Case 256
'''SOSPESO PER IL MOMENTO ... ATTENDIAMO RISPOSTA DA CUSTOM (FORSE!!)
'''               'se sto eseguendo un Annullo e l'errore si verifica sulla seconda chiamata (ultimo parametro = "1" della 7101)
'''               'lo ignoro e proseguo come se tutto sia andato a buon fine (anche perch ci siamo accorti che, di fatto, lo scontrino)
'''               'viene realemnete annullato
'''               If gtParam4RegCas.pEseguiAnnullo And vAnnulloNonNecessario Then
'''                  fCustomWrite = True
'''                  Exit Function
'''               Else
                  vDecodErr = vDecodErr & "Errore di sistema del Registratore": vAnnullaTransazione = True
'''               End If
                  If (gtParam4RegCas.pGenerazioneCustom <> "III") And (pStrRiga = Trim(Str(execChiusuraFiscale))) Then
                     vNoMsgBox = True
                  End If

            Case Else
               vDecodErr = vDecodErr & "Errore non codificato": vAnnullaTransazione = True
         End Select
         
         Call MsgRegCasInLogFile("[fCustomWrite] - " & vDecodErr, True)
      End If


   
   If vFineCarta Then
      MsgBox "LA CARTA NEL REGISTRATORE E' TERMINATA." & vbNewLine & _
              String(50, "-") & vbNewLine & _
             "SOSTITUISCI IL ROTOLO IN MODO CHE IL REGISTRATORE STAMPI LO SCONTRINO." & vbNewLine & vbNewLine & _
             "QUANDO HAI FATTO, PREMI SU <CONTINUA>", msg_Information, "ATTENZIONE!", "CONTINUA"
      
      If MsgBox("LO SCONTRINO E' STATO STAMPATO REGOLARMENTE?", msg_Question + msg_YesNo) = vbYes Then
         vRet = 0
         fCustomWrite = True
         Exit Function
      Else
         vAnnullaTransazione = True
      End If
   End If
   
   
   If vAnnullaTransazione And (vAnnulloNonNecessario = False) Then
      vStrNull = "3001"
      vStrNull = vStrNull & "8" 'annullo transazione
      vStrNull = vStrNull & "16"
      vStrNull = vStrNull & "TRANS. ANNULLATA"
      vStrNull = vStrNull & "000000000"
      
      vNullRet = VbCEFWriteCustom(vStrNull, vRetErr)
      If vNullRet = 0 Then
         Call MsgRegCasInLogFile("[fCustomWrite] - Documento annullato")
      Else
         Call MsgRegCasInLogFile("[fCustomWrite] - Tentativo di annullo - Err. " & vNullRet, True)
      End If
      
      ' Close Document
         vStrNull = "3011"
         vRet = VbCEFWriteCustom(vStrNull, vRetErr)
      
      ' Print and Cut
         vStrNull = "3013"
         vRet = VbCEFWriteCustom(vStrNull, vRetErr)
         
      If vNoMsgBox = False Then
         MsgBox "Errore in fase di scrittura sul Registratore Custom" & vbNewLine & String(50, "-") & vbNewLine & vDecodErr, msg_Critical
      End If
      Exit Function
   End If
   

GestErr:
   If err.Number <> 0 Then
      Dim vTxtErr As String
      vTxtErr = err.Number & " - " & err.Description
      Call MsgRegCasInLogFile("[fCustomWrite] - " & vTxtErr, True)
      MsgBox vTxtErr, msg_Critical
   End If
End Function


Public Function StampaVoucher_CUSTOM_RT(vTipConn As String, vApriCas As String, _
                                        vIndirIP As String, vNumPort As String, _
                                        vBaudRat As String, vBitDati As String, vParita As String, vBitStop As String, vFlusso As String, _
                                        vNomeStampante As String, pStampaValore As Boolean) As Boolean
   Dim vRet As Long
   Dim vRetErr As Long
      
   Dim vErrWrite As Boolean
   Dim tmpString As String
   Dim vStrRiga As String
   Dim NumFile As Integer 'per aprire il file che mi serve per storicizzare lo scontrino ed eventualmente ristamparlo
      
' Open Communication
   If vTipConn = "R" Then 'RETE
      vRet = VbCEFOpenEthCustom(vIndirIP, CLng(vNumPort), vRetErr)
   Else 'SERIALE
       vRet = VbCEFOpenCustom(CLng(vNumPort), CLng(vBaudRat), CByte(vParita), CByte(vBitDati), CByte(vBitStop), CByte(vFlusso), CLng(vRetErr))
   End If
      
   ' Check Init
   Call MsgRegCasInLogFile("[ScontrinoCustom_RT] - OpenConn '" & IIf(vTipConn = "R", "Rete", "Seriale") & "': " & vRet, (vRet <> 0))
   If (vRet <> 0) Then
      MsgBox "ATTENZIONE!" & vbNewLine & _
             "Errore di Comunicazione", (vbOKOnly + vbCritical)
      Exit Function
   End If

   'qui apri il file che creo comunque per la storicizzazione dello scontrino e l'eventuale ristampa
   NumFile = FreeFile
   'Open App.path & "\temp.txt" For Append As #NumFile      'CREO IL FILE
   Dim vNomeFileStorico As String
   vNomeFileStorico = Replace(Format(Date, "yyyy-mm-dd") & "_" & Format(Now, "hh.nn.ss"), ":", ".") & ".txt"
   Open PathREGCAS & "\Storico\" & vNomeFileStorico For Append As #NumFile      'CREO IL FILE
   'vFileAperto = True


   vStrRiga = "40014"  'Apertura documento 4001 di tipo 'Documento di cortesia' valore 4 (4001+4)
   If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
      Print #NumFile, vStrRiga 'Stampo la stringa nel File
   
   vStrRiga = "4002"  'Stampa intestazione 4002 identica a quella dello scontrino
   If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
      Print #NumFile, vStrRiga 'Stampo la stringa nel File

   
      
'      vStrRiga = "40034"  'RIGA VUOTA   <----- NON FUNZIONA!!!
'      tmpString = "  "
'      vStrRiga = vStrRiga & Len(tmpString)
'      vStrRiga = vStrRiga & tmpString
'      If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
'         Print #NumFile, vStrRiga 'Stampo la stringa nel File
      
      
         vStrRiga = "40034"  'Stampa riga descrittiva non fiscale 4003 + 4 (doppia altezza)
         tmpString = " - VOUCHER CARD - "
         vStrRiga = vStrRiga & Len(tmpString)
         vStrRiga = vStrRiga & tmpString
         If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
            Print #NumFile, vStrRiga 'Stampo la stringa nel File
      
      
'         vStrRiga = "40034"  'Stampa riga descrittiva non fiscale 4003 + 4 (doppia altezza)
'         tmpString = "Riferimento"
'         vStrRiga = vStrRiga & Len(tmpString)
'         vStrRiga = vStrRiga & tmpString
'         If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
'            Print #NumFile, vStrRiga 'Stampo la stringa nel File
            
         vStrRiga = "40034"  'Stampa riga descrittiva non fiscale 4003 + 4 (doppia altezza)
         tmpString = "Codice: " & gtParam4RegCas.pVoucherID & ""
         vStrRiga = vStrRiga & Len(tmpString)
         vStrRiga = vStrRiga & tmpString
         If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
            Print #NumFile, vStrRiga 'Stampo la stringa nel File
      
      
'         vStrRiga = "40034"  'Stampa riga descrittiva non fiscale 4003 + 4 (doppia altezza)
'         tmpString = "Descrizione"
'         vStrRiga = vStrRiga & Len(tmpString)
'         vStrRiga = vStrRiga & tmpString
'         If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
'            Print #NumFile, vStrRiga 'Stampo la stringa nel File
            
         vStrRiga = "40034"  'Stampa riga descrittiva non fiscale 4003 + 4 (doppia altezza)
         tmpString = "" & PulisciDescrizioneScontrino(gtParam4RegCas.pVoucherDescr) & ""
         vStrRiga = vStrRiga & Len(tmpString)
         vStrRiga = vStrRiga & tmpString
         If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
            Print #NumFile, vStrRiga 'Stampo la stringa nel File
      
   
'         vStrRiga = "40034"  'Stampa riga descrittiva non fiscale 4003 + 4 (doppia altezza)
'         tmpString = "Valore"
'         vStrRiga = vStrRiga & Len(tmpString)
'         vStrRiga = vStrRiga & tmpString
'         If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
'            Print #NumFile, vStrRiga 'Stampo la stringa nel File
            
         If pStampaValore Then
            
            vStrRiga = "40034"  'Stampa riga descrittiva non fiscale 4003 + 4 (doppia altezza)
            tmpString = "Valore: " & Format(gtParam4RegCas.pVoucherValue, "#####0.#0") & ""
            vStrRiga = vStrRiga & Len(tmpString)
            vStrRiga = vStrRiga & tmpString
            If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
               Print #NumFile, vStrRiga 'Stampo la stringa nel File
   
         End If
   

'      vStrRiga = "40034"  'RIGA VUOTA   <----- NON FUNZIONA!!!
'      tmpString = "  "
'      vStrRiga = vStrRiga & Len(tmpString)
'      vStrRiga = vStrRiga & tmpString
'      If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
'         Print #NumFile, vStrRiga 'Stampo la stringa nel File
   
   
'      'SPAZIO --------------
'         tmpString = "  "
'         vStrRiga = vStrRiga & Len(tmpString)
'         vStrRiga = vStrRiga & tmpString
'         Print #NumFile, vStrRiga 'Stampo la stringa nel File
   
'            'VALORE DEL VOUCHER
'               vStrRiga = "40034"  'Stampa riga descrittiva non fiscale 4003 + 4 (doppia altezza)
'               tmpString = " del valore di"
'               vStrRiga = vStrRiga & Len(tmpString)
'               vStrRiga = vStrRiga & tmpString
'               If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
'                  Print #NumFile, vStrRiga 'Stampo la stringa nel File
'
'               vStrRiga = "40034"  'Stampa riga descrittiva non fiscale 4003 + 4 (doppia altezza)
'               tmpString = "       " & Format(gtParam4RegCas.pVoucherValue, "#####0.#0") & " euro"
'               vStrRiga = vStrRiga & Len(tmpString)
'               vStrRiga = vStrRiga & tmpString
'               If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
'                  Print #NumFile, vStrRiga 'Stampo la stringa nel File

'      'SPAZIO --------------
'      tmpString = "  "
'      vStrRiga = vStrRiga & Len(tmpString)
'      vStrRiga = vStrRiga & tmpString
'      If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
'         Print #NumFile, vStrRiga 'Stampo la stringa nel File

   
   ' Close Document
      vStrRiga = "4004"
      If Not fCustomWrite(vStrRiga) Then vErrWrite = True: GoTo ChiusuraForzata
         Print #NumFile, vStrRiga 'Stampo la stringa nel File
            
            
ChiusuraForzata:
   'Chiudo il file
   Close #NumFile
                  
'Close Communication on Com Port
      vRet = VbCEFClose(vRetErr)
      Call MsgRegCasInLogFile("[VoucherCustom_RT] - CloseConn '" & IIf(vTipConn = "R", "Rete", "Seriale") & "': " & vRet, (vRet <> 0))
   
   
   If vErrWrite Then
      Exit Function
   End If
   
   
   StampaVoucher_CUSTOM_RT = True
   
End Function

Private Function DecodErrorCustom(vCodice As Long) As String
   Select Case vCodice
      Case 45: DecodErrorCustom = "IMPOSSIBILE STABILIRE UNA COMUNICAZIONE ETHERNET: E' GIA' APERTA UNA COMUNICAZIONE SERIALE"
      Case 47: DecodErrorCustom = "COMUNICAZIONE ETHERNET GIA' STABILITA"
      Case 256: DecodErrorCustom = "ERRORE DI SISTEMA"
      Case 65536: DecodErrorCustom = "COMANDO SCONOSCIUTO"
      Case 65537, 65538: DecodErrorCustom = "ERRORE NELL'APERTURA DELL'OGGETTO RICHIESTO"
      Case 65540: DecodErrorCustom = "DATO CORROTTO"
      Case 65541: DecodErrorCustom = "ERRORE NEL COMANDO DELLA FUNZIONE ESPORTATA"
      Case 65542: DecodErrorCustom = "PROTOCOLLO NON CORRETTO"
      Case 65543: DecodErrorCustom = "ERRORE DI COMUNICAZIONE" & vbNewLine & _
                                     "Eseguire le seguenti verifiche sulla stampante:" & vbNewLine & _
                                     " - accertarsi che sia accesa" & vbNewLine & _
                                     " - accertarsi che sia collegata alla rete interna" & vbNewLine & _
                                     " - verificare indirizzo 'IP'" & vbNewLine & _
                                     " - verificare che il protocollo sia 'CUSTOM'" & vbNewLine & _
                                     " - verificare sia in stato 'FPU' (se previsto)"
      Case 65547: DecodErrorCustom = "STAMPANTE BLOCCATA. SI CONSIGLIA DI SPEGNERLA E RIACCENDERLA OPPURE RIAVVIARE 'PRIMO'"
   End Select
End Function
